/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.Num;
import nts.command.Command;
import nts.command.Token;
import nts.io.Log;
import nts.math.MathPrim;

class MathGiven
extends Command
implements Num.Provider {
    private int code;
    private String name;

    public void exec(Token src) {
        MathPrim.handleMathCode(this.code, src);
    }

    public boolean hasMathCodeValue() {
        return true;
    }

    public int getMathCodeValue() {
        return this.code;
    }

    public boolean sameAs(Command cmd) {
        return cmd instanceof MathGiven && this.code == ((MathGiven)cmd).code;
    }

    public void addOn(Log log) {
        log.addEsc(this.name).add('\"').add(Integer.toHexString(this.code).toUpperCase());
    }

    public boolean hasNumValue() {
        return true;
    }

    public Num getNumValue() {
        return Num.valueOf(this.code);
    }

    public final String toString() {
        return "[mathchar given: " + this.code + "]";
    }

    public MathGiven(int code, String name) {
        this.code = code;
        this.name = name;
    }
}

