/*
 * Decompiled with CFR 0.152.
 */
package nts.hyph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import nts.hyph.WordMap;

public class WordTrie
implements WordMap {
    public static final WordTrie NULL;
    public static final Entry NULL_ENTRY;
    private static final Entry[] EMPTY_TABLE;
    public static final WordTrie EMPTY;
    private Entry[] table;
    private char maxCode;

    public Object get(String word) {
        int size = word.length();
        int curr = 0;
        int i = 0;
        while (i < size) {
            char code = word.charAt(i);
            curr = this.table[curr].link;
            if (curr == 0) {
                return null;
            }
            if ((curr += code) <= 0 || curr >= this.table.length) {
                return null;
            }
            Entry ent = this.table[curr];
            if (ent == null || ent.code != code) {
                return null;
            }
            ++i;
        }
        return this.table[curr].value;
    }

    public Object put(String word, Object value) {
        throw new UnsupportedOperationException("packed");
    }

    public WordMap.Seeker seeker() {
        WordTrie wordTrie = this;
        if (wordTrie == null) {
            throw null;
        }
        return wordTrie.new Seeker();
    }

    public Enumeration entries() {
        WordTrie wordTrie = this;
        if (wordTrie == null) {
            throw null;
        }
        return wordTrie.new Enum();
    }

    public WordMap packed() {
        return this;
    }

    public WordTrie(Entry[] table, char maxCode) {
        this.table = table;
        this.maxCode = maxCode;
    }

    static {
        EMPTY_TABLE = new Entry[]{new Entry('\u0000', 0, null)};
        EMPTY = new WordTrie(EMPTY_TABLE, '\u0000');
    }

    static class Entry
    implements Serializable {
        final char code;
        final int link;
        Object value;

        public Entry(char code, int link, Object value) {
            this.code = code;
            this.link = link;
            this.value = value;
        }
    }

    public class Seeker
    implements WordMap.Seeker {
        private int curr = 0;

        public void reset() {
            this.curr = 0;
        }

        public boolean isValid() {
            return this.curr >= 0;
        }

        public void seek(char code) {
            if (this.curr >= 0) {
                this.curr = ((WordTrie)WordTrie.this).table[this.curr].link;
                if (this.curr != 0) {
                    Entry ent;
                    this.curr += code;
                    if (this.curr > 0 && this.curr < WordTrie.this.table.length && (ent = WordTrie.this.table[this.curr]) != null && ent.code == code) {
                        return;
                    }
                }
                this.curr = -1;
            }
        }

        public Object get() {
            return this.curr > 0 ? ((WordTrie)WordTrie.this).table[this.curr].value : null;
        }
    }

    private class Level {
        int link;
        int curr;

        Level(int link, int curr) {
            this.link = link;
            this.curr = curr;
        }
    }

    private class Enum
    implements Enumeration {
        private Stack stack = new Stack();
        private int link;
        private int curr;

        private int next(int i) {
            int k = Math.min(WordTrie.this.table.length, this.link + WordTrie.this.maxCode + 1);
            while (i < k) {
                Entry ent = WordTrie.this.table[i];
                if (ent != null && ent.code == i - this.link) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        private void step() {
            int l = ((WordTrie)WordTrie.this).table[this.curr].link;
            if (l != 0) {
                WordTrie wordTrie = WordTrie.this;
                if (wordTrie == null) {
                    throw null;
                }
                this.stack.push(wordTrie.new Level(this.link, this.curr));
                this.link = l;
                this.curr = Math.max(this.link, 1);
            } else {
                ++this.curr;
            }
            while (true) {
                this.curr = this.next(this.curr);
                if (this.curr != 0) {
                    return;
                }
                if (this.stack.empty()) {
                    this.link = 0;
                    this.curr = 0;
                    return;
                }
                Level top = (Level)this.stack.pop();
                this.curr = top.curr + 1;
                this.link = top.link;
            }
        }

        public boolean hasMoreElements() {
            return this.curr != 0;
        }

        public Object nextElement() {
            if (this.curr == 0) {
                throw new NoSuchElementException("WordTrie is finished");
            }
            Enum enum_ = this;
            if (enum_ == null) {
                throw null;
            }
            Map.Entry mapEnt = new Map.Entry(enum_){
                private Entry ent;
                private String key;
                private final /* synthetic */ Enum this$0;
                private final /* synthetic */ WordTrie this$1;

                private String makeKey() {
                    char[] codes = new char[Enum.access$2(this.this$0).size() + 1];
                    int i = 0;
                    while (i < Enum.access$2(this.this$0).size()) {
                        Level lev = (Level)Enum.access$2(this.this$0).get(i);
                        codes[i] = WordTrie.access$0((WordTrie)this.this$1)[lev.curr].code;
                        ++i;
                    }
                    codes[i] = WordTrie.access$0((WordTrie)this.this$1)[Enum.access$1((Enum)this.this$0)].code;
                    return new String(codes);
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return this.ent.value;
                }

                public Object setValue(Object value) {
                    Object old = this.ent.value;
                    this.ent.value = value;
                    return old;
                }
                {
                    this.this$0 = this$0;
                    this.this$1 = Enum.access$0(this.this$0);
                    this.ent = WordTrie.access$0(this.this$1)[Enum.access$1(this.this$0)];
                    this.key = this.makeKey();
                    this.constructor$0(this$0);
                }

                private final void constructor$0(Enum enum_) {
                }
            };
            this.step();
            return mapEnt;
        }

        static /* synthetic */ WordTrie access$0(Enum enum_) {
            return enum_.WordTrie.this;
        }

        static /* synthetic */ int access$1(Enum enum_) {
            return enum_.curr;
        }

        static /* synthetic */ Stack access$2(Enum enum_) {
            return enum_.stack;
        }

        Enum() {
            this.link = ((WordTrie)WordTrie.this).table[0].link;
            this.curr = this.link != 0 ? this.next(Math.max(this.link, 1)) : 0;
        }
    }
}

