/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.AssignPrim;
import nts.command.CommandBase;
import nts.command.Token;

public class InteractionPrim
extends AssignPrim {
    public static final int BATCH = 0;
    public static final int NONSTOP = 1;
    public static final int SCROLL = 2;
    public static final int ERROR_STOP = 3;
    public static final String[] names = new String[]{"batchmode", "nonstopmode", "scrollmode", "errorstopmode"};
    private static int value = 3;
    private int mode;

    public static int get() {
        return value;
    }

    public static boolean isSilent() {
        return value == 0;
    }

    public static boolean isInteractive() {
        return value > 1;
    }

    public static boolean isErrStopping() {
        return value == 3;
    }

    public static void setScroll() {
        if (value > 2) {
            value = 2;
        }
    }

    public static void set(int val) {
        value = val;
        CommandBase.setTermEnable(value != 0);
    }

    public static void set(String mnem) {
        int i = 0;
        while (i < names.length) {
            if (mnem.equals(names[i])) {
                InteractionPrim.set(i);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Invalid interaction: " + mnem);
    }

    protected void assign(Token src, boolean glob) {
        CommandBase.normLog.endLine();
        InteractionPrim.set(this.mode);
    }

    public InteractionPrim(String name, int mode) {
        super(name);
        this.mode = mode;
    }

    static {
        String prop = System.getProperty("nts.interaction");
        if (prop != null) {
            InteractionPrim.set(prop);
        } else {
            InteractionPrim.set(3);
        }
    }
}

