#include <sys/emx.h>
#include <errno.h>
#include <sys/string.h>

extern unsigned short WinExec(char *, unsigned);

#define MAX_EXEC_CHARS 120

int __spawnve (struct _new_proc *np)
{
    int i, ret, len, sum;
    char buf[ MAX_EXEC_CHARS + 8];
    char *src, *dst;

    len = sum = strlen((const char *)np->fname_off);

    /* only 120 chars allowed (Win 3.1) */
    if (sum >= MAX_EXEC_CHARS) {
	errno = E2BIG;
	return -1;
    }

    strcpy(buf, (const char *)np->fname_off);

    src = (char *) np->arg_off;
    dst = buf + len;

    /* skip arg0 */
    ++src;
    src += strlen (src) + 1;

    for (i = 1; i <= np->arg_count; i++) {
	++src;		/* flag byte */
	*dst++ = ' ';
	len = strlen (src) + 1;
	sum += len;
	if (sum >= MAX_EXEC_CHARS) {
	    errno = E2BIG;
	    return -1;
	}
	memcpy(dst, src, len);
	src += len;
	dst += len;
    }

    ret = WinExec(buf, 1);

    if (ret <= 32) {
	errno = EINVAL;     /* should fixed */
	return -1;
    }
    else
	return 0;
}
