/*
** StartDVIprint.rexx
**
** This is a small hack to run DVIprint through ARexx, so as it may be
** called from ShowDVI or other programs.
**
** INPUTS: Same as to DVIprint, but use long option names. The last argument
** must be the name of an existing file.
*/
If ~Show('Libraries','rexxsupport.library') Then Do
  If ~AddLib('rexxsupport.library',0,-30) Then Do
    Say "Sorry, RexxSupport.library required"
    Exit 20 /* for statef() function */
  End
End

/*
** Provides StringReq("Title","initial string",StringBufSize,VisibleSize)
*/
If ~Show('Libraries','req.library') Then
  If ~AddLib('req.library',-5,-60,2) Then Do
    Say "Can't open 'req.library'!"
    Exit 20
End
/*
** ReqLib is less than ideal for what I want to do ...
*/

/*
** OPTIONS RESULTS
**
** This is commented out
*/

/*
** Keep it as simple as possible, e.g., the arguments allowed are
** passed through to DVIprint.
*/

Parse Arg ARGUMENTS

NUMARGS = Words(ARGUMENTS)

/*
** Last arg must be the FileName ...
*/
If Word(StateF(Word(ARGUMENTS,NUMARGS)),1) ~= "FILE" Then Do
  NAME = StringReq(".dvi filename",,127,40)
  If NAME ~= "" Then
     ARGUMENTS = ARGUMENTS NAME
  Else
     Exit
End

/*
** Look for 'FROM' KeyWord
*/
REQN = Para("from",ARGUMENTS)
If 0 = REQN Then Do
  REQN = IntReq("print from page ?", -100000, +100000)
  If REQN ~= "" Then
    ARGUMENTS = ARGUMENTS" from "REQN
End

/*
** Look for 'TO' KeyWord
*/
REQN = Para("to",ARGUMENTS)
If 0 = REQN Then Do
  REQN = IntReq("print upto page ?", -100000, +100000)
  If REQN ~= "" Then
    ARGUMENTS = ARGUMENTS" to "REQN
End

Say "executing: DVIprint "ARGUMENTS

Address COMMAND DVIPrint ARGUMENTS

Exit

/*
** See if specific parameter was given
*/
Para: Procedure Expose NUMARGS

/*
** All switched to uppercase
*/
Arg NAME, PARAMETERS

FOUNDAT = 0
Do I = 1 For NUMARGS
  If Word(PARAMETERS,I) = NAME Then Do
    FOUNDAT = I
    Leave
  End
End

Return FOUNDAT
