/* This ARexx program was automatically created by NUWEB from
   the master source file `callmf.w'.  Do not edit by hand! */
Signal On BREAK_C
Signal On BREAK_D
Pragma( "Priority", -5 )
Address COMMAND
UnSetEnv "LAST_FONT_CREATED"

PARENTDIR = MyGetEnv( "SELFAUTOPARENT" )
If "" = PARENTDIR Then Do
  Address COMMAND "kpsewhich --help > NIL:"
    /* Dummy command that sets \texttt{SELFAUTO} */
  PARENTDIR = MyGetEnv( "SELFAUTOPARENT" )
End

FONTSDIR = PARENTDIR || "/texmf/fonts"

SOURCEDIR = FONTSDIR || "/source"
GFDIR     = FONTSDIR || "/gf"
PKDIR     = FONTSDIR || "/pk"
TFMDIR    = FONTSDIR || "/tfm"
LOGDIR    = FONTSDIR || "/log"
AFMDIR    = FONTSDIR || "/afm"
TYPE1DIR  = FONTSDIR || "/type1"

DVIPSDIR  = PARENTDIR || "/texmf/dvips"

/* PSMAPFILENAME = DVIPSDIR || "/ps2pk.map" */
PSMAPFILENAME = "gsftopk.map" /*  faire : variable d'environnement */

FONTFILENAME = PARENTDIR || "/texmf/web2c/fontvols"

MASTERLOG = LOGDIR || "/MakeTeXFont.log"

VIRMF = GetClip( "VIRMF" )
If "" = VIRMF Then
  VIRMF = "MF"
GFTOPK = GetClip( "GFTOPK" )
If "" = GFTOPK Then
  GFTOPK = "GFtoPK"
PS2PK = GetClip( "PS2PK" )
If "" = PS2PK Then
  PS2PK = "PS2PK"
GSFTOPK = GetClip( "GSFTOPK" )
If "" = GSFTOPK Then
  GSFTOPK = "GSFTOPK"
T1CONVPRG = MyGetEnv( "T1CONVPRG" )
If "" = T1CONVPRG Then
  T1CONVPRG = "PS2PK"

NORMALBASE = MyGetEnv( "MFBASE" )
If "" = NORMALBASE Then
  NORMALBASE = "mf"

CMBASE = "cmbase"
EXBASE = "exbase"

KEEPGFFILES = 0


DUMMY = Time( "Reset" )
Parse Arg FONTNAME DPI HBASE VBASE DRIVER PKFILEARG PKDIRARG .

KPSEWHICH = "kpsewhich -dpi=" || HBASE
KPSEWHICH = KPSEWHICH "-mode=" || MyGetEnv( "MAKETEX_MODE" )

/* Select
  When SubStr( FONTNAME, 1, 2 ) = "ec" Then BASE = EXBASE
  When SubStr( FONTNAME, 1, 2 ) = "cm" Then BASE = CMBASE
Otherwise */
  BASE = NORMALBASE
/* End */


LOGSTRING = "Making font" FONTNAME "at" DPI "dpi and base"
LOGSTRING = LOGSTRING "(" || HBASE || "," VBASE || ")"
Say LOGSTRING

CURGFFILENAME  = FONTNAME || "." || DPI || "gf"
CURPKFILENAME  = FONTNAME || ".pk"
OLDPKFILENAME  = FONTNAME || "." || DPI || "pk"
CURLOGFILENAME = FONTNAME || ".log"
CURTFMFILENAME = FONTNAME || ".tfm"

LOGFILENAME = FONTNAME || ".log"
Call SafeMakeDir( LOGDIR )
Call SafeMakeFile( MASTERLOG )
Call SafeMakeDir( PKDIR )
Call SafeMakeDir( TFMDIR )

If 0 ~= KEEPGFFILES Then
  Call SafeMakeDir( GFDIR )

MODE = Left( PKDIRARG, LastPos( "/", PKDIRARG ) - 1 )
MODE = SubStr( MODE, LastPos( "/", MODE ) + 1 )

CARETFM = 1
CAREGF = 1
DELETECURPK = 1

FONTPKOK = 0
If Open( "fontfile", fontfilename, "read" ) Then Do
  Do Until EOF( "fontfile" )
    LINE = ReadLn( "fontfile" )
    If 0 > Pos( ";", line ) Then
      LINE = Left( LINE, Pos( ";", LINE ) - 1 )
    Parse Var LINE DISK || "=" || DDD || "d." || LINE
    If DDD = HBASE Then
      Do Until LINE = ""
        Parse Var LINE DIR || "." || LINE
        If DIR = DPI Then Do
          If Exists( DISK || ":" || DPI || "/" || OLDPKFILENAME ) Then Do
            CURPKFILENAME = DISK || ":" || DPI || "/" || OLDPKFILENAME
            DELETECURPK = 0
            CARETFM = 0
            CAREGF = 0
            
            "Echo >" CURLOGFILENAME "PK file copied from" CURPKFILENAME
            "Date >>" CURLOGFILENAME
            "setenv KPSERESULT `" || KPSEWHICH || " " || FONTNAME || ".mf`"
            
            SUPPLIER = SubStr( MyGetEnv( "KPSERESULT" ), Length( SOURCEDIR ) + 1 )
            SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
            
            TYPEFACE = SubStr( SUPPLIER, LastPos( "/", SUPPLIER ) )
            SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
            
            FONTPKOK = 1
            Say "PK file copied from" CURPKFILENAME
          End
        End
      End
    
  End
  If ~Close( "fontfile" ) Then
    Say "Can't close file" FONTFILENAME || "!"
End

If 0 = FONTPKOK Then Do
  If "GSFTOPK" = T1CONVPRG Then Do
      Say "Trying to create pk with:"
      Say GSFTOPK ">gsftopk.log --dosnames --mapfile" PSMAPFILENAME FONTNAME DPI
      SAVEMTBD = MyGetEnv( "MAKETEX_BASE_DPI" )
      SAVEMTM = MyGetEnv( "MAKETEX_MODE" )
      GSFTOPK ">gsftopk.log --dosnames --mapfile" PSMAPFILENAME FONTNAME DPI
      Call MySetEnv( "MAKETEX_BASE_DPI", SAVEMTBD )
      Call MySetEnv( "MAKETEX_MODE", SAVEMTM )
      If 0 = RC Then Do
        G2PTFM   = MyGetEnv( "GSFTOPKTFM" )
        If "" ~= G2PTFM Then Do
          SUPPLIER = Substr( G2PTFM, Length( TFMDIR ) + 1 )
          SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
          TYPEFACE = Substr( SUPPLIER, LastPos( "/", SUPPLIER ) )
          SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
          DELETECURPK = 1
          CARETFM = 0
          CAREGF = 0
          FONTPKOK = 1
          MODE = "modeless"
          "rename gsftopk.log" FONTNAME || ".log"
        End; Else
          Say "No valid pk generated by gsftopk"
      End; Else
        Say "Hmm gsftopk did not generate anything, may be not a type1 font..."
      
  End; Else Do
      If Open( "mapfile", DVIPSDIR || "/" || PSMAPFILENAME ) Then Do
        Do Until Eof( "mapfile" )
          LINE = Trim( Readln( "mapfile" ) )
          C = Left( LINE, 1 )
          If ~ ( " " = C | "*" = C | ";" = C | "#" = C ) Then Do
            Parse Var LINE MFNAME " " LINE
            If FONTNAME = MFNAME Then Leave
          End
        End
        
        If FONTNAME = MFNAME Then Do
          If 0 ~= Pos( '"', LINE) Then
            Parse Var LINE '"' QUOTED '"' LINE
          
          Parse Var LINE "<" PSFONTENC " " LINE
          Parse Var LINE "<" PSNAME " " LINE
          
          If "" = PSNAME Then Do
            PSNAME = PSFONTENC
            PSFONTENC = ""
          End
          
          SLANT = ""
          EXTEND = ""
          ENCODING = ""
          
          If "" ~= QUOTED Then Do
            If 0 ~= Pos( "SlantFont", QUOTED ) Then Do
              Parse Var QUOTED TMPSTR " SlantFont"
              SLANT = "-S" || Word( TMPSTR, Words( TMPSTR ) )
            End
            If 0 ~= Pos( "ExtendFont", quoted ) Then Do
              Parse Var QUOTED TMPSTR " ExtendFont"
              EXTEND = "-E" || Word( TMPSTR, Words( TMPSTR ) )
            End
          End
          
          PSNAME = Strip( PSNAME )
          PSFONTENC = Strip( PSFONTENC )
          
          If "" = PSNAME Then
            MFNAME = ""
        End; Else
          MFNAME = ""
        
        If "" ~= MFNAME Then Do
          "unsetenv T1INPUTS"
          "setenv TYPE1SRCFILE `" || KPSEWHICH PSNAME || "`"
          If 0 = RC Then Do
            AFMNAME = Substr( PSNAME, 1, Pos( ".", PSNAME ) - 1 ) || ".afm"
          
            "Echo >" CURLOGFILENAME "PK file created from" PSNAME
            "Date >>" CURLOGFILENAME
            KPSEWHICH ">NIL:" PSNAME
            If 0 ~= RC Then Do
              PSNAME = ""
            End
          End; Else Do
            Say "Can't find" PSNAME
            PSNAME = ""
          End
          
          If "" ~= PSNAME Then Do
            TYPE1SRCFILE = MyGetEnv( TYPE1SRCFILE )
            SUPPLIER = Substr( TYPE1SRCFILE, Length( TYPE1DIR ) + 1 )
            SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
            
            TYPEFACE = Substr( SUPPLIER, LastPos( "/", SUPPLIER ) )
            SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
            
            T1INPUTSSTRING = TYPE1DIR || SUPPLIER || TYPEFACE
            T1INPUTSSTRING = T1INPUTSSTRING || ","
            T1INPUTSSTRING = T1INPUTSSTRING || AFMDIR || SUPPLIER || TYPEFACE
            T1INPUTSSTRING = T1INPUTSSTRING || ","
            T1INPUTSSTRING = T1INPUTSSTRING || DVIPSDIR
            
            "Setenv T1INPUTS" T1INPUTSSTRING
            
            If "" ~= PSFONTENC Then
              ENCODING = "-e" PSFONTENC
            
            PSSIZE = 10.0 * DPI / HBASE
            
            OPTIONS = ">>" CURLOGFILENAME "-v" ENCODING
            OPTIONS = OPTIONS "-P" || PSSIZE EXTEND SLANT
            OPTIONS = OPTIONS "-X" || HBASE "-Y" || VBASE
            OPTIONS = OPTIONS PSNAME CURPKFILENAME
            
            Say "Generating PK file from PostScript font with options"
            Say "  " OPTIONS
            
            PS2PK OPTIONS
            
            If 0 = RC Then Do
              DELETECURPK = 1
              CARETFM = 0
              CAREGF = 0
              FONTPKOK = 1
              MODE = "modeless"
            End
            
            "Unsetenv T1INPUTS"
          End
        End
        Call Close( "mapfile" );
      End
      
  End
  
  If 0 = FONTPKOK Then Do
    MFOPTIONS = "\mode=" || MODE || ";"
    MFOPTIONS = MFOPTIONS "mag=" || DPI || "/" || HBASE || ";"
    MFOPTIONS = MFOPTIONS "scrollmode;"
    MFOPTIONS = MFOPTIONS "input" FONTNAME
    
    Say "Calling MetaFont with base: &" || BASE "and startup commands:"
    Say "`" || MFOPTIONS || "'"
    
    If ~Exists( CURGFFILENAME ) Then
      VIRMF "&" || BASE '"' || MFOPTIONS || '"'
    Else RC = 0 /* Simulate a perfect result */
    
    ERRORCODE = RC
    
    If 5 >= ERRORCODE Then Do
      If 0 < ERRORCODE Then
        Call Error /* and fall through! */
      Else
        Say FONTNAME "translated without errors."
    End; Else Do
      Call Error
      Exit 10
    End
    
    
    If "nullmode" ~= MODE Then Do
      SAVEMTBD = MyGetEnv( "MAKETEX_BASE_DPI" )
      SAVEMTM = MyGetEnv( "MAKETEX_MODE" )
      GFTOPK CURGFFILENAME CURPKFILENAME
      Call MySetEnv( "MAKETEX_BASE_DPI", SAVEMTBD )
      Call MySetEnv( "MAKETEX_MODE", SAVEMTM )
      If Exists( CURPKFILENAME ) Then Do
        If 0 = KEEPGFFILES Then
          Delete CURGFFILENAME
        FILENOTESTRING = '"mode=' || MODE || ","
        FILENOTESTRING = FILENOTESTRING "mag=" || DPI || "/" || HBASE || '"'
        FileNote CURPKFILENAME FILENOTESTRING
      End; Else Do
        Call Log( "Where is my" CURPKFILENAME || "?" )
        Exit 5
      End
      
    End
    
    If ~Open( LOGFILE, CURLOGFILENAME, "Read" ) Then Do
      Call Log( "Can't open" CURLOGFILENAME || "!" )
      Exit 10
    End
    
    LINE = ReadLn( LOGFILE ) /* Dummy read the first intro line */
    LINE = ReadLn( LOGFILE ) /* Dummy read the second calling line */
    LINE = ReadLn( LOGFILE ) /* Read the third line for real */
    
    SOURCEFILE = Word( LINE, 1 ) /* The `driver' file is what we want */
    
    If ~Close( LOGFILE ) Then Do
      Call Log( "Can't close" CURLOGFILENAME || "!" )
      Exit 10
    End
    
    SUPPLIER = SubStr( SOURCEFILE, Length( SOURCEDIR ) + 2 )
    /* `+1' for the open brace and `+1' for the leftmost slash */
    SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
    
    TYPEFACE = SubStr( SUPPLIER, LastPos( "/", SUPPLIER ) )
    SUPPLIER = Left( SUPPLIER, LastPos( "/", SUPPLIER ) - 1 )
    
  End
End

LOGDIR = LOGDIR || "/" || MODE
Call SafeMakeDir( LOGDIR )

LOGDIR = LOGDIR || SUPPLIER
Call SafeMakeDir( LOGDIR )

LOGDIR = LOGDIR || TYPEFACE
Call SafeMakeDir( LOGDIR )

LOGDIR = LOGDIR || "/dpi" || DPI
Call SafeMakeDir( LOGDIR )

LOGFILENAME = LOGDIR || "/" || LOGFILENAME

Copy CURLOGFILENAME LOGFILENAME clone
Delete CURLOGFILENAME


If 1 = CARETFM Then
  Do
    TFMDIR = TFMDIR || SUPPLIER
    Call SafeMakeDir( TFMDIR )
    
    TFMDIR = TFMDIR || TYPEFACE
    Call SafeMakeDir( TFMDIR )
    
    TFMFILENAME = TFMDIR || "/" || CURTFMFILENAME
    
    If ~Exists( TFMFILENAME ) Then Do
      Copy CURTFMFILENAME TFMFILENAME clone
      Protect TFMFILENAME r
    End
    
    Delete CURTFMFILENAME
    
  End
  
If "nullmode" ~= MODE Then Do
  PKDIR = PKDIR || "/" || MODE
  Call SafeMakeDir( PKDIR )
  
  PKDIR = PKDIR || SUPPLIER
  Call SafeMakeDir( PKDIR )
  
  PKDIR = PKDIR || TYPEFACE
  Call SafeMakeDir( PKDIR )
  
  PKDIR = PKDIR || "/dpi" || DPI
  Call SafeMakedir( PKDIR )
  
  PKFILENAME = PKDIR || "/" || FONTNAME || ".pk"
  
  If Exists( PKFILENAME ) Then Do
    LOGSTRING = PKFILENAME
    LOGSTRING = LOGSTRING "already exists;" '0A'X
    LOGSTRING = LOGSTRING "check your driver's configuration!"
    Say LOGSTRING
    Call Log( LOGSTRING )
    If 1 = DELETECURPK Then
      Delete CURPKFILENAME
    Exit 5
  End
  
  Copy CURPKFILENAME PKFILENAME clone
  If 1 = DELETECURPK Then
    Delete CURPKFILENAME
  Protect PKFILENAME r
  
  
  If 1 = CAREGF Then
    If 0 ~= KEEPGFFILES Then Do
      GFDIR = GFDIR || "/" || MODE
      Call SafeMakeDir( GFDIR )
      
      GFDIR = GFDIR || SUPPLIER
      Call SafeMakeDir( GFDIR )
      
      GFDIR = GFDIR || TYPEFACE
      Call SafeMakeDir( GFDIR )
      
      GFDIR = GFDIR || "/dpi" || DPI
      Call SafeMakedir( GFDIR )
      
      GFFILENAME = GFDIR || "/" || CURGFFILENAME
      
      If Exists( GFFILENAME ) Then Do
        LOGSTRING = GFFILENAME
        LOGSTRING = LOGSTRING "already exists;" '0A'X
        LOGSTRING = LOGSTRING "check your driver's configuration!"
        Say LOGSTRING
        Call Log( LOGSTRING )
        Delete CURGFFILENAME
        Exit 5
      End
      
      Copy CURGFFILENAME GFFILENAME clone
      Delete CURGFFILENAME
      Protect GFFILENAME r
      
    End
    
End


ELAPSED = Time( "Elapsed" )
LOGSTRING = "created in" ELAPSED % 3600
LOGSTRING = LOGSTRING || ":" || Right( ELAPSED % 60 // 60, 2, "0" )
LOGSTRING = LOGSTRING || ":" || Right( ELAPSED % 1 // 60, 2, "0" )
Call Log( LOGSTRING )
If "nullmode" = MODE Then
  Call MySetEnv( "LAST_FONT_CREATED", TFMFILENAME )
Else
  Call MySetEnv( "LAST_FONT_CREATED", PKFILENAME )
Exit 0 /* This is the end */

BREAK_C:
BREAK_D:
  Call Log( "Execution aborted!" )

  If Exists( CURGFFILENAME ) Then
    Delete CURGFFILENAME
  If Exists( CURLOGFILENAME ) Then
    Delete CURLOGFILENAME

  Exit 10
Log: Procedure Expose MASTERLOG FONTNAME MODE HBASE VBASE DPI
Parse Arg MSG

MESSAGE = Date() Time() || ":"
MESSAGE = MESSAGE FONTNAME "for" MODE
MESSAGE = MESSAGE "(" || HBASE || "," || VBASE || ") with" DPI "dpi"
MESSAGE = MESSAGE "(mag=" || DPI || "/" || HBASE || ")" '0A'X
MESSAGE = MESSAGE || MSG
Say MESSAGE

If ~Open( LOGFILE, MASTERLOG, "Append" ) Then Do
  Say "Can't open logfile!"
  Return
End

DUMMY = WriteLn( LOGFILE, MESSAGE )
If ~Close( LOGFILE ) Then
  Say "Can't close logfile!"

Return
Error:
  Say "Translation problem, MetaFont returned" ERRORCODE || "."
  Call Log( "Translation problem, MetaFont returned" ERRORCODE || "." )
Return
MyGetEnv: Procedure
Parse Arg NAME

OLDADDR = ADDRESS()
ADDRESS "REXX"

If Open( TEMPFILE, "ENV:" || NAME, "Read" ) Then Do
  GIVES = Readln( TEMPFILE )
  Close( TEMPFILE )
End; Else
  GIVES = ""

ADDRESS OLDADDR

Return GIVES
MySetEnv: Procedure
Parse Arg NAME,VALUE

Address COMMAND "SetEnv" NAME '"' || VALUE || '"'

Return
SafeMakeDir: Procedure
Parse Arg DIRNAME

If ~Exists( DIRNAME ) Then Do
  MakeDir DIRNAME
  If ~Exists( DIRNAME ) Then Do
    Call Log( "Could not create directory" DIRNAME )
    Exit 10
  End
  Say "Directory (" || DIRNAME || ") did not exist.  It was created."
End

Return
SafeMakeFile: Procedure
Parse Arg FILENAME

If ~Exists( FILENAME ) Then Do
  "echo >" FILENAME
  If ~Exists( FILENAME ) Then Do
    Call Log( "Could not create file=" || FILENAME )
    Exit 10
  End
  Say "File (" || FILENAME || ") did not exist.  It was created."
End

Return

