# basic (batch) installation for xtem_TeXMenu
#
# Copyright (C) 1999  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
#########################################################################################################################

source xic.tcl

XiInit

proc SigChldB {} { }
proc SigChldU {} { }

XiGetArgsAndOpenLog "xtem_TeXMenu basic (batch) installation parameters:"

XiGet_vv_XV

set stt ""; XiPlatform log

if	{[info commands set]==""}	{set errt "is not a Tcl/TclX-shell"} \
else					{set errt ""}
if {$errt!=""} {XiExit "Variable TCLCALL in file xteminstall\n$errt\n"}


#----- installation proc's ----------------------------------------------------------------------------------------------

proc XiLinkSym {to from} {# generates symbolic link:  from --> to  (either using TclX-command link or exec command!)
 global TclExtend
 TestPut 2 "<$TclExtend><[info commands link]>"
 XiProtokoll "\tgenerating symbolic link  $from --> $to"
    if {$TclExtend==1} {link -sym $to $from} else {exec ln -s $to $from}
}

proc XiUnlink {name} {XiProtokoll "\tremoving file/directory  $name"; file delete -force -- "$name";#del file/directory}

proc XiMkdir {dir} {# make directory dir   (either using TclX-command unlink or exec command!)
 global TclExtend
 TestPut 2 "<$TclExtend><[info commands mkdir]>"
 XiProtokoll "\tremoving file/directory  $dir<[info commands mkdir]>"
 if {$TclExtend==1} {mkdir $dir} else {exec mkdir $dir}
}

proc XiChmod {mode names} {# makes chmod (either using TclX-command chmod or exec command)
 global TclExtend
 TestPut 2 "<$TclExtend><[info commands chmod]>"
 XiProtokoll "\tchmod $mode $names"
 catch "glob -- $names" files; set filelist ""; foreach f $files {if [file exists $f] {lappend filelist $f}}
 if {$filelist==""} {return}
 if {$TclExtend==1} {chmod $mode $filelist} else {eval exec chmod $mode $filelist}
}

proc XiGetVersion {dir} {
 TestPut 3 ""
 if {[file exists $dir/xV.tcl]||[file exists $dir/xtem.tcl]} {
   if [file exists $dir/xV.tcl] {set file xV.tcl; #version>=5.01} else {set file xtem.tcl; #version<=5.00}
   set ret "old"
   set f [open $dir/$file]
   for {set i 1} {$i<=40} {incr i} {getscl $f z
		set e [string trim $z];                set p [string first " " $e];set w1 "$e"
     if {$p>0} {set w1 [string range $e 0 [expr $p-1]]
		set e [string trim [string range $e $p end]]; set p [string first " " $e]; set w2 "$e"}
     if {$p>0} {set w2 [string range $e 0 [expr $p-1]]
		set e [string trim [string range $e $p end]]; set p [string first " " $e]; set w3 "$e"}
     if {$p>0} {set w3 [string range $e 0 [expr $p-1]]}
     if {($w1=="set")&&($w2=="version")&&([string index $w3 0]=={"})} {
       if {[string first ";" $e]>0} {set e [string range $e 0 [expr [string first ";" $e]-1]]}
       set ret [lindex $e 0]
     }
   }
   close $f
   return $ret
 }
}

proc XiNotInstalledText {} \
 {return " <--- this file couldn't be installed\n(no write permission); restart xteminstall once more,  or do manually:"}

proc XiGetShellCallLine {} {# get Bourns shell call from file xteminstall (first line)
 global ShellCallLine
 set FIDSC [open xteminstall r]; gets $FIDSC ShellCallLine; close $FIDSC
 TestPut 4 "<$ShellCallLine><[string range $ShellCallLine 0 1]>"
 if {"[string range $ShellCallLine 0 1]"!="#!"} \
   {XiExit "Bourne shell specified in first line of `xteminstall' must start with `#!'"}
}

proc XiTestModifyShellCallLine {file} {# Test (and modify if necessary) Bourne shell call in scripts
 global ShellCallLine
 if ![file exists $file] {return}
 set FIDSC [open $file r]; gets $FIDSC fl; close $FIDSC; set SC [lindex $fl 0]
 TestPut 3 "<$file><$SC> <$ShellCallLine>"
 if {"$SC"=="$ShellCallLine"} {return}
 file rename -force -- $file $file.bak
 set FIDin [open $file.bak r]; set FIDout [open $file w]
 puts $FIDout "$ShellCallLine"
 if {[string range $SC 0 1]=="#!"} {gets $FIDin zeile}
 while {[gets $FIDin zeile]>=0} {puts $FIDout "$zeile"}
 close $FIDin; close $FIDout
}

proc XiCheckUpdMakecommand {language} {
 global MkcmdTclVColNr INSTPATH NEW tclversion
 set VstFile $INSTPATH/xtem_locals_$language/mkcommand.vst
 set VstPathLRW $INSTPATH/$NEW/locals_$language.LRW
 XiChmod a+rw $VstFile
 if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcolLRW [MkcmdTclVCol no-exit $VstPathLRW]
 if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]
 TestPut 4 "<$mkcmdcolLRW><$mkcmdcol>"
 if {($mkcmdcolLRW>0)&&($mkcmdcol==0)} {
   XiProtokollEnd2 "\n\tfile $VstFile needs upgrading to Tcl version $tclversion;"
   file rename -force $VstFile $VstFile.bak
     set FIDMOld  [open "$VstFile.bak" r]; set FIDMNew  [open "$VstFile" w]; set LN 1
   while {[getscl $FIDMOld ln]>=0} {
       if {([string first "mkcommand." $ln]<0)&&($LN>1)} {puts $FIDMNew "$ln"; continue}
     if {$LN==1} {
       set sep [string range [string trim $ln] 0 0]
       set IP [getAnzThisCharInString $sep $ln]
       while  {"[getvalue $ln $IP $sep]"==""} {incr IP -1}
       incr IP
     }
     set NS [getAnzThisCharInString $sep $ln]
     TestPut 4 "$IP $NS     <$ln>"
     while  {$IP<=$NS} {incr NS -1; set ln [string trimright [string range $ln 0 [expr [string last $sep $ln]-1]]]}
     if {$LN==1} {
       set ln "$ln     $sep Tcl_$tclversion"
     } else {
       if {"[getvalue $ln [expr $NS-0] $sep]"==""} {set ln "$ln            "}
       while  {[expr $IP-1]>$NS} {incr NS; set ln "$ln $sep            "}
       set p1 [string last "mkcommand." $ln]; set p2 [expr $p1+10]
       set MkCmd [string range $ln $p1 $p2]; set MkCmdNum [string range $MkCmd 10 end]
       set ln "$ln $sep"
       TestPut 4 "$IP $NS <$MkCmdNum> <$ln>"
       if {($MkCmdNum==0)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==1)&&($tclversion<=7.6)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==2)&&($tclversion<=7.4)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==3)&&($tclversion<=7.4)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==4)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==5)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==6)&&($tclversion>=7.4)} {set ln "$ln $MkCmd"}
       if {($MkCmdNum==7)&&($tclversion>=7.4)} {set ln "$ln $MkCmd"}
     }
     puts $FIDMNew "$ln"
     incr LN
   }
   close $FIDMOld; close $FIDMNew
   XiProtokollEnd2 "\tupgrading done automatically by installation procedure!\n"
 }
}
#________________________________________________________________________________________________________________________

#----- installation main procedure   ------------------------------------------------------------------------------------

set skipRest 0
set XiProtEndText4 ""; set XiProtEndText2 ""


XiProtokoll "\nLookup if xtem has been installed previously:"

XiChmod u+w $INSTPATH/xtem-$NEWV

# look for $INSTPATH/xtem
# if $INSTPATH/xtem exists, it is only allowed to be directory or link; if it's a file ---> exit!
if [file isfile $INSTPATH/xtem] {XiExit "\n*** Error - this should be a directory, but is a file: $INSTPATH/xtem"}

if [file isdirectory $INSTPATH/xtem] {
  if {[file type $INSTPATH/xtem]=="link"} {set XLINK 1} else {set XLINK 0}
  set XTEMV [XiGetVersion $INSTPATH/xtem]; set XTEM "xtem"
} else {
  set XTEMV "";			    set XTEM ""
}

if {$XTEM==""} {				# $INSTPATH/xtem didn't exist up to now, a link to NEW is to be created

  XiProtokoll "\tno old version of xtem found"
  XiUnlink $INSTPATH/xtem; XiLinkSym $INSTPATH/xtem-$NEWV $INSTPATH/xtem
  set XTEMV "$NEWV";   set XTEM "xtem-$NEWV"
  set OLDV  "";        set OLD  ""

} else {					# $INSTPATH/xtem exists

  if {$XTEMV==""} {					# exit if version is not found

    XiExit "\ncouldn't find xtem version in the start lines of: $INSTPATH/$XTEM/xtem.tcl"

  }

  if {"$NEWV"!="$XTEMV"} {				# XTEMV has to become OLDV

    set OLDV  "$XTEMV";  set OLD  "xtem-$OLDV"
    XiProtokoll "\told version of xtem found: $OLD"
    XiProtokoll "\tlink will be switched to:  $NEW"
    if {$XLINK} {
	XiUnlink $INSTPATH/xtem
    } else {
	if [file exists $INSTPATH/$OLD] {XiUnlink $INSTPATH/$OLD}
	frename $INSTPATH/$XTEM $INSTPATH/$OLD
    }
    XiLinkSym $INSTPATH/$NEW $INSTPATH/xtem
    set XTEMV "$NEWV";   set XTEM "xtem"

  } else {						# no OLD version

    XiProtokoll "\tno switching of link necessary"
    set OLDV  "";	  set OLD  ""

  }

}
set xtem_path "$INSTPATH/$XTEM"



# xtem shell-script creation and test for correct Shell Call

XiGetShellCallLine

XiProtokoll "\nxtem shell-script creation ..."
if {[file exists xtem]&&[file exists xtemInstalled]} {
  XiProtokollEnd2 "\nShell script \"xtem\" was not generated as file \"xtemInstalled\" exists."
} else {
  set f [open "xtem" w]
  puts $f "$ShellCallLine"
  puts $f {}
  puts $f {# generated by xteminstall}
  puts $f {}
  puts $f {# If you need to change this file (e.g. adding environment settings etc.),}
  puts $f {# you can prevent xteminstall from overwriting this file}
  puts $f {# at further calls of xteminstall: }
  puts $f {# just create a file "xtemInstalled" in this directory, eg with Unix command:}
  puts $f {#}
  puts $f {#      touch xtemInstalled}
  puts $f {}
  puts $f {#####  command to call wishx (must include Tcl, Tk and TclX)}
  puts $f "wishcall=\"$WISHCALL\""
  puts $f {}
  puts $f {#####  command to call tcl (pure Tcl, without Tk)}
  puts $f "tclcall=\"$TCLCALL\""
  puts $f {}
  puts $f {#####  path in which xtem is installed:}
  puts $f {#####  can be set by the environment variable XTEMPATH; }
  puts $f {#####  if XTEMPATH doesn't exist, it will be set to the following default value:}
  puts $f ": \$\{XTEMPATH=\$\{XTEMPATH-$INSTPATH/xtem\}\}"
  puts $f "#####  (i.e. files      $INSTPATH/xtem/*.tcl     will be found)"
  puts $f {}
  puts $f {#####  one of the following language defining lines must be made active! }
  puts $f {#defaultlanguage="german"}
  puts $f {#defaultlanguage="english"}
  puts $f "defaultlanguage=\"$DEFLANGUAGE\""
  puts $f {}
  puts $f {if [ ! -d "$XTEMPATH" ]}
  puts $f {then}
  puts $f {  echo "error at xtem call: directory  XTEMPATH=$XTEMPATH   doesn't exist"}
  puts $f {  echo "probably your installation is incomplete, see: xtem Installation Guide)"}
  puts $f {  exit}
  puts $f {fi}
  puts $f {}
  puts $f {if [ -z "$HOME" ]}
  puts $f {then}
  puts $f {  echo "error at xtem call: environment variable HOME  doesn't exist"}
  puts $f {  echo "(xtem needs this variable pointing to your home directory!)"}
  puts $f {  exit}
  puts $f {fi}
  puts $f {}
  puts $f {if [ -n "$XTEMDEFLANG" ]}
  puts $f {then}
  puts $f {  defaultlanguage=`echo $XTEMDEFLANG | tr '[:upper:]' '[:lower:]'`}
  puts $f {elif [ "$defaultlanguage" = "" ]}
  puts $f {then}
  puts $f {  defaultlanguage="english"}
  puts $f {  echo "installation incomplete: default language is not specified;  set to $defaultlanguage"}
  puts $f {  echo "please modify file (shell script) \"$0\""}
  puts $f {fi}
  puts $f {}
  puts $f {language=$defaultlanguage}
  puts $f {}
  puts $f {if [ "$1 " = "-l " ] ;# Blanks inserted for Linux}
  puts $f {then language="$2"; shift}
  puts $f {  if [ "$1" = "" ]}
  puts $f {  then}
  puts $f {    echo "syntax:  `basename $0` [ -l language ] [ filename[.tex] ]"}
  puts $f {  else}
  puts $f {    shift}
  puts $f {  fi}
  puts $f {fi}
  puts $f {}
  set languages "$LANGUAGES"; set supported ""; set sep ""
  while {[lindex $languages 0]!=""} {
    set langstring [lindex $languages 0]; set languages [lrange $languages 1 end]
    set language [lindex $langstring 0];  set synonyms [lrange $langstring 1 end]
    set supported "$supported$sep $language";   set sep ","
    while {[lindex $synonyms 0]!=""} {
      puts $f "if \[ \"\$language\" = \"[lindex $synonyms 0]\" \]; then language=\"$language\"; fi"
      set supported "$supported | [lindex $synonyms 0]"
      set synonyms [lrange $synonyms 1 end]
    }
  }
  puts $f "if \[ \\"
  set a "  "
  foreach i [Languages] {puts $f "     $a \"\$language\" != \"$i\" \\";   set a "-a"}
  puts $f {   ]}
  puts $f {then}
  puts $f {  echo "Warning: language \"$language\" not implemented; we use \"$defaultlanguage\" instead"}
  puts $f "  echo \"         supported languages are:  $supported\""
  puts $f {  language=$defaultlanguage}
  puts $f {fi}
  puts $f {}
  puts $f {exec $wishcall $XTEMPATH/xtem.tcl -n xtem $wishcall $tclcall $XTEMPATH $language $*}
  puts $f {####}
  puts $f {}
  close $f
  XiChmod a+rx xtem
}

XiTestModifyShellCallLine xtem_prog
XiTestModifyShellCallLine hyphen_show.sort
XiTestModifyShellCallLine xtem


XiProtokoll "\tDefaultlanguage:  $DEFLANGUAGE"
XiProtokoll "\tLanguage(s):"
set languages "$LANGUAGES"
while {[lindex $languages 0]!=""} {
  set langstring [lindex $languages 0]; set languages [lrange $languages 1 end]
  set language [lindex $langstring 0];  set synonyms [lrange $langstring 1 end]
  if {$synonyms==""} {XiProtokoll "\t  $language"} else {XiProtokoll "\t  $language  (synonym(s)): $synonyms)"}
}

# installation of shell script  xtem ---> $BINPATH

set cmpres [catch "exec cmp $BINPATH/xtem xtem" cmpmes]
if {[file exists "$BINPATH/xtem"]&&($cmpmes=="")} {# is up to date
  XiProtokoll "\nShell script is up to date: $BINPATH/xtem"
} else {# must be updated
  if [file writable $BINPATH] {# update can be done
    XiProtokoll "\nInstallation of Shell script:  $BINPATH/xtem"
    XiUnlink $BINPATH/xtem; XiLinkSym $INSTPATH/xtem/xtem $BINPATH/xtem
  } else {# needs update, but cannot be updated!
    XiProtokollEnd4 "\n$BINPATH/xtem [XiNotInstalledText]"
    XiProtokollEnd4 "\trm $BINPATH/xtem\n  ln -s $INSTPATH/xtem/xtem $BINPATH/xtem" ; XiProtokoll ""
  }
}

# installation of program changecode ---> $BINPATH

if [file exists "changecode"] {
  set cmpres [catch "exec cmp $BINPATH/changecode changecode" cmpmes]
  if {[file exists "$BINPATH/changecode"]&&($cmpmes=="")} {# changecode is up to date
    XiProtokoll "\nProgram is up to date: $BINPATH/changecode"
  } else {# changecode must be updated
    if [file writable $BINPATH] {# update can be done
      XiProtokoll "\nInstallation of program:  $BINPATH/changecode"
      XiUnlink $BINPATH/changecode; XiLinkSym $INSTPATH/xtem/changecode $BINPATH/changecode
    } else {# needs update, but cannot be updated!
      XiProtokollEnd4 "\n$BINPATH/changecode [XiNotInstalledText]"
      XiProtokollEnd4 "\trm $BINPATH/changecode\n  ln -s $INSTPATH/xtem/changecode $BINPATH/changecode"
      XiProtokoll ""
    }
  }
} else {# file changecode not found
  XiProtokollEnd4 "\nFile not found: changecode"; XiProtokoll ""
}

# installation of program hyphen_show ---> $BINPATH

if [file exists "hyphen_show"] {
  set cmpres [catch "exec cmp $BINPATH/hyphen_show hyphen_show" cmpmes]
  if {[file exists "$BINPATH/hyphen_show"]&&($cmpmes=="")} {# hyphen_show is up to date
    XiProtokoll "\nProgram is up to date: $BINPATH/hyphen_show"
  } else {# hyphen_show must be updated
    if [file writable $BINPATH] {# update can be done
      XiProtokoll "\nInstallation of program:  $BINPATH/hyphen_show"
      XiUnlink $BINPATH/hyphen_show; XiLinkSym $INSTPATH/xtem/hyphen_show $BINPATH/hyphen_show
    } else {# needs update, but cannot be updated!
      XiProtokollEnd4 "\n$BINPATH/hyphen_show [XiNotInstalledText]"
      XiProtokollEnd4 "\trm $BINPATH/hyphen_show\n  ln -s $INSTPATH/xtem/hyphen_show $BINPATH/hyphen_show"
      XiProtokoll ""
    }
  }
} else {# file hyphen_show not found
  XiProtokollEnd4 "\nFile not found: hyphen_show"; XiProtokoll ""
}


# man-page installation  xtem.1 ---> $MANPATH

set cmpres [catch "exec cmp $MANPATH/xtem.1 xtem.1" cmpmes]
if {[file exists "$MANPATH/xtem.1"]&&($cmpmes=="")} {# is up to date
  XiProtokoll "\nMan page is up to date: $MANPATH/xtem.1"
} else {# must be updated
  if [file writable $MANPATH] {# update can be done
    XiProtokoll "\nInstallation of man page:  $MANPATH/xtem.1"
    XiUnlink $MANPATH/xtem.1; XiLinkSym $INSTPATH/xtem/xtem.1 $MANPATH/xtem.1
  } else {# needs update, but cannot be updated!
    XiProtokollEnd4 "\n$MANPATH/xtem.1 [XiNotInstalledText]"
    XiProtokollEnd4 "\trm $MANPATH/xtem.1\n  ln -s $INSTPATH/xtem/xtem.1 $MANPATH/xtem.1"; XiProtokoll ""
  }
}


# man-page installation  hyphen_show.1 ---> $MANPATH

set cmpres [catch "exec cmp $MANPATH/hyphen_show.1 hyphen_show.1" cmpmes]
if {[file exists "$MANPATH/hyphen_show.1"]&&($cmpmes=="")} {# is up to date
  XiProtokoll "\nMan page is up to date: $MANPATH/hyphen_show.1"
} else {# must be updated
  if [file writable $MANPATH] {# update can be done
    XiProtokoll "\nInstallation of man page:  $MANPATH/hyphen_show.1"
    XiUnlink $MANPATH/hyphen_show.1; XiLinkSym $INSTPATH/xtem/hyphen_show.1 $MANPATH/hyphen_show.1
  } else {# needs update, but cannot be updated!
    XiProtokollEnd4 "\n$MANPATH/hyphen_show.1 [XiNotInstalledText]"
    XiProtokollEnd4 "\trm $MANPATH/hyphen_show.1\n  ln -s $INSTPATH/xtem/hyphen_show.1 $MANPATH/hyphen_show.1"
    XiProtokoll ""
  }
}


# installation of the setting files

XiProtokoll "\nPresetting files ($INSTPATH/xtem_locals_*/*.vst):"
foreach language [Languages] {
  set todir "$INSTPATH/xtem_locals_$language"
  #
  # first verify for correctness of basic situation, modify if necessary and if possible
  if {![file exists $todir]&&![file exists locals_$language]} {
    XiMkdir $todir;  XiChmod a+rx $todir
    if {[catch  "glob -- locals_$language.LRW/*.vst" files]} {set files [glob -- locals_$language.LRW/*.vst]}
    if {"$files"!=""} {foreach f $files {exec cp $f $todir/.; XiChmod a+r $todir/$f}}
    set newPrintingVst "yes"
    XiLinkSym $todir locals_$language
    XiProtokoll "\n\tis created:  $todir, setting files moved"
    XiProtokoll "\tfrom locals_$language.LRW to $todir"
    XiProtokoll "\tsymbolic link  locals_$language --> $todir\n\n"
  } elseif {![file exists $todir]&&[file exists locals_$language]&&[file type locals_$language]=="directory"} {
    XiMkdir $todir;  XiChmod a+rx $todir
    if {[catch  "glob -- locals_$language/*.vst" files]} {set files [glob -- locals_$language/*.vst]}
    if {"$files"!=""} {foreach f $files {exec cp $f $todir/.; XiChmod a+r $todir/$f}}
    set newPrintingVst "yes"
    XiUnlink locals_$language
    XiLinkSym $todir locals_$language
    XiProtokoll "\n\tis created:  $todir, setting files moved"
    XiProtokoll "\tfrom locals_$language to $todir,"
    XiProtokoll "\tsymbolic link  locals_$language --> $todir\n\n"
  } elseif {[file exists locals_$language]&&[file type locals_$language]=="directory"} {
    XiUnlink locals_$language
    XiProtokoll "\n\t`$INSTPATH/$XTEM/locals_$language' is directory;"
    XiProtokoll "\tshould not exist (xteminstall will then create an link!)"
    XiProtokoll "\tor should be link to `$todir'."
    XiProtokoll "\t(Your tar command probably unresolved this link!?)"
    XiProtokoll "\tdirectory `locals_$language' thus removed!\n"
  }
  if {[file exists $todir]&&![file writable $todir]} {set skipRest 1
    XiProtokollEnd4 "`$todir' exists and is not writeable;"
    XiProtokollEnd4 "please modify write permission, then restart xteminstall"
    XiProtokollEnd4 ""
  }
  if {[file exists $todir/letters.vst]&&[file writable $todir]} {
    file rename -force -- $todir/letters.vst $todir/letters.vst-old
    XiProtokoll "\n\t`$todir/letters.vst' is obsolete,"
    XiProtokoll "\tthus moved to `$todir/letters.vst-old'"
  }

  # now do setting file installation
  if {$skipRest==0} {
    set cpFrom ""
    if {[file exists $todir]} {                          # already exist's

      if {[file isdirectory $todir]} {                   #              and is directory
        XiChmod a+rx $todir
        XiProtokoll "\talready existing file is still used:  $todir"
      } else {                                           #              and is no directory
        XiExit "\n$todir \t exists and is file;\n\t\tshouldn't exist or should be directory!"
      }

    } else {                                             # doesn't exist: to be created

      XiMkdir $todir;  XiChmod a+rx $todir
      if {$OLDV!=""} {set cpFrom "$INSTPATH/$OLD/locals_$language"} else {set cpFrom "$INSTPATH/$NEW/locals_$language"}
      if {([file type $cpFrom]=="link")&&(![file exists [file readlink $cpFrom]])} \
		{set cpFrom "$INSTPATH/$NEW/locals_$language.LRW"}
      if {[catch  "glob -- $cpFrom/*.vst" files]} \
		{set cpFrom "$INSTPATH/$NEW/locals_$language.LRW"; set files [glob -- $cpFrom/*.vst]}
      foreach f $files {exec cp $f $todir/.}
      set files [glob -- $todir/*.vst];   foreach f $files {XiChmod a+r $f}
      XiProtokoll "\tis created:  $todir"

    }
    if {$cpFrom!=""} {XiProtokoll "\t(files copied from: $cpFrom)"; set cpFL($language) "$cpFrom"} \
    else {set cpFL($language) ""}
    set cpFrom ""
    cd locals_$language.LRW; set files "[glob -- *.vst]"; cd ..
    if {![file exists $todir/printing.vst]} {set newPrintingVst "yes"}
    foreach f $files {
	if ![file exists $todir/$f] {
	  set cpFrom "locals_$language.LRW/$f"
	  exec cp $cpFrom $todir/.
	  XiChmod a+r $todir/$f
	} else {
	  if ![file writable $todir/$f] {XiProtokollEnd2 "\n\tFile `$todir/$f' is not writeable!"; XiProtokoll ""}
	}
	if {$cpFrom!=""} {XiProtokoll "\tfile copied from: $cpFrom"}; set cpFrom ""
    }
    if {![file exists locals_$language]} {
	XiLinkSym $todir locals_$language
    } elseif {[file type locals_$language]=="link"} {
	XiUnlink locals_$language
	if {![file exists locals_$language]} {XiLinkSym $todir locals_$language}
    }

    set file locals_$language/texfmt.vst;  # test whether texfmt.vst should be updated or not
    XiProtokoll "\nChecking file $file"
    set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]; Xigetscl0 $f e
    if {[getvalue $e 2 $s]==""} {
	XiProtokollEnd2 "\n\tYou are recommended to update file `$file'"
	XiProtokollEnd2 "\tin order to use the `quick&dirty' facilities; for details see `Installation Guide'"
	XiProtokoll ""
    } else {XiProtokoll "\tOK: Quick&Dirty is installed"}
    if {[getvalue $e 10 $s]==""} {
	XiProtokollEnd2 "\n\tYou are recommended to update file `$file'"
	XiProtokollEnd2 "\tin order to use the `main file selection' facilities"
	XiProtokollEnd2 "\t(reduction of file selection list); for details see `Installation Guide'"
	XiProtokoll ""
    } else {XiProtokoll "\tOK: `main file list reduction facility' (file selection menu) is installed"}
    close $f

    set file locals_$language/prt_dvips.vst;  # test whether prt_dvips.vst should be updated or not
    XiProtokoll "\nChecking file $file"
    set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]
    set allempty 1; while {[Xigetscl0 $f e]>=0} {if {[string trim [getvalue $e 4 $s]]!=""} {set allempty 0}}
    if {$allempty} {
	XiProtokollEnd2 "\n\tYou are recommended to update file `$file'"
	XiProtokollEnd2 "\tin order to use the `prtcmd' facilities; for details see `Installation Guide'"
	XiProtokoll ""
    } else {XiProtokoll "\tOK: locals_$language/prt_dvips.vst does use parameters >=4 "}
    close $f

    set file locals_$language/mkcommand.vst
    # test whether mkcommand.vst has column for this Tcl version or not
    XiProtokoll "\nChecking file $file"
    XiCheckUpdMakecommand $language
    if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]
    if {$mkcmdcol==0} {
	XiProtokollEnd2 "\n\tFile `locals_$language/mkcommand.vst' has no column for Tcl version $tclversion"
	XiProtokollEnd2 "\tIt is necessary to update this file (e.g. by copying it from"
	XiProtokollEnd2 "\tlocals_$language.LRW/mkcommand.vst); for details see `Installation Guide'"
	XiProtokoll ""
    } else {XiProtokoll "\tOK: has entries for executing commands with Tcl version $tclversion"}
    # test whether mkcommand.vst must be updated or not
    vstr_exec no-exit
    if {"$mkcommand"=="mkcommand.9"} {
	XiProtokollEnd2 "\n\tFile `$file' needs customization;"
	XiProtokollEnd2 "\tremove \"... mkcommand.9 ...\" etc., for details see `Installation Guide'"
	XiProtokoll ""
    }

  }
}


# installation of the "local.news"

if {$skipRest==0} {
  XiProtokoll "\nLocal News ($INSTPATH/xtem_locals_*/local.news):"
  foreach file "local.news xtemstart.news" {
    foreach language [Languages] {
      if ![file exists $INSTPATH/xtem_locals_$language/$file] {
	if [file exists $INSTPATH/$OLD/locals_$language/$file] {set cpFrom "$INSTPATH/$OLD/locals_$language/$file"} \
	else {set cpFrom "locals_$language.LRW/$file"}
	set cpTo "$INSTPATH/xtem_locals_$language/$file"
	exec cp $cpFrom $cpTo;  XiChmod a+r $cpTo
	XiProtokoll "\tfile copied from:  $INSTPATH/xtem/$cpFrom"
      } else {
	XiProtokoll "\talready existing file is still used:  $INSTPATH/xtem_locals_$language/$file"
      }
    }
  }
}


# check (and modify if necessary) variable "xtermcall" in install.vst

if {$skipRest==0} {
  XiProtokoll "\nVariable xtermcall is checked (and modified if necessary) in $INSTPATH/xtem_locals_*/install.vst:"
  foreach language [Languages] {
    set todir "$INSTPATH/xtem_locals_$language"; set xtem_path "$INSTPATH/$NEW"; set XiVstHasSep 0
    if {![file exists $todir/install.vst]} {
      XiProtokoll "\n\tFile not found: $todir/install.vst\n"; mybell 4
    } else {
      set XiCurLanguage $language; set modified 0; set ln 0; XiVst2Lists install.vst "" new
      foreach l $XiVstActive {
	if {("z[lindex $l 0]"=="zxtermcall")&&("z[lrange $l 1 end]"!="z$XTERMCALL")} {
	  set XiVstActive [linsert [lreplace $XiVstActive $ln $ln "#$l"] [expr $ln+1] "xtermcall          $XTERMCALL"]
	  set modified 1; incr ln; #incr ln important at this place (if more than one xtermcall line!)
	}
	incr ln
      }
      if {$modified==1} {
	XiSaveVstfile install.vst 1
	XiProtokoll "\t(variable \"xtermcall\" has been modified to \"$XTERMCALL\")"
      } else {
	XiProtokoll "\tOK: file $INSTPATH/xtem_locals_*/install.vst"
      }
    }
  }
}


# check file hyphen.vst (copy new version if necessary)

if {$skipRest==0} {
  XiProtokoll "\nFile hyphen.vst is checked in $INSTPATH/xtem_locals_*/hyphen.vst:"
  foreach language [Languages] {
    set todir "$INSTPATH/xtem_locals_$language"; set xtem_path "$INSTPATH/$NEW"; set XiVstHasSep 1
    if {![file exists $todir/hyphen.vst]} {
	XiProtokoll "\n\tFile not found: $todir/hyphen.vst\n"; mybell 4
    } else {
	set XiCurLanguage $language; set ln 0; XiVst2Lists hyphen.vst "" new
	if {$XiVstVersion>=6.01} {set newFormOfVst 1} else {set newFormOfVst 0}
	foreach l $XiVstActive {
	  if {("[getvalue $l 3 $XiVstSep]"!="")||("[getvalue $l 4 $XiVstSep]"!="")} {set newFormOfVst 1}
	}
	if {$newFormOfVst==0} {
	  exec cp $INSTPATH/$NEW/locals_$language.LRW/hyphen.vst $todir/hyphen.vst
	  XiProtokoll "\n\tFile updated: $todir/hyphen.vst\n"; mybell 4
	} else {
	  XiProtokoll "\tOK: \"$todir/hyphen.vst\" has current format"
	}
    }
  }
}


# chmod's

if {$skipRest==0} {
  XiProtokoll "\n\nSetting acces modes:\n"
  cd $INSTPATH
  set mod "a+rx"; set names "xtem_locals_*       "; XiChmod $mod "$names"
  set mod "a+r";  set names "xtem_locals_*/*     "; XiChmod $mod "$names"
  set mod "u+w";  set names "xtem_locals_*/*     "; XiChmod $mod "$names"
  set mod "a+r";  set names "$NEW                "; XiChmod $mod "$names"
  set mod "a+rx"; set names "$NEW                "; XiChmod $mod "$names"
  cd $INSTPATH/$NEW
  set mod "a+r";  set names "*                   "; XiChmod $mod "$names"
  set mod "a+rx"; set names "xtem                "; XiChmod $mod "$names"
  set mod "a+rx"; set names "xtem.tcl            "; XiChmod $mod "$names"
  set mod "a+rx"; set names "xtem_async          "; XiChmod $mod "$names"
  set mod "a+rx"; set names "xtem_prog           "; XiChmod $mod "$names"
  set mod "a+rx"; set names "changecode          "; XiChmod $mod "$names"
  set mod "a+rx"; set names "hyphen_show         "; XiChmod $mod "$names"
  set mod "a+rx"; set names "hyphen_show.sort    "; XiChmod $mod "$names"
  set mod "a+rx"; set names "pages_show          "; XiChmod $mod "$names"
  set mod "a+rx"; set names "locals_*            "; XiChmod $mod "$names"
  set mod "a+r";  set names "locals_*/*          "; XiChmod $mod "$names"
  set mod "a-w";  set names "locals_*.LRW/*      "; XiChmod $mod "$names"
  set mod "a+rx"; set names "help_*              "; XiChmod $mod "$names"
  set mod "a+rx"; set names "help_*/latex        "; XiChmod $mod "$names"
  set mod "a+rx"; set names "help_*/miscellaneous"; XiChmod $mod "$names"
  foreach language [Languages] {
    cd $INSTPATH/$NEW/help_$language
    set mod "a+r";  set names "*                 "; XiChmod $mod "$names"
    set mod "a+r";  set names "*/*               "; XiChmod $mod "$names"
  }
  cd $INSTPATH/$NEW
}


# check file printing.vst <--> PRINTCOM (copy new version if necessary)

proc XiLookPrintComs {file} {# look for print commands in file, return list of all commands in order of first occurence
 set list ""; set pract ""; set prcom ""
 set f [open $file]; Xigetscl0 $f e; set s [string index [string trim $e] 0]; Xigetscl0 $f e
 TestPut 4 "<[pwd]><$file>"
 if {[string index [string trim $e] 0]=="$s"} {Xigetscl0 $f e}
 while {$e!=""} {  set p [getvalue $e 6 $s]; if {[lsearch $pract $p]<0} {lappend pract $p}; Xigetscl0 $f e  }
 while {[Xigetscl0 $f e]>=0} {
   set p [getvalue $e 6 $s]; if {([string first $s $e]>=0)&&([lsearch $prcom $p]<0)} {lappend prcom $p}
 }
 close $f
 lappend list $pract $prcom
 TestPut 4 "$list"
 return $list
}

proc XiLookPRINTCOM {PRINTCOM pract prinact} {# look for consistency of system <--> PRINTCOM & print_coms_in_printing.vst
 global tcl_platform
 set s [array get tcl_platform]; set i [lsearch $s "os"]
 if {$i<0} {return ""}
 if {$i<0} {return "[lindex $sys [expr $i+1]]"} else {return ""}
}

if {$skipRest==0} {
  if {"$PRINTCOM"!=""} {XiProtokoll "\nChecking file printing.vst versus print-command-name ($PRINTCOM)"} \
  else {XiProtokoll "\nChecking file printing.vst versus (empty) print-command-name"}
  set lpVstAll {lp lpr lpjep lpjep1 {}}
  foreach language [Languages] {
    set todir "$INSTPATH/xtem_locals_$language"; set xtem_path "$INSTPATH/$NEW"; set XiVstHasSep 1
    XiProtokoll "\n  File $todir/printing.vst"
    if {$newPrintingVst=="yes"} {XiUnlink $todir/printing.vst}
    if {(![file exists $todir/printing.vst])||($cpFL($language)!="")} {
      set fromdir $INSTPATH/$NEW/locals_$language.LRW
      if {[file isdirectory $fromdir]&&[file isdirectory $todir]} {
	XiProtokoll "\tgenerating file: $todir/printing.vst"
	if {[file exists $fromdir/printing.vst-[lindex $PRINTCOM 0]]} {
	  XiProtokoll "\t\tfrom $fromdir/printing.vst-*"
	  exec cat $fromdir/printing.vst-Preamble	 > $todir/printing.vst
	  foreach pr $PRINTCOM {if [file exists $fromdir/printing.vst-$pr] {
	    exec cat $fromdir/printing.vst-$pr		>> $todir/printing.vst
	  }}
	  exec cat $fromdir/printing.vst-Comment	>> $todir/printing.vst
	  foreach pr $lpVstAll {if [file exists $fromdir/printing.vst-$pr] {
	    exec cat $fromdir/printing.vst-$pr		>> $todir/printing.vst
	  }}
	} else {
	  XiProtokoll "\t\tfrom $fromdir/printing.vst"
	  exec cp $fromdir/printing.vst $todir/printing.vst
	}
	set mod "a+r";  set names "$todir/printing.vst"; XiChmod $mod "$names"
      } else {
	XiExit "\nSomething's going wrong:\neither\t \"$fromdir\"\nor\t \"$todir\"\ndoesn't exist or isn't directory!"
      }
    } 
    set file locals_$language/printing.vst;  # test whether printing.vst should be adapted from lp to lpr

    set lplist [XiLookPrintComs $file]; set pract [lindex $lplist 0]; set prinact [lindex $lplist 1]
    set fPRINTCOM [string trim [lindex $PRINTCOM 0]]; set defActPr [lindex $pract 0]

    set tOK "Seems to be OK"
    set tNOK "Seems not to be OK"
    set tDF "\n\tDefault print-command-name (first entry in setting file\n\t$todir/printing.vst) is: \"$defActPr\"\n\t"
    set tm "More than one print command: no further test at the moment, perhaps in the future;\n\tcontact $email)"
    set t0a "\n\tRun (after modifying variable PRINTCOM if necessary)"
    set t0c "\n\t\txteminstall basic printing\n\t(overwriting old setting file\n\t$todir/printing.vst)"
    set t0d "\n\tor run (after modifying variable PRINTCOM)\n\t\txteminstall basic"
    set t0d "${t0d}\n\t(not overwriting old setting file\n\t$todir/printing.vst)"
    set t1 "variable PRINTCOM in file xteminstall is empty\n\t(i.e. print into file only); default printer in file"
    set t1 "${t1}\n\t$todir/printing.vst\n\tprovides for print command \"$defActPr\".${t0a}${t0c}."
    set t2 "couldn't find print command \"$defActPr\" (calling \"which '$defActPr'\")!"
    set t2 "${t2}\n\tIf print command is OK (e.g missing PATH variable at the moment),"
    set t2 "${t2}\n\tignore this message! Otherwise modify variable \"PRINTCOM\" in\n\tfile \"xteminstall\", then run:"
    set t2 "${t2}${t0c}."
    set t3 "(having value \"$PRINTCOM\" -- this value of PRINTCOM\n\tseems to be OK!).${t0a}${t0c}."
    set t4 " (this value of PRINTCOM probably\n\tisn't OK -- couldn't find print command \"$PRINTCOM\""
    set t4 "${t4} calling \"which '$PRINTCOM'\")."
    set t5 "print command \"$defActPr\" probably incorrect on your\n\t$OSystem system"
    set t6 "this value isn't consistent with print command in variable\n\tPRINTCOM in file \"xteminstall\""
    set t7 ", which has value \"$PRINTCOM\";\n\tthe value of PRINTCOM seems to be wrong,\n\tas"
    set t8 "normally is used with your $OSystem system."

    XiProtokoll "\n\tthe following print-command-names are found in the active part of the file:\n\t\t$pract"
    XiProtokoll "\n\tthe following print-command-names are found in the comment part of the file:\n\t\t$prinact"

    TestPut 4 "<[catch "which lp"]><[catch "which lpr"]> <[catch "which $fPRINTCOM"]> <$fPRINTCOM><$PRINTCOM>"
    TestPut 4 "<$lpVstAll>:<$pract><$prinact>"

    if {"$fPRINTCOM"!="$PRINTCOM"} {# PRINTCOM is a list; unsupported up to now

					    		   XiProtokoll     "$tDF$tm"

    } elseif {"$fPRINTCOM"==""} {# print output into file only

	if {"$defActPr"==""} {				   XiProtokoll     "$tDF$tOK (print-output --> file only)"} \
	else {						   XiProtokollEnd4 "$tDF$tNOK: $t1"}
 
    } elseif {"$fPRINTCOM"=="$defActPr"} {# PRINTCOM and default printer consistent; does print command really exist?
 
	if {[catch "which $defActPr"]==0} {		   XiProtokoll     "$tDF$tOK!"} \
	elseif {($OSystem=="Linux")&&($PRINTCOM!="lpr")} { XiProtokollEnd4 "$tDF$tNOK: $t5 and $t2"} \
	else {						   XiProtokollEnd2 "$tDF$tNOK: $t2"}
 
    } else {# PRINTCOM and default printer inconsistent

	if {[catch "which $fPRINTCOM"]==0} {		   XiProtokollEnd4 "$tDF$t6 $t3"} \
	elseif {($OSystem=="zzSunOS")&&($PRINTCOM!="lp")} {XiProtokollEnd4 "$tDF$t6 $t7 \"lp\" $t8$t0a$t0c$t0d"} \
	elseif {($OSystem=="Linux")&&($PRINTCOM!="lpr")} { XiProtokollEnd4 "$tDF$t6 $t7 \"lpr\" $t8$t0a$t0c$t0d"} \
	else {						   XiProtokollEnd2 "$tDF$t6 $t4$t0a$t0c$t0d"}

    }
  }
}


# delete existing language-dependent directories for languages not included in LANGUAGES
#
# at the moment no real delete, but creation of a list of commands to delete them

if {$skipRest==0} {
  foreach langex "[glob -- help_*]" {
    set lgex [string range $langex 5 end];  set unused 1
    foreach language [Languages] {if {$lgex=="$language"} {set unused 0}}
    if {$unused} {
	XiProtokoll "\n$lgex :\tlanguage-dependent files are unused (~ 1 MB disk space/language!),"
	XiProtokoll "\tyou can use the following command to delete these files:"
	XiProtokoll "\t   rm -rf $INSTPATH/$NEW/*_$lgex "
    }
  }
}


# all programs accessable?

if {($skipRest==0)&&($whichcheck=="yes")} {xiVstCallsWhich}


# test for gunzip | xdvi

if {($skipRest==0)&&($whichcheck=="yes")} {
  set liste "gunzip xdvi"; set NoneInstalled 1; foreach p $liste {if {[catch "which $p"]==0} {set NoneInstalled 0}}
  if {$NoneInstalled} {
    XiProtokoll "\n$XV(AAsteriks)\nNone of the following programs is installed:  $liste"
    XiProtokoll "Sorry, you can't display the bitmaps to the (La)TeX syntax examples, see Installation Guide!"
    XiProtokoll "$XV(AAsteriks)\n"
  }
}

 #puts stdout "**** fehlt noch bei Installation: Installation weiterer Sprachen vorber.        "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: welche Buttons im Hauptmenu erzeugen?         "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: alte help-files Vorrang vor neuen?            "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: character set translation (umlaute)           "; #####@@@@@
 #puts stdout "**** fehlt noch bei Installation: Bitmap-Dateien: *.gz oder *.xbm lschen!      "; #####@@@@@

if {$XiProtEndText2!=""} {XiProtokoll "\n$XiProtEndText2"}
if {$XiProtEndText4!=""} {
  XiProtokoll "\n\n$XV(AAsteriks)\n$XV(AAsteriks)"
  XiProtokoll "\n$XiProtEndText4"
  XiProtokoll "Installation procedure ended incompletely (see preceding messages)!"
  XiProtokoll "Restart xteminstall after execution of the command(s) given ahead."
  XiProtokoll "$XV(AAsteriks)\n$XV(AAsteriks)"
  set exitCode 4;  mybell 4
} else {
  XiProtokoll "\nInstallation procedure ended correctly.\nYou can now test and modify the setting files!"
  set exitCode 0
}
set XiProtEndText4 ""; set XiProtEndText2 ""


close $XiFIDerr

exit $exitCode

#															 puts stdout "@@@@@@@@@ Ende der getesteten Installationsprozedur erreicht! @@@@@@@@@@@@@@@@@@";exit 0;##################################################################################################################################################################################################################################################################################																

#########################################################################################################################
