/* readword.c  this file is part of the package "plain2latex"
    Copyright (C) 1998 Pedro Fortuny.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file readme.t2l to know how to use this program. And how you
   can support me :-)

    Pedro Fortuny. Dpto. Algebra. Universidad de Valladolid. Spain.
    pfortuny@vax631.cpd.uva.es

*/

#include <stdio.h>
#include <string.h>
/*REMEMBER: 64 (IN THIS FILE 65) IS THE MAXIMUM
COMMAND-WORD LENGTH */

void redword (FILE *file,char str[]);
/* redword(FILE *file,char str[]): reads chars from file until it
 finds a non-character (see below), that is, a symbol which forms
 not part of any litteral word. it stores the whole word in str and
 adds a '\n' at the end of the read word in order to make it a real
 'C' string. this function
leaves the FILE src looking just after the lasy number-symbol it
has read (fseek at the end). if the word has length 0 then str
is set to '\0'.*/


int rednumber(FILE *src,char str[]);
/* rednumber(FILE *file,char str[]) it does the same as redword, but
now with numbers. it allows '+','-' and '.', in a number,
but NOT SPACES!!!!! IMPORTANT: we suppose the user is going to read
a number BEFORE beginning to do it: the function returns an integer,
which is the length (in digits & symbols) of the number, so if the
value is 0 it means that there is no number to read. this function
leaves the FILE src looking just after the lasy number-symbol it
has read (fseek at the end)  IT ALLOWS NO ABBREVIATIONS OR PRE-
DEFINED LENGTHS...SORRY*/


int redspaces(FILE *src,int *line_number);
/*redspaces(FILE *src): this function reads in src until it finds a symbol
which is not a ' ' (space) or a '\n' (a newline). it returns the number of spaces
and of new-lines read and leaves
src just after the last space read. useful if you need to look for a number
or word after a command like, f. e. \hskip */


/* here comes the code of the fuctions */
void redword (FILE *file,char str[]){
   char non_text[][1] = {
      '\\', ' ', '{', '}', '(', ')', '[', ']', '.', '-', '+', '1',
      '2', '3', '4', '5', '6', '7', '8', '9', '0', '\n', '\t', '_',
      ',', ':', ';', '%', '!', '$', '%', '6', '/', '=', '<', '>',
      '^','`','','','&','@','\0'
   };
   char temporal_word[65]; /* this is going to change: it is the word while being read */
   int length;
   int i;
   temporal_word[0]='A';
   for(i=1;i<=64;i++) temporal_word[i]='\0';
   length=0; /* initalize the length (i do not trust 'C') */
   while (temporal_word[length])
     {
     /* temporal_word++;*/                             /*this is a bit risky*/                                    /*buy i hope the computer*/
     length++;
     fread(&temporal_word[length],sizeof(char),1,file);    /*won't have too many problems*/
     i=0;
     while(*non_text[i]!='\0'){
     if(temporal_word[length]==*non_text[i]) goto end;
     i++;
     }
     }
end:
   if(length==1){
   strcpy(str,&temporal_word[1]);
   fseek(file,-1,SEEK_CUR);
   return ;}
   temporal_word[length]='\n';
   strcpy(str,&temporal_word[1]);
   fseek(file,-1,SEEK_CUR);
   return;
}



int rednumber(FILE *src,char str[]){
   int length;
   length=0;
   fread(&str[length],1,1,src);
   while((str[length]<='9' && str[length]>='0') ||
         str[length]=='+' || str[length]=='-' || str[length]=='.'){
     length++;
     fread(&str[length],1,1,src);
     }
   fseek(src,-1,SEEK_CUR);
   return(length);
}



int redspaces(FILE *src,int *line_number){
   int i;
   char spce;
   spce=' ';
   i=0;
   do{
     fread(&spce,1,1,src);
     i++;
     if(spce=='\n') *line_number=*line_number+1;
     }while(spce==' ' || spce=='\n');
   fseek(src,-1,SEEK_CUR);
   return(i-1);
}
