#!/usr/bin/wish8.0
# Tcltexed | Version 2.3 | 1. Feb. 1999 | Martin Strauss
set Tcltexed_Version 2.3 
# A plaintext-editor for LaTeX based on scriptlanguage tcl/tk (8.x) 
#
# Copyright (C) 1998 - Martin Strauss -
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# My email-adress : mys@phi.faveve.uni-stuttgart.de
#######################################################################
# Begin of Tcltexed
#######################################################################
set basepath "[file dirname [info script]]/.."
#######################################################################
# If it doesn't work by it's own please enter here the right
# installationpath to the base of tcltexed (not to the executable)
# and uncommend the next line
# set basepath /usr/local/app/tcltexed-2.2
#######################################################################
# You propably aren't interested to mix my files locations ???
set etcpath $basepath/etc
#######################################################################
# a short test looking if you set your mainpath right
if {![file exists $basepath/bin/tcltexed.tcl]} {
 wm withdraw .
 tk_messageBox -icon error -message "[info script] Tcltexed\nWrong path configuration !\nPlease read the INSTALL file !\n Currently the basepath is set to\n $basepath\nbut I can't find my data there."
 exit
}
#######################################################################
# Where to save options, this should work in the most cases
# without interferring 
switch $tcl_platform(platform) unix {
 set spellfileown $env(HOME)/.tcltexed_spell
 set spellfile $etcpath/tcltexed.sp
} windows {
 switch $tcl_platform(os) "Windows 95" {
  set spellfileown $etcpath/tcltexed_own.sp
  set spellfile $etcpath/tcltexed.sp
 } "Windows NT" {
  set spellfileown $env(USERPROFILE)/tcltexed.sp
  set spellfile $etcpath/tcltexed.sp
 }
}
#######################################################################
# What not to have within a word to spell
# [-0123456789&$^\[\]?\\+*/%=_]
set spell_not "\[-0123456789&$^\\\[\\\]\\\\+*/%=_\]"
set spell_yes "\[ \n\t.,:;!?\\\[\\\]\{\}()\]"



##########################################################################
##########################################################################
# You won't believe it what happens if you ... so leave it the way it is #
##########################################################################
label .l -text "This program adds\n new words for a language\nto current dictionary of tcltexed\n and saves the result.\n english -> 0\ngerman -> 1" 
set language 1
tk_optionMenu .m language 0 1
frame .f1
entry .f1.e 
.f1.e insert 0 sourcefile
button .f1.b -text browse -command {
 .f1.e delete 0 end
 .f1.e insert 0 [tk_getOpenFile]
}
pack .f1.e .f1.b -side left

frame .f2
entry .f2.e
.f2.e insert 0 $spellfileown
button .f2.b -text browse -command {
 .f2.e delete 0 end
 .f2.e insert 0 [tk_getSaveFile]
}
pack .f2.e .f2.b -side left

button .b -text "do it !" -command {
set file [.f1.e get]
set savefile [.f2.e get]

if [file exists $file] then {

 set f [open $file r]
 set Text [read $f]
 close $f

 if [file exists $spellfile$language] then {
  set f [open $spellfile$language r]
  set LISTE [gets $f]
  close $f
 # foreach I $LISTE {set spell_array($I) G}
 }
 if [file exists $spellfileown$language] then {
  set f [open $spellfileown$language r]
  set LISTE [gets $f]
  close $f
 # foreach I $LISTE {set spell_array($I) O}
 }
 set anz 0
 set last ""
 set LISTE [lsort [split $Text $spell_yes]]
 foreach I $LISTE {
  if {[string compare $last $I]!=0} {
   if {[regexp -- $spell_not $I] == 0} {
    if {![info exists spell_array($I)]} {
     if {$I != ""} {
      set spell_array($I) O
      incr anz
  }}}}
  set last $I
 }
 set LISTE ""
 set L [array get spell_array]
 foreach {I V} $L {lappend LISTE $I}
 set f [open $savefile$language w]
 puts $f [lsort $LISTE]
 close $f
 tk_messageBox  -type ok  -message "$anz words added\n from\t$file \n \t$spellfile$language \n\t $spellfileown$language\n to\t $savefile$language"
} { tk_messageBox  -type ok  -message "$file not found"
}
}

pack .l .m .f1 .f2 .b
