/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   stru_fun.c: Restukturieren der REFERENCES-Datenbank (u. Index)
*/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "refs.h"
#include "fd.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "sortix01.h"
#include "ix02_fun.h"
#include "sortix02.h"
#include "ix03_fun.h"
#include "sortix03.h"
#include "ix04_fun.h"
#include "sortix04.h"
#include "interf.h"
#include "initial.h"


 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];
 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;

 extern FILE * fpjournal;
 static FILE * fpjournalneu;
 extern FILE * fpdesc;
 static FILE * fpdescneu;
 extern FILE * fpbuch;
 static FILE * fpbuchneu;
 extern FILE * fpautorjl;
 static FILE * fpautorjlneu;
 extern FILE * fpautorbu;
 static FILE * fpautorbuneu;
 extern FILE * fparchiv;
 static FILE * tmpix;
 static FILE * newix;
 extern FILE * fpquell;
 static FILE * fpquellneu;
 extern FILE * fpstichw;
 static FILE * fpstichwneu;
 extern FILE * fpabs;
 static FILE * fpabsneu;


 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern author_rec             one_aued_rec;
 extern quell_rec              one_quell_rec;
 static keylist_rec            one_key_rec;
 extern abstr_rec              one_abstr_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern keylistpix_rec         ix03rec;
 extern abstrpix_rec           ix04rec;

 static int alles_ok;

 extern char journal_pix_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN + 1];
 static char journal_name_neu[PFAD_LEN + 1];
 extern char book_name[PFAD_LEN + 1];
 static char book_name_neu[PFAD_LEN + 1];
 extern char autorjl_name[PFAD_LEN + 1];
 static char autorjl_name_neu[PFAD_LEN + 1];
 extern char autorbu_name[PFAD_LEN + 1];
 static char autorbu_name_neu[PFAD_LEN + 1];
 extern char quell_pix_name[PFAD_LEN + 1];
 extern char quell_name[PFAD_LEN + 1];
 static char quell_name_neu[PFAD_LEN + 1];
 extern char desc_name[PFAD_LEN + 1];
 static char desc_name_neu[PFAD_LEN + 1];
 extern char stichw_name[PFAD_LEN+1];
 static char stichw_name_neu[PFAD_LEN + 1];
 extern char stichw_pix_name[PFAD_LEN+1];
 extern char abstr_pix_name[PFAD_LEN+1];
 extern char abstr_dat_name[PFAD_LEN+1];
 static char abstr_name_neu[PFAD_LEN + 1];

 static char tmpix_name[PFAD_LEN];
 static char newix_name[PFAD_LEN];
 extern char log_name[PFAD_LEN + 1];
 extern char formdef_name[PFAD_LEN + 1];
 
 static void hauptmenu_stru(void);
 static void zerstoeren(int code);
 static void build_missing_files(void);
 static int dateien_pruefen(void);
 static void make_ix01(void);
 static void make_ix02(void);
 static void make_ix03(void);
 static void copy_files(void);
 static void make_ix04(void);
 static void copy_abstract_files(void);


int stru_fun_main(void)
{
  strlimcpy(journal_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(journal_name_neu,"journal.da$",PFAD_LEN);

  strlimcpy(desc_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(desc_name_neu,"desc.da$",PFAD_LEN);

  strlimcpy(book_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(book_name_neu,"book.da$",PFAD_LEN);

  strlimcpy(autorjl_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(autorjl_name_neu,"autorjl.da$",PFAD_LEN);

  strlimcpy(autorbu_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(autorbu_name_neu,"autorbo.da$",PFAD_LEN);

  strlimcpy(quell_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(quell_name_neu,"source.da$",PFAD_LEN);

  strlimcpy(stichw_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(stichw_name_neu,"keyw.da$",PFAD_LEN);

  strlimcpy(abstr_name_neu,rdbpfad,PFAD_LEN);
  strlimcat(abstr_name_neu,"abst.da$",PFAD_LEN);

  strlimcpy(tmpix_name,rdbpfad,PFAD_LEN);
  strlimcat(tmpix_name,"tmp01_r.ix",PFAD_LEN);

  strlimcpy(newix_name,rdbpfad,PFAD_LEN);
  strlimcat(newix_name,"new01_r.ix",PFAD_LEN);

  hauptmenu_stru();
  return 1;
}

static void hauptmenu_stru(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  
  option = 0;
  while (option < 8)
  {
     strcpy(ein,"menu");
     wrtxt("\nMenu: rebuild database [i/r/a/d/c/1/2/q]\n");
     option = menu_wahl(ein,
       "[i] rebuild index files only\n"
       "[r] restructure database and index files\n"
       "[a] rebuild abstract index file\n"
       "[d] restructure abstract database and index files\n"
       "[c] create missing database and index files\n"
       "[1] destroy database files but not format definition database\n"
       "[2] destroy database files and format definition database\n"
       "[q] quit"
       );
     if (option==1) /* [i] */
     {
       if (dateien_pruefen())
       {
          logdatei_oeffnen();
          logdatei_schreiben("Rebuilding index files");
          make_ix01();
          make_ix02();
          make_ix03();
          logdatei_schliessen();
          sprintf(wrtxtbu,"\n(Reconstruction of index files complete, please "
                 "read %s)\n",log_name);
          wrtxt(wrtxtbu);
       }
     }
     if (option==2) /* [r] */
     {
       if (dateien_pruefen())
       {
          logdatei_oeffnen();
          logdatei_schreiben("Rebuilding index files");
          make_ix01();
          make_ix02();
          make_ix03();
          copy_files();
          logdatei_schliessen();
          sprintf(wrtxtbu,"\n(Reconstruction of index and database files "
                 "complete, please read %s)\n",log_name);
          wrtxt(wrtxtbu);
       }
     }
     if (option==3) /* [a] */
     {
           logdatei_oeffnen();
           logdatei_schreiben("Rebuilding abstract index file");
           make_ix04();
           logdatei_schliessen();
           sprintf(wrtxtbu,"\n(Reconstruction of abstract index file complete, "
                    "please read %s)\n",log_name);
           wrtxt(wrtxtbu);
     }
     if (option==4) /* [d] */
     {
           logdatei_oeffnen();
           logdatei_schreiben("Rebuilding abstract index and database files");
           make_ix04();
           copy_abstract_files();
           logdatei_schliessen();
           sprintf(wrtxtbu,"\n(Reconstruction of abstract index and "
             "database files complete, "
             "please read %s)\n",log_name);
           wrtxt(wrtxtbu);
     }
     if (option==5) /* [c] */
     {
       logdatei_oeffnen();
       logdatei_schreiben("Creating missing index and database files");
       build_missing_files();
       logdatei_schliessen();
     }
     if (option==6) /* [1] */
     {
       wrtxt("\nCaution - this is a dangerous operation\n");
       zerstoeren(1);
     }
     if (option==7) /* [2] */
     {
       wrtxt("\nCaution - this is a dangerous operation\n");
       zerstoeren(2);
     }
  }

}



static void zerstoeren(int code)
{
    if (!do_delete_yn())
    {
       wrtxt("\n(nothing deleted)\n");
       return;
    }
   if (isfile(journal_name)) remove(journal_name);
   if (isfile(desc_name)) remove(desc_name);
   if (isfile(journal_pix_name)) remove(journal_pix_name);
   if (isfile(autorjl_name)) remove(autorjl_name);
   if (isfile(autorbu_name)) remove(autorbu_name);
   if (isfile(book_name)) remove(book_name);
   if (isfile(stichw_name)) remove(stichw_name);
   if (isfile(stichw_pix_name)) remove(stichw_pix_name);
   if (isfile(quell_name)) remove(quell_name);
   if (isfile(quell_pix_name)) remove(quell_pix_name);
   if (isfile(abstr_dat_name)) remove(abstr_dat_name);
   if (isfile(abstr_pix_name)) remove(abstr_pix_name);
   if (code==2)
   {
     if (isfile(formdef_name)) remove(formdef_name);
   }
   wrtxt("\n(No more data and index files in current directory)\n");
}

static void build_missing_files(void)
{
    FILE * fp;
    wrtxt("\n");
    if (!isfile(journal_pix_name))
    {
       if ((fp=fopen(journal_pix_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and "
                   "to create %s\n",journal_pix_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(Index file `%s' created)\n",journal_pix_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"Index file `%s' created",journal_pix_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(Index file `%s' found)\n",journal_pix_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"Index file `%s' found",journal_pix_name);
      logdatei_schreiben(wrtxtbu);
    }


    if (!isfile(journal_name))
    {
       if ((fp=fopen(journal_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                    "create %s\n",journal_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",journal_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",journal_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",journal_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",journal_name);
      logdatei_schreiben(wrtxtbu);
    }

    if (!isfile(desc_name))
    {
       if ((fp=fopen(desc_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                    "create %s\n",desc_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",desc_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",desc_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",desc_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found\n",desc_name);
      logdatei_schreiben(wrtxtbu);
    }


    if (!isfile(book_name))
    {
       if ((fp=fopen(book_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to "
                "find and to create %s\n",book_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",book_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",book_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",book_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",book_name);
      logdatei_schreiben(wrtxtbu);
    }

    if (!isfile(autorjl_name))
    {
       if ((fp=fopen(autorjl_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and "
                "to create %s\n",autorjl_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",autorjl_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",autorjl_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",autorjl_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",autorjl_name);
      logdatei_schreiben(wrtxtbu);
    }


    if (!isfile(autorbu_name))
    {
       if ((fp=fopen(autorbu_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
              "create %s\n",autorbu_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",autorbu_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",autorbu_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",autorbu_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",autorbu_name);
      logdatei_schreiben(wrtxtbu);
    }


    if (!isfile(quell_pix_name))
    {
       if ((fp=fopen(quell_pix_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
             "create %s\n",quell_pix_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",quell_pix_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",quell_pix_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",quell_pix_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",quell_pix_name);
      logdatei_schreiben(wrtxtbu);
    }


    if (!isfile(quell_name))
    {
       if ((fp=fopen(quell_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and "
                   "to create %s\n",quell_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",quell_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",quell_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",quell_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",quell_name);
      logdatei_schreiben(wrtxtbu);
    }

    if (!isfile(stichw_pix_name))
    {
       if ((fp=fopen(stichw_pix_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find "
               "and to create %s\n",stichw_pix_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",stichw_pix_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",stichw_pix_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",stichw_pix_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",stichw_pix_name);
      logdatei_schreiben(wrtxtbu);
    }

    if (!isfile(stichw_name))
    {
       if ((fp=fopen(stichw_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                  "create %s\n",stichw_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",stichw_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",stichw_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",stichw_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",stichw_name);
      logdatei_schreiben(wrtxtbu);
    }

    if (!isfile(abstr_dat_name))
    {
       if ((fp=fopen(abstr_dat_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                  "create %s\n",abstr_dat_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",abstr_dat_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",abstr_dat_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",abstr_dat_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",abstr_dat_name);
      logdatei_schreiben(wrtxtbu);
    }
    

    if (!isfile(abstr_pix_name))
    {
       if ((fp=fopen(abstr_pix_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                  "create %s\n",abstr_pix_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",abstr_pix_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",abstr_pix_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",abstr_pix_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",abstr_pix_name);
      logdatei_schreiben(wrtxtbu);
    }



    if (!isfile(formdef_name))
    {
       if ((fp=fopen(formdef_name,"wb"))==NULL)
       {
         fprintf(stderr,"\nFATAL ERROR: Unable to find and to "
                  "create %s\n",formdef_name);
         exit(1);
       }
       fclose(fp);
       sprintf(wrtxtbu,"(File `%s' created)\n",formdef_name);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"File `%s' created",formdef_name);
       logdatei_schreiben(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"(File `%s' found)\n",formdef_name);
      wrtxt(wrtxtbu);
      sprintf(wrtxtbu,"File `%s' found",formdef_name);
      logdatei_schreiben(wrtxtbu);
    }
    wrtxt("(completed)\n");
}

static int dateien_pruefen(void)
{
     if (
         (filesize(journal_name) < 3 * sizeof(one_journal_rec)) ||
         (filesize(quell_name) < 3 * sizeof(one_quell_rec)) ||
         (filesize(stichw_name) < 3 * sizeof(one_key_rec)) ||
         (filesize(abstr_dat_name) < 3 * sizeof(one_abstr_rec))
       )
     {
       sprintf(wrtxtbu,"At least one database file < 3 records, restruct. "
               "not permitted");
       return 0;
     }
     else
     {
        return 1;
     }
}

static void make_ix01(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,ix_zeiger,i;
  char kennz_alt[KENNZIFFER_LEN + 1];
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",journal_name);
    exit(1);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
    exit(1);
  }
  fseek(fpjournal,0L,SEEK_END);
  anzahl_records = ftell(fpjournal) / sizeof(one_journal_rec);
  rewind(fpjournal);
  anzahl_records--;
  sprintf(wrtxtbu,"\n(Writing 1st Version of %s)\n",journal_pix_name);
  wrtxt(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix01rec,0,sizeof(ix01rec));
     fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
     byte_zeiger=ftell(fpjournal);
     rec_zeiger = (byte_zeiger / sizeof(one_journal_rec))-1;
     if (one_journal_rec.in_use==1)
     {
         strcpy(ix01rec.kennziffer,one_journal_rec.kennziffer);
         ix01rec.journal_rptr = rec_zeiger;
         ix01rec.buch_rptr = -1;
         ix01rec.autorjl_rptr = -1;
         ix01rec.autorbu_rptr = -1;
         ix01rec.desc_rptr = -1;
         if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
     }

  }
  fclose(fpjournal);
  fclose(tmpix);

  if (isfile(newix_name)) remove(newix_name);

  domerge01(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);


  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot read %s for eliminating "
            "duplicate entries in index\n",tmpix_name);
     exit(1);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create %s for "
       "eliminating duplicate entries in index\n",newix_name);
     exit(1);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix01rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kennz_alt,"",KENNZIFFER_LEN+1);
  sprintf(wrtxtbu,"(Checking for duplicate key values in `%s')\n",journal_name);
  wrtxt(wrtxtbu);
  sprintf(wrtxtbu,"Checking for duplicate key values in `%s'",journal_name);
  logdatei_schreiben(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix01rec,sizeof(ix01rec),1,tmpix);
     if (strcmp(kennz_alt,ix01rec.kennziffer)!=0)
     {
       if (fwrite(&ix01rec,sizeof(ix01rec),1,newix) < 1) schreibfehler();
     }
     else
     {
       sprintf(wrtxtbu,"Problem: duplicate key `%s' in %s'",
               ix01rec.kennziffer,journal_name);
       logdatei_schreiben(wrtxtbu);
       alles_ok = 0;
     }
     strncpy(kennz_alt,ix01rec.kennziffer,KENNZIFFER_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  /* Record-pointer aus BOOK.DAT eintragen */

  if (!read_write_ix01(newix_name))
  {
     fprintf(stderr,"\nUnexpected ERROR: cannot open %s\n",newix_name);
     exit(1);
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot open %s\n",book_name);
     exit(1);
  }
  fseek(fpbuch,0L,SEEK_END);
  byte_zeiger = ftell(fpbuch);
  anzahl_records = byte_zeiger / sizeof(one_buch_rec);
  anzahl_records--;
  rewind(fpbuch);
  sprintf(wrtxtbu,"(Adding record pointers of %s)\n",book_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
     byte_zeiger = ftell(fpbuch);
     rec_zeiger = (byte_zeiger / sizeof(one_buch_rec)) -1;
     if (one_buch_rec.in_use_bu==1)
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_buch_rec.kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.buch_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           if (fwrite(&ix01rec,sizeof(ix01rec),1,ix01file) < 1) schreibfehler();
        }
     }
  }
  fclose(fpbuch);
  close_ix01();
  /* Record-pointer aus AUTORJL.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     fprintf(stderr,"\nUnexpected ERROR: cannot open %s\n",newix_name);
     exit(1);
  }

  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot open %s\n",autorjl_name);
     exit(1);
  }
  fseek(fpautorjl,0L,SEEK_END);
  byte_zeiger = ftell(fpautorjl);
  anzahl_records = byte_zeiger / sizeof(one_aued_rec);
  anzahl_records--;
  rewind(fpautorjl);
  sprintf(wrtxtbu,"(Adding record pointers of %s)\n",autorjl_name);
  wrtxt(wrtxtbu);


  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
     byte_zeiger = ftell(fpautorjl);
     rec_zeiger = (byte_zeiger / sizeof(one_aued_rec)) -1;
     if ((one_aued_rec.in_use_au==1) && (one_aued_rec.au_i==1))
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_aued_rec.au_kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.autorjl_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           if (fwrite(&ix01rec,sizeof(ix01rec),1,ix01file) < 1) schreibfehler();
        }
     }
  }

  fclose(fpautorjl);
  close_ix01();

  /* Record-pointer aus AUTORBO.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot open %s\n",newix_name);
     exit(1);
  }

  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot open %s\n",autorbu_name);
     exit(1);
  }
  fseek(fpautorbu,0L,SEEK_END);
  byte_zeiger = ftell(fpautorbu);
  anzahl_records = byte_zeiger / sizeof(one_aued_rec);
  anzahl_records--;
  rewind(fpautorbu);
  sprintf(wrtxtbu,"(Adding record pointers of %s)\n",autorbu_name);
  wrtxt(wrtxtbu);


  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
     byte_zeiger = ftell(fpautorbu);
     rec_zeiger = (byte_zeiger / sizeof(one_aued_rec)) -1;
     if ((one_aued_rec.in_use_au==1) && (one_aued_rec.au_i==1))
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_aued_rec.au_kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.autorbu_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           if (fwrite(&ix01rec,sizeof(ix01rec),1,ix01file) < 1) schreibfehler();
        }
     }
  }

  fclose(fpautorbu);
  close_ix01();

  /* Record-pointer aus DESC.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot open %s\n",newix_name);
     exit(1);
  }

  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot open %s\n",desc_name);
     exit(1);
  }
  fseek(fpdesc,0L,SEEK_END);
  byte_zeiger = ftell(fpdesc);
  anzahl_records = byte_zeiger / sizeof(one_desc_rec);
  anzahl_records--;
  rewind(fpdesc);
  sprintf(wrtxtbu,"(Adding record pointers of %s)\n",desc_name);
  wrtxt(wrtxtbu);

   for (i=0;i<=anzahl_records;i++)
   {
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      byte_zeiger = ftell(fpdesc);
      rec_zeiger = (byte_zeiger / sizeof(one_desc_rec)) -1;
      if ((one_desc_rec.in_use==1) && (one_desc_rec.desc_i==1))
      {
         /* Wenn der Schluesselwert nicht gefunden wird? */
         ix_zeiger = locate_ix01(one_desc_rec.kennziffer,&ix01rec);
         if (ix_zeiger > -1)
         {
            ix01rec.desc_rptr = rec_zeiger;
            fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
            if (fwrite(&ix01rec,sizeof(ix01rec),1,ix01file) < 1) schreibfehler();
         }
      }
   }

   fclose(fpdesc);
   close_ix01();

  remove(journal_pix_name);
  if (rename(newix_name,journal_pix_name)!=0)
  {
     fprintf(stderr,"\nERROR: Reconstruction of %s failed\n",
       journal_pix_name);
     exit(1);
  }
}

static void make_ix02(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,i;
  char kuerzel_alt[QUELLKUERZEL_LEN + 1];
  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",quell_name);
     exit(1);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
     exit(1);
  }
  fseek(fpquell,0L,SEEK_END);
  anzahl_records = ftell(fpquell) / sizeof(one_quell_rec);
  rewind(fpquell);
  anzahl_records--;
  sprintf(wrtxtbu,"\n(Writing 1st Version of %s)\n",quell_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix02rec,0,sizeof(ix02rec));
     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
     byte_zeiger=ftell(fpquell);
     rec_zeiger = (byte_zeiger / sizeof(one_quell_rec))-1;
     if (one_quell_rec.in_use_quell == 1)
     {
         strcpy(ix02rec.quell_kuerzel,one_quell_rec.quell_kuerzel);
         ix02rec.quell_rptr = rec_zeiger;
         if (fwrite(&ix02rec,sizeof(ix02rec),1,tmpix) < 1) schreibfehler();
     }
  }
  fclose(tmpix);
  fclose(fpquell);
  if (isfile(newix_name)) remove(newix_name);
  domerge02(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);

  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot read %s for eliminating duplicate "
       "entries in index\n",tmpix_name);
     exit(1);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create %s for eliminating "
       "duplicate entries in index\n",newix_name);
     exit(1);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix02rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kuerzel_alt,"",QUELLKUERZEL_LEN+1);
  sprintf(wrtxtbu,"(Checking for duplicate key values in `%s')\n",quell_name);
  wrtxt(wrtxtbu);
  sprintf(wrtxtbu,"Checking for duplicate key values in `%s'",quell_name);
  logdatei_schreiben(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix02rec,sizeof(ix02rec),1,tmpix);
     if (strcmp(kuerzel_alt,ix02rec.quell_kuerzel)!=0)
     {
       if (fwrite(&ix02rec,sizeof(ix02rec),1,newix) < 1) schreibfehler();
     }
     else
     {
       sprintf(wrtxtbu,"Problem: duplicate key `%s' in `%s'",
               ix02rec.quell_kuerzel,quell_name);
       logdatei_schreiben(wrtxtbu);
       alles_ok = 0;
     }

     strncpy(kuerzel_alt,ix02rec.quell_kuerzel,QUELLKUERZEL_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  remove(quell_pix_name);
  if (rename(newix_name,quell_pix_name)!=0)
  {
     fprintf(stderr,"\nERROR: Reconstruction of %s failed\n",quell_pix_name);
     exit(1);
  }
}



static void make_ix03(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,i;
  char kwfield_alt[KEYWORDS_LEN + 1];
  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",stichw_name);
     exit(1);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
     exit(1);
  }
  fseek(fpstichw,0L,SEEK_END);
  anzahl_records = ftell(fpstichw) / sizeof(one_key_rec);
  rewind(fpstichw);
  anzahl_records--;
  sprintf(wrtxtbu,"\n(Writing 1st Version of %s)\n",stichw_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix03rec,0,sizeof(ix03rec));
     fread(&one_key_rec,sizeof(one_key_rec),1,fpstichw);
     byte_zeiger=ftell(fpstichw);
     rec_zeiger = (byte_zeiger / sizeof(one_key_rec))-1;
     if (one_key_rec.in_use == 1)
     {
         strcpy(ix03rec.keywordsfield,one_key_rec.keywordsfield);
         ix03rec.keywords_rptr = rec_zeiger;
         if (fwrite(&ix03rec,sizeof(ix03rec),1,tmpix) < 1) schreibfehler();
     }
  }
  fclose(tmpix);
  fclose(fpstichw);
  if (isfile(newix_name)) remove(newix_name);
  domerge03(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);




  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot read %s " 
       "for eliminating duplicate entries in index\n",tmpix_name);
     exit(1);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create %s for " 
       "eliminating duplicate entries in index\n",newix_name);
     exit(1);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix03rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kwfield_alt,"",KEYWORDS_LEN+1);
  sprintf(wrtxtbu,"(Checking for duplicate key values in `%s')\n",stichw_name);
  wrtxt(wrtxtbu);
  sprintf(wrtxtbu,"Checking for duplicate key values in `%s'",stichw_name);
  logdatei_schreiben(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix03rec,sizeof(ix03rec),1,tmpix);
     if (strcmp(kwfield_alt,ix03rec.keywordsfield)!=0)
     {
       if (fwrite(&ix03rec,sizeof(ix03rec),1,newix) < 1) schreibfehler();
     }
     else
     {
       sprintf(wrtxtbu,"Problem: duplicate key `%s' in `%s'",
               ix03rec.keywordsfield,stichw_name);
       logdatei_schreiben(wrtxtbu);
       alles_ok = 0;
     }
     strncpy(kwfield_alt,ix03rec.keywordsfield,KEYWORDS_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  remove(stichw_pix_name);
  if (rename(newix_name,stichw_pix_name)!=0)
  {
     fprintf(stderr,"\n(ERROR: Reconstruction " 
       "of %s failed)\n",stichw_pix_name);
     exit(1);
  }

}


static void copy_files(void)
{
  long i, j, byte_zeiger, rec_zeiger, anzahl_records;
  int anzahl_desc;

  logdatei_schreiben("Performing `RestructureDatabase' "
    "(after rebuilding index files),");
  logdatei_schreiben("  this function removes duplicate index files");
  wrtxt("\n(Rebuilding main database)\n");

  if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot " 
       "read %s\n",journal_pix_name);
     exit(1);
  }
  /* temporaere Indexdatei */
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
     exit(1);
  }
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",journal_name);
     exit(1);
  }
  if ((fpjournalneu=fopen(journal_name_neu,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",journal_name_neu);
     exit(1);
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",desc_name);
     exit(1);
  }
  if ((fpdescneu=fopen(desc_name_neu,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",desc_name_neu);
     exit(1);
  }
  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",book_name);
     exit(1);
  }
  if ((fpbuchneu=fopen(book_name_neu,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",book_name_neu);
     exit(1);
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",autorjl_name);
     exit(1);
  }
  if ((fpautorjlneu=fopen(autorjl_name_neu,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot " 
       "create %s\n",autorjl_name_neu);
     exit(1);
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",autorbu_name);
     exit(1);
  }
  if ((fpautorbuneu=fopen(autorbu_name_neu,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot " 
       "create %s\n",autorbu_name_neu);
     exit(1);
  }

  fseek(ix01file,0L,SEEK_END);
  anzahl_records = ftell(ix01file) / sizeof(ix01rec);
  anzahl_records--;
  rewind(ix01file);
  for (i=0;i<=anzahl_records;i++)
  {

      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      if (fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournalneu) < 1) schreibfehler();
      byte_zeiger = ftell(fpjournalneu);
      rec_zeiger = byte_zeiger / sizeof(one_journal_rec);
      ix01rec.journal_rptr = rec_zeiger - 1;

      if (ix01rec.buch_rptr!=-1)
      {
        byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
        fseek(fpbuch,byte_zeiger,SEEK_SET);
        fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
        if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuchneu) < 1) schreibfehler();
        byte_zeiger = ftell(fpbuchneu);
        rec_zeiger = byte_zeiger / sizeof(one_buch_rec);
        ix01rec.buch_rptr = rec_zeiger - 1;
      }

      if (ix01rec.autorjl_rptr!=-1)
      {
        byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
        fseek(fpautorjl,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
        if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjlneu) < 1) schreibfehler();
        byte_zeiger = ftell(fpautorjlneu);
        rec_zeiger = byte_zeiger / sizeof(one_aued_rec);
        ix01rec.autorjl_rptr = rec_zeiger - 1;
        if (one_aued_rec.au_n > 1)
        {
           for (j=2;j<=one_aued_rec.au_n;j++)
           {
               fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
               if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjlneu) < 1) schreibfehler();
           }
        }
      }

      if (ix01rec.autorbu_rptr!=-1)
      {
        byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
        fseek(fpautorbu,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
        if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbuneu) < 1) schreibfehler();
        byte_zeiger = ftell(fpautorbuneu);
        rec_zeiger = byte_zeiger / sizeof(one_aued_rec);
        ix01rec.autorbu_rptr = rec_zeiger - 1;
        if (one_aued_rec.au_n > 1)
        {
           for (j=2;j<=one_aued_rec.au_n;j++)
           {
               fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
               if (fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbuneu) < 1) schreibfehler();
           }
        }
      }

      if (ix01rec.desc_rptr!=-1)
      {
        byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
        fseek(fpdesc,byte_zeiger,SEEK_SET);
        fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
        if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdescneu) < 1) schreibfehler();
        byte_zeiger = ftell(fpdescneu);
        rec_zeiger = byte_zeiger / sizeof(one_desc_rec);
        ix01rec.desc_rptr = rec_zeiger - 1;
        anzahl_desc = one_desc_rec.desc_n;
        if (anzahl_desc > 1)
        {
           for (j=2;j<=anzahl_desc;j++)
           {
               fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
               if (fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdescneu) < 1) schreibfehler();
           }
        }
      }


      if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix) < 1) schreibfehler();
  }

  fclose(ix01file);
  fclose(tmpix);
  fclose(fpjournal);
  fclose(fpjournalneu);
  fclose(fpdesc);
  fclose(fpdescneu);
  fclose(fpbuch);
  fclose(fpbuchneu);
  fclose(fpautorjl);
  fclose(fpautorjlneu);
  fclose(fpautorbu);
  fclose(fpautorbuneu);

  if (isfile(journal_name)) remove(journal_name);
  rename(journal_name_neu,journal_name);
  if (isfile(desc_name)) remove(desc_name);
  rename(desc_name_neu,desc_name);
  if (isfile(book_name)) remove(book_name);
  rename(book_name_neu,book_name);
  if (isfile(autorjl_name)) remove(autorjl_name);
  rename(autorjl_name_neu,autorjl_name);
  if (isfile(autorbu_name)) remove(autorbu_name);
  rename(autorbu_name_neu,autorbu_name);

  if (isfile(journal_pix_name)) remove(journal_pix_name);
  rename(tmpix_name,journal_pix_name);

  /* SOURCE.DAT */
  wrtxt("(Rebuilding database with journal-names)\n");
  if ((ix02file=fopen(quell_pix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",quell_pix_name);
     exit(1);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
    exit(1);
  }

  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",quell_name);
     exit(1);
  }
  if ((fpquellneu=fopen(quell_name_neu,"wb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",quell_name_neu);
    exit(1);
  }

  fseek(ix02file,0L,SEEK_END);
  anzahl_records = ftell(ix02file) / sizeof(ix02rec);
  anzahl_records--;
  rewind(ix02file);
  for (i=0;i<=anzahl_records;i++)
  {

      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpquell,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
      if (fwrite(&one_quell_rec,sizeof(one_quell_rec),1,fpquellneu) < 1) schreibfehler();
      byte_zeiger = ftell(fpquellneu);
      rec_zeiger = byte_zeiger / sizeof(one_quell_rec);
      ix02rec.quell_rptr = rec_zeiger - 1;

      if (fwrite(&ix02rec,sizeof(ix02rec),1,tmpix) < 1) schreibfehler();
  }

  fclose(ix02file);
  fclose(tmpix);
  fclose(fpquell);
  fclose(fpquellneu);

  if (isfile(quell_name)) remove(quell_name);
  rename(quell_name_neu,quell_name);
  if (isfile(quell_pix_name)) remove(quell_pix_name);
  rename(tmpix_name,quell_pix_name);



  /* KEYW.DAT */
  wrtxt("(Rebuilding database with keywords (``thesaurus''))\n");
  if ((ix03file=fopen(stichw_pix_name,"rb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",stichw_pix_name);
    exit(1);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
    exit(1);
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",stichw_name);
    exit(1);
  }
  if ((fpstichwneu=fopen(stichw_name_neu,"wb"))==NULL)
  {
    fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",stichw_name_neu);
    exit(1);
  }

  fseek(ix03file,0L,SEEK_END);
  anzahl_records = ftell(ix03file) / sizeof(ix03rec);
  anzahl_records--;
  rewind(ix03file);
  for (i=0;i<=anzahl_records;i++)
  {

      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_key_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_key_rec,sizeof(one_key_rec),1,fpstichw);
      if (fwrite(&one_key_rec,sizeof(one_key_rec),1,fpstichwneu) < 1) schreibfehler();
      byte_zeiger = ftell(fpstichwneu);
      rec_zeiger = byte_zeiger / sizeof(one_key_rec);
      ix03rec.keywords_rptr = rec_zeiger - 1;

      if (fwrite(&ix03rec,sizeof(ix03rec),1,tmpix) < 1) schreibfehler();
  }

  fclose(ix03file);
  fclose(tmpix);
  fclose(fpstichw);
  fclose(fpstichwneu);

  if (isfile(stichw_name)) remove(stichw_name);
  rename(stichw_name_neu,stichw_name);
  if (isfile(stichw_pix_name)) remove(stichw_pix_name);
  rename(tmpix_name,stichw_pix_name);
}


static void make_ix04(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records, i;
  char kennz_alt[KENNZIFFER_LEN + 1];
  if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected ERROR: cannot read %s\n",abstr_dat_name);
     exit(1);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nUnexpected error: Cannot create %s\n",tmpix_name);
     exit(1);
  }
  fseek(fpabs,0L,SEEK_END);
  anzahl_records=ftell(fpabs)/sizeof(one_abstr_rec);
  rewind(fpabs);
  anzahl_records--;
  sprintf(wrtxtbu,"\n(Writing 1st Version of %s)\n",abstr_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix04rec,0,sizeof(ix04rec));
     fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
     byte_zeiger = ftell(fpabs);
     rec_zeiger=(byte_zeiger/sizeof(one_abstr_rec)) -1;
     if ((one_abstr_rec.in_use==1) && (one_abstr_rec.abstr_i==1))
     {
        strcpy(ix04rec.kennziffer,one_abstr_rec.kennziffer);
        ix04rec.abstr_rptr = rec_zeiger;
        if (fwrite(&ix04rec,sizeof(ix04rec),1,tmpix) < 1) schreibfehler();
     }
  }
  fclose(tmpix);
  fclose(fpabs);
  if (isfile(newix_name)) remove(newix_name);
  domerge04(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);

  /* Eine Kopie des Index erstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: connot read temporary abstract " 
       "index file %s for eliminating duplicate entries\n",tmpix_name);
     exit(1);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create temporary abstract " 
       "index file %s for eliminating duplicate entries\n",newix_name);
     exit(1);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix04rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kennz_alt,"",KENNZIFFER_LEN + 1);
  sprintf(wrtxtbu,"(Checking for duplicate key values in `%s')\n",
          abstr_dat_name);
  wrtxt(wrtxtbu);
  sprintf(wrtxtbu,"Checking for duplicate key values in `%s'",abstr_dat_name);
  logdatei_schreiben(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix04rec,sizeof(ix04rec),1,tmpix);
      if (strcmp(kennz_alt,ix04rec.kennziffer)!=0)
      {
         if (fwrite(&ix04rec,sizeof(ix04rec),1,newix) < 1) schreibfehler();
      }
      else
      {
        sprintf(wrtxtbu,"Problem: duplicate key `%s' in `%s'",
                ix04rec.kennziffer,abstr_dat_name);
        logdatei_schreiben(wrtxtbu);
        alles_ok = 0;
      }
      sprintf(kennz_alt,ix04rec.kennziffer,KENNZIFFER_LEN + 1);
  }
  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);
  remove(abstr_pix_name);
  if (rename(newix_name,abstr_pix_name)!=0)
  {
      fprintf(stderr,"\nERROR: Reconstruction of %s failed\n",
        abstr_pix_name);
      exit(1);
  }
  return;
}

static void copy_abstract_files(void)
{
   long i, byte_zeiger, rec_zeiger, anzahl_records;
   int j;
   logdatei_schreiben("Performing 'AbstractFiles' 'Database' "
                 "(after rebuilding index files),");
   logdatei_schreiben("  this function removes duplicate index files");
   wrtxt("(Rebuilding abstract database file)\n");

   if((ix04file=fopen(abstr_pix_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",abstr_pix_name);
      exit(1);
   }
   if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",tmpix_name);
      exit(1);
   }
   if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nUnexpected ERROR: Cannot read %s\n",abstr_dat_name);
      exit(1);
   }
   if ((fpabsneu=fopen(abstr_name_neu,"wb"))==NULL)
   {
      fprintf(stderr,"\nUnexpected ERROR: Cannot create %s\n",abstr_name_neu);
      exit(1);
   }

   fseek(ix04file,0L,SEEK_END);
   anzahl_records = ftell(ix04file) / sizeof(ix04rec);
   anzahl_records--;
   rewind(ix04file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix04rec,sizeof(ix04rec),1,ix04file);
      byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
      fseek(fpabs,byte_zeiger,SEEK_SET);
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsneu) < 1) schreibfehler();
      byte_zeiger=ftell(fpabsneu);
      rec_zeiger=byte_zeiger / sizeof(one_abstr_rec);
      ix04rec.abstr_rptr = rec_zeiger - 1;
      if (one_abstr_rec.abstr_n > 1)
      {
        for (j=2;j<=one_abstr_rec.abstr_n;j++)
        {
           fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
           if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsneu) < 1) schreibfehler();
           /* hier koennte man noch eine Sicherung einbauen */
        }
      }
      if (fwrite(&ix04rec,sizeof(ix04rec),1,tmpix) < 1) schreibfehler();
   }

   fclose(ix04file);
   fclose(tmpix);
   fclose(fpabs);
   fclose(fpabsneu);

   if (isfile(abstr_dat_name)) remove(abstr_dat_name);
   rename(abstr_name_neu,abstr_dat_name);
   if (isfile(abstr_pix_name)) remove(abstr_pix_name);
   rename(tmpix_name,abstr_pix_name);
   return;
}

