/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable.filters;

import com.izforge.izpack.api.data.ValueFilter;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;

public class CaseStyleFilter
implements ValueFilter {
    private static final long serialVersionUID = 1L;
    private Style style;

    public CaseStyleFilter(Style style) {
        this.style = style;
    }

    public CaseStyleFilter(String style) {
        try {
            this.style = Style.valueOf(style.toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public void validate() throws Exception {
        if (this.style == null) {
            throw new CompilerException("case Filter has been initialized with unknown style");
        }
    }

    @Override
    public String filter(String value, VariableSubstitutor ... substitutors) throws Exception {
        switch (this.style) {
            case LOWER: {
                return value.toLowerCase();
            }
            case UPPER: {
                return value.toUpperCase();
            }
        }
        throw new CompilerException("case Filter has been initialized with unimplemented style");
    }

    public String toString() {
        return "(style: " + this.style.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CaseStyleFilter)) {
            return false;
        }
        return this.style.equals((Object)((CaseStyleFilter)obj).getStyle());
    }

    public static enum Style {
        LOWER,
        UPPER;

    }
}

