/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataDateElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataDateTimeElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataTimeElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Julian {
    String timestamp;
    String zoneId;
    boolean hasDate = false;
    boolean hasTime = false;
    boolean hasTimeZone = false;
    int year = -4713;
    int month = 1;
    int day = 1;
    int dow = 1;
    int hour = 12;
    int minute = 0;
    int second = 0;
    int julianDay = 0;
    double julianTime = 0.0;
    double julianDate = 0.0;
    int localYear = -4713;
    int localMonth = 1;
    int localDay = 1;
    int localDow = 1;
    int localHour = 12;
    int localMinute = 0;
    int localSecond = 0;
    int tzh = 0;
    int tzm = 0;
    static final Pattern DATE_PATTERN = Pattern.compile("([+\\-]?\\d+)-(\\d{2})-(\\d{2})");
    static final Pattern TIME_PATTERN = Pattern.compile("(\\d{2}):(\\d{2})(?:\\:(\\d{2}))?");
    static final Pattern TIMEZONE_PATTERN = Pattern.compile("([+\\-]\\d{2}):?(\\d{2})");

    public static Julian createTime(double d) {
        Julian julian = new Julian();
        julian.julianTime = d;
        julian.hasTime = true;
        double d2 = 0.5 + d;
        julian.hour = (int)(d2 * 24.0);
        julian.minute = (int)(d2 * 1440.0) % 60;
        julian.second = (int)(d2 * 86400.0) % 60;
        julian.timestamp = String.format((Locale)null, "%02d:%02d:%02d", julian.hour, julian.minute, julian.second);
        julian.setLocals();
        return julian;
    }

    public static Julian createDay(int n) {
        Julian julian = new Julian();
        julian.julianDay = n;
        julian.julianDate = n;
        julian.hasDate = true;
        julian.updateYMD(false, n);
        julian.timestamp = String.format((Locale)null, "%d-%02d-%02d", julian.year, julian.month, julian.day);
        julian.setLocals();
        return julian;
    }

    public static Julian createDate(double d) {
        Julian julian = new Julian();
        julian.julianDate = d;
        julian.julianDay = (int)Math.round(d);
        julian.julianTime = d - (double)julian.julianDay;
        julian.hasTime = true;
        julian.hasDate = true;
        julian.updateYMD(false, julian.julianDay);
        double d2 = 0.5 + julian.julianTime;
        julian.hour = (int)(d2 * 24.0);
        julian.minute = (int)(d2 * 1440.0) % 60;
        julian.second = (int)(d2 * 86400.0) % 60;
        julian.timestamp = String.format((Locale)null, "%d-%02d-%02dT%02d:%02d:%02d", julian.year, julian.month, julian.day, julian.hour, julian.minute, julian.second);
        julian.setLocals();
        return julian;
    }

    public static Julian createDate(double d, int n, int n2) {
        Julian julian = Julian.createDate(d);
        julian.adjustTimeZone(n, n2);
        julian.zoneId = String.format((Locale)null, "%s:%02d", Julian.signedTwoDigits(julian.tzh), julian.tzm);
        julian.timestamp = julian.timestamp + julian.zoneId;
        return julian;
    }

    public static Julian createDate(Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return Julian.createDate(calendar);
    }

    public static Julian createDate(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        TimeZone timeZone = calendar.getTimeZone();
        int n = timeZone.getOffset(l);
        Julian julian = new Julian();
        julian.hasDate = true;
        julian.hasTime = true;
        julian.hasTimeZone = true;
        julian.julianDate = DataToolBaseSty.unixEpochMillisToJulianDate(l);
        julian.julianDay = (int)Math.round(julian.julianDate);
        julian.julianTime = julian.julianDate - (double)julian.julianDay;
        julian.localYear = calendar.get(1);
        julian.localMonth = calendar.get(2) + 1;
        julian.localDay = calendar.get(5);
        switch (calendar.get(7)) {
            case 1: {
                julian.localDow = 6;
                break;
            }
            case 2: {
                julian.localDow = 0;
                break;
            }
            case 3: {
                julian.localDow = 1;
                break;
            }
            case 4: {
                julian.localDow = 2;
                break;
            }
            case 5: {
                julian.localDow = 3;
                break;
            }
            case 6: {
                julian.localDow = 4;
                break;
            }
            case 7: {
                julian.localDow = 5;
            }
        }
        julian.localHour = calendar.get(11);
        julian.localMinute = calendar.get(12);
        julian.localSecond = calendar.get(13);
        julian.year = julian.localYear;
        julian.month = julian.localMonth;
        julian.day = julian.localDay;
        julian.dow = julian.localDow;
        julian.hour = julian.localDow;
        julian.minute = julian.localMinute;
        julian.second = julian.localSecond;
        if (n != 0) {
            julian.tzh = n / 3600000;
            julian.tzm = Math.abs(n / 60000) % 60;
            if (julian.tzm != 0) {
                julian.minute -= julian.tzm;
                if (julian.minute < 0) {
                    julian.minute += 60;
                    --julian.hour;
                } else if (julian.minute >= 60) {
                    julian.minute -= 60;
                    ++julian.hour;
                }
            }
            if (julian.tzh != 0) {
                julian.hour -= julian.tzh;
            }
            if (julian.hour < 0) {
                julian.hour += 23;
            } else if (julian.hour >= 24) {
                julian.hour -= 24;
            }
            julian.updateYMD(false, julian.julianDay);
            julian.dow = julian.julianDay % 7;
        }
        julian.zoneId = String.format((Locale)null, "%s:%02d", Julian.signedTwoDigits(julian.tzh), julian.tzm);
        julian.timestamp = String.format((Locale)null, "%d-%02d-%02dT%02d:%02d:%02d%s", julian.localYear, julian.localMonth, julian.localDay, julian.localHour, julian.localMinute, julian.localSecond, julian.zoneId);
        return julian;
    }

    public static Julian createDay(Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return Julian.createDay(calendar);
    }

    public static Julian createDay(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        Julian julian = new Julian();
        julian.hasDate = true;
        julian.hasTime = false;
        julian.hasTimeZone = false;
        julian.julianDay = (int)Math.round(DataToolBaseSty.unixEpochMillisToJulianDate(l));
        julian.julianDate = julian.julianDay;
        julian.year = calendar.get(1);
        julian.month = calendar.get(2) + 1;
        julian.day = calendar.get(5);
        switch (calendar.get(7)) {
            case 1: {
                julian.dow = 6;
                break;
            }
            case 2: {
                julian.dow = 0;
                break;
            }
            case 3: {
                julian.dow = 1;
                break;
            }
            case 4: {
                julian.dow = 2;
                break;
            }
            case 5: {
                julian.dow = 3;
                break;
            }
            case 6: {
                julian.dow = 4;
                break;
            }
            case 7: {
                julian.dow = 5;
            }
        }
        julian.setLocals();
        julian.timestamp = String.format((Locale)null, "%d-%02d-%02d", julian.year, julian.month, julian.day);
        return julian;
    }

    public static Julian createTime(Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return Julian.createTime(calendar);
    }

    public static Julian createTime(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        Julian julian = new Julian();
        julian.hasDate = false;
        julian.hasTime = true;
        julian.hasTimeZone = false;
        julian.julianDate = DataToolBaseSty.unixEpochMillisToJulianDate(l);
        julian.julianDay = (int)Math.round(julian.julianDate);
        julian.julianTime = julian.julianDate - (double)julian.julianDay;
        julian.julianDay = 0;
        julian.julianDate = julian.julianTime;
        julian.hour = calendar.get(11);
        julian.minute = calendar.get(12);
        julian.second = calendar.get(13);
        julian.setLocals();
        julian.timestamp = String.format((Locale)null, "%02d:%02d:%02d", julian.localHour, julian.localMinute, julian.localSecond);
        return julian;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Julian create(String string) throws IllegalArgumentException {
        int n;
        Julian julian = null;
        Matcher matcher = DATE_PATTERN.matcher(string);
        int n2 = 0;
        if (matcher.find() && matcher.start() == 0) {
            julian = new Julian();
            julian.hasDate = true;
            julian.year = Integer.parseInt(matcher.group(1));
            julian.month = Integer.parseInt(matcher.group(2));
            julian.day = Integer.parseInt(matcher.group(3));
            n2 = matcher.end();
            if (n2 + 1 < string.length() && ((n = (int)string.charAt(n2)) == 84 || n == 32)) {
                ++n2;
            }
            julian.calcJulianDate();
        }
        if ((matcher = TIME_PATTERN.matcher(string)).find(n2)) {
            n = matcher.start();
            if (n != n2) {
                throw new IllegalArgumentException(String.format("Invalid argument (time) '%s'", string));
            }
            if (julian == null) {
                julian = new Julian();
            }
            julian.hasTime = true;
            julian.hour = Integer.parseInt(matcher.group(1));
            julian.minute = Integer.parseInt(matcher.group(2));
            String string2 = matcher.group(3);
            if (string2 != null && !string2.isEmpty()) {
                julian.second = Integer.parseInt(string2);
            }
            n2 = matcher.end();
            if (julian.hasDate) {
                String string3 = string.substring(matcher.end());
                if (!string3.isEmpty()) {
                    if (string3.equals("Z")) {
                        julian.hasTimeZone = true;
                    } else {
                        matcher = TIMEZONE_PATTERN.matcher(string3);
                        if (!matcher.matches()) throw new IllegalArgumentException(String.format("Invalid argument (time zone) '%s'", string));
                        julian.hasTimeZone = true;
                        julian.tzh = Integer.parseInt(matcher.group(1));
                        julian.tzm = Integer.parseInt(matcher.group(2));
                    }
                }
            } else if (n2 != string.length()) {
                throw new IllegalArgumentException(String.format("Invalid argument (time) '%s'", string));
            }
        }
        if (julian == null) {
            throw new IllegalArgumentException(String.format("Invalid date/time argument '%s'", string));
        }
        if (julian.hasDate) {
            if (julian.hasTime) {
                julian.calcJulianDate();
                if (julian.hasTimeZone) {
                    julian.zoneId = String.format((Locale)null, "%s:%02d", Julian.signedTwoDigits(julian.tzh), julian.tzm);
                    julian.timestamp = String.format((Locale)null, "%d-%02d-%02dT%02d:%02d:%02d%s", julian.localYear, julian.localMonth, julian.localDay, julian.localHour, julian.localMinute, julian.localSecond, julian.zoneId);
                    return julian;
                } else {
                    julian.timestamp = String.format((Locale)null, "%d-%02d-%02dT%02d:%02d:%02d", julian.year, julian.month, julian.day, julian.hour, julian.minute, julian.second);
                }
                return julian;
            } else {
                julian.calcJulianDay();
                julian.timestamp = string;
            }
            return julian;
        } else {
            julian.calcJulianTime();
            julian.timestamp = string;
        }
        return julian;
    }

    public Calendar toCalendar() {
        Calendar.Builder builder = new Calendar.Builder();
        builder.setCalendarType("iso8601");
        if (this.hasDate) {
            builder.setDate(this.localYear, this.localMonth - 1, this.localDay);
        }
        if (this.hasTime) {
            builder.setTimeOfDay(this.localHour, this.localMinute, this.localSecond);
        }
        if (this.hasTimeZone) {
            String string = this.tzm == 0 ? String.format("GMT%+2d", this.tzh) : String.format("GMT%s%02d", Julian.signedTwoDigits(this.tzh), this.tzm);
            builder.setTimeZone(TimeZone.getTimeZone(string));
        }
        return builder.build();
    }

    public ZoneOffset getZoneOffset() {
        if (this.hasTimeZone) {
            try {
                return ZoneOffset.ofHoursMinutes(this.tzh, this.tzh < 0 ? -Math.abs(this.tzm) : Math.abs(this.tzm));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public ZoneId getZoneId() {
        if (this.zoneId != null) {
            try {
                return ZoneId.of(this.zoneId);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public LocalDateTime getLocalDateTime() {
        if (this.hasDate && this.hasTime) {
            try {
                return LocalDateTime.of(this.localYear, this.localMonth, this.localDay, this.localHour, this.localMinute, this.localSecond);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public LocalDate getLocalDate() {
        if (this.hasDate) {
            try {
                return LocalDate.of(this.localYear, this.localMonth, this.localDay);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public LocalTime getLocalTime() {
        if (this.hasTime) {
            try {
                return LocalTime.of(this.localHour, this.localMinute, this.localSecond);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public Temporal getTemporal() {
        LocalDateTime localDateTime;
        Comparable<ChronoLocalDateTime<?>> comparable = localDateTime = this.getLocalDateTime();
        if (localDateTime == null) {
            LocalDate localDate = this.getLocalDate();
            comparable = localDate == null ? this.getLocalTime() : localDate;
        } else {
            ZoneId zoneId = this.getZoneId();
            if (zoneId != null) {
                try {
                    comparable = ZonedDateTime.of(localDateTime, zoneId);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
        }
        return comparable;
    }

    public static String signedTwoDigits(int n) {
        return n < 0 ? String.format((Locale)null, "%02d", n) : String.format((Locale)null, "+%02d", n);
    }

    public TeXObjectList createTeXFormat(TeXParserListener teXParserListener) {
        TeXObjectList teXObjectList = teXParserListener.createStack();
        if (this.hasDate) {
            if (this.hasTime) {
                teXObjectList.add(new TeXCsRef("DataToolDateTimeFmt"));
                Group group = teXParserListener.createGroup();
                teXObjectList.add(group);
                group.add(TeXParserUtils.createGroup(teXParserListener, new UserNumber(this.localYear)));
                group.add(teXParserListener.createGroup(String.format("%02d", this.localMonth)));
                group.add(teXParserListener.createGroup(String.format("%02d", this.localDay)));
                group.add(TeXParserUtils.createGroup(teXParserListener, new UserNumber(this.localDow)));
                group = teXParserListener.createGroup();
                teXObjectList.add(group);
                group.add(teXParserListener.createGroup(String.format("%02d", this.localHour)));
                group.add(teXParserListener.createGroup(String.format("%02d", this.localMinute)));
                group.add(teXParserListener.createGroup(String.format("%02d", this.localSecond)));
                group = teXParserListener.createGroup();
                teXObjectList.add(group);
                group.add(teXParserListener.createGroup(Julian.signedTwoDigits(this.tzh)));
                group.add(teXParserListener.createGroup(String.format("%02d", this.tzm)));
            } else {
                teXObjectList.add(new TeXCsRef("DataToolDateFmt"));
                teXObjectList.add(TeXParserUtils.createGroup(teXParserListener, new UserNumber(this.localYear)));
                teXObjectList.add(teXParserListener.createGroup(String.format("%02d", this.localMonth)));
                teXObjectList.add(teXParserListener.createGroup(String.format("%02d", this.localDay)));
                teXObjectList.add(TeXParserUtils.createGroup(teXParserListener, new UserNumber(this.localDow)));
            }
        } else {
            teXObjectList.add(new TeXCsRef("DataToolTimeFmt"));
            teXObjectList.add(teXParserListener.createGroup(String.format("%02d", this.localHour)));
            teXObjectList.add(teXParserListener.createGroup(String.format("%02d", this.localMinute)));
            teXObjectList.add(teXParserListener.createGroup(String.format("%02d", this.localSecond)));
        }
        return teXObjectList;
    }

    public String getTeXFormatCode() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasDate) {
            if (this.hasTime) {
                stringBuilder.append("\\DataToolDateTimeFmt{");
                stringBuilder.append('{');
                stringBuilder.append(this.localYear);
                stringBuilder.append('}');
                stringBuilder.append(String.format("{%02d}", this.localMonth));
                stringBuilder.append(String.format("{%02d}", this.localDay));
                stringBuilder.append('{');
                stringBuilder.append(this.localDow);
                stringBuilder.append('}');
                stringBuilder.append("}{");
                stringBuilder.append(String.format("{%02d}", this.localHour));
                stringBuilder.append(String.format("{%02d}", this.localMinute));
                stringBuilder.append(String.format("{%02d}", this.localSecond));
                stringBuilder.append("}{");
                stringBuilder.append('{');
                stringBuilder.append(Julian.signedTwoDigits(this.tzh));
                stringBuilder.append('}');
                stringBuilder.append(String.format("{%02d}", this.tzm));
                stringBuilder.append('}');
            } else {
                stringBuilder.append("\\DataToolDateFmt");
                stringBuilder.append('{');
                stringBuilder.append(this.localYear);
                stringBuilder.append('}');
                stringBuilder.append(String.format("{%02d}", this.localMonth));
                stringBuilder.append(String.format("{%02d}", this.localDay));
                stringBuilder.append('{');
                stringBuilder.append(this.localDow);
                stringBuilder.append('}');
            }
        } else {
            stringBuilder.append("\\DataToolTimeFmt");
            stringBuilder.append(String.format("{%02d}", this.localHour));
            stringBuilder.append(String.format("{%02d}", this.localMinute));
            stringBuilder.append(String.format("{%02d}", this.localSecond));
        }
        return stringBuilder.toString();
    }

    public DatumElement toDatumElement(TeXParserListener teXParserListener, TeXObject teXObject, boolean bl) {
        TeXObject teXObject2 = teXObject;
        AbstractTeXObject abstractTeXObject = this.hasDate ? (this.hasTime ? new TeXFloatingPoint(this.julianDate) : new UserNumber(this.julianDay)) : new TeXFloatingPoint(this.julianTime);
        TeXObjectList teXObjectList = teXParserListener.createStack();
        teXObjectList.add(new TeXCsRef("DTLtemporalvalue"));
        teXObjectList.add(TeXParserUtils.createGroup(teXParserListener, abstractTeXObject));
        teXObjectList.add(teXParserListener.createGroup(this.timestamp));
        if (bl) {
            teXObject2 = this.createTeXFormat(teXParserListener);
        }
        return new DatumElement(teXObject2, (TeXNumber)((Object)abstractTeXObject), teXObjectList, null, this, this.getDatumType());
    }

    public DataElement toDataElement(TeXParserListener teXParserListener, TeXObject teXObject, boolean bl, boolean bl2) {
        if (bl) {
            return this.toDatumElement(teXParserListener, teXObject, bl2);
        }
        if (this.hasDate) {
            if (this.hasTime) {
                return new DataDateTimeElement(this.julianDate, teXObject);
            }
            return new DataDateElement(this.julianDay, teXObject);
        }
        return new DataTimeElement(this.julianTime, teXObject);
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    public boolean hasDate() {
        return this.hasDate;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public boolean hasTimeZone() {
        return this.hasTimeZone;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    public double getJulianTime() {
        return this.julianTime;
    }

    public double getJulianDate() {
        return this.julianDate;
    }

    public DatumType getDatumType() {
        if (this.hasDate) {
            if (this.hasTime) {
                return DatumType.DATETIME;
            }
            return DatumType.DATE;
        }
        return DatumType.TIME;
    }

    public long toUnixEpochMillis() {
        return DataToolBaseSty.unixEpochMillisFromJulianDate(this.julianDate);
    }

    public long toUnixEpochSeconds() {
        return DataToolBaseSty.unixEpochSecondsFromJulianDate(this.julianDate);
    }

    public int getYear(boolean bl) {
        return bl ? this.localYear : this.year;
    }

    public int getMonth(boolean bl) {
        return bl ? this.localMonth : this.month;
    }

    public int getDayOfMonth(boolean bl) {
        return bl ? this.localDay : this.day;
    }

    public int getDayOfWeek(boolean bl) {
        return bl ? this.localDow : this.dow;
    }

    public int getHour(boolean bl) {
        return bl ? this.localHour : this.hour;
    }

    public int getMinute(boolean bl) {
        return bl ? this.localMinute : this.minute;
    }

    public int getSecond(boolean bl) {
        return bl ? this.localSecond : this.second;
    }

    public int getTimeZoneHour() {
        return this.tzh;
    }

    public int getTimeZoneMinute() {
        return this.tzm;
    }

    public void adjustTimeZone(int n, int n2) {
        this.setLocals();
        int n3 = this.julianDay;
        if (n2 != 0) {
            this.localMinute += n2;
            if (this.localMinute < 0) {
                this.localMinute += 60;
                --this.localHour;
            } else if (this.localMinute >= 60) {
                this.localMinute -= 60;
                ++this.localHour;
            }
        }
        if (n != 0) {
            this.localHour += n;
        }
        if (this.localHour < 0) {
            this.localHour += 23;
            --this.localDow;
            --n3;
            if (this.localDow < 0) {
                this.localDow += 7;
            }
        } else if (this.localHour >= 24) {
            this.localHour -= 24;
            this.localDow = (this.localDow + 1) % 7;
            ++n3;
        }
        if (n3 != this.julianDay) {
            this.updateYMD(true, n3);
        }
        this.tzh = n;
        this.tzm = n2;
    }

    public void adjustTimeZone(TimeZone timeZone) {
        int n = timeZone.getOffset(this.toUnixEpochMillis());
        int n2 = n / 3600000;
        int n3 = Math.abs(n) / 60000 - Math.abs(n2 * 60);
        this.adjustTimeZone(n2, n3);
    }

    protected void setLocals() {
        this.localYear = this.year;
        this.localMonth = this.month;
        this.localDay = this.day;
        this.localHour = this.hour;
        this.localMinute = this.minute;
        this.localSecond = this.second;
        this.localDow = this.dow;
    }

    protected void calcJulianDate() {
        this.calcJulianDay();
        if (this.tzm != 0) {
            this.minute -= this.tzm;
            if (this.minute < 0) {
                this.minute += 60;
                --this.hour;
            } else if (this.minute >= 60) {
                this.minute -= 60;
                ++this.hour;
            }
        }
        if (this.tzh != 0) {
            this.hour -= this.tzh;
        }
        if (this.hour < 0) {
            this.hour += 23;
            --this.julianDay;
        } else if (this.hour >= 24) {
            this.hour -= 24;
            ++this.julianDay;
        }
        this.calcJulianTime();
        this.julianDate = (double)this.julianDay + this.julianTime;
        this.dow = this.julianDay % 7;
    }

    protected void calcJulianDay() {
        this.setLocals();
        this.julianDay = this.day - 32075 + 1461 * (this.year + 4800 + (this.month - 14) / 12) / 4 + 367 * (this.month - 2 - (this.month - 14) / 12 * 12) / 12 - 3 * ((this.year + 4900 + (this.month - 14) / 12) / 100) / 4;
        this.dow = this.localDow = this.julianDay % 7;
    }

    protected void calcJulianTime() {
        this.julianTime = ((double)this.hour - 12.0) / 24.0 + (double)this.minute / 1440.0 + (double)this.second / 86400.0;
    }

    protected void updateYMD(boolean bl, int n) {
        int n2 = n + 68569;
        int n3 = 4 * n2 / 146097;
        int n4 = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
        n2 = n2 - 1461 * n4 / 4 + 31;
        int n5 = 80 * n2 / 2447;
        int n6 = n2 - 2447 * n5 / 80;
        n2 = n5 / 11;
        n5 = n5 + 2 - 12 * n2;
        n4 = 100 * (n3 - 49) + n4 + n2;
        if (bl) {
            this.localYear = n4;
            this.localMonth = n5;
            this.localDay = n6;
        } else {
            this.year = n4;
            this.month = n5;
            this.day = n6;
        }
    }

    public String toString() {
        return String.format("%s[timestamp=%s,hasDate=%s,hasTime=%s,hasTimeZone=%s,year=%d,month=%d,day=%d,dow=%d,hour=%d,minute=%d,second=%d,localYear=%d,localMonth=%d,localDay=%d,localDow=%d,localHour=%d,localMinute=%d,localSecond=%d,tzh=%d,tzm=%d,jdn=%d,jt=%f,jdt=%f]", this.getClass().getSimpleName(), this.timestamp, this.hasDate, this.hasTime, this.hasTimeZone, this.year, this.month, this.day, this.dow, this.hour, this.minute, this.second, this.localYear, this.localMonth, this.localDay, this.localDow, this.localHour, this.localMinute, this.localSecond, this.tzh, this.tzm, this.julianDay, this.julianTime, this.julianDate);
    }
}

