/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file is the header file for token.c and those files which
 * use it: it contains the prototypes for the many token handling
 * routines.
 */

void make_empty_list(token_list *tl);

char is_empty(token_list *tl);

void append_token(token_list *tl,token tk);

void ensure_length(token_list *tl,int len);

token first_token(token_list *tl);

void remove_first(token_list *tl);

void remove_last(token_list *tl);

void free_list(token_list *tl);

void copy_list(token_list *td,token_list *ts);

void prepend_list(token_list *td,token_list *ts);

void append_list(token_list *td,token_list *ts);

char compare_list(token_list *t1,token_list *t2);

unsigned char *token_list_to_string(token_list *td);
