/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file contains the stack handling routines.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "simple.h"
#include "token.h"
#include "stack.h"

#define ALLUNIT 16

void
make_empty_stack(token_stack *ts)
     /* Create a new, empty, stack. */
{
  ts->s=NULL;
  ts->depth=0;
  ts->alldepth=0;
}

void
push_on_stack(token_stack *ts,token_list *tl)
     /* Push tl on stack ts. */
{
  if (ts->depth>=ts->alldepth) {
    if ((ts->s=REALLOC(ts->s,(ts->alldepth+=ALLUNIT)*sizeof(token_list)))
	==NULL)
      fatal(0,"Out of memory!");
  }
  make_empty_list(ts->s+ts->depth);
  copy_list(ts->s+ts->depth,tl);
  ts->depth++;
}

void
last_from_stack(token_stack *ts,token_list *tl)
     /* Return in tl the top list of the stack ts. */
{
  if (ts->depth==0)
    fatal(0,"Stack underflow.");
  copy_list(tl,ts->s+(ts->depth-1));
}

void
pop_from_stack(token_stack *ts)
     /* Remove the top list of the stack ts. */
{
  if (ts->depth==0)
    fatal(0,"Stack underflow.");
  free_list(ts->s+(ts->depth-1));
  ts->depth--;
}

int
stack_depth(token_stack *ts)
     /* Return the depth of the stack ts. */
{
  return ts->depth;
}

typedef struct stack_dict_entry {
  token_stack stk;
  char *name;
} stack_dict_entry;

stack_dict_entry *stack_dict = NULL;
int stack_dict_len = 0;

token_stack *
identify_stack(char *name)
     /* Convert a stack name to a stack, creating if it name is
      * unknown. */
{
  int i;
  for (i=0;i<stack_dict_len;i++)
    if (strcmp(stack_dict[i].name,name)==0)
      return &stack_dict[i].stk;
  if ((stack_dict=REALLOC(stack_dict,((++stack_dict_len)
				      *sizeof(stack_dict_entry))))
      ==NULL)
    fatal(0,"Out of memory!");
  make_empty_stack(&stack_dict[stack_dict_len-1].stk);
  stack_dict[stack_dict_len-1].name=malloc(strlen(name)+1);
  strcpy(stack_dict[stack_dict_len-1].name,name);
  return &stack_dict[stack_dict_len-1].stk;
}
