#!/usr/local/bin/perl -P
# This program converts a PostScript file written by lametex -t and converts it
# into a plain text file.
#
# Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
# edit and use as long as this copyright statement remains intact.

# Cycle through all the input, breaking everything apart into word. Interpret
# each word, building together a line of word and accumulating information
# about the margins, line spacing, indentation, and justification.
$justify = 102;
$firstpage=1;
while(<>)
{
  split;    # Breaks this line up into tokens by whitespace.
  foreach (@_) {
     if(/^def$/) { &FLUSHLINE; &DEFINE; }
     elsif(/^NW$/) { &NEXTWORD; }
     elsif(/^NEWPARA$/) { &NEWPARA; }
     elsif(/^BASELINESKIP$/) { &FLUSHLINE; $baselineskip = $last; }
     elsif(/^NewFont$/) { if ($lastlast eq "true") { $glue = 1;} }
     elsif(/^ENDPAGE/) { &FLUSHLINE;}
     elsif(/^STARTPAGE/) {
            if($firstpage==1) { $firstpage=0; }
            else { printf("\n\014\n");} }
     elsif(/^BULLET/) { $bullet=1; }
     elsif(/^VERBATIM/) { &VERBATIM; }
     elsif(/^ENUMERATE/) { 
           $_ = substr($last,1,length($last)-2);  # Take off parenthesis.
           s/\\\\/"/;
           s/\\\(/\(/;
           s/\\\)/\)/;
           $enum = $_; }

    
     $lastlast=$last;
     $last=$_;
  }
}

&FLUSHLINE;   # Don't forget to print the last line!

###############################################
# Handle the "def" keyword.
sub DEFINE
{
  $lastlast = substr($lastlast,1);
  eval("\$$lastlast = $last");
}

###############################################
# Handle the next word to be printed.
sub NEXTWORD
{
  $_ = $last;
  if($last =~ /^\((\\\\)\)$/) {
     $_ = "\\";
  } else {
     $_ = substr($_,1,length($_)-2);  # Take off parenthesis
  }
  s/\\\\/\"/;
  $word = $_;
  if(length($word) + $linelength + 1 >
      80 - int($leftmargin/9) - int($rightmargin/9)) {
    &PRINTLINE($justify);
  }
  if($glue) {
    $glue = pop(@line);
    push(@line, $glue.$word);
    $glue = 0;
  } else {
    push(@line, $word);
  }
  $linelength += length($word)+1;
}

###############################################
# Handle the next verbatim line to be printed.
sub VERBATIM
{
  $_ = $last;
  $_ = substr($_,1,length($_)-2);  # Take off parenthesis

  while(/\\\\/) {
     s/\\\\/\"/;
  }
  while(/\\_/) {
     s/\\_/ /;
  }
  while(/\\\(/) {
     s/\\\(/\(/;
  }
  while(/\\\)/) {
     s/\\\)/\)/;
  }
  $word = $_;
  print "$word\n";
}

###############################################
# Forces a print of the world list before margin space filled
sub FLUSHLINE
{
  if($linelength > 0) {
     if($justify == 102) {
        &PRINTLINE(108);     # Don't fully justify this line.
     } else {
       &PRINTLINE($justify);
     }
  }
}

###############################################
# Make a new paragraph
sub NEWPARA
{
  &FLUSHLINE;
  if($vspace > 0) {
     for($x=0; $x < $vspace/14; $x++) {
        print "\n";
      }
     $vspace = 0;
     if($para > 0) {
        $leftmargin -= $para;
        $para = 0;
     }
  } else {
     for($x=0; $x < $parskip/14; $x++) {
        print "\n";
     }
    if($justify != 99) {
       $para=$parindent;
       $leftmargin += $para;
    }
  }
}

###############################################
# Print the current line to stdout with the given justification.
sub PRINTLINE {
   $justification = shift;

   for($x=0; $x < int($leftmargin/9) - length($enum) - 1;
	   $x++) {
     if($bullet && $x == int($leftmargin/9) - 2) {
        print "*";
        $bullet=0;
     } else {
        print " ";
     }
   }
   if($enum) {
     print $enum;
     $enum="";
   }
   print " ";
   if($justification == 114) {     # flushright
      for($x=0; $x <
           80 - int($rightmargin/9) - int($leftmargin/9) - $linelength; $x++) {
         print " ";
      }
   } elsif($justification == 99) { # centered
      for($x=0;$x <
           (80 - int($rightmargin/9) - int($leftmargin/9) - $linelength)/2;
            $x++) {
         print " ";
      }
   }

   $slack = 80 - int($leftmargin/9) - int($rightmargin/9) - $linelength;
   $spaces = 1;
   $count = 0;
   foreach (@line) {
      $count++;                      # fully justified?
      if($justification == 102 && $slack > 0 && $count > 1) {
          while($count > $spaces / ($slack+1) * ($#line + 1)) {
             print " ";
             $spaces++;
          }
      }
      print;
      print " ";
  }

  for($x=0; $x < $baselineskip/14; $x++) {
     print "\n";
  }

  if($para > 0) {
    $leftmargin -= $para;
    $para = 0;
  }

  $linelength = 0;   # Empty the current line variable.
  $#line = -1;
}

