#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <unistd.h>
#include "bibview.h"


#define YYSTYPE char

#define __RUNTIME_YYMAXDEPTH
#define YYMAXDEPTH 1000

#define MAX_UEBERGABE  20000

char uebergabe[MAX_UEBERGABE];
int ueIdx = 0;

FILE *tempDatei;
extern FILE *yyin;
extern YY_NEW_FILE;
extern int yy_init;

extern int fld_indent, cont_indent, newline_indent;
extern int max_fields;

typedef struct _Snode {
                       char inh;
                       int slen;
                       struct _Snode *next;
} Snode;

/*******************************************/
/* Globale Variablen                       */
/*******************************************/

int yynline;
int yynflexcalls;
int yynerrs;
char errorstr[MAX_ERRORSTRLEN];

/*******************************************/
/* Lokale Variablen                        */
/*******************************************/

static Snode *key = NULL;            
static Snode *fldname = NULL;       
static Snode *fldcont = NULL;      

static char errstr[MAX_ERRLINELENGTH];
#ifdef GERMAN
static char *anfhelpstr = 
  "Es wurden leider Fehler entdeckt\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d Fehler";
#else
static char *anfhelpstr = 
  "Sorry, but there were syntax errors:\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d errors";
#endif
static CardType cardtype;
static CardData *card = NULL;
static UserFld *helpufield = NULL;
static String helpFldName = NULL;
static String errkey;
static Errcode err;
static BibPtr glbbp;
static int beginIdx;
static int keyline;
static int errorline;

/*******************************************/
/* Lokale Funktionen                       */
/*******************************************/

static void PushSign(Snode **w, char a);
static void AppendSign(Snode **w, char a);
static void FreeStack(Snode **s);
static void StackToString(Snode *s, char **text); 
static void GetKey();
static void GetFldNameCont();
static void SecStrcat(int maxlen, char *str1, char *str2);

static int SetInputFile(char *file);
static int SkipSpace(char *text, Snode **new);
static int SkipNewLineSpace(char *text);
static int StringIsPeteEmpty(char *text);
static void WriteRecToFile(CardData *card, FILE *datei);
static long WriteLineToFile(FILE *datei, char *feld, char *inh);
#ifdef __cplusplus
#  include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */ 
# define COMMENT 257
# define STRING 258
# define PREAMBLE 259
# define ARTICLE 260
# define BOOK 261
# define BOOKLET 262
# define CONFERENCE 263
# define INBOOK 264
# define INCOLLECTION 265
# define INPROCEEDINGS 266
# define MANUAL 267
# define MASTERSTHESIS 268
# define MISC 269
# define PHDTHESIS 270
# define PROCEEDINGS 271
# define TECHREPORT 272
# define UNPUBLISHED 273
# define TYPE 274
# define KOMMA 275
# define EQ 276
# define LGKL 277
# define RGKL 278
# define LRKL 279
# define RRKL 280
# define DAZ 281
# define ZAUN 282
# define PROZENT 283
# define ZEICHEN 284
# define WHITE_SPACE 285
# define BUCHSTABE_ZAHL 286
# define KOMMENTAR 287
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256



static int SkipNewLineSpace(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < MAX_UEBERGABE) {
   if (*text == '{' ||  *text == '(') {
     back = strlen(text);
     text = text + back;
     while (*text != '}' && *text != ')') { 
       *text = '\0';
       text--;
     }
     return erg;
   }
   text++;
   erg++;
 }
 return 0;
}




static int SkipSpace(char *text, Snode **new)
{
 int erg, lgkl, daz, index, inmakro;
 
 index = 0;
 lgkl = 0;
 daz = 0;
 inmakro = 0;

 while ((*text == ' ' || *text == '=' || *text == '\t') && index < ueIdx) { text++; index++; }
 erg = index;
 if (*text == '{') {
   lgkl += 1;
   index++;
   text++; 
   inmakro = 0;
 }
 else if (*text == '"') {
   daz += 1;
   index++;
   text++; 
   inmakro = 0;
 }
 else {
   AppendSign(new, '@');
   AppendSign(new, *text);
   index++;
   text++; 
   inmakro = 1;
 }
 while (index < ueIdx) {
   if (*text == '{') {
     if (lgkl >= 1 || daz >= 1) {  /* Klammer in String */
       AppendSign(new, *text);
     }
     text++;                       /* Klammer nach Zaun */
     index++;
     lgkl += 1;
     inmakro = 0;
   }
   else if (*text == '\n') {
     AppendSign(new, *text);
     text++;
     index++;
     while ((*text == ' ') || (*text == '\t')){
        text++;
	index++;
	}
     inmakro = 0;
   }
   else if (*text == '}') {
     if ((lgkl > 1) || (daz >= 1)) {
       AppendSign(new, *text);
     } 
     text++;
     index++;
     lgkl -= 1;
     inmakro = 0;
   }
   else if (*text == '"') {
     if (lgkl >= 1) {
       AppendSign(new, *text);
       text++;
       index++;
     } 
     else {
       text++;
       index++;
       if (daz == 0) daz++;
       else daz = 0;
     }
     inmakro = 0;
   }
   else if (*text == '#') {        /* Space vor/nach Konkatenation */
     if (lgkl < 1 && daz < 1) {
       if (text[index-1] != ' ') AppendSign(new, ' ');
       AppendSign(new, '@');       /* # -> @# */
       AppendSign(new, *text);
       if (text[index+1] != ' ') AppendSign(new, ' ');
     }
     else {                        /* Konkatenation in String */
       AppendSign(new, *text);
     }
     text++;
     index++;
     inmakro = 0;
   } 
   else if (*text == ',') {        /* Komma am Ende */
     if (lgkl < 1 && daz != 1) break;
     else {
       AppendSign(new, *text);
       text++;
       index++;
     }
     inmakro = 0;
   }
   else if (*text == ')') {        /* runde Klammer am Ende */
     if (lgkl < 1 && daz != 1) break;
     else {
       AppendSign(new, *text);
       text++;
       index++;
     }
     inmakro = 0;
   }
   else if (isalnum(*text)) {
     if (lgkl < 1 && daz < 1 && (inmakro==0)) {
       if (text[index-1] != ' ') AppendSign(new, ' ');
       AppendSign(new, '@');       /* makro -> @makro */
       AppendSign(new, *text);
       inmakro = 1;
     }
     else {                        /* Zeichen in String */
       AppendSign(new, *text);
     }
     text++;
     index++;
   } 
   else {                        /* sonstiges Zeichen in String */
     AppendSign(new, *text);
     text++;
     index++;
     inmakro = 0;
   } 
 }
 return erg;
  
}



static void PushSign(Snode **w, char a)
{
 Snode *hnode, *oldw;

 if (*w == NULL) {
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   *w = hnode;
 }
 else {
   oldw = *w; 
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = oldw->slen + 1;
   hnode->next = oldw;
   *w = hnode;
}
}


static void AppendSign(Snode **w, char a)
{
 Snode *hnode, *oldw;
 int newslen;

 if (*w == NULL) {
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   *w = hnode;
 }
 else {
   oldw = *w; 
   newslen = 1;
   while (oldw->next != NULL) {
     newslen++; 
     oldw = oldw->next;
   }
   newslen++; 
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   oldw->next = hnode;
   oldw = *w; 
   oldw->slen = newslen;      /* echte Laenge nur im 1. El. */
}
}


static void FreeStack(Snode **s)
{
 Snode *h, *del;

 del = *s;
 while (del != NULL) {
   h = del->next;
   XtFree((char *)del);
   del = h;
 }
 *s = NULL;
} 


static void StackToString(Snode *s, char **text) 
{
  char *help;
  
  if (s==NULL)
     help = (char *)XtCalloc(1,1);
  else
     help = (char *)XtCalloc(1,s->slen+1);
  *text = help;
  while (s != NULL) {
    *help = s->inh; 
    s = s->next;
    help++;
  }
  *help = '\0';
  help--;
  while (*help == '\n') {    /* NL am Ende vom Wort loeschen */
    *help = '\0';
    help--;
  }
}



static void GetKey()
{
  StackToString(key, &card->mainkey);
  FreeStack(&key);
  err = dbtInsert(glbbp, card);
  err = dbtDeleteCard(&card);
}


static void GetFldNameCont()
{
  int found;
  FieldName i;
  
  if (helpFldName != NULL) {
    XtFree((char *)helpFldName);
    helpFldName = NULL;
  }
  StackToString(fldname, &helpFldName);
  strlower(helpFldName); 
  SkipSpace(uebergabe, &fldcont);
  found = 0;
  for (i=0;i<max_fields && (!found);i++) {
      if (strcmp(helpFldName, glbFldToName(i)) == 0) {
         if (isstandardfield(i, cardtype))
            StackToString(fldcont, &card->field[i]);
         else {
            err = dbtMakeUserFld(&helpufield);
            Scalloc(&helpufield->fldName, helpFldName);
            StackToString(fldcont, &helpufield->fldData); 
            err = dbtAppendUserFld(&card->ufield, helpufield);
            }
         found = 1; 
         break;
      }
  }
  if (!found){
     err = dbtMakeUserFld(&helpufield);
     Scalloc(&helpufield->fldName, helpFldName);
     StackToString(fldcont, &helpufield->fldData); 
     err = dbtAppendUserFld(&card->ufield, helpufield);
     }
  FreeStack(&fldname);
  FreeStack(&fldcont);
}

static void SecStrcat(int maxlen, char *str1, char *str2)
{
 if (strlen(str1)+strlen(str2) < maxlen)
    strcat(str1, str2);
}

static int SetInputFile(char *file)
{
 char *infilename; 
    
 if (file)
 {
  infilename = file;

  if (access(infilename, F_OK) != 0)
     return BIF_ENOTEXISTS;

  yyin = fopen(infilename, "r" );

  if ( yyin == NULL ) {
    return BIF_EOPEN;  
  }
  return BIF_OK;  
 }
 else
 {
   yyin = stdin;
   infilename = "<stdin>";
   return BIF_OK;  
 }
}


/*********************************************
 * BibTeX-Datei lesen                        *
 *********************************************/
Errcode bifFileRead(BibPtr bp)
{
  int erg;

  yynline = 1; 
  yynflexcalls = 0;
  hlpQuitHelpError(7);

  sprintf(errorstr, anfhelpstr, "KEY", "OFFSET", "LINE");
#ifdef NO_TEMPNAM
  bp->tempfile = (char *)tmpnam(NULL);
  bp->macrofile = (char *)tmpnam(NULL);
#else
  bp->tempfile = (char *)tempnam(NULL, NULL);
  bp->macrofile = (char *)tempnam(NULL, NULL);
#endif
  tempDatei = fopen(bp->macrofile, "w" );

  if ((erg = SetInputFile(bp->filepath)) == BIF_ENOTEXISTS){
     glbbp = bp;
     fclose(tempDatei);
     return BIF_OK;
     }
  
  if ((erg = glbContIllegalChar(bp->filepath)) != 1) return ERR_NOBIB;
  glbbp = bp; 
  erg = yyparse();
  fclose(tempDatei);
  uebergabe[0] = '\0';
  sprintf(errstr, endhelpstr, bp->filepath, yynerrs);
  SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
  ueIdx = 0;
  if (erg == 0) {
    if (yyin) fclose(yyin);
    erg = yynline;
    if (yynerrs > 0)
       return yynline-1;
    else
       return BIF_OK;
  }
  else {
    erg = -yynline;
    yy_init = 1;
    if (yyin) fclose(yyin);
    FreeStack(&key);
    FreeStack(&fldname);
    FreeStack(&fldcont);
    return (Errcode)erg;
  }
}



Errcode bifFileWrite(BibPtr bp)
{
 char sysStr[2*MAX_FILEPATHLEN];

 CardListNode *cl = NULL;
 Errcode status;

 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, bp->tempfile);
    system(sysStr);
    tempDatei = fopen(bp->tempfile, "r+");
    }
 else
    {tempDatei = fopen(bp->tempfile, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;

 if ((status = dbtBuildList(bp->treeIdx, &cl, bp->sortedby)) != DBT_OK) {
      return (status);
   }

 while (cl != NULL) {
   WriteRecToFile(cl->data, tempDatei);
   cl = cl->next;
 } 

 fclose(tempDatei);
 sprintf(sysStr, "cp  %s %s", bp->tempfile, bp->filepath);
 system(sysStr);
 return BIF_OK;
}


Errcode bifFileListWrite(BibPtr bp, CardListNode *list, String fname)
{
 CardListNode *hlist;
 char sysStr[2*MAX_FILEPATHLEN];
 
 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, fname);
    system(sysStr);
    tempDatei = fopen(fname, "r+");
    }
 else
    {tempDatei = fopen(fname, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;
 hlist = list;
 while (hlist != NULL) {
   WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 
 fclose(tempDatei);
 return BIF_OK;
}


static long WriteLineToFile(FILE *datei, char *feld, char *inh)
{
  int inmakro = 0;    /* weder Makro, noch String */
  int instring = 0;
  int isempty = 1;
  int zaehler;
  long pos; 
  char *blank, *blankptr, *zeichen; 
  
  blank = (char *)XtMalloc(100);
  blankptr = blank;

  for (zaehler = 0; zaehler < fld_indent; zaehler++)
     fprintf(datei," ");
  fprintf(datei,"%s", feld);
  zaehler += strlen(feld);
  for (;zaehler < cont_indent - 3; zaehler++)
     fprintf(datei," ");
  fprintf(datei," = ");
  zeichen = inh;
  while (*zeichen!='\0'){
   switch (*zeichen){
     case ' ':
     case '\t':
	  if (instring)
	     *blankptr++ = *zeichen;
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '\n':
	  if (instring){
	     *blankptr++ = *zeichen;
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        *blankptr++ = ' ';
             }
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '@':
          if (inmakro)
	     fprintf(datei, " ");
          else if (instring){
	     fprintf(datei, "} ");
	     inmakro = 1;
	     instring = 0;
	     }
          else {
	     inmakro = 1;
	     instring = 0;
	     }
          break;
     case '#':
          if (isempty && inmakro) {
	     fprintf(datei, "{ } #");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (inmakro){
	     fprintf(datei, "# ");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (instring) 
	     fprintf(datei, "#");
          else {
	     fprintf(datei, "{#");
	     instring = 1;
	     }
          break;
      default:
          isempty = 0;
          if (inmakro)
	     fprintf(datei, "%c", *zeichen);
          else if (instring){
	     *blankptr++ = '\0';
	     fprintf(datei, "%s", blank);
	     blankptr = blank;
	     fprintf(datei, "%c", *zeichen);
	     }
          else{
	     fprintf(datei, "{%c", *zeichen);
	     instring = 1;
	     inmakro = 0;
	     }
          break;
      } /* case */
  zeichen++;
  } /* while */
	   
  if ((isempty==1) && (inmakro==0) && (instring==0))
    fprintf(datei,"{ }");    
  else if (instring) {
    fprintf(datei,"}");    
  }
        
  pos = ftell(datei);
  fprintf(datei,",\n");
  XtFree(blank);
  return pos;
}

static void WriteRecToFile(CardData *card, FILE *datei)
{
 UserFld *h;
 String newType;
 long pos;
 FieldName i;

 fseek(datei, 0L, SEEK_END); 
 fprintf(datei,"\n");
 pos = ftell(datei);
 newType = glbNewString(card->cardtypestr);
 fprintf(datei,"@%s{%s",newType, card->mainkey);
 XtFree(newType);
 pos = ftell(datei);
 fprintf(datei,",\n");

 for (i=0; i<max_fields; i++) {
    if (!StringIsPeteEmpty(card->field[i]))
       pos = WriteLineToFile(datei, glbFldToName(i), card->field[i]);
 }
 h = card->ufield; 
 while (h) {
   if (!StringIsPeteEmpty(h->fldData)) 
      pos = WriteLineToFile(datei,h->fldName,h->fldData);    
   h = h->next;
 }   
 fseek(datei, pos, SEEK_SET);
 fprintf(datei,"\n}\n\n");
}



static int StringIsPeteEmpty(char *text)
{
 if (text == NULL || *text == '\0') return 1;
 return 0;
}



yyerror(char *s)
{

 fputs(s, stderr);
 putc('\n', stderr);
}

#ifdef BIFMAIN

int main(int argc, char *argv[])
{
 Bib bp;
 int erg, b1, i;
 Errcode err;

#ifdef YYDEBUG
       extern int yydebug;

       yydebug = 1;
#endif

 strcpy(bp.filepath, argv[1]);
 dbtGetFreeTreeIdx(&b1);
 bp.treeIdx = b1;
 err = bifFileRead(&bp);
 err = bifFileWrite(&bp);
}

#endif
__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 4,
	-2, 0,
-1, 3,
	0, 3,
	-2, 0,
	};
# define YYNPROD 182
# define YYLAST 513
__YYSCLASS yytabelem yyact[]={

    21,    17,    22,    23,    45,    46,    50,   188,    51,    52,
    49,    47,    48,    43,    41,    44,    42,   184,    25,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    15,    16,    45,    46,    50,    95,    51,    52,    49,    47,
    48,    43,    41,    44,    42,   195,   197,   201,   209,   199,
   200,   190,   198,   196,   194,   191,   193,   192,    45,    46,
    50,   205,    51,    52,    49,    47,    48,    43,    41,    44,
    42,    60,    61,    65,   180,    66,   113,    64,    62,    63,
    58,    56,    59,    57,    60,    61,    65,   111,    66,   246,
    64,    62,    63,    58,    56,    59,    57,   195,   197,   201,
   136,   199,   200,   134,   198,   196,   194,   191,   193,   192,
   229,   231,   228,   241,   226,   227,   230,   131,   117,   225,
   222,   224,   223,   229,   231,   228,   221,   226,   227,   230,
   156,   100,   225,   222,   224,   223,    60,    61,    65,    32,
    66,    33,    64,    62,    63,    58,    56,    59,    57,   229,
   231,   228,   167,   226,   227,   230,   232,    80,   225,   222,
   224,   223,    78,   177,    79,    77,    32,    76,    33,   171,
    32,   208,    33,   172,   164,   153,   175,    32,   174,    33,
   142,    32,   141,    33,    80,    32,   220,    33,    37,    78,
    39,    79,    77,    34,    76,    36,    32,    29,    33,    31,
   204,    32,   171,    33,   163,    32,   172,    33,   179,   175,
   145,   174,   162,    32,   151,    33,    32,    32,    33,    33,
   135,    32,   142,    33,   141,   175,    81,   174,    82,    70,
    53,    71,    54,   132,   130,   128,   114,    84,    28,   144,
   127,   118,   189,   137,   140,   173,    73,    40,    55,     1,
    24,   169,    26,    27,    20,    75,    19,    18,     3,     2,
     0,   168,     0,     0,   139,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    69,     0,     0,    72,    83,     0,     0,    85,
    86,    87,    88,    89,    90,    91,    92,    93,    94,    96,
    97,    98,     0,    99,     0,   101,   102,   103,   104,   105,
   106,   107,   108,   109,   110,   112,     0,     0,   115,     0,
   116,     0,     0,     0,     0,    74,     0,     0,   125,   126,
   119,     0,   121,   122,   123,   124,     0,     0,     0,     0,
     0,     0,     0,   129,     0,     0,     0,     0,    30,    35,
    38,     0,     0,     0,     0,     0,     0,     0,    67,    68,
   133,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   146,     0,     0,     0,     0,   147,     0,     0,     0,
     0,   148,     0,   149,     0,     0,   157,   158,   159,   160,
     0,     0,     0,     0,     0,     0,     0,   165,     0,     0,
     0,   120,     0,   152,     0,     0,     0,     0,   181,   234,
   235,   236,   237,   238,   239,   240,   242,   243,   244,   187,
   202,   203,   186,     0,     0,     0,     0,     0,   247,   183,
     0,   152,     0,   248,   210,   211,   212,   213,   214,   215,
   216,   217,   218,   219,   138,   143,   206,   152,     0,     0,
     0,     0,     0,   138,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   150,   233,   154,   155,     0,     0,     0,
   138,   138,   161,     0,     0,   245,     0,     0,     0,   166,
     0,     0,   170,     0,     0,   176,   178,     0,     0,     0,
   182,     0,     0,   170,     0,   185,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   170,     0,   207 };
__YYSCLASS yytabelem yypact[]={

  -256, -3000,  -256,  -256, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,   -40,   -80,   -84,   -89, -3000, -3000, -3000, -3000,  -217,
   -47,  -139,   -69,   -69,  -217,   -48,  -139,  -119,   -51,  -119,
   -41,  -217,  -217,  -217,  -217,  -217,  -217,  -217,  -217,  -217,
  -243,  -217,  -217,  -217,  -139,  -149,  -139,  -139,  -139,  -139,
  -139,  -139,  -139,  -139,  -139,  -191,  -204, -3000, -3000,   -42,
  -217,  -139,  -162,   -34,   -92,   -69,   -92,   -92,   -92,   -92,
 -3000,  -119,  -119,   -35, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000,   -43,  -217, -3000, -3000,   -44,  -163,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
   -45,  -139,  -177, -3000, -3000,   -58,  -180, -3000,  -104,   -69,
 -3000, -3000, -3000, -3000, -3000,   -36,   -65,  -104,  -217, -3000,
 -3000, -3000,  -139, -3000,  -139, -3000, -3000,   -64,   -62,  -100,
  -146,   -62,   -62, -3000,  -104,  -104,   -68, -3000, -3000, -3000,
   -74, -3000,  -101,  -104, -3000,  -124,  -108, -3000, -3000,  -115,
   -72,  -206, -3000, -3000,  -104, -3000,   -62,  -108,  -265,   -69,
   -75,  -271,  -230, -3000,   -59,   -59,   -78, -3000,  -219, -3000,
 -3000, -3000,   -62,  -265,  -108, -3000,   -69,  -107, -3000,  -233,
 -3000,  -178,  -178,  -178,  -178,  -178,  -178,  -178,  -178,  -178,
  -178,  -152, -3000, -3000, -3000, -3000,  -265, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
  -122,  -178,  -126,  -126,  -126,  -126,  -126,  -126,  -165,  -126,
  -126,  -126,  -178, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
  -189,  -126, -3000, -3000, -3000, -3000,  -126, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,   249,   259,   258,   257,   256,   254,   247,   325,   248,
   250,   246,   243,   255,   264,   244,   261,   251,   242,   245,
   186 };
__YYSCLASS yytabelem yyr1[]={

     0,     1,     1,     1,     1,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     3,     3,
     3,     3,     3,     4,     4,     4,     4,     5,     5,     5,
     5,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     9,     9,     6,     6,     6,     6,     6,     6,     6,     6,
    10,    11,    11,    11,    11,    13,    13,    13,    13,    13,
    13,    13,    13,    13,    12,    12,    12,    12,    12,    12,
    12,    12,    12,    14,    14,    15,    15,    15,    15,     8,
     8,     8,     8,    16,    16,    16,    16,    16,    17,    17,
    17,    17,    17,    19,    19,    19,    19,    18,    18,    18,
    18,    18,    18,    18,    18,    18,    18,    18,    18,    18,
    18,    18,    18,    18,    18,    18,    18,    18,    18,    18,
    18,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    20 };
__YYSCLASS yytabelem yyr2[]={

     0,     4,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     5,     9,    11,     9,    11,     9,    11,     9,
    11,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     8,     6,     6,     4,     4,     4,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     4,     4,     4,
     4,     4,     4,     4,     4,     4,     8,     6,     6,     4,
     8,     6,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    15,    17,    13,    15,    15,    17,    13,    15,
     3,     4,     4,     6,     2,     5,     5,     5,     5,     3,
     3,     3,     3,     3,     8,     6,     6,     8,     4,     6,
     4,     2,     4,     9,     7,     5,     5,     3,     3,     4,
     4,     2,     2,     6,     2,     4,     4,     6,     6,     6,
     4,     4,     2,     4,     4,     2,     2,     4,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     6,     8,     4,
     6,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     4,     4,     4,     4,     4,     4,     6,     8,     4,
     6,     2,     2,     2,     4,     4,     4,     2,     2,     2,
     2,     2 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,    -3,   275,   276,   277,   278,   279,   280,
   281,   282,   283,   284,   285,   286,   287,   257,    -4,    -5,
    -6,   256,   258,   259,   -10,   274,    -1,    -1,   278,   277,
    -8,   279,   285,   287,   277,    -8,   279,   277,    -8,   279,
    -7,   285,   287,   284,   286,   275,   276,   282,   283,   281,
   277,   279,   280,   277,   279,    -9,   285,   287,   284,   286,
   275,   276,   282,   283,   281,   277,   279,    -8,    -8,    -7,
   277,   279,    -9,   -11,    -8,   -13,   286,   284,   281,   283,
   276,   277,   279,   -11,   278,    -7,    -7,    -7,    -7,    -7,
    -7,    -7,    -7,    -7,    -7,   278,    -7,    -7,    -7,    -9,
   280,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,
    -9,   278,    -9,   280,   278,    -7,    -9,   280,   275,   -13,
    -8,   -13,   -13,   -13,   -13,   -11,   -11,   275,   278,    -7,
   278,   280,   278,    -9,   280,   278,   280,   -12,    -8,   -14,
   -15,   286,   284,    -8,   275,   275,   -12,    -7,    -9,    -9,
    -8,   278,   -14,   275,    -8,    -8,   276,   -15,   -15,   -12,
   -12,    -8,   280,   278,   275,   -12,    -8,   276,   -16,   -17,
    -8,   277,   281,   -19,   286,   284,    -8,   278,    -8,   280,
   280,   -12,    -8,   -16,   282,    -8,   -17,    -7,   278,   -18,
   281,   285,   287,   286,   284,   275,   283,   276,   282,   279,
   280,   277,   -19,   -19,   278,   280,   -16,    -8,   278,   281,
   -18,   -18,   -18,   -18,   -18,   -18,   -18,   -18,   -18,   -18,
   -20,   278,   285,   287,   286,   284,   279,   280,   277,   275,
   281,   276,   278,   -18,   -20,   -20,   -20,   -20,   -20,   -20,
   -20,   278,   -20,   -20,   -20,   -18,   278,   -20,   -20 };
__YYSCLASS yytabelem yydef[]={

     0,    -2,    -2,    -2,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
    21,     0,     0,     0,     0,    90,     1,     2,    22,     0,
     0,     0,   121,   122,     0,     0,     0,     0,     0,     0,
     0,    46,    47,    48,    49,    50,    51,    52,    53,    54,
     0,    55,    56,     0,     0,     0,    73,    74,    75,    76,
    77,    78,    79,    80,    81,     0,     0,   119,   120,     0,
     0,     0,     0,     0,     0,    94,    99,   100,   102,   103,
   101,     0,     0,     0,    23,    31,    32,    33,    34,    35,
    36,    37,    38,    39,     0,    43,    44,    45,     0,     0,
    25,    57,    58,    59,    60,    61,    62,    63,    64,    65,
     0,    69,     0,    72,    27,     0,     0,    29,     0,    91,
    92,    95,    96,    97,    98,     0,     0,     0,    42,    41,
    24,    26,    68,    67,    71,    28,    30,     0,     0,   111,
     0,   117,   118,    93,     0,     0,     0,    40,    66,    70,
     0,    84,   110,   108,   112,     0,     0,   115,   116,     0,
     0,     0,    88,    82,   106,   105,   109,     0,   114,   124,
     0,     0,     0,   132,   135,   136,     0,    85,     0,    89,
    86,   104,   107,   113,     0,   125,   126,     0,   131,     0,
   130,   151,   152,   153,   154,   155,   156,   157,   158,   159,
   160,     0,   133,   134,    83,    87,   123,   127,   128,   129,
   137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     0,   149,   171,   172,   173,   177,   178,   179,     0,   180,
   181,     0,   147,   150,   161,   162,   163,   164,   165,   166,
     0,   169,   174,   175,   176,   148,   167,   170,   168 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"COMMENT",	257,
	"STRING",	258,
	"PREAMBLE",	259,
	"ARTICLE",	260,
	"BOOK",	261,
	"BOOKLET",	262,
	"CONFERENCE",	263,
	"INBOOK",	264,
	"INCOLLECTION",	265,
	"INPROCEEDINGS",	266,
	"MANUAL",	267,
	"MASTERSTHESIS",	268,
	"MISC",	269,
	"PHDTHESIS",	270,
	"PROCEEDINGS",	271,
	"TECHREPORT",	272,
	"UNPUBLISHED",	273,
	"TYPE",	274,
	"KOMMA",	275,
	"EQ",	276,
	"LGKL",	277,
	"RGKL",	278,
	"LRKL",	279,
	"RRKL",	280,
	"DAZ",	281,
	"ZAUN",	282,
	"PROZENT",	283,
	"ZEICHEN",	284,
	"WHITE_SPACE",	285,
	"BUCHSTABE_ZAHL",	286,
	"KOMMENTAR",	287,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"datei : between datei",
	"datei : entry datei",
	"datei : entry",
	"datei : between",
	"between : KOMMA",
	"between : EQ",
	"between : LGKL",
	"between : RGKL",
	"between : LRKL",
	"between : RRKL",
	"between : DAZ",
	"between : ZAUN",
	"between : PROZENT",
	"between : ZEICHEN",
	"between : WHITE_SPACE",
	"between : BUCHSTABE_ZAHL",
	"between : KOMMENTAR",
	"entry : COMMENT",
	"entry : string",
	"entry : preamble",
	"entry : eintrag",
	"entry : error RGKL",
	"string : STRING LGKL allstringG RGKL",
	"string : STRING leerraum LGKL allstringG RGKL",
	"string : STRING LRKL allstringR RRKL",
	"string : STRING leerraum LRKL allstringR RRKL",
	"preamble : PREAMBLE LGKL allstringG RGKL",
	"preamble : PREAMBLE leerraum LGKL allstringG RGKL",
	"preamble : PREAMBLE LRKL allstringR RRKL",
	"preamble : PREAMBLE leerraum LRKL allstringR RRKL",
	"allstringG : WHITE_SPACE allstringG",
	"allstringG : KOMMENTAR allstringG",
	"allstringG : ZEICHEN allstringG",
	"allstringG : BUCHSTABE_ZAHL allstringG",
	"allstringG : KOMMA allstringG",
	"allstringG : EQ allstringG",
	"allstringG : ZAUN allstringG",
	"allstringG : PROZENT allstringG",
	"allstringG : DAZ allstringG",
	"allstringG : LGKL allstringG RGKL allstringG",
	"allstringG : LGKL RGKL allstringG",
	"allstringG : LGKL allstringG RGKL",
	"allstringG : LGKL RGKL",
	"allstringG : LRKL allstringG",
	"allstringG : RRKL allstringG",
	"allstringG : WHITE_SPACE",
	"allstringG : KOMMENTAR",
	"allstringG : ZEICHEN",
	"allstringG : BUCHSTABE_ZAHL",
	"allstringG : KOMMA",
	"allstringG : EQ",
	"allstringG : ZAUN",
	"allstringG : PROZENT",
	"allstringG : DAZ",
	"allstringG : LRKL",
	"allstringG : RRKL",
	"allstringR : WHITE_SPACE allstringR",
	"allstringR : KOMMENTAR allstringR",
	"allstringR : ZEICHEN allstringR",
	"allstringR : BUCHSTABE_ZAHL allstringR",
	"allstringR : KOMMA allstringR",
	"allstringR : EQ allstringR",
	"allstringR : ZAUN allstringR",
	"allstringR : PROZENT allstringR",
	"allstringR : DAZ allstringR",
	"allstringR : LGKL allstringR RGKL allstringR",
	"allstringR : LGKL RGKL allstringR",
	"allstringR : LGKL allstringR RGKL",
	"allstringR : LGKL RGKL",
	"allstringR : LRKL allstringR RRKL allstringR",
	"allstringR : LRKL allstringR RRKL",
	"allstringR : LRKL RRKL",
	"allstringR : WHITE_SPACE",
	"allstringR : KOMMENTAR",
	"allstringR : ZEICHEN",
	"allstringR : BUCHSTABE_ZAHL",
	"allstringR : KOMMA",
	"allstringR : EQ",
	"allstringR : ZAUN",
	"allstringR : PROZENT",
	"allstringR : DAZ",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder RRKL",
	"eingabetyp : TYPE",
	"schluessel : leerraum schl",
	"schluessel : schl leerraum",
	"schluessel : leerraum schl leerraum",
	"schluessel : schl",
	"schl : BUCHSTABE_ZAHL schl",
	"schl : ZEICHEN schl",
	"schl : DAZ schl",
	"schl : PROZENT schl",
	"schl : BUCHSTABE_ZAHL",
	"schl : ZEICHEN",
	"schl : EQ",
	"schl : DAZ",
	"schl : PROZENT",
	"felder : leerraum feld KOMMA felder",
	"felder : feld KOMMA felder",
	"felder : leerraum feld KOMMA",
	"felder : leerraum feld KOMMA leerraum",
	"felder : feld KOMMA",
	"felder : feld KOMMA leerraum",
	"felder : leerraum feld",
	"felder : feld",
	"felder : feld leerraum",
	"feld : feldname leerraum EQ konkatenation",
	"feld : feldname EQ konkatenation",
	"feldname : BUCHSTABE_ZAHL feldname",
	"feldname : ZEICHEN feldname",
	"feldname : BUCHSTABE_ZAHL",
	"feldname : ZEICHEN",
	"leerraum : WHITE_SPACE leerraum",
	"leerraum : KOMMENTAR leerraum",
	"leerraum : WHITE_SPACE",
	"leerraum : KOMMENTAR",
	"konkatenation : konkatenation ZAUN konkatenation",
	"konkatenation : feldinhalt",
	"konkatenation : feldinhalt leerraum",
	"konkatenation : leerraum feldinhalt",
	"konkatenation : leerraum feldinhalt leerraum",
	"feldinhalt : LGKL allstringG RGKL",
	"feldinhalt : DAZ dazfeldinhalt DAZ",
	"feldinhalt : DAZ DAZ",
	"feldinhalt : LGKL RGKL",
	"feldinhalt : makro",
	"makro : BUCHSTABE_ZAHL makro",
	"makro : ZEICHEN makro",
	"makro : BUCHSTABE_ZAHL",
	"makro : ZEICHEN",
	"dazfeldinhalt : WHITE_SPACE dazfeldinhalt",
	"dazfeldinhalt : KOMMENTAR dazfeldinhalt",
	"dazfeldinhalt : BUCHSTABE_ZAHL dazfeldinhalt",
	"dazfeldinhalt : ZEICHEN dazfeldinhalt",
	"dazfeldinhalt : KOMMA dazfeldinhalt",
	"dazfeldinhalt : PROZENT dazfeldinhalt",
	"dazfeldinhalt : EQ dazfeldinhalt",
	"dazfeldinhalt : ZAUN dazfeldinhalt",
	"dazfeldinhalt : LRKL dazfeldinhalt",
	"dazfeldinhalt : RRKL dazfeldinhalt",
	"dazfeldinhalt : LGKL dazdaz RGKL",
	"dazfeldinhalt : LGKL dazdaz RGKL dazfeldinhalt",
	"dazfeldinhalt : LGKL RGKL",
	"dazfeldinhalt : LGKL RGKL dazfeldinhalt",
	"dazfeldinhalt : WHITE_SPACE",
	"dazfeldinhalt : KOMMENTAR",
	"dazfeldinhalt : BUCHSTABE_ZAHL",
	"dazfeldinhalt : ZEICHEN",
	"dazfeldinhalt : KOMMA",
	"dazfeldinhalt : PROZENT",
	"dazfeldinhalt : EQ",
	"dazfeldinhalt : ZAUN",
	"dazfeldinhalt : LRKL",
	"dazfeldinhalt : RRKL",
	"dazdaz : WHITE_SPACE dazdaz",
	"dazdaz : KOMMENTAR dazdaz",
	"dazdaz : BUCHSTABE_ZAHL dazdaz",
	"dazdaz : ZEICHEN dazdaz",
	"dazdaz : LRKL dazdaz",
	"dazdaz : RRKL dazdaz",
	"dazdaz : LGKL dazdaz RGKL",
	"dazdaz : LGKL dazdaz RGKL dazdaz",
	"dazdaz : LGKL RGKL",
	"dazdaz : LGKL RGKL dazdaz",
	"dazdaz : WHITE_SPACE",
	"dazdaz : KOMMENTAR",
	"dazdaz : BUCHSTABE_ZAHL",
	"dazdaz : KOMMA dazdaz",
	"dazdaz : DAZ dazdaz",
	"dazdaz : EQ dazdaz",
	"dazdaz : ZEICHEN",
	"dazdaz : LRKL",
	"dazdaz : RRKL",
	"dazdaz : KOMMA",
	"dazdaz : DAZ",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
		/*		yyerror( (nl_msg(30003,"syntax error")) ); */
				yynerrs++;
				errorline = yynline;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 22:{StackToString(key, &errkey);
	       FreeStack(&key);
	       if ((errkey!=NULL) && (errkey[0]!='\0')){
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", 
				 errkey, errorline-keyline, errorline-1);
                 XtFree(errkey);
		 errkey = NULL;
		 }
               else
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", "key unknown", 
				     errorline-keyline, errorline-1);
               SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
	       } break;
case 23:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@STRING"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 24:{          
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@STRING"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 25:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@STRING"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 26:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@STRING"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 27:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@PREAMBLE"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 28:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@PREAMBLE"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 29:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@PREAMBLE"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 30:{         
		keyline = yynline;
                beginIdx = SkipNewLineSpace(uebergabe);
                fprintf(tempDatei,"@PREAMBLE"); 
                fprintf(tempDatei,"%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 82:{                 
                  GetKey();
                } break;
case 83:{
                  GetKey();
                } break;
case 84:{
                  GetKey();
                } break;
case 85:{
                  GetKey();
                } break;
case 86:{
                  GetKey();
                } break;
case 87:{
                  GetKey();
                } break;
case 88:{
                  GetKey();
                } break;
case 89:{
                  GetKey();
                } break;
case 90:{
		  err = dbtMakeCard(&card);
		  card->cardtype = cardtype = 
		     glbNameToType(strlower(uebergabe)); 
		  if (cardtype == -1)
		     card->cardtype = cardtype = MAX_BIBTEX_TYPES;
		  Scalloc(&card->cardtypestr, uebergabe);
                } break;
case 95:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 96:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 97:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 98:{
                  PushSign(&key, '%');
		  keyline = yynline;
                  PushSign(&key, '\\');
                } break;
case 99:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 100:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 101:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 102:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 103:{
                  PushSign(&key, '%');
                  PushSign(&key, '\\');
		  keyline = yynline;
                } break;
case 113:{
                  GetFldNameCont();
                } break;
case 114:{
                  GetFldNameCont();
                } break;
case 115:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 116:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 117:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
case 118:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

