#define VERSION "2.10gf"
/* modified by Peter Damron 1987 University of Washington */
/*---------------------------------------------------------------------*/
/* $Header: dvi2ps.h,v 2.0 88/06/07 15:02:03 peterd Rel2 $ */
/*---------------------------------------------------------------------*/

/**********************************************************************/
/************************  Global Definitions  ************************/
/**********************************************************************/

/* default font area (directory) */
#ifndef FONTAREA
#define  FONTAREA	"/usr/local/lib/tex/fonts"
#endif

/* name for environment variable for tex font path/directory */
#ifndef ENVTEXFONTS
#define ENVTEXFONTS	"TEXFONTS"
#endif

/* default header file location */
#ifndef HDRFILE
#define HDRFILE		"/usr/local/lib/tex.ps"
#endif

#ifdef apollo
#ifndef SPOOLFILE
#define SPOOLFILE	"/local/spool/laser/tex."
#endif
#define MAXFLEN 28
#endif apollo

#ifdef apollo
#define  MAXOPEN	 45	/* limit on number of open font files */
#else !apollo
#define  MAXOPEN	 12	/* limit on number of open font files */
#endif

#ifdef apollo	   /* define for enabling of -c option (create output file) */
#define CREOPT
#endif apollo

#define USEGLOBALMAG 1			/* when defined, the dvi global */
					/*   magnification is applied   */
	/* We can leave USEGLOBALMAG undefined when we have a limited
	   number of font magnifications (at 300dpi) available.  Otherwise, we
	   will simply complain about missing font files
	 */
/* #undef USEGLOBALMAG */
	/* define for "optimal" relative postioning, rather
	   than absolute.  Relative can reduce size of postcript
	   output 20% (and reduce print time by almost as much */

#define USERELPOS	1 

#define DEBUG   1			/* for massive printing of input */
					/* trace information; select by -d */
					/* option after filename: */
					/* dviview filename -d */
#define STATS		/* to enable statistics reporting via -s option */

#define BINARYOPEN fopen		/* byte-oriented host version */

#define ARITHRSHIFT 1	   /* define if ">>" operator is a */
					/* sign-propagating arithmetic  */
					/*   right shift */

#define  RESOLUTION      300
#define  hconvRESOLUTION 300
#define  vconvRESOLUTION 300

#ifdef NOTDEF
#define  NPXLCHARS	128
#define  PXLID		1001
#endif NOTDEF

#define  DVIFORMAT	2

#define  STACKSIZE	100
#define  STRSIZE	257
#define  PATHSIZE	50

#define  NONEXISTANT	-1	/* offset for font files not found */
#define  NO_FILE	(FILE *)-1

#define  TRUE		1
#define  FALSE		0

/* define constants for fseek() */
#define FROM_START	0
#define FROM_HERE	1
#define FROM_END	2
#define READ		4		/* for access() */


/**********************************************************************/
/*************************  Global Procedures  ************************/
/**********************************************************************/
/* Note: Global procedures are declared here in alphabetical order, with
   those which do not return values typed "void".  Their bodies occur in
   alphabetical order following the main() procedure.  The names are
   kept unique in the first 6 characters for portability.
 */

float	ActualFactor();
void	AllDone();
FILE*	BINARYOPEN();
int     ChkOpt();		/* Check PostScript option for validity */
void    CopyFile();		/* copy a file to stdout */
void    DecodeArgs();		/* process command line options */
void    DoSpecial();
void    EmitCharBitMap();
void	Fatal();		/* like printf for fatal errors - no return */
void	FindPostAmble();
void	GetBytes();		/* get a string from a file */
void	GetFontDef();
char   *GetKeyStr();
int     GetKeyVal();
int     HasBeenRead();	/* return true if this dvi font number has been read */
int     IsSame();	/* comare strings ignoring case */
void    lcase();	/* convert a string to lower case - doesn't work? */
void	MoveDown();
void	MoveOver();
int     NoSignExtend();	 /* see cautionary note in code, re arithmetic vs logical shifts */
void	OpenFontFile();
#ifdef CREOPT
FILE*   OpenOutput();
#endif CREOPT
int	PixRound();
void	Progress();	/* like printf for messages about progress */
void    PutInt();
int	ReadFontDef();
void	CheckPreAmble();
void	ReadPreAmble();
void	ReadPostAmble();
void	SetChar();
void	SetFontNum();
void    SetPosn();
void	SetRule();
void    SetString();
int     SignExtend();	/* see cautionary note in code, re arithmetic vs logical shifts */
void	SkipFontDef();
void	Warning();	/* like printf for warnings */


/*---------------------------------------------------------------------*/
/**********************************************************************/
/***********************  Font Data Structures  ***********************/
/**********************************************************************/

typedef int BOOLEAN;

#ifdef NOTDEF
struct char_entry {			/* character entry */
#ifdef USEPXL
    unsigned short width;	/* char width in pixels */
    unsigned short height;	/* char height in pixels */
    short xOffset;		/* char x offset in pixels */
    short yOffset;		/* char y offset in pixels */
#endif
    struct {
	int isloaded;
	union {
	   int fileOffset;
	   long *pixptr;
	} address;
    } where;
    int tfmw;				/* TFM width */
};

struct font_entry {	/* font entry */
   int dvi_fnum;	/* font number - from dvi file */
   int dvi_check;	/* checksum - never checked */
   int dvi_s;		/* font space size */
   int dvi_d;		/* font design size */
   int dvi_alen;	/* area length for font name */
   int dvi_nlen;	/* device length */
			/* dvi_alen + dvi_nlen == length of dvi_name (name) */
   char dvi_name[STRSIZE];	/* FNT_DEF command parameters (??) (font name?) */
   int font_space;	/* computed from FNT_DEF s parameter */
   int font_mag;	/* computed from FNT_DEF s and d parameters */
   char psname[STRSIZE]; /* PostScript name of the font */
   char name[STRSIZE];	/* full name of font file */
   FILE *font_file_id;  /* file identifier (NO_FILE if none) */
   struct open_font_list *open_font_ptr;	/* entry in open font list */
#ifdef USEPXL
   int magnification;	/* magnification read from PXL file */
   int designsize;	/* design size read from PXL file */
#endif
   struct char_entry ch[NPXLCHARS];	/* character information */
   struct font_entry *next;		/* next font entry in list */
   int ncdl;		/* # of different chars actually downloaded */
#ifdef STATS
   int nbpxl;		/* # of bytes of font data downloaded*/
   int ncts;		/* total # of characters typeset */
   int nopen;		/* total # of file opens performed */
   int nclose;		/* total # of file opens performed */
#endif
};

struct open_font_list
{
    FILE *pixel_file_id;		/* file identifier */
    struct font_entry *font_entry_ptr;	/* font entry (fast lookup) */
    int use_count;			/* count of "opens" */
};
#endif NOTDEF

/*---------------------------------------------------------------------*/

