{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,G+,O+,F+}
{$ENDIF}

{$IFOPT R+}
{$DEFINE RANGEON}
{$ELSE}
{$UNDEF RANGEON}
{$ENDIF}

Unit bibinit;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, wobjects, WinTypes, WinProcs, strings, wbibdisp, wbibgui,
  wbibslct, wbibinit,wbib3d,
{$ELSE}
  bibwindo, Dos, objects, spawno, BibMouse, bibCrt, bibdisp, bibselct,
  bibcheck, bibclip,
{$ENDIF}
  streams, bibstrm, bibstrg, bibinit2, bibvars, bibfile, bib8bit, bibwild,
  bibutil, BibSrtPt, rc_strng, bibtmplt, rc_Param, bibcache, bibtext, lfnunit;

const
  TempBufSize=16384; { Must be at least 132*60*2=15840 }
type
  PText = ^Text;
  TempBufType = array[1..TempBufSize] of char;
  TempBufPtr  = ^TempBufType;

{$IFDEF WINDOWS}
function ShowFormatConfig(cfg: Ptext; EBox: PEdit; var HighField: Integer;
                          SF: ShowFormatPtr;
                          PTempBuf: TempBufPtr; Source: PStream): string;
{$ENDIF}
procedure InitDb(var Pattern: PatRecPtr);


Implementation

const
  ParametersEnvInd     = 1;
  VideoModesEnvInd     = 2;
  MouseEnvInd          = 3;
  DESQviewEnvInd       = 4;
  WindowsEnvInd        = 5;
  PcConfigEnvInd       = 6;
  MemoryEnvInd         = 7;
  BibTeXEnvInd         = 8;
  CommaDelimitedEnvInd = 9;
  TibEnvInd            = 10;
  ReferEnvInd          = 11;
  ExportFormatEnvInd   = 12;

  NumberOfEnvs = 12;
  EnvLimits: array[1..NumberOfEnvs,1..2] of word =
    ((Par_Version,         Par_LastParameter-1  ),
     (Video_InitialMode,   Video_LastParameter-1),
     (Mous_Use,            Mous_LastParameter-1 ),
     (Desq_Mouse,          Desq_LastParameter-1 ),
     (Win_Mouse,           Win_LastParameter-1  ),
     (PcCon_MaxFileHandles,PcCon_LastParameter-1),
     (Mem_ReportMemory,    Mem_LastParameter-1  ),
     (Form_ImportVerify,   Form_LastParameter-1 ),
     (Form_ImportVerify,   Form_LastParameter-1 ),
     (Form_ImportVerify,   Form_LastParameter-1 ),
     (Form_ImportVerify,   Form_LastParameter-1 ),
     (Form_ImportVerify,   Form_LastParameter-1 )
  );


type
  Str1    = string[1];
  Ext4Str = string[4];
  Env15Str= string[15];
  FileExtStr = string[31];
  PParamObj = ^TParamObj;
  TParamObj = object(TObject)
    S: PString;
    Id: integer;
    constructor init(AS: string; AId: integer);
    destructor  done; virtual;
  end;

  PParamsCollection = ^TParamsCollection;
  TParamsCollection = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Integer; virtual;
  end;

constructor TParamObj.Init(AS: string; AId: integer);
begin
  TObject.Init;
  StrLwr(AS);
  S:=Nil; if AS<>'' then S:=NewStr(AS);
  id:=AId;
end;

destructor TParamObj.Done;
begin
  if S<>Nil then
  begin
    DisposeStr(S); S:=Nil;
  end;
  TObject.Done;
end;

function TParamsCollection.Compare(Key1, Key2: Pointer): Integer;
begin
  if PParamObj(Key1)^.S^<PParamObj(Key2)^.S^ then Compare:=-1
  else if PParamObj(Key1)^.S^>PParamObj(Key2)^.S^ then Compare:=1
  else Compare:=0;
end;

procedure NonPrintable(var s: string; InsStr: Str1);
var
  i,j,k,icode: integer;
  tmp: string;
begin  
  i:=ChrPosX(s,'\',1);
  while (i>0) and (i<=length(s)-2) do
  begin
    tmp:=''; j:=i+1;
    if s[j] in ['0'..'9'] then
    begin
      while (j<=length(s)) and (s[j] in ['0'..'9']) do
      begin
        tmp:=tmp+s[j]; inc(j);
      end;
      Val(tmp,k,icode); if icode<>0 then k:=-1;
    end else
    begin
      while (j<=length(s)) and (s[j] in ['A'..'Z'])
            and (length(tmp)<=2) do
      begin
        tmp:=tmp+s[j]; inc(j);
      end;
      if (tmp='DC') and (j<=length(s)) and (s[j] in ['1'..'4']) then
      begin
        tmp:=tmp+s[j]; inc(j);
      end;
      k:=-1; icode:=0;
      if      tmp='NUL' then k:=0
      else if tmp='SOH' then k:=1
      else if tmp='STX' then k:=2
      else if tmp='ETX' then k:=3
      else if tmp='EOT' then k:=4
      else if tmp='ENQ' then k:=5
      else if tmp='ACK' then k:=6
      else if tmp='BEL' then k:=7
      else if tmp='BS'  then k:=8
      else if tmp='HT'  then k:=9
      else if tmp='LF'  then k:=10
      else if tmp='VT'  then k:=11
      else if tmp='FF'  then k:=12
      else if tmp='CR'  then k:=13
      else if tmp='SO'  then k:=14
      else if tmp='SI'  then k:=15
      else if tmp='DLE' then k:=16
      else if tmp='DC1' then k:=17
      else if tmp='DC2' then k:=18
      else if tmp='DC3' then k:=19
      else if tmp='DC4' then k:=20
      else if tmp='NAK' then k:=21
      else if tmp='SYN' then k:=22
      else if tmp='ETB' then k:=23
      else if tmp='CAN' then k:=24
      else if tmp='EM'  then k:=25
      else if tmp='SUB' then k:=26
      else if tmp='ESC' then k:=27
      else if tmp='FS'  then k:=28
      else if tmp='GS'  then k:=29
      else if tmp='RS'  then k:=30
      else if tmp='US'  then k:=31;
    end;
    if k>255 then k:=-1;
    if k>-1 then StrRepl(s,'\'+tmp,InsStr+Chr(k),i,1,255);
    i:=ChrPosX(s,'\',i+1);
  end;
end;                         { NonPrintable }

function WhichMode(Sin: string; imp: boolean): byte;
var
  W,Last,i,nf: byte;
begin
  W:=0; nf:=0;
  if imp then Last:=LastImportFormat
  else Last:=LastFileFormat;
  StrLwr(Sin); ChrDel(Sin,' ');
  for i:=1 to Last do if Sin=FormatModes[i]^ then
  begin
    W:=i; inc(nf);
  end;
  if W=0 then
  begin
    nf:=0;
    for i:=1 to Last do
      if Pos(Sin,FormatModes[i]^)=1 then
      begin
        inc(nf); W:=i;
      end;
  end;
  if nf<>1 then W:=0;
  WhichMode:=W;
end;                                 { WhichMode }

function ShowFormatConfig(cfg: Ptext;
{$IFDEF WINDOWS}
                          EBox: PEdit;
{$ENDIF}
                          var HighField: Integer;
                          SF: ShowFormatPtr; PTempBuf: TempBufPtr;
                          Source: PStream): string;
{$IFDEF WINDOWS}
const
  LineBufSize = 256;
{$ENDIF}
var
  line, lline, tmp, tmp1: string;
  rep,fPre: string[3];
  i,ii,ifld,j,pl,si,nbr,nbr2,icode: integer;
  ind: Byte;
  index,Att1,Att2,Pmap: Byte;
  ch,ftyp,FieldChr: Char;
  found,AddEoln,CanBeField,CanBeType,CanBeFileFormat,OwnTempBuf: boolean;
  shf: text;
  oper: array[1..100] of Byte;
  ShowFormatLength,Segment,Offset: Word;
  igfield: array[1..maxfield+1] of boolean;
{$IFDEF WINDOWS}
  lcount,lind,l: longint;
  P: PChar;
  AddEnding: boolean;
{$ENDIF}

procedure TidyUp(Err: word; S: PString);
begin
  if OwnTempBuf then Dispose(PTempBuf);
  if Err<>0 then
  begin
    if S=Nil then ShowFormatConfig:=StringRC(Err,'')
    else ShowFormatConfig:=StringRC(Err,S^);
  end;
{$IFDEF WINDOWS}
  if P<>Nil then FreeMem(P,LineBufSize);
{$ENDIF}
end;

begin
  ShowFormatConfig:='';
  OwnTempBuf:=PTempBuf=Nil;
  if OwnTempBuf then New(PTempBuf);
  if SF<>Nil then with SF^ do
    if (len>0) and (p<>Nil) then 
    begin
      FreeMem(p,len); len:=0; p:=Nil;
    end;
  ShowFormatLength:=0;
  nbr:=1; oper[nbr]:=0;
{$IFDEF WINDOWS}
  lcount:=0; lind:=0; P:=Nil; AddEnding:=false;
  if EBox<>Nil then begin
    lcount:=EBox^.GetNumLines; P:=MemAlloc(LineBufSize);
  end;
{$ENDIF}
{     Format:
  #0  - NOP.
  #1  - Boldface.
  #2  - End attribute range (bf, color, case).
  #3  - \cr.  Character after is number of lines.
  #4  - \if.  After that, a list of fields and operations. Fields appear as
        128+number, entries as 50+number. *,^,+ appear as themselves.
        Special fields:
          #255 = Display;
          #254 = Windows printer;
          #253 = DOS version of BibDB;
          #252 = Windows version of BibDB;
          #251 = true;
          #250 = false;
          #249 to #250-NumUserFormats = Specific file formats;
          #50 = File header (i.e. Type=0).
  #5  - \elseif. Same as \if. Also \else appears as \elseif().
  #6  - end of logical block of \if and \elseif.
  #7  - <field>.   Next character is 128+field number. Special fields are:
          #249 = Full path name of current file;
          #250 = Current file drive;
          #251 = Current file path;
          #252 = Current file name;
          #253 = Current file extension;
          #254 = entry name;
          #255 = entry type.
  #8  - [[field]]. Next character is 128+field number.
  #9  - Reserved (TAB).
  #10 - Reserved (LF).
  #11 - <<field>>. Next character is 128+field number.
  #12 - \color. Character after is color attribute.
  #13 - Reserved (CR).
  #14 - Quote next character verbatim.
  #15 - Upper case.
  #16 - Lower case.
  #17 - Default case.
  #18 - END directive.
  #19 - <<<field>>>. Character following is 128+field number.
  #20 - \FF, Form Feed for Windows printing only, ignored by others.
  #23 - Explicit \.
  #24 - Explicit lbrace.
  #25 - Explicit rbrace.
  #26 - Explicit ;.
  #27 - Explicit <.
  #28 - Explicit >.
  #200+i - Closing brace of level i.
}
  repeat
    repeat
{$IFDEF WINDOWS}
      if EBox=Nil then readln(cfg^,line)
      else if AddEnding then
      begin
        line:=''; AddEnding:=false; P[0]:=#0;
        inc(lind);
      end else
      begin
        P[0]:=#0; line:='';
        l:=EBox^.GetLineLength(lind); if l>LineBufSize-1 then l:=LineBufSize-1;
        if not EBox^.GetLine(P,l+2,lind) then P[0]:=#0;
        if P[0]<>#0 then line:=StrPas(P);
        inc(lind);
      end;
{$ELSE}
      readln(cfg^,line);
{$ENDIF}
      if (Source<>Nil) then
      begin
        if line<>'' then Source^.write(line[1],length(line));
        tmp:=#13#10; Source^.write(tmp[1],length(tmp));
      end;
{$IFDEF WINDOWS}
      if (Ebox<>Nil) and (lind=lcount) and (line<>'') then AddEnding:=true;
{$ENDIF}
      ChrDelL(line,' ');
    until (line<>'') or ((cfg<>Nil) and eof(cfg^)) 
{$IFDEF WINDOWS}
               or ((EBox<>Nil) and (not AddEnding) and (lind>=lcount))
{$ENDIF}
               ;
    if line='' then
    begin
      line:=rbrace;
      if (Source<>Nil) then
      begin
        Source^.write(line[1],length(line));
        tmp:=#13#10; Source^.write(tmp[1],length(tmp));
      end;
    end;
    AddEoln:=true;

    i:=1; tmp:='';
    while i<=length(line) do
    begin
      if line[i]=';' then               { Comment character }
      begin
        AddEOLN:=false; i:=length(line);    
      end else if (line[i]='\') and (i<length(line)) then
      begin
        if line[i+1] in ['\',lbrace,rbrace,';','<','>','[',']'] then
        begin                       { Escaped special chars }
          tmp:=tmp+line[i+1]; inc(i);
        end else if StrCmpI(Copy(line,i,4),'\end',1,1,255)=0 then
        begin
          tmp:=tmp+sf_END; i:=i+3;
        end else if StrCmpI(Copy(line,i,3),'\ff',1,1,255)=0 then
        begin
{$IFDEF WINDOWS}
          tmp:=tmp+sf_FF;
{$ENDIF}
          i:=i+2;
        end else
        begin
          tmp1:=''; j:=i+1; rep:='';
          while (j<=length(line)) and (line[j]<>lbrace) do inc(j);
          if (j<=length(line)) and (line[j]=lbrace) then
          begin
            tmp1:=Copy(line,i+1,j-i-1); StrLwr(tmp1);
                 if tmp1='bf'     then rep:=sf_BF
            else if (tmp1='color') or (tmp1='colour') then Rep:=sf_Color
            else if tmp1='uc'     then Rep:=sf_UpCase 
            else if tmp1='lc'     then Rep:=sf_DnCase
            else if tmp1='dc'     then Rep:=sf_DefCase
            else if tmp1='cr'     then Rep:=sf_CR
            else if tmp1='if'     then Rep:=sf_If
            else if tmp1='elseif' then Rep:=sf_ElseIf
            else if tmp1='else'   then Rep:=sf_ElseIf+rbrace+lbrace
          end;
          if Rep<>'' then
          begin
            tmp:=tmp+Rep; i:=j; inc(nbr);  { Push brace }
          end else tmp:=tmp+line[i];
        end;
      end else if (line[i] in ['<','[']) and (i<length(line)+1) then  { fields }
      begin
        fPre:=Copy(line,i,3); ftyp:=#0; FieldChr:=#0;
        if fPre='<<<' then ftyp:=sf_Field3
        else begin
          delete(fPre,3,1);
          if fPre='<<' then ftyp:=sf_Field2
          else if fPre='[[' then ftyp:=sf_Field1
          else if fPre[1]='<' then
          begin
            ftyp:=sf_Field; delete(fPre,2,1);
          end else if fPre[1]='[' then
          begin
            ftyp:=sf_FldName; delete(fPre,2,1);
          end;
        end;
        if ftyp<>#0 then    { Found a field designator, I think }
        begin
          for j:=1 to length(fpre) do
            if fPre[j]='<' then fPre[j]:='>'
            else if fPre[j]='[' then fPre[j]:=']';
          j:=i+length(fPre); tmp1:='';
          while (j<=length(line)) and (line[j]<>fPre[1]) do
          begin
            tmp1:=tmp1+line[j]; inc(j);
          end;
          if (length(tmp1)<2) or (j>length(line)) or (line[j]<>fPre[1]) or
            (Copy(line,j,length(fPre))<>fPre) then ftyp:=#0
          else begin
            StrLwr(tmp1);
                 if tmp1='_file'      then FieldChr:=sfFld_flFull
            else if tmp1='_filedrive' then FieldChr:=sfFld_flDrive
            else if tmp1='_filepath'  then FieldChr:=sfFld_flPath
            else if tmp1='_filename'  then FieldChr:=sfFld_flName
            else if tmp1='_fileext'   then FieldChr:=sfFld_flExt
            else if tmp1=typefield^[StringIndex] then
                        FieldChr:=Chr(sfFld_Offset+StringIndex)
            else if tmp1='_name'      then FieldChr:=sfFld_Name
            else if tmp1='_type'      then FieldChr:=sfFld_Type
            else for ii:=1 to FieldLast do
              if tmp1=TypeField^[ii]  then
              begin
                FieldChr:=Chr(sfFld_Offset+ii);
                if ii>HighField then HighField:=ii;
              end;
            if FieldChr=#0 then fTyp:=#0;
          end;
          if ftyp<>#0 then    { ok }
          begin
            tmp:=tmp+ftyp+FieldChr;
            i:=j+length(fPre)-1;
          end else tmp:=tmp+line[i];
        end else tmp:=tmp+line[i];
      end else
      begin
        tmp:=tmp+line[i];
        if line[i]=lbrace then inc(nbr)
        else if line[i]=rbrace then dec(nbr);
      end;
      inc(i);
    end;
    NonPrintable(tmp,sf_Quote);
    if AddEoln then tmp:=tmp+sf_EOL;
    line:=tmp;

{    logstring(line);}

    if ShowFormatLength+length(line)>TempBufSize then
    begin
      TidyUp(Str_ShowBufTooBig,Nil); Exit;
    end;
    Move(line[1],Ptempbuf^[ShowFormatLength+1],length(line));
    ShowFormatLength:=ShowFormatLength+length(line);
{$IFDEF WINDOWS}
  until ((EBox<>Nil) and (not AddEnding) and (lind>=lcount))
        or ((cfg<>Nil) and eof(cfg^)) or (nbr<1);
{$ELSE}
  until eof(cfg^) or (nbr<1);
{$ENDIF}
  if nbr>0 then
  begin
    TidyUp(Str_ShowFormUnbalanced,Nil); Exit;
  end;
{
   Finished reading .CFG file
}
  nbr:=1; si:=0;
  while (si<ShowFormatLength) and (nbr>0) do
  begin
    inc(si);
    ch:=Ptempbuf^[si];
    if ch=sf_Quote then inc(si)    { Quote ASCII }
    else if ch in [sf_BF,sf_UpCase,sf_DnCase,sf_DefCase] then  { \bf,\uc,\lc,\dc }
    begin
      inc(nbr);
      oper[nbr]:=sf_Attrib;
      {
      if ch=#1 then message('\bf at level '+num2str(nbr))
      else if ch=#15 then message('\uc at level '+num2str(nbr));
      }
    end else if ch=sf_Color then   { \color }
    begin
      tmp:=''; pl:=si;
      repeat
        inc(si);
        if IsDigit(Ptempbuf^[si]) then PStrCat(tmp,Ptempbuf^[si],255);
      until not IsDigit(Ptempbuf^[si]);
      Val(tmp,Att1,icode);
      if (icode<>0) or (Att1<1) or (Att1>16) then
      begin
        TidyUp(Str_ShowColorErr,Nil); Exit;
      end;
      while Ptempbuf^[si] in [' ',#9] do inc(si);
      if (Ptempbuf^[si]<>rbrace) or (Ptempbuf^[si+1]<>lbrace) then
      begin
        TidyUp(Str_ShowColorErr,Nil); Exit;
      end;
      inc(si);
      Ptempbuf^[pl+1]:=Chr(Att1);
      for i:=pl+2 to si do Ptempbuf^[i]:=sf_NOP;
      inc(nbr);
      oper[nbr]:=sf_Attrib;
      { message('\color at level '+num2str(nbr)); }
    end else if ch=lbrace then { dummy open brace }
    begin
      ch:=sf_NOP; {Ptempbuf^[si]:=#0;}      { %%%%%%%%%%%%%%%%% }
      inc(nbr);
      oper[nbr]:=0;
    end else if ch=sf_CR then   { \cr }
    begin
      tmp:=''; pl:=si;
      if PTempBuf^[si+1]='-' then
      begin
        tmp:=tmp+PTempBuf^[si+1]; inc(si);
      end;
      repeat
        inc(si);
        if IsDigit(Ptempbuf^[si]) then PStrCat(tmp,Ptempbuf^[si],255);
      until not IsDigit(Ptempbuf^[si]);
      while Ptempbuf^[si]<>rbrace do inc(si);
      if tmp='' then tmp:='1';
      Val(tmp,j,icode);
      if (j<0) and (j>-128) then j:=256+j;
      if (j<0) or (j>255) then j:=0;
      Ptempbuf^[pl+1]:=Chr(j);
      for i:=pl+2 to si do Ptempbuf^[i]:=sf_NOP;
    end else if (ch=sf_If) or (ch=sf_ElseIf) then    { \if and \elseif and \else }
    begin
      tmp:=''; pl:=si+1;
      repeat
        inc(si);
        if Ptempbuf^[si]<>rbrace then PStrCat(tmp,Ptempbuf^[si],255);
      until Ptempbuf^[si]=rbrace;
      index:=1;
      if tmp<>'' then
      repeat
        tmp1:='';
        WrdToken(tmp1,tmp,' ,',index);
        if (tmp1=sfIf_NOT) or (tmp1=sfIf_OR) or (tmp1=sfIf_AND) then
        begin
          Ptempbuf^[pl]:=tmp1[1];
          inc(pl);
        end else if (length(tmp1)>0) and IsAlpha(tmp1[1]) then
        begin
          StrLwr(tmp1);
          found:=false;
          CanBeField:=true; CanBeType:=true;
          CanBeFileFormat:=false;
          if (length(tmp1)>2) and (tmp1[2] in ['''','`']) then
          begin
            if tmp1[1]='t' then CanBeField:=false
            else if tmp[1]='f' then CanBeType:=false
            else if tmp[1]='x' then
            begin
              CanBeField:=false; CanBeType:=false;
              CanBeFileFormat:=true;
            end else
            begin
              tmp:=tmp[1];
              TidyUp(Str_UnknownPrefix,@tmp); Exit;
            end;
            Delete(tmp1,1,2);
          end;
          i:=0;
          if CanBeField then
          begin
            if tmp1=StringFieldName then
            begin
              found:=true;
              Ptempbuf^[pl]:=Chr(sfIf_Field+StringIndex);
              inc(pl);
            end else
            repeat
              inc(i);
              if tmp1=typefield^[i] then
              begin
                found:=true;
                Ptempbuf^[pl]:=Chr(sfIf_Field+i);
                inc(pl);
              end;
            until found or (i>=fieldlast);
          end;
          i:=0;
          if CanBeType and (not found) and (tmp1='_header') then
          begin
            found:=true;
            Ptempbuf^[pl]:=sfIf_Header;
            inc(pl);
          end;
          if CanBeType and (not found) then
          repeat
            inc(i);
            if tmp1=TypeEntry^[i] then
            begin
              found:=true;
              Ptempbuf^[pl]:=Chr(sfIf_Type+i);
              inc(pl);
            end;
          until found or (i>=StringTypeInd);
          if (not found) and CanBeFileFormat and (Pos('display',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_Display; inc(pl);
          end else if (not found) and CanBeFileFormat and (Pos('print',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_WinPrint; inc(pl);
          end else if (not found) and CanBeFileFormat and (Pos('dos',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_Dos; inc(pl);
          end else if (not found) and CanBeFileFormat and (Pos('windows',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_Windows; inc(pl);
          end else if (not found) and CanBeFileFormat and (Pos('true',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_true; inc(pl);
          end else if (not found) and CanBeFileFormat and (Pos('false',tmp1)=1) then
          begin
            found:=true; Ptempbuf^[pl]:=sfIf_false; inc(pl);
          end else if (not found) and CanBeFileFormat then
          begin
            i:=WhichMode(tmp1,false);
            if i>=FirstUserFormat then
            begin
              i:=i+1-FirstUserFormat;
              found:=true;
              Ptempbuf^[pl]:=Chr(sfIf_LastForm+1-i);
            end;
            inc(pl);
          end;
          if not found then
          begin
            TidyUp(Str_SFUnknownField,@tmp1); Exit;
          end;
        end else index:=0;
      until index=0;
      for i:=pl to si do Ptempbuf^[i]:=sf_NOP;
      inc(si);
      if Ptempbuf^[si]<>lbrace then
      begin
        TidyUp(Str_MissingIfBrace,Nil); Exit;
      end;
      Ptempbuf^[si]:=sf_EndIf;
      inc(nbr);
      oper[nbr]:=nbr;
    end else if ch=rbrace then
    begin
      if oper[nbr]=sf_Attrib then Ptempbuf^[si]:=sf_EndAtt
      else if oper[nbr]=0 then {Ptempbuf^[si]:=#0}   { %%%%%%%%%%%%%%%%% }
      begin
        if nbr=1 then PTempBuf^[si]:=sf_NOP;  { Trailing right brace }
      end else Ptempbuf^[si]:=Chr(nbr+sf_EndBrace);
      dec(nbr);
    end;
  end;
  Ptempbuf^[si+1]:=sf_CR; Ptempbuf^[si+2]:=#0;       { \cr(0) }
  si:=si+2;
{  Ptempbuf^[si+1]:='A'; si:=si+1;}
  for j:=FieldLast+1 to MaxField do
  begin
    Ptempbuf^[si+1]:=sf_Field1; Ptempbuf^[si+2]:=Chr(sfFld_Offset+j);
    si:=si+2;
  end;
  ShowFormatLength:=si;
  if SF<>Nil then with SF^ do
  begin
    GetMem(p,ShowFormatLength);
    move(Ptempbuf^[1],p^,ShowFormatLength);
    len:=ShowFormatLength;
  end;

  if OwnTempBuf then Dispose(PTempBuf); 

  {message(' Main ShowFormat is '+num2str(ShowFormatLength)+' bytes long. ');}
  {
  Assign(shf,'false.buf');
  rewrite(shf);
  decode;
  close(shf);
  } 
end;                               { ShowFormatConfig }

Procedure InitDb(var Pattern: PatRecPtr);
Const
  NumOptionNames = 3;
  COpt_a=1; COpt_c=2; COpt_h=3; COpt_p=4; COpt_s=5; COpt_x=6;
  COpt_mono=7; COpt_color=8; COpt_test=9; COpt_link=10;
  COpt_debug=11; COpt_readonly=12; COpt_latex=13; COpt_tag=14;
  COpt_if=15; COpt_xf=16;
  COpt_ent=17; COpt_str=18; COpt_l=19;
{$IFDEF WINDOWS}
  COpt_ini=20; COpt_Max=21; Copt_Min=22; Copt_noRAM=23;
  LastOpt=COpt_noRAM;
{$ELSE}
  COpt_noems=20; COpt_noxms=21;
  COpt_save=22; COpt_nosave=23;
  COpt_25=24; COpt_28=25; COpt_30=26; COpt_33=27; COpt_34=28; COpt_35=29; 
  COpt_40=30; COpt_43=31; COpt_48=32; COpt_50=33; COpt_60=34;
  COpt_vmode=35; COpt_multi=36; COpt_nomouse=37;
  LastOpt = COpt_nomouse;
  NumOfVGAModes = 10;
{$ENDIF}
Type
{$IFNDEF WINDOWS}
  Win3xType = record
    nomouse,noxms,noems,shell,clip: boolean;
  end;
  DESQviewType = record
    nomouse,noxms,noems,shell,virtualize: boolean;
    hardfirst,hardlast: integer;
  end;
  VGAModesType = record
    lines: byte;
    on,VGA: boolean;
  end;
{$ENDIF}
  OptionTypeRec = record
    Name: array[1..NumOptionNames] of string[10];
    Found,quote: boolean;
    S: Pstring;
  end;
  TempOverType = array[1..MaxOverView] of string;
  TFilesList = array[1..MaxBibFiles] of string;
var
{ Buffers for string pointers }
{$IFNDEF WINDOWS}
  S_S: string;
  S_CLineFilesList: TFilesList;
{$ENDIF}
  Dir,Name,S,PatternFile,fname: Pstring;
  tmp,AuxDir,TexInput: string;
  PattString,DefPatternScope: string;
  AdapterString,KeyboardString: string[10];
  ImportFormatString,ExportFormatString: ItemStringType;
  ind,j,k,l,ifld,itmp,index,EditFieldsDef,nbibfiles,ffi: byte;
  StartupMode,StartupLen,PatOptFirst,PatOptLast,SrOptFirst,SrOptLast: byte;
  bibattr,i,SavedScreenSize: Word;
  nbrace,NormHardFirst,NormHardLast,icode: integer;
  VFileSize,MemoryUsed,M,MU,MaxCache: longint;
  DoSelfTest,Bjunk,ok,MustExist,AuxSpecified,DumpSpecified,finish: boolean;
  VersionSpecified,SaveTheScreen,TryString,AlwaysTimeout: Boolean;
  UseClipBoard,InputLatexFile,Includes,SelectTagged,accept: Boolean;
  ch,drive: char;
  TempOver: ^TempOverType;
  tmpfile,cfg: text;
{$IFDEF WINDOWS}
  BstInput: string;
  FBuf: array[0..255] of char;
  CmdStr_ini: PString;
  ConfigFileVersion: string[20];
{$ELSE}
  Win3x: Win3xType;
  RealTempOver: TempOverType;
  CodePageStr: string[63];
  ColorScr: ColorScrType;
  MultiTaskerStr: string[63];
  CmdStr_vmode: string[63];
  DESQviewOpts: DESQviewType;
  TempBuf: TempBufType;
  VGAModes: array[1..NumOfVGAModes] of VGAModesType;
  VModeStrList: array[1..MaxVidModes] of ItemStringType;
  CmdStr_a: string;
{$ENDIF}
  Option: array[1..LastOpt] of OptionTypeRec;
  CmdStr_x: string;
  CmdStr_if,CmdStr_xf: string[63];
  CmdStr_c: PString;
  CLineFiles: byte;
  CLineFilesList: ^TFilesList;

procedure ScanOneFile(var aux: text; fn,Home: PString);
var
  KeptPos: longint;
  fn2: PString;
  k: integer;
begin
  if fn=Nil then
  begin
    logstring('Scan1 0'); Exit;
  end;
  if fn^='' then
  begin
    logstring('Scan1 1'); Exit;
  end;
  logstring('Scan1 2 "'+fn^+'","'+Home^+'"');
  if nbibfiles>=MaxBibFiles then
  begin
    logstring('Scan1 3 '+num2str(nbibfiles)); Exit;
  end;

  fn2:=Nil;
  if (nbibfiles>=MaxBibFiles) or (fn=Nil) or (fn^='') then Exit;

  if ((Pos('\',fn^)=0) and not LFNFileExist(Home^+fn^)) or
     ((Pos('\',fn^)>0) and not LFNFileExist(fn^)) then
  begin
    logstring('Scan1 4'); Exit;
  end;

  logsection('ScanOneFile',true);

  if Pos('\',fn^)=0 then LFNAssign(aux,Home^+fn^) else LFNAssign(aux,fn^);
  LFNreset(aux,0);

  logstring('Assigned');

  while (nbibfiles<=MaxBibFiles) and not eof(aux) do
  begin
    ReadLine(aux,tmp,true);
    logstring('Read "'+tmp+'"');
    ChrDel(tmp,' ');
    i:=Pos(lbrace,tmp);
    if (i=0) or (tmp='') or (tmp[1]<>'\') then   { nothing }
    else if Copy(tmp,1,i-1)='\@input' then  { Include file }
    begin
      fn2:=NewStr(Copy(tmp,i+1,length(tmp)-i-1));
      StrRepl(fn2^,'/','\',1,255,255);
      logstring('Found file "'+fn2^+'"');

      KeptPos:=TextFilePos(aux); LFNClose(aux);
      ScanOneFile(aux,fn2,Home);
      DisposeStr(fn2); fn2:=Nil;

      if Pos('\',fn^)=0 then LogString('Return to "'+Home^+fn^+'"')
      else logstring('Return to "'+fn^+'"');
      if Pos('\',fn^)=0 then LFNAssign(aux,Home^+fn^) else LFNAssign(aux,fn^);
      LFNreset(aux,0);
      TextSeek(aux,KeptPos);
    end else if Copy(tmp,1,i-1)='\bibdata' then {bingo}
    begin          { Got a live one }
      logstring('Got a live one!');
      Ind:=i+1;
      while (ind>0) and (ind<=length(tmp)) do
      begin
        WrdToken(S^,tmp,lbrace+rbrace+' ,'+#9,Ind);
        if (S^<>'') and (nbibfiles<MaxBibFiles) then
        begin
          j:=0;
          StrRepl(S^,'/','\',1,255,255);
          logstring('its "'+S^+'"');
          for k:=1 to nbibfiles do
            if S^=bibfiles^[k].name then j:=k;
          if j=0 then
          begin
            Inc(nbibfiles);
            bibfiles^[nbibfiles].name:=S^;
            logstring('  Adding it to list as #'+num2str(nbibfiles));
          end;
        end;
      end;
    end;
  end;
  LFNClose(aux);
  logsection('ScanOneFile',false);
end;                  { ScanOneFile }


procedure GetRidOfComment(var line: string);
var
  tmp: string;
begin
  tmp:=line; UnTabify(tmp); ChrDelL(tmp,' ');
  if (tmp<>'') and (tmp[1] in CommentSet) then line:='';
end;

{$IFNDEF WINDOWS}
function ReadVidMode(s: string): byte;
var
  itmp: byte;
  icode: integer;  
begin        { ReadVidMode }
  itmp:=0; icode:=0;
  ChrDel(s,' '); ChrDel(s,'$');
  if s='' then icode:=1
  else if s[1]='#' then
  begin
    delete(s,1,1);
    Val(s,itmp,icode);
  end else
  begin
    if length(s)=1 then s:='0'+s;
    if s[2] in ['0'..'9'] then itmp:=itmp+Ord(s[2])-Ord('0')
    else if s[2] in ['a'..'f'] then itmp:=itmp+Ord(s[2])-Ord('a')+10
    else icode:=1;
    if s[1] in ['0'..'9'] then itmp:=itmp+16*(Ord(s[1])-Ord('0'))
    else if s[1] in ['a'..'f'] then 
      itmp:=itmp+16*(Ord(s[1])-Ord('a')+10)
    else icode:=1;
  end;
  if icode=0 then ReadVidMode:=itmp
  else ReadVidMode:=0;
end;                               { ReadVidMode }
{$ENDIF}

procedure PathListConfig(var PathListStr: string; var PathList: PathListPtr);
var
  Index,l: byte;
  Path,CurrentPath: string;
  Recurse,Sub,first: boolean;
  Home: PathListPtr;

procedure AddPath(Path: string);
var
  Root: PathListPtr;
begin
  if Path='' then Exit;
  if (Path<>'')  and (Path[length(Path)]<>'\') then Path:=Path+'\';
  CanonicalFName(Path);
  if IsDirName(Path) then
  begin
    Root:=Home;
    while (Root<>Nil) and (Root^.P<>Nil) do
    begin
      if StrCmpI(Root^.P^,Path,1,1,255)=0 then Exit;
      Root:=Root^.Next;
    end;
    if first then
    begin
      New(PathList); first:=false; Home:=PathList; PathList^.Back:=Nil;
    end else
    begin
      New(PathList^.Next);
      PathList^.Next^.Back:=PathList; PathList:=PathList^.Next;
    end;
    PathList^.Next:=Nil;
    PathList^.P:=NewStr(Path);
{    message('Added "'+Path+'"');}
  end else ErrorMessageRC(Str_IllegalPath,Path);
end;                            { AddPath }

{$IFDEF WINDOWS}

procedure AddTree(var Path: string; Recurse: boolean);
var
  S: PLFNSearchRec;
  ch: char;
  Plen: byte;
  P: PChar;
begin
  if Path='' then Exit;
  if IsDirName(Path) then
  begin
    if Path[length(Path)]<>'\' then Path:=Path+'\';
    Plen:=length(Path);
    AddPath(Path);
    {
    GetMem(P,Plen+5);
    StrPCopy(P,Path+'*.*');
    FindFirst(P,faDirectory,S);
    FreeMem(P,Plen+5);
    }
    New(S);
    LFNFindFirst(Path+'*.*',faDirectory,S^);
    while DosError=0 do
    begin
      if (StrComp(S^.Name,'.')<>0) and (StrComp(S^.Name,'..')<>0) then
      begin
        Path:=Path+StrPas(S^.Name);
        if (S^.Attr and faDirectory <> 0) then     
        begin
          if Recurse then AddTree(Path,Recurse)
          else AddPath(Path);
        end;
        Path[0]:=Chr(Plen);
      end;
      LFNFindNext(S^);
    end;
    LFNFindClose(S^);
    Dispose(S);
  end else ErrorMessageRC(Str_IllegalPath,Path);
end;                           { AddTree }

{$ELSE}

procedure AddTree(var Path: string; Recurse: boolean);
var
  S: PLFNSearchRec;
  Plen: byte;
begin
  if Path='' then Exit;
  if IsDirName(Path) then
  begin
    if Path[length(Path)]<>'\' then Path:=Path+'\';
    Plen:=length(Path);
    AddPath(Path);
    New(S);
    LFNFindFirst(Path+'*.*',Directory,S^);
    while DosError=0 do
    begin
      if (StrPas(PCharOf(S^.Name))<>'.') and (StrPas(PCharOf(S^.Name))<>'..') then
      begin
        Path:=Path+StrPas(PCharOf(S^.Name));
        if (S^.Attr AND Directory)<>0 then
        begin
          if Recurse then AddTree(Path,Recurse)
          else AddPath(Path);
        end;
        Path[0]:=Chr(Plen);
      end;
      LFNFindNext(S^);
    end;
    LFNFindClose(S^); Dispose(S);
  end else ErrorMessageRC(Str_IllegalPath,Path);
end;                           { AddTree }
{$ENDIF}

begin                       { PathListConfig }
  Home:=Nil;
  Index:=1; first:=true;
  ChrDelL(PathListStr,' '); ChrDelR(PathListStr,' ');
  StrRepl(PathListStr,'/','\',1,255,255);
  repeat
    Path:=''; WrdToken(Path,PathListStr,';',Index);
    Sub:=false; Recurse:=false;
    if (Path<>'') and (Path[length(Path)]='!') then
    begin
      Sub:=true; Delete(Path,length(Path),1);
      if (Path<>'') and (Path[length(Path)]='!') then
      begin
        Recurse:=true; Delete(Path,length(Path),1);
      end;
    end;
    if Path<>'' then
    begin
      Path:=LFNFExpand(Path); {StrLwr(Path);}
      if Sub then AddTree(Path,Recurse)            { Subdirectory search }
      else AddPath(Path);
    end;
  until Index=0;
  PathList:=Home;
end;                                  { PathListConfig }

procedure FileExtension(var pvalue: string; name: FileExtStr; var Ext: PString);
var
  ok: boolean;
  i: integer;
begin
  if Ext<>Nil then DisposeStr(Ext); Ext:=Nil;
  if pvalue='' then Exit;
  if pvalue[1]='.' then Ext:=NewStr(pvalue)
  else Ext:=NewStr('.'+Pvalue);
  ok:=true;
  for i:=2 to length(Ext^) do
    if not IsFile(Ext^[i]) then ok:=false;
  if not ok then
    FatalErrorRC(Str_IllegalCharInDef,name);
end;                          { FileExtension }

{%R-}

procedure ParametersConfig(env: integer);
const
  TokenStr = '='+lbrace+rbrace;
var
  index,ind2,itmp: byte;
  wtmp,ii: Word;
  nbr,nbr2,icode,i,j,k,ParamInd: integer;
  ftemp,factor,iii: LongInt;
  line,tline,param,pvalue,tmp2,tmp3: string;
  notparam,ok: boolean;
  ParamsList: TParamsCollection;

{$IFNDEF WINDOWS}
procedure PcConfigEnv;
var
  icode: integer;
begin
  if ParamInd=PcCon_MaxFileHandles then
  begin
    Val(pvalue,MaxFileHandles,icode);
    if icode<>0 then MaxFileHandles:=15;
  end else if ParamInd=PcCon_keyboard         then KeyboardString:=pvalue
  else if ParamInd=PcCon_VideoAdapter         then AdapterString:=pvalue
  else if ParamInd=PcCon_AltPrtscRoutine      then AltPrtScRoutine:=IsOn(pvalue)
  else if ParamInd=PcCon_FixVideoMode         then
  begin
    if IsOn(pvalue) then FixedVideoMode:=3;
  end else if ParamInd=PcCon_Codepage         then
  begin
    if (pvalue='us') or (Pos('437',pvalue)+pos('united',pvalue)>0) then
      CodePageStr:='US'
    else if Pos('850',pvalue)+Pos('Multi',pvalue)+Pos('latin i',pvalue)>0 then
      CodePageStr:='multilingual'
    else if Pos('auto',pvalue)>0 then CodePageStr:='autodetect'
    else if Pos('none',pvalue)>0 then CodePageStr:='none';
  end;
end;                         { PcConfigEnv }
{$ENDIF}

procedure MemoryEnv;
var
  l: longint;
  i: integer;
begin
  if ParamInd=Mem_ReportMemory       then ReportMemory:=IsOn(pvalue)
  else if ParamInd=Mem_SaveScreen    then SaveTheScreen:=IsOn(pvalue)
  else if ParamInd=Mem_VirtualMemory then
  begin
    UseVirtualMemory:=Pos('off',pvalue)+Pos('no',pvalue)=0;
    ForceKeepInStream:=Pos('force',pvalue)+Pos('file',pvalue)>0;
  end else if ParamInd=Mem_BibFileBufSize then
  begin
    Val(pvalue,ii,icode);
    if (icode=0) and (ii>=MinFileBufSize) and (ii<=MaxFileBufSize) then
      FileBufSize:=ii;
  end else if ParamInd=Mem_AuxFileBufSize then
  begin
    Val(pvalue,ii,icode);
    if icode=0 then AuxBufSize:=ii;
  end else if ParamInd=Mem_BigFields        then
  begin
    Ind2:=1; tmp2:='';
    WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
    Val(tmp2,ii,icode);
    if icode=0 then
    begin
      if ii<0 then MaxNumberBig:=0
      else if ii>Maxfield then MaxNumberBig:=Maxfield
      else MaxNumberBig:=ii;
      if Ind2>0 then
      begin
        WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
        Val(tmp2,ii,icode);
        if icode=0 then
        begin
          if ii>MaxMaxBig then MaxBig:=MaxMaxBig
          else if ii>255 then MaxBig:=ii
          else MaxBig:=255;
        end;
      end;
    end;
  end else if ParamInd=Mem_EntryCacheSize then
  begin
    ii:=0;
    i:=Pos('k',pvalue); if i=0 then i:=Pos('K',pvalue);
    if i>0 then
    begin
      delete(Pvalue,i,255); ii:=1;
    end;
    Val(pvalue,l,icode);
    if (icode=0) and (l>=0) then
    begin
      MaxCache:=l; if ii=1 then MaxCache:=MaxCache*1024;
    end;
  end else if ParamInd=Mem_EntryCacheDir then
  begin
    if (pvalue<>'') and (pvalue[length(pvalue)]<>'\') then
      pvalue:=pvalue+'\';
    if (pvalue<>'') and (pvalue[1]<>'\') and
      ((length(pvalue)<2) or (pvalue[2]<>':') ) then
        pvalue:=ProgramDir^+pvalue;
    StrLwr(Pvalue);
    if (pvalue<>'') and IsDirName(pvalue) then CacheDir^:=pvalue;
  end else if ParamInd=Mem_AutoLoadCache then
  begin
    AutoLoadCache:=Pos('load',pvalue)>0;
    AutoSaveCache:=Pos('save',pvalue)>0;
  end
{$IFDEF WINDOWS}
  else if ParamInd=Mem_UseRam then UseRAMStream:=IsOn(pvalue)
{$ELSE}
  else if ParamInd=Mem_UseXms then XmsExists:=XmsExists and IsOn(pvalue)
  else if ParamInd=Mem_UseEms then EmsExists:=EmsExists and IsOn(pvalue)
  else if ParamInd=Mem_Swap then
  begin
    Execswap:=(Pos('off',line)+Pos('no',line)=0);
    SwapMode:=Swap_Disk;
    if Pos('ems',line)>0 then SwapMode:=SwapMode+Swap_EMS;
    if Pos('xms',line)>0 then SwapMode:=SwapMode+Swap_XMS;
    if Pos('ext',line)>0 then SwapMode:=SwapMode+Swap_EXT;
    if IsOn(line) then SwapMode:=Swap_ALL;
  end else if ParamInd=Mem_SwapDir then SwapDir:=pvalue
{$ENDIF}
  else if (not AuxSpecified) and (ParamInd=Mem_AuxDir) and (pvalue<>'') then
        auxdir:=pvalue;
{$IFDEF WINDOWS}
  MaxNumberBig:=MaxField;
  MaxBig:=$7FF0;
{$ENDIF}
end;                      { MemoryEnv }

{$IFNDEF WINDOWS}
procedure WindowsEnv;
begin
  if ParamInd=Win_Mouse             then Win3x.nomouse:=not IsOn(pvalue)
  else if ParamInd=Win_Ems          then Win3x.noems:=not IsOn(pvalue)
  else if ParamInd=Win_Xms          then Win3x.noxms:=not IsOn(pvalue)
  else if ParamInd=Win_DosShell     then Win3x.shell:=IsOn(pvalue)
  else if ParamInd=Win_UseClipboard then Win3x.clip :=IsOn(pvalue);
end;                      { WindowsEnv }

procedure DESQviewEnv;
begin
  if ParamInd=Desq_Mouse             then DESQviewOpts.nomouse:=not IsOn(pvalue)
  else if ParamInd=Desq_Ems          then DESQviewOpts.noems:=not IsOn(pvalue)
  else if ParamInd=Desq_Xms          then DESQviewOpts.noxms:=not IsOn(pvalue)
  else if ParamInd=Desq_DosShell     then DESQviewOpts.shell:=IsOn(pvalue)
  else if ParamInd=Desq_Virtualize   then DESQviewOpts.virtualize:=IsOn(pvalue)
  else if ParamInd=Desq_HmouseCursor then
  begin
    ind2:=1; tmp2:=''; tmp3:='';
    WrdToken(tmp2,pvalue,'-.fromt',ind2);
    if ind2>0 then WrdToken(tmp3,pvalue,'-.fromt',ind2);
    Val(tmp2,DESQviewOpts.hardfirst,icode);
    if icode=0 then Val(tmp3,DESQviewOpts.hardlast,icode);
    if icode<>0 then
    begin
      DESQviewOpts.hardfirst:=-1; DESQviewOpts.hardlast:=-1;
    end;
  end;
end;                         { WindowsEnv }

procedure VideoModesEnv;
begin
  if (ParamInd=Video_InitialMode) then
  begin
    Ind2:=1; tmp2:='';
    StrRepl(pvalue,'vga','vga ',1,255,255);
    StrRepl(pvalue,'ega','ega ',1,255,255);
    WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
    if (tmp2='mda') or (tmp2='cga') or (tmp2='ega') or 
       (tmp2='vga') then
    begin
      CurrentLen:=25; CurrentMode:=$FF;
      WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
      tmp2:=tmp2+'    '; tmp2:=tmp2[1]+tmp2[2];
      Val(tmp2,CurrentLen,icode);
    end else if (tmp2='startup') or (tmp2='none') then CurrentMode:=0
    else if tmp2<>'' then CurrentMode:=ReadVidMode(tmp2);
  end else if (length(param)=9) and (Copy(param,1,4)='show') and
          (Copy(param,7,3)='x80') then
  begin
    Val(Copy(param,5,2),i,icode);
    if icode=0 then
    begin
      j:=1; while (j<=NumOfVGAModes) and (VGAModes[j].lines<>i) do inc(j);
      if j<=NumOfVGAModes then VGAModes[j].on:=IsOn(pvalue);
    end;
  end else if ParamInd=Video_NewVideoMode then
  begin
    j:=0;
    ind2:=1; tmp:=''; WrdToken(tmp,tline,#9+';,-.',ind2);
    ChrDelR(tmp,' ');
    j:=ReadVidMode(tmp);
    Delete(tline,1,ind2); ChrDelL(tline,' ');
    if (j>0) and (tline<>'') and (NVidModes<MaxVidModes) then
    begin
      Inc(NVidModes);
      VModeList[NVidModes]:=j;
      VModeStrList[NVidModes]:=tline;
    end;
  end;
end;                     { VideoModesEnv }

procedure MouseEnv;
begin
  if      ParamInd=Mous_Use         then UseMouse:=IsOn(pvalue)
  else if ParamInd=Mous_WideScreen  then WideScreenMouse:=IsOn(pvalue)
  else if ParamInd=Mous_Sensitivity then
  begin
    if pvalue='startup' then
    begin
      Xmotions:=0; YMotions:=0;
    end else
    begin
      i:=Xmotions; Val(pvalue,i,icode);
      if icode=0 then
      begin
        if i<1 then i:=1;
        Xmotions:=i; Ymotions:=i;
      end;
    end;
  end else if (ParamInd=Mous_Reset) then
    SoftwareMouseReset:=(Pos('soft',pvalue)>0)
  else if (ParamInd=Mous_HardwareCursor) and
    (pvalue<>'off') and (pvalue<>'no') and (pvalue<>'false') and
    (pvalue<>'0') then
  begin
    NormHardFirst:=0; NormHardLast:=0;
    ind2:=1;
    WrdToken(tmp2,pvalue,' ,;.:-=to'+lbrace+rbrace+#9,ind2);
    Val(tmp2,NormHardFirst,icode);
    if ind2>0 then
    begin
      WrdToken(tmp2,pvalue,' ,;.:-to'+lbrace+rbrace+#9,ind2);
      if icode=0 then Val(tmp2,NormHardLast,icode);
    end;
    if NormHardFirst=0 then NormHardFirst:=1;
    if NormHardLast=0 then NormHardLast:=13;
    HardWareCur:=true;
    if not IsMDA then
    begin
      if NormHardFirst>7 then NormHardFirst:=7;
      if NormHardlast>7 then NormHardlast:=7
    end;
  end;
end;                     { MouseEnv }
{$ENDIF}

procedure FileFormatEnv;
var
  CurFileFormat: byte;
  i: integer;
begin
  CurFileFormat:=0;
  if      env=BibtexEnvInd         then CurFileFormat:=BibTeXFormat
  else if env=CommaDelimitedEnvInd then CurFileFormat:=CommaDelimited
  else if env=TibEnvInd            then CurFileFormat:=TibFormat
  else if env=ReferEnvInd          then CurFileFormat:=ReferFormat
  else if env=ExportFormatEnVInd   then CurFileFormat:=FirstUserFormat+NumUserFormats-1;
  if ParamInd=Form_ImportVerify    then
  begin
    StrLwr(pvalue);
    if (pvalue='off') or (pvalue='none') then
                                       Verify[CurFileFormat]:=VerifyOff
    else if Pos('label',pvalue)>0 then Verify[CurFileFormat]:=VerifyLabel
    else if (pvalue='on') or (pvalue='entry') or (pvalue='all') then
      Verify[CurFileFormat]:=VerifyEntry;
  end else if ParamInd=Form_Width    then
  begin
    Val(pvalue,ii,icode);
    if icode=0 then LineWidth[CurFileFormat]:=ii;
  end else if ParamInd=Form_DefaultExtension then
    FileExtension(pvalue,'DefaultExtension',DefExtension[CurFileFormat])
  else if ((env=TibEnvInd) or (env=ReferEnvInd)) and (ParamInd=Form_Labels) then
  begin
    ChrDel(pvalue,','); ChrDel(pvalue,' ');
    ChrDel(pvalue,'%'); ChrDel(pvalue,';');
    StrUpr(pvalue);
    if env=TibEnvInd then TibLabels:=pvalue
    else if env=ReferEnvInd then
    begin
      StrUpr(pvalue); ReferLabels:=pvalue;
    end;
  end else if ParamInd=Form_ExportFile then
  begin
    StrLwr(pvalue);
    if not IsFileName(pvalue) then ErrorMessageRC(Str_ExpInvalid,pvalue)
    else DumpFileList^[CurFileFormat]:=pvalue;
  end else if env=BibtexEnvInd then
  begin
    if ParamInd=Form_ProcessStrings          then EditOnlyStrings:=IsOn(pvalue)
    else if ParamInd=Form_FieldDelimit       then
                       DelimitBrace[false]:=(Pos('brace',pvalue)>0)
    else if ParamInd=Form_StringFieldDelimit then
                       DelimitBrace[true]:=(Pos('brace',pvalue)>0);
  end else if env=CommaDelimitedEnvInd then
  begin
    if ParamInd=Form_Separator then
    begin
      NonPrintable(tline,''); CommaSeparator:=tline[1];
    end;
  end else if env=TibEnvInd then
  begin
    if ParamInd=Form_Macros then
    begin
      StrLwr(pvalue);
      i:=Pos('import',pvalue); j:=pos('export',pvalue);
      if (i=0) and (j=0) then TibMacros:=NotImpOrExp
      else if i=0 then TibMacros:=ExpOnly
      else if j=0 then TibMacros:=ImpOnly
      else TibMacros:=ImpAndExp;
    end;
  end else if env=ExportFormatEnvInd then
  begin
    if (ParamInd=Form_Name) then
    begin
      tmp:=tline;
      i:=Pos(',',tline);
      if i>0 then
      begin
        tmp[0]:=Chr(i-1);
        Delete(tline,1,i); ChrDel(tline,' ');
        UserFormatChars:=UserFormatChars+UpCase(tline[1]);
      end else
      begin
        i:=1;
        while (i<=length(tline)) and (tline[i]>='A') and
              (tline[i]<='Z') do inc(i);
        if i<=length(tline) then
          UserFormatChars:=UserFormatChars+UpCase(tline[i]);
      end;
      ChrDelR(tmp,' '); ChrDelL(tmp,' ');
      UserFormatName[CurFileFormat]:=NewStr(tmp);
      ChrDel(tmp,' '); StrLwr(tmp);
      if FormatModes[CurFileFormat]<>Nil then
      DisposeStr(FormatModes[CurFileFormat]);
      FormatModes[CurFileFormat]:=NewStr(tmp);
    end else if (ParamInd=Form_BoldfaceOn) or (ParamInd=Form_BoldfaceOff) or
      (ParamInd=Form_HyperColor) or (ParamInd=Form_HyperColorOff) or
      (Pos('color',param)=1) or (Pos('colour',param)=1) then
    begin
      NonPrintable(tline,'');
      i:=1;
      while i<=length(tline) do
      begin
        if (tline[i] in [lbrace,rbrace]) and
           ((i=1) or (tline[i-1]<>'\')) then Delete(tline,i,1)
        else inc(i);
      end;
      if ParamInd=Form_BoldfaceOn then
      begin
        if BoldfaceOn[CurFileFormat]=Nil then
          BoldfaceOn[CurFileFormat]:=NewStr(tline);
      end else if ParamInd=Form_BoldfaceOff then
      begin
        if BoldfaceOff[CurFileFormat]=Nil then
          BoldfaceOff[CurFileFormat]:=NewStr(tline);
      end else if ParamInd=Form_HyperColor then
      begin
        if PrintColorStr^[CurFileFormat,17,1]=Nil then
          PrintColorStr^[CurFileFormat,17,1]:=NewStr(tline);
      end else if ParamInd=Form_HyperColorOff then
      begin
        if PrintColorStr^[CurFileFormat,17,2]=Nil then
          PrintColorStr^[CurFileFormat,17,2]:=NewStr(tline);
      end else
      begin
        i:=1;
        if Pos('off',param)=length(param)-2 then
        begin
          i:=2; Delete(param,length(param)-2,3);
        end else if Pos('on',param)=length(param)-1 then
           Delete(param,length(param)-1,2);
        while (param<>'') and not (param[1] in ['0'..'9']) do
          Delete(param,1,1);
        Val(param,k,icode);
        if (icode<>0) or (k>15) then FatalErrorRC(Str_WrongExpColor,'');
        if PrintColorStr^[CurFileFormat,k,i]=Nil then
          PrintColorStr^[CurFileFormat,k,i]:=NewStr(tline);
      end;
    end else if ParamInd=Form_EndLineString then
    begin
      if EndLineString[CurFileFormat]=Nil then
        EndLineString[CurFileFormat]:=NewStr(tline);
    end else if ParamInd=Form_Hyperlinks then
    begin
      if Pos('r',pvalue)=1 then ExpHyperFormat[CurFileFormat]:=ExpHyper_Resolve
      else if Pos('i',pvalue)=1 then ExpHyperFormat[CurFileFormat]:=ExpHyper_Ignore
      else if Pos('h',pvalue)=1 then ExpHyperFormat[CurFileFormat]:=ExpHyper_HTML;
    end;
  end;
end;                             { FileFormatEnv }

procedure ParametersEnv;
var
  i,j,nbrr: integer;
  btmp: boolean;
{$IFDEF WINDOWS}
  found: boolean;
  Ind: byte;
{$ENDIF}
procedure GetEncoding(var enc8,enc7: boolean; var enc: integer);
var
  i: integer;
  Ind: byte;
begin
  Enc:=-1;
  StrLwr(pvalue); ChrDel(pvalue,' ');
  enc7:=false; enc8:=false; Ind:=1;
  tmp:=''; WrdToken(tmp,pvalue,',;',Ind);
  if Pos('8',tmp)>0 then enc8:=true
  else if Pos('7',tmp)+Pos('tex',tmp)>0 then enc7:=true;
  if Ind>0 then
  begin
    tmp:=''; WrdToken(tmp,pvalue,',;',Ind);
    enc:=-1;
    for i:=0 to EncodingsList.Count-1 do
            if tmp=PEncoding(EncodingsList.at(i))^.Name^ then enc:=i;
  end;
end;

begin                      { ParametersEnv }
  if (ParamInd=Par_Version) then
  begin
{$IFDEF WINDOWS}
    found:=false; Ind:=1;
    repeat
      tmp2:=''; WrdToken(tmp2,ConfigFileVersion,' ,;'#9,Ind);
      if Match(tmp2[1],length(tmp2),pvalue[1],length(pvalue),false) then found:=true;
{      if StrCmpI(tmp2,pvalue,1,1,255)=0 then found:=true;}
    until found or (Ind=0);
    if not found then FatalErrorRC(Str_WrongCfgVer,'');
{$ELSE}
    if not Match(pvalue[1],length(pvalue),ProgramVersion[1],length(ProgramVersion),
        false) then FatalErrorRC(Str_WrongCfgVer,'');
    {
    tmp2:=ProgramVersion;
    StrLwr(tmp2);
    if pvalue<>tmp2 then FatalErrorRC(Str_WrongCfgVer,'');
    }
    VersionSpecified:=true;
{$ENDIF}
  end
  else if ParamInd=Par_selftest         then DoSelfTest:=IsOn(pvalue)
  else if ParamInd=Par_autocapitalize   then UseAutoCap:=IsOn(pvalue)
  else if ParamInd=Par_tildetospace     then TildeToSpace:=IsOn(pvalue)
{  else if ParamInd=Par_eoldisplay       then EolDisplay:=IsOn(pvalue)    }
  else if ParamInd=Par_stickylist       then StickyList:=IsOn(pvalue)
  else if ParamInd=Par_readonly         then ForbidEditing:=IsOn(pvalue)
  else if ParamInd=Par_leaveconfirm     then LeaveConfirm:=IsOn(pvalue)
{  else if ParamInd=Par_logging          then Logging_on:=IsOn(pvalue)}
  else if ParamInd=Par_saveoptsonexit   then SaveOptsOnExit:=IsOn(pvalue)
  else if ParamInd=Par_escapebraces     then EscapeBraces:=IsOn(pvalue) or
                                             (pvalue='tex') or (pvalue='latex')
  else if ParamInd=Par_importformat     then ImportFormatString:=pvalue
  else if ParamInd=Par_exportformat     then ExportFormatString:=pvalue
  else if ParamInd=Par_defpatternscope  then DefPatternScope:=pvalue
  else if ParamInd=Par_defsearchscope   then DefSearchScope^:=pvalue
  else if ParamInd=Par_sortedbydefault  then SortedByDefault:=IsOn(pvalue)
  else if ParamInd=Par_sortnewfiles     then SortNewFiles:=IsOn(pvalue)
  else if ParamInd=Par_retainnullfields then RetainNullFields:=IsOn(pvalue)
  else if ParamInd=Par_alwaysreadfields then AlwaysRead:=IsOn(pvalue)
  else if ParamInd=Par_fastread         then FastRead:=IsOn(pvalue)
  else if ParamInd=Par_viewallfields    then FirstShowBuf:=not IsOn(pvalue)
  else if ParamInd=Par_confirmescquit   then ConfirmESCQuit:=IsOn(pvalue)
  else if ParamInd=Par_wrapeof2bof      then WrapEOF2BOF:=IsOn(pvalue)
  else if ParamInd=Par_strbeforeentries then StringsBeforeEntries:=IsOn(pvalue)
  else if ParamInd=Par_hideextrabraces  then StripExtraBraces:=IsOn(pvalue)
  else if ParamInd=Par_AutoBuildIndex   then AutoBuildIndex:=IsOn(pvalue)
  else if ParamInd=Par_TagNewEntries    then TagNewEntries:=IsOn(pvalue)
  else if ParamInd=Par_LongFilenames    then LFNToggleSupport(IsOn(pvalue))
  else if ParamInd=Par_addsortenv       then
  begin
    if Pos('all',pvalue)>0 then AddSort2New:=AddToAllNew
    else if Pos('sort',pvalue)>0 then AddSort2New:=AddToSortedNew;
  end else if ParamInd=Par_checkduplicate   then
  begin
    if (pvalue='none') or IsOff(pvalue) then
      CheckDuplicate:=AllowDuplicate
    else if (pvalue='caseon') or (pvalue='respectcase') then
      CheckDuplicate:=DuplicateCaseOn
    else if (pvalue='caseoff') or (pvalue='ignorecase') or IsOn(pvalue) then
      CheckDuplicate:=DuplicateCaseOff
    else if Pos('warn',pvalue)>0 then CheckDuplicate:=DuplicateCaseWarn;
  end else if ParamInd=Par_shellargument    then
  begin
    if DosArgString=Nil then DosArgString:=NewStr(tline);
  end else if ParamInd=Par_stringsearchmode then
  begin
    if Pos('caseon',pvalue)>0 then SearchCase:=true
    else if Pos('caseoff',pvalue)>0 then SearchCase:=false;
    if (Pos('regexpoff',pvalue)>0) or (Pos('sub',pvalue)>0) then
       SearchRegexp:=false
    else if Pos('regexp',pvalue)>0 then SearchRegexp:=true;
    if Pos('reset',pvalue)>0 then SearchSticky:=false
    else if Pos('sticky',pvalue)>0 then SearchSticky:=true;
  end else if ParamInd=Par_namesearchmode  then
  begin
    if Pos('caseon',pvalue)>0 then LabelCase:=true
    else if Pos('caseoff',pvalue)>0 then LabelCase:=false;
    if (Pos('regexpoff',pvalue)>0) or (Pos('sub',pvalue)>0) then
       LabelRegexp:=false
    else if Pos('regexp',pvalue)>0 then LabelRegexp:=true;
    if Pos('reset',pvalue)>0 then LabelSticky:=false
    else if Pos('sticky',pvalue)>0 then LabelSticky:=true;
  end else if ParamInd=Par_backupextension then
  begin
    if pvalue<>'none' then FileExtension(pvalue,'BackupExtension',BackupExtension);
  end else if ParamInd=Par_indexextension then
    FileExtension(pvalue,'IndexExtension',IndexExtension)
{$IFNDEF WINDOWS}
  else if ParamInd=Par_helpfileextension then
    FileExtension(pvalue,'HelpFileExtension',HelpFileExtension)
{$ENDIF}
  else if ParamInd=Par_configbackextension then
    FileExtension(pvalue,'ConfigBackExtension',ConfigBackExtension)
  else if ParamInd=Par_useindexfile then
  begin
    if Pos('verify',pvalue)>0 then VerifyIndexFile:=true;
    if Pos('verbatim',pvalue)>0 then IndexVerbatim:=true;
    CopyFromIndexFile:=IsOn(pvalue);
    UseIndexFile:=VerifyIndexFile or CopyFromIndexFile;
  end else if ParamInd=Par_preamble then
  begin
    Ind2:=1; tmp2:='';
    WrdToken(tmp2,tline,' ,"'#9,Ind2); StrLwr(tmp2);
    UsePreamble:=IsOn(tmp2);
    if Ind2>0 then
    begin
      WrdToken(tmp2,tline,'"',Ind2);
      PreambleName^:=tmp2;
      if Pos('\',PreambleName^)<>0 then PreambleName^:=LFNFExpand(PreambleName^);
    end;
    if (PreambleName^='') then UsePreamble:=false;
  end else if ParamInd=Par_eolstring    then
  begin
    if NEolStrings=0 then
    begin
      Ind2:=1; tmp2:='';
      WrdToken(tmp2,tline,', '+#9,Ind2);
      while (NEolStrings<MaxEolStrings) and (tmp2<>'') do
      begin
        inc(NEolStrings);
        EolString[NEolStrings]:=NewStr(tmp2);
        if Ind2>0 then WrdToken(tmp2,tline,', '+#9,Ind2);
      end;
      if NEolStrings>0 then EolDisplay:=true;
    end;
  end else if ParamInd=Par_verbosity    then
  begin
    Val(pvalue,ii,icode);
    if icode=0 then Verbosity:=ii;
  end else if ParamInd=Par_unixdrives   then
  begin
    ChrDel(pvalue,':'); ChrDel(pvalue,'\');
    ChrDel(pvalue,';'); ChrDel(pvalue,',');
    UnixDrives:=pvalue; StrLwr(UnixDrives);
  end else if ParamInd=Par_detectnumeric then
  begin
    Ind2:=1; tmp2:='';
    WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
    if (pvalue='on') or (pvalue='always') or (pvalue='yes') then
        DetectNumeric:=AlwaysDetect
    else if (pvalue='no') or (pvalue='off') or (pvalue='never') then
        DetectNumeric:=NeverDetect
    else if (pvalue='numeric') or (pvalue='numericonly') then
        DetectNumeric:=NumericOnly;
  end
{$IFNDEF WINDOWS}
  else if ParamInd=Par_explodingwindows then
  begin
    if pvalue='off' then ExplodingWindows:=false
    else begin
      Val(pvalue,wtmp,icode);
      if icode=0 then
      begin
        ExplodeDelay:=wtmp;
        ExplodingWindows:=true;
      end;
    end;
  end else if ParamInd=Par_multitasker then
  begin
    if Pos('none',pvalue)>0 then MultiTasker:=NoTasker
    else if Pos('windows',pvalue)>0 then MultiTasker:=Windows
    else if Pos('desqview',pvalue)>0 then MultiTasker:=DESQview
    else if Pos('os/2',pvalue)+Pos('warp',pvalue)>0 then MultiTasker:=OS2
    else if Pos('netware',pvalue)>0 then MultiTasker:=NetWare
    else if Pos('double',pvalue)>0 then MultiTasker:=DoubleDOS
    else if Pos('nwdos',pvalue)+Pos('novell',pvalue)+Pos('drdos',pvalue)>0
       then MultiTasker:=DRDOS
    else if Pos('other',pvalue)>0 then MultiTasker:=UnknownTasker;
  end
{$ENDIF}
  else if ParamInd=Par_multitimeout then
  begin
    Ind2:=1; tmp2:='';
    WrdToken(tmp2,pvalue,' ,;'+#9,Ind2);
    Val(tmp2,DispTimeOut,icode);
    if icode>0 then DispTimeOut:=0;
    if Pos('always',pvalue)>0 then AlwaysTimeout:=true;
  end else if ParamInd=Par_debuglevel then
  begin
    Val(pvalue,debuglevel,icode);
    if icode>0 then debuglevel:=0;
  end else if ParamInd=Par_displayencoding then
    GetEncoding(Prog8bit,Prog7bit,DispEncoding)
  else if ParamInd=Par_fileencoding then
    GetEncoding(File8bit,File7bit,FReadEncoding)
  else if ParamInd=Par_editfields then
  begin
    if Pos('required',pvalue)>0 then EditFieldsDef:=EditFieldsDef+1;
    if Pos('optional',pvalue)>0 then EditFieldsDef:=EditFieldsDef+2;
    if Pos('all',pvalue)>0 then EditFieldsDef:=4;
    if pos('custom',pvalue)>0 then EditFieldsDef:=5;
  end else if ParamInd=Par_OverviewFields then
  begin
    UnTabify(tline);
    NOverview:=0; nbrr:=0;
    while (NoverView<MaxOverView) and (tline<>'') do
    begin
      index:=0;
      while (index<length(tline)) and ((nbrr>0) or (tline[index+1]<>',')) do
      begin
        inc(index);
        if tline[index]=lbrace then inc(nbrr)
        else if (tline[index]=rbrace) and (nbrr>0) then dec(nbrr);
      end;
      tmp2:=Copy(tline,1,index); ChrDelR(tmp2,' '); ChrDelL(tmp2,' ');
      if index>=length(tline) then tline:=''
      else Delete(tline,1,index+1);
      if tmp2<>'' then
      begin
        Inc(NOverview); TempOver^[NOverview]:=tmp2;
      end;
    end;
  end else if ParamInd=Par_BibInput then texinput:=pvalue
{$IFDEF WINDOWS}
  else if ParamInd=Par_BstInput then BstInput:=pvalue
{$ENDIF}
  else if ParamInd=Par_labelmode    then
  begin
    StrLwr(pvalue);
    if (pvalue='verify') or (pvalue='on') then LabelMode:=VerifyLabelMode
    else if Pos('auto',pvalue)>0 then LabelMode:=AutoLabelMode
    else LabelMode:=OffLabelMode;
  end else if ParamInd=Par_LabelTemplate then
    LabelTemplate^:=tline
  else if ParamInd=Par_BinaryFields then
  begin
    if BinaryFields<>Nil then DisposeStr(BinaryFields);
    BinaryFields:=NewStr(pvalue);
  end;
end;                             { ParametersEnv }

var
  ParamObj: PParamObj;

begin                                   { ParametersConfig }
  nbr:=1;
  if env=ExportFormatEnvInd   then
  begin
    if NumUserFormats>=MaxUserFormats then dec(NumUserFormats);
    inc(NumUserFormats);
  end;
  ParamsList.Init(100,100);
  for i:=EnvLimits[env,1] to EnvLimits[env,2] do
  begin
    tmp:=StringRC(i,'');
    if tmp<>'' then ParamsList.Insert(New(PParamObj,Init(tmp,i)));
  end;
  New(ParamObj,Init('',0)); New(ParamObj^.S);
  repeat
    line:='';
    readln(cfg,line); GetRidOfComment(line);
    Untabify(line); ChrDelL(line,' '); ChrDelR(line,' ');
    nbr:=nbr+ChrQty(line,lbrace)-ChrQty(line,rbrace);
    if (length(line)>0) and IsAlpha(line[1]) then
    begin
      index:=1; param:=''; pvalue:='';
      i:=1; while (i<=length(line)) and (Pos(line[i],TokenStr)=0) do inc(i);
      param:=Copy(line,1,i-1); ChrDelR(param,' ');
      if line[i]='=' then pvalue:=Copy(line,i+1,length(line)-i)
      else pvalue:=Copy(line,i+1,length(line)-i-1);
      ChrDelL(pvalue,' '); ChrDelR(pvalue,' ');
      if line[i]=lbrace then    { Remove trailing comments }
      begin
        nbr2:=1; i:=1;
        while (nbr2>0) and (i<=length(pvalue)) do
        begin
          if (i=1) or ((i>1) and (pvalue[i-1]<>'\')) then
          begin
            if pvalue[i]=lbrace then inc(nbr2)
            else if pvalue[i]=rbrace then dec(nbr2);
          end;
          if nbr2>0 then inc(i);
        end;
        pvalue[0]:=Chr(i-1); ChrDelR(pvalue,' ');
      end;
                                        { Substituting environment variables }
      if (pvalue<>'') and (env<>TibEnvInd) and (env<>ReferEnvInd) then
      begin
        i:=Pos('%',pvalue);
        while (i>0) do
        begin
          ind2:=i+1; tmp2:=''; tmp3:='';
          if (Ind2<=length(pvalue)) and (pvalue[Ind2]='%') then
            Delete(pvalue,ind2,1)
          else begin
            while (Ind2<=length(pvalue)) and
                 (Pos(pvalue[Ind2],' ,;<>=+()^%/\')=0) do
            begin
              tmp2:=tmp2+pvalue[Ind2]; Inc(Ind2);
            end;
            if (tmp2<>'')then
            begin
              tmp3:=GetEnv(tmp2);
              if (Ind2>0) and (Ind2<=length(pvalue)) and (pvalue[Ind2]='%') then
              begin
                inc(Ind2); tmp2:=tmp2+'%';
              end;
              {if tmp3<>'' then}
              begin
                StrRepl(pvalue,'%'+tmp2,tmp3,i,1,255);
                iii:=Ind2-length(tmp2)+length(tmp3)-1;
                if iii<1 then iii:=1; if iii>255 then iii:=255; Ind2:=iii;
              end;
            end;
          end;
          if (Ind2=0) or (Ind2>length(pvalue)) then i:=0
          else i:=ChrPosX(pvalue,'%',ind2);
        end;
      end;
      tline:=pvalue; ChrDel(pvalue,' ');
      StrLwr(param); StrLwr(pvalue); StrLwr(line);
{$IFDEF WINDOWS}
      if Pos('win:',param)=1 then Delete(param,1,4);
{$ELSE}
      if Pos('dos:',param)=1 then Delete(param,1,4);
{$ENDIF}
      ParamObj^.S^:=param;
      ParamInd:=-1;
      if ParamsList.Search(ParamObj,i) then
        ParamInd:=PParamObj(ParamsList.at(i))^.id;
{      if ParamInd=-1 then message(param);}
      case env of
        ParametersEnvInd: ParametersEnv;
{$IFNDEF WINDOWS}
        VideoModesEnvInd: VideoModesEnv;
        MouseEnvInd:      MouseEnv;
        DesqviewEnvInd:   DESQviewEnv;
        WindowsEnvInd:    WindowsEnv;
        PcConfigEnvInd:   PcConfigEnv;
{$ENDIF}
        MemoryEnvInd:     MemoryEnv;
        BibtexEnvInd,CommaDelimitedEnvInd,TibEnvInd,
            ReferEnvInd,ExportFormatEnvInd: FileFormatEnv;
      end;
    end;
  until (eof(cfg)) or (nbr<1);
{$IFNDEF WINDOWS}
  if swapdir='' then SwapDir:='.';
{$ENDIF}
  Dispose(ParamObj^.S); ParamObj^.S:=Nil;
  Dispose(ParamObj,Done);
  ParamsList.Done;
end;                                  { ParametersConfig }

{$IFNDEF WINDOWS}

{$I bibcolor.inc}
{$I bibmenus.inc}

{$ENDIF}

procedure Defaults;
var
  i,j: byte;
  ch: char;
begin
  { List of existing configuration environments/modified options }

  FillChar(ConfigEnvFound,sizeof(ConfigEnvFound),byte(false));
  FillChar(OptionsModified,sizeof(OptionsModified),byte(false));

                                        { Memory }
{$IFDEF WINDOWS}
  MaxBig:=$7FF0;
  MaxNumberBig:=MaxField;
  SaveTheScreen:=false;
{$ELSE}
  MaxBig:=16382;
  MaxNumberBig:=2;
  SaveTheScreen:=true;
{$ENDIF}
  UseClipboard:=true;
  ClipboardString:=false;
  ClipboardEmpty:=true;
  ClipboardName^:='';
  ClipboardType^:='';
{$IFNDEF WINDOWS}
  ClipBoardMode:=DontKeep;
  ClipboardPosition:=0;
{$ENDIF}
  UseVirtualMemory:=true;
  ForceKeepInStream:=false;
  AuxDir:='';
  AuxBufSize:=2048;
  FileBufSize:=4096;
  ReportMemory:=false;
  MaxCache:=0;
  CacheDir^:='';
  AutoLoadCache:=false;
                                         { GUI }
  FirstShowBuf:=true;
  StripExtraBraces:=true;
{$IFNDEF WINDOWS}
  WideScreenMouse:=true;
  CurrentMode:=0;
  NVidModes:=0;
  CurrentLen:=25;
  UseMouse:=mouse_present;
  FixedVideoMode:=0;
  ColorScr:=AutoColor;
  AdapterString:='';
  HardwareCur:=false;
{$ENDIF}
  EolDisplay:=false;
  for i:=1 to MaxEolStrings do EolString[i]:=Nil;
  NEolStrings:=0;
  KeyboardString:='';
{$IFNDEF WINDOWS}
  VGAModes[1].lines :=28; VGAModes[1].VGA :=true;
  VGAModes[2].lines :=30; VGAModes[2].VGA :=true;
  VGAModes[3].lines :=33; VGAModes[3].VGA :=true;
  VGAModes[4].lines :=34; VGAModes[4].VGA :=true;
  VGAModes[5].lines :=35; VGAModes[5].VGA :=false;
  VGAModes[6].lines :=40; VGAModes[6].VGA :=true;
  VGAModes[7].lines :=43; VGAModes[7].VGA :=false;
  VGAModes[8].lines :=48; VGAModes[8].VGA :=true;
  VGAModes[9].lines :=50; VGAModes[9].VGA :=true;
  VGAModes[10].lines:=60; VGAModes[10].VGA:=true;
  for i:=1 to NumOfVGAModes do VGAModes[i].on:=true;
{$ENDIF}
  
                                         { Files }
  UnixBib:=false;
  UnixDrives:='';
  UnixDump:=false;
  DumpName^:='';
  DumpFileExists:=false;
  DumpToPrinter:=false;
  TexInput:='.';
  TexInputList:=Nil;
{$IFDEF WINDOWS}
  BstInput:='.';
  BstInputList:=Nil;
{$ELSE}
  HelpFileExtension:=NewStr('.olh');
{$ENDIF}
  TexAuxFile^:='';
  BackupExtension:=NewStr('.bak');
  IndexExtension :=NewStr('.bix');
  ConfigBackExtension:=NewStr('cf~');
  ConfigFileBacked:=false;
  UseIndexFile:=false;
  VerifyIndexFile:=false;
  CopyFromIndexFile:=false;
  IndexFileName^:='';
  DisableIndexFile:=false;
  AutoBuildIndex:=false;
  PreambleName^:=''; UsePreamble:=false;
  NumberOfEntries:=0; EndOfIndexHeader:=-1;
  for i:=1 to MaxBibFiles do
  with BibFiles^[i] do
  begin
    name:=''; marked:='';
    Place:=-1; Time:=-1;
    RealNum:=0; EntryNum:=0; RealStart:=0; EntryStart:=0;
    PatOn:=false; PatNum:=0; Ex:=false; RO:=false;
  end;
  MaxFileHandles:=15;
  LFNToggleSupport(true);

                                         {  File Formats }
  for i:=1 to LastImportFormat do
  begin
    DumpFileList^[i]:=''; Verify[i]:=VerifyOff;
    LineWidth[i]:=80;
  end;
  DumpLabelsOnly:=false;
  DefExtension[BibTexFormat]:=NewStr('.bib');
  DefExtension[CommaDelimited]:=NewStr('.dbm');
  DefExtension[TibFormat]:=NewStr('.ref');
  DefExtension[ReferFormat]:=NewStr('.ref');
  FormatModes[BibTexFormat]:=NewStr('bibtex');
  FormatModes[CommaDelimited]:=NewStr('commadelimited');
  FormatModes[TibFormat]:=NewStr('tib');
  FormatModes[ReferFormat]:=NewStr('refer');
  TibMacros:=NotImpOrExp;
  TibLabels:='FK';
  ReferLabels:='LK';
  DefNullLabels^:=lbrace+'_filename'+rbrace+':'+lbrace+'_num'+rbrace;
  NumUserFormats:=0;
  for j:=FirstUserFormat to LastExportFormat do
  begin
    UserFormatName[j]:=Nil;
    FormatModes[j]:=Nil;
    DumpFileList^[j]:=''; 
    BoldfaceOn[j]:=Nil; BoldfaceOff[j]:=Nil;
    for i:=1 to 17 do
    begin
      PrintColorStr^[j,i,1]:=Nil; PrintColorStr^[j,i,2]:=Nil;
    end;
    LineWidth[j]:=80;
    DefExtension[j]:=NewStr('.txt');
    EndLineString[j]:=Nil;
    ExpHyperFormat[j]:=ExpHyper_Resolve;
  end;
  UserFormatChars:='';
  CommaSeparator:=',';
  ImportFormatString:=''; ExportFormatString:='';
  ImportFormat:=BibTeXFormat;
  ExportFormat:=BibTeXFormat;

                                            { Entries & Fields }
  GetMem(TypeField,(maxfield+2)*sizeof(ListArrRec));
  GetMem(TypeEntry,(maxfield+3)*sizeof(ListArrRec));
  for i:=1 to maxfield do Required^[i,0]:=0;
  FieldLast:=0;
  NumberOfTypes:=0;
  for i:=1 to MaxField+1 do
  begin
    EditFields^[i]:='';   TypeField^[i]:='';  TypeEntry^[i]:='';
    with FieldParams^[i] do
    begin
      AuthorLike:=false;  Capitalize:=false; Numeric:=false;
      ProtectCase:=false; ProtectCap:=false; AltName:=Nil;
    end;
  end;
  TypeEntry^[MaxField+2]:='';

                                            { Various }
{$IFDEF WINDOWS}
  EmsExists:=false;
  XMSExists:=false;
  UseRAMStream:=true;
{$ELSE}
{  EmsExists:=false;   }  { EMS problem hopefully fixed. }
  EmsExists:=exist_ems;
  XmsExists:=exist_xms;
  UseRAMStream:=false;
{$ENDIF}
  StringsBeforeEntries:=false;
  ForbidEditing:=false;
  EscapeBraces:=false;
  EditOnlyStrings:=false;
  DelimitBrace[false]:=true; DelimitBrace[true]:=false;
  CheckDuplicate:=DuplicateCaseOff;
  RetainNullFields:=false;
  DetectNumeric:=AlwaysDetect;
  EditFieldsDef:=0;
  StickyList:=false;
  UseAutoCap:=true;
  NoverView:=0;
  BreakupLength:=1000;
{$IFDEF WINDOWS}
  new(TempOver);
{$ELSE}
  TempOver:=@RealTempOver;
{$ENDIF}
  for i:=1 to MaxOverView do
  begin
    OverView[i]:=Nil; TempOver^[i]:='';
  end;
  DmenuNum:=0; PmenuNum:=0;
  for i:=1 to maxfield do DumpFields[i]:=true;
  DumpUndecFields:=true;
  ImportFormat:=BibTeXFormat;
  ExportFormat:=BibTeXFormat;
  LabelTemplate^:='\auth{Author,Editor}\syear{year,note}';
  LabelMode:=OffLabelMode;
  FastRead:=false;
  DosArgString:=Nil;
  NArticles:=0;
  for i:=1 to MaxArticles do Articles[i]:=Nil;
  BookMark^:='';
{$IFNDEF WINDOWS}
  ComSpec:='';
  TagChar:=#251; MenuCheckChar:=#251;
  EditLoadFile:='*';
{$ENDIF}
  SaveOptsOnExit:=false;
  ConfirmESCQuit:=false;
  WrapEOF2BOF:=true;
  IncludePreambles:=false;
  StringTypeInd:=1; PreambleTypeInd:=1;
  TagNewEntries:=false;

  DefPatternScope:=PattStr_All;
  SearchCase:=false; SearchRegexp:=false;
  SearchSticky:=true;
  DefSearchScope^:=PattStr_All;
  SearchString^:='';
  LabelSearchString^:='';
  LabelRegexp:=false; LabelCase:=false;
  LabelSticky:=false;
                                            { Sorting }
  ZeroSortMode(ConfigSortMode^,Nil);
  ZeroSortMode(CurrentSortMode^,Nil);
  ZeroSortMode(ExportSortMode^,Nil);
  SortPattPosDef:=0; SortPattPosCur:=0; SortPattPosExp:=0;
  AddSort2New:=AddToNoNew;
  SortNewFiles:=false; SortedByDefault:=false;
                                            { 8 bit }
  Prog7Bit:=false; Prog8Bit:=false;
  File7Bit:=false; File8Bit:=false;
  DispEncoding:=-1; FReadEncoding:=-1; FWriteEncoding:=-1;
  CodePage:=0;
{$IFNDEF WINDOWS}
  CodePageStr:='autodetect';
{$ENDIF}
                                            { Prog options }
  LeaveConfirm:=true;
{$IFDEF WINDOWS}
  DoSelfTest:=false;
  AllowShell:=false;
{$ELSE}
  SwapMode:=Swap_All; ExecSwap:=true; SwapDir:='.'; SwapOn:=ExecSwap;
  AllowShell:=true;
  DoSelfTest:=(Correct.bibsize=0);
{$ENDIF}
                                            { Debugging }
  debug:=false;
  DebugLevel:=0;
  Verbosity:=1;
  IndexVerbatim:=false;
                            { Multitasking }
{$IFNDEF WINDOWS}
  with Win3x do
  begin
    noxms:=false; noems:=false; nomouse:=false; shell:=true; clip:=true;
  end;
  MultiTasker:=AutoTasker;
  MultiTasking:=false;
  AlwaysTimeout:=false;
  with DESQviewOpts do
  begin
    noems:=false; noxms:=false; nomouse:=false; shell:=true; virtualize:=false;
    hardfirst:=-1; hardlast:=-1;
  end;
  Virtualize_DV:=false;
  UseWindowsClipboard:=true;
{$ENDIF}

  for i:=1 to LastOpt do
  with Option[i] do
  begin
    for j:=1 to NumOptionNames do name[j]:='';
    Found:=false; Quote:=false; S:=Nil;
  end;
  Option[COpt_a].name[1]:='a';
  Option[COpt_c].name[1]:='c';
  Option[COpt_h].name[1]:='h';
    Option[COpt_h].name[2]:='help'; Option[COpt_h].name[3]:='?';
  Option[COpt_p].name[1]:='p';
  Option[COpt_s].name[1]:='s';
  Option[COpt_x].name[1]:='x';
  Option[COpt_mono].name[1]:='mono';
  Option[COpt_color].name[1]:='color'; Option[COpt_color].name[2]:='colour';
  Option[COpt_test].name[1]:='test';
  Option[COpt_link].name[1]:='link'; Option[COpt_link].name[2]:='linked';
  Option[COpt_debug].name[1]:='debug';
  Option[COpt_readonly].name[1]:='readonly'; Option[COpt_readonly].name[2]:='ro';
  Option[COpt_latex].name[1]:='latex';
  Option[COpt_tag].name[1]:='tag'; Option[COpt_tag].name[2]:='tagged';
  Option[COpt_if].name[1]:='if';
  Option[COpt_xf].name[1]:='xf';
  Option[COpt_ent].name[1]:='ent'; Option[COpt_ent].name[2]:='entry';
    Option[COpt_ent].name[3]:='entries';
  Option[COpt_str].name[1]:='str'; Option[COpt_str].name[2]:='string';
    Option[COpt_str].name[3]:='strings';
  Option[COpt_l].name[1]:='l';  Option[COpt_l].name[2]:='label';
{$IFDEF WINDOWS}
  Option[COpt_ini].name[1]:='ini';
  Option[COpt_Max].name[1]:='max';
  Option[COpt_Min].name[1]:='min';
  Option[COpt_NoRAM].name[1]:='noram';
{$ELSE}
  Option[COpt_noems].name[1]:='noems';
  Option[COpt_noxms].name[1]:='noxms';
  Option[COpt_nomouse].name[1]:='nomouse';
  Option[COpt_save].name[1]:='save';
  Option[COpt_nosave].name[1]:='nosave';
  Option[COpt_multi].name[1]:='multi'; Option[COpt_multi].name[2]:='mult';
    Option[COpt_multi].name[3]:='mul';
  Option[COpt_25].name[1]:='25';
  Option[COpt_28].name[1]:='28';
  Option[COpt_30].name[1]:='30';
  Option[COpt_33].name[1]:='33';
  Option[COpt_34].name[1]:='34';
  Option[COpt_35].name[1]:='35';
  Option[COpt_40].name[1]:='40';
  Option[COpt_43].name[1]:='43';
  Option[COpt_48].name[1]:='48';
  Option[COpt_50].name[1]:='50';
  Option[COpt_60].name[1]:='60';
  Option[COpt_vmode].name[1]:='vmode';
{$ENDIF}

                                       { Link the strings }
  New(CmdStr_c); Option[COpt_c].S:=CmdStr_c;
  Option[COpt_p].S:=@PattString;
  Option[COpt_s].S:=SearchString;
  Option[COpt_l].S:=LabelSearchString;
  Option[COpt_x].S:=@CmdStr_x;
  Option[COpt_if].S:=@CmdStr_if;
  Option[COpt_xf].S:=@CmdStr_xf;
{$IFDEF WINDOWS}
  New(CmdStr_ini); Option[COpt_ini].S:=CmdStr_ini;
  Option[COpt_a].S:=@AuxDir;
{$ELSE}
  Option[COpt_a].S:=@CmdStr_a;
  Option[COpt_multi].S:=@MultiTaskerStr;
  Option[COpt_vmode].S:=@CmdStr_vmode;
{$ENDIF}

  CLineFiles:=0; for i:=1 to MaxBibFiles do CLineFilesList^[i]:='';
  IniFieldLast:=0;
end;                           { Defaults }

{$IFOPT R-}
  {$IFDEF RANGEON}
    {$R+}
  {$ENDIF}
{$ENDIF}

procedure CommandLine;
var
  pindex,i,j,nopt: byte;
  Prm,line: string;
  btmp: boolean;

function CollectString(var line: string; var Quote: boolean): string;
var
  S,tmp: string;
  Delim: char;
  DDelim: string[2];
  Finish: boolean;
  depth: integer;
begin
  CollectString:=''; S:=''; Quote:=false;
  if line='' then line:=ParamStr(pindex); if line='' then Exit;
  if (line[1]='''') or (line[1]='"') then      { quote-delimited string }
  begin
    Quote:=true; Delim:=line[1]; DDelim:=Delim+Delim;
    Delete(line,1,1);
    Finish:=false; Depth:=1;
    repeat
      tmp:='';
      StrRepl(line,DDelim,#1,1,255,255);
      if (length(line)>1) and (line[1]=Delim) then inc(depth);
      if line[length(line)]=Delim then
      begin
        dec(depth);
        if depth<=0 then
        begin
          delete(line,length(line),1);
          finish:=true;
        end;
        tmp:=line;
      end else if pindex=ParamCount then
      begin
        tmp:=line; finish:=true;
      end else
      begin
        tmp:=line;
      end;
      if S='' then S:=tmp
      else S:=S+' '+tmp;
      if not finish then
      begin
        inc(pindex); line:=ParamStr(pindex);
        if line='' then Finish:=true;
      end;
    until finish;
    StrRepl(S,#1,Delim,1,255,255);
  end else S:=line;
  CollectString:=S;
  line:='';
end;                    { CollectString }

begin
  if ParamCount=0 then Exit;
  CLineFiles:=0; pindex:=0;
  line:=''; Prm:='';
  repeat
    if line='' then
    begin
      inc(pindex); line:=ParamStr(pindex);
    end;
    if (line='') then { nothing }
    else if (line='/') or (line='-') then FatalErrorRC(Str_CmdLineErr,'')
    else if line[1] in ['-','/'] then         { option names }
    begin
      Delete(line,1,1);
      i:=Pos('/',line);
      if i>0 then
      begin
        Prm:=Copy(line,1,i-1); Delete(line,1,i-1);
      end else
      begin
        Prm:=line; line:='';
      end;
      if Prm='' then FatalErrorRC(Str_CmdLineErr,'');
      StrLwr(Prm);
      nopt:=0; i:=0;
      repeat
        inc(i);
        for j:=1 to NumOptionNames do if Prm=Option[i].name[j] then nopt:=i;
      until (i>=LastOpt) or (nopt<>0);
      if nopt=0 then FatalErrorRC(Str_UnknownCmdLine,Prm);
      Option[nopt].found:=true;
      if Option[nopt].S<>Nil then with Option[nopt] do   { accepts string }
      begin
        S^:='';
        if (line<>'') or (pindex>=ParamCount) then FatalErrorRC(Str_CmdLineStr,Prm);
        inc(pindex); line:=ParamStr(pindex);
        if (line[1]='/') or (line[1]='-') then FatalErrorRC(Str_CmdLineStr,Prm);
        S^:=CollectString(line,Quote);
      end;
    end else                                  { files }
    begin
      if CLineFiles<MaxBibFiles then
      begin
        Inc(CLineFiles);
        CLineFilesList^[CLineFiles]:=CollectString(line,btmp);
        StrRepl(CLineFilesList^[CLineFiles],'/','\',1,255,255);
        if Pos('.',CLineFilesList^[CLineFiles])=1 then
          CLineFilesList^[CLineFiles]:=LFNFExpand(CLineFilesList^[CLineFiles]);
      end;
      line:='';
    end;
  until (pindex>=ParamCount) and (line='');
end;                                    { CommandLine }

procedure FindConfigFile(OptNum: integer; var CmdStr: string; Exten: Ext4Str;
{$IFDEF WINDOWS}
                         EnvVar: Env15Str; IniVar: PChar;
{$ELSE}
                         EnvVar,IniVar: Env15Str;
{$ENDIF}
                         LookInWinIni: boolean);
var
  fl: text;
  F: array[0..255] of char;
  Name,Dir,S: PString;
begin
  New(Name); New(Dir); New(S);
  if Option[OptNum].found then    { config file specified }
  begin
    ChrDel(CmdStr,' ');
    ChrDelR(CmdStr,'"'); ChrDelL(CmdStr,'"');
    StrRepl(CmdStr,'/','\',1,255,255);
    if (CmdStr='') or (not isFileName(CmdStr)) then
        FatalErrorRC(Str_CmdLineErr,'');
  end else CmdStr:='';
  if CmdStr='' then
  begin
{$IFDEF WINDOWS}
    if LookInWinIni then i:=GetProfileString('wbibdb',IniVar,'<none>',Fbuf,255)
    else
      i:=GetPrivateProfileString(GeneralSec,IniVar,'<none>',Fbuf,255,IniFile);
    if (i>0) and (StrComp(Fbuf,'<none>')<>0) then CmdStr:=StrPas(Fbuf)
    else if EnvVar<>'' then CmdStr:=GetEnv(EnvVar);
    if CmdStr<>'' then
    begin
      StrRepl(CmdStr,'/','\',1,255,255);
      LFNFSplit(CmdStr,Dir,Name,Nil);
      if Dir^='' then CmdStr:=ProgramDir^+CmdStr;
    end;
{$ELSE}
    if EnvVar<>'' then CmdStr:=GetEnv(EnvVar);
    if CmdStr<>'' then CmdStr:=LFNFexpand(CmdStr);
{$ENDIF}
  end;
  if CmdStr='' then
  begin
    CmdStr:=LFNLongName(LFNFexpand(ParamStr(0)));
    LFNFsplit(CmdStr,Dir,Name,Nil);
    CmdStr:=Name^;
  end;
  StrRepl(CmdStr,'/','\',1,255,255);
  LFNFsplit(CmdStr,Dir,Name,Nil);
  if Dir^='' then
  begin
    LFNFSplit(LFNLongName(LFNFexpand(ParamStr(0))),Dir,Nil,Nil);
    tmp:='.;'+Dir^;
    FindFile(S^,Concat(name^,Exten),tmp);
  end else FindFile(S^,Name^+Exten,LFNFexpand(Dir^));
  StrUpr(Exten);
{$IFDEF WINDOWS}
  if (S^='') and LookInWinIni then
  begin
    GetWindowsDirectory(F,150);
    Dir^:=StrPas(F); if Dir^[length(Dir^)]<>'\' then Dir^:=Dir^+'\';
    S^:=Dir^+name^+Exten;
    if not LFNFileExist(S^) then S^:='';
  end;
{$ENDIF}
  if S^='' then FatalErrorRC(Str_CantFindCfg,Name^+Exten);
  CmdStr:=S^;
  if not LFNFileExist(S^) then FatalErrorRC(Str_CantReadCfg,S^);
  Dispose(S); Dispose(Dir); Dispose(Name);
end;                                    { FindConfigFile }

begin                                         { InitDB }
{$IFDEF WINDOWS}
  New(S); New(CLineFilesList);
{$ELSE}
  S:=@S_S; CLineFilesList:=@S_CLineFilesList;
{$ENDIF}

  PattString:=''; PatOptFirst:=255; PatOptLast:=0;
  SrOptFirst:=255; SrOptLast:=0;
  AuxSpecified:=false;
  DumpSpecified:=false;
  VersionSpecified:=false;
  ErrorFormat:=Init;
  StartupLen:=0;
  StartupMode:=0;
  InputLatexFile:=false;
  SelectTagged:=false;
  ProgramFile:=NewStr(LFNLongName(LFNFExpand(ParamStr(0))));

  Defaults;
{$IFDEF WINDOWS}
  WinDefaults;
{$ENDIF}

  CommandLine;

  AuxSpecified  :=Option[COpt_a].found;
  DumpSpecified :=Option[COpt_x].found;
  InputLatexFile:=Option[COpt_latex].found;
  SelectTagged  :=Option[COpt_tag].found;
  ForbidEditing :=Option[COpt_readonly].found;
  linked        :=Option[COpt_link].found;

  if not InputLatexFile then SelectTagged:=false;
  if LabelSearchString^<>'' then LabelSearchString^:=#1+LabelSearchString^;

{$IFDEF WINDOWS}
  StartupMaximized:=Option[COpt_Max].found;
  StartupMinimized:=Option[COpt_Min].found;
  if Option[COpt_noRAM].found then UseRAMStream:=false;
{$ELSE}
  if Option[COpt_vmode].found then      { StartupMode }
  begin
    ChrDelR(Option[COpt_vmode].S^,'"'); ChrDelL(Option[COpt_vmode].S^,'"');
    StartUpMode:=ReadVidMode(Option[COpt_vmode].S^);
  end;

  if Option[COpt_noems].found then EmsExists:=false;
  if Option[COpt_noxms].found then XmsExists:=false;
  if Option[COpt_mono].found  then ColorScr:=NoColor;
  if Option[COpt_color].found then ColorScr:=YesColor;
  if Option[COpt_25].found    then StartupLen:=25;
  if Option[COpt_28].found    then StartupLen:=28;
  if Option[COpt_30].found    then StartupLen:=30;
  if Option[COpt_33].found    then StartupLen:=33;
  if Option[COpt_34].found    then StartupLen:=34;
  if Option[COpt_35].found    then StartupLen:=35;
  if Option[COpt_40].found    then StartupLen:=40;
  if Option[COpt_43].found    then StartupLen:=43;
  if Option[COpt_48].found    then StartupLen:=48;
  if Option[COpt_50].found    then StartupLen:=50;
  if Option[COpt_60].found    then StartupLen:=60;
{$ENDIF}

{$IFDEF WINDOWS}
  FindConfigFile(COpt_ini,CmdStr_ini^,'.ini','','IniFile',true);
  StrPCopy(IniFile,LFNShortName(CmdStr_ini^));
  StrRepl(CmdStr_ini^,'.ini','.pat',1,255,255);
  StrPCopy(PattHeirFile,CmdStr_ini^);
  Dispose(CmdStr_ini);
  WinParamsConfig(VersionSpecified, ConfigFileVersion);
  FindConfigFile(COpt_c,CmdStr_c^,'.cfg','WBIBDBCFG','ConfigFile',false);
{$ELSE}
  FindConfigFile(COpt_c,CmdStr_c^,'.cfg','BIBDBCFG','ConfigFile',false);
{$ENDIF}
  ConfigFile:=NewStr(CmdStr_c^); Dispose(CmdStr_c);
  LFNNew(cfg,true); LFNAssign(cfg,ConfigFile^);
  ErrorFormat:=config;

  { Read The configuration file a first time }

  LFNReset(cfg,0);
  repeat
    repeat
      readln(cfg,S^); UnTabify(S^); ChrDel(S^,' ');
    until eof(cfg) or ((S^[1]='\') and (Pos(lbrace,S^)>0));
    if not eof(cfg) then
    begin
      StrLwr(S^);
      PStrCopy(tmp,S^,2,Pos(lbrace,S^)-2); ChrDel(tmp,' ');
      if tmp='parameters' then
      begin
        ParametersConfig(ParametersEnvInd); ConfigEnvFound.Parameters:=true;
      end else if tmp='memory' then
      begin
        ParametersConfig(MemoryEnvInd); ConfigEnvFound.Memory:=true;
      end
{$IFNDEF WINDOWS}
      else if tmp='pcconfig' then
      begin
        ParametersConfig(PcConfigEnvInd); ConfigEnvFound.PcConfig:=true;
      end
      else if tmp='windows' then
      begin
        ParametersConfig(WindowsEnvInd); ConfigEnvFound.Windows:=true;
      end else if tmp='mouse' then
      begin
        ParametersConfig(MouseEnvInd); ConfigEnvFound.Mouse:=true;
      end else if tmp='desqview' then
      begin
        ParametersConfig(DESQviewEnvInd); ConfigEnvFound.DESQview:=true;
      end else if tmp='videomodes' then
      begin
        ParametersConfig(VideoModesEnvInd); ConfigEnvFound.VideoModes:=true;
      end
{$ENDIF}
      else if tmp='bibtex' then
      begin
        ParametersConfig(BibTeXEnvInd); ConfigEnvFound.BibTeX:=true;
      end else if tmp='commadelimited' then
      begin
        ParametersConfig(CommaDelimitedEnvInd); ConfigEnvFound.CommaDelimited:=true;
      end else if tmp='tib' then
      begin
        ParametersConfig(TibEnvInd); ConfigEnvFound.Tib:=true;
      end else if tmp='refer' then
      begin
        ParametersConfig(ReferEnvInd); ConfigEnvFound.Refer:=true;
      end else if tmp='exportformat' then
      begin
        ParametersConfig(ExportFormatEnvInd); ConfigEnvFound.ExportFormat:=true;
      end else if tmp='fields' then
      begin
        FieldsConfig(cfg); ConfigEnvFound.Fields:=true;
      end else if tmp='shortwords' then
      begin
        ShortWordsConfig(cfg); ConfigEnvFound.ShortWords:=true;
      end else
      begin
        GetRidOfComment(S^);
        nbrace:=ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        while (not eof(cfg)) and (nbrace>0) do
        begin
          readln(cfg,S^); GetRidOfComment(S^);
          nbrace:=nbrace+ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        end;
        tmp:='';
      end;
    end;
  until eof(cfg);

{$IFNDEF WINDOWS}
  if Option[COpt_h].found then
  begin
    ContextHelp('Online Help'); Halt;
  end;
{$ENDIF}
  if not VersionSpecified then FatalErrorRC(Str_NoCfgVer,'');
  if fieldlast=0 then FatalErrorRC(Str_NoFieldsDefined,'');

  LastFileFormat:=LastImportFormat+NumUserFormats;

  { Multitaskers }

{$IFNDEF WINDOWS}
  if Option[COpt_multi].found then
  begin
    StrLwr(Option[COpt_multi].S^);
    if Pos('none',Option[COpt_multi].S^)>0 then MultiTasker:=NoTasker
    else if Pos('windows',Option[COpt_multi].S^)>0 then MultiTasker:=Windows
    else if Pos('desqview',Option[COpt_multi].S^)>0 then MultiTasker:=DESQview
    else if Pos('os/2',Option[COpt_multi].S^)+Pos('warp',Option[COpt_multi].S^)>0
      then MultiTasker:=OS2
    else if Pos('netware',Option[COpt_multi].S^)>0 then MultiTasker:=NetWare
    else if Pos('double',Option[COpt_multi].S^)>0 then MultiTasker:=DoubleDOS
    else if Pos('nwdos',Option[COpt_multi].S^)+Pos('novell',Option[COpt_multi].S^)+
      Pos('drdos',Option[COpt_multi].S^)>0 then MultiTasker:=DRDOS
    else if Pos('other',Option[COpt_multi].S^)>0 then MultiTasker:=UnknownTasker
    else if Pos('auto',Option[COpt_multi].S^)>0 then MultiTasker:=AutoTasker;
  end;
  if MultiTasker=AutoTasker then CheckForMultiTaskers
  else MultiTasking:=not (MultiTasker in [NoTasker,AutoTasker]);
  if not (Multitasking or AlwaysTimeout) then DispTimeout:=0; 
{$ENDIF}

  if ImportFormatString<>'' then
  begin
    ImportFormat:=WhichMode(ImportFormatString,true);
    if ImportFormat=0 then FatalErrorRC(Str_WrongImpFormat,'');
  end;
  if ExportFormatString<>'' then
    begin
    ExportFormat:=WhichMode(ExportFormatString,false);
    if ExportFormat=0 then FatalErrorRC(Str_WrongExpFormat,'');
  end;

  ErrorFormat:=normal;
  if MaxBig<255 then MaxBig:=255;
  SwapOn:=Execswap;
  DefFieldLast:=fieldlast; OrigFieldLast:=FieldLast;
  typefield^[StringIndex]:=StringFieldName;

                               { Aux file command line parameter }
  if Option[COpt_a].found then
  begin
{$IFNDEF WINDOWS}
    auxdir:=Option[COpt_a].S^;
{$ENDIF}
    ChrDelR(auxdir,'"'); ChrDelL(auxdir,'"');
  end;
                               { Windows and DESQview }
{$IFNDEF WINDOWS}
  if MultiTasker=DesqView then
  with DESQviewOpts do
  begin
    if nomouse then UseMouse:=false;
    if noems then EmsExists:=false;
    if noxms then XmsExists:=false;
    if not shell then AllowShell:=false;
    Virtualize_DV:=Virtualize;
  end;
  if MultiTasker=Windows then
  with Win3x do
  begin
    if nomouse then UseMouse:=false;
    if noems then EmsExists:=false;
    if noxms then XmsExists:=false;
    if not shell then AllowShell:=false;
    UseWindowsClipboard:=clip;
  end;
  if UseWindowsClipboard and (GetWinOldApVersion=0) then
    UseWindowsClipboard:=false;
  if UseMouse and Option[COpt_nomouse].found then UseMouse:=false;
{$ENDIF}

                    { Work Stream types }
  ind:=1; S^:=''; i:=1;
  TempDirList^:='';
  LFNNew(tmpfile,true);
  if AuxDir<>'' then
  begin
    repeat
      WrdToken(tmp,AuxDir,' ;',ind); StrLwr(tmp);
      if (tmp<>'') and IsDirName(tmp) then
      begin
        if tmp[length(tmp)]<>'\' then tmp:=tmp+'\';
        if LFNAssign(tmpfile,tmp+'$$test$&.&$&')<>0 then tmp:=''
        else begin
          if LFNRewrite(tmpfile,0)<>0 then tmp:='';
          LFNclose(tmpfile); LFNErase(tmpfile);
        end;
        if tmp<>'' then  TempDirList^:=TempDirList^+tmp+';';
      end;
    until (i>NumTypes) or (ind=0);
  end;
  LFNDispose(tmpfile);
  WorkBufSize:=AuxBufSize;
  ChrDelR(TempDirList^,';');

                { str, ent, if, xf }
  if Option[COpt_test].found  then DoSelfTest:=true;
  if Option[COpt_debug].found  then Debug:=false;
{$IFNDEF WINDOWS}
  if Option[COpt_save].found then SaveTheScreen:=true;
  if Option[COpt_nosave].found then SaveTheScreen:=false;
{$ENDIF}
  if Option[COpt_str].found then EditOnlyStrings:=true;
  if Option[COpt_ent].found then EditOnlyStrings:=false;
  if Option[COpt_if].found then
  begin
    ChrDelR(Option[COpt_if].S^,'"'); ChrDelL(Option[COpt_if].S^,'"');
    ImportFormat:=WhichMode(Option[COpt_if].S^,true);
    if ImportFormat=0 then FatalErrorRC(Str_WrongIfParam,'');
  end;
  if Option[COpt_xf].found then
  begin
    ChrDelR(Option[COpt_xf].S^,'"'); ChrDelL(Option[COpt_xf].S^,'"');
    ExportFormat:=WhichMode(Option[COpt_xf].S^,false);
    if ExportFormat=0 then FatalErrorRC(Str_WrongXfParam,'');
  end;
                                        { Bib buffer }
  if bibbuf=Nil then GetMem(bibbuf,FileBufSize);
  MaxMemAvail;

                           { Init the screen }
{$IFNDEF WINDOWS}
  VideoInit(AdapterString);
  if FixedVideoMode>0 then FixedVideoMode:=OldVidMode;
  WindowsInit;
  KeyboardInit(KeyboardString);
  if ColorScr=autoColor then
  begin
    if IsColor then COlorScr:=YesColor
    else ColorScr:=NoColor;
  end;
  if ColorScr=NoColor then
  begin
    DefaultColors(false);
    shadow:=0;
  end else
  begin
    DefaultColors(true);
    shadow:=2;
  end;
  if (MultiTasker=DESQview) and not Virtualize_DV then
  with DESQviewOpts do
  begin
    HardFirst:=-1; HardLast:=-1;
  end;

  SavedScreenSize:=MaxX*MaxY*2;
  if SavedScreenSize>TempBufSize then SavedScreenSize:=0
  else Move(VideoBuf^,TempBuf,SavedScreenSize);
  if StartupMode>0 then
  begin
    CurrentMode:=StartupMode; CurrentLen:=25;
  end else if CurrentMode=$FF then CurrentMode:=NormalMode;
  if (StartupLen>25) and (IsEGA or IsVGA) then
  begin
    CurrentMode:=NormalMode;
    CurrentLen:=StartupLen;
  end;
  if CurrentMode=7 then CurrentLen:=25;
  if IsEGA and (CurrentLen=50) then CurrentLen:=43;
  if IsEga and (CurrentLen=40) then CurrentLen:=35;
  if IsEGA and not (CurrentLen in [25, 35, 43]) then CurrentLen:=25
  else if IsVGA and not (CurrentLen in [25,28,30,33,34,35,40,43,48,50,60]) then
     CurrentLen:=25;
  set_bibdb_mode;
  CursorOff;
  Tpwfill(1,1,ScrLen,ScrWidth,' ',EntryNorm);
  ScreenInitialized:=true;
{$ENDIF}

                                 { SelfTest }
{$IFNDEF WINDOWS}
  If DoSelfTest or (Correct.bibsize=0) then SelfTest;

  WaitingMessage('Initializing...');
{$ENDIF}

  { Virtual Memory }

  MemoryUsed:=0;
{$IFNDEF WINDOWS}
  MemoryUsed:=(MaxScrWidth-3+MaxOverView)*(MaxScrLen-5);   { memory used in overview }
  i:=((MaxScrWidth-5) div 15)*(MaxScrLen-5)*16;            { memory used in entrylist }
  if i>MemoryUsed then MemoryUsed:=i;
{$ENDIF}
  if sizeof(PatRec)>MemoryUsed then MemoryUsed:=sizeof(PatRec);
  MemoryUsed:=MemoryUsed+4096;                 { various }

  MU:=MemoryUsed;
  if UseVirtualMemory then
  begin
    VFileSize:=0;
{$IFNDEF WINDOWS}
    if SaveTheScreen then   { Room for the startup screen }
    begin
      M:=MaxX*MaxY*2;
      if ForceKeepInStream or (MaxAvail-MU<M) then
        VFileSize:=VFileSize+M
      else MU:=MU+M;
    end;
{$ENDIF}
                        { Memory }
    M:=36*256;
    if ForceKeepInStream or (MaxAvail-MU<M) then VFileSize:=VFileSize+M
    else MU:=MU+M;
                         { Room for the three sort patterns }
    M:=sizeof(PatRec);
    if ForceKeepInStream or (MaxAvail-MU<M) then VFileSize:=VFileSize+M
    else MU:=MU+M;
    if ForceKeepInStream or (MaxAvail-MU<M) then VFileSize:=VFileSize+M
    else MU:=MU+M;
    if ForceKeepInStream or (MaxAvail-MU<M) then VFileSize:=VFileSize+M
    else MU:=MU+M;
    if UseClipBoard then                { Room for the clipboard }
    begin
      M:=sizeof(EntryRec)+MaxNumberBig*(MaxBig+1);  { Clipboard }
      if  ForceKeepInStream or (MaxAvail-MU<M) then
        VFileSize:=VFileSize+M
      else MU:=MU+M;
    end;
    MU:=MemoryUsed-sizeof(ListArr);
    if auxdir<>'' then                       { Room for various components }
    begin
      if (MaxBig+1)<2*sizeof(PatRec)+2*160*60 then
        M:=2*sizeof(PatRec)+2*160*60
      else M:=M+(MaxBig+1);
      if ForceKeepInStream or (MaxAvail-MU<M) then
        VFileSize:=VFileSize+M
      else MU:=MU+M;
    end;     
    VirtualStream:=Nil;
    WorkBufSize:=AuxBufSize;
{$IFDEF WINDOWS}
    New(VirtualStream,Init(WorkVirtualMem));
{$ELSE}
    New(VirtualStream,Init(WorkStreamOrder));
{$ENDIF}
    WorkBufSize:=AuxBufSize;
    if VirtualStream<>Nil then
    begin
      VirtualStream^.seek(0);
      FillChar(tmp[0],256,#0);
      for M:=1 to (VFileSize div 256)+1 do
        VirtualStream^.write(tmp[0],256);
    end;
    if (VirtualStream=Nil) or (VirtualStream^.status<>stOK) then
      FatalErrorRC(Str_NotEnoughVmem,'');
    VirtualStream^.seek(0);
  end;
  { Save the screen }

{$IFNDEF WINDOWS}
  if SaveTheScreen and (SavedScreenSize>0) then
    PushBufferStack(TempBuf,SavedScreenSize,EnoughMem(MemoryUsed),0)
  else PushBufferStack(TempBuf,SavedScreenSize,DontKeep,0);
{$ENDIF}

  { Prepare memory registers }

  MemoryMode:=EnoughMem(MemoryUsed+36*256);
  MemoryPos:=BuffStackInd+1;
  FillChar(tmp[1],255,' '); tmp[0]:=#0;
  for i:=1 to 36 do PushBufferStack(tmp[0],256,MemoryMode,0);

  { Prepare the pattern }

  New(Pattern);  
  with Pattern^ do
  begin
    noper:=0; npatt:=0; on:=false;
  end;
  
  { Test DefPatternScope and DefSearchScope }

  if DefPatternScope<>'_none' then
  begin
    tmp:=DefPatternScope+' "blabla"';
    InputPattern(cfg,Nil,Pattern,tmp,false,false);
    if Pattern^.noper=0 then FatalErrorRC(Str_BadDefPatScope,'');
    with Pattern^ do
    begin
      noper:=0; npatt:=0; on:=false;
    end;
  end;
  tmp:=DefSearchScope^+' "blabla"';
  InputPattern(cfg,Nil,Pattern,tmp,false,false);
  if Pattern^.noper=0 then FatalErrorRC(Str_BadDefSrchScope,'');
  DefSearchScope^:=Pattern^.Field[Pattern^.npatt];
{$IFDEF WINDOWS}
  SearchFieldStr:=DefSearchScope^;
{$ENDIF}
  with Pattern^ do
  begin
    noper:=0; npatt:=0; on:=false;
  end;

  { Read the configuration a second time }

  LFNReset(cfg,0);
  repeat
    repeat
      readln(cfg,S^); ChrDel(S^,' ');
    until eof(cfg) or ((S^[1]='\') and (Pos(lbrace,S^)>0));
    if not eof(cfg) then
    begin
      StrLwr(S^);
      PStrCopy(tmp,S^,2,Pos(lbrace,S^)-2);  ChrDel(tmp,' ');
      if tmp='entrytypes' then
      begin
        EntryConfig(cfg,EditFieldsDef,IniFieldLast); ConfigEnvFound.EntryTypes:=true;
      end else if tmp='registers' then
      begin
        RegistersConfig(cfg); ConfigEnvFound.Registers:=true;
      end else if tmp='sort' then
      begin
        LoadSortMode(cfg,Nil,CurrentSortMode^,Pattern); ConfigEnvFound.Sort:=true;
      end
{$IFNDEF WINDOWS}
      else if (tmp='colors') or (tmp='colours') then
      begin
        ColorsConfig(cfg,ColorScr);
        ConfigEnvFound.Colors:=true;
      end
{$ENDIF}
      else if tmp='patternfields' then
      begin
        FlistMenuConfig(PmenuChoice,PmenuNum,PmenuStr,PmenuChars,cfg);
        ConfigEnvFound.PatternFields:=true;
      end else if tmp='exportfields' then
      begin
        FlistMenuConfig(DmenuChoice,DmenuNum,DmenuStr,DmenuChars,cfg);
        ConfigEnvFound.ExportFields:=true;
      end else
      begin
        GetRidOfComment(S^);
        nbrace:=ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        while (not eof(cfg)) and (nbrace>0) do
        begin
          readln(cfg,S^); GetRidOfComment(S^);
          nbrace:=nbrace+ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        end;
        tmp:='';
      end;
    end;
  until eof(cfg);
  
  if NumberOfTypes=0 then FatalErrorRC(Str_NoEntriesDefined,'');
  for i:=1 to NumberOfTypes do StrLwr(TypeEntry^[i]);

  { Expand templates }

  PrepareTemplate(LabelTemplate^);
  PrepareTemplate(DefNullLabels^);
                               { Overview templates. }
  for i:=1 to NOverview do
  begin
    PrepareTemplate(TempOver^[i]);
    OverView[i]:=NewStr(TempOver^[i]);
  end;
{$IFDEF WINDOWS}
  Dispose(TempOver);
{$ENDIF}

  { Find the code page and configure accordingly }
{$IFDEF WINDOWS}
  Codepage:=GetCodePage;
{$ELSE}
  if Pos('auto',CodePageStr)=1 then Codepage:=GetCodePage
  else if CodePageStr='US' then CodePage:=437
  else if CodePageStr='multilingual' then CodePage:=850
  else begin
    Val(CodePageStr,CodePage,icode);
    if icode<>0 then CodePage:=0;
  end;
  if CodePage=0 then
  begin
    prog7bit:=false; prog8bit:=false;
    file7bit:=false; file8bit:=false;
  end;
  if debug then message(' Using code page '+num2str(CodePage)+'. ');

  if CodePage=437 then
  begin
    TagChar:=#251; MenuCheckChar:=#251;
  end else
  begin
    TagChar:='*'; MenuCheckChar:='X';
  end;
  
  { Find the command interpreter for shelling to DOS }

  Comspec:=Getenv('COMSPEC'); S^:=comspec;
  tmp:=Concat(Getenv('PATH'),';c:\4dos;c:\drdos;c:\dos;c:\');
  if S^='' then
  begin
    Comspec:='4dos.com';
    FindFile(S^,Comspec,tmp);
  end;
  if S^='' then
  begin
    Comspec:='command.com';
    FindFile(S^,Comspec,tmp);
  end;
  if S^='' then
  begin
    comspec:='';
    ErrorMessage(' Can''t find a command interpreter - set COMSPEC appropriately! ');
  end;
  comspec:=S^;
{$ENDIF}

  { Now read the ShowFormat environment }

  LFNReset(cfg,0);
  repeat
    repeat
      readln(cfg,S^); Untabify(S^); ChrDel(S^,' ');
    until eof(cfg) or ((S^[1]='\') and (Pos(lbrace,S^)>0));
    if not eof(cfg) then
    begin
      StrLwr(S^);
      PStrCopy(tmp,S^,2,Pos(lbrace,S^)-2);
      ChrDel(tmp,' ');
      if tmp='showformat' then
      begin
        BeginOfShowFormat:=TextFilePos(cfg);
{$IFDEF WINDOWS}
        tmp:=ShowFormatConfig(@cfg,Nil,IniFieldLast,@ShowFormat[true],Nil,Nil);
{$ELSE}
        tmp:=ShowFormatConfig(@cfg,IniFieldLast,@ShowFormat[true],@TempBuf,Nil);
{$ENDIF}
        if tmp<>'' then FatalError(tmp);
        { "View All" ShowFormat }
        with ShowFormat[false] do
        begin
          tmp:='';
          for j:=1 to MaxField+1 do tmp:=tmp+sf_Field1+Chr(sfFld_Offset+j);
          GetMem(P,length(tmp));
          move(tmp[1],P^,length(tmp));
          len:=length(tmp);
        end;
        ConfigEnvFound.ShowFormat:=true;
      end else
      begin
        GetRidOfComment(S^);
        nbrace:=ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        while (not eof(cfg)) and (nbrace>0) do
        begin
          readln(cfg,S^); GetRidOfComment(S^);
          if Pos('register',tmp)>0 then
          begin
            UnEscape(S^,lbrace+rbrace);
          end;
          nbrace:=nbrace+ChrQty(S^,lbrace)-ChrQty(S^,rbrace);
        end;
      end;
    end;
  until ConfigEnvFound.ShowFormat or eof(cfg);
  LFNDispose(cfg);
  if not ConfigEnvFound.ShowFormat then FatalErrorRC(Str_NoShowformat,'');

                                     { Initialise Mouse }
{$IFNDEF WINDOWS}
  if UseMouse then
  begin
    InitMouse;
    if mouse_present then
    begin
      MouseCursor.hardware:=false;
      MouseBox(0,0,ScrWidth*Xpixels-1,ScrLen*YPixels-1);
      if (Multitasker=DesqView) and (DESQviewOpts.hardlast>-1) then
      begin
        UsingCursor:=false;
        HardwareTextCursor(DESQviewOpts.hardfirst,DESQviewOpts.hardlast)
      end else if HardWareCur then
      begin
        UsingCursor:=false;
        HardwareTextCursor(normhardfirst,normhardlast);
      end;
      ShowMouseCursor; ShowMouseCursor;
      HideMouseCursor;
    end else UseMouse:=false;
  end;
  OrigUseMouse:=UseMouse;
  if ScrWidth>80 then UseMouse:=UseMouse and WideScreenMouse;
{$ENDIF}

{$IFDEF WINDOWS}
  if UseCtl3d then Load3dDll;           { Use of Ctl3DV2.DLL }
{$ENDIF}
                          { The database files }

  PathListConfig(TexInput,TexInputList);
{$IFDEF WINDOWS}
  PathListConfig(BstInput,BstInputList);
{$ENDIF}

  bibname^:=''; i:=1; nbibfiles:=0;
  New(Name); New(Dir);

  if InputLatexFile then
  begin
    {logging_on:=true;}
    New(fname);
    TexAuxFile^:=CLineFilesList^[1];
    CanonicalFName(TexAuxFile^);
    fname^:=TexAuxFile^; StrLwr(fname^);
    if Pos('.tex',fname^)=length(fname^)-3 then
    begin
      dec(TexAuxFile^[0],3); TexAuxFile^:=TexAuxFile^+'aux';
    end;
    logsection('/latex: "'+TexAuxFile^+'"',true); accept:=true;
    FileChoose(TexAuxFile^,'.aux',TexInputList,
               AnyFile and (not (Directory or SysFile)),
               false,true,false,Nil,'TeX aux file:',TeXAuxDesc,accept);
    if not accept then TexAuxFile^:=''
    else if Pos('\',TexAuxFile^)=0 then LFNFExpand(TexAuxFile^);
    LFNFSplit(TexAuxFile^,Dir,Nil,Nil);

    LFNNew(tmpfile,true);
    ScanOneFile(tmpfile,TexAuxFile,Dir);
    LFNDispose(tmpfile);

    Dispose(fname);
    if nbibfiles=0 then ErrorMessageRC(Str_NoBibFiles,'');
    logsection('/latex '+num2str(nbibfiles),false);
    {logging_on:=false;}
  end else for i:=1 to CLineFiles do
  begin
    if nbibfiles<MaxBibFiles then
    begin
      if (not IsWildcard(CLineFilesList^[i])) or
        ValidRegexp(CLineFilesList^[i],true) then
      begin
        Inc(nbibfiles);
        bibfiles^[nbibfiles].name:=CLineFilesList^[i];
      end;
    end;
  end;
  if nbibfiles=0 then        { No file specified on the command line }
  begin
    bibfiles^[1].name:=''; nbibfiles:=1;
    CurrentBibFile:=1;
  end else
  begin
    MustExist:=true;
    CurrentBibFile:=0;
    for i:=1 to MaxBibFiles do if bibfiles^[i].name<>'' then
    begin
      tmp:=bibfiles^[i].name; IndexToBibExt(tmp);
      NewBib(tmp,false,MustExist,true,bjunk);
      if tmp<>'' then
      begin
        BibFiles^[i].name:=tmp;
        CanonicalFName(BibFiles^[i].name);
        LFNFsplit(bibfiles^[i].name,Dir,Name,S);
        if S^='' then S^:=DefExtension[BibTeXFormat]^;
        Bibfiles^[i].name:=LFNfexpand(Concat(Dir^,Name^,S^));
        CanonicalFName(BibFiles^[i].name);
        if MustExist then CurrentBibFile:=i;
        MustExist:=false;
      end else
      begin
        tmp:=LFNFexpand(BibFiles^[i].name);
        if not IsFileName(tmp) then tmp:=''
        else begin
          LFNFsplit(tmp,Dir,Name,S);
          if S^='' then S^:=DefExtension[BibTeXFormat]^;
          tmp:=Concat(Dir^,Name^,S^);
        end;
        CanonicalFName(tmp);
        bibfiles^[i].name:=tmp;
      end;
    end;
  end;
  if CurrentBibFile=0 then
  begin
     bibfiles^[1].name:=''; nbibfiles:=1;
     CurrentBibFile:=1;
     { FatalErrorRC(Str_NoBibFiles,'');}
  end;
  for i:=1 to MaxBibFiles do
    BibFiles^[i].time:=GetFileTime(BibFiles^[i].name);
  bibname^:=bibfiles^[CurrentBibFile].name;
  if (bibname^<>'') and not IsFileName(bibname^) then
     FatalErrorRC(Str_BibCmdLineErr,'');
  BibFileExists:=LFNFileExist(bibname^);
  LFNAssign(bib,bibname^);
  UnixBib:=IsUnixFile(bib,bibname^);
  ResetBibFile(bib,bibname^);
  SetTextBuf(bib,bibbuf^,FileBufSize);
  GetFAttr(bib,bibattr);
  BibReadOnly:=ForbidEditing or (bibattr and ReadOnly <> 0);

  Dispose(Dir); Dispose(Name);

                       { Tags }
  EraseTags(Tags);

  { look for sort order info }

  ConfigSortMode^:=CurrentSortMode^;
  SortPattModeDef:=EnoughMem(sizeof(PatRec)+MemoryUsed);
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeDef,0);
  SortPattPosDef:=BuffStackInd;
  SortPattModeCur:=EnoughMem(sizeof(PatRec)+MemoryUsed);
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,0);
  SortPattPosCur:=BuffStackInd;
  ExportSortMode^:=CurrentSortMode^;
  ExportSortMode^.SortingOn:=SortNewFiles;
  SortPattModeExp:=EnoughMem(sizeof(PatRec)+MemoryUsed);
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeExp,0);
  SortPattPosExp:=BuffStackInd;

  if BibFileExists then
  begin
    CurrentSortMode^.SortingOn:=SortedByDefault;
    finish:=false;
    i:=0;
    while (not eof(bib)) and (not finish) and (i<=MaxLookForSort) do
    begin
      tmp:='';
      ReadLine(bib,tmp,UnixBib); ChrDel(tmp,' '); StrLwr(tmp);
      inc(i);
      if tmp='\sort'+lbrace then
      begin
        LoadSortMode(bib,Nil,CurrentSortMode^,Pattern);
        finish:=true;
      end;
    end;
  end else CurrentSortMode^.SortingOn:=SortNewFiles;
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur);

  CheckForIndexFile(bib,bibname);

  ResetBibFile(bib,bibname^);
  SetTextBuf(bib,bibbuf^,FileBufSize);

  { make links }

  if linked then
  begin
    BibRingNum:=0;
    for i:=1 to MaxBibFiles do
    begin
      if LFNFileExist(BibFiles^[i].name) then
      begin
        Inc(BibRingNum);
        BibRing[BibRingNum]:=i;
      end;
      BibFiles^[i].EntryStart:=0; BibFiles^[i].RealStart:=0;
    end;
    if BibRingNum<=1 then linked:=false;
  end else
  begin
    BibRing[1]:=CurrentBibFile; BibRingNum:=1;
  end;
  BibInRing:=1;

  { The Export files }
  {
  for i:=1 to LastFileFormat do
  if  DefExtension[i]=Nil then message(num2str(i)+' - nil')
  else message(num2str(i)+' - "'+DefExtension[i]^+'"');
  }
  New(Dir); New(Name);
  for i:=1 to LastFileFormat do
  if DumpFileList^[i]<>'' then
  begin
    DumpFileList^[i]:=LFNFexpand(DumpFileList^[i]);
    CanonicalFName(DumpFileList^[i]);
    LFNFsplit(DumpFileList^[i],Dir,Name,S);
    if S^='' then DumpFileList^[i]:=Dir^+Name^+DefExtension[i]^;
  end;
  DumpFirstTime:=true; DumpName^:='';
  if Option[COpt_x].found then DumpName^:=Option[COpt_x].S^;
  ChrDelL(DumpName^,' '); ChrDelR(DumpName^,' '); ChrDel(DumpName^,'"');
  if DumpName^<>'' then
  begin
    StrRepl(DumpName^,'/','\',1,255,255);
    if not IsFileName(DumpName^) then
    begin
      ErrorMessageRC(Str_ExpCmdLineErr,'');
      DumpName^:='';
    end;
  end else DumpName^:=DumpFileList^[ExportFormat];
  if DumpName^<>'' then NewDump(false,bibname^);

  Dispose(Name); Dispose(Dir);

                       { Clipboard }
{$IFNDEF WINDOWS}
  if UseClipBoard then
  begin
    ClipBoardMode:=EnoughMem(sizeof(EntryRec)-Maxfield*sizeof(BigTypePtr)
       -2*sizeof(longint)-2*sizeof(Word) +MaxNumberBig*(MaxBig+1)
       +MemoryUsed);
    ClipboardPosition:=BuffStackInd+1;
  end;
{$ENDIF}
                       { Pattern }
  New(PatternFile); PatternFile^:='';
  with pattern^ do
  begin
    noper:=0; npatt:=0; on:=false;
  end;
  if Copy(PattString,1,6)='_file:' then
  begin
    Delete(PattString,1,6); ChrDelL(PattString,' ');
    if PattString<>'' then
    begin
      if PattString[1]='"' then
      begin
        Delete(PattString,1,1);
        if (PattString<>'') and (PattString[length(PattString)]='"') then
          Delete(PattString,length(PattString),1);
      end;
      PatternFile^:=PattString; PattString:='';
    end;
  end;

  if SelectTagged and (PatternFile^='') and (PattString='') then
    PattString:=PattStr_Tagged;
  if PatternFile^<>'' then    { /p option with file name }
  begin
    New(Dir); New(Name);
    StrRepl(PatternFile^,'/','\',1,255,255);
    LFNFSplit(PatternFile^,Dir,Name,S);
    if not IsFileName(PatternFile^) or (PatternFile^<>Dir^+Name^+S^) then
      ErrorMessageRC(Str_CmdNoPattFile,'')
    else begin
      PatternLoad(Pattern,PatternFile^,false,ok);
      if (not ok) and (PatternFile^<>'') then
        ErrorMessageRC(Str_CmdNoPattFile,'');
    end;
    Dispose(Name); Dispose(Dir);
  end;
  if PattString<>'' then    { /p option with explicit string }
  begin
    with pattern^ do
    begin
      noper:=0; npatt:=0; on:=false;
    end;
    TryString:=(PattString[1]='"') or (length(PattString)<3);
    if not TryString then
    begin
      InputPattern(cfg,Nil,Pattern,PattString,false,false);
      if Pattern^.noper>0 then TryString:=false
      else TryString:=(Pos(' ',PattString)=0);
    end;
    if TryString then
    begin
      if PattString[1]='"' then delete(PattString,1,1);
      i:=length(PattString);
      if (PattString[i]='"') and ((i=1) or (PattString[i-1]<>'"')) then
        Delete(PattString,i,1);
      if PattString='' then TryString:=false;
    end;
    if TryString and (DefPatternScope<>'_none') then
    begin
      tmp:=DefPatternScope+' "blabla"';
      InputPattern(cfg,Nil,Pattern,tmp,false,false);
      Pattern^.Patrn[Pattern^.npatt]:=PattString;
    end;
    if Pattern^.noper>0 then Pattern^.on:=true
    else begin
      ErrorMessageRC(Str_SyntaxErrP,'');
      with pattern^ do
      begin
        noper:=0; npatt:=0; on:=false;
      end;
    end;
  end;
  PatternNumber:=0;
  Dispose(PatternFile);

                     { EditFields default }
  if EditFieldsDef<5 then
  for i:=1 to NumberOfTypes do
  begin
    if EditFieldsDef=4 then
    for j:=1 to fieldlast do EditFields^[i]:=Concat(EditFields^[i],Chr(j))
    else if EditFieldsDef>0 then
    for j:=1 to required^[i,0] do
    if ((EditFieldsDef in [1,3]) and (required^[i,j]>0)) or
       ((EditFieldsDef in [2,3]) and (required^[i,j]<0)) then
         EditFields^[i]:=Concat(EditFields^[i],Chr(abs(required^[i,j])));
  end;
  for i:=1 to NumberOfTypes do DefEditFields^[i]:=EditFields^[i];

{$IFNDEF WINDOWS}
  Menus;

  if Execswap then
  begin
    init_spawno(SwapDir,swapMode,20,0);
  end;
  WaitingOff;
{$ENDIF}
                                  { 8-bit translation }
  if DispEncoding<0  then DispEncoding :=EncodingsList.Count-1;
  if FReadEncoding<0 then FReadEncoding:=EncodingsList.Count-1;
  HighBits(DispEncoding,FReadEncoding,-1);

  UnInitialized:=false;

  PSuspendFile:=@bib;     { What file to close on timeout }

  { cache stuff }
  New(EntryCache,Init(MaxCache));
  EntryCache^.LookForCacheFile('',Nil,true,false,Nil,Nil,Nil);
  EntryCache^.LoadCache(Pattern);
  MaxMemAvail;
{$IFDEF WINDOWS}
  Dispose(CLineFilesList);
  Dispose(S);
{$ENDIF}
end;                       { InitDb }

end.
