/* $Id: isdnif.h,v 1.20.2.7 1999/08/30 19:50:42 keil Exp $
 *
 * Linux ISDN subsystem
 *
 * Definition of the interface between the subsystem and its low-level drivers.
 *
 * Copyright 1994-1998  by Fritz Elfert (fritz@isdn4linux.de)
 * Copyright 1995,96    Thinking Objects Software GmbH Wuerzburg
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Log: isdnif.h,v $
 * Revision 1.20.2.7  1999/08/30 19:50:42  keil
 * resync hisax for 2.0 to 2.2/2.3 stuff
 *
 * Revision 1.20.2.6  1999/07/15 13:14:15  keil
 * add ISDN_STAT_DISCH from 2.2
 *
 * Revision 1.20.2.5  1999/07/01 11:10:13  keil
 * changes for compatibility
 *
 * Revision 1.20.2.4  1999/05/05 19:28:45  werner
 * added new stat message for DISPLAY
 *
 * Revision 1.20.2.3  1999/04/22 21:12:18  werner
 * Added support for dss1 diversion services
 *
 * Revision 1.20.2.2  1998/11/05 22:13:33  fritz
 * Changed mail-address.
 *
 * Revision 1.20.2.1  1998/03/07 23:00:50  tsbogend
 * added defines for Linux/Alpha 2.0.x with alpha-patches
 *
 * Revision 1.20  1997/05/27 15:18:06  fritz
 * Added changes for recent 2.1.x kernels:
 *   changed return type of isdn_close
 *   queue_task_* -> queue_task
 *   clear/set_bit -> test_and_... where apropriate.
 *   changed type of hard_header_cache parameter.
 *
 * Revision 1.19  1997/03/25 23:13:56  keil
 * NI-1 US protocol
 *
 * Revision 1.18  1997/03/04 22:09:18  calle
 * Change macros copy_from_user and copy_to_user in inline function.
 * These are now correct replacements of the functions for 2.1.xx
 *
 * Revision 1.17  1997/02/10 21:12:53  fritz
 * More setup-interface changes.
 *
 * Revision 1.16  1997/02/10 19:42:57  fritz
 * New interface for reporting incoming calls.
 *
 * Revision 1.15  1997/02/09 00:18:42  keil
 * leased line support
 *
 * Revision 1.14  1997/02/03 23:43:00  fritz
 * Misc changes for Kernel 2.1.X compatibility.
 *
 * Revision 1.13  1996/11/13 02:39:59  fritz
 * More compatibility changes.
 *
 * Revision 1.12  1996/11/06 17:38:48  keil
 * more changes for 2.1.X
 *
 * Revision 1.11  1996/10/23 11:59:42  fritz
 * More compatibility changes.
 *
 * Revision 1.10  1996/10/22 23:14:19  fritz
 * Changes for compatibility to 2.0.X and 2.1.X kernels.
 *
 * Revision 1.9  1996/06/06 21:24:24  fritz
 * Started adding support for suspend/resume.
 *
 * Revision 1.8  1996/05/18 01:45:37  fritz
 * More spelling corrections.
 *
 * Revision 1.7  1996/05/18 01:37:19  fritz
 * Added spelling corrections and some minor changes
 * to stay in sync with kernel.
 *
 * Revision 1.6  1996/05/17 03:59:28  fritz
 * Marked rcvcallb and writebuf obsolete.
 *
 * Revision 1.5  1996/05/01 11:43:54  fritz
 * Removed STANDALONE
 *
 * Revision 1.4  1996/05/01 11:38:40  fritz
 * Added ISDN_FEATURE_L2_TRANS
 *
 * Revision 1.3  1996/04/29 22:57:54  fritz
 * Added driverId and channel parameters to
 * writecmd() and readstat().
 * Added constant for voice-support.
 *
 * Revision 1.2  1996/04/20 17:02:40  fritz
 * Changes to support skbuffs for Lowlevel-Drivers.
 * Misc. typos
 *
 * Revision 1.1  1996/01/09 05:50:51  fritz
 * Initial revision
 *
 */

#ifndef isdnif_h
#define isdnif_h

#include <linux/isdn_compat.h>
/*
 * Values for general protocol-selection
 */
#define ISDN_PTYPE_UNKNOWN   0   /* Protocol undefined   */
#define ISDN_PTYPE_1TR6      1   /* german 1TR6-protocol */
#define ISDN_PTYPE_EURO      2   /* EDSS1-protocol       */
#define ISDN_PTYPE_LEASED    3   /* for leased lines     */
#define ISDN_PTYPE_NI1       4   /* US NI-1 protocol     */
#define ISDN_PTYPE_MAX       7   /* Max. 8 Protocols     */

/*
 * Values for Layer-2-protocol-selection
 */
#define ISDN_PROTO_L2_X75I   0   /* X75/LAPB with I-Frames      */
#define ISDN_PROTO_L2_X75UI  1   /* X75/LAPB with UI-Frames     */
#define ISDN_PROTO_L2_X75BUI 2   /* X75/LAPB with UI-Frames     */
#define ISDN_PROTO_L2_HDLC   3   /* HDLC                        */
#define ISDN_PROTO_L2_TRANS  4   /* Transparent (Voice)         */
#define ISDN_PROTO_L2_X25DTE 5   /* X25/LAPB DTE mode                 */
#define ISDN_PROTO_L2_X25DCE 6   /* X25/LAPB DCE mode                 */
#define ISDN_PROTO_L2_V11096 7   /* V.110 bitrate adaption 9600 Baud  */
#define ISDN_PROTO_L2_V11019 8   /* V.110 bitrate adaption 19200 Baud */
#define ISDN_PROTO_L2_V11038 9   /* V.110 bitrate adaption 38400 Baud */
#define ISDN_PROTO_L2_MODEM  10  /* Analog Modem on Board */
#define ISDN_PROTO_L2_FAX    11  /* Fax Group 2/3         */
#define ISDN_PROTO_L2_MAX    15  /* Max. 16 Protocols                 */

/*
 * Values for Layer-3-protocol-selection
 */
#define ISDN_PROTO_L3_TRANS  0   /* Transparent                 */

#ifdef __KERNEL__

#include <linux/skbuff.h>

/***************************************************************************/
/* Extensions made by Werner Cornelius (werner@ikt.de)                     */
/*                                                                         */ 
/* The proceed command holds a incoming call in a state to leave processes */
/* enough time to check whether ist should be accepted.                    */
/* The PROT_IO Command extends the interface to make protocol dependant    */
/* features available (call diversion, call waiting...).                   */
/*                                                                         */ 
/* The PROT_IO Command is executed with the desired driver id and the arg  */
/* parameter coded as follows:                                             */
/* The lower 8 bits of arg contain the desired protocol from ISDN_PTYPE    */
/* definitions. The upper 24 bits represent the protocol specific cmd/stat.*/
/* Any additional data is protocol and command specific.                   */
/* This mechanism also applies to the statcallb callback STAT_PROT.        */    
/*                                                                         */
/* This suggested extension permits an easy expansion of protocol specific */
/* handling. Extensions may be added at any time without changing the HL   */
/* driver code and not getting conflicts without certifications.           */
/* The well known CAPI 2.0 interface handles such extensions in a similar  */
/* way. Perhaps a protocol specific module may be added and separately     */
/* loaded and linked to the basic isdn module for handling.                */                    
/***************************************************************************/

/*****************/
/* DSS1 commands */ 
/*****************/
#define DSS1_CMD_INVOKE       ((0x00 << 8) | ISDN_PTYPE_EURO)   /* invoke a supplementary service */
#define DSS1_CMD_INVOKE_ABORT ((0x01 << 8) | ISDN_PTYPE_EURO)   /* abort a invoke cmd */

/*******************************/
/* DSS1 Status callback values */
/*******************************/
#define DSS1_STAT_INVOKE_RES  ((0x80 << 8) | ISDN_PTYPE_EURO)   /* Result for invocation */
#define DSS1_STAT_INVOKE_ERR  ((0x81 << 8) | ISDN_PTYPE_EURO)   /* Error Return for invocation */
#define DSS1_STAT_INVOKE_BRD  ((0x82 << 8) | ISDN_PTYPE_EURO)   /* Deliver invoke broadcast info */


/*********************************************************************/
/* structures for DSS1 commands and callback                         */
/*                                                                   */
/* An action is invoked by sending a DSS1_CMD_INVOKE. The ll_id, proc*/
/* timeout, datalen and data fields must be set before calling.      */
/*                                                                   */
/* The return value is a positive hl_id value also delivered in the  */
/* hl_id field. A value of zero signals no more left hl_id capacitys.*/
/* A negative return value signals errors in LL. So if the return    */
/* value is <= 0 no action in LL will be taken -> request ignored    */
/*                                                                   */
/* The timeout field must be filled with a positive value specifying */
/* the amount of time the INVOKED process waits for a reaction from  */
/* the network.                                                      */
/* If a response (either error or result) is received during this    */
/* intervall, a reporting callback is initiated and the process will */
/* be deleted, the hl identifier will be freed.                      */
/* If no response is received during the specified intervall, a error*/
/* callback is initiated with timeout set to -1 and a datalen set    */
/* to 0.                                                             */
/* If timeout is set to a value <= 0 during INVOCATION the process is*/
/* immediately deleted after sending the data. No callback occurs !  */
/*                                                                   */
/* A currently waiting process may be aborted with INVOKE_ABORT. No  */
/* callback will occur when a process has been aborted.              */
/*                                                                   */
/* Broadcast invoke frames from the network are reported via the     */
/* STAT_INVOKE_BRD callback. The ll_id is set to 0, the other fields */
/* are supplied by the network and not by the HL.                    */   
/*********************************************************************/
typedef struct
  { ulong ll_id; /* ID supplied by LL when executing    */
		 /* a command and returned by HL for    */
                 /* INVOKE_RES and INVOKE_ERR           */
    int hl_id;   /* ID supplied by HL when called       */
                 /* for executing a cmd and delivered   */
                 /* for results and errors              */
                 /* must be supplied by LL when aborting*/  
    int proc;    /* invoke procedure used by CMD_INVOKE */
                 /* returned by callback and broadcast  */ 
    int timeout; /* timeout for INVOKE CMD in ms        */
                 /* -1  in stat callback when timed out */
                 /* error value when error callback     */
    int datalen; /* length of cmd or stat data          */
    u_char *data;/* pointer to data delivered or send   */
  } dss1_cmd_stat;


/*
 * Commands from linklevel to lowlevel
 *
 */
#define ISDN_CMD_IOCTL    0       /* Perform ioctl                         */
#define ISDN_CMD_DIAL     1       /* Dial out                              */
#define ISDN_CMD_ACCEPTD  2       /* Accept an incoming call on D-Chan.    */
#define ISDN_CMD_ACCEPTB  3       /* Request B-Channel connect.            */
#define ISDN_CMD_HANGUP   4       /* Hangup                                */
#define ISDN_CMD_CLREAZ   5       /* Clear EAZ(s) of channel               */
#define ISDN_CMD_SETEAZ   6       /* Set EAZ(s) of channel                 */
#define ISDN_CMD_GETEAZ   7       /* Get EAZ(s) of channel                 */
#define ISDN_CMD_SETSIL   8       /* Set Service-Indicator-List of channel */
#define ISDN_CMD_GETSIL   9       /* Get Service-Indicator-List of channel */
#define ISDN_CMD_SETL2   10       /* Set B-Chan. Layer2-Parameter          */
#define ISDN_CMD_GETL2   11       /* Get B-Chan. Layer2-Parameter          */
#define ISDN_CMD_SETL3   12       /* Set B-Chan. Layer3-Parameter          */
#define ISDN_CMD_GETL3   13       /* Get B-Chan. Layer3-Parameter          */
#define ISDN_CMD_LOCK    14       /* Signal usage by upper levels          */
#define ISDN_CMD_UNLOCK  15       /* Release usage-lock                    */
#define ISDN_CMD_SUSPEND 16       /* Suspend connection                    */
#define ISDN_CMD_RESUME  17       /* Resume connection                     */
#define ISDN_CMD_PROCEED 18       /* Proceed with call establishment       */
#define ISDN_CMD_ALERT   19       /* Alert after Proceeding                */
#define ISDN_CMD_REDIR   20       /* Redir a incoming call                 */ 
#define ISDN_CMD_PROT_IO 21       /* Protocol specific commands            */
#define CAPI_PUT_MESSAGE 22       /* CAPI message send down or up          */

/*
 * Status-Values delivered from lowlevel to linklevel via
 * statcallb().
 *
 */
#define ISDN_STAT_STAVAIL 256    /* Raw status-data available             */
#define ISDN_STAT_ICALL   257    /* Incoming call detected                */
#define ISDN_STAT_RUN     258    /* Signal protocol-code is running       */
#define ISDN_STAT_STOP    259    /* Signal halt of protocol-code          */
#define ISDN_STAT_DCONN   260    /* Signal D-Channel connect              */
#define ISDN_STAT_BCONN   261    /* Signal B-Channel connect              */
#define ISDN_STAT_DHUP    262    /* Signal D-Channel disconnect           */
#define ISDN_STAT_BHUP    263    /* Signal B-Channel disconnect           */
#define ISDN_STAT_CINF    264    /* Charge-Info                           */
#define ISDN_STAT_LOAD    265    /* Signal new lowlevel-driver is loaded  */
#define ISDN_STAT_UNLOAD  266    /* Signal unload of lowlevel-driver      */
#define ISDN_STAT_BSENT   267    /* Signal packet sent                    */
#define ISDN_STAT_NODCH   268    /* Signal no D-Channel                   */
#define ISDN_STAT_ADDCH   269    /* Add more Channels                     */
#define ISDN_STAT_CAUSE   270    /* Cause-Message                         */
#define ISDN_STAT_ICALLW  271    /* Incoming call without B-chan waiting  */
#define ISDN_STAT_REDIR   272    /* Redir result                          */ 
#define ISDN_STAT_PROT    273    /* protocol IO specific callback         */
#define ISDN_STAT_DISPLAY 274    /* deliver a received display message    */
#define ISDN_STAT_L1ERR   275    /* Signal Layer-1 Error                  */
#define ISDN_STAT_FAXIND  276    /* FAX indications from HL-driver        */
#define ISDN_STAT_AUDIO   277    /* DTMF, DSP indications                 */
#define ISDN_STAT_DISCH   278    /* Disable/Enable channel usage          */

/*
 * Values for feature-field of interface-struct.
 */
/* Layer 2 */
#define ISDN_FEATURE_L2_X75I    (0x0001 << ISDN_PROTO_L2_X75I)
#define ISDN_FEATURE_L2_X75UI   (0x0001 << ISDN_PROTO_L2_X75UI)
#define ISDN_FEATURE_L2_X75BUI  (0x0001 << ISDN_PROTO_L2_X75BUI)
#define ISDN_FEATURE_L2_HDLC    (0x0001 << ISDN_PROTO_L2_HDLC)
#define ISDN_FEATURE_L2_TRANS   (0x0001 << ISDN_PROTO_L2_TRANS)
#define ISDN_FEATURE_L2_X25DTE  (0x0001 << ISDN_PROTO_L2_X25DTE)
#define ISDN_FEATURE_L2_X25DCE  (0x0001 << ISDN_PROTO_L2_X25DCE)
#define ISDN_FEATURE_L2_V11096  (0x0001 << ISDN_PROTO_L2_V11096)
#define ISDN_FEATURE_L2_V11019  (0x0001 << ISDN_PROTO_L2_V11019)
#define ISDN_FEATURE_L2_V11038  (0x0001 << ISDN_PROTO_L2_V11038)
#define ISDN_FEATURE_L2_MODEM   (0x0001 << ISDN_PROTO_L2_MODEM)
#define ISDN_FEATURE_L2_FAX	(0x0001 << ISDN_PROTO_L2_FAX)

#define ISDN_FEATURE_L2_MASK    (0x0FFFF) /* Max. 16 protocols */
#define ISDN_FEATURE_L2_SHIFT   (0)

/* Layer 3 */
#define ISDN_FEATURE_L3_TRANS   (0x0100 << ISDN_PROTO_L3_TRANS)

#define ISDN_FEATURE_L3_MASK    (0x0FF0000) /* Max. 8 Protocols */
#define ISDN_FEATURE_L3_SHIFT   (16)

/* Signaling */
#define ISDN_FEATURE_P_UNKNOWN  (0x1000 << ISDN_PTYPE_UNKNOWN)
#define ISDN_FEATURE_P_1TR6     (0x1000 << ISDN_PTYPE_1TR6)
#define ISDN_FEATURE_P_EURO     (0x1000 << ISDN_PTYPE_EURO)
#define ISDN_FEATURE_P_NI1      (0x1000 << ISDN_PTYPE_NI1)

#define ISDN_FEATURE_P_MASK     (0x0FF000000) /* Max. 8 Protocols */
#define ISDN_FEATURE_P_SHIFT    (24)

typedef struct setup_parm {
    char phone[32];         /* Remote Phone-Number    */
    char eazmsn[32];        /* Local EAZ or MSN       */
    unsigned char si1;      /* Service Indicator 1    */
    unsigned char si2;      /* Service Indicator 2    */
    unsigned char plan;     /* Numbering plan         */
    unsigned char screen;   /* Screening info         */
} setup_parm;

/* CAPI structs */

/* this is compatible to the old union size */
#define MAX_CAPI_PARA_LEN 50

typedef struct {
	/* Header */
	__u16 Length;
	__u16 ApplId;
	__u8 Command;
	__u8 Subcommand;
	__u16 Messagenumber;

	/* Parameter */
	union {
		__u32 Controller;
		__u32 PLCI;
		__u32 NCCI;
	} adr;
	__u8 para[MAX_CAPI_PARA_LEN];
} capi_msg;

/*
 * Structure for exchanging above infos
 *
 */
typedef struct {
	int   driver;		/* Lowlevel-Driver-ID            */
	int   command;		/* Command or Status (see above) */
	ulong arg;		/* Additional Data               */
	union {
		ulong errcode;	/* Type of error with STAT_L1ERR         */
		int length;	/* Amount of bytes sent with STAT_BSENT  */
		u_char num[50];/* Additional Data			*/
		setup_parm setup;/* For SETUP msg			*/
		capi_msg cmsg;	/* For CAPI like messages		*/
		char display[85];/* display message data          */ 
		dss1_cmd_stat dss1_io; /* DSS1 IO-parameter/result */
	} parm;
} isdn_ctrl;

/*
 * The interface-struct itself (initialized at load-time of lowlevel-driver)
 *
 * See Documentation/isdn/INTERFACE for a description, how the communication
 * between the ISDN subsystem and its drivers is done.
 *
 */
typedef struct {
  /* Number of channels supported by this driver
   */
  int channels;

  /* 
   * Maximum Size of transmit/receive-buffer this driver supports.
   */
  int maxbufsize;

  /* Feature-Flags for this driver.
   * See defines ISDN_FEATURE_... for Values
   */
  unsigned long features;

  /*
   * Needed for calculating
   * dev->hard_header_len = linklayer header + hl_hdrlen;
   * Drivers, not supporting sk_buff's should set this to 0.
   */
  unsigned short hl_hdrlen;

  /* Receive-Callback
   * Parameters:
   *             int    Driver-ID
   *             int    local channel-number (0 ...)
   *             u_char pointer to received data (in Kernel-Space, volatile)
   *             int    length of data
   *
   * NOTE: This callback is obsolete, and will be removed when all
   *       current LL-drivers support rcvcall_skb. Do NOT use for new
   *       drivers.
   */
  void (*rcvcallb)(int, int, u_char*, int);

  /*
   * Receive-Callback using sk_buff's
   * Parameters:
   *             int                    Driver-ID
   *             int                    local channel-number (0 ...)
   *             struct sk_buff *skb    received Data
   */
  void (*rcvcallb_skb)(int, int, struct sk_buff *);

  /* Status-Callback
   * Parameters:
   *             isdn_ctrl*
   *                   driver  = Driver ID.
   *                   command = One of above ISDN_STAT_... constants.
   *                   arg     = depending on status-type.
   *                   num     = depending on status-type.
   */
  int (*statcallb)(isdn_ctrl*);
  /* Send command
   * Parameters:
   *             isdn_ctrl*
   *                   driver  = Driver ID.
   *                   command = One of above ISDN_CMD_... constants.
   *                   arg     = depending on command.
   *                   num     = depending on command.
   */
  int (*command)(isdn_ctrl*);
  /* Send Data
   * Parameters:
   *             int    driverId
   *             int    local channel-number (0 ...)
   *             u_char pointer to data
   *             int    length of data
   *             int    Flag: 0 = Call form Kernel-Space (use memcpy,
   *                              no schedule allowed) 
   *                          1 = Data is in User-Space (use memcpy_fromfs,
   *                              may schedule)
   *
   * NOTE: This call is obsolete, and will be removed when all
   *       current LL-drivers support writebuf_skb. Do NOT use for new
   *       drivers.
   */
  int (*writebuf)(int, int, const u_char*, int, int);

  /*
   * Send data using sk_buff's
   * Parameters:
   *             int                    driverId
   *             int                    local channel-number (0...)
   *             int                    Flag: Need ACK for this packet.
   *             struct sk_buff *skb    Data to send
   */
  int (*writebuf_skb) (int, int, int, struct sk_buff *);

  /* Send raw D-Channel-Commands
   * Parameters:
   *             u_char pointer data
   *             int    length of data
   *             int    Flag: 0 = Call form Kernel-Space (use memcpy,
   *                              no schedule allowed) 
   *                          1 = Data is in User-Space (use memcpy_fromfs,
   *                              may schedule)
   *             int    driverId
   *             int    local channel-number (0 ...)
   */
  int (*writecmd)(const u_char*, int, int, int, int);
  /* Read raw Status replies
   *             u_char pointer data (volatile)
   *             int    length of buffer
   *             int    Flag: 0 = Call form Kernel-Space (use memcpy,
   *                              no schedule allowed) 
   *                          1 = Data is in User-Space (use memcpy_fromfs,
   *                              may schedule)
   *             int    driverId
   *             int    local channel-number (0 ...)
   */
  int (*readstat)(u_char*, int, int, int, int);
  char id[20];
} isdn_if;

/*
 * Function which must be called by lowlevel-driver at loadtime with
 * the following fields of above struct set:
 *
 * channels     Number of channels that will be supported.
 * hl_hdrlen    Space to preserve in sk_buff's when sending. Drivers, not
 *              supporting sk_buff's should set this to 0.
 * command      Address of Command-Handler.
 * features     Bitwise coded Features of this driver. (use ISDN_FEATURE_...)
 * writebuf     Address of Send-Command-Handler. OBSOLETE do NOT use anymore.
 * writebuf_skb Address of Skbuff-Send-Handler. (NULL if not supported)
 * writecmd        "    "  D-Channel  " which accepts raw D-Ch-Commands.
 * readstat        "    "  D-Channel  " which delivers raw Status-Data.
 *
 * The linklevel-driver fills the following fields:
 *
 * channels      Driver-ID assigned to this driver. (Must be used on all
 *               subsequent callbacks.
 * rcvcallb      Address of handler for received data. OBSOLETE, do NOT use anymore.
 * rcvcallb_skb  Address of handler for received Skbuff's. (NULL if not supp.)
 * statcallb        "    "     "    for status-changes.
 *
 */
extern int register_isdn(isdn_if*);

#endif /* __KERNEL__ */
#endif /* isdnif_h */
