// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: bpf-registered-target
// RUN: %clang_cc1 -triple bpf -disable-llvm-passes -emit-llvm -o - %s | FileCheck %s

// Check that call to preserve.static.offset is generated when field of
// a struct marked with __attribute__((preserve_static_offset)) is accessed.

#define __ctx __attribute__((preserve_static_offset))

struct foo {
  int a;
} __ctx;

// CHECK-LABEL: define dso_local void @lvalue
// CHECK-SAME: (ptr noundef [[P:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.preserve.static.offset(ptr [[TMP0]])
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_FOO:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK-NEXT:    store i32 42, ptr [[A]], align 4
// CHECK-NEXT:    ret void
//
void lvalue(struct foo *p) {
  p->a = 42;
}
