/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_IMAGE_H
#define VN_PROTOCOL_DRIVER_IMAGE_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/* struct VkSparseImageMemoryRequirements */

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements(const VkSparseImageMemoryRequirements *val)
{
    size_t size = 0;
    size += vn_sizeof_VkSparseImageFormatProperties(&val->formatProperties);
    size += vn_sizeof_uint32_t(&val->imageMipTailFirstLod);
    size += vn_sizeof_VkDeviceSize(&val->imageMipTailSize);
    size += vn_sizeof_VkDeviceSize(&val->imageMipTailOffset);
    size += vn_sizeof_VkDeviceSize(&val->imageMipTailStride);
    return size;
}

static inline void
vn_decode_VkSparseImageMemoryRequirements(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements *val)
{
    vn_decode_VkSparseImageFormatProperties(dec, &val->formatProperties);
    vn_decode_uint32_t(dec, &val->imageMipTailFirstLod);
    vn_decode_VkDeviceSize(dec, &val->imageMipTailSize);
    vn_decode_VkDeviceSize(dec, &val->imageMipTailOffset);
    vn_decode_VkDeviceSize(dec, &val->imageMipTailStride);
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements_partial(const VkSparseImageMemoryRequirements *val)
{
    size_t size = 0;
    size += vn_sizeof_VkSparseImageFormatProperties_partial(&val->formatProperties);
    /* skip val->imageMipTailFirstLod */
    /* skip val->imageMipTailSize */
    /* skip val->imageMipTailOffset */
    /* skip val->imageMipTailStride */
    return size;
}

static inline void
vn_encode_VkSparseImageMemoryRequirements_partial(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements *val)
{
    vn_encode_VkSparseImageFormatProperties_partial(enc, &val->formatProperties);
    /* skip val->imageMipTailFirstLod */
    /* skip val->imageMipTailSize */
    /* skip val->imageMipTailOffset */
    /* skip val->imageMipTailStride */
}

/* struct VkExternalMemoryImageCreateInfo chain */

static inline size_t
vn_sizeof_VkExternalMemoryImageCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalMemoryImageCreateInfo_self(const VkExternalMemoryImageCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->handleTypes);
    return size;
}

static inline size_t
vn_sizeof_VkExternalMemoryImageCreateInfo(const VkExternalMemoryImageCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalMemoryImageCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkExternalMemoryImageCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkExternalMemoryImageCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalMemoryImageCreateInfo_self(struct vn_cs_encoder *enc, const VkExternalMemoryImageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->handleTypes);
}

static inline void
vn_encode_VkExternalMemoryImageCreateInfo(struct vn_cs_encoder *enc, const VkExternalMemoryImageCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO });
    vn_encode_VkExternalMemoryImageCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkExternalMemoryImageCreateInfo_self(enc, val);
}

/* struct VkImageDrmFormatModifierListCreateInfoEXT chain */

static inline size_t
vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT_self(const VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifiers) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        size += vn_sizeof_uint64_t_array(val->pDrmFormatModifiers, val->drmFormatModifierCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT(const VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkImageDrmFormatModifierListCreateInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageDrmFormatModifierListCreateInfoEXT_self(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifiers) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        vn_encode_uint64_t_array(enc, val->pDrmFormatModifiers, val->drmFormatModifierCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkImageDrmFormatModifierListCreateInfoEXT(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT });
    vn_encode_VkImageDrmFormatModifierListCreateInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkImageDrmFormatModifierListCreateInfoEXT_self(enc, val);
}

/* struct VkSubresourceLayout */

static inline size_t
vn_sizeof_VkSubresourceLayout(const VkSubresourceLayout *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkDeviceSize(&val->rowPitch);
    size += vn_sizeof_VkDeviceSize(&val->arrayPitch);
    size += vn_sizeof_VkDeviceSize(&val->depthPitch);
    return size;
}

static inline void
vn_encode_VkSubresourceLayout(struct vn_cs_encoder *enc, const VkSubresourceLayout *val)
{
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkDeviceSize(enc, &val->rowPitch);
    vn_encode_VkDeviceSize(enc, &val->arrayPitch);
    vn_encode_VkDeviceSize(enc, &val->depthPitch);
}

static inline void
vn_decode_VkSubresourceLayout(struct vn_cs_decoder *dec, VkSubresourceLayout *val)
{
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkDeviceSize(dec, &val->rowPitch);
    vn_decode_VkDeviceSize(dec, &val->arrayPitch);
    vn_decode_VkDeviceSize(dec, &val->depthPitch);
}

static inline size_t
vn_sizeof_VkSubresourceLayout_partial(const VkSubresourceLayout *val)
{
    size_t size = 0;
    /* skip val->offset */
    /* skip val->size */
    /* skip val->rowPitch */
    /* skip val->arrayPitch */
    /* skip val->depthPitch */
    return size;
}

static inline void
vn_encode_VkSubresourceLayout_partial(struct vn_cs_encoder *enc, const VkSubresourceLayout *val)
{
    /* skip val->offset */
    /* skip val->size */
    /* skip val->rowPitch */
    /* skip val->arrayPitch */
    /* skip val->depthPitch */
}

/* struct VkImageDrmFormatModifierExplicitCreateInfoEXT chain */

static inline size_t
vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT_self(const VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_uint32_t(&val->drmFormatModifierPlaneCount);
    if (val->pPlaneLayouts) {
        size += vn_sizeof_array_size(val->drmFormatModifierPlaneCount);
        for (uint32_t i = 0; i < val->drmFormatModifierPlaneCount; i++)
            size += vn_sizeof_VkSubresourceLayout(&val->pPlaneLayouts[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT(const VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_uint32_t(enc, &val->drmFormatModifierPlaneCount);
    if (val->pPlaneLayouts) {
        vn_encode_array_size(enc, val->drmFormatModifierPlaneCount);
        for (uint32_t i = 0; i < val->drmFormatModifierPlaneCount; i++)
            vn_encode_VkSubresourceLayout(enc, &val->pPlaneLayouts[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT });
    vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self(enc, val);
}

/* struct VkImageCreateInfo chain */

static inline size_t
vn_sizeof_VkImageCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageCreateInfo_pnext(((const VkExternalMemoryImageCreateInfo *)pnext)->pNext);
            size += vn_sizeof_VkExternalMemoryImageCreateInfo_self((const VkExternalMemoryImageCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageCreateInfo_pnext(((const VkImageFormatListCreateInfo *)pnext)->pNext);
            size += vn_sizeof_VkImageFormatListCreateInfo_self((const VkImageFormatListCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageCreateInfo_pnext(((const VkImageDrmFormatModifierListCreateInfoEXT *)pnext)->pNext);
            size += vn_sizeof_VkImageDrmFormatModifierListCreateInfoEXT_self((const VkImageDrmFormatModifierListCreateInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageCreateInfo_pnext(((const VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext)->pNext);
            size += vn_sizeof_VkImageDrmFormatModifierExplicitCreateInfoEXT_self((const VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageCreateInfo_pnext(((const VkImageStencilUsageCreateInfo *)pnext)->pNext);
            size += vn_sizeof_VkImageStencilUsageCreateInfo_self((const VkImageStencilUsageCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageCreateInfo_self(const VkImageCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkImageType(&val->imageType);
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkExtent3D(&val->extent);
    size += vn_sizeof_uint32_t(&val->mipLevels);
    size += vn_sizeof_uint32_t(&val->arrayLayers);
    size += vn_sizeof_VkSampleCountFlagBits(&val->samples);
    size += vn_sizeof_VkImageTiling(&val->tiling);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkSharingMode(&val->sharingMode);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndexCount);
    if (val->sharingMode == VK_SHARING_MODE_CONCURRENT) {
        size += vn_sizeof_array_size(val->queueFamilyIndexCount);
        size += vn_sizeof_uint32_t_array(val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_VkImageLayout(&val->initialLayout);
    return size;
}

static inline size_t
vn_sizeof_VkImageCreateInfo(const VkImageCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkImageCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkImageCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageCreateInfo_pnext(enc, ((const VkExternalMemoryImageCreateInfo *)pnext)->pNext);
            vn_encode_VkExternalMemoryImageCreateInfo_self(enc, (const VkExternalMemoryImageCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageCreateInfo_pnext(enc, ((const VkImageFormatListCreateInfo *)pnext)->pNext);
            vn_encode_VkImageFormatListCreateInfo_self(enc, (const VkImageFormatListCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageCreateInfo_pnext(enc, ((const VkImageDrmFormatModifierListCreateInfoEXT *)pnext)->pNext);
            vn_encode_VkImageDrmFormatModifierListCreateInfoEXT_self(enc, (const VkImageDrmFormatModifierListCreateInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageCreateInfo_pnext(enc, ((const VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext)->pNext);
            vn_encode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self(enc, (const VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageCreateInfo_pnext(enc, ((const VkImageStencilUsageCreateInfo *)pnext)->pNext);
            vn_encode_VkImageStencilUsageCreateInfo_self(enc, (const VkImageStencilUsageCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageCreateInfo_self(struct vn_cs_encoder *enc, const VkImageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkImageType(enc, &val->imageType);
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkExtent3D(enc, &val->extent);
    vn_encode_uint32_t(enc, &val->mipLevels);
    vn_encode_uint32_t(enc, &val->arrayLayers);
    vn_encode_VkSampleCountFlagBits(enc, &val->samples);
    vn_encode_VkImageTiling(enc, &val->tiling);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkSharingMode(enc, &val->sharingMode);
    vn_encode_uint32_t(enc, &val->queueFamilyIndexCount);
    if (val->sharingMode == VK_SHARING_MODE_CONCURRENT) {
        vn_encode_array_size(enc, val->queueFamilyIndexCount);
        vn_encode_uint32_t_array(enc, val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkImageLayout(enc, &val->initialLayout);
}

static inline void
vn_encode_VkImageCreateInfo(struct vn_cs_encoder *enc, const VkImageCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO });
    vn_encode_VkImageCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkImageCreateInfo_self(enc, val);
}

/* struct VkBindImageMemoryDeviceGroupInfo chain */

static inline size_t
vn_sizeof_VkBindImageMemoryDeviceGroupInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindImageMemoryDeviceGroupInfo_self(const VkBindImageMemoryDeviceGroupInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceIndexCount);
    if (val->pDeviceIndices) {
        size += vn_sizeof_array_size(val->deviceIndexCount);
        size += vn_sizeof_uint32_t_array(val->pDeviceIndices, val->deviceIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->splitInstanceBindRegionCount);
    if (val->pSplitInstanceBindRegions) {
        size += vn_sizeof_array_size(val->splitInstanceBindRegionCount);
        for (uint32_t i = 0; i < val->splitInstanceBindRegionCount; i++)
            size += vn_sizeof_VkRect2D(&val->pSplitInstanceBindRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkBindImageMemoryDeviceGroupInfo(const VkBindImageMemoryDeviceGroupInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindImageMemoryDeviceGroupInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindImageMemoryDeviceGroupInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindImageMemoryDeviceGroupInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindImageMemoryDeviceGroupInfo_self(struct vn_cs_encoder *enc, const VkBindImageMemoryDeviceGroupInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceIndexCount);
    if (val->pDeviceIndices) {
        vn_encode_array_size(enc, val->deviceIndexCount);
        vn_encode_uint32_t_array(enc, val->pDeviceIndices, val->deviceIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->splitInstanceBindRegionCount);
    if (val->pSplitInstanceBindRegions) {
        vn_encode_array_size(enc, val->splitInstanceBindRegionCount);
        for (uint32_t i = 0; i < val->splitInstanceBindRegionCount; i++)
            vn_encode_VkRect2D(enc, &val->pSplitInstanceBindRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkBindImageMemoryDeviceGroupInfo(struct vn_cs_encoder *enc, const VkBindImageMemoryDeviceGroupInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO });
    vn_encode_VkBindImageMemoryDeviceGroupInfo_pnext(enc, val->pNext);
    vn_encode_VkBindImageMemoryDeviceGroupInfo_self(enc, val);
}

/* struct VkBindImagePlaneMemoryInfo chain */

static inline size_t
vn_sizeof_VkBindImagePlaneMemoryInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindImagePlaneMemoryInfo_self(const VkBindImagePlaneMemoryInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageAspectFlagBits(&val->planeAspect);
    return size;
}

static inline size_t
vn_sizeof_VkBindImagePlaneMemoryInfo(const VkBindImagePlaneMemoryInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindImagePlaneMemoryInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindImagePlaneMemoryInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindImagePlaneMemoryInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindImagePlaneMemoryInfo_self(struct vn_cs_encoder *enc, const VkBindImagePlaneMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageAspectFlagBits(enc, &val->planeAspect);
}

static inline void
vn_encode_VkBindImagePlaneMemoryInfo(struct vn_cs_encoder *enc, const VkBindImagePlaneMemoryInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO });
    vn_encode_VkBindImagePlaneMemoryInfo_pnext(enc, val->pNext);
    vn_encode_VkBindImagePlaneMemoryInfo_self(enc, val);
}

/* struct VkBindImageMemoryInfo chain */

static inline size_t
vn_sizeof_VkBindImageMemoryInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBindImageMemoryInfo_pnext(((const VkBindImageMemoryDeviceGroupInfo *)pnext)->pNext);
            size += vn_sizeof_VkBindImageMemoryDeviceGroupInfo_self((const VkBindImageMemoryDeviceGroupInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBindImageMemoryInfo_pnext(((const VkBindImagePlaneMemoryInfo *)pnext)->pNext);
            size += vn_sizeof_VkBindImagePlaneMemoryInfo_self((const VkBindImagePlaneMemoryInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
            if (!vn_cs_renderer_protocol_has_extension(546 /* VK_KHR_maintenance6 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBindImageMemoryInfo_pnext(((const VkBindMemoryStatus *)pnext)->pNext);
            size += vn_sizeof_VkBindMemoryStatus_self((const VkBindMemoryStatus *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindImageMemoryInfo_self(const VkBindImageMemoryInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkDeviceMemory(&val->memory);
    size += vn_sizeof_VkDeviceSize(&val->memoryOffset);
    return size;
}

static inline size_t
vn_sizeof_VkBindImageMemoryInfo(const VkBindImageMemoryInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindImageMemoryInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindImageMemoryInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindImageMemoryInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBindImageMemoryInfo_pnext(enc, ((const VkBindImageMemoryDeviceGroupInfo *)pnext)->pNext);
            vn_encode_VkBindImageMemoryDeviceGroupInfo_self(enc, (const VkBindImageMemoryDeviceGroupInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBindImageMemoryInfo_pnext(enc, ((const VkBindImagePlaneMemoryInfo *)pnext)->pNext);
            vn_encode_VkBindImagePlaneMemoryInfo_self(enc, (const VkBindImagePlaneMemoryInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
            if (!vn_cs_renderer_protocol_has_extension(546 /* VK_KHR_maintenance6 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBindImageMemoryInfo_pnext(enc, ((const VkBindMemoryStatus *)pnext)->pNext);
            vn_encode_VkBindMemoryStatus_self(enc, (const VkBindMemoryStatus *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindImageMemoryInfo_self(struct vn_cs_encoder *enc, const VkBindImageMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkDeviceMemory(enc, &val->memory);
    vn_encode_VkDeviceSize(enc, &val->memoryOffset);
}

static inline void
vn_encode_VkBindImageMemoryInfo(struct vn_cs_encoder *enc, const VkBindImageMemoryInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO });
    vn_encode_VkBindImageMemoryInfo_pnext(enc, val->pNext);
    vn_encode_VkBindImageMemoryInfo_self(enc, val);
}

/* struct VkImagePlaneMemoryRequirementsInfo chain */

static inline size_t
vn_sizeof_VkImagePlaneMemoryRequirementsInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImagePlaneMemoryRequirementsInfo_self(const VkImagePlaneMemoryRequirementsInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageAspectFlagBits(&val->planeAspect);
    return size;
}

static inline size_t
vn_sizeof_VkImagePlaneMemoryRequirementsInfo(const VkImagePlaneMemoryRequirementsInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImagePlaneMemoryRequirementsInfo_pnext(val->pNext);
    size += vn_sizeof_VkImagePlaneMemoryRequirementsInfo_self(val);

    return size;
}

static inline void
vn_encode_VkImagePlaneMemoryRequirementsInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImagePlaneMemoryRequirementsInfo_self(struct vn_cs_encoder *enc, const VkImagePlaneMemoryRequirementsInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageAspectFlagBits(enc, &val->planeAspect);
}

static inline void
vn_encode_VkImagePlaneMemoryRequirementsInfo(struct vn_cs_encoder *enc, const VkImagePlaneMemoryRequirementsInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO });
    vn_encode_VkImagePlaneMemoryRequirementsInfo_pnext(enc, val->pNext);
    vn_encode_VkImagePlaneMemoryRequirementsInfo_self(enc, val);
}

/* struct VkImageMemoryRequirementsInfo2 chain */

static inline size_t
vn_sizeof_VkImageMemoryRequirementsInfo2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageMemoryRequirementsInfo2_pnext(((const VkImagePlaneMemoryRequirementsInfo *)pnext)->pNext);
            size += vn_sizeof_VkImagePlaneMemoryRequirementsInfo_self((const VkImagePlaneMemoryRequirementsInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageMemoryRequirementsInfo2_self(const VkImageMemoryRequirementsInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->image);
    return size;
}

static inline size_t
vn_sizeof_VkImageMemoryRequirementsInfo2(const VkImageMemoryRequirementsInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageMemoryRequirementsInfo2_pnext(val->pNext);
    size += vn_sizeof_VkImageMemoryRequirementsInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkImageMemoryRequirementsInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageMemoryRequirementsInfo2_pnext(enc, ((const VkImagePlaneMemoryRequirementsInfo *)pnext)->pNext);
            vn_encode_VkImagePlaneMemoryRequirementsInfo_self(enc, (const VkImagePlaneMemoryRequirementsInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageMemoryRequirementsInfo2_self(struct vn_cs_encoder *enc, const VkImageMemoryRequirementsInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->image);
}

static inline void
vn_encode_VkImageMemoryRequirementsInfo2(struct vn_cs_encoder *enc, const VkImageMemoryRequirementsInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2 });
    vn_encode_VkImageMemoryRequirementsInfo2_pnext(enc, val->pNext);
    vn_encode_VkImageMemoryRequirementsInfo2_self(enc, val);
}

/* struct VkImageSparseMemoryRequirementsInfo2 chain */

static inline size_t
vn_sizeof_VkImageSparseMemoryRequirementsInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageSparseMemoryRequirementsInfo2_self(const VkImageSparseMemoryRequirementsInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->image);
    return size;
}

static inline size_t
vn_sizeof_VkImageSparseMemoryRequirementsInfo2(const VkImageSparseMemoryRequirementsInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageSparseMemoryRequirementsInfo2_pnext(val->pNext);
    size += vn_sizeof_VkImageSparseMemoryRequirementsInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkImageSparseMemoryRequirementsInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageSparseMemoryRequirementsInfo2_self(struct vn_cs_encoder *enc, const VkImageSparseMemoryRequirementsInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->image);
}

static inline void
vn_encode_VkImageSparseMemoryRequirementsInfo2(struct vn_cs_encoder *enc, const VkImageSparseMemoryRequirementsInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2 });
    vn_encode_VkImageSparseMemoryRequirementsInfo2_pnext(enc, val->pNext);
    vn_encode_VkImageSparseMemoryRequirementsInfo2_self(enc, val);
}

/* struct VkSparseImageMemoryRequirements2 chain */

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2_self(const VkSparseImageMemoryRequirements2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageMemoryRequirements(&val->memoryRequirements);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2(const VkSparseImageMemoryRequirements2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageMemoryRequirements2_pnext(val->pNext);
    size += vn_sizeof_VkSparseImageMemoryRequirements2_self(val);

    return size;
}

static inline void
vn_decode_VkSparseImageMemoryRequirements2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSparseImageMemoryRequirements2_self(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageMemoryRequirements(dec, &val->memoryRequirements);
}

static inline void
vn_decode_VkSparseImageMemoryRequirements2(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2);

    assert(val->sType == stype);
    vn_decode_VkSparseImageMemoryRequirements2_pnext(dec, val->pNext);
    vn_decode_VkSparseImageMemoryRequirements2_self(dec, val);
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2_self_partial(const VkSparseImageMemoryRequirements2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageMemoryRequirements_partial(&val->memoryRequirements);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageMemoryRequirements2_partial(const VkSparseImageMemoryRequirements2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageMemoryRequirements2_pnext_partial(val->pNext);
    size += vn_sizeof_VkSparseImageMemoryRequirements2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSparseImageMemoryRequirements2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageMemoryRequirements2_self_partial(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageMemoryRequirements_partial(enc, &val->memoryRequirements);
}

static inline void
vn_encode_VkSparseImageMemoryRequirements2_partial(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2 });
    vn_encode_VkSparseImageMemoryRequirements2_pnext_partial(enc, val->pNext);
    vn_encode_VkSparseImageMemoryRequirements2_self_partial(enc, val);
}

/* struct VkDeviceImageMemoryRequirements chain */

static inline size_t
vn_sizeof_VkDeviceImageMemoryRequirements_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceImageMemoryRequirements_self(const VkDeviceImageMemoryRequirements *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_simple_pointer(val->pCreateInfo);
    if (val->pCreateInfo)
        size += vn_sizeof_VkImageCreateInfo(val->pCreateInfo);
    size += vn_sizeof_VkImageAspectFlagBits(&val->planeAspect);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceImageMemoryRequirements(const VkDeviceImageMemoryRequirements *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceImageMemoryRequirements_pnext(val->pNext);
    size += vn_sizeof_VkDeviceImageMemoryRequirements_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceImageMemoryRequirements_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceImageMemoryRequirements_self(struct vn_cs_encoder *enc, const VkDeviceImageMemoryRequirements *val)
{
    /* skip val->{sType,pNext} */
    if (vn_encode_simple_pointer(enc, val->pCreateInfo))
        vn_encode_VkImageCreateInfo(enc, val->pCreateInfo);
    vn_encode_VkImageAspectFlagBits(enc, &val->planeAspect);
}

static inline void
vn_encode_VkDeviceImageMemoryRequirements(struct vn_cs_encoder *enc, const VkDeviceImageMemoryRequirements *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS });
    vn_encode_VkDeviceImageMemoryRequirements_pnext(enc, val->pNext);
    vn_encode_VkDeviceImageMemoryRequirements_self(enc, val);
}

/* struct VkImageDrmFormatModifierPropertiesEXT chain */

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_self(const VkImageDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    return size;
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT(const VkImageDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkImageDrmFormatModifierPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkImageDrmFormatModifierPropertiesEXT_self(struct vn_cs_decoder *dec, VkImageDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
}

static inline void
vn_decode_VkImageDrmFormatModifierPropertiesEXT(struct vn_cs_decoder *dec, VkImageDrmFormatModifierPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkImageDrmFormatModifierPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkImageDrmFormatModifierPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_self_partial(const VkImageDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->drmFormatModifier */
    return size;
}

static inline size_t
vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_partial(const VkImageDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->drmFormatModifier */
}

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT });
    vn_encode_VkImageDrmFormatModifierPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkImageDrmFormatModifierPropertiesEXT_self_partial(enc, val);
}

/* struct VkImageSubresource2 chain */

static inline size_t
vn_sizeof_VkImageSubresource2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageSubresource2_self(const VkImageSubresource2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageSubresource(&val->imageSubresource);
    return size;
}

static inline size_t
vn_sizeof_VkImageSubresource2(const VkImageSubresource2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageSubresource2_pnext(val->pNext);
    size += vn_sizeof_VkImageSubresource2_self(val);

    return size;
}

static inline void
vn_encode_VkImageSubresource2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageSubresource2_self(struct vn_cs_encoder *enc, const VkImageSubresource2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageSubresource(enc, &val->imageSubresource);
}

static inline void
vn_encode_VkImageSubresource2(struct vn_cs_encoder *enc, const VkImageSubresource2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2 });
    vn_encode_VkImageSubresource2_pnext(enc, val->pNext);
    vn_encode_VkImageSubresource2_self(enc, val);
}

/* struct VkSubresourceHostMemcpySize chain */

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize_self(const VkSubresourceHostMemcpySize *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize(const VkSubresourceHostMemcpySize *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubresourceHostMemcpySize_pnext(val->pNext);
    size += vn_sizeof_VkSubresourceHostMemcpySize_self(val);

    return size;
}

static inline void
vn_decode_VkSubresourceHostMemcpySize_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSubresourceHostMemcpySize_self(struct vn_cs_decoder *dec, VkSubresourceHostMemcpySize *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_decode_VkSubresourceHostMemcpySize(struct vn_cs_decoder *dec, VkSubresourceHostMemcpySize *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE);

    assert(val->sType == stype);
    vn_decode_VkSubresourceHostMemcpySize_pnext(dec, val->pNext);
    vn_decode_VkSubresourceHostMemcpySize_self(dec, val);
}

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize_self_partial(const VkSubresourceHostMemcpySize *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->size */
    return size;
}

static inline size_t
vn_sizeof_VkSubresourceHostMemcpySize_partial(const VkSubresourceHostMemcpySize *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubresourceHostMemcpySize_pnext_partial(val->pNext);
    size += vn_sizeof_VkSubresourceHostMemcpySize_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSubresourceHostMemcpySize_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubresourceHostMemcpySize_self_partial(struct vn_cs_encoder *enc, const VkSubresourceHostMemcpySize *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->size */
}

static inline void
vn_encode_VkSubresourceHostMemcpySize_partial(struct vn_cs_encoder *enc, const VkSubresourceHostMemcpySize *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE });
    vn_encode_VkSubresourceHostMemcpySize_pnext_partial(enc, val->pNext);
    vn_encode_VkSubresourceHostMemcpySize_self_partial(enc, val);
}

/* struct VkSubresourceLayout2 chain */

static inline size_t
vn_sizeof_VkSubresourceLayout2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
            if (!vn_cs_renderer_protocol_has_extension(271 /* VK_EXT_host_image_copy */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkSubresourceLayout2_pnext(((const VkSubresourceHostMemcpySize *)pnext)->pNext);
            size += vn_sizeof_VkSubresourceHostMemcpySize_self((const VkSubresourceHostMemcpySize *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubresourceLayout2_self(const VkSubresourceLayout2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSubresourceLayout(&val->subresourceLayout);
    return size;
}

static inline size_t
vn_sizeof_VkSubresourceLayout2(const VkSubresourceLayout2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubresourceLayout2_pnext(val->pNext);
    size += vn_sizeof_VkSubresourceLayout2_self(val);

    return size;
}

static inline void
vn_decode_VkSubresourceLayout2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        vn_decode_VkSubresourceLayout2_pnext(dec, ((VkSubresourceHostMemcpySize *)pnext)->pNext);
        vn_decode_VkSubresourceHostMemcpySize_self(dec, (VkSubresourceHostMemcpySize *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkSubresourceLayout2_self(struct vn_cs_decoder *dec, VkSubresourceLayout2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSubresourceLayout(dec, &val->subresourceLayout);
}

static inline void
vn_decode_VkSubresourceLayout2(struct vn_cs_decoder *dec, VkSubresourceLayout2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2);

    assert(val->sType == stype);
    vn_decode_VkSubresourceLayout2_pnext(dec, val->pNext);
    vn_decode_VkSubresourceLayout2_self(dec, val);
}

static inline size_t
vn_sizeof_VkSubresourceLayout2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
            if (!vn_cs_renderer_protocol_has_extension(271 /* VK_EXT_host_image_copy */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkSubresourceLayout2_pnext_partial(((const VkSubresourceHostMemcpySize *)pnext)->pNext);
            size += vn_sizeof_VkSubresourceHostMemcpySize_self_partial((const VkSubresourceHostMemcpySize *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubresourceLayout2_self_partial(const VkSubresourceLayout2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSubresourceLayout_partial(&val->subresourceLayout);
    return size;
}

static inline size_t
vn_sizeof_VkSubresourceLayout2_partial(const VkSubresourceLayout2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubresourceLayout2_pnext_partial(val->pNext);
    size += vn_sizeof_VkSubresourceLayout2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSubresourceLayout2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
            if (!vn_cs_renderer_protocol_has_extension(271 /* VK_EXT_host_image_copy */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkSubresourceLayout2_pnext_partial(enc, ((const VkSubresourceHostMemcpySize *)pnext)->pNext);
            vn_encode_VkSubresourceHostMemcpySize_self_partial(enc, (const VkSubresourceHostMemcpySize *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubresourceLayout2_self_partial(struct vn_cs_encoder *enc, const VkSubresourceLayout2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSubresourceLayout_partial(enc, &val->subresourceLayout);
}

static inline void
vn_encode_VkSubresourceLayout2_partial(struct vn_cs_encoder *enc, const VkSubresourceLayout2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2 });
    vn_encode_VkSubresourceLayout2_pnext_partial(enc, val->pNext);
    vn_encode_VkSubresourceLayout2_self_partial(enc, val);
}

/* struct VkDeviceImageSubresourceInfo chain */

static inline size_t
vn_sizeof_VkDeviceImageSubresourceInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceImageSubresourceInfo_self(const VkDeviceImageSubresourceInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_simple_pointer(val->pCreateInfo);
    if (val->pCreateInfo)
        size += vn_sizeof_VkImageCreateInfo(val->pCreateInfo);
    size += vn_sizeof_simple_pointer(val->pSubresource);
    if (val->pSubresource)
        size += vn_sizeof_VkImageSubresource2(val->pSubresource);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceImageSubresourceInfo(const VkDeviceImageSubresourceInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceImageSubresourceInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceImageSubresourceInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceImageSubresourceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceImageSubresourceInfo_self(struct vn_cs_encoder *enc, const VkDeviceImageSubresourceInfo *val)
{
    /* skip val->{sType,pNext} */
    if (vn_encode_simple_pointer(enc, val->pCreateInfo))
        vn_encode_VkImageCreateInfo(enc, val->pCreateInfo);
    if (vn_encode_simple_pointer(enc, val->pSubresource))
        vn_encode_VkImageSubresource2(enc, val->pSubresource);
}

static inline void
vn_encode_VkDeviceImageSubresourceInfo(struct vn_cs_encoder *enc, const VkDeviceImageSubresourceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO });
    vn_encode_VkDeviceImageSubresourceInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceImageSubresourceInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkGetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements_partial(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_encode_vkGetImageMemoryRequirements(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pMemoryRequirements))
        vn_encode_VkMemoryRequirements_partial(enc, pMemoryRequirements);
}

static inline size_t vn_sizeof_vkGetImageMemoryRequirements_reply(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip image */
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_decode_vkGetImageMemoryRequirements_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT);

    /* skip device */
    /* skip image */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryRequirements(dec, pMemoryRequirements);
    } else {
        pMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkBindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_VkDeviceMemory(&memory);
    cmd_size += vn_sizeof_VkDeviceSize(&memoryOffset);

    return cmd_size;
}

static inline void vn_encode_vkBindImageMemory(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    vn_encode_VkDeviceMemory(enc, &memory);
    vn_encode_VkDeviceSize(enc, &memoryOffset);
}

static inline size_t vn_sizeof_vkBindImageMemory_reply(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip image */
    /* skip memory */
    /* skip memoryOffset */

    return cmd_size;
}

static inline VkResult vn_decode_vkBindImageMemory_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBindImageMemory_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip image */
    /* skip memory */
    /* skip memoryOffset */

    return ret;
}

static inline size_t vn_sizeof_vkGetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements_partial(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetImageSparseMemoryRequirements(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements_partial(enc, &pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetImageSparseMemoryRequirements_reply(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip image */
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetImageSparseMemoryRequirements_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT);

    /* skip device */
    /* skip image */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pSparseMemoryRequirementCount);
    } else {
        pSparseMemoryRequirementCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements(dec, &pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pSparseMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkCreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkImageCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pImage);
    if (pImage)
        cmd_size += vn_sizeof_VkImage(pImage);

    return cmd_size;
}

static inline void vn_encode_vkCreateImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkImageCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pImage))
        vn_encode_VkImage(enc, pImage);
}

static inline size_t vn_sizeof_vkCreateImage_reply(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pImage);
    if (pImage)
        cmd_size += vn_sizeof_VkImage(pImage);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateImage_reply(struct vn_cs_decoder *dec, VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateImage_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkImage(dec, pImage);
    } else {
        pImage = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyImage_reply(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip image */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyImage_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyImage_EXT);

    /* skip device */
    /* skip image */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkGetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pSubresource);
    if (pSubresource)
        cmd_size += vn_sizeof_VkImageSubresource(pSubresource);
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout_partial(pLayout);

    return cmd_size;
}

static inline void vn_encode_vkGetImageSubresourceLayout(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pSubresource))
        vn_encode_VkImageSubresource(enc, pSubresource);
    if (vn_encode_simple_pointer(enc, pLayout))
        vn_encode_VkSubresourceLayout_partial(enc, pLayout);
}

static inline size_t vn_sizeof_vkGetImageSubresourceLayout_reply(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip image */
    /* skip pSubresource */
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout(pLayout);

    return cmd_size;
}

static inline void vn_decode_vkGetImageSubresourceLayout_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT);

    /* skip device */
    /* skip image */
    /* skip pSubresource */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkSubresourceLayout(dec, pLayout);
    } else {
        pLayout = NULL;
    }
}

static inline size_t vn_sizeof_vkBindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&bindInfoCount);
    if (pBindInfos) {
        cmd_size += vn_sizeof_array_size(bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; i++)
            cmd_size += vn_sizeof_VkBindImageMemoryInfo(&pBindInfos[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkBindImageMemory2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &bindInfoCount);
    if (pBindInfos) {
        vn_encode_array_size(enc, bindInfoCount);
        for (uint32_t i = 0; i < bindInfoCount; i++)
            vn_encode_VkBindImageMemoryInfo(enc, &pBindInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkBindImageMemory2_reply(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBindImageMemory2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip bindInfoCount */
    /* skip pBindInfos */

    return cmd_size;
}

static inline VkResult vn_decode_vkBindImageMemory2_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBindImageMemory2_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip bindInfoCount */
    /* skip pBindInfos */

    return ret;
}

static inline size_t vn_sizeof_vkGetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkImageMemoryRequirementsInfo2(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2_partial(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_encode_vkGetImageMemoryRequirements2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkImageMemoryRequirementsInfo2(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pMemoryRequirements))
        vn_encode_VkMemoryRequirements2_partial(enc, pMemoryRequirements);
}

static inline size_t vn_sizeof_vkGetImageMemoryRequirements2_reply(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_decode_vkGetImageMemoryRequirements2_reply(struct vn_cs_decoder *dec, VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryRequirements2(dec, pMemoryRequirements);
    } else {
        pMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkGetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkImageSparseMemoryRequirementsInfo2(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements2_partial(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetImageSparseMemoryRequirements2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkImageSparseMemoryRequirementsInfo2(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements2_partial(enc, &pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetImageSparseMemoryRequirements2_reply(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements2(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetImageSparseMemoryRequirements2_reply(struct vn_cs_decoder *dec, VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pSparseMemoryRequirementCount);
    } else {
        pSparseMemoryRequirementCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements2(dec, &pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pSparseMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkGetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkDeviceImageMemoryRequirements(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2_partial(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceImageMemoryRequirements(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkDeviceImageMemoryRequirements(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pMemoryRequirements))
        vn_encode_VkMemoryRequirements2_partial(enc, pMemoryRequirements);
}

static inline size_t vn_sizeof_vkGetDeviceImageMemoryRequirements_reply(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pMemoryRequirements);
    if (pMemoryRequirements)
        cmd_size += vn_sizeof_VkMemoryRequirements2(pMemoryRequirements);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceImageMemoryRequirements_reply(struct vn_cs_decoder *dec, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryRequirements2(dec, pMemoryRequirements);
    } else {
        pMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkGetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkDeviceImageMemoryRequirements(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements2_partial(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceImageSparseMemoryRequirements(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkDeviceImageMemoryRequirements(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements2_partial(enc, &pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetDeviceImageSparseMemoryRequirements_reply(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirementCount)
        cmd_size += vn_sizeof_uint32_t(pSparseMemoryRequirementCount);
    if (pSparseMemoryRequirements) {
        cmd_size += vn_sizeof_array_size((pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageMemoryRequirements2(&pSparseMemoryRequirements[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceImageSparseMemoryRequirements_reply(struct vn_cs_decoder *dec, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pSparseMemoryRequirementCount);
    } else {
        pSparseMemoryRequirementCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pSparseMemoryRequirementCount ? *pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements2(dec, &pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pSparseMemoryRequirements = NULL;
    }
}

static inline size_t vn_sizeof_vkGetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT_partial(pProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetImageDrmFormatModifierPropertiesEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pProperties))
        vn_encode_VkImageDrmFormatModifierPropertiesEXT_partial(enc, pProperties);
}

static inline size_t vn_sizeof_vkGetImageDrmFormatModifierPropertiesEXT_reply(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip image */
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkImageDrmFormatModifierPropertiesEXT(pProperties);

    return cmd_size;
}

static inline VkResult vn_decode_vkGetImageDrmFormatModifierPropertiesEXT_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip image */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkImageDrmFormatModifierPropertiesEXT(dec, pProperties);
    } else {
        pProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_simple_pointer(pSubresource);
    if (pSubresource)
        cmd_size += vn_sizeof_VkImageSubresource2(pSubresource);
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout2_partial(pLayout);

    return cmd_size;
}

static inline void vn_encode_vkGetImageSubresourceLayout2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkImage(enc, &image);
    if (vn_encode_simple_pointer(enc, pSubresource))
        vn_encode_VkImageSubresource2(enc, pSubresource);
    if (vn_encode_simple_pointer(enc, pLayout))
        vn_encode_VkSubresourceLayout2_partial(enc, pLayout);
}

static inline size_t vn_sizeof_vkGetImageSubresourceLayout2_reply(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageSubresourceLayout2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip image */
    /* skip pSubresource */
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout2(pLayout);

    return cmd_size;
}

static inline void vn_decode_vkGetImageSubresourceLayout2_reply(struct vn_cs_decoder *dec, VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageSubresourceLayout2_EXT);

    /* skip device */
    /* skip image */
    /* skip pSubresource */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkSubresourceLayout2(dec, pLayout);
    } else {
        pLayout = NULL;
    }
}

static inline size_t vn_sizeof_vkGetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSubresourceLayout_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkDeviceImageSubresourceInfo(pInfo);
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout2_partial(pLayout);

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceImageSubresourceLayout(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSubresourceLayout_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkDeviceImageSubresourceInfo(enc, pInfo);
    if (vn_encode_simple_pointer(enc, pLayout))
        vn_encode_VkSubresourceLayout2_partial(enc, pLayout);
}

static inline size_t vn_sizeof_vkGetDeviceImageSubresourceLayout_reply(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceImageSubresourceLayout_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pInfo */
    cmd_size += vn_sizeof_simple_pointer(pLayout);
    if (pLayout)
        cmd_size += vn_sizeof_VkSubresourceLayout2(pLayout);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceImageSubresourceLayout_reply(struct vn_cs_decoder *dec, VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceImageSubresourceLayout_EXT);

    /* skip device */
    /* skip pInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkSubresourceLayout2(dec, pLayout);
    } else {
        pLayout = NULL;
    }
}

static inline void vn_submit_vkGetImageMemoryRequirements(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageMemoryRequirements(device, image, pMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageMemoryRequirements_reply(device, image, pMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageMemoryRequirements(enc, cmd_flags, device, image, pMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkBindImageMemory(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBindImageMemory(device, image, memory, memoryOffset);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBindImageMemory_reply(device, image, memory, memoryOffset) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkBindImageMemory(enc, cmd_flags, device, image, memory, memoryOffset);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageSparseMemoryRequirements_reply(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageSparseMemoryRequirements(enc, cmd_flags, device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCreateImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateImage(device, pCreateInfo, pAllocator, pImage);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateImage_reply(device, pCreateInfo, pAllocator, pImage) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateImage(enc, cmd_flags, device, pCreateInfo, pAllocator, pImage);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyImage(device, image, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyImage_reply(device, image, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyImage(enc, cmd_flags, device, image, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageSubresourceLayout(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageSubresourceLayout(device, image, pSubresource, pLayout);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageSubresourceLayout_reply(device, image, pSubresource, pLayout) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageSubresourceLayout(enc, cmd_flags, device, image, pSubresource, pLayout);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkBindImageMemory2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBindImageMemory2(device, bindInfoCount, pBindInfos);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBindImageMemory2_reply(device, bindInfoCount, pBindInfos) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkBindImageMemory2(enc, cmd_flags, device, bindInfoCount, pBindInfos);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageMemoryRequirements2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageMemoryRequirements2_reply(device, pInfo, pMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageMemoryRequirements2(enc, cmd_flags, device, pInfo, pMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageSparseMemoryRequirements2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageSparseMemoryRequirements2_reply(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageSparseMemoryRequirements2(enc, cmd_flags, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceImageMemoryRequirements(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceImageMemoryRequirements_reply(device, pInfo, pMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceImageMemoryRequirements(enc, cmd_flags, device, pInfo, pMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceImageSparseMemoryRequirements_reply(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceImageSparseMemoryRequirements(enc, cmd_flags, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageDrmFormatModifierPropertiesEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageDrmFormatModifierPropertiesEXT_reply(device, image, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageDrmFormatModifierPropertiesEXT(enc, cmd_flags, device, image, pProperties);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageSubresourceLayout2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageSubresourceLayout2(device, image, pSubresource, pLayout);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageSubresourceLayout2_reply(device, image, pSubresource, pLayout) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageSubresourceLayout2(enc, cmd_flags, device, image, pSubresource, pLayout);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceImageSubresourceLayout(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceImageSubresourceLayout(device, pInfo, pLayout);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceImageSubresourceLayout_reply(device, pInfo, pLayout) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceImageSubresourceLayout(enc, cmd_flags, device, pInfo, pLayout);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_call_vkGetImageMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageMemoryRequirements(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, pMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageMemoryRequirements_reply(dec, device, image, pMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageMemoryRequirements(vn_ring, 0, device, image, pMemoryRequirements, &submit);
}

static inline VkResult vn_call_vkBindImageMemory(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkBindImageMemory(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, memory, memoryOffset, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkBindImageMemory_reply(dec, device, image, memory, memoryOffset);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBindImageMemory(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkBindImageMemory(vn_ring, 0, device, image, memory, memoryOffset, &submit);
}

static inline void vn_call_vkGetImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSparseMemoryRequirements(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageSparseMemoryRequirements_reply(dec, device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSparseMemoryRequirements(vn_ring, 0, device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
}

static inline VkResult vn_call_vkCreateImage(struct vn_ring *vn_ring, VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pImage, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateImage_reply(dec, device, pCreateInfo, pAllocator, pImage);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateImage(struct vn_ring *vn_ring, VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateImage(vn_ring, 0, device, pCreateInfo, pAllocator, pImage, &submit);
}

static inline void vn_async_vkDestroyImage(struct vn_ring *vn_ring, VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyImage(vn_ring, 0, device, image, pAllocator, &submit);
}

static inline void vn_call_vkGetImageSubresourceLayout(struct vn_ring *vn_ring, VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSubresourceLayout(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, pSubresource, pLayout, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageSubresourceLayout_reply(dec, device, image, pSubresource, pLayout);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageSubresourceLayout(struct vn_ring *vn_ring, VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSubresourceLayout(vn_ring, 0, device, image, pSubresource, pLayout, &submit);
}

static inline VkResult vn_call_vkBindImageMemory2(struct vn_ring *vn_ring, VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkBindImageMemory2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, bindInfoCount, pBindInfos, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkBindImageMemory2_reply(dec, device, bindInfoCount, pBindInfos);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBindImageMemory2(struct vn_ring *vn_ring, VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkBindImageMemory2(vn_ring, 0, device, bindInfoCount, pBindInfos, &submit);
}

static inline void vn_call_vkGetImageMemoryRequirements2(struct vn_ring *vn_ring, VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageMemoryRequirements2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageMemoryRequirements2_reply(dec, device, pInfo, pMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageMemoryRequirements2(struct vn_ring *vn_ring, VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageMemoryRequirements2(vn_ring, 0, device, pInfo, pMemoryRequirements, &submit);
}

static inline void vn_call_vkGetImageSparseMemoryRequirements2(struct vn_ring *vn_ring, VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSparseMemoryRequirements2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageSparseMemoryRequirements2_reply(dec, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageSparseMemoryRequirements2(struct vn_ring *vn_ring, VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSparseMemoryRequirements2(vn_ring, 0, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
}

static inline void vn_call_vkGetDeviceImageMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageMemoryRequirements(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetDeviceImageMemoryRequirements_reply(dec, device, pInfo, pMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetDeviceImageMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageMemoryRequirements(vn_ring, 0, device, pInfo, pMemoryRequirements, &submit);
}

static inline void vn_call_vkGetDeviceImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageSparseMemoryRequirements(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetDeviceImageSparseMemoryRequirements_reply(dec, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetDeviceImageSparseMemoryRequirements(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageSparseMemoryRequirements(vn_ring, 0, device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements, &submit);
}

static inline VkResult vn_call_vkGetImageDrmFormatModifierPropertiesEXT(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageDrmFormatModifierPropertiesEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetImageDrmFormatModifierPropertiesEXT_reply(dec, device, image, pProperties);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetImageDrmFormatModifierPropertiesEXT(struct vn_ring *vn_ring, VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageDrmFormatModifierPropertiesEXT(vn_ring, 0, device, image, pProperties, &submit);
}

static inline void vn_call_vkGetImageSubresourceLayout2(struct vn_ring *vn_ring, VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSubresourceLayout2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, image, pSubresource, pLayout, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetImageSubresourceLayout2_reply(dec, device, image, pSubresource, pLayout);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetImageSubresourceLayout2(struct vn_ring *vn_ring, VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageSubresourceLayout2(vn_ring, 0, device, image, pSubresource, pLayout, &submit);
}

static inline void vn_call_vkGetDeviceImageSubresourceLayout(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageSubresourceLayout(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, pLayout, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetDeviceImageSubresourceLayout_reply(dec, device, pInfo, pLayout);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetDeviceImageSubresourceLayout(struct vn_ring *vn_ring, VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceImageSubresourceLayout(vn_ring, 0, device, pInfo, pLayout, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_IMAGE_H */
