// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +f8f32mm -target-feature +sme -target-feature +sve -target-feature +sve2 -verify=guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve2,f8f32mm" streaming_guard="" flags=""

void test(void) {
  fpm_t fpm_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  svmmla_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  svmmla_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
}

void test_streaming(void) __arm_streaming{
  fpm_t fpm_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  fpm_t fpm_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
}
