/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaSet* all_basic_blocks;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};

static gint ValaFlowAnalyzer_private_offset;
static gpointer vala_flow_analyzer_parent_class = NULL;
static gint ValaFlowAnalyzerJumpTarget_private_offset;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void vala_flow_analyzer_value_set_jump_target (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void vala_flow_analyzer_value_take_jump_target (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED ;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                           ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                         ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                          ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                      ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                           ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                          ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                           ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                                                    ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                                                  ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                      ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                                   ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                                  ValaList* block_list,
                                                  ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                              ValaBasicBlock* current,
                                              ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                                              ValaBasicBlock** idoms,
                                              gint idoms_length1,
                                              ValaBasicBlock* b1,
                                              ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                                ValaList* block_list,
                                                ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                               ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                                     ValaMap* var_map,
                                                     ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                                    ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                             ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                      ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                          ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                          ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                         ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                       ValaCodeNode* node,
                                       gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                                   ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                         ValaExpressionStatement* stmt);
static void vala_flow_analyzer_real_visit_with_statement (ValaCodeVisitor* base,
                                                   ValaWithStatement* stmt);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                                 ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                     ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void vala_flow_analyzer_real_visit_loop_statement (ValaCodeVisitor* base,
                                                   ValaLoopStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                                                      ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                      ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                                    ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                       ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                     ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                                    ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                                                 ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                                               ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                                                     ValaBasicBlock* basic_block,
                                                                                     ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                                             ValaCatchClause* catch_clause,
                                                                             ValaErrorDomain* error_domain,
                                                                             ValaErrorCode* error_code,
                                                                             ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block,
                                                                                   ValaCatchClause* catch_clause,
                                                                                   ValaErrorDomain* error_domain,
                                                                                   ValaErrorCode* error_code,
                                                                                   ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                                   ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                     ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                               ValaExpression* expr);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                            gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                          gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                        gboolean value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                           gboolean value);
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaCatchClause* value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static GType vala_flow_analyzer_jump_target_get_type_once (void);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static GType vala_flow_analyzer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
vala_flow_analyzer_get_instance_private (ValaFlowAnalyzer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzer_private_offset);
}

ValaFlowAnalyzer*
vala_flow_analyzer_construct (GType object_type)
{
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}

ValaFlowAnalyzer*
vala_flow_analyzer_new (void)
{
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}

/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_flow_analyzer_analyze (ValaFlowAnalyzer* self,
                            ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	ValaList* source_files = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_, _tmp2_);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = (ValaSet*) _tmp3_;
	_tmp4_ = vala_code_context_get_source_files (context);
	_tmp5_ = _vala_iterable_ref0 (_tmp4_);
	source_files = _tmp5_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp6_;
		gint _file_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _file_index = 0;
		_tmp6_ = source_files;
		_file_list = _tmp6_;
		_tmp7_ = _file_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_file_size = _tmp9_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaSourceFile* _tmp14_;
			_file_index = _file_index + 1;
			_tmp10_ = _file_index;
			_tmp11_ = _file_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _file_list;
			_tmp13_ = vala_list_get (_tmp12_, _file_index);
			file = (ValaSourceFile*) _tmp13_;
			_tmp14_ = file;
			vala_source_file_accept (_tmp14_, (ValaCodeVisitor*) self);
			_vala_source_file_unref0 (file);
		}
	}
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = NULL;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_iterable_unref0 (source_files);
}

static void
vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                           ValaSourceFile* source_file)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                      ValaStruct* st)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                    ValaEnum* en)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* ed)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                     ValaField* f)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_used ((ValaSymbol*) f);
		_tmp3_ = _tmp2_;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_symbol_get_external_package ((ValaSymbol*) f);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp6_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			gboolean _tmp7_ = FALSE;
			ValaCodeContext* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_internal_header_filename (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaCodeContext* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = self->priv->context;
				_tmp12_ = vala_code_context_get_use_fast_vapi (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			_tmp6_ = _tmp7_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
		} else {
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_symbol_get_full_name ((ValaSymbol*) f);
			_tmp17_ = _tmp16_;
			vala_report_warning (_tmp15_, "Field `%s' never used", _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
}

static gpointer
_vala_basic_block_ref0 (gpointer self)
{
	return self ? vala_basic_block_ref (self) : NULL;
}

static void
vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                 ValaLambdaExpression* le)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaList* _tmp7_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	old_unreachable_reported = self->priv->unreachable_reported;
	_tmp2_ = self->priv->jump_stack;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	old_jump_stack = _tmp3_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp5_;
	vala_code_node_accept_children ((ValaCodeNode*) le, (ValaCodeVisitor*) self);
	_tmp6_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp6_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp7_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp7_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}

static void
vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                      ValaMethod* m)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = vala_symbol_get_used ((ValaSymbol*) m);
		_tmp7_ = _tmp6_;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = vala_method_get_entry_point (m);
		_tmp9_ = _tmp8_;
		_tmp4_ = !_tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = vala_symbol_get_external_package ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp3_ = !_tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = vala_method_get_overrides (m);
		_tmp13_ = _tmp12_;
		_tmp2_ = !_tmp13_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp14_ = FALSE;
		ValaMethod* _tmp15_;
		ValaMethod* _tmp16_;
		_tmp15_ = vala_method_get_base_interface_method (m);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			_tmp17_ = vala_method_get_base_interface_method (m);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == m;
		}
		_tmp1_ = _tmp14_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp19_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			gboolean _tmp20_ = FALSE;
			ValaCodeContext* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = self->priv->context;
			_tmp22_ = vala_code_context_get_internal_header_filename (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ != NULL) {
				_tmp20_ = TRUE;
			} else {
				ValaCodeContext* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = self->priv->context;
				_tmp25_ = vala_code_context_get_use_fast_vapi (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = _tmp26_;
			}
			_tmp19_ = _tmp20_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			ValaSymbol* _tmp29_;
			ValaSymbol* _tmp30_;
			_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp30_ = _tmp29_;
			if (_tmp30_ != NULL) {
				ValaSymbol* _tmp31_;
				ValaSymbol* _tmp32_;
				ValaAttribute* _tmp33_;
				_tmp31_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp32_, "DBus");
				_tmp28_ = _tmp33_ != NULL;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				_tmp27_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "visible", TRUE);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
			} else {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) m);
				_tmp37_ = _tmp36_;
				vala_report_warning (_tmp35_, "Method `%s' never used", _tmp37_);
				_g_free0 (_tmp37_);
			}
		}
	}
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) m);
}

static void
vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                      ValaSignal* sig)
{
	ValaFlowAnalyzer * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_signal_get_default_handler (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_default_handler (sig);
		_tmp3_ = _tmp2_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp3_);
	}
}

static void
vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                     ValaSubroutine* m)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaSet* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaSet* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaSet* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp44_;
	ValaSet* _tmp45_;
	ValaBasicBlock* _tmp46_;
	ValaBasicBlock* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaBasicBlock* _tmp49_;
	ValaBasicBlock* _tmp50_;
	ValaList* _tmp51_;
	ValaBasicBlock* _tmp52_;
	ValaBasicBlock* _tmp53_;
	ValaFlowAnalyzerJumpTarget* _tmp54_;
	ValaFlowAnalyzerJumpTarget* _tmp55_;
	ValaList* _tmp56_;
	ValaBasicBlock* _tmp57_;
	ValaBasicBlock* _tmp58_;
	ValaFlowAnalyzerJumpTarget* _tmp59_;
	ValaFlowAnalyzerJumpTarget* _tmp60_;
	ValaList* _tmp61_;
	ValaList* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gpointer _tmp65_;
	ValaFlowAnalyzerJumpTarget* _tmp66_;
	ValaBasicBlock* _tmp67_;
	ValaBasicBlock* _tmp77_;
	ValaBasicBlock* _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_subroutine_get_body (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = vala_basic_block_new_entry ();
	_tmp3_ = _tmp2_;
	vala_subroutine_set_entry_block (m, _tmp3_);
	_vala_basic_block_unref0 (_tmp3_);
	_tmp4_ = self->priv->all_basic_blocks;
	_tmp5_ = vala_subroutine_get_entry_block (m);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp6_);
	_tmp7_ = vala_basic_block_new ();
	_tmp8_ = _tmp7_;
	vala_subroutine_set_return_block (m, _tmp8_);
	_vala_basic_block_unref0 (_tmp8_);
	_tmp9_ = self->priv->all_basic_blocks;
	_tmp10_ = vala_subroutine_get_return_block (m);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp9_, _tmp11_);
	_tmp12_ = vala_basic_block_new_exit ();
	_tmp13_ = _tmp12_;
	vala_subroutine_set_exit_block (m, _tmp13_);
	_vala_basic_block_unref0 (_tmp13_);
	_tmp14_ = self->priv->all_basic_blocks;
	_tmp15_ = vala_subroutine_get_exit_block (m);
	_tmp16_ = _tmp15_;
	vala_collection_add ((ValaCollection*) _tmp14_, _tmp16_);
	_tmp17_ = vala_subroutine_get_return_block (m);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_subroutine_get_exit_block (m);
	_tmp20_ = _tmp19_;
	vala_basic_block_connect (_tmp18_, _tmp20_);
	if (VALA_IS_METHOD (m)) {
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp21_;
			gint _param_size = 0;
			ValaList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _param_index = 0;
			_tmp21_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_METHOD, ValaMethod));
			_param_list = _tmp21_;
			_tmp22_ = _param_list;
			_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_param_size = _tmp24_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				ValaParameter* param = NULL;
				ValaList* _tmp27_;
				gpointer _tmp28_;
				ValaParameter* _tmp29_;
				ValaParameterDirection _tmp30_;
				ValaParameterDirection _tmp31_;
				_param_index = _param_index + 1;
				_tmp25_ = _param_index;
				_tmp26_ = _param_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = vala_list_get (_tmp27_, _param_index);
				param = (ValaParameter*) _tmp28_;
				_tmp29_ = param;
				_tmp30_ = vala_parameter_get_direction (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					ValaParameter* _tmp35_;
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaMemberAccess* _tmp38_;
					ValaMemberAccess* _tmp39_;
					ValaParameter* _tmp40_;
					ValaBasicBlock* _tmp41_;
					ValaBasicBlock* _tmp42_;
					ValaMemberAccess* _tmp43_;
					_tmp32_ = param;
					_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = param;
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = vala_member_access_new_simple (_tmp34_, _tmp37_);
					param_ma = _tmp38_;
					_tmp39_ = param_ma;
					_tmp40_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp39_, (ValaSymbol*) _tmp40_);
					_tmp41_ = vala_subroutine_get_return_block (m);
					_tmp42_ = _tmp41_;
					_tmp43_ = param_ma;
					vala_basic_block_add_node (_tmp42_, (ValaCodeNode*) _tmp43_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
		}
	}
	_tmp44_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp44_;
	_tmp45_ = self->priv->all_basic_blocks;
	_tmp46_ = self->priv->current_block;
	vala_collection_add ((ValaCollection*) _tmp45_, _tmp46_);
	_tmp47_ = vala_subroutine_get_entry_block (m);
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->current_block;
	vala_basic_block_connect (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp50_, (ValaCodeNode*) m);
	_tmp51_ = self->priv->jump_stack;
	_tmp52_ = vala_subroutine_get_return_block (m);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_flow_analyzer_jump_target_new_return_target (_tmp53_);
	_tmp55_ = _tmp54_;
	vala_collection_add ((ValaCollection*) _tmp51_, _tmp55_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp55_);
	_tmp56_ = self->priv->jump_stack;
	_tmp57_ = vala_subroutine_get_exit_block (m);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp58_);
	_tmp60_ = _tmp59_;
	vala_collection_add ((ValaCollection*) _tmp56_, _tmp60_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp60_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp61_ = self->priv->jump_stack;
	_tmp62_ = self->priv->jump_stack;
	_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_list_remove_at (_tmp61_, _tmp64_ - 1);
	_tmp66_ = (ValaFlowAnalyzerJumpTarget*) _tmp65_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp66_);
	_tmp67_ = self->priv->current_block;
	if (_tmp67_ != NULL) {
		gboolean _tmp68_;
		gboolean _tmp69_;
		ValaBasicBlock* _tmp72_;
		ValaBasicBlock* _tmp73_;
		ValaBasicBlock* _tmp74_;
		_tmp68_ = vala_subroutine_get_has_result (m);
		_tmp69_ = _tmp68_;
		if (_tmp69_) {
			ValaSourceReference* _tmp70_;
			ValaSourceReference* _tmp71_;
			_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp71_ = _tmp70_;
			vala_report_error (_tmp71_, "missing return statement at end of subroutine body");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		}
		_tmp72_ = self->priv->current_block;
		_tmp73_ = vala_subroutine_get_return_block (m);
		_tmp74_ = _tmp73_;
		vala_basic_block_connect (_tmp72_, _tmp74_);
	} else {
		ValaBlock* _tmp75_;
		ValaBlock* _tmp76_;
		_tmp75_ = vala_subroutine_get_body (m);
		_tmp76_ = _tmp75_;
		vala_block_set_unreachable_exit (_tmp76_, TRUE);
	}
	_tmp77_ = vala_subroutine_get_entry_block (m);
	_tmp78_ = _tmp77_;
	vala_flow_analyzer_analyze_body (self, _tmp78_);
}

static void
vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                 ValaBasicBlock* entry_block)
{
	ValaList* block_list = NULL;
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_depth_first_list (self, entry_block);
	block_list = _tmp0_;
	vala_flow_analyzer_build_dominator_tree (self, block_list, entry_block);
	vala_flow_analyzer_build_dominator_frontier (self, block_list, entry_block);
	vala_flow_analyzer_insert_phi_functions (self, block_list, entry_block);
	vala_flow_analyzer_check_variables (self, entry_block);
	_vala_iterable_unref0 (block_list);
}

static ValaList*
vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block)
{
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	vala_flow_analyzer_depth_first_traverse (self, entry_block, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}

static void
vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* current,
                                         ValaList* list)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_basic_block_get_postorder_visited (current);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_basic_block_set_postorder_visited (current, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp2_;
		gint _succ_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _succ_index = 0;
		_tmp2_ = vala_basic_block_get_successors (current);
		_succ_list = _tmp2_;
		_tmp3_ = _succ_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_succ_size = _tmp5_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaBasicBlock* _tmp10_;
			_succ_index = _succ_index + 1;
			_tmp6_ = _succ_index;
			_tmp7_ = _succ_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _succ_list;
			_tmp9_ = vala_list_get (_tmp8_, _succ_index);
			succ = (ValaBasicBlock*) _tmp9_;
			_tmp10_ = succ;
			vala_flow_analyzer_depth_first_traverse (self, _tmp10_, list);
		}
	}
	_tmp11_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp12_ = _tmp11_;
	vala_basic_block_set_postorder_number (current, _tmp12_);
	vala_list_insert (list, 0, current);
}

static void
vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaBasicBlock** idoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ValaBasicBlock** _tmp2_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	ValaBasicBlock* _tmp6_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (ValaBasicBlock*, _tmp1_ + 1);
	idoms = _tmp2_;
	idoms_length1 = _tmp1_;
	_idoms_size_ = idoms_length1;
	_tmp3_ = idoms;
	_tmp3__length1 = idoms_length1;
	_tmp4_ = vala_basic_block_get_postorder_number (entry_block);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_basic_block_ref0 (entry_block);
	_vala_basic_block_unref0 (_tmp3_[_tmp5_]);
	_tmp3_[_tmp5_] = _tmp6_;
	changed = TRUE;
	while (TRUE) {
		if (!changed) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			gint _block_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _block_index = 0;
			_block_list = block_list;
			_tmp7_ = _block_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_block_size = _tmp9_;
			_block_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp12_;
				gpointer _tmp13_;
				ValaBasicBlock* _tmp14_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp35_;
				gint _tmp35__length1;
				ValaBasicBlock* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				ValaBasicBlock* _tmp39_;
				ValaBasicBlock* _tmp40_;
				_block_index = _block_index + 1;
				_tmp10_ = _block_index;
				_tmp11_ = _block_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _block_list;
				_tmp13_ = vala_list_get (_tmp12_, _block_index);
				block = (ValaBasicBlock*) _tmp13_;
				_tmp14_ = block;
				if (_tmp14_ == entry_block) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp15_;
					ValaList* _tmp16_;
					gint _pred_size = 0;
					ValaList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _pred_index = 0;
					_tmp15_ = block;
					_tmp16_ = vala_basic_block_get_predecessors (_tmp15_);
					_pred_list = _tmp16_;
					_tmp17_ = _pred_list;
					_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					_pred_size = _tmp19_;
					_pred_index = -1;
					while (TRUE) {
						gint _tmp20_;
						gint _tmp21_;
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp22_;
						gpointer _tmp23_;
						ValaBasicBlock** _tmp24_;
						gint _tmp24__length1;
						ValaBasicBlock* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						ValaBasicBlock* _tmp28_;
						_pred_index = _pred_index + 1;
						_tmp20_ = _pred_index;
						_tmp21_ = _pred_size;
						if (!(_tmp20_ < _tmp21_)) {
							break;
						}
						_tmp22_ = _pred_list;
						_tmp23_ = vala_list_get (_tmp22_, _pred_index);
						pred = (ValaBasicBlock*) _tmp23_;
						_tmp24_ = idoms;
						_tmp24__length1 = idoms_length1;
						_tmp25_ = pred;
						_tmp26_ = vala_basic_block_get_postorder_number (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = _tmp24_[_tmp27_];
						if (_tmp28_ != NULL) {
							if (first) {
								ValaBasicBlock* _tmp29_;
								ValaBasicBlock* _tmp30_;
								_tmp29_ = pred;
								_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp30_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp31_;
								gint _tmp31__length1;
								ValaBasicBlock* _tmp32_;
								ValaBasicBlock* _tmp33_;
								ValaBasicBlock* _tmp34_;
								_tmp31_ = idoms;
								_tmp31__length1 = idoms_length1;
								_tmp32_ = pred;
								_tmp33_ = new_idom;
								_tmp34_ = vala_flow_analyzer_intersect (self, _tmp31_, (gint) _tmp31__length1, _tmp32_, _tmp33_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp34_;
							}
						}
					}
				}
				_tmp35_ = idoms;
				_tmp35__length1 = idoms_length1;
				_tmp36_ = block;
				_tmp37_ = vala_basic_block_get_postorder_number (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp35_[_tmp38_];
				_tmp40_ = new_idom;
				if (_tmp39_ != _tmp40_) {
					ValaBasicBlock** _tmp41_;
					gint _tmp41__length1;
					ValaBasicBlock* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					ValaBasicBlock* _tmp45_;
					ValaBasicBlock* _tmp46_;
					_tmp41_ = idoms;
					_tmp41__length1 = idoms_length1;
					_tmp42_ = block;
					_tmp43_ = vala_basic_block_get_postorder_number (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = new_idom;
					_tmp46_ = _vala_basic_block_ref0 (_tmp45_);
					_vala_basic_block_unref0 (_tmp41_[_tmp44_]);
					_tmp41_[_tmp44_] = _tmp46_;
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
		}
	}
	{
		ValaList* _block_list = NULL;
		gint _block_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _block_index = 0;
		_block_list = block_list;
		_tmp47_ = _block_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_block_size = _tmp49_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp52_;
			gpointer _tmp53_;
			ValaBasicBlock* _tmp54_;
			ValaBasicBlock** _tmp55_;
			gint _tmp55__length1;
			ValaBasicBlock* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaBasicBlock* _tmp59_;
			ValaBasicBlock* _tmp60_;
			_block_index = _block_index + 1;
			_tmp50_ = _block_index;
			_tmp51_ = _block_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _block_list;
			_tmp53_ = vala_list_get (_tmp52_, _block_index);
			block = (ValaBasicBlock*) _tmp53_;
			_tmp54_ = block;
			if (_tmp54_ == entry_block) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp55_ = idoms;
			_tmp55__length1 = idoms_length1;
			_tmp56_ = block;
			_tmp57_ = vala_basic_block_get_postorder_number (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = _tmp55_[_tmp58_];
			_tmp60_ = block;
			vala_basic_block_add_child (_tmp59_, _tmp60_);
			_vala_basic_block_unref0 (block);
		}
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}

static ValaBasicBlock*
vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                              ValaBasicBlock** idoms,
                              gint idoms_length1,
                              ValaBasicBlock* b1,
                              ValaBasicBlock* b2)
{
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		if (!(b1 != b2)) {
			break;
		}
		while (TRUE) {
			gint _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			ValaBasicBlock* _tmp6_;
			_tmp0_ = vala_basic_block_get_postorder_number (b1);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_basic_block_get_postorder_number (b2);
			_tmp3_ = _tmp2_;
			if (!(_tmp1_ < _tmp3_)) {
				break;
			}
			_tmp4_ = vala_basic_block_get_postorder_number (b2);
			_tmp5_ = _tmp4_;
			_tmp6_ = idoms[_tmp5_];
			b1 = _tmp6_;
		}
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp7_ = vala_basic_block_get_postorder_number (b2);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_basic_block_get_postorder_number (b1);
			_tmp10_ = _tmp9_;
			if (!(_tmp8_ < _tmp10_)) {
				break;
			}
			_tmp11_ = vala_basic_block_get_postorder_number (b2);
			_tmp12_ = _tmp11_;
			_tmp13_ = idoms[_tmp12_];
			b2 = _tmp13_;
		}
	}
	_tmp14_ = _vala_basic_block_ref0 (b1);
	result = _tmp14_;
	return result;
}

static void
vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                             ValaList* block_list,
                                             ValaBasicBlock* entry_block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaBasicBlock* block = NULL;
				gpointer _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp4_ = vala_list_get (block_list, i);
				block = (ValaBasicBlock*) _tmp4_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp5_;
					ValaList* _tmp6_;
					gint _succ_size = 0;
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gint _succ_index = 0;
					_tmp5_ = block;
					_tmp6_ = vala_basic_block_get_successors (_tmp5_);
					_succ_list = _tmp6_;
					_tmp7_ = _succ_list;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					_succ_size = _tmp9_;
					_succ_index = -1;
					while (TRUE) {
						gint _tmp10_;
						gint _tmp11_;
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp12_;
						gpointer _tmp13_;
						ValaBasicBlock* _tmp14_;
						ValaBasicBlock* _tmp15_;
						ValaBasicBlock* _tmp16_;
						ValaBasicBlock* _tmp17_;
						_succ_index = _succ_index + 1;
						_tmp10_ = _succ_index;
						_tmp11_ = _succ_size;
						if (!(_tmp10_ < _tmp11_)) {
							break;
						}
						_tmp12_ = _succ_list;
						_tmp13_ = vala_list_get (_tmp12_, _succ_index);
						succ = (ValaBasicBlock*) _tmp13_;
						_tmp14_ = succ;
						_tmp15_ = vala_basic_block_get_parent (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = block;
						if (_tmp16_ != _tmp17_) {
							ValaBasicBlock* _tmp18_;
							ValaBasicBlock* _tmp19_;
							_tmp18_ = block;
							_tmp19_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp18_, _tmp19_);
						}
					}
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp20_;
					ValaList* _tmp21_;
					gint _child_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _child_index = 0;
					_tmp20_ = block;
					_tmp21_ = vala_basic_block_get_children (_tmp20_);
					_child_list = _tmp21_;
					_tmp22_ = _child_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_child_size = _tmp24_;
					_child_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						ValaBasicBlock* child = NULL;
						ValaList* _tmp27_;
						gpointer _tmp28_;
						_child_index = _child_index + 1;
						_tmp25_ = _child_index;
						_tmp26_ = _child_size;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = _child_list;
						_tmp28_ = vala_list_get (_tmp27_, _child_index);
						child = (ValaBasicBlock*) _tmp28_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp29_;
							ValaSet* _tmp30_;
							ValaIterator* _tmp31_;
							_tmp29_ = child;
							_tmp30_ = vala_basic_block_get_dominator_frontier (_tmp29_);
							_tmp31_ = vala_iterable_iterator ((ValaIterable*) _tmp30_);
							_child_frontier_it = _tmp31_;
							while (TRUE) {
								ValaIterator* _tmp32_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp33_;
								gpointer _tmp34_;
								ValaBasicBlock* _tmp35_;
								ValaBasicBlock* _tmp36_;
								ValaBasicBlock* _tmp37_;
								ValaBasicBlock* _tmp38_;
								_tmp32_ = _child_frontier_it;
								if (!vala_iterator_next (_tmp32_)) {
									break;
								}
								_tmp33_ = _child_frontier_it;
								_tmp34_ = vala_iterator_get (_tmp33_);
								child_frontier = (ValaBasicBlock*) _tmp34_;
								_tmp35_ = child_frontier;
								_tmp36_ = vala_basic_block_get_parent (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = block;
								if (_tmp37_ != _tmp38_) {
									ValaBasicBlock* _tmp39_;
									ValaBasicBlock* _tmp40_;
									_tmp39_ = block;
									_tmp40_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp39_, _tmp40_);
								}
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
					}
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}

static ValaMap*
vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                       ValaList* block_list,
                                       ValaBasicBlock* entry_block)
{
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		gint _block_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _block_index = 0;
		_block_list = block_list;
		_tmp4_ = _block_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_block_size = _tmp6_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp11_;
			ValaArrayList* _tmp12_;
			_block_index = _block_index + 1;
			_tmp7_ = _block_index;
			_tmp8_ = _block_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _block_list;
			_tmp10_ = vala_list_get (_tmp9_, _block_index);
			block = (ValaBasicBlock*) _tmp10_;
			_tmp11_ = g_direct_equal;
			_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
			defined_variables = _tmp12_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp13_;
				ValaList* _tmp14_;
				gint _node_size = 0;
				ValaList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _node_index = 0;
				_tmp13_ = block;
				_tmp14_ = vala_basic_block_get_nodes (_tmp13_);
				_node_list = _tmp14_;
				_tmp15_ = _node_list;
				_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				_node_size = _tmp17_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp18_;
					gint _tmp19_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp20_;
					gpointer _tmp21_;
					ValaCodeNode* _tmp22_;
					ValaArrayList* _tmp23_;
					_node_index = _node_index + 1;
					_tmp18_ = _node_index;
					_tmp19_ = _node_size;
					if (!(_tmp18_ < _tmp19_)) {
						break;
					}
					_tmp20_ = _node_list;
					_tmp21_ = vala_list_get (_tmp20_, _node_index);
					node = (ValaCodeNode*) _tmp21_;
					_tmp22_ = node;
					_tmp23_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp22_, (ValaCollection*) _tmp23_);
					_vala_code_node_unref0 (node);
				}
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp24_;
				gint _variable_size = 0;
				ValaArrayList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _variable_index = 0;
				_tmp24_ = defined_variables;
				_variable_list = _tmp24_;
				_tmp25_ = _variable_list;
				_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_variable_size = _tmp27_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp28_;
					gint _tmp29_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp30_;
					gpointer _tmp31_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp32_;
					ValaVariable* _tmp33_;
					gpointer _tmp34_;
					ValaSet* _tmp35_;
					ValaSet* _tmp42_;
					ValaBasicBlock* _tmp43_;
					_variable_index = _variable_index + 1;
					_tmp28_ = _variable_index;
					_tmp29_ = _variable_size;
					if (!(_tmp28_ < _tmp29_)) {
						break;
					}
					_tmp30_ = _variable_list;
					_tmp31_ = vala_list_get ((ValaList*) _tmp30_, _variable_index);
					variable = (ValaVariable*) _tmp31_;
					_tmp32_ = map;
					_tmp33_ = variable;
					_tmp34_ = vala_map_get ((ValaMap*) _tmp32_, _tmp33_);
					block_set = (ValaSet*) _tmp34_;
					_tmp35_ = block_set;
					if (_tmp35_ == NULL) {
						GHashFunc _tmp36_;
						GEqualFunc _tmp37_;
						ValaHashSet* _tmp38_;
						ValaHashMap* _tmp39_;
						ValaVariable* _tmp40_;
						ValaSet* _tmp41_;
						_tmp36_ = g_direct_hash;
						_tmp37_ = g_direct_equal;
						_tmp38_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp36_, _tmp37_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp38_;
						_tmp39_ = map;
						_tmp40_ = variable;
						_tmp41_ = block_set;
						vala_map_set ((ValaMap*) _tmp39_, _tmp40_, _tmp41_);
					}
					_tmp42_ = block_set;
					_tmp43_ = block;
					vala_collection_add ((ValaCollection*) _tmp42_, _tmp43_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
	}
	result = (ValaMap*) map;
	return result;
}

static void
vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaMap* assign = NULL;
	ValaMap* _tmp0_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_assignment_map (self, block_list, entry_block);
	assign = _tmp0_;
	counter = 0;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_);
	work_list = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp3_, _tmp4_, _tmp5_);
	added = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp7_, _tmp8_, _tmp9_);
	phi = _tmp10_;
	{
		ValaList* _block_list = NULL;
		gint _block_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _block_index = 0;
		_block_list = block_list;
		_tmp11_ = _block_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_block_size = _tmp13_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaHashMap* _tmp18_;
			ValaBasicBlock* _tmp19_;
			ValaHashMap* _tmp20_;
			ValaBasicBlock* _tmp21_;
			_block_index = _block_index + 1;
			_tmp14_ = _block_index;
			_tmp15_ = _block_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _block_list;
			_tmp17_ = vala_list_get (_tmp16_, _block_index);
			block = (ValaBasicBlock*) _tmp17_;
			_tmp18_ = added;
			_tmp19_ = block;
			vala_map_set ((ValaMap*) _tmp18_, _tmp19_, (gpointer) ((gintptr) 0));
			_tmp20_ = phi;
			_tmp21_ = block;
			vala_map_set ((ValaMap*) _tmp20_, _tmp21_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp22_;
		ValaSet* _tmp23_;
		ValaSet* _tmp24_;
		ValaIterator* _tmp25_;
		ValaIterator* _tmp26_;
		_tmp22_ = assign;
		_tmp23_ = vala_map_get_keys (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_iterable_iterator ((ValaIterable*) _tmp24_);
		_tmp26_ = _tmp25_;
		_vala_iterable_unref0 (_tmp24_);
		_variable_it = _tmp26_;
		while (TRUE) {
			ValaIterator* _tmp27_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp28_;
			gpointer _tmp29_;
			gint _tmp30_;
			_tmp27_ = _variable_it;
			if (!vala_iterator_next (_tmp27_)) {
				break;
			}
			_tmp28_ = _variable_it;
			_tmp29_ = vala_iterator_get (_tmp28_);
			variable = (ValaVariable*) _tmp29_;
			_tmp30_ = counter;
			counter = _tmp30_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp31_;
				ValaVariable* _tmp32_;
				gpointer _tmp33_;
				ValaSet* _tmp34_;
				ValaIterator* _tmp35_;
				ValaIterator* _tmp36_;
				_tmp31_ = assign;
				_tmp32_ = variable;
				_tmp33_ = vala_map_get (_tmp31_, _tmp32_);
				_tmp34_ = (ValaSet*) _tmp33_;
				_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
				_tmp36_ = _tmp35_;
				_vala_iterable_unref0 (_tmp34_);
				_block_it = _tmp36_;
				while (TRUE) {
					ValaIterator* _tmp37_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp38_;
					gpointer _tmp39_;
					ValaArrayList* _tmp40_;
					ValaBasicBlock* _tmp41_;
					ValaHashMap* _tmp42_;
					ValaBasicBlock* _tmp43_;
					_tmp37_ = _block_it;
					if (!vala_iterator_next (_tmp37_)) {
						break;
					}
					_tmp38_ = _block_it;
					_tmp39_ = vala_iterator_get (_tmp38_);
					block = (ValaBasicBlock*) _tmp39_;
					_tmp40_ = work_list;
					_tmp41_ = block;
					vala_collection_add ((ValaCollection*) _tmp40_, _tmp41_);
					_tmp42_ = added;
					_tmp43_ = block;
					vala_map_set ((ValaMap*) _tmp42_, _tmp43_, (gpointer) ((gintptr) counter));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp47_;
				gpointer _tmp48_;
				_tmp44_ = work_list;
				_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				if (!(_tmp46_ > 0)) {
					break;
				}
				_tmp47_ = work_list;
				_tmp48_ = vala_list_remove_at ((ValaList*) _tmp47_, 0);
				block = (ValaBasicBlock*) _tmp48_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp49_;
					ValaSet* _tmp50_;
					ValaIterator* _tmp51_;
					_tmp49_ = block;
					_tmp50_ = vala_basic_block_get_dominator_frontier (_tmp49_);
					_tmp51_ = vala_iterable_iterator ((ValaIterable*) _tmp50_);
					_frontier_it = _tmp51_;
					while (TRUE) {
						ValaIterator* _tmp52_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp53_;
						gpointer _tmp54_;
						ValaBasicBlock* _tmp55_;
						gint blockPhi = 0;
						ValaHashMap* _tmp56_;
						ValaBasicBlock* _tmp57_;
						gpointer _tmp58_;
						_tmp52_ = _frontier_it;
						if (!vala_iterator_next (_tmp52_)) {
							break;
						}
						_tmp53_ = _frontier_it;
						_tmp54_ = vala_iterator_get (_tmp53_);
						_tmp55_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp54_);
						frontier = _tmp55_;
						_tmp56_ = phi;
						_tmp57_ = frontier;
						_tmp58_ = vala_map_get ((ValaMap*) _tmp56_, _tmp57_);
						blockPhi = (gint) ((gintptr) _tmp58_);
						if (blockPhi < counter) {
							ValaBasicBlock* _tmp59_;
							ValaVariable* _tmp60_;
							ValaBasicBlock* _tmp61_;
							ValaList* _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							ValaPhiFunction* _tmp65_;
							ValaPhiFunction* _tmp66_;
							ValaHashMap* _tmp67_;
							ValaBasicBlock* _tmp68_;
							gint block_added = 0;
							ValaHashMap* _tmp69_;
							ValaBasicBlock* _tmp70_;
							gpointer _tmp71_;
							_tmp59_ = frontier;
							_tmp60_ = variable;
							_tmp61_ = frontier;
							_tmp62_ = vala_basic_block_get_predecessors (_tmp61_);
							_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_phi_function_new (_tmp60_, _tmp64_);
							_tmp66_ = _tmp65_;
							vala_basic_block_add_phi_function (_tmp59_, _tmp66_);
							_vala_phi_function_unref0 (_tmp66_);
							_tmp67_ = phi;
							_tmp68_ = frontier;
							vala_map_set ((ValaMap*) _tmp67_, _tmp68_, (gpointer) ((gintptr) counter));
							_tmp69_ = added;
							_tmp70_ = frontier;
							_tmp71_ = vala_map_get ((ValaMap*) _tmp69_, _tmp70_);
							block_added = (gint) ((gintptr) _tmp71_);
							if (block_added < counter) {
								ValaHashMap* _tmp72_;
								ValaBasicBlock* _tmp73_;
								ValaArrayList* _tmp74_;
								ValaBasicBlock* _tmp75_;
								_tmp72_ = added;
								_tmp73_ = frontier;
								vala_map_set ((ValaMap*) _tmp72_, _tmp73_, (gpointer) ((gintptr) counter));
								_tmp74_ = work_list;
								_tmp75_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp74_, _tmp75_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}

static void
vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                    ValaBasicBlock* entry_block)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp11_;
	ValaArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	vala_flow_analyzer_check_block_variables (self, entry_block);
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
	used_vars_queue = _tmp12_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp13_ = self->priv->used_vars;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_variable_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValaVariable* _tmp19_;
			_tmp15_ = _variable_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			variable = (ValaVariable*) _tmp17_;
			_tmp18_ = used_vars_queue;
			_tmp19_ = variable;
			vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp23_;
		gpointer _tmp24_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp25_;
		ValaVariable* _tmp26_;
		gpointer _tmp27_;
		ValaPhiFunction* _tmp28_;
		_tmp20_ = used_vars_queue;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		if (!(_tmp22_ > 0)) {
			break;
		}
		_tmp23_ = used_vars_queue;
		_tmp24_ = vala_list_remove_at ((ValaList*) _tmp23_, 0);
		used_var = (ValaVariable*) _tmp24_;
		_tmp25_ = self->priv->phi_functions;
		_tmp26_ = used_var;
		_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
		phi = (ValaPhiFunction*) _tmp27_;
		_tmp28_ = phi;
		if (_tmp28_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp29_;
				ValaList* _tmp30_;
				ValaList* _tmp31_;
				gint _variable_size = 0;
				ValaList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _variable_index = 0;
				_tmp29_ = phi;
				_tmp30_ = vala_phi_function_get_operands (_tmp29_);
				_tmp31_ = _tmp30_;
				_variable_list = _tmp31_;
				_tmp32_ = _variable_list;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_variable_size = _tmp34_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					ValaVariable* variable = NULL;
					ValaList* _tmp37_;
					gpointer _tmp38_;
					ValaVariable* _tmp39_;
					ValaSet* _tmp53_;
					ValaVariable* _tmp54_;
					_variable_index = _variable_index + 1;
					_tmp35_ = _variable_index;
					_tmp36_ = _variable_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _variable_list;
					_tmp38_ = vala_list_get (_tmp37_, _variable_index);
					variable = (ValaVariable*) _tmp38_;
					_tmp39_ = variable;
					if (_tmp39_ == NULL) {
						ValaVariable* _tmp40_;
						_tmp40_ = used_var;
						if (VALA_IS_LOCAL_VARIABLE (_tmp40_)) {
							ValaVariable* _tmp41_;
							ValaSourceReference* _tmp42_;
							ValaSourceReference* _tmp43_;
							ValaVariable* _tmp44_;
							const gchar* _tmp45_;
							const gchar* _tmp46_;
							_tmp41_ = used_var;
							_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = used_var;
							_tmp45_ = vala_symbol_get_name ((ValaSymbol*) _tmp44_);
							_tmp46_ = _tmp45_;
							vala_report_error (_tmp43_, "Use of possibly unassigned local variable `%s'", _tmp46_);
						} else {
							ValaVariable* _tmp47_;
							ValaSourceReference* _tmp48_;
							ValaSourceReference* _tmp49_;
							ValaVariable* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							_tmp47_ = used_var;
							_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = used_var;
							_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
							_tmp52_ = _tmp51_;
							vala_report_warning (_tmp49_, "Use of possibly unassigned parameter `%s'", _tmp52_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp53_ = self->priv->used_vars;
					_tmp54_ = variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp53_, _tmp54_)) {
						ValaVariable* _tmp55_;
						ValaVariable* _tmp56_;
						ValaSourceReference* _tmp57_;
						ValaSourceReference* _tmp58_;
						ValaSet* _tmp59_;
						ValaVariable* _tmp60_;
						ValaArrayList* _tmp61_;
						ValaVariable* _tmp62_;
						_tmp55_ = variable;
						_tmp56_ = used_var;
						_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp56_);
						_tmp58_ = _tmp57_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp55_, _tmp58_);
						_tmp59_ = self->priv->used_vars;
						_tmp60_ = variable;
						vala_collection_add ((ValaCollection*) _tmp59_, _tmp60_);
						_tmp61_ = used_vars_queue;
						_tmp62_ = variable;
						vala_collection_add ((ValaCollection*) _tmp61_, _tmp62_);
					}
					_vala_code_node_unref0 (variable);
				}
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = NULL;
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = NULL;
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = NULL;
	_vala_iterable_unref0 (used_vars_queue);
}

static void
vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                          ValaBasicBlock* block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp0_;
		ValaIterator* _tmp1_;
		_tmp0_ = vala_basic_block_get_phi_functions (block);
		_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
		_phi_it = _tmp1_;
		while (TRUE) {
			ValaIterator* _tmp2_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp3_;
			gpointer _tmp4_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp5_;
			ValaPhiFunction* _tmp6_;
			ValaVariable* _tmp7_;
			ValaVariable* _tmp8_;
			ValaVariable* _tmp9_;
			ValaMap* _tmp10_;
			ValaVariable* _tmp11_;
			ValaPhiFunction* _tmp12_;
			_tmp2_ = _phi_it;
			if (!vala_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _phi_it;
			_tmp4_ = vala_iterator_get (_tmp3_);
			phi = (ValaPhiFunction*) _tmp4_;
			_tmp5_ = self->priv->var_map;
			_tmp6_ = phi;
			_tmp7_ = vala_phi_function_get_original_variable (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_flow_analyzer_process_assignment (self, _tmp5_, _tmp8_);
			versioned_var = _tmp9_;
			_tmp10_ = self->priv->phi_functions;
			_tmp11_ = versioned_var;
			_tmp12_ = phi;
			vala_map_set (_tmp10_, _tmp11_, _tmp12_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp13_;
		gint _node_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _node_index = 0;
		_tmp13_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp13_;
		_tmp14_ = _node_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_node_size = _tmp16_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp21_;
			ValaArrayList* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaArrayList* _tmp24_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp67_;
			ValaArrayList* _tmp68_;
			ValaCodeNode* _tmp69_;
			ValaArrayList* _tmp70_;
			_node_index = _node_index + 1;
			_tmp17_ = _node_index;
			_tmp18_ = _node_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _node_list;
			_tmp20_ = vala_list_get (_tmp19_, _node_index);
			node = (ValaCodeNode*) _tmp20_;
			_tmp21_ = g_direct_equal;
			_tmp22_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp21_);
			used_variables = _tmp22_;
			_tmp23_ = node;
			_tmp24_ = used_variables;
			vala_code_node_get_used_variables (_tmp23_, (ValaCollection*) _tmp24_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp25_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _var_symbol_index = 0;
				_tmp25_ = used_variables;
				_var_symbol_list = _tmp25_;
				_tmp26_ = _var_symbol_list;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_var_symbol_size = _tmp28_;
				_var_symbol_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp31_;
					gpointer _tmp32_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp33_;
					ValaVariable* _tmp34_;
					gpointer _tmp35_;
					gboolean _tmp36_ = FALSE;
					ValaList* _tmp37_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp54_;
					ValaList* _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					gpointer _tmp58_;
					ValaSet* _tmp59_;
					ValaVariable* _tmp60_;
					ValaSet* _tmp65_;
					ValaVariable* _tmp66_;
					_var_symbol_index = _var_symbol_index + 1;
					_tmp29_ = _var_symbol_index;
					_tmp30_ = _var_symbol_size;
					if (!(_tmp29_ < _tmp30_)) {
						break;
					}
					_tmp31_ = _var_symbol_list;
					_tmp32_ = vala_list_get ((ValaList*) _tmp31_, _var_symbol_index);
					var_symbol = (ValaVariable*) _tmp32_;
					_tmp33_ = self->priv->var_map;
					_tmp34_ = var_symbol;
					_tmp35_ = vala_map_get (_tmp33_, (ValaSymbol*) _tmp34_);
					variable_stack = (ValaList*) _tmp35_;
					_tmp37_ = variable_stack;
					if (_tmp37_ == NULL) {
						_tmp36_ = TRUE;
					} else {
						ValaList* _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						_tmp38_ = variable_stack;
						_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp36_ = _tmp40_ == 0;
					}
					if (_tmp36_) {
						ValaVariable* _tmp41_;
						_tmp41_ = var_symbol;
						if (VALA_IS_LOCAL_VARIABLE (_tmp41_)) {
							ValaCodeNode* _tmp42_;
							ValaSourceReference* _tmp43_;
							ValaSourceReference* _tmp44_;
							ValaVariable* _tmp45_;
							const gchar* _tmp46_;
							const gchar* _tmp47_;
							_tmp42_ = node;
							_tmp43_ = vala_code_node_get_source_reference (_tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = var_symbol;
							_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
							_tmp47_ = _tmp46_;
							vala_report_error (_tmp44_, "Use of possibly unassigned local variable `%s'", _tmp47_);
						} else {
							ValaCodeNode* _tmp48_;
							ValaSourceReference* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaVariable* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							_tmp48_ = node;
							_tmp49_ = vala_code_node_get_source_reference (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = var_symbol;
							_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
							_tmp53_ = _tmp52_;
							vala_report_warning (_tmp50_, "Use of possibly unassigned parameter `%s'", _tmp53_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp54_ = variable_stack;
					_tmp55_ = variable_stack;
					_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = vala_list_get (_tmp54_, _tmp57_ - 1);
					versioned_variable = (ValaVariable*) _tmp58_;
					_tmp59_ = self->priv->used_vars;
					_tmp60_ = versioned_variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp59_, _tmp60_)) {
						ValaVariable* _tmp61_;
						ValaCodeNode* _tmp62_;
						ValaSourceReference* _tmp63_;
						ValaSourceReference* _tmp64_;
						_tmp61_ = versioned_variable;
						_tmp62_ = node;
						_tmp63_ = vala_code_node_get_source_reference (_tmp62_);
						_tmp64_ = _tmp63_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp61_, _tmp64_);
					}
					_tmp65_ = self->priv->used_vars;
					_tmp66_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp65_, _tmp66_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
			}
			_tmp67_ = g_direct_equal;
			_tmp68_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp67_);
			defined_variables = _tmp68_;
			_tmp69_ = node;
			_tmp70_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp69_, (ValaCollection*) _tmp70_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp71_;
				gint _variable_size = 0;
				ValaArrayList* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gint _variable_index = 0;
				_tmp71_ = defined_variables;
				_variable_list = _tmp71_;
				_tmp72_ = _variable_list;
				_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
				_tmp74_ = _tmp73_;
				_variable_size = _tmp74_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp75_;
					gint _tmp76_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp77_;
					gpointer _tmp78_;
					ValaMap* _tmp79_;
					ValaVariable* _tmp80_;
					ValaVariable* _tmp81_;
					ValaVariable* _tmp82_;
					_variable_index = _variable_index + 1;
					_tmp75_ = _variable_index;
					_tmp76_ = _variable_size;
					if (!(_tmp75_ < _tmp76_)) {
						break;
					}
					_tmp77_ = _variable_list;
					_tmp78_ = vala_list_get ((ValaList*) _tmp77_, _variable_index);
					variable = (ValaVariable*) _tmp78_;
					_tmp79_ = self->priv->var_map;
					_tmp80_ = variable;
					_tmp81_ = vala_flow_analyzer_process_assignment (self, _tmp79_, _tmp80_);
					_tmp82_ = _tmp81_;
					_vala_code_node_unref0 (_tmp82_);
					_vala_code_node_unref0 (variable);
				}
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
	}
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp83_;
		gint _succ_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _succ_index = 0;
		_tmp83_ = vala_basic_block_get_successors (block);
		_succ_list = _tmp83_;
		_tmp84_ = _succ_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_succ_size = _tmp86_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp87_;
			gint _tmp88_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp89_;
			gpointer _tmp90_;
			gint j = 0;
			_succ_index = _succ_index + 1;
			_tmp87_ = _succ_index;
			_tmp88_ = _succ_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _succ_list;
			_tmp90_ = vala_list_get (_tmp89_, _succ_index);
			succ = (ValaBasicBlock*) _tmp90_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp91_;
				ValaList* _tmp92_;
				gint _pred_size = 0;
				ValaList* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _pred_index = 0;
				_tmp91_ = succ;
				_tmp92_ = vala_basic_block_get_predecessors (_tmp91_);
				_pred_list = _tmp92_;
				_tmp93_ = _pred_list;
				_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
				_tmp95_ = _tmp94_;
				_pred_size = _tmp95_;
				_pred_index = -1;
				while (TRUE) {
					gint _tmp96_;
					gint _tmp97_;
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp98_;
					gpointer _tmp99_;
					ValaBasicBlock* _tmp100_;
					gint _tmp101_;
					_pred_index = _pred_index + 1;
					_tmp96_ = _pred_index;
					_tmp97_ = _pred_size;
					if (!(_tmp96_ < _tmp97_)) {
						break;
					}
					_tmp98_ = _pred_list;
					_tmp99_ = vala_list_get (_tmp98_, _pred_index);
					pred = (ValaBasicBlock*) _tmp99_;
					_tmp100_ = pred;
					if (_tmp100_ == block) {
						break;
					}
					_tmp101_ = j;
					j = _tmp101_ + 1;
				}
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp102_;
				ValaSet* _tmp103_;
				ValaIterator* _tmp104_;
				_tmp102_ = succ;
				_tmp103_ = vala_basic_block_get_phi_functions (_tmp102_);
				_tmp104_ = vala_iterable_iterator ((ValaIterable*) _tmp103_);
				_phi_it = _tmp104_;
				while (TRUE) {
					ValaIterator* _tmp105_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp106_;
					gpointer _tmp107_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp108_;
					ValaPhiFunction* _tmp109_;
					ValaVariable* _tmp110_;
					ValaVariable* _tmp111_;
					gpointer _tmp112_;
					gboolean _tmp113_ = FALSE;
					ValaList* _tmp114_;
					_tmp105_ = _phi_it;
					if (!vala_iterator_next (_tmp105_)) {
						break;
					}
					_tmp106_ = _phi_it;
					_tmp107_ = vala_iterator_get (_tmp106_);
					phi = (ValaPhiFunction*) _tmp107_;
					_tmp108_ = self->priv->var_map;
					_tmp109_ = phi;
					_tmp110_ = vala_phi_function_get_original_variable (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_map_get (_tmp108_, (ValaSymbol*) _tmp111_);
					variable_stack = (ValaList*) _tmp112_;
					_tmp114_ = variable_stack;
					if (_tmp114_ != NULL) {
						ValaList* _tmp115_;
						gint _tmp116_;
						gint _tmp117_;
						_tmp115_ = variable_stack;
						_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp113_ = _tmp117_ > 0;
					} else {
						_tmp113_ = FALSE;
					}
					if (_tmp113_) {
						ValaPhiFunction* _tmp118_;
						ValaList* _tmp119_;
						ValaList* _tmp120_;
						ValaList* _tmp121_;
						ValaList* _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gpointer _tmp125_;
						ValaVariable* _tmp126_;
						_tmp118_ = phi;
						_tmp119_ = vala_phi_function_get_operands (_tmp118_);
						_tmp120_ = _tmp119_;
						_tmp121_ = variable_stack;
						_tmp122_ = variable_stack;
						_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_list_get (_tmp121_, _tmp124_ - 1);
						_tmp126_ = (ValaVariable*) _tmp125_;
						vala_list_set (_tmp120_, j, _tmp126_);
						_vala_code_node_unref0 (_tmp126_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
		}
	}
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp127_;
		gint _child_size = 0;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gint _child_index = 0;
		_tmp127_ = vala_basic_block_get_children (block);
		_child_list = _tmp127_;
		_tmp128_ = _child_list;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_child_size = _tmp130_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp131_;
			gint _tmp132_;
			ValaBasicBlock* child = NULL;
			ValaList* _tmp133_;
			gpointer _tmp134_;
			ValaBasicBlock* _tmp135_;
			_child_index = _child_index + 1;
			_tmp131_ = _child_index;
			_tmp132_ = _child_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _child_list;
			_tmp134_ = vala_list_get (_tmp133_, _child_index);
			child = (ValaBasicBlock*) _tmp134_;
			_tmp135_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp135_);
		}
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp136_;
		ValaIterator* _tmp137_;
		_tmp136_ = vala_basic_block_get_phi_functions (block);
		_tmp137_ = vala_iterable_iterator ((ValaIterable*) _tmp136_);
		_phi_it = _tmp137_;
		while (TRUE) {
			ValaIterator* _tmp138_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp139_;
			gpointer _tmp140_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp141_;
			ValaPhiFunction* _tmp142_;
			ValaVariable* _tmp143_;
			ValaVariable* _tmp144_;
			gpointer _tmp145_;
			ValaList* _tmp146_;
			ValaList* _tmp147_;
			gint _tmp148_;
			gint _tmp149_;
			gpointer _tmp150_;
			ValaVariable* _tmp151_;
			_tmp138_ = _phi_it;
			if (!vala_iterator_next (_tmp138_)) {
				break;
			}
			_tmp139_ = _phi_it;
			_tmp140_ = vala_iterator_get (_tmp139_);
			phi = (ValaPhiFunction*) _tmp140_;
			_tmp141_ = self->priv->var_map;
			_tmp142_ = phi;
			_tmp143_ = vala_phi_function_get_original_variable (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_map_get (_tmp141_, (ValaSymbol*) _tmp144_);
			variable_stack = (ValaList*) _tmp145_;
			_tmp146_ = variable_stack;
			_tmp147_ = variable_stack;
			_tmp148_ = vala_collection_get_size ((ValaCollection*) _tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_list_remove_at (_tmp146_, _tmp149_ - 1);
			_tmp151_ = (ValaVariable*) _tmp150_;
			_vala_code_node_unref0 (_tmp151_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp152_;
		gint _node_size = 0;
		ValaList* _tmp153_;
		gint _tmp154_;
		gint _tmp155_;
		gint _node_index = 0;
		_tmp152_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp152_;
		_tmp153_ = _node_list;
		_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
		_tmp155_ = _tmp154_;
		_node_size = _tmp155_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp156_;
			gint _tmp157_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp158_;
			gpointer _tmp159_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp160_;
			ValaArrayList* _tmp161_;
			ValaCodeNode* _tmp162_;
			ValaArrayList* _tmp163_;
			_node_index = _node_index + 1;
			_tmp156_ = _node_index;
			_tmp157_ = _node_size;
			if (!(_tmp156_ < _tmp157_)) {
				break;
			}
			_tmp158_ = _node_list;
			_tmp159_ = vala_list_get (_tmp158_, _node_index);
			node = (ValaCodeNode*) _tmp159_;
			_tmp160_ = g_direct_equal;
			_tmp161_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp160_);
			defined_variables = _tmp161_;
			_tmp162_ = node;
			_tmp163_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp162_, (ValaCollection*) _tmp163_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp164_;
				gint _variable_size = 0;
				ValaArrayList* _tmp165_;
				gint _tmp166_;
				gint _tmp167_;
				gint _variable_index = 0;
				_tmp164_ = defined_variables;
				_variable_list = _tmp164_;
				_tmp165_ = _variable_list;
				_tmp166_ = vala_collection_get_size ((ValaCollection*) _tmp165_);
				_tmp167_ = _tmp166_;
				_variable_size = _tmp167_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp168_;
					gint _tmp169_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp170_;
					gpointer _tmp171_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp172_;
					ValaVariable* _tmp173_;
					gpointer _tmp174_;
					ValaList* _tmp175_;
					ValaList* _tmp176_;
					gint _tmp177_;
					gint _tmp178_;
					gpointer _tmp179_;
					ValaVariable* _tmp180_;
					_variable_index = _variable_index + 1;
					_tmp168_ = _variable_index;
					_tmp169_ = _variable_size;
					if (!(_tmp168_ < _tmp169_)) {
						break;
					}
					_tmp170_ = _variable_list;
					_tmp171_ = vala_list_get ((ValaList*) _tmp170_, _variable_index);
					variable = (ValaVariable*) _tmp171_;
					_tmp172_ = self->priv->var_map;
					_tmp173_ = variable;
					_tmp174_ = vala_map_get (_tmp172_, (ValaSymbol*) _tmp173_);
					variable_stack = (ValaList*) _tmp174_;
					_tmp175_ = variable_stack;
					_tmp176_ = variable_stack;
					_tmp177_ = vala_collection_get_size ((ValaCollection*) _tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = vala_list_remove_at (_tmp175_, _tmp178_ - 1);
					_tmp180_ = (ValaVariable*) _tmp179_;
					_vala_code_node_unref0 (_tmp180_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
	}
}

static ValaVariable*
vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                       ValaMap* var_map,
                                       ValaVariable* var_symbol)
{
	ValaList* variable_stack = NULL;
	gpointer _tmp0_;
	ValaList* _tmp1_;
	ValaVariable* versioned_var = NULL;
	ValaList* _tmp23_;
	ValaVariable* _tmp24_;
	ValaVariable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = vala_map_get (var_map, (ValaSymbol*) var_symbol);
	variable_stack = (ValaList*) _tmp0_;
	_tmp1_ = variable_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp3_;
		_tmp4_ = variable_stack;
		vala_map_set (var_map, (ValaSymbol*) var_symbol, _tmp4_);
		vala_variable_set_single_assignment (var_symbol, TRUE);
	} else {
		vala_variable_set_single_assignment (var_symbol, FALSE);
	}
	if (VALA_IS_LOCAL_VARIABLE (var_symbol)) {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaLocalVariable* _tmp13_;
		_tmp5_ = vala_variable_get_variable_type (var_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_local_variable_new (_tmp8_, _tmp10_, NULL, _tmp12_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp13_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type (var_symbol);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new (_tmp15_, _tmp19_, _tmp21_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp22_;
		_vala_code_node_unref0 (_tmp19_);
	}
	_tmp23_ = variable_stack;
	_tmp24_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}

static void
vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                               ValaCreationMethod* m)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}

static void
vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                        ValaProperty* prop)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                 ValaPropertyAccessor* acc)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) acc);
}

static void
vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                     ValaBlock* b)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                     ValaDeclarationStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaBasicBlock* _tmp14_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	gboolean _tmp17_ = FALSE;
	ValaLocalVariable* _tmp18_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_declaration_statement_get_declaration (stmt);
		_tmp1_ = _tmp0_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp1_, TRUE);
		return;
	}
	_tmp2_ = vala_declaration_statement_get_declaration (stmt);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_used (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp6_ = vala_declaration_statement_get_declaration (stmt);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_declaration_statement_get_declaration (stmt);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_warning (_tmp9_, "Local variable `%s' declared but never used", _tmp13_);
	}
	_tmp14_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp14_, (ValaCodeNode*) stmt);
	_tmp15_ = vala_declaration_statement_get_declaration (stmt);
	_tmp16_ = _tmp15_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp16_) ? ((ValaLocalVariable*) _tmp16_) : NULL;
	_tmp18_ = local;
	if (_tmp18_ != NULL) {
		ValaLocalVariable* _tmp19_;
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		_tmp19_ = local;
		_tmp20_ = vala_variable_get_initializer ((ValaVariable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaLocalVariable* _tmp22_;
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp22_ = local;
		_tmp23_ = vala_variable_get_initializer ((ValaVariable*) _tmp22_);
		_tmp24_ = _tmp23_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp24_, FALSE);
	}
}

static void
vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                              ValaLocalVariable* local)
{
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
}

static void
vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                    ValaExpressionStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, FALSE);
	_tmp1_ = vala_expression_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	if (VALA_IS_METHOD_CALL (_tmp2_)) {
		ValaMethodCall* expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaMemberAccess* _tmp10_;
		_tmp3_ = vala_expression_statement_get_expression (stmt);
		_tmp4_ = _tmp3_;
		expr = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
		_tmp5_ = expr;
		_tmp6_ = vala_method_call_get_call (_tmp5_);
		_tmp7_ = _tmp6_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp7_) ? ((ValaMemberAccess*) _tmp7_) : NULL;
		_tmp10_ = ma;
		if (_tmp10_ != NULL) {
			ValaMemberAccess* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp11_ = ma;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaMemberAccess* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaAttribute* _tmp17_;
			_tmp14_ = ma;
			_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp16_, "NoReturn");
			_tmp8_ = _tmp17_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			vala_flow_analyzer_mark_unreachable (self);
			return;
		}
	}
}

static void
vala_flow_analyzer_real_visit_with_statement (ValaCodeVisitor* base,
                                              ValaWithStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_with_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_with_statement_get_expression (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_with_statement_get_body (stmt);
	_tmp6_ = _tmp5_;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                            ValaIfStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp14_;
	ValaBlock* _tmp15_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp29_;
	ValaBasicBlock* _tmp30_;
	gboolean _tmp31_ = FALSE;
	ValaBasicBlock* _tmp32_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_if_statement_get_condition (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_if_statement_get_condition (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = _vala_basic_block_ref0 (_tmp5_);
	last_block = _tmp6_;
	_tmp7_ = vala_if_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	if (vala_expression_is_always_false (_tmp8_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp9_;
		ValaSet* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* _tmp12_;
		ValaBasicBlock* _tmp13_;
		_tmp9_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp9_;
		_tmp10_ = self->priv->all_basic_blocks;
		_tmp11_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
		_tmp12_ = last_block;
		_tmp13_ = self->priv->current_block;
		vala_basic_block_connect (_tmp12_, _tmp13_);
	}
	_tmp14_ = vala_if_statement_get_true_statement (stmt);
	_tmp15_ = _tmp14_;
	vala_code_node_accept ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
	_tmp16_ = self->priv->current_block;
	_tmp17_ = _vala_basic_block_ref0 (_tmp16_);
	last_true_block = _tmp17_;
	_tmp18_ = vala_if_statement_get_condition (stmt);
	_tmp19_ = _tmp18_;
	if (vala_expression_is_always_true (_tmp19_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp20_;
		ValaSet* _tmp21_;
		ValaBasicBlock* _tmp22_;
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp20_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp20_;
		_tmp21_ = self->priv->all_basic_blocks;
		_tmp22_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
		_tmp23_ = last_block;
		_tmp24_ = self->priv->current_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = vala_if_statement_get_false_statement (stmt);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaBlock* _tmp27_;
		ValaBlock* _tmp28_;
		_tmp27_ = vala_if_statement_get_false_statement (stmt);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, (ValaCodeVisitor*) self);
	}
	_tmp29_ = self->priv->current_block;
	_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
	last_false_block = _tmp30_;
	_tmp32_ = last_true_block;
	if (_tmp32_ != NULL) {
		_tmp31_ = TRUE;
	} else {
		ValaBasicBlock* _tmp33_;
		_tmp33_ = last_false_block;
		_tmp31_ = _tmp33_ != NULL;
	}
	if (_tmp31_) {
		ValaBasicBlock* _tmp34_;
		ValaSet* _tmp35_;
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		ValaBasicBlock* _tmp40_;
		_tmp34_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp34_;
		_tmp35_ = self->priv->all_basic_blocks;
		_tmp36_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp35_, _tmp36_);
		_tmp37_ = last_true_block;
		if (_tmp37_ != NULL) {
			ValaBasicBlock* _tmp38_;
			ValaBasicBlock* _tmp39_;
			_tmp38_ = last_true_block;
			_tmp39_ = self->priv->current_block;
			vala_basic_block_connect (_tmp38_, _tmp39_);
		}
		_tmp40_ = last_false_block;
		if (_tmp40_ != NULL) {
			ValaBasicBlock* _tmp41_;
			ValaBasicBlock* _tmp42_;
			_tmp41_ = last_false_block;
			_tmp42_ = self->priv->current_block;
			vala_basic_block_connect (_tmp41_, _tmp42_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static void
vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                ValaSwitchStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	gboolean has_default_label = FALSE;
	gboolean is_enum_typed = FALSE;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaEnum* en = NULL;
	ValaHashSet* enum_values = NULL;
	gboolean _tmp78_ = FALSE;
	ValaBasicBlock* _tmp115_;
	ValaList* _tmp116_;
	gint _tmp117_;
	gint _tmp118_;
	ValaList* _tmp121_;
	ValaList* _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	gpointer _tmp125_;
	ValaFlowAnalyzerJumpTarget* _tmp126_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	after_switch_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = after_switch_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = after_switch_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_break_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = self->priv->current_block;
	_tmp8_ = vala_switch_statement_get_expression (stmt);
	_tmp9_ = _tmp8_;
	vala_basic_block_add_node (_tmp7_, (ValaCodeNode*) _tmp9_);
	_tmp10_ = self->priv->current_block;
	_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
	condition_block = _tmp11_;
	_tmp12_ = vala_switch_statement_get_expression (stmt);
	_tmp13_ = _tmp12_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp13_, FALSE);
	has_default_label = FALSE;
	_tmp14_ = vala_switch_statement_get_expression (stmt);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_expression_get_value_type (_tmp15_);
	_tmp17_ = _tmp16_;
	is_enum_typed = VALA_IS_ENUM_VALUE_TYPE (_tmp17_);
	en = NULL;
	enum_values = NULL;
	if (is_enum_typed) {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaTypeSymbol* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		GHashFunc _tmp24_;
		GEqualFunc _tmp25_;
		ValaHashSet* _tmp26_;
		_tmp18_ = vala_switch_statement_get_expression (stmt);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_value_type (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
		_tmp23_ = _tmp22_;
		en = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_ENUM, ValaEnum);
		_tmp24_ = g_direct_hash;
		_tmp25_ = g_direct_equal;
		_tmp26_ = vala_hash_set_new (VALA_TYPE_ENUM_VALUE, NULL, NULL, _tmp24_, _tmp25_);
		_vala_iterable_unref0 (enum_values);
		enum_values = _tmp26_;
	}
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp27_;
		gint _section_size = 0;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _section_index = 0;
		_tmp27_ = vala_switch_statement_get_sections (stmt);
		_section_list = _tmp27_;
		_tmp28_ = _section_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_section_size = _tmp30_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaBasicBlock* _tmp35_;
			ValaSet* _tmp36_;
			ValaBasicBlock* _tmp37_;
			ValaBasicBlock* _tmp38_;
			ValaBasicBlock* _tmp39_;
			ValaSwitchSection* _tmp70_;
			ValaBasicBlock* _tmp71_;
			_section_index = _section_index + 1;
			_tmp31_ = _section_index;
			_tmp32_ = _section_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _section_list;
			_tmp34_ = vala_list_get (_tmp33_, _section_index);
			section = (ValaSwitchSection*) _tmp34_;
			_tmp35_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp35_;
			_tmp36_ = self->priv->all_basic_blocks;
			_tmp37_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp36_, _tmp37_);
			_tmp38_ = condition_block;
			_tmp39_ = self->priv->current_block;
			vala_basic_block_connect (_tmp38_, _tmp39_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp40_;
				ValaList* _tmp41_;
				gint _section_stmt_size = 0;
				ValaList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _section_stmt_index = 0;
				_tmp40_ = section;
				_tmp41_ = vala_block_get_statements ((ValaBlock*) _tmp40_);
				_section_stmt_list = _tmp41_;
				_tmp42_ = _section_stmt_list;
				_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_section_stmt_size = _tmp44_;
				_section_stmt_index = -1;
				while (TRUE) {
					gint _tmp45_;
					gint _tmp46_;
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp47_;
					gpointer _tmp48_;
					ValaStatement* _tmp49_;
					_section_stmt_index = _section_stmt_index + 1;
					_tmp45_ = _section_stmt_index;
					_tmp46_ = _section_stmt_size;
					if (!(_tmp45_ < _tmp46_)) {
						break;
					}
					_tmp47_ = _section_stmt_list;
					_tmp48_ = vala_list_get (_tmp47_, _section_stmt_index);
					section_stmt = (ValaStatement*) _tmp48_;
					_tmp49_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp49_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			if (is_enum_typed) {
				{
					ValaList* _label_list = NULL;
					ValaSwitchSection* _tmp50_;
					ValaList* _tmp51_;
					gint _label_size = 0;
					ValaList* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					gint _label_index = 0;
					_tmp50_ = section;
					_tmp51_ = vala_switch_section_get_labels (_tmp50_);
					_label_list = _tmp51_;
					_tmp52_ = _label_list;
					_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
					_tmp54_ = _tmp53_;
					_label_size = _tmp54_;
					_label_index = -1;
					while (TRUE) {
						gint _tmp55_;
						gint _tmp56_;
						ValaSwitchLabel* label = NULL;
						ValaList* _tmp57_;
						gpointer _tmp58_;
						ValaSwitchLabel* _tmp59_;
						ValaExpression* _tmp60_;
						ValaExpression* _tmp61_;
						_label_index = _label_index + 1;
						_tmp55_ = _label_index;
						_tmp56_ = _label_size;
						if (!(_tmp55_ < _tmp56_)) {
							break;
						}
						_tmp57_ = _label_list;
						_tmp58_ = vala_list_get (_tmp57_, _label_index);
						label = (ValaSwitchLabel*) _tmp58_;
						_tmp59_ = label;
						_tmp60_ = vala_switch_label_get_expression (_tmp59_);
						_tmp61_ = _tmp60_;
						if (_tmp61_ != NULL) {
							ValaEnumValue* val = NULL;
							ValaSwitchLabel* _tmp62_;
							ValaExpression* _tmp63_;
							ValaExpression* _tmp64_;
							ValaSymbol* _tmp65_;
							ValaSymbol* _tmp66_;
							ValaEnumValue* _tmp67_;
							_tmp62_ = label;
							_tmp63_ = vala_switch_label_get_expression (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_expression_get_symbol_reference (_tmp64_);
							_tmp66_ = _tmp65_;
							val = VALA_IS_ENUM_VALUE (_tmp66_) ? ((ValaEnumValue*) _tmp66_) : NULL;
							_tmp67_ = val;
							if (_tmp67_ != NULL) {
								ValaHashSet* _tmp68_;
								ValaEnumValue* _tmp69_;
								_tmp68_ = enum_values;
								_tmp69_ = val;
								vala_collection_add ((ValaCollection*) _tmp68_, _tmp69_);
							}
						}
						_vala_code_node_unref0 (label);
					}
				}
			}
			_tmp70_ = section;
			if (vala_switch_section_has_default_label (_tmp70_)) {
				has_default_label = TRUE;
			}
			_tmp71_ = self->priv->current_block;
			if (_tmp71_ != NULL) {
				ValaSwitchSection* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSwitchSection* _tmp75_;
				ValaBasicBlock* _tmp76_;
				ValaBasicBlock* _tmp77_;
				_tmp72_ = section;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				vala_report_error (_tmp74_, "missing break statement at end of switch section");
				_tmp75_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp75_, TRUE);
				_tmp76_ = self->priv->current_block;
				_tmp77_ = after_switch_block;
				vala_basic_block_connect (_tmp76_, _tmp77_);
			}
			_vala_code_node_unref0 (section);
		}
	}
	if (!has_default_label) {
		_tmp78_ = is_enum_typed;
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		ValaHashSet* remaining_values = NULL;
		GHashFunc _tmp79_;
		GEqualFunc _tmp80_;
		ValaHashSet* _tmp81_;
		ValaHashSet* _tmp82_;
		ValaEnum* _tmp83_;
		ValaList* _tmp84_;
		ValaHashSet* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		_tmp79_ = g_direct_hash;
		_tmp80_ = g_direct_equal;
		_tmp81_ = vala_hash_set_new (VALA_TYPE_ENUM_VALUE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp79_, _tmp80_);
		remaining_values = _tmp81_;
		_tmp82_ = remaining_values;
		_tmp83_ = en;
		_tmp84_ = vala_enum_get_values (_tmp83_);
		vala_collection_add_all ((ValaCollection*) _tmp82_, (ValaCollection*) _tmp84_);
		{
			ValaIterator* _val_it = NULL;
			ValaHashSet* _tmp85_;
			ValaIterator* _tmp86_;
			_tmp85_ = enum_values;
			_tmp86_ = vala_iterable_iterator ((ValaIterable*) _tmp85_);
			_val_it = _tmp86_;
			while (TRUE) {
				ValaIterator* _tmp87_;
				ValaEnumValue* val = NULL;
				ValaIterator* _tmp88_;
				gpointer _tmp89_;
				ValaHashSet* _tmp90_;
				ValaEnumValue* _tmp91_;
				_tmp87_ = _val_it;
				if (!vala_iterator_next (_tmp87_)) {
					break;
				}
				_tmp88_ = _val_it;
				_tmp89_ = vala_iterator_get (_tmp88_);
				val = (ValaEnumValue*) _tmp89_;
				_tmp90_ = remaining_values;
				_tmp91_ = val;
				vala_collection_remove ((ValaCollection*) _tmp90_, _tmp91_);
			}
			_vala_iterator_unref0 (_val_it);
		}
		_tmp92_ = remaining_values;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		if (_tmp94_ > 0) {
			gchar** missing_vals = NULL;
			gchar** _tmp95_;
			gint missing_vals_length1;
			gint _missing_vals_size_;
			ValaSourceReference* _tmp105_;
			ValaSourceReference* _tmp106_;
			gchar** _tmp107_;
			gint _tmp107__length1;
			gchar* _tmp108_;
			gchar* _tmp109_;
			ValaEnum* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			_tmp95_ = g_new0 (gchar*, 0 + 1);
			missing_vals = _tmp95_;
			missing_vals_length1 = 0;
			_missing_vals_size_ = missing_vals_length1;
			{
				ValaIterator* _val_it = NULL;
				ValaHashSet* _tmp96_;
				ValaIterator* _tmp97_;
				_tmp96_ = remaining_values;
				_tmp97_ = vala_iterable_iterator ((ValaIterable*) _tmp96_);
				_val_it = _tmp97_;
				while (TRUE) {
					ValaIterator* _tmp98_;
					ValaEnumValue* val = NULL;
					ValaIterator* _tmp99_;
					gpointer _tmp100_;
					ValaEnumValue* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					gchar* _tmp104_;
					_tmp98_ = _val_it;
					if (!vala_iterator_next (_tmp98_)) {
						break;
					}
					_tmp99_ = _val_it;
					_tmp100_ = vala_iterator_get (_tmp99_);
					val = (ValaEnumValue*) _tmp100_;
					_tmp101_ = val;
					_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = g_strdup (_tmp103_);
					_vala_array_add1 (&missing_vals, &missing_vals_length1, &_missing_vals_size_, _tmp104_);
					_vala_code_node_unref0 (val);
				}
				_vala_iterator_unref0 (_val_it);
			}
			_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp106_ = _tmp105_;
			_tmp107_ = missing_vals;
			_tmp107__length1 = missing_vals_length1;
			_tmp108_ = _vala_g_strjoinv ("', `", _tmp107_, (gint) _tmp107__length1);
			_tmp109_ = _tmp108_;
			_tmp110_ = en;
			_tmp111_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp110_);
			_tmp112_ = _tmp111_;
			vala_report_warning (_tmp106_, "Switch does not handle `%s' of enum `%s'", _tmp109_, _tmp112_);
			_g_free0 (_tmp112_);
			_g_free0 (_tmp109_);
			missing_vals = (_vala_array_free (missing_vals, missing_vals_length1, (GDestroyNotify) g_free), NULL);
		}
		_vala_iterable_unref0 (remaining_values);
	}
	if (!has_default_label) {
		ValaBasicBlock* _tmp113_;
		ValaBasicBlock* _tmp114_;
		_tmp113_ = condition_block;
		_tmp114_ = after_switch_block;
		vala_basic_block_connect (_tmp113_, _tmp114_);
	}
	_tmp115_ = after_switch_block;
	_tmp116_ = vala_basic_block_get_predecessors (_tmp115_);
	_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
	_tmp118_ = _tmp117_;
	if (_tmp118_ > 0) {
		ValaBasicBlock* _tmp119_;
		ValaBasicBlock* _tmp120_;
		_tmp119_ = after_switch_block;
		_tmp120_ = _vala_basic_block_ref0 (_tmp119_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp120_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp121_ = self->priv->jump_stack;
	_tmp122_ = self->priv->jump_stack;
	_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_list_remove_at (_tmp121_, _tmp124_ - 1);
	_tmp126_ = (ValaFlowAnalyzerJumpTarget*) _tmp125_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp126_);
	_vala_iterable_unref0 (enum_values);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}

static void
vala_flow_analyzer_real_visit_loop_statement (ValaCodeVisitor* base,
                                              ValaLoopStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp7_;
	ValaSet* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaList* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaFlowAnalyzerJumpTarget* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gpointer _tmp35_;
	ValaFlowAnalyzerJumpTarget* _tmp36_;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gpointer _tmp41_;
	ValaFlowAnalyzerJumpTarget* _tmp42_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	loop_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = loop_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = vala_basic_block_new ();
	after_loop_block = _tmp7_;
	_tmp8_ = self->priv->all_basic_blocks;
	_tmp9_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
	_tmp10_ = self->priv->jump_stack;
	_tmp11_ = after_loop_block;
	_tmp12_ = vala_flow_analyzer_jump_target_new_break_target (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_collection_add ((ValaCollection*) _tmp10_, _tmp13_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp13_);
	_tmp14_ = self->priv->current_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	last_block = _tmp15_;
	_tmp16_ = last_block;
	_tmp17_ = loop_block;
	vala_basic_block_connect (_tmp16_, _tmp17_);
	_tmp18_ = loop_block;
	_tmp19_ = _vala_basic_block_ref0 (_tmp18_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp19_;
	_tmp20_ = vala_loop_get_body ((ValaLoop*) stmt);
	_tmp21_ = _tmp20_;
	vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->current_block;
	if (_tmp22_ != NULL) {
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp23_ = self->priv->current_block;
		_tmp24_ = loop_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = after_loop_block;
	_tmp26_ = vala_basic_block_get_predecessors (_tmp25_);
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == 0) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp29_;
		ValaBasicBlock* _tmp30_;
		_tmp29_ = after_loop_block;
		_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp30_;
	}
	_tmp31_ = self->priv->jump_stack;
	_tmp32_ = self->priv->jump_stack;
	_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_list_remove_at (_tmp31_, _tmp34_ - 1);
	_tmp36_ = (ValaFlowAnalyzerJumpTarget*) _tmp35_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp36_);
	_tmp37_ = self->priv->jump_stack;
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_list_remove_at (_tmp37_, _tmp40_ - 1);
	_tmp42_ = (ValaFlowAnalyzerJumpTarget*) _tmp41_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp42_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}

static void
vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                 ValaForeachStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaSet* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaFlowAnalyzerJumpTarget* _tmp10_;
	ValaFlowAnalyzerJumpTarget* _tmp11_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp12_;
	ValaSet* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaList* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaFlowAnalyzerJumpTarget* _tmp17_;
	ValaFlowAnalyzerJumpTarget* _tmp18_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBlock* _tmp27_;
	ValaBasicBlock* _tmp28_;
	ValaBasicBlock* _tmp31_;
	ValaBasicBlock* _tmp32_;
	ValaBasicBlock* _tmp33_;
	ValaBasicBlock* _tmp36_;
	ValaBasicBlock* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gpointer _tmp42_;
	ValaFlowAnalyzerJumpTarget* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_;
	ValaFlowAnalyzerJumpTarget* _tmp49_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_foreach_statement_get_collection (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_foreach_statement_get_collection (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_basic_block_new ();
	loop_block = _tmp5_;
	_tmp6_ = self->priv->all_basic_blocks;
	_tmp7_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->jump_stack;
	_tmp9_ = loop_block;
	_tmp10_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp11_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp11_);
	_tmp12_ = vala_basic_block_new ();
	after_loop_block = _tmp12_;
	_tmp13_ = self->priv->all_basic_blocks;
	_tmp14_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->jump_stack;
	_tmp16_ = after_loop_block;
	_tmp17_ = vala_flow_analyzer_jump_target_new_break_target (_tmp16_);
	_tmp18_ = _tmp17_;
	vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
	_tmp19_ = self->priv->current_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	last_block = _tmp20_;
	_tmp21_ = last_block;
	_tmp22_ = loop_block;
	vala_basic_block_connect (_tmp21_, _tmp22_);
	_tmp23_ = loop_block;
	_tmp24_ = _vala_basic_block_ref0 (_tmp23_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp24_;
	_tmp25_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp25_, (ValaCodeNode*) stmt);
	_tmp26_ = vala_foreach_statement_get_body (stmt);
	_tmp27_ = _tmp26_;
	vala_code_node_accept ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
	_tmp28_ = self->priv->current_block;
	if (_tmp28_ != NULL) {
		ValaBasicBlock* _tmp29_;
		ValaBasicBlock* _tmp30_;
		_tmp29_ = self->priv->current_block;
		_tmp30_ = loop_block;
		vala_basic_block_connect (_tmp29_, _tmp30_);
	}
	_tmp31_ = last_block;
	_tmp32_ = after_loop_block;
	vala_basic_block_connect (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->current_block;
	if (_tmp33_ != NULL) {
		ValaBasicBlock* _tmp34_;
		ValaBasicBlock* _tmp35_;
		_tmp34_ = self->priv->current_block;
		_tmp35_ = after_loop_block;
		vala_basic_block_connect (_tmp34_, _tmp35_);
	}
	_tmp36_ = after_loop_block;
	_tmp37_ = _vala_basic_block_ref0 (_tmp36_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp37_;
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = self->priv->jump_stack;
	_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_list_remove_at (_tmp38_, _tmp41_ - 1);
	_tmp43_ = (ValaFlowAnalyzerJumpTarget*) _tmp42_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp43_);
	_tmp44_ = self->priv->jump_stack;
	_tmp45_ = self->priv->jump_stack;
	_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_list_remove_at (_tmp44_, _tmp47_ - 1);
	_tmp49_ = (ValaFlowAnalyzerJumpTarget*) _tmp48_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp49_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}

static void
vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                               ValaBreakStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaFlowAnalyzerJumpTarget* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = self->priv->jump_stack;
				_tmp7_ = vala_list_get (_tmp6_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp7_;
				_tmp8_ = jump_target;
				_tmp9_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					ValaBasicBlock* _tmp11_;
					ValaFlowAnalyzerJumpTarget* _tmp12_;
					ValaBasicBlock* _tmp13_;
					ValaBasicBlock* _tmp14_;
					_tmp11_ = self->priv->current_block;
					_tmp12_ = jump_target;
					_tmp13_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp12_);
					_tmp14_ = _tmp13_;
					vala_basic_block_connect (_tmp11_, _tmp14_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = jump_target;
					_tmp16_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						ValaBasicBlock* _tmp18_;
						ValaFlowAnalyzerJumpTarget* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaFlowAnalyzerJumpTarget* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						_tmp18_ = self->priv->current_block;
						_tmp19_ = jump_target;
						_tmp20_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp19_);
						_tmp21_ = _tmp20_;
						vala_basic_block_connect (_tmp18_, _tmp21_);
						_tmp22_ = jump_target;
						_tmp23_ = vala_flow_analyzer_jump_target_get_last_block (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _vala_basic_block_ref0 (_tmp24_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp25_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp27_ = _tmp26_;
	vala_report_error (_tmp27_, "no enclosing loop or switch statement found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                  ValaContinueStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaFlowAnalyzerJumpTarget* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = self->priv->jump_stack;
				_tmp7_ = vala_list_get (_tmp6_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp7_;
				_tmp8_ = jump_target;
				_tmp9_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					ValaBasicBlock* _tmp11_;
					ValaFlowAnalyzerJumpTarget* _tmp12_;
					ValaBasicBlock* _tmp13_;
					ValaBasicBlock* _tmp14_;
					_tmp11_ = self->priv->current_block;
					_tmp12_ = jump_target;
					_tmp13_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp12_);
					_tmp14_ = _tmp13_;
					vala_basic_block_connect (_tmp11_, _tmp14_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = jump_target;
					_tmp16_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						ValaBasicBlock* _tmp18_;
						ValaFlowAnalyzerJumpTarget* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaFlowAnalyzerJumpTarget* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						_tmp18_ = self->priv->current_block;
						_tmp19_ = jump_target;
						_tmp20_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp19_);
						_tmp21_ = _tmp20_;
						vala_basic_block_connect (_tmp18_, _tmp21_);
						_tmp22_ = jump_target;
						_tmp23_ = vala_flow_analyzer_jump_target_get_last_block (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _vala_basic_block_ref0 (_tmp24_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp25_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp27_ = _tmp26_;
	vala_report_error (_tmp27_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                ValaReturnStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp30_;
	ValaSourceReference* _tmp31_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	_tmp1_ = vala_return_statement_get_return_expression (stmt);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_return_statement_get_return_expression (stmt);
		_tmp4_ = _tmp3_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->jump_stack;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		i = _tmp7_ - 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				ValaFlowAnalyzerJumpTarget* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ - 1;
				}
				_tmp8_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp10_ = self->priv->jump_stack;
				_tmp11_ = vala_list_get (_tmp10_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp11_;
				_tmp12_ = jump_target;
				_tmp13_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					ValaBasicBlock* _tmp15_;
					ValaFlowAnalyzerJumpTarget* _tmp16_;
					ValaBasicBlock* _tmp17_;
					ValaBasicBlock* _tmp18_;
					_tmp15_ = self->priv->current_block;
					_tmp16_ = jump_target;
					_tmp17_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp16_);
					_tmp18_ = _tmp17_;
					vala_basic_block_connect (_tmp15_, _tmp18_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp19_;
					gboolean _tmp20_;
					gboolean _tmp21_;
					_tmp19_ = jump_target;
					_tmp20_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp19_);
					_tmp21_ = _tmp20_;
					if (_tmp21_) {
						ValaBasicBlock* _tmp22_;
						ValaFlowAnalyzerJumpTarget* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaFlowAnalyzerJumpTarget* _tmp26_;
						ValaBasicBlock* _tmp27_;
						ValaBasicBlock* _tmp28_;
						ValaBasicBlock* _tmp29_;
						_tmp22_ = self->priv->current_block;
						_tmp23_ = jump_target;
						_tmp24_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp23_);
						_tmp25_ = _tmp24_;
						vala_basic_block_connect (_tmp22_, _tmp25_);
						_tmp26_ = jump_target;
						_tmp27_ = vala_flow_analyzer_jump_target_get_last_block (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = _vala_basic_block_ref0 (_tmp28_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp29_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp31_ = _tmp30_;
	vala_report_error (_tmp31_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                  ValaCodeNode* node,
                                  gboolean always_fail)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_code_node_get_tree_can_fail (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp2_;
		ValaBasicBlock* _tmp3_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaArrayList* _tmp6_;
		_tmp2_ = self->priv->current_block;
		_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
		last_block = _tmp3_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		error_types = _tmp5_;
		_tmp6_ = error_types;
		vala_code_node_get_error_types (node, (ValaCollection*) _tmp6_, NULL);
		{
			ValaArrayList* _error_data_type_list = NULL;
			ValaArrayList* _tmp7_;
			gint _error_data_type_size = 0;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _error_data_type_index = 0;
			_tmp7_ = error_types;
			_error_data_type_list = _tmp7_;
			_tmp8_ = _error_data_type_list;
			_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_error_data_type_size = _tmp10_;
			_error_data_type_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				ValaDataType* error_data_type = NULL;
				ValaArrayList* _tmp13_;
				gpointer _tmp14_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp15_;
				ValaClass* error_class = NULL;
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaBasicBlock* _tmp19_;
				ValaBasicBlock* _tmp20_;
				_error_data_type_index = _error_data_type_index + 1;
				_tmp11_ = _error_data_type_index;
				_tmp12_ = _error_data_type_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _error_data_type_list;
				_tmp14_ = vala_list_get ((ValaList*) _tmp13_, _error_data_type_index);
				error_data_type = (ValaDataType*) _tmp14_;
				_tmp15_ = error_data_type;
				error_type = VALA_IS_ERROR_TYPE (_tmp15_) ? ((ValaErrorType*) _tmp15_) : NULL;
				_tmp16_ = error_data_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				error_class = VALA_IS_CLASS (_tmp18_) ? ((ValaClass*) _tmp18_) : NULL;
				_tmp19_ = last_block;
				_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp20_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					_tmp21_ = self->priv->jump_stack;
					_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					i = _tmp23_ - 1;
					{
						gboolean _tmp24_ = FALSE;
						_tmp24_ = TRUE;
						while (TRUE) {
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp26_;
							gpointer _tmp27_;
							ValaFlowAnalyzerJumpTarget* _tmp28_;
							gboolean _tmp29_;
							gboolean _tmp30_;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = i;
								i = _tmp25_ - 1;
							}
							_tmp24_ = FALSE;
							if (!(i >= 0)) {
								break;
							}
							_tmp26_ = self->priv->jump_stack;
							_tmp27_ = vala_list_get (_tmp26_, i);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp27_;
							_tmp28_ = jump_target;
							_tmp29_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp28_);
							_tmp30_ = _tmp29_;
							if (_tmp30_) {
								ValaBasicBlock* _tmp31_;
								ValaFlowAnalyzerJumpTarget* _tmp32_;
								ValaBasicBlock* _tmp33_;
								ValaBasicBlock* _tmp34_;
								_tmp31_ = self->priv->current_block;
								_tmp32_ = jump_target;
								_tmp33_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp32_);
								_tmp34_ = _tmp33_;
								vala_basic_block_connect (_tmp31_, _tmp34_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp35_;
								gboolean _tmp36_;
								gboolean _tmp37_;
								_tmp35_ = jump_target;
								_tmp36_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp35_);
								_tmp37_ = _tmp36_;
								if (_tmp37_) {
									ValaCodeContext* _tmp38_;
									ValaProfile _tmp39_;
									ValaProfile _tmp40_;
									_tmp38_ = self->priv->context;
									_tmp39_ = vala_code_context_get_profile (_tmp38_);
									_tmp40_ = _tmp39_;
									if (_tmp40_ == VALA_PROFILE_GOBJECT) {
										gboolean _tmp41_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp42_;
										ValaErrorDomain* _tmp43_;
										ValaErrorDomain* _tmp44_;
										_tmp42_ = jump_target;
										_tmp43_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp42_);
										_tmp44_ = _tmp43_;
										if (_tmp44_ == NULL) {
											_tmp41_ = TRUE;
										} else {
											gboolean _tmp45_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp46_;
											ValaErrorDomain* _tmp47_;
											ValaErrorDomain* _tmp48_;
											ValaErrorType* _tmp49_;
											ValaErrorDomain* _tmp50_;
											ValaErrorDomain* _tmp51_;
											_tmp46_ = jump_target;
											_tmp47_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp46_);
											_tmp48_ = _tmp47_;
											_tmp49_ = error_type;
											_tmp50_ = vala_error_type_get_error_domain (_tmp49_);
											_tmp51_ = _tmp50_;
											if (_tmp48_ == _tmp51_) {
												gboolean _tmp52_ = FALSE;
												ValaFlowAnalyzerJumpTarget* _tmp53_;
												ValaErrorCode* _tmp54_;
												ValaErrorCode* _tmp55_;
												_tmp53_ = jump_target;
												_tmp54_ = vala_flow_analyzer_jump_target_get_error_code (_tmp53_);
												_tmp55_ = _tmp54_;
												if (_tmp55_ == NULL) {
													_tmp52_ = TRUE;
												} else {
													ValaFlowAnalyzerJumpTarget* _tmp56_;
													ValaErrorCode* _tmp57_;
													ValaErrorCode* _tmp58_;
													ValaErrorType* _tmp59_;
													ValaErrorCode* _tmp60_;
													ValaErrorCode* _tmp61_;
													_tmp56_ = jump_target;
													_tmp57_ = vala_flow_analyzer_jump_target_get_error_code (_tmp56_);
													_tmp58_ = _tmp57_;
													_tmp59_ = error_type;
													_tmp60_ = vala_error_type_get_error_code (_tmp59_);
													_tmp61_ = _tmp60_;
													_tmp52_ = _tmp58_ == _tmp61_;
												}
												_tmp45_ = _tmp52_;
											} else {
												_tmp45_ = FALSE;
											}
											_tmp41_ = _tmp45_;
										}
										if (_tmp41_) {
											ValaBasicBlock* _tmp62_;
											ValaFlowAnalyzerJumpTarget* _tmp63_;
											ValaBasicBlock* _tmp64_;
											ValaBasicBlock* _tmp65_;
											_tmp62_ = self->priv->current_block;
											_tmp63_ = jump_target;
											_tmp64_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp63_);
											_tmp65_ = _tmp64_;
											vala_basic_block_connect (_tmp62_, _tmp65_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											gboolean _tmp66_ = FALSE;
											ValaErrorType* _tmp67_;
											ValaErrorDomain* _tmp68_;
											ValaErrorDomain* _tmp69_;
											_tmp67_ = error_type;
											_tmp68_ = vala_error_type_get_error_domain (_tmp67_);
											_tmp69_ = _tmp68_;
											if (_tmp69_ == NULL) {
												_tmp66_ = TRUE;
											} else {
												gboolean _tmp70_ = FALSE;
												ValaErrorType* _tmp71_;
												ValaErrorDomain* _tmp72_;
												ValaErrorDomain* _tmp73_;
												ValaFlowAnalyzerJumpTarget* _tmp74_;
												ValaErrorDomain* _tmp75_;
												ValaErrorDomain* _tmp76_;
												_tmp71_ = error_type;
												_tmp72_ = vala_error_type_get_error_domain (_tmp71_);
												_tmp73_ = _tmp72_;
												_tmp74_ = jump_target;
												_tmp75_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp74_);
												_tmp76_ = _tmp75_;
												if (_tmp73_ == _tmp76_) {
													gboolean _tmp77_ = FALSE;
													ValaErrorType* _tmp78_;
													ValaErrorCode* _tmp79_;
													ValaErrorCode* _tmp80_;
													_tmp78_ = error_type;
													_tmp79_ = vala_error_type_get_error_code (_tmp78_);
													_tmp80_ = _tmp79_;
													if (_tmp80_ == NULL) {
														_tmp77_ = TRUE;
													} else {
														ValaErrorType* _tmp81_;
														ValaErrorCode* _tmp82_;
														ValaErrorCode* _tmp83_;
														ValaFlowAnalyzerJumpTarget* _tmp84_;
														ValaErrorCode* _tmp85_;
														ValaErrorCode* _tmp86_;
														_tmp81_ = error_type;
														_tmp82_ = vala_error_type_get_error_code (_tmp81_);
														_tmp83_ = _tmp82_;
														_tmp84_ = jump_target;
														_tmp85_ = vala_flow_analyzer_jump_target_get_error_code (_tmp84_);
														_tmp86_ = _tmp85_;
														_tmp77_ = _tmp83_ == _tmp86_;
													}
													_tmp70_ = _tmp77_;
												} else {
													_tmp70_ = FALSE;
												}
												_tmp66_ = _tmp70_;
											}
											if (_tmp66_) {
												ValaBasicBlock* _tmp87_;
												ValaFlowAnalyzerJumpTarget* _tmp88_;
												ValaBasicBlock* _tmp89_;
												ValaBasicBlock* _tmp90_;
												_tmp87_ = self->priv->current_block;
												_tmp88_ = jump_target;
												_tmp89_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp88_);
												_tmp90_ = _tmp89_;
												vala_basic_block_connect (_tmp87_, _tmp90_);
											}
										}
									} else {
										gboolean _tmp91_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp92_;
										ValaClass* _tmp93_;
										ValaClass* _tmp94_;
										_tmp92_ = jump_target;
										_tmp93_ = vala_flow_analyzer_jump_target_get_error_class (_tmp92_);
										_tmp94_ = _tmp93_;
										if (_tmp94_ == NULL) {
											_tmp91_ = TRUE;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp95_;
											ValaClass* _tmp96_;
											ValaClass* _tmp97_;
											ValaClass* _tmp98_;
											_tmp95_ = jump_target;
											_tmp96_ = vala_flow_analyzer_jump_target_get_error_class (_tmp95_);
											_tmp97_ = _tmp96_;
											_tmp98_ = error_class;
											_tmp91_ = _tmp97_ == _tmp98_;
										}
										if (_tmp91_) {
											ValaBasicBlock* _tmp99_;
											ValaFlowAnalyzerJumpTarget* _tmp100_;
											ValaBasicBlock* _tmp101_;
											ValaBasicBlock* _tmp102_;
											_tmp99_ = self->priv->current_block;
											_tmp100_ = jump_target;
											_tmp101_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp100_);
											_tmp102_ = _tmp101_;
											vala_basic_block_connect (_tmp99_, _tmp102_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp103_;
											ValaClass* _tmp104_;
											ValaClass* _tmp105_;
											ValaClass* _tmp106_;
											_tmp103_ = jump_target;
											_tmp104_ = vala_flow_analyzer_jump_target_get_error_class (_tmp103_);
											_tmp105_ = _tmp104_;
											_tmp106_ = error_class;
											if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp105_, (ValaTypeSymbol*) _tmp106_)) {
												ValaBasicBlock* _tmp107_;
												ValaFlowAnalyzerJumpTarget* _tmp108_;
												ValaBasicBlock* _tmp109_;
												ValaBasicBlock* _tmp110_;
												_tmp107_ = self->priv->current_block;
												_tmp108_ = jump_target;
												_tmp109_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp108_);
												_tmp110_ = _tmp109_;
												vala_basic_block_connect (_tmp107_, _tmp110_);
											}
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp111_;
									gboolean _tmp112_;
									gboolean _tmp113_;
									_tmp111_ = jump_target;
									_tmp112_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp111_);
									_tmp113_ = _tmp112_;
									if (_tmp113_) {
										ValaBasicBlock* _tmp114_;
										ValaFlowAnalyzerJumpTarget* _tmp115_;
										ValaBasicBlock* _tmp116_;
										ValaBasicBlock* _tmp117_;
										ValaFlowAnalyzerJumpTarget* _tmp118_;
										ValaBasicBlock* _tmp119_;
										ValaBasicBlock* _tmp120_;
										ValaBasicBlock* _tmp121_;
										_tmp114_ = self->priv->current_block;
										_tmp115_ = jump_target;
										_tmp116_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp115_);
										_tmp117_ = _tmp116_;
										vala_basic_block_connect (_tmp114_, _tmp117_);
										_tmp118_ = jump_target;
										_tmp119_ = vala_flow_analyzer_jump_target_get_last_block (_tmp118_);
										_tmp120_ = _tmp119_;
										_tmp121_ = _vala_basic_block_ref0 (_tmp120_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp121_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_data_type);
			}
		}
		if (!always_fail) {
			ValaBasicBlock* _tmp122_;
			ValaSet* _tmp123_;
			ValaBasicBlock* _tmp124_;
			ValaBasicBlock* _tmp125_;
			ValaBasicBlock* _tmp126_;
			_tmp122_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp122_;
			_tmp123_ = self->priv->all_basic_blocks;
			_tmp124_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp123_, _tmp124_);
			_tmp125_ = last_block;
			_tmp126_ = self->priv->current_block;
			vala_basic_block_connect (_tmp125_, _tmp126_);
		}
		_vala_iterable_unref0 (error_types);
		_vala_basic_block_unref0 (last_block);
	}
}

static void
vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                               ValaYieldStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaSet* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* finally_block = NULL;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	ValaList* catch_clauses = NULL;
	ValaList* _tmp41_;
	ValaList* _tmp42_;
	ValaBasicBlock* _tmp95_;
	ValaBasicBlock* _tmp96_;
	ValaBlock* _tmp97_;
	ValaBlock* _tmp98_;
	ValaBasicBlock* _tmp99_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp107_;
	ValaArrayList* _tmp108_;
	ValaBasicBlock* _tmp194_;
	ValaBasicBlock* _tmp201_;
	ValaList* _tmp202_;
	gint _tmp203_;
	gint _tmp204_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	before_try_block = _tmp1_;
	_tmp2_ = vala_basic_block_new ();
	after_try_block = _tmp2_;
	_tmp3_ = self->priv->all_basic_blocks;
	_tmp4_ = after_try_block;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp4_);
	finally_block = NULL;
	_tmp5_ = vala_try_statement_get_finally_body (stmt);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaBasicBlock* _tmp7_;
		ValaSet* _tmp8_;
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp12_;
		ValaSet* _tmp13_;
		ValaBasicBlock* _tmp14_;
		ValaList* _tmp15_;
		ValaBasicBlock* _tmp16_;
		ValaFlowAnalyzerJumpTarget* _tmp17_;
		ValaFlowAnalyzerJumpTarget* _tmp18_;
		ValaBlock* _tmp19_;
		ValaBlock* _tmp20_;
		ValaBasicBlock* _tmp21_;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		ValaList* _tmp27_;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gpointer _tmp31_;
		ValaFlowAnalyzerJumpTarget* _tmp32_;
		ValaList* _tmp33_;
		ValaBasicBlock* _tmp34_;
		ValaBasicBlock* _tmp35_;
		ValaFlowAnalyzerJumpTarget* _tmp36_;
		ValaFlowAnalyzerJumpTarget* _tmp37_;
		_tmp7_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp7_;
		_tmp8_ = self->priv->all_basic_blocks;
		_tmp9_ = finally_block;
		vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
		_tmp10_ = finally_block;
		_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp11_;
		_tmp12_ = vala_basic_block_new ();
		invalid_block = _tmp12_;
		_tmp13_ = self->priv->all_basic_blocks;
		_tmp14_ = invalid_block;
		vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		_tmp15_ = self->priv->jump_stack;
		_tmp16_ = invalid_block;
		_tmp17_ = vala_flow_analyzer_jump_target_new_any_target (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
		_tmp19_ = vala_try_statement_get_finally_body (stmt);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
		_tmp21_ = invalid_block;
		_tmp22_ = vala_basic_block_get_predecessors (_tmp21_);
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ > 0) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "jump out of finally block not permitted");
			vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp27_ = self->priv->jump_stack;
		_tmp28_ = self->priv->jump_stack;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_list_remove_at (_tmp27_, _tmp30_ - 1);
		_tmp32_ = (ValaFlowAnalyzerJumpTarget*) _tmp31_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp32_);
		_tmp33_ = self->priv->jump_stack;
		_tmp34_ = finally_block;
		_tmp35_ = self->priv->current_block;
		_tmp36_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp34_, _tmp35_);
		_tmp37_ = _tmp36_;
		vala_collection_add ((ValaCollection*) _tmp33_, _tmp37_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp37_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	finally_jump_stack_size = _tmp40_;
	_tmp41_ = vala_try_statement_get_catch_clauses (stmt);
	_tmp42_ = _vala_iterable_ref0 (_tmp41_);
	catch_clauses = _tmp42_;
	{
		gint i = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp43_ = catch_clauses;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		i = _tmp45_ - 1;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaBasicBlock* error_block = NULL;
				ValaBasicBlock* _tmp50_;
				ValaSet* _tmp51_;
				ValaBasicBlock* _tmp52_;
				gboolean _tmp53_ = FALSE;
				ValaCatchClause* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ - 1;
				}
				_tmp46_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp48_ = catch_clauses;
				_tmp49_ = vala_list_get (_tmp48_, i);
				catch_clause = (ValaCatchClause*) _tmp49_;
				_tmp50_ = vala_basic_block_new ();
				error_block = _tmp50_;
				_tmp51_ = self->priv->all_basic_blocks;
				_tmp52_ = error_block;
				vala_collection_add ((ValaCollection*) _tmp51_, _tmp52_);
				_tmp54_ = catch_clause;
				_tmp55_ = vala_catch_clause_get_error_type (_tmp54_);
				_tmp56_ = _tmp55_;
				if (_tmp56_ != NULL) {
					ValaCatchClause* _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					_tmp57_ = catch_clause;
					_tmp58_ = vala_code_node_get_error ((ValaCodeNode*) _tmp57_);
					_tmp59_ = _tmp58_;
					_tmp53_ = !_tmp59_;
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					ValaCodeContext* _tmp60_;
					ValaProfile _tmp61_;
					ValaProfile _tmp62_;
					_tmp60_ = self->priv->context;
					_tmp61_ = vala_code_context_get_profile (_tmp60_);
					_tmp62_ = _tmp61_;
					if (_tmp62_ == VALA_PROFILE_GOBJECT) {
						ValaErrorType* error_type = NULL;
						ValaCatchClause* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						ValaList* _tmp66_;
						ValaBasicBlock* _tmp67_;
						ValaCatchClause* _tmp68_;
						ValaCatchClause* _tmp69_;
						ValaDataType* _tmp70_;
						ValaDataType* _tmp71_;
						ValaTypeSymbol* _tmp72_;
						ValaTypeSymbol* _tmp73_;
						ValaErrorType* _tmp74_;
						ValaErrorCode* _tmp75_;
						ValaErrorCode* _tmp76_;
						ValaFlowAnalyzerJumpTarget* _tmp77_;
						ValaFlowAnalyzerJumpTarget* _tmp78_;
						_tmp63_ = catch_clause;
						_tmp64_ = vala_catch_clause_get_error_type (_tmp63_);
						_tmp65_ = _tmp64_;
						error_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_ERROR_TYPE, ValaErrorType);
						_tmp66_ = self->priv->jump_stack;
						_tmp67_ = error_block;
						_tmp68_ = catch_clause;
						_tmp69_ = catch_clause;
						_tmp70_ = vala_catch_clause_get_error_type (_tmp69_);
						_tmp71_ = _tmp70_;
						_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = error_type;
						_tmp75_ = vala_error_type_get_error_code (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = vala_flow_analyzer_jump_target_new_error_target (_tmp67_, _tmp68_, VALA_IS_ERROR_DOMAIN (_tmp73_) ? ((ValaErrorDomain*) _tmp73_) : NULL, _tmp76_, NULL);
						_tmp78_ = _tmp77_;
						vala_collection_add ((ValaCollection*) _tmp66_, _tmp78_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp78_);
					} else {
						ValaClass* error_class = NULL;
						ValaCatchClause* _tmp79_;
						ValaDataType* _tmp80_;
						ValaDataType* _tmp81_;
						ValaTypeSymbol* _tmp82_;
						ValaTypeSymbol* _tmp83_;
						ValaList* _tmp84_;
						ValaBasicBlock* _tmp85_;
						ValaCatchClause* _tmp86_;
						ValaClass* _tmp87_;
						ValaFlowAnalyzerJumpTarget* _tmp88_;
						ValaFlowAnalyzerJumpTarget* _tmp89_;
						_tmp79_ = catch_clause;
						_tmp80_ = vala_catch_clause_get_error_type (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = vala_data_type_get_type_symbol (_tmp81_);
						_tmp83_ = _tmp82_;
						error_class = VALA_IS_CLASS (_tmp83_) ? ((ValaClass*) _tmp83_) : NULL;
						_tmp84_ = self->priv->jump_stack;
						_tmp85_ = error_block;
						_tmp86_ = catch_clause;
						_tmp87_ = error_class;
						_tmp88_ = vala_flow_analyzer_jump_target_new_error_target (_tmp85_, _tmp86_, NULL, NULL, _tmp87_);
						_tmp89_ = _tmp88_;
						vala_collection_add ((ValaCollection*) _tmp84_, _tmp89_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp89_);
					}
				} else {
					ValaList* _tmp90_;
					ValaBasicBlock* _tmp91_;
					ValaCatchClause* _tmp92_;
					ValaFlowAnalyzerJumpTarget* _tmp93_;
					ValaFlowAnalyzerJumpTarget* _tmp94_;
					_tmp90_ = self->priv->jump_stack;
					_tmp91_ = error_block;
					_tmp92_ = catch_clause;
					_tmp93_ = vala_flow_analyzer_jump_target_new_error_target (_tmp91_, _tmp92_, NULL, NULL, NULL);
					_tmp94_ = _tmp93_;
					vala_collection_add ((ValaCollection*) _tmp90_, _tmp94_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp94_);
				}
				_vala_basic_block_unref0 (error_block);
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp95_ = before_try_block;
	_tmp96_ = _vala_basic_block_ref0 (_tmp95_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp96_;
	_tmp97_ = vala_try_statement_get_body (stmt);
	_tmp98_ = _tmp97_;
	vala_code_node_accept ((ValaCodeNode*) _tmp98_, (ValaCodeVisitor*) self);
	_tmp99_ = self->priv->current_block;
	if (_tmp99_ != NULL) {
		ValaBasicBlock* _tmp100_;
		ValaBasicBlock* _tmp105_;
		ValaBasicBlock* _tmp106_;
		_tmp100_ = finally_block;
		if (_tmp100_ != NULL) {
			ValaBasicBlock* _tmp101_;
			ValaBasicBlock* _tmp102_;
			ValaBasicBlock* _tmp103_;
			ValaBasicBlock* _tmp104_;
			_tmp101_ = self->priv->current_block;
			_tmp102_ = finally_block;
			vala_basic_block_connect (_tmp101_, _tmp102_);
			_tmp103_ = finally_block;
			_tmp104_ = _vala_basic_block_ref0 (_tmp103_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp104_;
		}
		_tmp105_ = self->priv->current_block;
		_tmp106_ = after_try_block;
		vala_basic_block_connect (_tmp105_, _tmp106_);
	}
	_tmp107_ = g_direct_equal;
	_tmp108_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp107_);
	catch_stack = (ValaList*) _tmp108_;
	{
		gint i = 0;
		ValaList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		_tmp109_ = self->priv->jump_stack;
		_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		i = _tmp111_ - 1;
		{
			gboolean _tmp112_ = FALSE;
			_tmp112_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp114_;
				gpointer _tmp115_;
				ValaList* _tmp116_;
				ValaFlowAnalyzerJumpTarget* _tmp117_;
				if (!_tmp112_) {
					gint _tmp113_;
					_tmp113_ = i;
					i = _tmp113_ - 1;
				}
				_tmp112_ = FALSE;
				if (!(i >= finally_jump_stack_size)) {
					break;
				}
				_tmp114_ = self->priv->jump_stack;
				_tmp115_ = vala_list_remove_at (_tmp114_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp115_;
				_tmp116_ = catch_stack;
				_tmp117_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp116_, _tmp117_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp118_;
		gint _jump_target_size = 0;
		ValaList* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
		gint _jump_target_index = 0;
		_tmp118_ = catch_stack;
		_jump_target_list = _tmp118_;
		_tmp119_ = _jump_target_list;
		_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
		_tmp121_ = _tmp120_;
		_jump_target_size = _tmp121_;
		_jump_target_index = -1;
		while (TRUE) {
			gint _tmp122_;
			gint _tmp123_;
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp124_;
			gpointer _tmp125_;
			ValaFlowAnalyzerJumpTarget* _tmp162_;
			ValaBasicBlock* _tmp163_;
			ValaBasicBlock* _tmp164_;
			ValaList* _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			_jump_target_index = _jump_target_index + 1;
			_tmp122_ = _jump_target_index;
			_tmp123_ = _jump_target_size;
			if (!(_tmp122_ < _tmp123_)) {
				break;
			}
			_tmp124_ = _jump_target_list;
			_tmp125_ = vala_list_get (_tmp124_, _jump_target_index);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp125_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp126_;
				gint _prev_target_size = 0;
				ValaList* _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				gint _prev_target_index = 0;
				_tmp126_ = catch_stack;
				_prev_target_list = _tmp126_;
				_tmp127_ = _prev_target_list;
				_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
				_tmp129_ = _tmp128_;
				_prev_target_size = _tmp129_;
				_prev_target_index = -1;
				while (TRUE) {
					gint _tmp130_;
					gint _tmp131_;
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp132_;
					gpointer _tmp133_;
					ValaFlowAnalyzerJumpTarget* _tmp134_;
					ValaFlowAnalyzerJumpTarget* _tmp135_;
					ValaCodeContext* _tmp136_;
					ValaProfile _tmp137_;
					ValaProfile _tmp138_;
					_prev_target_index = _prev_target_index + 1;
					_tmp130_ = _prev_target_index;
					_tmp131_ = _prev_target_size;
					if (!(_tmp130_ < _tmp131_)) {
						break;
					}
					_tmp132_ = _prev_target_list;
					_tmp133_ = vala_list_get (_tmp132_, _prev_target_index);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp133_;
					_tmp134_ = prev_target;
					_tmp135_ = jump_target;
					if (_tmp134_ == _tmp135_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp136_ = self->priv->context;
					_tmp137_ = vala_code_context_get_profile (_tmp136_);
					_tmp138_ = _tmp137_;
					if (_tmp138_ == VALA_PROFILE_GOBJECT) {
						gboolean _tmp139_ = FALSE;
						ValaFlowAnalyzerJumpTarget* _tmp140_;
						ValaErrorDomain* _tmp141_;
						ValaErrorDomain* _tmp142_;
						ValaFlowAnalyzerJumpTarget* _tmp143_;
						ValaErrorDomain* _tmp144_;
						ValaErrorDomain* _tmp145_;
						_tmp140_ = prev_target;
						_tmp141_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp140_);
						_tmp142_ = _tmp141_;
						_tmp143_ = jump_target;
						_tmp144_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp143_);
						_tmp145_ = _tmp144_;
						if (_tmp142_ == _tmp145_) {
							ValaFlowAnalyzerJumpTarget* _tmp146_;
							ValaErrorCode* _tmp147_;
							ValaErrorCode* _tmp148_;
							ValaFlowAnalyzerJumpTarget* _tmp149_;
							ValaErrorCode* _tmp150_;
							ValaErrorCode* _tmp151_;
							_tmp146_ = prev_target;
							_tmp147_ = vala_flow_analyzer_jump_target_get_error_code (_tmp146_);
							_tmp148_ = _tmp147_;
							_tmp149_ = jump_target;
							_tmp150_ = vala_flow_analyzer_jump_target_get_error_code (_tmp149_);
							_tmp151_ = _tmp150_;
							_tmp139_ = _tmp148_ == _tmp151_;
						} else {
							_tmp139_ = FALSE;
						}
						if (_tmp139_) {
							ValaSourceReference* _tmp152_;
							ValaSourceReference* _tmp153_;
							_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp153_ = _tmp152_;
							vala_report_error (_tmp153_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					} else {
						ValaFlowAnalyzerJumpTarget* _tmp154_;
						ValaClass* _tmp155_;
						ValaClass* _tmp156_;
						ValaFlowAnalyzerJumpTarget* _tmp157_;
						ValaClass* _tmp158_;
						ValaClass* _tmp159_;
						_tmp154_ = prev_target;
						_tmp155_ = vala_flow_analyzer_jump_target_get_error_class (_tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = jump_target;
						_tmp158_ = vala_flow_analyzer_jump_target_get_error_class (_tmp157_);
						_tmp159_ = _tmp158_;
						if (_tmp156_ == _tmp159_) {
							ValaSourceReference* _tmp160_;
							ValaSourceReference* _tmp161_;
							_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp161_ = _tmp160_;
							vala_report_error (_tmp161_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
			}
			_tmp162_ = jump_target;
			_tmp163_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = vala_basic_block_get_predecessors (_tmp164_);
			_tmp166_ = vala_collection_get_size ((ValaCollection*) _tmp165_);
			_tmp167_ = _tmp166_;
			if (_tmp167_ == 0) {
				ValaFlowAnalyzerJumpTarget* _tmp168_;
				ValaCatchClause* _tmp169_;
				ValaCatchClause* _tmp170_;
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				_tmp168_ = jump_target;
				_tmp169_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp170_);
				_tmp172_ = _tmp171_;
				vala_report_warning (_tmp172_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp173_;
				ValaBasicBlock* _tmp174_;
				ValaBasicBlock* _tmp175_;
				ValaBasicBlock* _tmp176_;
				ValaBasicBlock* _tmp177_;
				ValaFlowAnalyzerJumpTarget* _tmp178_;
				ValaCatchClause* _tmp179_;
				ValaCatchClause* _tmp180_;
				ValaFlowAnalyzerJumpTarget* _tmp181_;
				ValaCatchClause* _tmp182_;
				ValaCatchClause* _tmp183_;
				ValaBlock* _tmp184_;
				ValaBlock* _tmp185_;
				ValaBasicBlock* _tmp186_;
				_tmp173_ = jump_target;
				_tmp174_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = _vala_basic_block_ref0 (_tmp175_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp176_;
				_tmp177_ = self->priv->current_block;
				_tmp178_ = jump_target;
				_tmp179_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_basic_block_add_node (_tmp177_, (ValaCodeNode*) _tmp180_);
				_tmp181_ = jump_target;
				_tmp182_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_catch_clause_get_body (_tmp183_);
				_tmp185_ = _tmp184_;
				vala_code_node_accept ((ValaCodeNode*) _tmp185_, (ValaCodeVisitor*) self);
				_tmp186_ = self->priv->current_block;
				if (_tmp186_ != NULL) {
					ValaBasicBlock* _tmp187_;
					ValaBasicBlock* _tmp192_;
					ValaBasicBlock* _tmp193_;
					_tmp187_ = finally_block;
					if (_tmp187_ != NULL) {
						ValaBasicBlock* _tmp188_;
						ValaBasicBlock* _tmp189_;
						ValaBasicBlock* _tmp190_;
						ValaBasicBlock* _tmp191_;
						_tmp188_ = self->priv->current_block;
						_tmp189_ = finally_block;
						vala_basic_block_connect (_tmp188_, _tmp189_);
						_tmp190_ = finally_block;
						_tmp191_ = _vala_basic_block_ref0 (_tmp190_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp191_;
					}
					_tmp192_ = self->priv->current_block;
					_tmp193_ = after_try_block;
					vala_basic_block_connect (_tmp192_, _tmp193_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
	}
	_tmp194_ = finally_block;
	if (_tmp194_ != NULL) {
		ValaList* _tmp195_;
		ValaList* _tmp196_;
		gint _tmp197_;
		gint _tmp198_;
		gpointer _tmp199_;
		ValaFlowAnalyzerJumpTarget* _tmp200_;
		_tmp195_ = self->priv->jump_stack;
		_tmp196_ = self->priv->jump_stack;
		_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
		_tmp198_ = _tmp197_;
		_tmp199_ = vala_list_remove_at (_tmp195_, _tmp198_ - 1);
		_tmp200_ = (ValaFlowAnalyzerJumpTarget*) _tmp199_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp200_);
	}
	_tmp201_ = after_try_block;
	_tmp202_ = vala_basic_block_get_predecessors (_tmp201_);
	_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
	_tmp204_ = _tmp203_;
	if (_tmp204_ > 0) {
		ValaBasicBlock* _tmp205_;
		ValaBasicBlock* _tmp206_;
		_tmp205_ = after_try_block;
		_tmp206_ = _vala_basic_block_ref0 (_tmp205_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp206_;
	} else {
		vala_try_statement_set_after_try_block_reachable (stmt, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}

static void
vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                              ValaLockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}

static void
vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                ValaUnlockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}

static void
vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                          ValaExpression* expr)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	if (!VALA_IS_LAMBDA_EXPRESSION (expr)) {
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
	}
}

static gboolean
vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                ValaCodeNode* node)
{
	ValaBasicBlock* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		vala_code_node_set_unreachable (node, TRUE);
		if (!self->priv->unreachable_reported) {
			ValaSourceReference* _tmp1_;
			ValaSourceReference* _tmp2_;
			_tmp1_ = vala_code_node_get_source_reference (node);
			_tmp2_ = _tmp1_;
			vala_report_warning (_tmp2_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self)
{
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}

static inline gpointer
vala_flow_analyzer_jump_target_get_instance_private (ValaFlowAnalyzerJumpTarget* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzerJumpTarget_private_offset);
}

static gboolean
vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_break_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_break_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_continue_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_continue_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_return_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_return_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_exit_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_exit_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_error_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_error_target = value;
}

static ValaErrorDomain*
vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaErrorDomain* value)
{
	ValaErrorDomain* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp0_;
}

static ValaErrorCode*
vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                               ValaErrorCode* value)
{
	ValaErrorCode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp0_;
}

static ValaClass*
vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp0_;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_finally_clause;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_finally_clause = value;
}

static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp0_;
}

static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                               ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp0_;
}

static ValaCatchClause*
vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self)
{
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaCatchClause* value)
{
	ValaCatchClause* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp0_;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                       ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                          ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                        ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                      ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                       ValaBasicBlock* basic_block,
                                                       ValaCatchClause* catch_clause,
                                                       ValaErrorDomain* error_domain,
                                                       ValaErrorCode* error_code,
                                                       ValaClass* error_class)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_catch_clause (self, catch_clause);
	vala_flow_analyzer_jump_target_set_error_domain (self, error_domain);
	vala_flow_analyzer_jump_target_set_error_code (self, error_code);
	vala_flow_analyzer_jump_target_set_error_class (self, error_class);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                 ValaCatchClause* catch_clause,
                                                 ValaErrorDomain* error_domain,
                                                 ValaErrorCode* error_code,
                                                 ValaClass* error_class)
{
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                     ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                         ValaBasicBlock* basic_block,
                                                         ValaBasicBlock* last_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_last_block (self, last_block);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                   ValaBasicBlock* last_block)
{
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct (GType object_type)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new (void)
{
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}

static void
vala_flow_analyzer_value_jump_target_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_flow_analyzer_value_jump_target_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}

static void
vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_flow_analyzer_value_jump_target_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_flow_analyzer_value_get_jump_target (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}

static void
vala_flow_analyzer_value_set_jump_target (GValue* value,
                                          gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}

static void
vala_flow_analyzer_value_take_jump_target (GValue* value,
                                           gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}

static void
vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass,
                                           gpointer klass_data)
{
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzerJumpTarget_private_offset);
}

static void
vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self,
                                              gpointer klass)
{
	self->priv = vala_flow_analyzer_jump_target_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}

static GType
vala_flow_analyzer_jump_target_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_flow_analyzer_jump_target_type_id;
	vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaFlowAnalyzerJumpTarget_private_offset = g_type_add_instance_private (vala_flow_analyzer_jump_target_type_id, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
	return vala_flow_analyzer_jump_target_type_id;
}

static GType
vala_flow_analyzer_jump_target_get_type (void)
{
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = vala_flow_analyzer_jump_target_get_type_once ();
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}

static gpointer
vala_flow_analyzer_jump_target_ref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_flow_analyzer_jump_target_unref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass,
                               gpointer klass_data)
{
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzer_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor*, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor*, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor*, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor*, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor*, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_with_statement = (void (*) (ValaCodeVisitor*, ValaWithStatement*)) vala_flow_analyzer_real_visit_with_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor*, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor*, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop_statement = (void (*) (ValaCodeVisitor*, ValaLoopStatement*)) vala_flow_analyzer_real_visit_loop_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor*, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor*, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor*, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor*, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor*, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor*, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor*, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor*, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}

static void
vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_flow_analyzer_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}

static void
vala_flow_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}

/**
 * Code visitor building the control flow graph.
 */
static GType
vala_flow_analyzer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
	GType vala_flow_analyzer_type_id;
	vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
	ValaFlowAnalyzer_private_offset = g_type_add_instance_private (vala_flow_analyzer_type_id, sizeof (ValaFlowAnalyzerPrivate));
	return vala_flow_analyzer_type_id;
}

GType
vala_flow_analyzer_get_type (void)
{
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = vala_flow_analyzer_get_type_once ();
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

