'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAddDeviceLedInfo __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddDeviceLedInfo \- Initialize an XkbDeviceLedInfoRec structure
.SH SYNOPSIS
.B XkbDeviceLedInfoPtr XkbAddDeviceLedInfo
(
.I device_info,
.I led_class,
.I led_id
)
.br
      XkbDeviceInfoPtr \fIdevice_info\fP\^;
.br
      unsigned int \fIled_class\fP\^;
.br
      unsigned int \fIled_id\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- device_info
structure in which to add LED info
.TP
.I \- led_class
input extension class for LED device of interest
.TP
.I \- led_id
input extension ID for LED device of interest
.SH DESCRIPTION
.LP
.I XkbAddDeviceLedInfo 
first checks to see whether an entry matching 
.I led_class 
and 
.I led_id 
already exists in the 
.I device_info->leds 
array. If it finds a matching entry, it returns a pointer to that entry. Otherwise, it checks to be sure 
there is at least one empty entry in
.I device_info->leds 
and extends it if there is not enough room. It then increments
.I device_info->num_leds 
and fills in the next available entry in 
.I device_info->leds 
with 
.I led_class 
and 
.I led_id.

If successful, 
.I XkbAddDeviceLedInfo 
returns a pointer to the XkbDeviceLedInfoRec structure that was initialized. If unable to allocate 
sufficient storage, or if 
.I device_info 
points to an invalid XkbDeviceInfoRec structure, or if 
.I led_class 
or 
.I led_id 
are inappropriate, 
.I XkbAddDeviceLedInfo 
returns NULL.

To allocate additional space for button actions in an XkbDeviceInfoRec structure, use 
.I XkbResizeDeviceButtonActions.

.SH STRUCTURES
.LP
Information about X Input Extension devices is transferred between a client program and the Xkb 
extension in an XkbDeviceInfoRec structure:
.nf

    typedef struct {
        char *               name;          /\(** name for device */
        Atom                 type;          /\(** name for class of devices */
        unsigned short       device_spec;   /\(** device of interest */
        Bool                 has_own_state; /\(** True=>this device has its own state */
        unsigned short       supported;     /\(** bits indicating supported capabilities */
        unsigned short       unsupported;   /\(** bits indicating unsupported capabilities */
        unsigned short       num_btns;      /\(** number of entries in btn_acts */
        XkbAction *          btn_acts;      /\(** button actions */
        unsigned short       sz_leds;       /\(** total number of entries in LEDs vector */
        unsigned short       num_leds;      /\(** number of valid entries in LEDs vector */
        unsigned short       dflt_kbd_fb;   /\(** input extension ID of default (core kbd) indicator */
        unsigned short       dflt_led_fb;   /\(** input extension ID of default indicator feedback */
        XkbDeviceLedInfoPtr  leds;          /\(** LED descriptions */
    } XkbDeviceInfoRec, *XkbDeviceInfoPtr;
    

    typedef struct {
        unsigned short      led_class;        /\(** class for this LED device*/
        unsigned short      led_id;           /\(** ID for this LED device */
        unsigned int        phys_indicators;  /\(** bits for which LEDs physically present */
        unsigned int        maps_present;     /\(** bits for which LEDs have maps in maps */
        unsigned int        names_present;    /\(** bits for which LEDs are in names */
        unsigned int        state;            /\(** 1 bit => corresponding LED is on */
        Atom                names[XkbNumIndicators];   /\(** names for LEDs */
        XkbIndicatorMapRec  maps;             /\(** indicator maps for each LED */
    } XkbDeviceLedInfoRec, *XkbDeviceLedInfoPtr;

.fi    
.SH "SEE ALSO"
.BR XkbResizeDeviceButtonActions (__libmansuffix__)
