#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xE4, 0x3C, 0x1D, 0xED, 0xF6, 0x22, 0xCB, 0x92, 0x44, 0x11, 
	0x4C, 0x3A, 0x33, 0xF5, 0xC5, 0xB0, 0xF8, 0x43, 0xE5, 0x02, 
	0xF7, 0x73, 0xA6, 0x18, 0xB5, 0xC8, 0x38, 0x79, 0x1C, 0x72, 
	0xE2, 0xDF, 0x65, 0xD0, 0x37, 0x25, 0x5B, 0x12, 0x0E, 0x8B, 
	0xA4, 0x60, 0xC1, 0xC6, 0x1D, 0x28, 0xC1, 0x8D, 0x0C, 0xCF, 
	0x6A, 0x7A, 0x97, 0x87, 0x00, 0xBA, 0x24, 0x2D, 0xE3, 0x8D, 
	0x1E, 0x0A, 0x70, 0x81, 0xCD, 0xE1, 0xF3, 0xD3, 0x21, 0x9B, 
	0xAA, 0x0F, 0x7F, 0x68, 0xA6, 0x43, 0xB0, 0xC7, 0x70, 0xAC, 
	0x6A, 0x5F, 0x52, 0xDB, 0x50, 0x2D, 0x06, 0xCB, 0x9A, 0x5C, 
	0x8B, 0x81, 0x05, 0x4B, 0xBB, 0x18, 0x21, 0x58, 0xC5, 0xA5, 
	0x14, 0xAF, 0xED, 0x34, 0x8A, 0x85, 0x5D, 0x94, 0x0E, 0x52, 
	0xBF, 0xAC, 0x13, 0x61, 0x9E, 0x2F, 0x04, 0x48, 0x1A, 0x98, 
	0x71, 0x6A, 0xF4, 0x60, 0x1B, 0x55, 0x7B, 0x53, 0x61, 0xDC, 
	0x12, 0x8D, 0x92, 0xBF, 0x0B, 0x21, 0xBF, 0x6F, 0x43, 0x21, 
	0x84, 0xC4, 0xC3, 0x0D, 0xD8, 0x71, 0x93, 0xD7, 0xE1, 0x6D, 
	0x40, 0xFA, 0x22, 0xD6, 0x69, 0xB8, 0x2E, 0x1E, 0xBB, 0xCC, 
	0x4A, 0x6B, 0xD5, 0x23, 0x72, 0x3F, 0x87, 0x94, 0xE0, 0x4D, 
	0x2A, 0x86, 0x49, 0x73, 0xC3, 0x32, 0xC2, 0xD3, 0x84, 0xB3, 
	0x46, 0x0C, 0x07, 0x3C, 0xA9, 0x1C, 0x3B, 0xF6, 0x3B, 0x8F, 
	0x89, 0xA8, 0xC5, 0x0B, 0x45, 0x41, 0x12, 0x01, 0xA3, 0x95, 
	0x00, 0x0A, 0xE8, 0x34, 0x41, 0x31, 0xD1, 0x30, 0x84, 0x3C, 
	0xBC, 0x17, 0x58, 0x51, 0xAC, 0xD2, 0xEF, 0xA7, 0xE4, 0xD5, 
	0x55, 0x51, 0xC5, 0x66, 0x18, 0xC1, 0x4C, 0xD5, 0xF4, 0x0F, 
	0xEE, 0x32, 0x12, 0xCD, 0x98, 0xA4, 0xA2, 0x77, 0x50, 0xF8, 
	0xBC, 0xF0, 0xD8, 0x3A, 0x4E, 0xE6, 0x54, 0xCD, 0xDE, 0xC4, 
	0x38, 0x18, 0x39, 0xD8, 0x3B, 0x6B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
