/*-
 * Copyright (c) 1991 by Patrick J. Naughton.
 * Copyright (c) 1997 by David Bagley.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Revision History:
 * 14-Feb-2003: Added many more lifeforms from Stephen Silver's Life Lexicon
 *              http://www.argentum.freeserve.co.uk/lex_home.htm
 * 25-Jan-2003: File spawned from life.c
 *
 */

/*-
 * neighbors of 0 does not randomize.  All inappropriate
 * modes will be set at 8.  3, 6, 9, & 12 also available.
 */

#define MAXNEIGHBORS 12
#define MAXGROUPS 3             /* Eventually this may be MAXNEIGHBORS - 3 */
#define FIRSTGROUP 2            /* Need at least 2 to make a group */
#define MAXCOUNTNEIGHBORS 9     /* This restriction is because of base 10 */
#define NEIGHBORKINDS 6
#define NUMPTS  64

typedef struct {
	int         survival, birth;
	int         survival_group[MAXGROUPS];
	int         birth_group[MAXGROUPS];
} paramstruct;

static char plots[NEIGHBORKINDS] =
{
	3, 4, 6, 8, 9, 12	/* Neighborhoods */
};

static char maxgroups[NEIGHBORKINDS] =
{0, 0, 3, 0, 0, 0};
static char groupnumber[NEIGHBORKINDS][MAXGROUPS] =
{
	{0, 0, 0},		/* Triangular */
	{0, 0, 0},		/* Future improvement */
	{3, 3, 3},		/* Hexagonal */
	{0, 0, 0},		/* Maxgroup will expand... */
	{0, 0, 0},		/* Future improvement */
	{0, 0, 0}		/* Future improvement */
};

static char style6[64] =
{0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 1, 1, 0, 1, 0, 0,
 0, 1, 2, 1, 1, 2, 1, 1, 0, 1, 1, 2, 0, 1, 0, 0,
 0, 0, 1, 0, 2, 1, 1, 0, 1, 1, 2, 1, 1, 2, 1, 0,
 0, 0, 1, 0, 1, 1, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0};


/*-
 * Patterns have < NUMPTS pts (and should have a size of <= 32x32,
 * the Glider Gun is an exception)
 */
static char patterns_8S23B3_6[][2 * NUMPTS + 1] =
{
	{		/* almosymmetric, clock (flywheel), blinker (p2) */
		-1, -4,
		-1, -3, 1, -3,
		-3, -2,
		2, -1, 3, -1,
		-4, 0, -3, 0,
		2, 1,
		-2, 2, 0, 2,
		0, 3,

		5, 3,
		3, 4, 4, 4,
		5, 5, 6, 5,
		4, 6,

		8, 0,
		8, 1,
		8, 2,
		127
	},
	{		/* baker (c p4 fuse) */
		6, -7, 7, -7,
		5, -6, 7, -6,
		4, -5,
		3, -4,
		2, -3,
		1, -2,
		0, -1,
		-1, 0,
		-2, 1,
		-3, 2,
		-4, 3,
		-5, 4,
		-8, 5, -7, 5, -6, 5,
		-7, 6,
		127
	},
	{		/* barber's pole (p2) */
		-6, -6, -5, -6,
		-6, -5, -4, -5,
		-4, -3, -2, -3,
		-2, -1, 0, -1,
		0, 1, 2, 1,
		2, 3, 4, 3,
		5, 4,
		4, 5, 5, 5,
		127
	},
	{		/* bent keys (p3), from Lexicon */
		-5, -2, 4, -2,
		-6, -1, -4, -1, 3, -1, 5, -1,
		-5, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-2, 1, 1, 1,
		-2, 2, 1, 2,
		127
	},
	{		/* blinkers bit pole (p2), from Lexicon */
		2, -3, 3, -3,
		-3, -2, -2, -2, -1, -2, 1, -2, 3, -2,
		-2, 0, 0, 0, 3, 0,
		-3, 1, 2, 1,
		-3, 2, -2, 2, 2, 2,
		127
	},
	{		/* boat maker (c p4 fuse) */
		7, -8, 8, -8,
		6, -7, 8, -7,
		5, -6,
		4, -5,
		3, -4,
		2, -3,
		1, -2,
		0, -1,
		-1, 0,
		-2, 1,
		-3, 2,
		-4, 3,
		-9, 4, -8, 4, -7, 4, -6, 4, -5, 4,
		-5, 5,
		-5, 6,
		-5, 7,
		-5, 8,
		127
	},
	{		/* by flops (p2), from Lexicon */
		0, -3,
		-2, -2, 0, -2,
		2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0,
		2, 1,
		-2, 2, 0, 2,
		0, 3,
		127
	},
	{		/* candlefrobra (p3), from Lexicon */
		0, -2,
		-4, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1,
		-5, 0, -3, 0, 1, 0, 3, 0, 4, 0,
		-4, 1, 1, 1,
		0, 2, 1, 2,
		127
	},
	{		/* clock II (p4) */
		-2, -6, -1, -6,
		-2, -5, -1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-6, -2, -5, -2, -3, -2, 0, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, -1, -1, 2, -1,
		-3, 0, -1, 0, 2, 0, 4, 0, 5, 0,
		-3, 1, 2, 1, 4, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		0, 4, 1, 4,
		0, 5, 1, 5,
		127
	},
	{	 	/* Coe's p8, from Lexicon */
		-6, -3, -5, -3,
		-6, -2, -5, -2, -2, -2, -1, -2,
		-1, -1, 0, -1,
		-2, 0, 1, 0,
		1, 1, 4, 1, 5, 1,
		-1, 2, 1, 2, 4, 2, 5, 2,
		127
	},
	{		/* confused eaters (p4), from Lexicon */
		-5, -5,
		-5, -4, -4, -4, -3, -4,
		-2, -3,
		-3, -2,
		-3, -1, 0, -1,
		0, 0,
		-2, 1, 0, 1,
		-2, 2, -1, 2, 2, 2, 3, 2,
		2, 3, 4, 3,
		4, 4,
		4, 5, 5, 5,
		127
	},
	{		/* cross (p3), from Lexicon */
		-2, -4, -1, -4, 0, -4, 1, -4,
		-2, -3, 1, -3,
		-4, -2, -3, -2, -2, -2, 1, -2, 2, -2, 3, -2,
		-4, -1, 3, -1,
		-4, 0, 3, 0,
		-4, 1, -3, 1, -2, 1, 1, 1, 2, 1, 3, 1,
		-2, 2, 1, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		127
	},
	{		/* cuphook (p3) (in compact form), from Lexicon */
		1, -4, 2, -4,
		0, -3, 2, -3,
		0, -2,
		-3, -1, -2, -1, 0, -1,
		-3, 0, -2, 0, 0, 0, 3, 0,
		0, 1, 2, 1, 3, 1,
		0, 2,
		-1, 3, 0, 3,
		127
	},
	{		/* diehard (vanishes at 130, longest 7 cells) */
		2, -1,
		-4, 0, -3, 0,
		-3, 1, 1, 1, 2, 1, 3, 1,
		127
	},
	{ 		/* eater/bound frob (p4), from Lexicon */
		-4, -5, -3, -5,
		-3, -4,
		-3, -3, -1, -3,
		-2, -2, 0, -2,
		0, -1, 1, -1, 3, -1, 4, -1,
		3, 0, 4, 0,
		-3, 1, -2, 1,
		-2, 2,
		-5, 3, -4, 3, -3, 3,
		-5, 4,
		127
	},
	{		/* flotilla (school of fish, escort), from Lexicon */
		-3, -8, -2, -8, -1, -8, 0, -8,
		-4, -7, -3, -7, -2, -7, -1, -7, 0, -7, 1, -7,
		-5, -6, -4, -6, -2, -6, -1, -6, 0, -6, 1, -6,
		-4, -5, -3, -5,
		4, -3, 5, -3,
		-6, -2, 7, -2,
		-7, -1,
		-7, 0, 7, 0,
		-7, 1, -6, 1, -5, 1, -4, 1, -3, 1, -2, 1, -1, 1, 0, 1, 1, 1,
			2, 1, 3, 1, 4, 1, 5, 1, 6, 1,
		-3, 4, -2, 4, -1, 4, 0, 4,
		-4, 5, -3, 5, -2, 5, -1, 5, 0, 5, 1, 5,
		-5, 6, -4, 6, -2, 6, -1, 6, 0, 6, 1, 6,
		-4, 7, -3, 7,
		127
	},
	{		/* fore and back (p2), from Lexicon */
		-3, -3, -2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, 0, -2, 2, -2,
		3, -1,
		-3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0,
		-3, 1,
		-2, 2, 0, 2, 2, 2, 3, 2,
		-1, 3, 0, 3, 2, 3, 3, 3,
		127
	},
	{		/* fox (p2), from Lexicon */
		1, -3,
		1, -2,
		-1, -1, 2, -1,
		-3, 0, -2, 0,
		1, 1, 3, 1,
		-1, 2, 1, 2, 3, 2,
		3, 3,
		127
	},
	{		/* French kiss (p3), from Lexicon */
		-5, -4,
		-5, -3, -4, -3, -3, -3,
		-2, -2,
		-3, -1, 0, -1, 1, -1,
		-3, 0, 2, 0,
		-2, 1, -1, 1, 2, 1,
		1, 2,
		2, 3, 3, 3, 4, 3,
		4, 4,
		127
	},
	{		/* fumarole (p5), from Lexicon */
		-1, -3, 0, -3,
		-3, -2, 2, -2,
		-3, -1, 2, -1,
		-3, 0, 2, 0,
		-2, 1, 1, 1,
		-4, 2, -2, 2, 1, 2, 3, 2,
		-4, 3, -3, 3, 2, 3, 3, 3,
		127
	},
	{		/* hammer (3 LWSS to 1 MWSS), from Lexicon */
		-10, -3, -7, -3,
		-6, -2, -2, -2, -1, -2,
		-10, -1, -6, -1, -3, -1, -2, -1, -1, -1, 5, -1, 6, -1, 7, -1,
			8, -1,
		-9, 0, -8, 0, -7, 0, -6, 0, -3, 0, -2, 0, 0, 0, 5, 0, 9, 0,
		-2, 1, -1, 1, 0, 1, 5, 1,
		-1, 2, 6, 2, 9, 2,
		127
	},
	{		/* harvester (c p4 fuse), from Lexicon */
		7, -7, 8, -7,
		6, -6, 8, -6,
		5, -5,
		4, -4,
		3, -3,
		2, -2,
		1, -1,
		0, 0,
		-1, 1,
		-2, 2,
		-3, 3,
		-4, 4,
		-9, 5, -8, 5, -7, 5, -6, 5, -5, 5,
		-9, 6, -8, 6, -7, 6, -6, 6,
		-9, 7, -7, 7, -6, 7,
		127
	},
	{		/* hivenudger (c/2 orthogonally, p4) */
		-6, -6, -5, -6, -4, -6, -3, -6, 3, -6, 6, -6,
		-6, -5, -2, -5, 2, -5,
		-6, -4, 2, -4, 6, -4,
		-5, -3, -2, -3, 2, -3, 3, -3, 4, -3, 5, -3,
		-1, -1, 0, -1,
		-1, 0, 0, 0,
		-1, 1, 0, 1,
		-5, 3, -2, 3, 2, 3, 3, 3, 4, 3, 5, 3,
		-6, 4, 2, 4, 6, 4,
		-6, 5, -2, 5, 2, 5,
		-6, 6, -5, 6, -4, 6, -3, 6, 3, 6, 6, 6,
		127
	},
	{		/* mazing (p4) (pulse1), from Lexicon */
		0, -3, 1, -3,
		-2, -2, 0, -2,
		-3, -1, 3, -1,
		-2, 0, 2, 0, 3, 0,
		0, 2, 2, 2,
		1, 3,
		127
	},
	{		/* muttering moat (p2) (example), from Lexicon */
		-3, -3, -2, -3, 
		-3, -2, -1, -2, 1, -2, 2, -2, 
		2, -1, 
		-2, 0, 1, 0, 
		-1, 1, 
		-1, 2, 1, 2, 3, 2, 
		2, 3, 3, 3, 
		127
	},
	{		/* oscillator0 (p3), from HighLife */
		0, -2, 
		-4, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1, 
		-5, 0, -3, 0, 1, 0, 3, 0, 4, 0, 
		-4, 1, 1, 1, 
		0, 2, 1, 2, 
		127
	},
	{		/* oscillator1 (p3), from HighLife */
		-3, -2, 
		-3, -1, -2, -1, -1, -1, 3, -1, 5, -1, 6, -1, 7, -1, 
		-4, 0, -2, 0, 2, 0, 4, 0, 
		-7, 1, -6, 1, -5, 1, -3, 1, 1, 1, 2, 1, 3, 1, 
		3, 2, 
		127
	},
	{		/* oscillator4 (p4) (~HW emulator), from HighLife */
		-9, -3, -8, -3, -6, -3, -5, -3, -2, -3, -1, -3, 0, -3, 1, -3,
			4, -3, 5, -3, 7, -3, 8, -3, 
		-11, -2, -8, -2, -6, -2, -3, -2, -2, -2, -1, -2, 0, -2, 1, -2,
			2, -2, 5, -2, 7, -2, 10, -2, 
		-11, -1, -10, -1, -5, -1, -4, -1, -3, -1, -2, -1, -1, -1,
			0, -1, 1, -1, 2, -1, 3, -1, 4, -1, 9, -1, 10, -1, 
		-7, 0, -6, 0, 5, 0, 6, 0, 
		-8, 1, -5, 1, 4, 1, 7, 1, 
		-7, 2, -6, 2, 5, 2, 6, 2, 
		127
	},
	{		/* oscillator0 (p6), from HighLife */
		-3, -8, 3, -8, 
		-3, -7, -2, -7, 2, -7, 3, -7, 
		-3, -6, -2, -6, 2, -6, 3, -6, 
		-2, -5, 2, -5, 
		-1, -3, 0, -3, 1, -3, 
		-2, -2, 2, -2, 
		-2, 1, 2, 1, 
		-1, 2, 0, 2, 1, 2, 
		-2, 4, 2, 4, 
		-3, 5, -2, 5, 2, 5, 3, 5, 
		-3, 6, -2, 6, 2, 6, 3, 6, 
		-3, 7, 3, 7, 
		127
	},
	{	       /* phoenix (example) (p2), from Lexicon */
		0, -4,
		-2, -3, 0, -3,
		2, -2,
		-4, -1, -3, -1,
		2, 0, 3, 0,
		-3, 1,
		-1, 2, 1, 2,
		-1, 3,
		127
	},
	{		/* pinwheel (p4) */
		-2, -6, -1, -6,
		-2, -5, -1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-3, -2, -1, -2, 2, -2, 4, -2, 5, -2,
		-3, -1, 1, -1, 2, -1, 4, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, 0, 0, 2, 0,
		-6, 1, -5, 1, -3, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		0, 4, 1, 4,
		0, 5, 1, 5,
		127
	},
	{	       /* pulsar quadrant (p3), from Lexicon */
		1, -4,
		-1, -3, 0, -3, 1, -3,
		-2, -2, 2, -2, 3, -2,
		-4, -1, -1, -1, 2, -1,
		-4, 0, 0, 0, 2, 0,
		-4, 1, 1, 1,
		-2, 3, -1, 3, 0, 3,
		127
	},
	{	       /* quad (p2), from Lexicon */
		-3, -3, -2, -3, 1, -3, 2, -3,
		-3, -2, 0, -2, 2, -2,
		-2, -1,
		1, 0,
		-3, 1, -1, 1, 2, 1,
		-3, 2, -2, 2, 1, 2, 2, 2,
		127
	},
	{	       /* reverse fuse, from Lexicon */
		6, -6, 7, -6,
		5, -5, 7, -5,
		4, -4,
		3, -3,
		2, -2,
		1, -1,
		0, 0,
		-1, 1,
		-2, 2,
		-3, 3,
		-4, 4,
		-5, 5,
		-7, 6, -6, 6,
		127
	},
	{	       /*  revolver (p2) */
		-7, -4, 6, -4,
		-7, -3, -6, -3, -5, -3, 0, -3, 4, -3, 5, -3, 6, -3,
		-4, -2, -2, -2, 0, -2, 3, -2,
		-5, -1, 2, -1, 4, -1,
		-5, 0, -3, 0, 4, 0,
		-4, 1, -1, 1, 1, 1, 3, 1,
		-7, 2, -6, 2, -5, 2, -1, 2, 4, 2, 5, 2, 6, 2,
		-7, 3, 6, 3,
		127
	},
	{	       /* roteightor (p8), from Lexicon */
		-6, -7,
		-6, -6, -5, -6, -4, -6, 5, -6, 6, -6,
		-3, -5, 5, -5,
		-4, -4, -3, -4, 3, -4, 5, -4,
		3, -3, 4, -3,
		-2, -1, -1, -1, 0, -1,
		-2, 0, 1, 0,
		-2, 1,
		-5, 2, -4, 2, -1, 2, 3, 2,
		-6, 3, -4, 3, 3, 3,
		-6, 4, 2, 4,
		-7, 5, -6, 5, 3, 5, 4, 5, 5, 5,
		5, 6,
		127
	},
	{		/* ship smallest diagonal but 1 (c/4, p4) (25-cell) */
		2, -6, 3, -6,
		1, -5, 2, -5,
		3, -4,
		5, -3, 6, -3,
		4, -2,
		3, 0, 6, 0,
		-5, 1, -4, 1, 2, 1, 3, 1,
		-6, 2, -5, 2, 1, 2,
		-4, 3, 1, 3, 3, 3,
		-2, 4, -1, 4, 2, 4,
		-2, 5, -1, 5,
		127
	},
	{	       /* sidecar, from Lexicon */
		-3, -5,
		-4, -4, 2, -4,
		-4, -3, 2, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 0, -2, 2, -2,
		0, 0, 1, 0,
		-2, 1, 3, 1,
		-3, 2,
		-3, 3, 3, 3,
		-3, 4, -2, 4, -1, 4, 0, 4, 1, 4, 2, 4,
		127
	},
	{	       /* singular flip flop (p2), from Lexicon */
		-1, -3,
		-1, -2, 1, -2,
		-3, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 2, 0, 2,
		-1, 3, 0, 3,
		127
	},
	{	       /* skewed quad (p2), from Lexicon */
		-2, -3, -1, -3,
		-2, -2, 2, -2, 3, -2,
		-1, -1, 1, -1, 3, -1,
		-3, 1, -1, 1, 1, 1,
		-3, 2, -2, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
	{	       /* snake pit II (p3), from Lexicon */
		0, -5, 1, -5,
		-1, -4, 2, -4,
		-1, -3, 1, -3, 2, -3,
		-4, -2, -3, -2, -1, -2,
		-5, -1, -3, -1, -1, -1, 1, -1, 2, -1, 3, -1, 4, -1,
		-5, 0, 5, 0,
		-4, 1, -3, 1, -2, 1, -1, 1, 1, 1, 3, 1, 5, 1,
		1, 2, 3, 2, 4, 2,
		-2, 3, -1, 3, 1, 3,
		-2, 4, 1, 4,
		-1, 5, 0, 5,
		127
	},
#if 0
	{		/* spark coil (p2), from Lexicon */
		-4, -2, -3, -2, 2, -2, 3, -2,
		-4, -1, -2, -1, 1, -1, 3, -1,
		-2, 0, 1, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, -3, 2, 2, 2, 3, 2,
		127
	},
#endif
	{		/* star (p3) (big cross), from Lexicon */
		0, -5,
		-1, -4, 0, -4, 1, -4,
		-3, -3, -2, -3, -1, -3, 1, -3, 2, -3, 3, -3,
		-3, -2, 3, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 4, 0, 5, 0,
		-4, 1, -3, 1, 3, 1, 4, 1,
		-3, 2, 3, 2,
		-3, 3, -2, 3, -1, 3, 1, 3, 2, 3, 3, 3,
		-1, 4, 0, 4, 1, 4,
		0, 5,
		127
	},
	{		/* sym (p4) */
		-6, -2, -5, -2, 4, -2, 5, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, 1, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -2, 0, 1, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, -1, 1, 0, 1, 1, 1, 3, 1, 4, 1,
		127
	},
	{		/* turtle (p3, c/3), from Lexicon */
		-4, -5, -3, -5, -2, -5, 6, -5,
		-4, -4, -3, -4, 0, -4, 2, -4, 3, -4, 5, -4, 6, -4,
		-2, -3, -1, -3, 0, -3, 5, -3,
		-4, -2, -1, -2, 1, -2, 5, -2,
		-5, -1, 0, -1, 5, -1,
		-5, 0, 0, 0, 5, 0,
		-4, 1, -1, 1, 1, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 5, 2,
		-4, 3, -3, 3, 0, 3, 2, 3, 3, 3, 5, 3, 6, 3,
		-4, 4, -3, 4, -2, 4, 6, 4,
		127
	},
	{	       /* two eaters (p3), from Lexicon */
		-4, -4, -3, -4,
		-3, -3,
		-3, -2, -1, -2,
		-2, -1, -1, -1,
		1, 0, 2, 0,
		1, 1, 3, 1,
		3, 2,
		3, 3, 4, 3,
		127
	},
	{		/* two pulsar quadrants (p3) (pulsar 18-22-20) */
		0, -4, 1, -4, 2, -4,
		-1, -2, 4, -2,
		-2, -1, 0, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, 1, 0, 4, 0,
		2, 1,
		0, 2, 1, 2,
		0, 3,
		0, 4,
		127
	},
	{		/* why not (p2), from Lexicon */
		0, -3,
		0, -2, 2, -2,
		-2, -1,
		-3, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-2, 1,
		0, 2, 2, 2,
		0, 3,
		127
	},
	{		/* windmill (p4), from Lexicon */
		2, -9,
		0, -8, 1, -8, 3, -8,
		-2, -7, -1, -7,
		1, -6, 2, -6,
		-2, -5, -1, -5, 0, -5,
		-9, -3, -8, -3, -7, -3,
		-6, -2, -5, -2, -2, -2, -1, -2, 0, -2, 2, -2, 3, -2,
		1, -1, 2, -1, 3, -1, 4, -1, 5, -1, 6, -1, 7, -1,
		-8, 0, -7, 0, -6, 0, -5, 0, -4, 0, -3, 0, -2, 0,
		-4, 1, -3, 1, -1, 1, 0, 1, 1, 1, 4, 1, 5, 1,
		6, 2, 7, 2, 8, 2,
		-1, 4, 0, 4, 1, 4,
		-3, 5, -2, 5,
		0, 6, 1, 6,
		-4, 7, -2, 7, -1, 7,
		-3, 8,
		127
	},
	{		/* worker bee (p9), from Lexicon */
		-8, -5, -7, -5, 6, -5, 7, -5,
		-7, -4, 6, -4,
		-7, -3, -5, -3, 4, -3, 6, -3,
		-6, -2, -5, -2, 4, -2, 5, -2,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-6, 2, -5, 2, 4, 2, 5, 2,
		-7, 3, -5, 3, 4, 3, 6, 3,
		-7, 4, 6, 4,
		-8, 5, -7, 5, 6, 5, 7, 5,
		127
	}
};

static char patterns_8S23B3[][2 * NUMPTS + 1] =
{
	/* Lexicon 22-2-02 http://www.argentum.freeserve.co.uk/lex_home.htm */
	{		/* 101 (p5), from Lexicon */
		-5, -6, -4, -6, 3, -6, 4, -6,
		-6, -5, -4, -5, 3, -5, 5, -5,
		-6, -4, 5, -4,
		-9, -3, -8, -3, -6, -3, 5, -3, 7, -3, 8, -3,
		-9, -2, -8, -2, -6, -2, -4, -2, -1, -2, 0, -2, 3, -2, 5, -2,
			7, -2, 8, -2,
		-6, -1, -4, -1, -2, -1, 1, -1, 3, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, 1, 0, 3, 0, 5, 0,
		-9, 1, -8, 1, -6, 1, -4, 1, -1, 1, 0, 1, 3, 1, 5, 1, 7, 1,
			8, 1,
		-9, 2, -8, 2, -6, 2, 5, 2, 7, 2, 8, 2,
		-6, 3, 5, 3,
		-6, 4, -4, 4, 3, 4, 5, 4,
		-5, 5, -4, 5, 3, 5, 4, 5,
		127
	},
	{ 		/* 1-2-3 (p3), from Lexicon */
		-3, -4, -2, -4,
		-5, -3, -2, -3,
		-5, -2, -4, -2, -2, -2, 0, -2, 1, -2,
		-4, -1, -2, -1, 1, -1,
		-4, 0, 1, 0, 3, 0, 4, 0,
		-3, 1, -2, 1, -1, 1, 1, 1, 3, 1, 4, 1,
		0, 2,
		-1, 3,
		-1, 4, 0, 4,
		127
	},
	{		/* 1-2-3-4 (p4), from Lexicon */
		0, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -3, 0, 3, 0, 5, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 3,
		-1, 4, 1, 4,
		0, 5,
		127
	},
	{		/* Achim's p144, from Lexicon */
		-14, -9, -13, -9, 12, -9, 13, -9,
		-14, -8, -13, -8, 12, -8, 13, -8,
		4, -7, 5, -7,
		3, -6, 6, -6,
		4, -5, 5, -5,
		-1, -3, 0, -3, 1, -3,
		-1, -2, 1, -2,
		-1, -1, 0, -1, 1, -1,
		-1, 0, 0, 0,
		-2, 1, -1, 1, 0, 1,
		-2, 2, 0, 2,
		-2, 3, -1, 3, 0, 3,
		-6, 5, -5, 5,
		-7, 6, -4, 6,
		-6, 7, -5, 7,
		-14, 8, -13, 8, 12, 8, 13, 8,
		-14, 9, -13, 9, 12, 9, 13, 9,
		127
	},
	{		/* Achim's p16, from Lexicon */
		1, -6, 2, -6,
		1, -5, 3, -5,
		-4, -4, 1, -4, 3, -4, 4, -4,
		-5, -3, -4, -3, 2, -3,
		-6, -2, -3, -2,
		-6, -1, -5, -1, -4, -1,
		4, 1, 5, 1, 6, 1,
		3, 2, 6, 2,
		-2, 3, 4, 3, 5, 3,
		-4, 4, -3, 4, -1, 4, 4, 4,
		-3, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
	{		/* Achim (p4), from Lexicon */
		-3, -4, -2, -4, 2, -4, 3, -4,
		-4, -3, -1, -3, 1, -3, 4, -3,
		-4, -2, -2, -2, -1, -2, 1, -2, 2, -2, 4, -2,
		-5, -1, -4, -1, 4, -1, 5, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-5, 1, -4, 1, 4, 1, 5, 1,
		-4, 2, -2, 2, -1, 2, 1, 2, 2, 2, 4, 2,
		-4, 3, -1, 3, 1, 3, 4, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		127
	},
	{		/* Achim's p5 (pseudo-barberpole), from Lexicon */
		-6, -6, -5, -6,
		-6, -5,
		-4, -4,
		-4, -3, -2, -3,
		-2, -1, 0, -1,
		0, 1, 2, 1,
		2, 3, 3, 3,
		5, 4,
		4, 5, 5, 5,
		127
	},
	{ 		/* Achim's p8 (asym), from Lexicon */
		-3, -4, -2, -4,
		-4, -3,
		-3, -2, 1, -2,
		-3, -1, 1, -1, 2, -1,
		-1, 0, 1, 0,
		-2, 1, -1, 1, 3, 1,
		-1, 2, 3, 2,
		4, 3,
		2, 4, 3, 4,
		127
	},
	{		/* acorn (stabilizes at 5206), from Lexicon */
		-2, -1,
		0, 0,
		-3, 1, -2, 1, 1, 1, 2, 1, 3, 1,
		127
	},
	{ 		/* A for All (p6), from Lexicon */
		-1, -5, 0, -5,
		-2, -4, 1, -4,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-4, -2, -2, -2, 1, -2, 3, -2,
		-5, -1, 4, -1,
		-5, 0, 4, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		-2, 3, 1, 3,
		-1, 4, 0, 4,
		127
	},
	{		/* airforce (p7), from Lexicon */
		0, -7,
		-1, -6, 1, -6,
		0, -5,
		-2, -3, -1, -3, 0, -3, 1, -3, 2, -3,
		-3, -2, 3, -2, 5, -2, 6, -2,
		-4, -1, -2, -1, -1, -1, 3, -1, 5, -1, 6, -1,
		-4, 0, -2, 0, 1, 0, 3, 0,
		-7, 1, -6, 1, -4, 1, 0, 1, 1, 1, 3, 1,
		-7, 2, -6, 2, -4, 2, 2, 2,
		-3, 3, -2, 3, -1, 3, 0, 3, 1, 3,
		-1, 5,
		-2, 6, 0, 6,
		-1, 7,
		127
	},
	{		/* AK47 (almost a gun) */
		-12, -6, -11, -6,
		-12, -5, -11, -5,
		11, -4, 12, -4,
		11, -3,
		3, -2, 4, -2, 5, -2, 9, -2, 11, -2,
		2, -1, 6, -1, 9, -1, 10, -1,
		-10, 0, -9, 0, 1, 0, 7, 0,
		-11, 1, -9, 1, 1, 1, 7, 1,
		-11, 2, 1, 2, 7, 2,
		-12, 3, -11, 3, 2, 3, 6, 3,
		3, 4, 4, 4, 5, 4, 11, 4, 12, 4,
		11, 5, 12, 5,
		127
	},
	{		/* asym (p4) */
		-4, -4, -2, -4,
		-4, -3, -1, -3,
		-1, -2,
		-2, -1, -1, -1, 0, -1, 3, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, 0, 0, 1, 0, 2, 0,
		1, 1,
		1, 2, 4, 2,
		2, 3, 4, 3,
		127
	},
	{		/* asym 2 (p4) */
		-3, -3, -1, -3, 2, -3, 4, -3, 5, -3, 6, -3,
		-4, -2, -1, -2, 1, -2, 3, -2, 5, -2,
		-4, -1,
		3, 0,
		-6, 1, -4, 1, -2, 1, 0, 1, 3, 1,
		-7, 2, -6, 2, -5, 2, -3, 2, 0, 2, 2, 2,
		127
	},
	{		/* aVerage (p5), from Lexicon */
		-3, -5, -2, -5,
		-2, -4, -1, -4, 0, -4,
		-4, -3, 1, -3,
		-5, -2, -3, -2, -2, -2, -1, -2, 0, -2, 2, -2,
		-5, -1, -3, -1, 2, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, -1, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, -3, 1, 2, 1, 5, 1,
		-5, 2, -3, 2, -2, 2, -1, 2, 0, 2, 2, 2,
		-4, 3, 1, 3,
		-2, 4, -1, 4, 0, 4,
		-3, 5, -2, 5,
		127
	},
	{		/* babbling brook (4 cell rotor), from Lexicon */
		-1, -5,
		-3, -4, -2, -4, -1, -4, 4, -4, 5, -4,
		-4, -3, 0, -3, 1, -3, 4, -3,
		-7, -2, -4, -2, -2, -2, -1, -2, 2, -2, 4, -2,
		-8, -1, -6, -1, -4, -1, 1, -1, 2, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -3, 0, -2, 0, 3, 0, 5, 0, 7, 0,
		-5, 1, -3, 1, 0, 1, 1, 1, 3, 1, 6, 1,
		-5, 2, -2, 2, -1, 2, 3, 2,
		-6, 3, -5, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
	{		/* baker's dozen (p12), from Lexicon */
		-11, -5, -10, -5, 0, -5, 1, -5,
		-11, -4, -10, -4, -9, -4, -8, -4, -6, -4, 0, -4, 1, -4,
		-11, -3, -9, -3, -6, -3, -5, -3, -4, -3,
		0, -2,
		-7, -1, -6, -1, -1, -1, 1, -1,
		-7, 0, -1, 0, 2, 0, 7, 0,
		0, 1, 1, 1, 6, 1, 7, 1,
		4, 3, 5, 3, 6, 3, 9, 3, 11, 3,
		-1, 4, 0, 4, 6, 4, 8, 4, 9, 4, 10, 4, 11, 4,
		-1, 5, 0, 5, 10, 5, 11, 5,
		127
	},
	{		/* big glider 2 (c/4 diagonal, p4) */
		0, -9, 1, -9,
		0, -8, 2, -8,
		0, -7,
		1, -6, 2, -6, 3, -6,
		1, -5, 3, -5, 4, -5, 5, -5,
		1, -4, 4, -4, 5, -4,
		3, -3, 5, -3, 7, -3, 8, -3,
		2, -2, 3, -2, 5, -2, 7, -2,
		1, -1, 2, -1, 7, -1,
		-9, 0, -8, 0, -7, 0,
		-9, 1, -6, 1, -5, 1, -4, 1, -1, 1, 3, 1, 4, 1,
		-8, 2, -6, 2, -2, 2, -1, 2,
		-6, 3, -5, 3, -3, 3, -2, 3, 1, 3,
		-5, 4, -4, 4, 1, 4,
		-5, 5, -4, 5, -3, 5, -2, 5,
		-3, 7, -2, 7, -1, 7,
		-3, 8,
		127
	},
	{		/* big glider 3 (c4 diagonal, p4) */
		-1, -8,
		-2, -7, -1, -7,
		-2, -6, 0, -6,
		0, -4, 2, -4,
		-2, -3, 0, -3, 2, -3,
		-7, -2, -3, -2, -2, -2, 0, -2, 2, -2, 3, -2,
		-8, -1, -7, -1, -6, -1, -5, -1, -2, -1, 4, -1,
		-8, 0, -5, 0, -4, 0, -2, 0, -1, 0, 3, 0, 4, 0,
		-6, 1, -5, 1, 0, 1,
		-4, 2, -3, 2, 1, 2,
		-3, 3, -2, 3, -1, 3, 2, 3, 4, 3, 5, 3, 6, 3, 7, 3,
		-3, 4, 0, 4, 3, 4, 4, 4, 5, 4,
		-1, 5, 0, 5, 1, 5,
		1, 6, 2, 6, 3, 6,
		2, 7, 3, 7,
		127
	},
	{		/* blockers (p8) (oscillator 7) */
		-4, -2, -3, -2, -2, -2, -1, -2, 4, -2, 5, -2, 6, -2, 7, -2,
		-9, -1, -8, -1, 0, -1, 8, -1,
		-9, 0, -8, 0, -5, 0, -4, 0, 0, 0, 3, 0, 4, 0, 8, 0,
		-5, 1, -4, 1, -1, 1, 3, 1, 4, 1, 7, 1,
		127
	},
	{ 		/* boss (p4), from Lexicon */
		0, -7,
		-1, -6, 1, -6,
		-1, -5, 1, -5,
		-2, -4, -1, -4, 1, -4, 2, -4,
		-3, -3, 3, -3,
		-4, -2, -2, -2, 0, -2, 2, -2, 4, -2,
		-4, -1, -2, -1, 2, -1, 4, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-5, 1, -2, 1, 0, 1, 2, 1, 5, 1,
		-3, 2, 3, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		-1, 4, 1, 4,
		-1, 5, 1, 5,
		0, 6,
		127
	},
	{ 		/* buckaroo (queen bee shuttle, piston) (p30) */
		-10, -6,
		-12, -5, -10, -5,
		-11, -4, -10, -4,
		-1, -3,
		-3, -2, -1, -2,
		-4, -1, -2, -1,
		-5, 0, -2, 0, 10, 0, 11, 0,
		-4, 1, -2, 1, 10, 1, 11, 1,
		-9, 2, -8, 2, -3, 2, -1, 2,
		-10, 3, -8, 3, -1, 3,
		-10, 4,
		-11, 5, -10, 5,
		127
	},
	{		/* bunnies (parent of rabbits, stabilizes at 17332) */
		-4, -2, 2, -2,
		-2, -1, 2, -1,
		-2, 0, 1, 0, 3, 0,
		-3, 1, -1, 1,
		127
	},
	{		/* burloaferimeter (p7), from Lexicon */
		-1, -5, 0, -5,
		0, -4,
		-1, -3,
		-2, -2, 0, -2, 1, -2, 2, -2,
		-2, -1, 0, -1, 3, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 3, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		-1, 4, 0, 4,
		-1, 5, 0, 5,
		127
	},
	{		/* Canada goose (c/4, p4) (diagonal ship) */
		-6, -6, -5, -6, -4, -6,
		-6, -5, 4, -5, 5, -5,
		-5, -4, 2, -4, 3, -4, 4, -4, 6, -4,
		-3, -3, -2, -3, 1, -3, 2, -3,
		-2, -2,
		2, -1,
		-2, 0, -1, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 2, 1,
		-3, 2, -1, 2, 2, 2, 4, 2, 5, 2,
		-4, 3, 1, 3, 2, 3,
		-4, 4, -3, 4,
		-4, 5, -3, 5,
		127
	},
	{		/* candelabra (p3), from Lexicon */
		-4, -3, -3, -3, 2, -3, 3, -3,
		-7, -2, -4, -2, 3, -2, 6, -2,
		-8, -1, -6, -1, -4, -1, 3, -1, 5, -1, 7, -1,
		-7, 0, -4, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 6, 0,
		-4, 1, -2, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		127
	},
	{		/* carnival shuttle (p12) (w/ monograms, fencepost) */
		14, -3, 18, -3,
		-19, -2, -18, -2, -14, -2, -13, -2, 14, -2, 15, -2, 16, -2,
			 17, -2, 18, -2,
		-18, -1, -16, -1, -14, -1, -10, -1, -7, -1, 0, -1, 1, -1,
			 5, -1, 8, -1, 16, -1,
		-18, 0, -17, 0, -15, 0, -14, 0, -11, 0, -10, 0, -6, 0, -5, 0,
			 0, 0, 1, 0, 4, 0, 5, 0, 9, 0, 10, 0, 15, 0, 17, 0,
		-18, 1, -16, 1, -14, 1, -10, 1, -7, 1, 0, 1, 1, 1, 5, 1, 8,
			 1, 16, 1,
		-19, 2, -18, 2, -14, 2, -13, 2, 14, 2, 15, 2, 16, 2, 17, 2,
			 18, 2,
		14, 3, 18, 3,
		127
	},
	{		/* caterer (p3) (question), from Lexicon */
		-2, -4, -1, -4, 0, -4,
		2, -3,
		-3, -2, 2, -2,
		1, -1,
		-2, 0, -1, 0,
		-2, 1,
		-2, 2,
		-2, 3,
		127
	},
	{	       /* cauldron (p8), from Lexicon */
		0, -6,
		-1, -5, 1, -5,
		0, -4,
		-2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-5, -1, -3, -1, 3, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 2, 1,
		-2, 2, 2, 2,
		-1, 3, 0, 3, 1, 3,
		-1, 5, 0, 5, 2, 5,
		-1, 6, 1, 6, 2, 6,
		127
	},
#if 0
	{	       /* cavity (p2), from Lexicon */
		-4, -4, -3, -4,
		-3, -3,
		-3, -2, -1, -2, 0, -2,
		-2, -1, 1, -1,
		1, 0,
		0, 1,
		1, 2, 2, 2, 3, 2,
		3, 3,
		127
	},
#endif
	{	       /* chemist (p5), from Lexicon */
		0, -6,
		0, -5, 1, -5, 2, -5,
		3, -4,
		-2, -3, -1, -3, 0, -3, 3, -3, 6, -3, 7, -3,
		-3, -2, -1, -2, 1, -2, 3, -2, 5, -2, 7, -2,
		-3, -1, 1, -1, 3, -1, 5, -1,
		-6, 0, -5, 0, -3, 0, 3, 0, 5, 0, 6, 0,
		-5, 1, -3, 1, -1, 1, 3, 1,
		-7, 2, -5, 2, -3, 2, -1, 2, 1, 2, 3, 2,
		-7, 3, -6, 3, -3, 3, 0, 3, 1, 3, 2, 3,
		-3, 4,
		-2, 5, -1, 5, 0, 5,
		0, 6,
		127
	},
	{		/* Coe ship (c/2, p16), from Lexicon */
		-1, -4, 0, -4, 1, -4, 2, -4, 3, -4, 4, -4,
		-3, -3, -2, -3, 4, -3,
		-5, -2, -4, -2, -2, -2, 4, -2,
		-1, -1, 3, -1,
		1, 0,
		1, 1, 2, 1,
		0, 2, 1, 2, 2, 2, 3, 2,
		0, 3, 1, 3, 3, 3, 4, 3,
		2, 4, 3, 4,
		127
	},
	{		/* converter (using Kok's galaxy (p8) (turbine)) */
		-6, -6, -4, -6, -1, -6,
		-6, -5, -5, -5, -4, -5, -2, -5, 0, -5, 1, -5,
		-7, -4, 0, -4, 6, -4,
		-6, -3, 0, -3, 1, -3, 5, -3, 7, -3,
		6, -2, 7, -2,
		-7, -1, -6, -1, 0, -1,
		-6, 0, 1, 0,
		-7, 1, -6, 1, -4, 1, -2, 1, -1, 1, 0, 1,
		-5, 2, -2, 2, 0, 2,
		5, 3, 6, 3, 7, 3,
		5, 4, 7, 4,
		5, 5, 7, 5,
		127
	},
	{		/* cousins (p3), from Lexicon */
		-1, -3, 1, -3, 2, -3,
		-3, -2, -2, -2, -1, -2, 1, -2, 3, -2,
		-6, -1, -4, -1, 3, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, 0, 0, 1, 0, 3, 0, 5, 0, 6, 0,
		-3, 1, -1, 1, 4, 1, 6, 1,
		-3, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		-2, 3, -1, 3, 1, 3,
		127
	},
	{		/* cross II (p3), from Lexicon */
		-4, -6, -3, -6, -2, -6, -1, -6, 1, -6, 2, -6, 3, -6, 4, -6,
		-4, -5, -1, -5, 1, -5, 4, -5,
		-6, -4, -5, -4, -4, -4, -1, -4, 0, -4, 1, -4, 4, -4, 5, -4,
			6, -4,
		-6, -3, 6, -3,
		-6, -2, 6, -2,
		-6, -1, -5, -1, -4, -1, 4, -1, 5, -1, 6, -1,
		-4, 0, 4, 0,
		-6, 1, -5, 1, -4, 1, 4, 1, 5, 1, 6, 1,
		-6, 2, 6, 2,
		-6, 3, 6, 3,
		-6, 4, -5, 4, -4, 4, -1, 4, 0, 4, 1, 4, 4, 4, 5, 4, 6, 4,
		-4, 5, -1, 5, 1, 5, 4, 5,
		-4, 6, -3, 6, -2, 6, -1, 6, 1, 6, 2, 6, 3, 6, 4, 6,
		127
	},
	{		/* crowd (p3), from Lexicon */
		4, -7,
		2, -6, 3, -6, 4, -6,
		-2, -5, -1, -5, 1, -5,
		-2, -4, 2, -4,
		0, -3, 1, -3, 3, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 3, -2,
		-7, -1, -5, -1, 1, -1, 3, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -4, 0, -2, 0, 4, 0, 6, 0,
		-4, 1, 0, 1, 1, 1, 2, 1, 3, 1,
		-4, 2, -2, 2, -1, 2,
		-3, 3, 1, 3,
		-2, 4, 0, 4, 1, 4,
		-5, 5, -4, 5, -3, 5,
		-5, 6,
		127
	},
	{		/* dart (c/3, p3), from Lexicon */
		3, -7,
		2, -6, 4, -6,
		1, -5, 2, -5,
		4, -4,
		0, -3, 4, -3,
		-3, -2, 0, -2,
		-4, -1, -2, -1, 1, -1, 2, -1, 3, -1, 4, -1,
		-5, 0, -2, 0,
		-4, 1, -2, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, 0, 2,
		0, 3, 4, 3,
		4, 4,
		1, 5, 2, 5,
		2, 6, 4, 6,
		3, 7,
		127
	},
	{		/* diag sym (p4) */
		-2, -4, 0, -4,
		-2, -3, 0, -3, 2, -3, 3, -3,
		-4, -2, -3, -2, 2, -2,
		0, -1, 1, -1, 2, -1,
		-4, 0, -3, 0, -1, 0, 2, 0,
		-1, 1, 2, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
		-3, 3,
		127
	},
	{		/* diamond ring (p3) (stargate repeater) */
		0, -6,
		-1, -5, 1, -5,
		-2, -4, 0, -4, 2, -4,
		-2, -3, 2, -3,
		-4, -2, -3, -2, 0, -2, 3, -2, 4, -2,
		-5, -1, 0, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, -1, 0, 1, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, 0, 1, 5, 1,
		-4, 2, -3, 2, 0, 2, 3, 2, 4, 2,
		-2, 3, 2, 3,
		-2, 4, 0, 4, 2, 4,
		-1, 5, 1, 5,
		0, 6,
		127
	},
	{		/* double ewe, from Lexicon */
		-4, -10, -3, -10,
		-3, -9,
		-4, -8,
		-4, -7, -3, -7,
		-1, -6, 0, -6,
		-4, -5, -3, -5, -2, -5, 0, -5,
		-10, -4, -8, -4, -7, -4, -5, -4,
		-10, -3, -9, -3, -7, -3, -5, -3,
		-5, -2, -1, -2,
		-6, -1, -2, -1, -1, -1, 4, -1, 5, -1,
		-6, 0, -5, 0, 0, 0, 1, 0, 5, 0,
		0, 1, 4, 1,
		4, 2, 6, 2, 8, 2, 9, 2,
		4, 3, 6, 3, 7, 3, 9, 3,
		-1, 4, 1, 4, 2, 4, 3, 4,
		-1, 5, 0, 5,
		2, 6, 3, 6,
		3, 7,
		2, 8,
		2, 9, 3, 9,
		127
	},
	{		/* dinner table (p12) (whirly thing), from Lexicon */
		-5, -6,
		-5, -5, -4, -5, -3, -5, 5, -5, 6, -5,
		-2, -4, 5, -4,
		-3, -3, -2, -3, 3, -3, 5, -3,
		3, -2, 4, -2,
		0, -1, 1, -1,
		0, 0, 1, 0,
		0, 1, 1, 1,
		-4, 2, -3, 2,
		-5, 3, -3, 3, 2, 3, 3, 3,
		-5, 4, 2, 4,
		-6, 5, -5, 5, 3, 5, 4, 5, 5, 5,
		5, 6,
		127
	},
	{ 		/* eater-bound pond (p3), from Lexicon */
		-6, -6,
		-6, -5, -5, -5, -4, -5,
		-3, -4,
		-4, -3, -3, -3,
		-3, -2, -2, -2,
		-2, -1, -1, -1,
		-3, 0, 0, 0,
		-3, 1, 0, 1, 1, 1,
		-2, 2, -1, 2, 1, 2, 2, 2, 3, 2,
		2, 3, 4, 3,
		4, 4,
		4, 5, 5, 5,
		127
	},
#if 0
	{ 		/* eater plug (p2), from Lexicon */
		3, -4,
		1, -3, 2, -3, 3, -3,
		0, -2,
		1, -1,
		-2, 0, 1, 0,
		-3, 1, -1, 1, 0, 1,
		-3, 2,
		-4, 3, -3, 3,
		127
	},
#endif
	{		/* edge-repair spaceship (and Hershel) (c/3, p3) */
		4, -3,
		-12, -2, 3, -2, 4, -2, 5, -2, 6, -2,
		-12, -1, -10, -1, -2, -1, 2, -1, 6, -1, 7, -1, 9, -1, 10, -1,
		-12, 0, -11, 0, -10, 0, -3, 0, -2, 0, -1, 0, 0, 0, 6, 0,
			9, 0, 10, 0,
		-10, 1, -4, 1, 0, 1, 8, 1, 11, 1,
		-3, 2, -1, 2, 2, 2,
		1, 3,
		127
	},
	{		/* Elkies' p5, from Lexicon */
		-3, -4,
		-4, -3, -1, -3, 0, -3, 1, -3,
		-2, -2,
		-1, -1, 1, -1, 4, -1,
		-2, 0, -1, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		0, 1,
		0, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
	{		/* en retard (p3) */
		0, -5,
		-1, -4, 1, -4,
		-5, -3, -4, -3, -2, -3, 0, -3, 2, -3, 4, -3, 5, -3,
		-4, -2, -2, -2, 2, -2, 4, -2,
		-5, -1, -2, -1, 0, -1, 2, -1, 5, -1,
		-4, 0, -3, 0, 3, 0, 4, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		-3, 4, -1, 4, 1, 4, 3, 4,
		-3, 5, -2, 5, 2, 5, 3, 5,
		127
	},
	{		/* Eureka (p30) (a pre-pulsar shuttle) */
		-8, -5, 7, -5,
		-9, -4, -7, -4, 1, -4, 2, -4, 6, -4, 8, -4,
		-8, -3, 0, -3, 1, -3, 2, -3, 7, -3,
		1, -2, 2, -2,
		1, 2, 2, 2,
		-8, 3, 0, 3, 1, 3, 2, 3, 7, 3,
		-9, 4, -7, 4, 1, 4, 2, 4, 6, 4, 8, 4,
		-8, 5, 7, 5,
		127
	},
	{		/* extremely impressive (p6), from Lexicon */
		-2, -5, -1, -5,
		-3, -4, -1, -4, 0, -4, 1, -4,
		-3, -3, 2, -3,
		-6, -2, -5, -2, -3, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, 3, -1, 4, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 5, 0,
		4, 1, 5, 1,
		0, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
	{		/* Fast Forward Force Field with LWSS, from Lexicon */
		-1, -3, 6, -3,
		0, -2, 7, -2, 8, -2,
		-6, -1, -5, -1, -2, -1, -1, -1, 0, -1, 6, -1, 7, -1,
		-8, 0, -7, 0, -5, 0, -4, 0,
		-8, 1, -7, 1, -6, 1, -5, 1, 5, 1,
		-7, 2, -6, 2, 4, 2, 5, 2,
		4, 3, 6, 3,
		127
	},
#if 0
	{		/* figure-8 (p8), from Lexicon */
		-3, -3, -2, -3, -1, -3,
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		127
	},
#endif
	{		/* fountain (p4), from Lexicon */
		0, -7,
		-6, -5, -5, -5, -3, -5, 3, -5, 5, -5, 6, -5,
		-6, -4, 0, -4, 6, -4,
		-5, -3, -4, -3, -2, -3, -1, -3, 1, -3, 2, -3, 4, -3, 5, -3,
		-3, -1, -2, -1, 2, -1, 3, -1,
		-9, 0, -8, 0, 8, 0, 9, 0,
		-9, 1, -6, 1, -2, 1, 0, 1, 2, 1, 6, 1, 9, 1,
		-8, 2, -7, 2, -6, 2, -4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
			2, 2, 3, 2, 4, 2, 6, 2, 7, 2, 8, 2,
		-5, 3, 0, 3, 5, 3,
		-6, 4, -5, 4, 5, 4, 6, 4,
		-6, 5, 6, 5,
		-4, 6, 4, 6,
		-5, 7, -4, 7, 4, 7, 5, 7,
		127
	},
	{		/* frog II (p3), from Lexicon */
		-3, -6, -2, -6, 2, -6, 3, -6,
		-3, -5, -1, -5, 1, -5, 3, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-5, 0, -2, 0, 0, 0, 2, 0, 5, 0,
		-4, 1, -2, 1, 2, 1, 4, 1,
		-5, 2, -4, 2, -2, 2, 2, 2, 4, 2, 5, 2,
		-1, 3, 0, 3, 1, 3,
		-2, 5, 0, 5, 1, 5,
		-2, 6, -1, 6, 1, 6,
		127
	},
	{		/* germ (p3), from Lexicon */
		-1, -5, 0, -5,
		0, -4,
		-2, -3,
		-3, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-3, -1, 2, -1,
		-4, 0, -3, 0, -1, 0,
		-3, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-5, 2, -3, 2, -1, 2, 4, 2,
		-5, 3, -4, 3, 0, 3, 1, 3, 2, 3,
		2, 4, 3, 4,
		127
	},
	{		/* glasses (p2), from Lexicon */
		-5, -5, 4, -5,
		-7, -4, -6, -4, -5, -4, 4, -4, 5, -4, 6, -4,
		-8, -3, 7, -3,
		-8, -2, -5, -2, -4, -2, -3, -2, 2, -2, 3, -2, 4, -2, 7, -2,
		-9, -1, -8, -1, -6, -1, -2, -1, 1, -1, 5, -1, 7, -1, 8, -1,
		-6, 0, -2, 0, -1, 0, 0, 0, 1, 0, 5, 0,
		-6, 1, -2, 1, 1, 1, 5, 1,
		-5, 2, -4, 2, -3, 2, 2, 2, 3, 2, 4, 2,
		-5, 4, -4, 4, -2, 4, 1, 4, 3, 4, 4, 4,
		-5, 5, -3, 5, -2, 5, 1, 5, 2, 5, 4, 5,
		127
	},
#if 0
	{		/* glider-block cycle, from Lexicon */
		-1, -3, 0, -3,
		-1, -2, 0, -2,
		-2, 1, 1, 1,
		-4, 2, -2, 2, 1, 2, 3, 2,
		-3, 3, -2, 3, 1, 3, 2, 3,
		127
	},
#endif
	{		/* glider pusher, from Lexicon */
		-3, -10, -2, -10,
		-3, -9, -2, -9,
		-2, -7,
		-3, -6, -1, -6,
		-3, -5, -1, -5,
		-2, -4,
		-5, -1, -4, -1, -2, -1, 0, -1, 1, -1,
		-5, 0, 1, 0,
		-4, 1, 0, 1,
		-11, 2, -3, 2, -2, 2, -1, 2,
		-10, 3,
		-12, 4, -11, 4, -10, 4,
		5, 7, 10, 7,
		3, 8, 4, 8, 6, 8, 7, 8, 8, 8, 9, 8, 11, 8, 12, 8,
		5, 9, 10, 9,
		127
	},
	{		/* Gosper glider gun (p30) */
		6, -4,
		5, -3, 6, -3,
		-6, -2, -5, -2, 8, -2, 9, -2, 16, -2,
		-7, -1, 8, -1, 9, -1, 10, -1, 16, -1, 17, -1,
		-18, 0, -17, 0, -8, 0, 8, 0, 9, 1,
		-17, 1, -8, 1, 5, 1, 6, 1,
		-8, 2, 6, 2,
		-7, 3,
		-6, 4, -5, 4,
		127
	},
	{		/* Gray counter (p4), from Lexicon */
		0, -4,
		-1, -3, 1, -3,
		-2, -2, 0, -2, 2, -2,
		-5, -1, -2, -1, 2, -1, 5, -1,
		-6, 0, -4, 0, -2, 0, 2, 0, 4, 0, 6, 0,
		-5, 1, -2, 1, 2, 1, 5, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
#if 0
	{		/* great on-off (p2), from Lexicon */
		-2, -4, -1, -4,
		-3, -3, 0, -3,
		-3, -2, -1, -2,
		-4, -1, -3, -1, -1, -1, 2, -1,
		0, 0, 1, 0, 3, 0,
		3, 1,
		0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
#endif
	{		/* harbor (p5), from Lexicon */
		-3, -8, -2, -8, 2, -8, 3, -8,
		-3, -7, -1, -7, 1, -7, 3, -7,
		-2, -6, 2, -6,
		-3, -4, -2, -4, 2, -4, 3, -4,
		-8, -3, -7, -3, -4, -3, -2, -3, 2, -3, 4, -3, 7, -3, 8, -3,
		-8, -2, -6, -2, -4, -2, -3, -2, 3, -2, 4, -2, 6, -2, 8, -2,
		-7, -1, 7, -1,
		-7, 1, 7, 1,
		-8, 2, -6, 2, -4, 2, -3, 2, 3, 2, 4, 2, 6, 2, 8, 2,
		-8, 3, -7, 3, -4, 3, -2, 3, 2, 3, 4, 3, 7, 3, 8, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		-2, 6, 2, 6,
		-3, 7, -1, 7, 1, 7, 3, 7,
		-3, 8, -2, 8, 2, 8, 3, 8,
		127
	},
	{		/* Hertz oscillator (p8) */
		-2, -5, -1, -5,
		-2, -4, -1, -4,
		-7, -2, -6, -2, -2, -2, -1, -2, 0, -2, 1, -2, 5, -2, 6, -2,
		-7, -1, -5, -1, -3, -1, 2, -1, 4, -1, 6, -1,
		-5, 0, -3, 0, -2, 0, 2, 0, 4, 0,
		-6, 1, -5, 1, -3, 1, 2, 1, 4, 1, 5, 1,
		-2, 2, -1, 2, 0, 2, 1, 2,
		-2, 4, -1, 4,
		-2, 5, -1, 5,
		127
	},
	{		/* hustler (p3), from Lexicon */
		0, -6, 1, -6,
		0, -5, 1, -5,
		-2, -3, -1, -3, 0, -3, 1, -3,
		-5, -2, -3, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 3, 1, 5, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		-1, 4, 0, 4,
		-1, 5, 0, 5,
		127
	},
	{		/* hustler II (p4), from Lexicon */
		-4, -6,
		-4, -5, -3, -5, -2, -5,
		-1, -4,
		-2, -3, 1, -3, 2, -3,
		-8, -2, -6, -2, -5, -2, -3, -2, -1, -2, 0, -2, 3, -2,
		-8, -1, -7, -1, -5, -1, -3, -1, 3, -1,
		-3, 0, 2, 0,
		-4, 1, 2, 1, 4, 1, 6, 1, 7, 1,
		-4, 2, -1, 2, 0, 2, 2, 2, 4, 2, 5, 2, 7, 2,
		-3, 3, -2, 3, 1, 3,
		0, 4,
		1, 5, 2, 5, 3, 5,
		3, 6,
		127
	},
	{		/* HW emulator (p4), from Lexicon */
		-1, -3, 0, -3,
		-6, -2, -5, -2, -3, -2, 2, -2, 4, -2, 5, -2,
		-6, -1, 5, -1,
		-5, 0, -4, 0, 3, 0, 4, 0,
		-8, 1, -7, 1, -6, 1, -3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
			5, 1, 6, 1, 7, 1,
		-8, 2, -5, 2, 4, 2, 7, 2,
		-7, 3, -6, 3, 5, 3, 6, 3,
		127
	},

	{		/* infinite growth 1 (from smallest number) */
		2, -3,
		0, -2, 2, -2, 3, -2,
		0, -1, 2, -1,
		0, 0,
		-2, 1,
		-4, 2, -2, 2,
		127
	},
	{		/* infinite growth 2 (from smallest area) */
		-2, -2, -1, -2, 0, -2, 2, -2,
		-2, -1,
		1, 0, 2, 0,
		-1, 1, 0, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		127
	},
	{		/* infinite growth 3 (from 1 dimension) */
		-19, 0, -18, 0, -17, 0, -16, 0, -15, 0, -14, 0, -13, 0,
			-12, 0, -10, 0, -9, 0, -8, 0, -7, 0, -6, 0, -2, 0,
			 -1, 0, 0, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 0,
			 13, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0,
		127
	},
	{		/* jack (p4), from Lexicon */
		-3, -4, 3, -4,
		-3, -3, -2, -3, 2, -3, 3, -3,
		-6, -2, -3, -2, -2, -2, 2, -2, 3, -2, 6, -2,
		-6, -1, -5, -1, -4, -1, -1, -1, 1, -1, 4, -1, 5, -1, 6, -1,
		-1, 0, 1, 0,
		-6, 1, -5, 1, -4, 1, -1, 1, 1, 1, 4, 1, 5, 1, 6, 1,
		-6, 2, -3, 2, -2, 2, 2, 2, 3, 2, 6, 2,
		-3, 3, -2, 3, 2, 3, 3, 3,
		-3, 4, 3, 4,
		127
	},
	{		/* jam (p3), from Lexicon */
		0, -3, 1, -3,
		-1, -2, 2, -2,
		-3, -1, 0, -1, 2, -1,
		-3, 0, 1, 0,
		-3, 1,
		0, 2,
		-2, 3, -1, 3,
		127
	},
#if 0
	{		/* Kok's galaxy (p8), from Lexicon */
		-4, -4, -3, -4, -2, -4, -1, -4, 0, -4, 1, -4, 3, -4, 4, -4, 
		-4, -3, -3, -3, -2, -3, -1, -3, 0, -3, 1, -3, 3, -3, 4, -3, 
		3, -2, 4, -2, 
		-4, -1, -3, -1, 3, -1, 4, -1, 
		-4, 0, -3, 0, 3, 0, 4, 0, 
		-4, 1, -3, 1, 3, 1, 4, 1, 
		-4, 2, -3, 2, 
		-4, 3, -3, 3, -1, 3, 0, 3, 1, 3, 2, 3, 3, 3, 4, 3, 
		-4, 4, -3, 4, -1, 4, 0, 4, 1, 4, 2, 4, 3, 4, 4, 4, 
		127
	},
#endif
	{		/* Laputa (p2), from Lexicon */
		-3, -3, -2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, 0, -2, 4, -2, 5, -2,
		2, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 2, 0, 3, 0, 4, 0,
		-6, 1, -3, 1, -1, 1,
		-6, 2, -5, 2, -1, 2, 1, 2, 2, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		127
	},
	{		/* light bulb (p2), from Lexicon */
		-2, -4, -1, -4, 1, -4,
		-2, -3, 0, -3, 1, -3,
		-1, -1, 0, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1,
		-1, 2, 1, 2,
		-3, 3, -1, 3, 1, 3, 3, 3,
		-3, 4, -2, 4, 2, 4, 3, 4,
		127
	},
	{		/* light bulb II (p2), from Lexicon */
		-1, -4,
		-3, -3, -2, -3, -1, -3,
		-4, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1,
		2, 0,
		-2, 1, 2, 1,
		-2, 2, -1, 2, 1, 2,
		2, 3, 3, 3, 4, 3,
		4, 4,
		127
	},
	{		/* loading dock (p3), from Lexicon */
		0, -4,
		-2, -3, -1, -3, 0, -3,
		-3, -2, 1, -2, 2, -2,
		-4, -1, -2, -1, -1, -1, 3, -1,
		-3, 0, 1, 0, 2, 0, 4, 0,
		-2, 1, -1, 1, 3, 1,
		0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
	{		/* LW emulator (p4), from Lexicon */
		-5, -3, -4, -3, -2, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 4, -2,
		-4, -1, -3, -1, 2, -1, 3, -1,
		-7, 0, -6, 0, -5, 0, -2, 0, -1, 0, 0, 0, 1, 0, 4, 0, 5, 0,
			6, 0,
		-7, 1, -4, 1, 3, 1, 6, 1,
		-6, 2, -5, 2, 4, 2, 5, 2,
		127
	},
	{		/* mathematician (p5), from Lexicon */
		0, -5, 
		-1, -4, 1, -4, 
		-1, -3, 1, -3, 
		-2, -2, -1, -2, 1, -2, 2, -2, 
		-4, -1, 4, -1, 
		-4, 0, -3, 0, -2, 0, 2, 0, 3, 0, 4, 0, 
		-4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2, 
		-4, 3, 4, 3, 
		-1, 4, 0, 4, 1, 4, 2, 4, 
		-1, 5, 2, 5, 3, 5, 
		127
	},
	{		/* metamorphosis, from Lexicon */
		5, -9, 
		6, -8, 
		4, -7, 5, -7, 6, -7, 
		-2, -1, 2, -1, 8, -1, 10, -1, 11, -1, 
		-14, 0, -13, 0, -3, 0, 3, 0, 8, 0, 10, 0, 12, 0, 
		-14, 1, -13, 1, -3, 1, 7, 1, 12, 1, 
		-3, 2, -2, 2, 2, 2, 8, 2, 10, 2, 12, 2, 
		-1, 3, 0, 3, 1, 3, 8, 3, 10, 3, 11, 3, 
		-1, 5, 0, 5, 1, 5, 
		-3, 6, -2, 6, 2, 6, 
		-14, 7, -13, 7, -3, 7, 13, 7, 14, 7, 
		-14, 8, -13, 8, -3, 8, 3, 8, 13, 8, 14, 8, 
		-2, 9, 2, 9, 
		127
	},
	{		/* metamorphosis II, from Lexicon */
		10, -15, 
		9, -14, 
		9, -13, 10, -13, 11, -13, 
		-3, -10, -1, -10, 
		-3, -9, 0, -9, 
		-12, -8, -11, -8, 0, -8, 1, -8, 
		-12, -7, -11, -7, -2, -7, 2, -7, 3, -7, 
		-7, -6, -6, -6, 0, -6, 1, -6, 
		-8, -5, -3, -5, 0, -5, 
		-3, -4, -1, -4, 
		4, 1, 
		3, 2, 4, 2, 5, 2, 
		2, 3, 3, 3, 4, 3, 5, 3, 6, 3, 
		1, 4, 3, 4, 5, 4, 7, 4, 
		1, 5, 2, 5, 6, 5, 7, 5, 
		4, 8, 
		3, 9, 5, 9, 
		3, 10, 5, 10, 
		4, 11, 
		3, 12, 4, 12, 
		3, 13, 4, 13, 
		3, 14, 4, 14, 
		127
	},
	{		/* mini pressure cooker (p3), from Lexicon */
		0, -5, 
		-1, -4, 1, -4, 
		-1, -3, 1, -3, 
		-2, -2, -1, -2, 1, -2, 2, -2, 
		-5, -1, -3, -1, 3, -1, 5, -1, 
		-5, 0, -4, 0, -2, 0, 0, 0, 2, 0, 4, 0, 5, 0, 
		-2, 1, 2, 1, 
		-2, 2, 0, 2, 2, 2, 
		-1, 3, 1, 3, 
		0, 4, 
		127
	},
	{		/* multum in parvo (stabilizes at 3933) */
		0, -2, 1, -2, 2, -2, 
		-1, -1, 2, -1, 
		-2, 0, 
		-3, 1, 
		127
	},
	{		/* MW emulator (p4), from Lexicon */
		-5, -3, -4, -3, -2, -3, 2, -3, 4, -3, 5, -3,
		-5, -2, 5, -2,
		-4, -1, -3, -1, 3, -1, 4, -1,
		-7, 0, -6, 0, -5, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 5, 0,
			6, 0, 7, 0,
		-7, 1, -4, 1, 4, 1, 7, 1,
		-6, 2, -5, 2, 5, 2, 6, 2,
		127
	},
	{		/* MW volcano (p5), from Lexicon */
		0, -6, 
		-2, -5, 2, -5, 
		-3, -3, 3, -3, 
		-5, -2, -4, -2, -3, -2, -1, -2, 0, -2, 1, -2, 3, -2, 4, -2, 5, -2, 
		-6, -1, -2, -1, -1, -1, 1, -1, 2, -1, 6, -1, 
		-6, 0, -4, 0, -3, 0, -2, 0, 0, 0, 2, 0, 3, 0, 4, 0, 5, 0, 
		-5, 1, 
		-3, 2, -1, 2, 1, 2, 3, 2, 4, 2, 6, 2, 
		-4, 3, -3, 3, -1, 3, 0, 3, 1, 3, 3, 3, 5, 3, 6, 3, 
		-3, 4, -1, 4, 2, 4, 
		-3, 5, 0, 5, 1, 5, 
		-4, 6, -3, 6, 
		127
	},
	{		/* negentropy (p2), from Lexicon */
		-2, -6, -1, -6, 1, -6, 
		-2, -5, 0, -5, 1, -5, 
		-1, -3, 0, -3, 1, -3, 
		-2, -2, 0, -2, 2, -2, 4, -2, 5, -2, 
		-2, -1, -1, -1, 2, -1, 4, -1, 5, -1, 
		-5, 0, -4, 0, -2, 0, 2, 0, 
		-5, 1, -4, 1, -2, 1, 2, 1, 
		-1, 2, 0, 2, 1, 2, 
		-1, 4, 0, 4, 2, 4, 
		-1, 5, 1, 5, 2, 5, 
		127
	},
	{		/* new five (p3), from Lexicon */
		-2, -4, -1, -4, 
		-3, -3, 0, -3, 
		-3, -2, -1, -2, 2, -2, 
		-4, -1, -3, -1, -1, -1, 1, -1, 2, -1, 
		-4, 0, 
		-3, 1, -2, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1, 
		1, 2, 4, 2, 
		-4, 3, -2, 3, -1, 3, 
		-4, 4, -3, 4, -1, 4, 0, 4, 
		127
	},
	{		/* Noah's ark (2 switch engines), from Lexicon */
		3, -7, 5, -7, 
		2, -6, 
		3, -5, 6, -5, 
		5, -4, 6, -4, 7, -4, 
		-6, 2, 
		-7, 3, -5, 3, 
		-7, 5, -4, 5, 
		-5, 6, -4, 6, 
		-4, 7, 
		127
	},
	{		/* octagon II (p5) (shining flower) */
		-1, -4, 0, -4,
		-2, -3, 1, -3,
		-3, -2, 2, -2,
		-4, -1, 3, -1,
		-4, 0, 3, 0,
		-3, 1, 2, 1,
		-2, 2, 1, 2,
		-1, 3, 0, 3,
		127
	},
	{		/* octagon IV (p4), from Lexicon */
		-1, -8, 0, -8, 
		-1, -7, 0, -7, 
		-2, -5, -1, -5, 0, -5, 1, -5, 
		-3, -4, 2, -4, 
		-4, -3, 3, -3, 
		-5, -2, 4, -2, 
		-8, -1, -7, -1, -5, -1, 4, -1, 6, -1, 7, -1, 
		-8, 0, -7, 0, -5, 0, 4, 0, 6, 0, 7, 0, 
		-5, 1, 4, 1, 
		-4, 2, 3, 2, 
		-3, 3, 2, 3, 
		-2, 4, -1, 4, 0, 4, 1, 4, 
		-1, 6, 0, 6, 
		-1, 7, 0, 7, 
		127
	},
	{	       /* odd keys (p3), fom Lexicon */
		4, -2,
		-5, -1, 3, -1, 5, -1,
		-6, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-5, 1, -2, 1, 1, 1,
		-2, 2, 1, 2,
		127
	},
#if 0
	{		/* Orion (c/4 diagonal, p4) (big glider 1) */
		-4, -7, -3, -7,
		-4, -6, -2, -6,
		-4, -5,
		-7, -4, -6, -4, -4, -4,
		-7, -3, -2, -3,
		-7, -2, -5, -2, -4, -2, 3, -2, 4, -2, 5, -2,
		-2, -1, -1, -1, 0, -1, 5, -1, 6, -1,
		-1, 0, 0, 0, 1, 0, 3, 0, 5, 0,
		6, 1,
		-1, 2, 1, 2,
		-2, 3, -1, 3, 1, 3,
		-1, 4,
		-3, 5, -2, 5, 0, 5,
		0, 6,
		-2, 7, -1, 7,
		127
	},
#endif
	{		/* Orion (c/4 diagonal, p4) (smaller variant) */
		-5, -6, -4, -6,
		-6, -5, -5, -5,
		-4, -4,
		-2, -3, 3, -3, 4, -3, 5, -3,
		-2, -2, -1, -2, 0, -2, 5, -2, 6, -2,
		-1, -1, 0, -1, 1, -1, 3, -1, 5, -1,
		6, 0,
		-1, 1, 1, 1,
		-2, 2, -1, 2, 1, 2,
		-1, 3,
		-3, 4, -2, 4, 0, 4,
		0, 5,
		-2, 6, -1, 6,
		127
	},
	{	       /* p22 oscillator, from Lexicon */
		-13, -5, -12, -5,
		-12, -4,
		-12, -3, -10, -3, 5, -3, 6, -3,
		-11, -2, -10, -2, 3, -2, 4, -2, 7, -2,
		-7, -1, -6, -1, -5, -1, 3, -1, 4, -1, 6, -1, 7, -1,
		-7, 0, -6, 0, -4, 0, -3, 0, 5, 0, 6, 0, 7, 0,
		-7, 1, -4, 1, -3, 1, 10, 1, 11, 1,
		-6, 2, -5, 2, 10, 2, 12, 2,
		12, 3,
		12, 4, 13, 4,
		127
	},
	{		/* p54 shuttle (piston3) */
		-14, -8, -13, -8, 13, -8, 14, -8,
		-13, -7, 13, -7,
		-13, -6, -11, -6, 11, -6, 13, -6,
		-12, -5, -11, -5, -1, -5, 11, -5, 12, -5,
		0, -4,
		-6, -3, -5, -3, 1, -3,
		-6, -2, -5, -2, -2, -2, 0, -2,
		-1, -1,
		-1, 1,
		-6, 2, -5, 2, -2, 2, 0, 2,
		-6, 3, -5, 3, 1, 3,
		0, 4,
		-12, 5, -11, 5, -1, 5, 11, 5, 12, 5,
		-13, 6, -11, 6, 11, 6, 13, 6,
		-13, 7, 13, 7,
		-14, 8, -13, 8, 13, 8, 14, 8,
		127
	},
	{	       /* pedestle (p5) */
		0, -8,
		-1, -7, 1, -7,
		-4, -6, -1, -6, 0, -6,
		-4, -5, -3, -5, -2, -5,
		0, -4, 1, -4, 2, -4,
		-2, -3, -1, -3, 3, -3,
		-3, -2, 2, -2, 5, -2,
		-4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 0, 1, 2, 1, 4, 1,
		-5, 2, -2, 2, 3, 2,
		-3, 3, 1, 3, 2, 3,
		-2, 4, -1, 4, 0, 4,
		2, 5, 3, 5, 4, 5,
		0, 6, 1, 6, 4, 6,
		-1, 7, 1, 7,
		0, 8,
		127
	},
	{	       /* penny lane (p4) */
		-4, -5, -3, -5, 3, -5, 4, -5,
		-4, -4, 4, -4,
		-7, -3, -6, -3, -4, -3, 4, -3, 6, -3, 7, -3,
		-7, -2, -6, -2, -4, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2,
			 4, -2, 6, -2, 7, -2,
		-3, -1, 0, -1, 3, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		0, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
	{		/* pentadecathlon (p15), from Lexicon */
	/* -5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, */
		1, -4,
		1, -3, 3, -3,
		1, -2, 2, -2,
		-5, 0, -4, 0, -3, 0,
		-3, 1,
		-4, 2, 2, 2, 3, 2,
		3, 3, 4, 3,
		2, 4,
		127
	},
	{	       /* pentant (p5), from Lexicon */
		-5, -6, -4, -6,
		-4, -5,
		-4, -4, -2, -4,
		-3, -3, -2, -3, 3, -3, 4, -3,
		4, -2,
		0, -1, 1, -1, 2, -1, 3, -1,
		0, 0,
		-3, 1, 1, 1, 2, 1, 3, 1,
		-3, 2, -2, 2, -1, 2, 0, 2, 3, 2,
		0, 3,
		-1, 4,
		-1, 5, 0, 5,
		127
	},
	{	       /* pentoad (p5), from Lexicon */
		5, -6, 6, -6,
		5, -5,
		3, -4, 5, -4,
		3, -3, 4, -3,
		-1, -2, 0, -2,
		0, -1,
		0, 0,
		0, 1, 1, 1,
		-4, 2, -3, 2,
		-5, 3, -3, 3,
		-5, 4,
		-6, 5, -5, 5,
		127
	},
	{		/* pi oscillator (p88) */
		6, -12,
		4, -11, 5, -11, 6, -11,
		3, -10,
		3, -9, 4, -9,
		-13, -8, -12, -8, 8, -8, 9, -8,
		-12, -7, 8, -7,
		-12, -6, -10, -6, 6, -6, 8, -6,
		-11, -5, -10, -5, 6, -5, 7, -5,
		0, -3, 1, -3, 2, -3,
		0, -2, 2, -2,
		0, -1, 2, -1,
		-7, 5, -6, 5, 10, 5, 11, 5,
		-8, 6, -6, 6, 10, 6, 12, 6,
		-8, 7, 12, 7,
		-9, 8, -8, 8, 12, 8, 13, 8,
		-4, 9, -3, 9,
		-3, 10,
		-6, 11, -5, 11, -4, 11,
		-6, 12,
		127
	},
	{	       /* pipsquirter (example) (p6), from Lexicon */
		-2, -7,
		-2, -6,
		-4, -4, 0, -4,
		-6, -3, -5, -3, -4, -3, -2, -3, 0, -3, 1, -3, 2, -3,
		-7, -2, -3, -2, -2, -2, 3, -2,
		-7, -1, -5, -1, -4, -1, -1, -1, 0, -1, 2, -1, 4, -1,
		-6, 0, -3, 0, -2, 0, 1, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -1, 1, 0, 1, 2, 1, 4, 1, 6, 1, 7, 1,
		-3, 2, 0, 2, 2, 2, 4, 2, 6, 2, 7, 2,
		-3, 3, -2, 3, -1, 3, 0, 3, 2, 3, 3, 3,
		1, 4,
		-1, 5, 1, 5,
		-1, 6, 0, 6,
		127
	},
	{		/* pi ship with fuse (], near ship) */
		0, -2,
		-1, -1, 1, -1,
		-12, 0, -11, 0, -2, 0, -1, 0, 1, 0, 2, 0, 11, 0, 12, 0,
		-12, 1, -11, 1, 11, 1, 12, 1,
		127
	},
	{	       /* piston (p2) */
		-5, -2, -4, -2, 4, -2, 5, -2,
		-5, -1, -3, -1, 0, -1, 3, -1, 5, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-5, 1, -3, 1, 0, 1, 3, 1, 5, 1,
		-5, 2, -4, 2, 4, 2, 5, 2,
		127
	},
	{		/* pre-pulsar oscillator (p28) (4 molds, flutter) */
		-9, -7, -7, -7, 7, -7, 9, -7,
		-6, -6, 6, -6,
		-10, -5, -7, -5, 7, -5, 10, -5,
		-11, -4, -9, -4, -7, -4, 7, -4, 9, -4, 11, -4,
		-11, -3, -8, -3, 8, -3, 11, -3,
		-10, -2, -9, -2, -4, -2, -3, -2, -2, -2,
		2, -2, 3, -2, 4, -2, 9, -2, 10, -2,
		-3, -1, 3, -1,
		-10, 1, -9, 1, 9, 1, 10, 1,
		-11, 2, -8, 2, 8, 2, 11, 2,
		-11, 3, -9, 3, -6, 3, 6, 3, 9, 3, 11, 3,
		-10, 4, 10, 4,
		-9, 5, -8, 5, -6, 5, 6, 5, 8, 5, 9, 5,
		-7, 6, 7, 6,
		127
	},
	{	       /* pressure cooker (p3) */
		0, -6,
		-1, -5, 1, -5,
		-1, -4, 1, -4,
		-2, -3, -1, -3, 1, -3, 2, -3,
		-5, -2, -3, -2, 3, -2, 5, -2,
		-5, -1, -4, -1, -2, -1, 0, -1, 2, -1, 4, -1, 5, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1,
		-1, 2, 0, 2, 1, 2,
		-2, 4, 0, 4, 1, 4,
		-2, 5, -1, 5, 1, 5,
		127
	},
	{	       /* protein (p3), from Lexicon */
		-2, -6, -1, -6,
		-2, -5,
		0, -4,
		-4, -3, -3, -3, -2, -3, -1, -3, 1, -3, 3, -3, 4, -3,
		-5, -2, 1, -2, 3, -2, 6, -2,
		-5, -1, -2, -1, -1, -1, 1, -1, 3, -1, 5, -1, 6, -1,
		-6, 0, -5, 0, -3, 0, 3, 0,
		-3, 1, 0, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		-2, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
	{		/* puffer (example), from Lexicon */
		-12, -3, -11, -3, -10, -3, -3, -3, 3, -3, 10, -3, 11, -3,
			12, -3,
		-13, -2, -10, -2, -4, -2, -3, -2, -2, -2, 2, -2, 3, -2, 4,
			-2, 10, -2, 13, -2,
		-10, -1, -5, -1, -4, -1, -2, -1, 2, -1, 4, -1, 5, -1, 10, -1,
		-10, 0, 10, 0,
		-10, 1, -7, 1, 7, 1, 10, 1,
		-10, 2, -7, 2, -6, 2, 6, 2, 7, 2, 10, 2,
		-11, 3, -7, 3, -6, 3, 6, 3, 7, 3, 11, 3,
		127
	},
	{		/* puffer train, from Lexicon */
		1, -9,
		2, -8,
		-2, -7, 2, -7,
		-1, -6, 0, -6, 1, -6, 2, -6,
		-2, -2,
		-1, -1, 0, -1,
		0, 0,
		0, 1,
		-1, 2,
		1, 5,
		2, 6,
		-2, 7, 2, 7,
		-1, 8, 0, 8, 1, 8, 2, 8,
		127
	},
	{		/* pulsar (p3) (pulsar CP 48-56-72) */
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, 2, 0,
		127
	},
	{	       /* pushalong (example), from Lexicon */
		-4, -6, -3, -6, -2, -6, 0, -6,
		-5, -5, -4, -5, -3, -5, -2, -5, 0, -5,
		-6, -4, -5, -4,
		-5, -3, -3, -3,
		-4, -2, -3, -2, -2, -2, -1, -2, 1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		0, 3, 5, 3,
		0, 4,
		1, 5, 5, 5,
		3, 6,
		127
	},
	{	       /* pyrotechnecium (p8), from Lexicon */
		-1, -5,
		-3, -4, -2, -4, -1, -4, 0, -4, 1, -4,
		-4, -3, 2, -3,
		-7, -2, -4, -2, -2, -2, 0, -2, 1, -2, 3, -2,
		-8, -1, -6, -1, -4, -1, -2, -1, 3, -1, 6, -1,
		-7, 0, -4, 0, 1, 0, 3, 0, 5, 0, 7, 0,
		-4, 1, -2, 1, -1, 1, 1, 1, 3, 1, 6, 1,
		-3, 2, 3, 2,
		-2, 3, -1, 3, 0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
	{	       /* R2D2 (p8) */
		0, -5,
		-1, -4, 1, -4,
		-2, -3, 0, -3, 2, -3,
		-2, -2, 0, -2, 2, -2,
		-5, -1, -4, -1, -2, -1, 2, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 2, 1,
		-2, 2, 0, 2, 2, 2,
		-1, 3, 1, 3,
		0, 4,
		127
	},
	{		/* rake p20 backwards */
		0, -10, 1, -10, 10, -10,
		-1, -9, 0, -9, 1, -9, 2, -9, 11, -9,
		-1, -8, 0, -8, 2, -8, 3, -8, 7, -8, 11, -8,
		1, -7, 2, -7, 8, -7, 9, -7, 10, -7, 11, -7,
		6, -3, 7, -3,
		5, -2, 6, -2, 8, -2, 9, -2,
		6, -1, 9, -1,
		6, 0, 9, 0,
		7, 1, 8, 1,
		10, 4,
		11, 5,
		-8, 6, 7, 6, 11, 6,
		-7, 7, 8, 7, 9, 7, 10, 7, 11, 7,
		-11, 8, -7, 8,
		-10, 9, -9, 9, -8, 9, -7, 9,
		127
	},
	{		/* rake p20 forwards */
		0, -10, 1, -10, 10, -10,
		-1, -9, 0, -9, 1, -9, 2, -9, 11, -9,
		-1, -8, 0, -8, 2, -8, 3, -8, 7, -8, 11, -8,
		1, -7, 2, -7, 8, -7, 9, -7, 10, -7, 11, -7,
		6, -3, 7, -3,
		5, -2, 6, -2, 8, -2, 9, -2,
		6, -1, 9, -1,
		6, 0, 9, 0,
		7, 1, 8, 1,
		10, 4,
		11, 5,
		7, 6, 11, 6,
		-9, 7, -8, 7, -7, 7, -6, 7, 8, 7, 9, 7, 10, 7, 11, 7,
		-10, 8, -6, 8,
		-6, 9,
		-7, 10,
		127
	},
	{		/* rake p24 backwards */
		-5, -10,
		-4, -9,
		-10, -8, -4, -8,
		-9, -7, -8, -7, -7, -7, -6, -7, -5, -7, -4, -7,
		6, -6, 7, -6,
		5, -5, 6, -5, 7, -5, 8, -5,
		5, -4, 6, -4, 8, -4, 9, -4,
		7, -3, 8, -3,
		0, -2, 2, -2,
		-1, -1, 2, -1, 3, -1,
		0, 0, 2, 0,
		7, 1, 8, 1,
		5, 2, 6, 2, 8, 2, 9, 2,
		5, 3, 6, 3, 7, 3, 8, 3,
		6, 4, 7, 4,
		-5, 6, -4, 6,
		-9, 7, -8, 7, -7, 7, -6, 7, -4, 7, -3, 7,
		-9, 8, -8, 8, -7, 8, -6, 8, -5, 8, -4, 8,
		-8, 9, -7, 9, -6, 9, -5, 9,
		127
	},
	{	       /* rats (p6) */
		-1, -5, 0, -5,
		0, -4,
		-2, -3,
		-6, -2, -5, -2, -3, -2, -1, -2, 0, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, 3, -1, 5, -1,
		-3, 0, 0, 0, 1, 0, 2, 0, 4, 0, 5, 0,
		-3, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 2, 2,
		1, 3,
		0, 4,
		0, 5, 1, 5,
		127
	},
	{	       /* reflector (figure-8 example), from Lexicon */
		-2, -7, -1, -7, 5, -7, 6, -7,
		-8, -6, -6, -6, -2, -6, -1, -6, 5, -6,
		-7, -5, -6, -5, 3, -5, 5, -5,
		-7, -4, 3, -4, 4, -4,
		-1, -3, 0, -3,
		-1, -2, 1, -2,
		0, -1,
		3, 1, 4, 1, 5, 1,
		3, 2, 4, 2, 5, 2,
		3, 3, 4, 3, 5, 3,
		6, 4, 7, 4, 8, 4,
		6, 5, 7, 5, 8, 5,
		6, 6, 7, 6, 8, 6,
		127
	},
	{	       /*  relay (p(60+120n)), from Lexicon */
		10, -3, 15, -3,
		-1, -2, 0, -2, 8, -2, 9, -2, 11, -2, 12, -2, 13, -2, 14, -2,
			16, -2, 17, -2,
		0, -1, 1, -1, 10, -1, 15, -1,
		-1, 0,
		-15, 1, -10, 1,
		-17, 2, -16, 2, -14, 2, -13, 2, -12, 2, -11, 2, -9, 2, -8, 2,
		-15, 3, -10, 3,
		127
	},
#if 0
	{	       /* rephaser */
		-2, -3, 1, -3,
		-4, -2, -2, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, 1, -1, 2, -1,
		-1, 2, 0, 2,
		-1, 3, 0, 3,
		127
	},
#endif
	{		/* R-pentomino (stabilizes at 1103), from Lexicon */
		0, -1, 1, -1,
		-1, 0, 0, 0,
		0, 1,
		127
	},
	{		/* Schick engine (c/2, p12) (sym puffer) */
		1, -4, 2, -4, 3, -4, 4, -4,
		0, -3, 4, -3,
		4, -2,
		-4, -1, -3, -1, 0, -1, 3, -1,
		-4, 0, -3, 0, -2, 0,
		-4, 1, -3, 1, 0, 1, 3, 1,
		4, 2,
		0, 3, 4, 3,
		1, 4, 2, 4, 3, 4, 4, 4,
		127
	},
#if 0
	{	       /* scrubber (p2), from Lexicon */
		-1, -5,
		-3, -4, -2, -4, -1, -4,
		-4, -3,
		-4, -2, -1, -2, 0, -2, 1, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-2, 0, 2, 0,
		-2, 1, 2, 1, 4, 1, 5, 1,
		-1, 2, 0, 2, 1, 2, 4, 2,
		4, 3,
		1, 4, 2, 4, 3, 4,
		1, 5,
		127
	},
#endif
	{		/* ship smallest known c/3, p3 */
		0, -8,
		-1, -7, 1, -7,
		-1, -6, 1, -6,
		-1, -5,
		-2, -3, -1, -3,
		-1, -2, 1, -2,
		-2, -1, 0, -1,
		-2, 0, -1, 0, 0, 0,
		-1, 2, 1, 2,
		-1, 3, 0, 3,
		0, 4,
		0, 5, 2, 5,
		0, 6, 2, 6,
		1, 7,
		127
	},
	{		/* ship smallest known 2c/5, p5 */
		0, -6, 
		-3, -5, -2, -5, 0, -5, 1, -5, 
		-4, -4, -2, -4, 0, -4, 
		-5, -3, -4, -3, 0, -3, 
		-4, -2, -2, -2, 1, -2, 
		-3, -1, -2, -1, 0, -1, 
		1, 1, 2, 1, 
		0, 2, 2, 2, 3, 2, 4, 2, 
		-1, 3, 3, 3, 4, 3, 5, 3, 
		0, 4, 2, 4, 
		1, 5, 
		127
	},
	{		/* ship 2nd smallest known 2c/5, p5 */
		1, -7, 3, -7,
		-2, -6, 3, -6,
		-3, -5, -2, -5, -1, -5, 4, -5,
		-4, -4, -2, -4,
		-5, -3, -4, -3, -1, -3, 0, -3, 5, -3,
		-4, -2, -3, -2, 0, -2, 1, -2, 2, -2, 3, -2, 4, -2,
		-4, 2, -3, 2, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		-5, 3, -4, 3, -1, 3, 0, 3, 5, 3,
		-4, 4, -2, 4,
		-3, 5, -2, 5, -1, 5, 4, 5,
		-2, 6, 3, 6,
		1, 7, 3, 7,
		127
	},
	{		/* ship smallest known c/4, p4, from col of small ss */
		-4, -9, -3, -9, -2, -9,
		-5, -8, -1, -8, 0, -8,
		2, -7,
		-5, -6, -1, -6, 3, -6, 4, -6,
		-5, -5, -1, -5, 2, -5,
		-1, -4, 0, -4,
		-5, -3, -1, -3,
		-5, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		-3, 1, -2, 1, -1, 1,
		-5, 2, -1, 2,
		-5, 3, -1, 3,
		-1, 4, 0, 4,
		-5, 5, -1, 5, 2, 5,
		-5, 6, -1, 6, 3, 6, 4, 6,
		2, 7,
		-5, 8, -1, 8, 0, 8,
		-4, 9, -3, 9, -2, 9,
		127
	},
	{		/* ship2 (p4, c/2) */
		-4, -7, -3, -7, -1, -7, 0, -7, 1, -7, 2, -7, 3, -7, 4, -7,
		-5, -6, -4, -6, -3, -6, -2, -6, 5, -6,
		-6, -5, -5, -5,
		-5, -4, 5, -4,
		-4, -3, -3, -3, -2, -3, 0, -3,
		-2, -2,
		-2, -1,
		-1, 0,
		-2, 1,
		-2, 2,
		-4, 3, -3, 3, -2, 3, 0, 3,
		-5, 4, 5, 4,
		-6, 5, -5, 5,
		-5, 6, -4, 6, -3, 6, -2, 6, 5, 6,
		-4, 7, -3, 7, -1, 7, 0, 7, 1, 7, 2, 7, 3, 7, 4, 7,
		127
	},
	{	       /* short keys (p3), from Lexicon */
		-5, -2, 4, -2,
		-6, -1, -4, -1, -3, -1, -2, -1, 1, -1, 2, -1, 3, -1, 5, -1,
		-5, 0, -2, 0, 1, 0, 4, 0,
		-2, 1, 1, 1,
		127
	},
	{		/* shower tub (p8) (part of oscillators) */
		-3, -6, -2, -6, 2, -6, 3, -6,
		-4, -5, -2, -5, 2, -5, 4, -5,
		-4, -4, 4, -4,
		-7, -3, -6, -3, -4, -3, -3, -3, 3, -3, 4, -3, 6, -3, 7, -3,
		-7, -2, -6, -2, -4, -2, 0, -2, 4, -2, 6, -2, 7, -2,
		-4, -1, -2, -1, 2, -1, 4, -1,
		-4, 0, -2, 0, 2, 0, 4, 0,
		-5, 1, -4, 1, -2, 1, 2, 1, 4, 1, 5, 1,
		-4, 2, -1, 2, 0, 2, 1, 2, 4, 2,
		-4, 3, 4, 3, 6, 3,
		-3, 4, -2, 4, -1, 4, 5, 4, 6, 4,
		-1, 5,
		127
	},
	{	       /* side-shooting gun (portion), from Lexicon */
		6, -10, 7, -10,
		6, -9, 7, -9,
		0, -8, 1, -8, 2, -8,
		2, -7,
		1, -6, 7, -6, 8, -6,
		6, -5, 8, -5,
		8, -4,
		-7, 7,
		-7, 8, -6, 8,
		-8, 9, -6, 9,
		127
	},
	{	       /* siesta (p5), from Lexicon */
		3, -6, 4, -6,
		-5, -5, -4, -5, 2, -5, 4, -5,
		-5, -4, -3, -4, 2, -4,
		-3, -3, 1, -3, 2, -3, 4, -3,
		-5, -2, -3, -2, -2, -2, 4, -2, 5, -2, 6, -2,
		-7, -1, -6, -1, -5, -1, 1, -1, 3, -1, 7, -1,
		-8, 0, -4, 0, -2, 0, 4, 0, 5, 0, 6, 0,
		-7, 1, -6, 1, -5, 1, 1, 1, 2, 1, 4, 1,
		-5, 2, -3, 2, -2, 2, 2, 2,
		-3, 3, 2, 3, 4, 3,
		-5, 4, -3, 4, 3, 4, 4, 4,
		-5, 5, -4, 5,
		127
	},
	{	       /* six Ls (p3), from Lexicon */
		0, -4,
		-2, -3, -1, -3, 0, -3, 3, -3,
		-3, -2, 1, -2, 2, -2, 3, -2,
		-3, -1, -2, -1, -1, -1,
		1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 3, 1,
		-3, 2, 0, 2, 1, 2, 2, 2,
		0, 3,
		127
	},
	{		/* smiley (p8), from Lexicon */
		-3, -3, -2, -3, -1, -3, 1, -3, 2, -3, 3, -3,
		-2, -2, 0, -2, 2, -2,
		-2, 0, 2, 0,
		-3, 2, -1, 2, 1, 2, 3, 2,
		-1, 3, 1, 3,
		127
	},
	{	       /* snacker (p9), from Lexicon */
		-10, -5, -9, -5, 8, -5, 9, -5,
		-9, -4, 8, -4,
		-9, -3, -7, -3, 6, -3, 8, -3,
		-8, -2, -7, -2, 6, -2, 7, -2,
		-3, -1, 2, -1,
		-5, 0, -4, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 4, 0,
		-3, 1, 2, 1,
		-8, 2, -7, 2, 6, 2, 7, 2,
		-9, 3, -7, 3, 6, 3, 8, 3,
		-9, 4, 8, 4,
		-10, 5, -9, 5, 8, 5, 9, 5,
		127
	},
	{	       /* sombreros (p6), from Lexicon */
		-6, -5, -5, -5, 4, -5, 5, -5,
		-6, -4, -4, -4, 3, -4, 5, -4,
		-4, -3, 3, -3,
		-6, -2, -4, -2, -3, -2, 2, -2, 3, -2, 5, -2,
		-8, -1, -7, -1, -6, -1, 5, -1, 6, -1, 7, -1,
		-9, 0, -5, 0, -3, 0, 2, 0, 4, 0, 8, 0,
		-8, 1, -7, 1, -6, 1, 5, 1, 6, 1, 7, 1,
		-6, 2, -4, 2, -3, 2, 2, 2, 3, 2, 5, 2,
		-4, 3, 3, 3,
		-6, 4, -4, 4, 3, 4, 5, 4,
		-6, 5, -5, 5, 4, 5, 5, 5,
		127
	},
	{		/* spider (c/5, p5), from col. of small spaceships */
		0, -13, 1, -13,
		-3, -12, -2, -12, 1, -12,
		-3, -11, -2, -11, 1, -11,
		2, -10,
		-3, -9, -1, -9, 0, -9, 1, -9, 2, -9,
		-4, -8, -3, -8, -1, -8,
		0, -7, 1, -7, 2, -7,
		1, -6,
		1, -5, 2, -5,
		3, -4,
		2, -3,
		2, -2,
		-2, -1, -1, -1, 0, -1,
		-2, 1, -1, 1, 0, 1,
		2, 2,
		2, 3,
		3, 4,
		1, 5, 2, 5,
		1, 6,
		0, 7, 1, 7, 2, 7,
		-4, 8, -3, 8, -1, 8,
		-3, 9, -1, 9, 0, 9, 1, 9, 2, 9,
		2, 10,
		-3, 11, -2, 11, 1, 11,
		-3, 12, -2, 12, 1, 12,
		0, 13, 1, 13,
		127
	},
	{	       /* stillater (p3), from Lexicon */
		-1, -4,
		-2, -3, 0, -3, 2, -3, 3, -3,
		-2, -2, 0, -2, 1, -2, 3, -2,
		-4, -1, -3, -1,
		-3, 0, -1, 0, 1, 0, 2, 0,
		-3, 1, -1, 1, 2, 1,
		-2, 2, 1, 2,
		-1, 3, 0, 3,
		127
	},
	{	       /* surprise (p3), from Lexicon */
		-2, -4, 3, -4, 4, -4,
		-2, -3, -1, -3, 0, -3, 3, -3,
		-4, -2, -3, -2, 1, -2, 3, -2,
		-5, -1, -2, -1, -1, -1, 1, -1, 3, -1, 4, -1,
		-4, 0, 3, 0,
		-5, 1, -4, 1, -2, 1, 0, 1, 1, 1, 4, 1,
		-4, 2, -2, 2, 2, 2, 3, 2,
		-4, 3, -1, 3, 0, 3, 1, 3,
		-5, 4, -4, 4, 1, 4,
		127
	},
	{		/* swan (c/4, p4) (small diagonal sparker) */
		1, -11,
		0, -10, 1, -10,
		-2, -8, -1, -8, 0, -8,
		-2, -7, -1, -7, 0, -7,
		-3, -4, -2, -4, -1, -4,
		-3, -3, -2, -3,
		-4, -2, -1, -2, 0, -2, 1, -2, 3, -2,
		-4, -1, -3, -1, -1, -1, 3, -1,
		-4, 0, -3, 0, -1, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -3, 1, -2, 1,
		-4, 2, -3, 2,
		-4, 3,
		-4, 4, -3, 4,
		-3, 5, -1, 5,
		1, 6,
		-1, 7, 2, 7,
		0, 8, 3, 8,
		0, 9,
		3, 10,
		1, 11, 2, 11, 3, 11,
		127
	},
	{		/* switch engine (p288, c/12 diagonal puffer) */
		-12, -3, -10, -3,
		-13, -2,
		-12, -1, -9, -1,
		-10, 0, -9, 0, -8, 0,
		13, 2, 14, 2,
		13, 3,
		127
	},
	{	       /* technician (p5), from Lexicon */
		0, -6,
		-1, -5, 1, -5,
		-1, -4, 0, -4,
		-3, -3, -2, -3,
		-4, -2, 0, -2, 1, -2, 2, -2,
		-5, -1, -2, -1, -1, -1, 3, -1, 5, -1,
		-4, 0, -3, 0, 2, 0, 4, 0, 5, 0,
		-2, 1, 0, 1, 2, 1,
		-2, 2, 2, 2,
		-1, 3, 0, 3, 1, 3,
		1, 4, 3, 4,
		2, 5, 3, 5,
		127
	},
#if 0
	{	       /* test tube baby (p2), from Lexicon */
		-4, -2, -3, -2, 2, -2, 3, -2,
		-4, -1, -2, -1, 1, -1, 3, -1,
		-2, 0, 1, 0,
		-2, 1, 1, 1,
		-1, 2, 0, 2,
		127
	},
#endif
	{	       /* timebomb (glider producing switch engine (p384)) */
		-6, -3, 6, -3, 7, -3,
		-7, -2, -5, -2, 0, -2, 7, -2,
		0, -1, 5, -1,
		-5, 0, -2, 0, 2, 0, 5, 0,
		-5, 1, -4, 1, 3, 1,
		-4, 2,
		127
	},
#if 0
	{	       /* titanic toroidal traveler (p16/unknown) */
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, -1, 0,
		127
	},
#endif
	{	       /* T-nosed p4, from Lexicon */
		0, -6,
		0, -5,
		-1, -4, 0, -4, 1, -4,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-3, 1, -1, 1, 0, 1, 1, 1, 3, 1,
		-3, 2, -1, 2, 1, 2, 3, 2,
		-4, 3, -3, 3, -1, 3, 1, 3, 3, 3, 4, 3,
		-5, 4, -2, 4, -1, 4, 1, 4, 2, 4, 5, 4,
		-5, 5, -4, 5, 4, 5, 5, 5,
		127
	},
	{	       /* T-nosed p6, from Lexicon */
		-3, -5, -2, -5, 2, -5, 3, -5,
		-3, -4, -1, -4, 1, -4, 3, -4,
		-2, -3, 2, -3,
		-7, -1, -5, -1, -3, -1, 3, -1, 5, -1, 7, -1,
		-9, 0, -8, 0, -7, 0, -5, 0, -3, 0, -2, 0, 2, 0, 3, 0, 5, 0,
			7, 0, 8, 0, 9, 0,
		-7, 1, -5, 1, -3, 1, 3, 1, 5, 1, 7, 1,
		-2, 3, 2, 3,
		-3, 4, -1, 4, 1, 4, 3, 4,
		-3, 5, -2, 5, 2, 5, 3, 5,
		127
	},
	{	       /* toad-flipper, from Lexicon */
		-8, -5, 7, -5,
		-8, -4, 7, -4,
		-9, -3, -7, -3, 6, -3, 8, -3,
		-8, -2, 7, -2,
		-8, -1, -1, -1, 7, -1,
		-8, 0, -1, 0, 0, 0, 7, 0,
		-8, 1, -1, 1, 0, 1, 7, 1,
		-9, 2, -7, 2, 0, 2, 6, 2, 8, 2,
		-8, 3, 7, 3,
		-8, 4, 7, 4,
		127
	},
	{	       /* toad-sucker, from Lexicon */
		-8, -5,
		-8, -4, 7, -4,
		-9, -3, -7, -3, 7, -3,
		-8, -2, 6, -2, 8, -2,
		-8, -1, -1, -1, 7, -1,
		-8, 0, -1, 0, 0, 0, 7, 0,
		-8, 1, -1, 1, 0, 1, 7, 1,
		-9, 2, -7, 2, 0, 2, 7, 2,
		-8, 3, 6, 3, 8, 3,
		-8, 4, 7, 4,
		7, 5,
		127
	},
	{	       /* toaster (p5), from Lexicon */
		-3, -6, 4, -6, 5, -6,
		-4, -5, -2, -5, 0, -5, 1, -5, 4, -5,
		-4, -4, -2, -4, 0, -4, 2, -4, 4, -4,
		-5, -3, -4, -3, -2, -3, 2, -3, 4, -3, 5, -3,
		-7, -2, -3, -2, -2, -2, 0, -2, 2, -2, 3, -2, 7, -2,
		-4, -1, 4, -1,
		-4, 0, 4, 0,
		-7, 1, -3, 1, -2, 1, 0, 1, 2, 1, 3, 1, 7, 1,
		-5, 2, -4, 2, -2, 2, 2, 2, 4, 2, 5, 2,
		-4, 3, -2, 3, 0, 3, 2, 3, 4, 3,
		-4, 4, -2, 4, 0, 4, 1, 4, 4, 4,
		-3, 5, 4, 5, 5, 5,
		127
	},
	{	       /* transparent block reaction, from Lexicon */
		-7, -2,
		-7, -1, -6, -1, 5, -1, 6, -1,
		-6, 0, -5, 0, 5, 0, 6, 0,
		-7, 1, -6, 1,
		127
	},
	{	       /* trice tongs (p3), from Lexicon */
		-1, -3,
		-1, -2, 0, -2, 1, -2,
		-3, -1, -2, -1, 2, -1,
		-2, 0, 0, 0, 2, 0,
		-2, 1,
		-1, 2, 0, 2, 3, 2,
		2, 3, 3, 3,
		127
	},
	{	       /* triple caterer (p3), from Lexicon */
		-3, -5, -2, -5,
		-4, -4, -1, -4, 2, -4, 3, -4,
		-4, -3, -3, -3, -1, -3, 3, -3,
		-2, -2, 0, -2, 1, -2, 2, -2, 7, -2,
		-6, -1, -5, -1, -4, -1, -2, -1, 0, -1, 5, -1, 6, -1, 7, -1,
		-7, 0, -4, 0, -1, 0, 4, 0,
		-8, 1, -6, 1, -3, 1, 1, 1, 4, 1, 5, 1,
		-7, 2,
		-6, 3, -5, 3, -3, 3, -2, 3, 0, 3, 1, 3, 3, 3, 4, 3,
		-5, 4, -1, 4, 3, 4,
		-5, 5, -1, 5, 3, 5,
		127
	},
	{	       /* tritoad (p3), from Lexicon */
		0, -7, 1, -7,
		0, -6,
		1, -5, 4, -5, 5, -5,
		-2, -4, -1, -4, 0, -4, 2, -4, 5, -4,
		-3, -3, 2, -3, 3, -3, 5, -3, 7, -3, 8, -3,
		-3, -2, -1, -2, 0, -2, 3, -2, 5, -2, 7, -2, 8, -2,
		-6, -1, -5, -1, -3, -1, 1, -1, 2, -1, 5, -1,
		-6, 0, -3, 0, -2, 0, 2, 0, 4, 0, 5, 0,
		-9, 1, -8, 1, -6, 1, -4, 1, -1, 1, 0, 1, 2, 1,
		-9, 2, -8, 2, -6, 2, -4, 2, -3, 2, 2, 2,
		-6, 3, -3, 3, -1, 3, 0, 3, 1, 3,
		-6, 4, -5, 4, -2, 4,
		-1, 5,
		-2, 6, -1, 6,
		127
	},
	{	       /* tubber (p3), from Lexicon */
		-2, -6, 0, -6,
		-2, -5, -1, -5, 1, -5,
		1, -4, 2, -4, 3, -4,
		-2, -3, -1, -3, 4, -3,
		-6, -2, -5, -2, -3, -2, 0, -2, 1, -2, 4, -2,
		-5, -1, -3, -1, 2, -1, 4, -1, 5, -1,
		-6, 0, -2, 0, 2, 0, 6, 0,
		-5, 1, -4, 1, -2, 1, 3, 1, 5, 1,
		-4, 2, -1, 2, 0, 2, 3, 2, 5, 2, 6, 2,
		-4, 3, 1, 3, 2, 3,
		-3, 4, -2, 4, -1, 4,
		-1, 5, 1, 5, 2, 5,
		0, 6, 2, 6,
		127
	},
	{		/* tumbler (p14) (pump), from Lexicon */
		-2, -3, -1, -3, 1, -3, 2, -3,
		-2, -2, -1, -2, 1, -2, 2, -2,
		-1, -1, 1, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 3, 1,
		-3, 2, -2, 2, 2, 2, 3, 2,
		127
	},
	{	       /* tumbling T-tetson (p8)*/
		-9, -5, -8, -5, -7, -5,
		-10, -4, 9, -4, 10, -4,
		-10, -3, -6, -3, 7, -3, 9, -3, 10, -3,
		-10, -2, -7, -2, -5, -2, 6, -2,
		-8, -1, -6, -1, -3, -1, 9, -1,
		-7, 0, -3, 0, 5, 0, 6, 0, 8, 0,
		-3, 1, 5, 1, 6, 1,
		-6, 2, -5, 2, -4, 2, 1, 2,
		-1, 3, 0, 3,
		1, 4,
		127
	},
	{		/* twin bees shuttle (p46) (piston2) */
		-12, -8, -11, -8,
		-12, -7, -11, -7,
		2, -5,
		-13, -4, -12, -4, 2, -4, 3, -4, 12, -4, 13, -4,
		-13, -3, -12, -3, 3, -3, 4, -3, 12, -3, 13, -3,
		-2, -2, -1, -2, 2, -2, 3, -2,
		-2, 2, -1, 2, 2, 2, 3, 2,
		-13, 3, -12, 3, 3, 3, 4, 3,
		-13, 4, -12, 4, 2, 4, 3, 4,
		2, 5,
		-12, 7, -11, 7,
		-12, 8, -11, 8,
		127
	},
	{	       /* twirling T-tetsons II (p60), from Lexicon */
		-5, -12, -4, -12, 0, -12, 1, -12,
		-6, -11, 2, -11,
		-3, -10, -1, -10,
		-5, -9, -4, -9, 0, -9, 1, -9,
		9, -5, 10, -5, 11, -5,
		8, -4, 9, -4, 10, -4,
		1, -3,
		-12, -2, -11, -2, -10, -2, 0, -2, 1, -2, 2, -2,
		-11, -1, -10, -1, -9, -1,
		8, 0, 9, 0, 10, 0,
		9, 1, 10, 1, 11, 1,
		-11, 3, -10, 3, -9, 3,
		-12, 4, -11, 4, -10, 4, 0, 4, 1, 4, 2, 4,
		1, 5,
		-2, 8, -1, 8, 3, 8, 4, 8,
		0, 9, 2, 9,
		-3, 10, 5, 10,
		-2, 11, -1, 11, 3, 11, 4, 11,
		127
	},
	{		/* unix (p6) (pulse2), from Lexicon */
		0, -4, 1, -4,
		-4, -3, -3, -3, -1, -3,
		-4, -2, -3, -2, 0, -2, 3, -2,
		1, -1, 3, -1,
		2, 0,
		1, 2, 2, 2,
		1, 3, 2, 3,
		127
	},
	{	       /* washerwoman (2c/3 p18 fuse), from Lexicon */
		-16, -2,
		-16, -1, -15, -1, -10, -1, -4, -1, 2, -1, 8, -1, 14, -1,
		-16, 0, -15, 0, -14, 0, -11, 0, -9, 0, -5, 0, -3, 0, 1, 0,
			3, 0, 7, 0, 9, 0, 13, 0, 15, 0,
		-16, 1, -15, 1, -10, 1, -4, 1, 2, 1, 8, 1, 14, 1,
		-16, 2,
		127
	},
	{		/* washing machine (p2), from Lexicon */
		-2, -3, -1, -3, 1, -3, 2, -3,
		-3, -2, -1, -2, 0, -2, 3, -2,
		-3, -1, -2, -1, 3, -1,
		-2, 0, 2, 0,
		-3, 1, 2, 1, 3, 1,
		-3, 2, 0, 2, 1, 2, 3, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		127
	},
	{		/* wasp (c/3, p3), from Lexicon */
		-1, -5, 0, -5, 2, -5, 3, -5,
		-3, -4, -2, -4, 0, -4, 2, -4, 3, -4, 5, -4, 6, -4,
		-6, -3, -5, -3, -4, -3, -2, -3, 1, -3, 2, -3, 3, -3, 6, -3,
			7, -3, 8, -3, 9, -3,
		-10, -2, -9, -2, -8, -2, -3, -2, -2, -2, -1, -2, 5, -2, 10, -2,
		-11, -1, -9, -1, -7, -1, -5, -1, -4, -1, -3, -1, -1, -1,
			8, -1, 9, -1,
		-11, 0, -9, 0, -7, 0, -5, 0, -4, 0, -3, 0, -2, 0,
		-10, 1, -8, 1, -3, 1, 0, 1,
		-1, 2,
		-9, 3,
		-9, 4,
		127
	},
	{		/* wavefront (p4), from Lexicon */
		2, -6, 3, -6,
		2, -5,
		3, -4,
		2, -3, 3, -3,
		-1, -2, 0, -2, 4, -2, 5, -2,
		-2, -1, 1, -1, 2, -1, 3, -1, 6, -1,
		-2, 0, 4, 0, 5, 0,
		-1, 1, 3, 1,
		-6, 2, -5, 2, -3, 2, -1, 2, 3, 2,
		-6, 3, -4, 3, -3, 3, -1, 3, 1, 3, 2, 3,
		-2, 4, 0, 4,
		-2, 5, 0, 5,
		-1, 6,
		127
	},
	{		/* weekender (2c/7, p7), from Lexicon */
		-7, -5, 6, -5,
		-7, -4, 6, -4,
		-8, -3, -6, -3, 5, -3, 7, -3,
		-7, -2, 6, -2,
		-7, -1, 6, -1,
		-6, 0, -2, 0, -1, 0, 0, 0, 1, 0, 5, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		-6, 2, -5, 2, -4, 2, -3, 2, 2, 2, 3, 2, 4, 2, 5, 2,
		-4, 4, 3, 4,
		-3, 5, -2, 5, 1, 5, 2, 5,
		127
	},
	{		/* x66 (c/2, p4) (ship1), from Lexicon */
		-3, -5,
		-4, -4, -3, -4, -2, -4, -1, -4, 0, -4,
		-5, -3, -4, -3, 0, -3, 1, -3, 3, -3,
		-4, -2, 4, -2,
		-3, -1, -2, -1, 1, -1, 3, -1,
		-3, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, 4, 2,
		-5, 3, -4, 3, 0, 3, 1, 3, 3, 3,
		-4, 4, -3, 4, -2, 4, -1, 4, 0, 4,
		-3, 5,
		127
	}
};

static char patterns_8S23B36[][2 * NUMPTS + 1] =
{
	{		/* replicator */
		-1, -2, 0, -2, 1, -2,
		-2, -1,
		-2, 0,
		-2, 1,
		127
	},
	{		/* bomber */
		-4, -3, -3, -3, -2, -3,
		-5, -2,
		-5, -1,
		-5, 0, 4, 0,
		4, 1,
		4, 2,
		127
	},
	{		/* growing ship */
		-8, -7, -7, -7, -6, -7,
		-9, -6, -6, -6,
		-10, -5, -6, -5,
		-10, -4, -7, -4,
		-10, -3, -9, -3, -8, -3,
		7, 6, 8, 6, 9, 6,
		127
	},
#if 0
	{		/* gun */
		3, -11,
		1, -10, 2, -10, 3, -10,
		0, -9,
		0, -8, 1, -8,
		-3, 0, -2, 0, -1, 0,
		-3, 1, -1, 1,
		-3, 2, -2, 2, -1, 2,
		-2, 3,
		17, 4, 18, 4,
		-18, 5, -17, 5, 17, 5,
		-17, 6, 15, 6, 17, 6,
		-17, 7, -15, 7, 6, 7, 15, 7, 16, 7,
		-16, 8, -15, 8, 6, 8,
		-6, 9, -5, 9, 5, 9, 7, 9, 8, 9,
		-7, 10, -6, 10, -4, 10, 6, 10,
		-6, 11, -5, 11, 6, 11,
		127
	},
	{		/* tug of war */
		-12, -13, -11, -13, -10, -13,
		-13, -12,
		-13, -11,
		-13, -10,
		0, -6,
		0, -5,
		0, -4,
		4, 1,
		3, 2, 4, 2,
		2, 3, 4, 3,
		1, 4, 2, 4, 3, 4,
		11, 10, 12, 10, 13, 10,
		10, 11, 12, 11,
		10, 12, 11, 12,
		10, 13,
		127
	},
	{		/* unpredictable tug of war */
		-16, -17, -15, -17, -14, -17,
		-17, -16,
		-17, -15,
		-17, -14,
		-4, -10,
		-4, -9,
		-4, -8,
		16, 13,
		15, 14, 16, 14,
		14, 15, 16, 15,
		13, 16, 14, 16, 15, 16,
		127
	},
#endif
	{		/* puffer train 1 */
		4, -10, 5, -10, 6, -10,
		3, -9, 7, -9,
		2, -8, 7, -8,
		1, -7, 4, -7, 7, -7,
		1, -6, 6, -6,
		1, -5, 5, -5,
		2, -4, 3, -4, 4, -4,
		7, 0,
		7, 1,
		7, 2,
		-5, 4, -4, 4, -3, 4,
		-6, 5, -3, 5,
		-7, 6, -3, 6,
		-7, 7, -4, 7,
		-7, 8, -6, 8, -5, 8,
		2, 9, 3, 9, 4, 9,
		127
	},
	{		/* puffer train 2 */
		2, -10, 3, -10,
		3, -9, 4, -9,
		0, -8, 2, -8, 3, -8,
		0, -7, 1, -7, 2, -7,
		1, -6, 10, -6,
		10, -5,
		10, -4,
		-7, -2,
		-8, -1, -7, -1,
		-9, 0, -7, 0,
		-10, 1, -9, 1, -8, 1,
		-5, 7,
		-5, 8,
		-5, 9,
		127
	},
	{		/* period 96 rake */
		-8, -6, -7, -6, -6, -6,
		-5, -5,
		-10, -4, -8, -4, -4, -4,
		-10, -3, -3, -3,
		-10, -2, -2, -2,
		-9, -1, -2, -1,
		-8, 0, -4, 0, -2, 0,
		-7, 1, 6, 1, 7, 1, 8, 1,
		-6, 2, -5, 2, -4, 2, 9, 2,
		9, 3,
		0, 4, 9, 4,
		0, 5,
		0, 6,
		127
	},
	{		/* another p3 c/3 spaceship */
		-2, -3, 2, -3,
		-3, -2, -1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, -1, -1, 1, -1, 2, -1, 3, -1,
		-9, 0, -8, 0, -7, 0, -6, 0, -5, 0, -3, 0, 3, 0, 5, 0, 6, 0,
			7, 0, 8, 0, 9, 0,
		-9, 1, -8, 1, -5, 1, -4, 1, 0, 1, 4, 1, 5, 1, 8, 1, 9, 1,
		-7, 2, -6, 2, -5, 2, 0, 2, 5, 2, 6, 2, 7, 2,
		-7, 3, 7, 3,
		127
	},
	{		/* mold (p4), from Lexicon */
		0, -3, 1, -3, 
		-1, -2, 2, -2, 
		-3, -1, 0, -1, 2, -1, 
		1, 0, 
		-3, 1, -1, 1, 0, 1, 
		-2, 2, 
		127
	},
	{		/* monogram (p4), from Lexicon */
		-3, -2, -2, -2, 2, -2, 3, -2, 
		-2, -1, 0, -1, 2, -1, 
		-2, 0, -1, 0, 1, 0, 2, 0, 
		-2, 1, 0, 1, 2, 1, 
		-3, 2, -2, 2, 2, 2, 3, 2, 
		127
	},
	{		/* oscillator DH (p3) */
		0, -4, 1, -4, 
		-1, -3, 2, -3, 
		1, -2, 3, -2, 
		-3, -1, -1, -1, 3, -1, 
		-4, 0, 0, 0, 2, 0, 
		-4, 1, -2, 1, 
		-3, 2, 0, 2, 
		-2, 3, -1, 3, 
		127
	},
	{		/* oscillator0 DH (p4) */
		1, -5, 2, -5, 
		0, -4, 2, -4, 
		-5, -3, -4, -3, 0, -3, 
		-5, -2, -2, -2, 0, -2, 1, -2, 
		-4, -1, -3, -1, -2, -1, 
		1, 0, 2, 0, 3, 0, 
		-2, 1, -1, 1, 1, 1, 4, 1, 
		-1, 2, 3, 2, 4, 2, 
		-3, 3, -1, 3, 
		-3, 4, -2, 4, 
		127
	},
	{		/* oscillator1 DH (p4) */
		0, -7, 1, -7,
		0, -6, 1, -6,
		-2, -4, -1, -4, 0, -4, 1, -4,
		-3, -3, 2, -3,
		-4, -2, -2, -2, 0, -2, 1, -2, 3, -2, 5, -2, 6, -2,
		-4, -1, -2, -1, 3, -1, 5, -1, 6, -1,
		-7, 0, -6, 0, -4, 0, 1, 0, 3, 0,
		-7, 1, -6, 1, -4, 1, -2, 1, -1, 1, 1, 1, 3, 1,
		-3, 2, 2, 2,
		-2, 3, -1, 3, 0, 3, 1, 3,
		-2, 5, -1, 5,
		-2, 6, -1, 6,
		127
	},
	{		/* oscillator DH (p7) */
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		1, 0, 2, 0, 3, 0,
		1, 1, 2, 1, 3, 1,
		127
	},
	{		/* oscillator DH (p9)  */
		-11, -5, -10, -5, 10, -5, 11, -5,
		-10, -4, 10, -4,
		-10, -3, -8, -3, 8, -3, 10, -3,
		-9, -2, -8, -2, 8, -2, 9, -2,
		-6, 0, -5, 0, -4, 0, -3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0,
			4, 0, 5, 0, 6, 0,
		-9, 2, -8, 2, 8, 2, 9, 2,
		-10, 3, -8, 3, 8, 3, 10, 3,
		-10, 4, 10, 4,
		-11, 5, -10, 5, 10, 5, 11, 5,
		127
	},
	{		/* oscillator DH (p10) */
		-2, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
	{		/* oscillator DH (p12) */
		-3, -3, -2, -3, 1, -3, 3, -3,
		-1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1, 2, -1,
		-2, 1, 2, 1, 3, 1,
		-3, 2, -1, 2, 1, 2,
		-3, 3, -1, 3, 2, 3, 3, 3,
		127
	},
	{		/* oscillator DH (p14) */
		-2, -5, -1, -5, 0, -5,
		-3, -4, -1, -4, 0, -4, 2, -4,
		-4, -3, 3, -3,
		-2, -2, 1, -2, 4, -2,
		-5, -1, -4, -1, 3, -1, 4, -1,
		-5, 0, -4, 0, 3, 0, 4, 0,
		-5, 1, -2, 1, 1, 1,
		-4, 2, 3, 2,
		-3, 3, -1, 3, 0, 3, 2, 3,
		-1, 4, 0, 4, 1, 4,
		127
	},
	{		/* oscillator DH (p20) */
		-1, -5,
		-3, -4, -2, -4, -1, -4,
		-4, -3, -1, -3,
		-4, -2, -2, -2,
		-5, -1, -4, -1, -3, -1,
		2, 0, 3, 0, 4, 0,
		1, 1, 3, 1,
		0, 2, 3, 2,
		0, 3, 1, 3, 2, 3,
		0, 4,
		127
	},
	{		/* oscillator DH (p28) */
		-6, -4, 6, -4,
		-6, -3, -4, -3, 4, -3, 6, -3,
		-9, -2, -6, -2, -5, -2, 5, -2, 6, -2, 9, -2,
		-10, -1, -9, -1, -8, -1, 8, -1, 9, -1, 10, -1,
		-11, 0, -10, 0, -8, 0, -7, 0, 7, 0, 8, 0, 10, 0, 11, 0,
		-10, 1, -9, 1, -8, 1, 8, 1, 9, 1, 10, 1,
		-9, 2, -6, 2, -5, 2, 5, 2, 6, 2, 9, 2,
		-6, 3, -4, 3, 4, 3, 6, 3,
		-6, 4, 6, 4,
		127
	},
	{		/* shuttle DH (p24) */
		-3, -3, -2, -3,
		-3, -2, -1, -2, 1, -2, 3, -2,
		-3, -1, -2, -1,
		-9, 0, -8, 0, 7, 0, 8, 0,
		-10, 1, -8, 1, 7, 1, 9, 1,
		-10, 2, 9, 2,
		-11, 3, -10, 3, 9, 3, 10, 3,
		127
	},
#if 0
	{		/* oscillator NT (p48) */
		-9, -13, -8, -13, -7, -13, 7, -13, 8, -13, 9, -13,
		-9, -12, -6, -12, 6, -12, 9, -12,
		-9, -11, -5, -11, 5, -11, 9, -11,
		-8, -10, -5, -10, 5, -10, 8, -10,
		-7, -9, -6, -9, -5, -9, 5, -9, 6, -9, 7, -9,
		-11, -2, 11, -2,
		-12, -1, -10, -1, 10, -1, 12, -1,
		-14, 0, -13, 0, 13, 0, 14, 0,
		-12, 1, -10, 1, 10, 1, 12, 1,
		-11, 2, 11, 2,
		-7, 9, -6, 9, -5, 9, 5, 9, 6, 9, 7, 9,
		-8, 10, -5, 10, 5, 10, 8, 10,
		-9, 11, -5, 11, 5, 11, 9, 11,
		-9, 12, -6, 12, 6, 12, 9, 12,
		-9, 13, -8, 13, -7, 13, 7, 13, 8, 13, 9, 13,
		127
	},
#endif
	{		/* simple oscillator DH (p48)*/
		-11, -11,
		-11, -10, -10, -10, -9, -10,
		-8, -9,
		-9, -8, -8, -8,
		-1, -5, 0, -5, 1, -5,
		-2, -4, 1, -4,
		-3, -3, 1, -3,
		-3, -2, 0, -2,
		-3, -1, -2, -1, -1, -1,
		8, 8, 9, 8,
		8, 9, 10, 9,
		10, 10,
		10, 11, 11, 11,
		127
	},
	{ 		/* oscillator HE (p96) */
		-13, -13, -12, -13,
		-13, -12, -12, -12,
		7, -4,
		6, -3, 7, -3,
		5, -2, 7, -2,
		4, -1, 5, -1, 6, -1,
		10, 1, 11, 1, 12, 1,
		9, 2, 11, 2,
		9, 3, 10, 3,
		9, 4,
		12, 12, 13, 12,
		12, 13, 13, 13,
		127
	}
};

static char patterns_8S34678B3678[][2 * NUMPTS + 1] =
{
#if 0
	{		/* I (p3)  */
		-2, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-2, 2, 2, 2,
		127
	},
	{		/* OO (p3) */
		-2, -2, -1, -2, 1, -2, 2, -2,
		-3, -1, -1, -1, 1, -1, 3, -1,
		-3, 0, -1, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 1, 1, 2, 1,
		127
	},
#endif
	{		/* rocket predecessor */
		-3, -2, -2, -2,
		-4, -1, -2, -1, -1, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, -1, 1,
		-3, 2, -2, 2,
		127
	},
	{		/* 2 rockets and junk */
		-1, -2,
		-2, -1, -1, -1, 0, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-1, 2,
		127
	},
	{		/* p2 c/2 even spaceship */
		0, -4, 1, -4, 2, -4,
		-2, -3, 0, -3, 1, -3,
		-3, -2, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2, 4, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1,
		-2, 2, 0, 2, 1, 2,
		0, 3, 1, 3, 2, 3,
		127
	},
	{		/* p2 c/2 odd spaceship */
		0, -3, 1, -3, 2, -3,
		-2, -2, 0, -2, 1, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 2, -1, 4, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0, 3, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1,
		-2, 2, 0, 2, 1, 2,
		0, 3, 1, 3, 2, 3,
		127
	},
	{		/* p4 c/2 odd spaceship */
		1, -3,
		-1, -2, 1, -2,
		-2, -1, -1, -1, 0, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 0, 1,
		-1, 2, 1, 2,
		1, 3,
		127
	},
	{		/* p4 c/2 even spaceship*/
		1, -4,
		-1, -3, 1, -3,
		-2, -2, -1, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 3, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0,
		-2, 1, -1, 1, 0, 1,
		-1, 2, 1, 2,
		1, 3,
		127
	},
	{		/* p32 c/2 spaceship */
		-1, -3,
		-3, -2, -2, -2, -1, -2,
		-4, -1, -2, -1, -1, -1, 0, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, -1, 1, 0, 1, 2, 1,
		-3, 2, -2, 2, -1, 2,
		-1, 3,
		127
	},
#if 0
	{		/* p3 c/3 diagonal butterfly */
		-1, -2, 0, -2, 1, -2,
		-2, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0,
		-2, 1, -1, 1,
		-1, 2,
		127
	},
#endif
	{		/* p14 c/7 snail */
		0, -2,
		-2, -1, 0, -1, 1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 1, 1,
		0, 2,
		127
	},
	{		/* asym p4 c/2 spaceship */
		-7, -3, -6, -3, 1, -3, 2, -3,
		-8, -2, -7, -2, -6, -2, -4, -2, -3, -2, -2, -2, -1, -2, 1, -2,
			2, -2, 4, -2, 5, -2, 6, -2, 7, -2,
		-9, -1, -7, -1, -6, -1, -2, -1, 1, -1, 3, -1, 4, -1, 5, -1, 6,
			-1, 8, -1,
		-8, 0, -7, 0, -6, 0, -5, 0, 0, 0, 2, 0, 4, 0, 6, 0, 7, 0, 8, 0,
		-6, 2, 6, 2, 7, 2,
		-8, 3,
		127
	},
	{		/* small doomed ship */
		-1, -2, 0, -2,
		-2, -1, -1, -1, 0, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, -1, 1, 0, 1, 2, 1,
		-1, 2, 0, 2,
		127
	},
	{		/* p6 oscillator 0 */
		0, -2,
		-1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 1, 0, 1,
		-1, 2, 0, 2,
		127
	},
	{		/* p6 oscillator 1 */
		0, -2,
		-1, -1, 0, -1, 1, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-1, 1, 0, 1, 1, 1, 2, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		127
	},
	{		/* p6 oscillator 2 */
		-3, -3, -2, -3, -1, -3,
		-3, -2, -2, -2, -1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		127
	},
	{		/* p6 oscillator 3 */
		-3, -4, 1, -4,
		-3, -3, -2, -3, -1, -3, 2, -3, 3, -3,
		-4, -2, -2, -2, 1, -2, 2, -2,
		-1, -1, 0, -1, 2, -1,
		-3, 0, -1, 0, 0, 0,
		-3, 1, -2, 1, 1, 1, 3, 1,
		-4, 2, -3, 2, 0, 2, 1, 2, 2, 2,
		-2, 3, 2, 3,
		127
	},
	{		/* 7 oscillator */
		-1, -3, 0, -3, 1, -3,
		0, -2, 1, -2, 2, -2,
		-3, -1, 0, -1, 1, -1,
		-3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-3, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-2, 2, 0, 2, 1, 2, 2, 2, 3, 2,
		2, 3, 3, 3,
		127
	},
	{		/* odd 8 oscillator */
		0, -3,
		-2, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		-4, 1, -3, 1, -2, 1, -1, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-2, 2, -1, 2, 1, 2, 2, 2,
		127
	},
	{		/* even 8 oscillator */
		-1, -3, 0, -3,
		-3, -1, 2, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 3, 0, 4, 0,
		-5, 1, -4, 1, -3, 1, -2, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-3, 2, -2, 2, 1, 2, 2, 2,
		127
	},
	{		/* 13 oscillator */
		-1, -3,
		-1, -2,
		-3, -1, -2, -1, -1, -1,
		0, 0,
		1, 1, 2, 1, 3, 1,
		1, 2,
		1, 3,
		127
	},
	{		/* 14 oscillator */
		3, -3,
		3, -2,
		2, -1, 3, -1,
		2, 0,
		-2, 1,
		-3, 2, -2, 2, -1, 2,
		-1, 3,
		127
	},
	{		/* 16 oscillator */
		0, -2,
		-1, -1, 0, -1,
		-1, 0,
		-1, 1,
		127
	},
	{		/* 36 oscillator */
		-1, -2, 0, -2, 1, -2,
		-2, -1, 0, -1, 2, -1,
		-2, 0, -1, 0, 0, 0, 1, 0, 2, 0,
		-2, 1, 0, 1,
		-1, 2, 0, 2,
		127
	},
	{		/* 42 oscillator */
		-3, -5, 2, -5,
		-4, -4, -3, -4, -2, -4, 1, -4, 2, -4, 3, -4,
		-5, -3, -4, -3, -3, -3, -2, -3, 1, -3, 2, -3, 3, -3, 4, -3,
		-4, -2, -3, -2, -1, -2, 0, -2, 2, -2, 3, -2,
		-2, -1, -1, -1, 0, -1, 1, -1,
		-2, 0, -1, 0, 0, 0, 1, 0,
		-4, 1, -3, 1, -1, 1, 0, 1, 2, 1, 3, 1,
		-5, 2, -4, 2, -3, 2, -2, 2, 1, 2, 2, 2, 3, 2, 4, 2,
		-4, 3, -3, 3, -2, 3, 1, 3, 2, 3, 3, 3,
		-3, 4, 2, 4,
		127
	}
};


/*-
 * This assumes Callahan's "/" notation
 *    ABC                   A B C
 *    DEF          ->      D E F
 *    GHI                 G H I
 */

/* CALLAHAN */
static char patterns_6S2b34B2a[][2 * NUMPTS + 1] =
{
#if 0
	{		/* glider (p4) */
		0, -2,
		1, -1,
		-2, 0, 1, 0,
		1, 1,
		1, 2,
		127
	},
#endif
	{		/* 3 oscillator glider gun (p42) */
		5, -6, 6, -6,
		6, -5, 7, -5, 9, -5,
		6, -4, 8, -4, 9, -4,
		7, -3, 8, -3, 10, -3, 11, -3,
		8, -2, 10, -2,
		8, -1, 10, -1, 11, -1,
		8, 0, 9, 0, 10, 0, 12, 0,
		10, 1,

		-10, -5,
		-11, -4, -10, -4, -8, -4,
		-12, -3, -11, -3, -9, -3, -8, -3, -7, -3,
		-10, -2, -8, -2, -6, -2,
		-10, -1, -9, -1, -7, -1, -6, -1, -5, -1, -4, -1,
		-10, 0, -8, 0, -7, 0, -5, 0,

		0, -1, 1, -1,
		1, 0, 2, 0, 3, 0,
		1, 1, 3, 1,
		0, 2, 1, 2, 2, 2, 3, 2,
		0, 3, 4, 3,
		1, 4, 2, 4, 3, 4, 4, 4, 5, 4,
		3, 5,
		3, 6,
		127
	},
	{		/* another gun (p20) */
		-2, -7, -1, -7,
		-2, -6,

		-8, -2,
		-9, -1, -8, -1, -7, -1, -6, -1, -5, -1,
		-8, 0, -6, 0, -5, 0,
		-7, 1, -6, 1,
		-8, 2, -7, 2,
		-10, 3, -9, 3, -8, 3,
		-8, 4,
		-9, 5, -8, 5, -7, 5,
		-6, 6,

		4, 0,
		3, 1, 4, 1, 5, 1, 10, 1,
		3, 2, 4, 2, 6, 2, 7, 2, 10, 2,
		5, 3, 6, 3, 8, 3, 9, 3, 10, 3, 11, 3,
		7, 4, 10, 4, 12, 4,
		11, 5,
		127
	},
	{		/* ship (p48) */
		-3, -2, -1, -2,
		-2, -1, -1, -1,
		-2, 0, -1, 0, 0, 0, 2, 0,
		-1, 1, 0, 1, 3, 1,
		0, 2,
		127
	},
	{		/* ship (p15) */
		-3, -5, -1, -5,
		-2, -4, -1, -4, 0, -4,
		-4, -3, -3, -3, -2, -3, 0, -3,
		-2, -2, 0, -2,
		-1, -1, 0, -1,
		0, 1, 1, 1,
		0, 2, 2, 2,
		-1, 3, 0, 3, 1, 3, 3, 3,
		2, 4, 3, 4, 4, 4,
		2, 5, 4, 5,
		127
	},
	{		/* ship by a collision of 3 gliders (p15) */
		7, -4,
		8, -3,
		8, -2, 10, -2,
		-11, -1, -10, -1, 1, -1, 2, -1, 3, -1, 4, -1, 9, -1, 11, -1,
		-9, 0, 1, 0, 10, 0,
		-8, 1,
		-7, 2, 5, 2,
		-9, 3,
		127
	},
	{		/* stalk (p8) */
		-2, -4,
		-3, -3, -2, -3,
		-3, -2, -1, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 1, -1,
		0, 0, 1, 0,
		0, 1, 2, 1,
		0, 2, 1, 2, 2, 2,
		2, 3, 3, 3, 4, 3,
		127
	},
	{		/* stalk by a collision of 3 gliders */
		-8, -9,
		-5, -8,
		-5, -7,
		-5, -6,
		-6, -5, -5, -5,
		-3, 1,
		-4, 2, -2, 2,
		-3, 3, -1, 3,
		-1, 4,
		0, 5, 5, 5,
		5, 6,
		5, 7, 8, 7,
		5, 8,
		6, 9,
		127
	},
	{		/* stalk by a collision of 2 gilders and eater */
		3, -6,
		3, -5,
		-5, -4, 4, -4, 7, -4,
		-4, -3, -3, -3, 5, -3,
		6, -2,
		-7, 1, -6, 1,
		-5, 2,
		-4, 3,
		-3, 4,
		-5, 5,
		127
	},
	{		/* oscillator (p42) */
		-2, -3, -1, -3,
		-2, -2, 0, -2,
		-3, -1, -2, -1, -1, -1, 0, -1,
		-3, 0, 1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		0, 2,
		0, 3,
		127
	},
	{		/* tentacle (p66) */
		-3, -3, -2, -3,
		-5, -2, -4, -2, -3, -2, -1, -2,
		-5, -1, -3, -1, -1, -1,
		-4, 0, -3, 0, -1, 0, 0, 0,
		-4, 1, -2, 1, -1, 1, 1, 1, 3, 1,
		0, 2, 1, 2, 3, 2, 4, 2, 5, 2,
		2, 3, 3, 3,
		127
	},
	{		/* rotating oscillator (p42) */
		0, -2, 1, -2,
		-1, -1, 0, -1, 1, -1,
		1, 0,
		-2, 1, -1, 1, 0, 1, 1, 1,
		-2, 2, -1, 2,
		127
	},
	{		/* internal oscillator (p7) */
		-3, -6,
		-4, -5, -3, -5,
		-5, -4, -4, -4, -2, -4, -1, -4, 1, -4,
		-3, -3, -1, -3, 0, -3, 1, -3,
		-6, -2, -4, -2, -3, -2, -1, -2, 2, -2, 3, -2,
		-5, -1, -4, -1, -2, -1, 2, -1,
		-6, 0, -5, 0, -3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-4, 1, -3, 1, 1, 1, 3, 1,
		-4, 2, -2, 2, 0, 2, 1, 2, 4, 2,
		-4, 3, -3, 3, -2, 3, 0, 3, 1, 3, 3, 3, 4, 3, 5, 3,
		-1, 4, 0, 4, 2, 4, 3, 4,
		1, 5, 2, 5,
		127
	},
	{		/* oscillator (p7) */
		-6, -7,
		-6, -6,
		-5, -5, -4, -5,
		-4, -4, -3, -4, -2, -4,
		-5, -3, -4, -3, -1, -3, 0, -3, 2, -3,
		-5, -2, 0, -2, 1, -2, 2, -2,
		-4, -1, 2, -1,
		3, 0,
		2, 1, 3, 1,
		2, 2,
		3, 3, 5, 3,
		2, 4, 3, 4, 4, 4, 5, 4,
		5, 5,
		6, 6,
		127
	},
	{			/* oscillator (p9) */
		-2, -6, -1, -6,
		-4, -5, -3, -5, -2, -5, 0, -5,
		-3, -4, -1, -4, 0, -4,
		-3, -3, -2, -3, -1, -3, 1, -3,
		0, -2, 1, -2,
		0, -1,
		-1, 0, 0, 0, 1, 0,
		-1, 1, 2, 1,
		-2, 2, -1, 2, 0, 2, 2, 2,
		-2, 3, 0, 3, 3, 3,
		-1, 4, 0, 4, 2, 4, 3, 4,
		1, 5, 2, 5,
		2, 6,
		127
	},
	{			/* oscillator1 (p11) */
		-4, -5,
		-5, -4, -4, -4,
		-4, -3, -3, -3, -1, -3,
		-6, -2, -5, -2, -4, -2, -2, -2, 0, -2,
		-4, -1, -2, -1, 1, -1, 2, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 1, 0, 3, 0, 4, 0, 5, 0,
		-4, 1, 0, 1, 1, 1, 4, 1,
		2, 2, 3, 2, 4, 2,
		4, 3,
		5, 4,
		127
	},
	{			/* oscillator2 (p11) */
		-3, -3, -2, -3, 0, -3,
		-3, -2, 0, -2, 1, -2,
		-1, -1, 0, -1, 2, -1,
		-3, 0, -2, 0, -1, 0, 1, 0, 2, 0,
		-2, 1, 0, 1, 1, 1, 3, 1,
		-1, 2, 0, 2, 2, 2, 3, 2,
		1, 3, 2, 3,
		127
	},
	{			/* oscillator (p14) */
		-2, -3, -1, -3, 0, -3,
		-3, -2, -2, -2, 0, -2,
		-3, -1, 1, -1, 2, -1,
		-3, 0, -2, 0, 0, 0, 1, 0,
		-1, 1, 0, 1, 2, 1, 3, 1,
		-1, 2, 1, 2, 2, 2,
		1, 3,
		127
	},
	{			/* oscillator (p17) */
		-3, -6,
		-3, -5,
		-5, -4, -4, -4, -3, -4, -2, -4, -1, -4, 0, -4,
		-3, -3, -1, -3, 0, -3,
		-2, -2, -1, -2,
		-2, 0, -1, 0, 2, 0,
		-3, 1, -2, 1, 0, 1, 1, 1,
		-3, 2, 0, 2, 2, 2,
		-2, 3, -1, 3, 1, 3, 2, 3,
		0, 4, 1, 4, 3, 4, 4, 4,
		2, 5, 3, 5,
		2, 6,
		127
	},
	{			/* oscillator (p18) */
		-5, -4, -3, -4,
		-4, -3, -3, -3, -2, -3,
		-5, -2, -4, -2, -2, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, 0, -1, 1, -1, 2, -1, 4, -1,
		-6, 0, -4, 0, -3, 0, -1, 0, 1, 0, 3, 0, 4, 0, 5, 0, 6, 0,
		-5, 1, -4, 1, -2, 1, -1, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		-3, 2, -2, 2, 0, 2, 2, 2, 3, 2, 4, 2, 6, 2,
		-3, 3, -1, 3, 4, 3,
		127
	},
	{			/* oscillator (p19) */
		-6, -4, -2, -4,
		-7, -3, -6, -3, -3, -3, -2, -3, -1, -3, 1, -3,
		-7, -2, -5, -2, -4, -2, -2, -2, 0, -2, 1, -2, 2, -2,
		-6, -1, -5, -1, -3, -1, -2, -1, -1, -1, 0, -1, 1, -1, 3, -1,
		-6, 0, -4, 0, -3, 0, 0, 0, 2, 0, 3, 0,
		-4, 1, -2, 1, 0, 1, 1, 1, 2, 1, 4, 1, 5, 1,
		0, 2, 1, 2, 3, 2, 4, 2, 5, 2,
		1, 3, 2, 3, 3, 3, 6, 3,
		3, 4,
		127
	},
	{			/* oscillator (p22) */
		-5, -5,
		-4, -4,
		-6, -3, -5, -3, -4, -3, -3, -3, -2, -3,
		-4, -2, -2, -2,
		-4, -1, -3, -1, -2, -1, -1, -1, 0, -1,
		-3, 0, -1, 0, 1, 0, 2, 0,
		0, 1, 1, 1, 2, 1, 3, 1,
		0, 2, 1, 2,
		4, 4,
		5, 5, 6, 5,
		127
	},
	{			/* oscillator (p26) */
		-5, -7,
		-5, -6, -3, -6,
		-6, -5, -5, -5, -4, -5, -3, -5, -2, -5,
		-5, -4, -3, -4, -1, -4, 0, -4,
		-5, -3, -2, -3, -1, -3, 1, -3,
		-3, -2, -2, -2, 1, -2,
		-1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		1, 0, 3, 0,
		-1, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1,
		-4, 2, -3, 2, -1, 2, 1, 2, 3, 2, 5, 2,
		-2, 3, 0, 3, 1, 3, 3, 3,
		2, 4, 3, 4, 4, 4,
		2, 5, 5, 5,
		5, 6,
		127
	},
	{			/* oscillator (p29) */
		-2, -6,
		-2, -5, -1, -5,
		-3, -4, -2, -4, 0, -4, 1, -4,
		-5, -3, -4, -3, -3, -3, 2, -3, 3, -3, 4, -3,
		-4, -2, -2, -2, 2, -2, 4, -2,
		-3, -1, -2, -1, -1, -1, 0, -1, 3, -1, 4, -1, 5, -1,
		-5, 0, -4, 0, -3, 0, -2, 0, 1, 0, 2, 0, 3, 0,
		-5, 1, -4, 1, -1, 1, 0, 1, 1, 1, 2, 1,
		-4, 2, -3, 2, -2, 2, 0, 2, 2, 2,
		-3, 3, 0, 3,
		1, 5,
		127
	},
	{			/* oscillator (p46) */
		-2, -4,
		-2, -3, -1, -3, 0, -3,
		-4, -2, -3, -2, -2, -2, 0, -2,
		-5, -1, -3, -1, -1, -1, 0, -1, 1, -1, 2, -1, 3, -1,
		-4, 0, -3, 0, -2, 0, -1, 0, 0, 0, 3, 0,
		-3, 1, -1, 1, 1, 1, 4, 1,
		-4, 2, -3, 2, -2, 2, -1, 2, 0, 2, 1, 2,
		-1, 3,
		-1, 4,
		127
	},
};

/* ANDREEN */
static char patterns_6S2a2b4aB2a3a4b[][2 * NUMPTS + 1] =
{
#if 0
	{		/* 3 different gliders */
		-5, -9,
		-5, -8,
		-4, -7, -3, -7,
		-4, -6,
		-3, -5,
		-1, -2,
		-1, -1, 1, -1,
		-1, 0, 1, 0,
		0, 1,
		0, 2,
		2, 5,
		2, 6,
		2, 7,
		3, 8, 5, 8,
		3, 9,
		127
	},
#endif
	{		/* symmetric 4 glider gun */
		-2, -3, -1, -3, 0, -3,
		-3, -2, -2, -2, 3, -2,
		-2, -1, 0, -1, 1, -1,
		-2, 0, 0, 0, 2, 0, 3, 0,
		-1, 1,
		-1, 2,
		127
	},
	{		/* puffer (p18) */
		-2, -4,
		-3, -3, -2, -3, -1, -3, 0, -3,
		-2, -2, 0, -2,
		-2, -1, 1, -1,
		-2, 0, 2, 0,
		-2, 2, 4, 2,
		-1, 3, 0, 3, 1, 3, 2, 3, 3, 3, 4, 3,
		0, 4, 1, 4, 3, 4, 4, 4,
		1, 5, 4, 5,
		127
	},
	{		/* quasar (p10) */
		-2, -1, -1, -1, 0, -1,
		-1, 0, 0, 0,
		0, 1,
		127
	}
};

/* TRILIFE */
static char patterns_12S34B45[][2 * NUMPTS + 1] =
{
#if 0
	{		/* glider (p7, c/7) lower right */
		1,0, 2,0,
		1,1, 2,1, 4,1,
		1,2, 2,2, 4,2, 5,2,
		4,3, 5,3,
		4,4,
		4,5,
		127
	},
#endif
	{		/* oscillator backwards clock (p6) */
		0, -2, 1, -2,
		0, -1,
		0, 0,
		0, 1, 1, 1,
		127
	},
	{		/* oscillator bat (p2) */
		0, -3,
		0, -2, 1, -2,
		0, -1, 1, -1,
		-1, 0, 0, 0,
		0, 1, 1, 1,
		0, 2, 1, 2,
		0, 3,
		127
	},
	{		/* oscillator jaws (p4) */
		-2, -5, -1, -5, 2, -5, 3, -5,
		-1, -4, 2, -4,
		-2, -3, -1, -3, 2, -3, 3, -3,
		-1, -2, 0, -2, 1, -2, 2, -2,
		-2, -1, -1, -1, 2, -1, 3, -1,
		-1, 0, 2, 0,
		-2, 1, -1, 1, 2, 1, 3, 1,
		-1, 2, 0, 2, 1, 2, 2, 2,
		-2, 3, -1, 3, 2, 3, 3, 3,
		-1, 4, 2, 4,
		-2, 5, -1, 5, 2, 5, 3, 5,
		127
	}
};

static char patterns_12S45B456[][2 * NUMPTS + 1] =
{
#if 0
	{		/* glider (c/4, p8) flutters down */
		0,1,
		0,2, 1,2, 2,2,
		0,3, 1,3,
		0,4,
		0,5, 1,5,
		127
	},
#endif
	{		/* blinker (p2) */
		-1, -2,
		-1, -1,
		-1, 0, 0, 0,
		0, 1,
		0, 2,
		127
	},
	{		/* oscillator backwards clock (p6) */
		-1, -2, 0, -2,
		-1, -1, 0, -1, 1, -1,
		0, 0,
		-1, 1,
		127
	}
};

static char patterns_12S23B45[][2 * NUMPTS + 1] =
{
#if 0
	{		/* glider (p5, c/5) Down */
		1,0, 2,0,
		1,4, 2,4,
		0,5, 1,5, 2,5, 3,5,
		1,6, 2,6,
		127
	},
#endif
	{		/* oscillator (labeled as 2,3/3) (p22) */
		0, -4, 1, -4,
		0, -3,
		-1, -2, 2, -2,
		-2, -1, -1, -1,
		-1, 0, 2, 0,
		0, 1,
		0, 2, 1, 2,
		127
	},
	{		/* oscillator (p2) */
		0, -5, 1, -5,
		0, -4, 1, -4,
		-1, -3, 2, -3,
		-2, -1, 3, -1,
		-2, 1, 3, 1,
		-2, 2, 3, 2,
		-2, 3, -1, 3, 2, 3, 3, 3,
		0, 4, 1, 4,
		127
	}
};


static int  patterns_6rules[] =
{
	(sizeof patterns_6S2b34B2a / sizeof patterns_6S2b34B2a[0]),
	(sizeof patterns_6S2a2b4aB2a3a4b / sizeof patterns_6S2a2b4aB2a3a4b[0])
};

#define common_8size (sizeof patterns_8S23B3_6 / sizeof patterns_8S23B3_6[0])

static int  patterns_8rules[] =
{
	common_8size + (sizeof patterns_8S23B3 / sizeof patterns_8S23B3[0]),
	common_8size + (sizeof patterns_8S23B36 / sizeof patterns_8S23B36[0]),
	(sizeof patterns_8S34678B3678 / sizeof patterns_8S34678B3678[0])
};

static int  patterns_12rules[] =
{
	(sizeof patterns_12S34B45 / sizeof patterns_12S34B45[0]),
	(sizeof patterns_12S45B456 / sizeof patterns_12S45B456[0]),
	(sizeof patterns_12S23B45 / sizeof patterns_12S23B45[0])
};

static paramstruct param_6rules[] =
{
	{
		0x18, 0x0,
		{0x2, 0x0, 0x0},
		{0x1, 0x0, 0x0}
	},
	{
		0x0, 0x0,
		{0x3, 0x0, 0x1},
		{0x1, 0x1, 0x2}
	}
};

static paramstruct param_8rules[] =
{
	{
		0xC, 0x8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{
		0xC, 0x48,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{
		0x1D8, 0x1C8,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	}
};

static paramstruct param_12rules[] =
{
	{
		0x18, 0x30,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{
		0x30, 0x70,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	},
	{
		0xC, 0x30,
		{0x0, 0x0, 0x0},
		{0x0, 0x0, 0x0}
	}
};

#define LIFE_6S2b34B2a 0 /* CALLAHAN */
#define LIFE_6S2a2b4aB2a3a4b 1 /* ANDREEN */
#define LIFE_6GLIDERS 2		/* GLIDER rules are first in param_6rules */
#define LIFE_6RULES (sizeof param_6rules / sizeof param_6rules[0])
#define LIFE_8S23B3 0 /* LIFE, CONWAY */
#define LIFE_8S23B36 1 /* HIGHLIFE, BELL */
#define LIFE_8S34678B3678 2 /* DAY_NIGHT, THOMPSON */
#define LIFE_8GLIDERS 3		/* GLIDER rules are first in param_8rules */
#define LIFE_8RULES (sizeof param_8rules / sizeof param_8rules[0])
#define LIFE_12S34B45 0 /* TRILIFE, BAYS */
#define LIFE_12S45B456 1 /* TRILIFE1, BAYS */
#define LIFE_12S23B45 2 /* TRILIFE2, BAYS */
#define LIFE_12GLIDERS 3	/* GLIDER rules are first in param_12rules */
#define LIFE_12RULES (sizeof param_12rules / sizeof param_12rules[0])
