/*
  ImageMagick MagickWand interface.
*/

#ifndef _MAGICK_WAND_H
#define _MAGICK_WAND_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include "magick/drawing_wand.h"
#include "magick/pixel_wand.h"

typedef struct _MagickWand
  MagickWand;

extern MagickExport const char
  *MagickGetFilename(MagickWand *),
  *MagickGetImageFilename(MagickWand *);

extern MagickExport MagickWand
  *MagickCloneWand(const MagickWand *),
  *MagickCoalesceImages(MagickWand *),
  *NewMagickWand(void);

extern MagickExport unsigned int
  MagickAdaptiveThresholdImage(MagickWand *,const unsigned long,
    const unsigned long,const long),
  MagickAddNoiseImage(MagickWand *,const NoiseType),
  MagickAffineTransformImage(MagickWand *,const DrawingWand *),
  MagickAnnotateImage(MagickWand *,const DrawingWand *),
  MagickAnimateImages(MagickWand *,const char *),
  MagickBlackThresholdImage(MagickWand *,const PixelWand *),
  MagickBlurImage(MagickWand *,const double,const double),
  MagickBorderImage(MagickWand *,const unsigned long,const unsigned long,
    PixelWand *),
  MagickChannelImage(MagickWand *,const ChannelType),
  MagickCharcoalImage(MagickWand *,const double,const double),
  MagickChopImage(MagickWand *,const unsigned long,const unsigned long,
    const long,const long),
  MagickClipImage(MagickWand *),
  MagickColorFloodfillImage(MagickWand *,const long,const long,PixelWand *,
    PixelWand *),
  MagickColorizeImage(MagickWand *,const PixelWand *,const PixelWand *),
  MagickCommentImage(MagickWand *,const char *),
  MagickCompositeImage(MagickWand *,const CompositeOperator,const MagickWand *,
    const long,const long),
  MagickContrastImage(MagickWand *,const unsigned int),
  MagickCompareImage(MagickWand *,const MagickWand *,double *,double *,
    double *),
  MagickCropImage(MagickWand *,const unsigned long,const unsigned long,
    const long,const long),
  MagickDisplayImage(MagickWand *,const char *),
  MagickDisplayImages(MagickWand *,const char *),
  MagickDrawImage(MagickWand *,const DrawingWand *),
  MagickGetException(MagickWand *,char **),
  MagickGetImagePixels(MagickWand *,const long,const long,const unsigned long,
    const unsigned long,const char *,const StorageType,void *),
  MagickNextImage(MagickWand *),
  MagickPreviousImage(MagickWand *),
  MagickReadImage(MagickWand *,const char *),
  MagickResizeImage(MagickWand *,const unsigned long,const unsigned long,
    const FilterTypes,const double),
  MagickRemoveImage(MagickWand *),
  MagickRotateImage(MagickWand *,const double),
  MagickSetImage(MagickWand *,const unsigned long),
  MagickSetImageFilename(MagickWand *,const char *),
  MagickSetImagePixels(MagickWand *,const long,const long,const unsigned long,
    const unsigned long,const char *,const StorageType,void *),
  MagickWriteImage(MagickWand *,const char *),
  MagickWriteImages(MagickWand *,const char *);

extern MagickExport unsigned long
  MagickGetNumberOfImages(MagickWand *);

extern MagickExport void
  DestroyMagickWand(MagickWand *),
  MagickGetSize(MagickWand *,unsigned long *,unsigned long *),
  MagickSetFuzzyColorDistance(MagickWand *,const double),
  MagickSetFilename(MagickWand *,const char *),
  MagickSetSize(MagickWand *,const unsigned long,const unsigned long);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
