/*
 * Copyright (C) 2001-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: main.c,v 1.85 2003/03/23 23:29:30 guenter Exp $
 *
 * gtk+ ui for xine
 *
 * main
 */

#include <config.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <X11/Xlib.h>

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>

#include "globals.h"
#include "actions.h"
#include "infobar.h"
#include "wizards.h"
#include "skin_window.h"
#include "noskin_window.h"
#include "server.h"
#include "open_mrl.h"
#include "log_window.h"
#include "preferences.h"
#include "key_events.h"
#include "mediamarks.h"
#include "playlist.h"
#include "settings.h"
#include "play_item.h"
#include "lirc.h"
#include "stream_info.h"
#include "utils.h"
#include "gtkxine.h"

/*
#define EXP_STUFF 
*/

/*
 * globals
 */

GtkWidget      *app;
GtkWidget      *gtx;
infobar_t      *bar;
pthread_mutex_t engine_lock;

void gxine_try_remote (int argc, char *argv[], int enqueue) {

  if (!server_client_connect()) {
    return;
  }

  /*
   * pass on files to play
   */

  if (!enqueue)
    server_client_send ("playlist_clear();\n");

  if (optind<argc) {
    int i;

    for (i=optind; i<argc; i++) {

      char *mrl;

      mrl = argv[i];

      if ((mrl[0] != '/') && !strstr (mrl, ":/")) {

	/* make filename an absolute pathname */

	char  buf[1024];
	char *pathname;
	int   l1, l2;

	getcwd (buf, 1024);

	l1 = strlen(buf);
	l2 = strlen(mrl);
	
	pathname = g_malloc (l1+l2+2);
	memcpy (pathname, buf, l1);
	pathname[l1]='/';
	memcpy (&pathname[l1+1], mrl, l2);
	pathname[l1+l2+1]=0;

	mrl = pathname;
      }	

      server_client_send ("playlist_add (\"");
      server_client_send (mrl);
      server_client_send ("\");\n");
      i++;
    }

    if (!enqueue)
      server_client_send ("playlist_play (0)\n");
  }

  server_client_stop ();
  exit (0);
}

static GtkWidget *splash;

static void splash_show (void) {

  gchar     *pathname;
  GtkWidget *img;

  gdk_threads_enter();  

  splash = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_decorated (splash, FALSE);

  gtk_window_set_position (splash, GTK_WIN_POS_CENTER_ALWAYS);

  pathname = g_strconcat (GXINE_PIXMAPDIR, "/splash.png", NULL);
  img = gtk_image_new_from_file (pathname);
  g_free (pathname);

  gtk_container_add (GTK_CONTAINER (splash),img);

  gtk_widget_show_all (splash);

  while (gtk_events_pending ()) 
    gtk_main_iteration ();

  gdk_threads_leave();  
}

void splash_hide (void) {
  gdk_threads_enter();  
  gtk_widget_destroy (splash);
  gdk_threads_leave();  
}

int main(int argc, char* argv[]) {

  int            opt, enqueue;

  gchar         *video_driver_id=NULL;
  gchar         *audio_driver_id=NULL;

  /*
   * init glib/gdk/gtk thread safe/aware 
   */

  g_thread_init (NULL);
  gdk_threads_init ();
  gtk_init(&argc, &argv);

  /*
   * some xine engine functions may block for a long
   * time - that's why it is often not called directly
   * but by using an extra thread so the gui will stay
   * responsive
   */

  pthread_mutex_init (&engine_lock, NULL);


  /*
   * parse command line arguments
   */

  verbosity = 0;
  enqueue = 0;
  while ((opt = getopt(argc, argv, "veV:A:")) > 0) {
    switch (opt) {
    case 'v':
      verbosity++;
      break;
    case 'e':
      enqueue = 1;
      break;
    case 'V':
      video_driver_id = optarg;
      break;  
    case 'A':
      audio_driver_id = optarg;
      break;  
    default:
      printf ("usage: %s [-v] [-e] [-V <video_driver>] [-A <audio_driver>] mrls...\n\n", 
	      argv[0]);
      exit (1);
    }
  }

  /*
   * make sure ~/.gxine exists
   */
  {
    char *fname = g_strconcat (g_get_home_dir(), "/.gxine", NULL);
    mkdir (fname, 0700);
    g_free (fname);
  }

  /*
   * find out if gxine is already running, if so
   * just pass on the files to play
   */

  gxine_try_remote (argc, argv, enqueue);

  server_setup ();

  /*
   * a splash screen for the impatient
   */

  splash_show ();


  /*
   * skript engine, main window
   */

  action_init ();

#ifdef EXP_STUFF
  create_skin_window () ;
#endif
  noskin_main_init (audio_driver_id, video_driver_id);

  /*
   * create all dialogs (invisible)
   */

  file_dialog_init ();
  open_mrl_init    ();
  log_window_init  ();
  preferences_init ();
  playlist_init    ();
  settings_init    ();
  mediamarks_init  (); 
  play_item_init   ();
  key_events_init  ();
  gxine_lirc_init  ();
  utils_init       ();
  stream_info_init ();
  
  /*
   * wizards (first run only)
   */

  gdk_threads_enter ();  
  run_wizards (FALSE);
  gdk_threads_leave ();  

  /*
   * argument parsing
   */

  if (optind<argc) {
    int i;
    int first = -1;

    if (!enqueue)
      playlist_clear();

    for (i=optind; i<argc; i++) {

      if (first<0) {
	first = playlist_add_mrl (argv[i]);
      } else {
	playlist_add_mrl (argv[i]);
      }
    }

    playlist_play (first);
  } else
    playlist_logo ();

  server_start ();
  
  splash_hide (); 

  gdk_threads_enter();  
  gtk_main();
  gdk_threads_leave();  

  return 0;
}
