/***************************************************************************
                          text.cpp  -  description
                             -------------------
    begin                : Thu Aug 9 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "text.h"

Text::Text() : GeoObjects()
{
  kapp->config()->setGroup( "Sizes" );
	width = kapp->config()->readNumEntry( "LineWidth", 1 );

  zOrder = 2;
	ID = ID_text;
  identificator = "Text";

	acceptsQPoint = true;
	acceptsQPointOnly = true;
	acceptsGeoPoint = false;
	canBeDestroyed = true;
	isMovable = true;

	textRect = QRect( 0, 0, 0, 0 );
	textFrame = textRect;
	value = "";
}

Text::~Text()
{
}

void Text::paint( QPainter *p )
{
	if ( initComplete )
	{
		if ( textRect.height() == 0 )
		{
			textRect = p->boundingRect ( textRect, Qt::AlignVCenter | Qt::AlignLeft, value );
			textFrame = textRect;
			textFrame.setHeight( textRect.height() + 4 );
			textFrame.setWidth( textRect.width() + 8 );
			textFrame.moveCenter( coords.getQPoint() );
			textRect.moveCenter( coords.getQPoint() );
		}

		p->setPen( QPen( Qt::black, 1, Qt::SolidLine ) );
		p->setBrush( QColor( 255, 255, 222 ) );
		if ( frame )
		{
  		p->drawRect( textFrame );
  		p->drawText( textRect, Qt::AlignVCenter | Qt::AlignLeft , value );
  		QPoint pt = textRect.topLeft();
  		pt.setX( textRect.left() + 2 );
  		pt.setY( textRect.top() + 2 );
  		p->setPen( QPen( QColor( 197, 194, 197 ), 1, Qt::SolidLine ) );
  		p->drawLine( textFrame.topLeft(), textFrame.topRight() );
  		p->drawLine( textFrame.topLeft(), textFrame.bottomLeft() );
		}
		else
		{
  		p->drawText( textRect, Qt::AlignVCenter | Qt::AlignLeft , value );
		}
	}
}

bool Text::contains( QPoint *pt )
{
	return textRect.contains( *pt );
}

void Text::move()
{
 	if ( textRect.height() == 0 )
 	{
		//	Set the text of our label
		EditTextDialog editText( 0, 0, true,0 );
		editText.LineEditText->setFocus();

	  if ( ( editText.exec() ) )
		{	
			if ( editText.LineEditText->text() != 0 )
			{
				if ( editText.LineEditText->text() != "" )
				{
					value = editText.LineEditText->text();
					frame = editText.Frame->isChecked();
					canBeDestroyed = false;
				}
			}
		}
 	}
}

void Text::move( QPoint *pt )
{
	coords.set( *pt );
	coords += moveOffset;

	textRect.moveCenter( coords.getQPoint() );
	textFrame.moveCenter( coords.getQPoint() );
}

void Text::getObjectOverlay( QList <QRect> & list )
{
	list.append( new QRect( textFrame ) );
}

void Text::writeToFile( KSimpleConfig *config )
{
	config->writeEntry( "Geo", ID );
	config->writeEntry( "Color", getColor() );
	config->writeEntry( "Size", width );
	config->writeEntry( "Frame", frame );

	Coordinates coord1( textRect.center() );
	MetricsCenter::mapCanvasToGrid( coord1 );
	config->writeEntry( "TextRectCenterX",  coord1.getD_X() );
	config->writeEntry( "TextRectCenterY",  coord1.getD_Y() );
	config->writeEntry( "TextRectWidth", textRect.width() );
	config->writeEntry( "TextRectHeight", textRect.height() );
	config->writeEntry( "TextRectEntry", value );
}

void Text::readFromFile( KSimpleConfig *config )
{
	textRect = QRect( 0, 0, 0, 0 );

	setColor( config->readColorEntry( "Color" ) );
	size = config->readNumEntry( "Size" );
	frame = config->readBoolEntry( "Frame" );

	int textX = config->readNumEntry( "TextRectWidth" );
	int textY = config->readNumEntry( "TextRectHeight" );
  textRect.setWidth( textX );
  textRect.setHeight( textY );

	QString strX, strY;
	strX = config->readEntry( "TextRectCenterX" );
	strY = config->readEntry( "TextRectCenterY" );
	double x = strX.toDouble();
	double y = strY.toDouble();
	coords.set( x, y );
  MetricsCenter::mapGridToCanvas( coords );
	textRect.moveCenter( coords.getQPoint() );

 	textFrame = textRect;
	textFrame.setHeight( textRect.height() + 4 );
	textFrame.setWidth( textRect.width() + 8 );
	textFrame.moveCenter( coords.getQPoint() );

	value = config->readEntry( "TextRectEntry" );
	initComplete = true;
}
