// Qt-CSharp tutorial 2
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);
		
		QPushButton quit = new QPushButton ("Quit", null);
		// In C++, the second parameter is 0 (null pointer)
		
		quit.Resize (75, 30);
		quit.SetFont (new QFont ("Times", 18, QFont.Weight.Bold));
		// In C++, QFont::Bold is sufficient
		
		QObject.Connect ( quit, QtSupport.SIGNAL ("clicked()"), a, QtSupport.SLOT ("Quit()") );
		// SIGNAL and SLOT are static functions of QtSupport
		
		a.SetMainWidget (quit);
		quit.Show ();
		return a.Exec ();
	}
}
