/***************************************************************************
                            KService.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Represent a service, i.e. an application bound to one or several mimetypes
 (or servicetypes) as written in its desktop entry file.

 A service may be a library, too.
 The starting point you need is often the static methods.

 @author Torben Weis <weis@kde.org>
 
 @short *
 Represent a service, i.
*/
public class KService extends KSycocaEntry  {
	protected KService(Class dummy){super((Class) null);}

	private native void newKService( String _name, String _exec, String _icon);

/** 
 Construct a temporary service with a given name, exec-line and icon.
   
*/
	public KService( String _name, String _exec, String _icon) {
		super((Class) null);
		newKService( _name, _exec, _icon);
	}
	private native void newKService( String _fullpath);

/** 
 Construct a service and take all information from a config file.

*/
	public KService( String _fullpath) {
		super((Class) null);
		newKService( _fullpath);
	}
	private native void newKService( KDesktopFile config);

/** 
 Construct a service and take all information from a desktop file.
   
*/
	public KService( KDesktopFile config) {
		super((Class) null);
		newKService( config);
	}
	private native void newKService( QDataStream _str, int offset);

/** 

 Construct a service from a stream.
 The stream must already be positionned at the correct offset.
   
*/
	public KService( QDataStream _str, int offset) {
		super((Class) null);
		newKService( _str, offset);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native String type();

/** 

*/
	public native String name();

/** 

*/
	public native String exec();

/** 

*/
	public native String library();

/** 

*/
	public native String init();

/** 

*/
	public native String icon();

/** 

*/
	public native QPixmap pixmap( int _group, int _force_size, int _state, String _path);
	public native QPixmap pixmap( int _group);

/** 

*/
	public native boolean terminal();

/** 

 The service must be a tty-oriented program.
   
*/
	public native String terminalOptions();

/** 

*/
	public native boolean substituteUid();

/** 

*/
	public native String username();

/** 

 This is a relative path if the desktop entry was found in any
 of the locations pointed to by $KDEDIRS (e.g. "Internet/kppp.desktop")
 It is a full path if the desktop entry originates from another
 location.
   
*/
	public native String desktopEntryPath();

/** 

*/
	public native String desktopEntryName();

/** 

*/
	public native int DCOPServiceType();

/** 

*/
	public native String path();

/** 

*/
	public native String comment();

/** 

*/
	public native String genericName();

/** 

*/
	public native ArrayList keywords();

/** 

*/
	public native ArrayList categories();

/** 

*/
	public native ArrayList serviceTypes();

/** 

*/
	public native boolean hasServiceType( String _service);

/** 

*/
	public native boolean allowAsDefault();

/** 

*/
	public native boolean allowMultipleFiles();

/** 
 What preference to associate with this service initially (before
 the user has had any chance to define a profile for it)
 The bigger the value, the most preferred the service is.
   
*/
	public native int initialPreference();

/** 

   
*/
	public native void setInitialPreference( int i);

/** 
 Whether the entry should be suppressed in menus.
   
*/
	public native boolean noDisplay();

/** 
 Name of the application this service belongs to.
 (Usefull for e.g. plugins)

*/
	public native String parentApp();

/** 

         It depends upon the {@link #serviceTypes} of this service which
         properties a service can have.

*/
	public native QVariant property( String _name);

/** 

*/
	public native ArrayList propertyNames();

/** 

*/
	public native boolean isValid();

/** 

 Load the service from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 

 Save the service to a stream.
   
*/
	public native void save( QDataStream arg1);

/** 
 Find a service by name, i.e. the translated Name field. You should
 really not use this method, since the name is translated.

*/
	public static native int serviceByName( String _name);

/** 
 Find a service by its relative path to the applnk or services
 directory, for instance "Internet/konqbrowser.desktop". Better not use
 it for menu entries though, since the user can move them.
 It's ok to use it for services though (e.g. "http_cache_cleaner.desktop")

*/
	public static native int serviceByDesktopPath( String _name);

/** 
 Find a service by the name of its desktop file, not depending on
 its actual location (as long as it's under the applnk or service
 directories). For instance "konqbrowser" or "kcookiejar". Note that
 the ".desktop" extension is implicit.

 This is the recommended method (safe even if the user moves stuff)
 but note that it assumes that no two entries have the same filename.

*/
	public static native int serviceByDesktopName( String _name);

/** 

  Useful for being able to
 to display them in a list box, for example.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
	public static native List allServices();

/** 

 Only needed by "kcminit"
   
*/
	public static native List allInitServices();
	protected native void init( KDesktopFile config);
	protected native ArrayList accessServiceTypes();
	protected native void virtual_hook( int identifier, int data);
	public static final int DCOP_None = 0;
	public static final int DCOP_Unique = 0;
	public static final int DCOP_Multi = 1;
	public static final int DCOP_Wait = 2;
}
