// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef HWINDOW_H
#define HWINDOW_H

#include <kmainwindow.h>
#include <kurl.h>
#include <qmap.h>

#include <noatun/playlist.h>
#include <noatun/plugin.h>

class KAction;
class KFileTreeViewItem;
class KToggleAction;
class KEdFind;
class KListView;
class QLabel;
class QListViewItem;

namespace Hayes
{
class Playlist;
class ListView;
class ListViewItem;

/**
 * Window is the plugin itself, and is the bulk of the UI.  It is *not* the playlist.
 * It *has* a playlist, Playlist *list.
 */
class Window : public KMainWindow, public Plugin
{
Q_OBJECT

public:
	Window();
	virtual ~Window();

	virtual void init(void);
	virtual ::Playlist *playlist(void);

signals:
	void listHidden(void);
	void listShown(void);

protected:
	void closeEvent(QCloseEvent *);
	void hideEvent(QHideEvent *);
	void showEvent(QShowEvent *);

private slots:
	void search(void);
	void searchDone(void);

	void newSong(PlaylistItem);

	void contextMenu(KListView *, QListViewItem *, const QPoint &);
	void properties(void);
	void openInBrowser(void);

	void file_open(void);
	void edit_find(void);
	void options_shuffle(void);
	void options_volume(void);
	void options_menubar(void);
	void options_toolbar(void);
	void options_playerToolbar(void);
	void options_statusbar(void);
	void options_configuretoolbars(void);
	void options_configurekeys(void);
	void aboutHayes(void);

private:
	Playlist *list;
	ListView *listView;

	KToggleAction *options_shuffleAction, *options_volumeAction;
	KToggleAction *options_toolbarAction, *options_menubarAction;
	KToggleAction *options_statusbarAction, *options_playerToolbarAction;

	QLabel *currentSong;

	KURL currentPlaylistURL;

	KEdFind *findDialog;
	PlaylistItem findCurrent;

	KPopupMenu *dirMenu;
	KPopupMenu *menu;
	KFileTreeViewItem *contextItem;
};

}

#endif
