// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef HBRANCH_H
#define HBRANCH_H

#include <kfiletreebranch.h>
#include <kfiletreeview.h>
#include <kfiletreeviewitem.h>
#include <ksimpleconfig.h>
#include <qcache.h>
#include <qcolor.h>
#include <qregexp.h>

namespace Hayes
{

class FileTreeViewItem;

// a KFileTreeView that reverts back to KListView drag/drop behavior
// also manages the checkbox column, for use with FileTreeViewItems (see below)
// also manages tristate sort mode, for reordering
class FileTreeView : public KFileTreeView
{
Q_OBJECT

friend class FileTreeViewItem;

public:
	FileTreeView(QWidget *, const char *);
	virtual ~FileTreeView(void);
	// use these instead
	void superSaveLayout(KConfig *, const QString &);
	void superRestoreLayout(KConfig *, const QString &);

	void setColumns(int);

	void sortDirectoriesFirst(bool);
	bool isSortingDirectoriesFirst(void) const;

	// this is a cache for the items to share
	KSimpleConfig &directoryCache(const KURL&);
	QString mimetypes(void);

	enum Sorting
	{
		Ascending = 0,
		Descending,
		Custom
	};

	Sorting sorting(void) { return sortDirection; }

	// this is all for the special
	void setSpecialItem(FileTreeViewItem *);
	FileTreeViewItem *specialItem(void);
	virtual void clear(void);
	virtual void takeItem(QListViewItem *);

signals:
	void itemTaken(FileTreeViewItem *);

protected:
	virtual bool acceptDrag(QDropEvent *) const;
	virtual QDragObject *dragObject(void);
	virtual void contentsDragEnterEvent(QDragEnterEvent *);
	virtual void contentsDragMoveEvent(QDragMoveEvent *);
	virtual void contentsDragLeaveEvent(QDragLeaveEvent *);
	virtual void contentsDropEvent(QDropEvent *);

	virtual void movableDropEvent(QListViewItem *, QListViewItem *);

private slots:
	void headerIndexChange(int, int, int);
	void myChangeSortColumn(int);
	void applySorting(int column);
	void handleMove(QListViewItem *, QListViewItem *, QListViewItem *);
	void customSort(void);
	void updateSortKeys( int col );

private:
	QCache<KSimpleConfig> cache;
	QString mimetypeCache;
	Sorting sortDirection;
	FileTreeViewItem *special;
	bool directoriesFirst;
};

class Branch : public KFileTreeBranch
{
Q_OBJECT

public:
	Branch(FileTreeView *, const KURL &, const QString &);

protected:
	virtual KFileTreeViewItem *createTreeViewItem(KFileTreeViewItem *, KFileItem *);

protected slots:
	void refresh(const KFileItemList &);
	void refresh(KFileItem *, FileTreeViewItem *, bool firstTime = false);
};

// This is a KFileTreeViewItem *and* a Check item
// But mine uses the real style for the check button so neener neener
class FileTreeViewItem : public KFileTreeViewItem
{
public:
	FileTreeViewItem(FileTreeView *, KFileItem *, Branch *);
	FileTreeViewItem(FileTreeViewItem *, KFileItem *, Branch *);
	~FileTreeViewItem(void);

	virtual int width(const QFontMetrics &, const QListView *, int) const;
	static int checkBoxWidth(void);

	void setSpecial(bool);
	bool isSpecial(void) const;

	void setOn(bool);
	bool isOn(void) const;
	void toggle(void);

	void setVolume(int);
	bool hasVolume(void) const;
	int volume(void) const;

	virtual QString key(int, bool) const;
	void updateKey( int col );

protected:
	virtual void paintCell(QPainter *, const QColorGroup &, int, int, int);
	virtual void activate(void);

	QRect checkBoxRect(void) const;
	QRect checkBoxCellRect(void) const;

	bool supported(void) const;
private:
	QString m_key;
	bool special : 1;
	bool on : 1;
	bool check : 1;

	class SharedData
	{
	public:
		SharedData();
		QRegExp re1, re2;
	};

	static SharedData *shared;
};

}

#endif
