/*
 *  Copyright (C) 2003 Crispin Flowerday
 *
 *  Derived from galeon-stop-button.h:
 *      Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_fullscreen_button_h
#define __galeon_fullscreen_button_h

#include "galeon-tbi.h"

/* object forward declarations */

typedef struct _GaleonFullscreenButton GaleonFullscreenButton;
typedef struct _GaleonFullscreenButtonClass GaleonFullscreenButtonClass;
typedef struct _GaleonFullscreenButtonPrivate GaleonFullscreenButtonPrivate;

/**
 * TbiFullscreen object
 */

#define GALEON_TYPE_FULLSCREEN_BUTTON			(galeon_fullscreen_button_get_type())
#define GALEON_FULLSCREEN_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GALEON_TYPE_FULLSCREEN_BUTTON, GaleonFullscreenButton))
#define GALEON_FULLSCREEN_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_FULLSCREEN_BUTTON,\
							 GaleonFullscreenButtonClass))
#define GALEON_IS_FULLSCREEN_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GALEON_TYPE_FULLSCREEN_BUTTON))
#define GALEON_IS_FULLSCREEN_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_FULLSCREEN_BUTTON))
#define GALEON_FULLSCREEN_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_FULLSCREEN_BUTTON,\
							 GaleonFullscreenButtonClass))

struct _GaleonFullscreenButtonClass 
{
	GaleonTbiClass parent_class;
};

/* Remember: fields are public read-only */
struct _GaleonFullscreenButton
{
	GaleonTbi parent_object;
	GaleonFullscreenButtonPrivate *priv;
};



GType				galeon_fullscreen_button_get_type	(void);
GaleonFullscreenButton *	galeon_fullscreen_button_new		(void);
void                            galeon_fullscreen_button_set_fullscreen (GaleonFullscreenButton *b, gboolean s);
#endif
