.\"
.\" "$Id: filter.man,v 1.10 2003/01/24 19:31:58 mike Exp $"
.\"
.\"   filter man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2003 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH filter 1 "Common UNIX Printing System" "22 June 2000" "Easy Software Products"
.SH NAME
filter \- cups file conversion filter interfaces
.SH SYNOPSIS
.B filter
job user title num-copies options [
.I filename
]
.SH DESCRIPTION
The CUPS filter interface provides a standard method for adding support for
new document types to CUPS. Each filter is capable of converting from one
or more input formats to another format that can either be printed directly
or piped into another filter to get it to a printable format.
.LP
Filters must be capable of reading from a filename on the command-line
or from the standard input, copying the standard input to a temporary
file as required by the file format. All output must be sent to the
standard output.
.LP
The command name (argv[0]) is set to the name of the destination printer.
.SH ENVIRONMENT VARIABLES
The following environment variables are defined by the CUPS server when
executing each filter:
.TP 5
CHARSET
.br
The default text character set (typically us-ascii or iso-8859-1).
.TP 5
CLASS
.br
When a job is submitted to a printer class, contains the name of
the destination printer class. Otherwise this environment
variable will not be set.
.TP 5
CONTENT_TYPE
.br
The MIME type associated with the file (e.g. application/postscript).
.TP 5
CUPS_DATADIR
.br
The directory where data files can be found.
.TP 5
CUPS_SERVERROOT
.br
The root directory of the server.
.TP 5
DEVICE_URI
.br
The device-uri associated with the printer.
.TP 5
LANG
.br
The default language locale (typically C or en).
.TP 5
PATH
.br
The standard execution path for external programs that may be run by the filter.
.TP 5
PPD
.br
The full pathname of the PostScript Printer Description (PPD) file for
this printer.
.TP 5
PRINTER
.br
The name of the printer; this is provided for shell scripts which may not be
able to get the passed argv[0] string.
.TP 5
RIP_CACHE
.br
The recommended amount of memory to use for Raster Image Processors (RIPs).
.TP 5
SOFTWARE
.br
The name and version number of the server (typically CUPS/1.1).
.TP 5
TZ
.br
The timezone of the server.
.TP 5
USER
.br
The user executing the filter, typically lp; consult the cupsd.conf file for
the current setting.
.SH COMPATIBILITY
While the filter interface is compatible with System V interface
scripts, it will only work with the System V interface script as the
only filter.  Typically the interface script will be provided via the
\fBlpadmin(8)\fR command using the \fI-i\fR option.
.SH SEE ALSO
backend(1), cupsd(8),
CUPS Interface Design Description,
CUPS Software Administrators Manual,
CUPS Software Programmers Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2003 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: filter.man,v 1.10 2003/01/24 19:31:58 mike Exp $".
.\"
