/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Arguments;
import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.Comment;
import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.ForwardValueEntry;
import com.sun.tools.corba.se.idl.IDLID;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.InterfaceType;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.NativeEntry;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Preprocessor;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.Scanner;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.SymtabFactory;
import com.sun.tools.corba.se.idl.Token;
import com.sun.tools.corba.se.idl.TokenBuffer;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionBranch;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.ExprFactory;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.constExpr.Negative;
import com.sun.tools.corba.se.idl.constExpr.Not;
import com.sun.tools.corba.se.idl.constExpr.Positive;
import com.sun.tools.corba.se.idl.constExpr.Terminal;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class Parser {
    private boolean _isModuleLegalType = false;
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private static final int MIN_SHORT = Short.MIN_VALUE;
    private static final int MAX_USHORT = 65535;
    UnionBranch defaultBranch = null;
    public static final String unknownNamePrefix = "uN__";
    static Hashtable symbolTable;
    Hashtable lcSymbolTable = new Hashtable();
    static Hashtable overrideNames;
    Vector emitList = new Vector();
    boolean emitAll;
    boolean cppModule;
    boolean noWarn;
    Scanner scanner;
    Hashtable symbols;
    Vector macros = new Vector();
    Vector paths;
    SymtabEntry currentModule = null;
    static Stack repIDStack;
    int sequence = 0;
    Vector includes;
    Vector includeEntries;
    boolean parsingConditionalExpr = false;
    Token token;
    ModuleEntry topLevelModule;
    private Preprocessor prep;
    private boolean verbose;
    SymtabFactory stFactory;
    ExprFactory exprFactory;
    private String[] keywords;
    private TokenBuffer tokenHistory = new TokenBuffer();
    protected float corbaLevel;
    private Arguments arguments;

    static {
        repIDStack = new Stack();
    }

    private void addPrimEntries() {
        symbolTable.put("short", this.stFactory.primitiveEntry("short"));
        symbolTable.put("long", this.stFactory.primitiveEntry("long"));
        symbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        symbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        symbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        symbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        symbolTable.put("char", this.stFactory.primitiveEntry("char"));
        symbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        symbolTable.put("float", this.stFactory.primitiveEntry("float"));
        symbolTable.put("double", this.stFactory.primitiveEntry("double"));
        symbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        symbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        symbolTable.put("any", this.stFactory.primitiveEntry("any"));
        InterfaceEntry interfaceEntry = this.stFactory.interfaceEntry();
        interfaceEntry.name("Object");
        symbolTable.put("Object", interfaceEntry);
        ValueEntry valueEntry = this.stFactory.valueEntry();
        valueEntry.name("ValueBase");
        symbolTable.put("ValueBase", valueEntry);
        this.lcSymbolTable.put("short", this.stFactory.primitiveEntry("short"));
        this.lcSymbolTable.put("long", this.stFactory.primitiveEntry("long"));
        this.lcSymbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        this.lcSymbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        this.lcSymbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        this.lcSymbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        this.lcSymbolTable.put("char", this.stFactory.primitiveEntry("char"));
        this.lcSymbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        this.lcSymbolTable.put("float", this.stFactory.primitiveEntry("float"));
        this.lcSymbolTable.put("double", this.stFactory.primitiveEntry("double"));
        this.lcSymbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        this.lcSymbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        this.lcSymbolTable.put("any", this.stFactory.primitiveEntry("any"));
        this.lcSymbolTable.put("object", interfaceEntry);
        this.lcSymbolTable.put("valuebase", valueEntry);
    }

    public static void enteringInclude() {
        repIDStack.push(new IDLID());
    }

    public static void exitingInclude() {
        repIDStack.pop();
    }

    void forwardEntryCheck() {
        Enumeration enumeration = symbolTable.elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (!(symtabEntry instanceof ForwardEntry)) continue;
            ParseException.forwardEntry(this.scanner, symtabEntry.fullName());
        }
    }

    private void issueTokenWarnings() {
        if (this.noWarn) {
            return;
        }
        if ((this.token.equals(80) || this.token.equals(81)) && !this.token.isEscaped() && this.token.collidesWithKeyword()) {
            ParseException.warning(this.scanner, Util.getMessage("Migration.keywordCollision", this.token.name));
        }
        if (this.token.isKeyword() && this.token.isDeprecated()) {
            ParseException.warning(this.scanner, Util.getMessage("Deprecated.keyword", this.token.toString()));
        }
    }

    private void skipToRightBrace() throws IOException {
        boolean bl = true;
        while (!this.token.equals(999) && !this.token.equals(102)) {
            if (bl) {
                bl = false;
            } else if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
    }

    private void skipToSemicolon() throws IOException {
        while (!this.token.equals(999) && !this.token.equals(100)) {
            if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
        try {
            this.match(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isModuleLegalType() {
        return this._isModuleLegalType;
    }

    private void match(int n) throws IOException, ParseException {
        String string;
        ParseException parseException = null;
        if (!this.token.equals(n)) {
            parseException = ParseException.syntaxError(this.scanner, n, this.token.type);
            if (n == 100) {
                return;
            }
        }
        this.token = this.scanner.getToken();
        this.issueTokenWarnings();
        this.tokenHistory.insert(this.token);
        while (this.token.isDirective()) {
            this.token = this.prep.process(this.token);
        }
        if ((this.token.equals(80) || this.token.equals(81)) && (string = (String)this.symbols.get(this.token.name)) != null && !string.equals("")) {
            if (this.macros.contains(this.token.name)) {
                this.scanner.scanString(this.prep.expandMacro(string, this.token));
                this.match(this.token.type);
            } else {
                this.scanner.scanString(string);
                this.match(this.token.type);
            }
        }
        if (parseException != null) {
            throw parseException;
        }
    }

    public void isModuleLegalType(boolean bl) {
        this._isModuleLegalType = bl;
    }

    private void enumType2(EnumEntry enumEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String string = this.token.name;
            this.match(80);
            if (!this.isntInStringList(enumEntry.elements(), string)) continue;
            enumEntry.addElement(string);
            SymtabEntry symtabEntry = new SymtabEntry(enumEntry.container(), (IDLID)repIDStack.peek());
            if (symtabEntry.module().equals("")) {
                symtabEntry.module(symtabEntry.name());
            } else if (!symtabEntry.name().equals("")) {
                symtabEntry.module(symtabEntry.module() + "/" + symtabEntry.name());
            }
            symtabEntry.name(string);
            this.pigeonhole(enumEntry.container(), symtabEntry);
        }
    }

    private void attrDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        AttributeEntry attributeEntry = this.stFactory.attributeEntry(interfaceEntry, (IDLID)repIDStack.peek());
        attributeEntry.sourceFile(this.scanner.fileEntry());
        attributeEntry.comment(this.token.comment);
        Comment comment = attributeEntry.comment();
        if (this.token.type == 25) {
            this.match(25);
            attributeEntry.readOnly(true);
        }
        this.match(1);
        attributeEntry.type(this.paramTypeSpec(attributeEntry));
        attributeEntry.name(this.token.name);
        if (!this.token.comment.text().equals("")) {
            attributeEntry.comment(this.token.comment);
        }
        interfaceEntry.methodsAddElement(attributeEntry, this.scanner);
        this.pigeonholeMethod(interfaceEntry, attributeEntry);
        if (!this.token.comment.text().equals("")) {
            AttributeEntry attributeEntry2 = (AttributeEntry)attributeEntry.clone();
            attributeEntry2.comment(comment);
            this.match(80);
            this.attrDcl2(interfaceEntry, attributeEntry2);
        } else {
            this.match(80);
            this.attrDcl2(interfaceEntry, attributeEntry);
        }
    }

    private void export(InterfaceEntry interfaceEntry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 29: 
                case 32: 
                case 34: {
                    this.typeDcl(interfaceEntry);
                    break;
                }
                case 5: {
                    this.constDcl(interfaceEntry);
                    break;
                }
                case 19: {
                    this.nativeDcl(interfaceEntry);
                    break;
                }
                case 10: {
                    this.exceptDcl(interfaceEntry);
                    break;
                }
                case 1: 
                case 25: {
                    this.attrDcl(interfaceEntry);
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 8: 
                case 13: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 27: 
                case 28: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 45: 
                case 80: 
                case 124: {
                    this.opDcl(interfaceEntry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9, 5, 10, 25, 1, 22, 13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 35, 45}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void inheritanceSpec(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        this.match(103);
        while (true) {
            SymtabEntry symtabEntry;
            SymtabEntry symtabEntry2;
            if (this.isInterfaceOnly(symtabEntry2 = Parser.typeOf(symtabEntry = this.scopedName(interfaceEntry.container(), this.stFactory.interfaceEntry())))) {
                boolean bl = symtabEntry2 instanceof InterfaceEntry;
                if (interfaceEntry.derivedFrom().contains(symtabEntry2)) {
                    ParseException.alreadyDerived(this.scanner, symtabEntry2.fullName(), interfaceEntry.fullName());
                } else if (!interfaceEntry.isAbstract() || ((InterfaceType)((Object)symtabEntry2)).getInterfaceType() == 1) {
                    interfaceEntry.derivedFromAddElement(symtabEntry2, this.scanner);
                } else {
                    ParseException.nonAbstractParent(this.scanner, interfaceEntry.fullName(), symtabEntry.fullName());
                }
            } else if (this.isForward(symtabEntry2)) {
                ParseException.illegalForwardInheritance(this.scanner, interfaceEntry.fullName(), symtabEntry.fullName());
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "interface", this.entryName(symtabEntry));
            }
            if (symtabEntry instanceof InterfaceEntry && ((InterfaceEntry)symtabEntry).state() != null) {
                if (interfaceEntry.state() == null) {
                    interfaceEntry.initState();
                } else {
                    throw ParseException.badState(this.scanner, interfaceEntry.fullName());
                }
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private void interfaceDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        if (this.token.type != 101) {
            this.inheritanceSpec(interfaceEntry);
        } else if (!interfaceEntry.isAbstract()) {
            SymtabEntry symtabEntry = this.qualifiedEntry("Object");
            SymtabEntry symtabEntry2 = Parser.typeOf(symtabEntry);
            if (symtabEntry != null) {
                if (!this.isInterface(symtabEntry2)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("Object"), "interface", symtabEntry.typeName());
                } else {
                    interfaceEntry.derivedFromAddElement(symtabEntry2, this.scanner);
                }
            }
        }
        this.prep.openScope(interfaceEntry);
        this.match(101);
        while (this.token.type != 102) {
            this.export(interfaceEntry);
        }
        this.prep.closeScope(interfaceEntry);
        this.match(102);
    }

    private void opDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        MethodEntry methodEntry = this.stFactory.methodEntry(interfaceEntry, (IDLID)repIDStack.peek());
        methodEntry.sourceFile(this.scanner.fileEntry());
        methodEntry.comment(this.token.comment);
        if (this.token.type == 22) {
            this.match(22);
            methodEntry.oneway(true);
        }
        methodEntry.type(this.opTypeSpec(methodEntry));
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        methodEntry.name(this.token.name);
        interfaceEntry.methodsAddElement(methodEntry, this.scanner);
        this.pigeonholeMethod(interfaceEntry, methodEntry);
        this.opDcl2(methodEntry);
        if (methodEntry.oneway()) {
            this.checkIfOpLegalForOneway(methodEntry);
        }
        repIDStack.pop();
    }

    private void checkIfOpLegalForOneway(MethodEntry methodEntry) {
        boolean bl = false;
        if (methodEntry.type() != null || methodEntry.exceptions().size() != 0) {
            bl = true;
        } else {
            Enumeration enumeration = methodEntry.parameters().elements();
            while (enumeration.hasMoreElements()) {
                if (((ParameterEntry)enumeration.nextElement()).passType() == 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            ParseException.oneway(this.scanner, methodEntry.name());
        }
    }

    private void contextExpr(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(6);
        this.match(108);
        String string = (String)this.stringLiteral().value();
        if (this.isntInStringList(methodEntry.contexts(), string)) {
            methodEntry.addContext(string);
        }
        this.contextExpr2(methodEntry);
        this.match(109);
    }

    private void contextExpr2(MethodEntry methodEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String string = (String)this.stringLiteral().value();
            if (!this.isntInStringList(methodEntry.contexts(), string)) continue;
            methodEntry.addContext(string);
        }
    }

    private void initParamDcl(MethodEntry methodEntry) throws IOException, ParseException {
        ParameterEntry parameterEntry = this.stFactory.parameterEntry(methodEntry, (IDLID)repIDStack.peek());
        parameterEntry.sourceFile(this.scanner.fileEntry());
        parameterEntry.comment(this.token.comment);
        this.match(14);
        parameterEntry.passType(0);
        parameterEntry.type(this.paramTypeSpec(methodEntry));
        parameterEntry.name(this.token.name);
        this.match(80);
        if (this.isntInList(methodEntry.parameters(), parameterEntry.name())) {
            methodEntry.addParameter(parameterEntry);
        }
    }

    private void opDcl2(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.equals(81)) {
            this.match(81);
            this.parameterDcls2(methodEntry);
        } else {
            this.match(80);
            this.parameterDcls(methodEntry);
        }
        this.opDcl3(methodEntry);
    }

    private void opDcl3(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.type != 100) {
            if (!this.token.equals(24) && !this.token.equals(6)) {
                throw ParseException.syntaxError(this.scanner, new int[]{24, 6, 100}, this.token.type);
            }
            if (this.token.type == 24) {
                this.raisesExpr(methodEntry);
            }
            if (this.token.type == 6) {
                this.contextExpr(methodEntry);
            }
        }
    }

    private void paramDcl(MethodEntry methodEntry) throws IOException, ParseException {
        ParameterEntry parameterEntry = this.stFactory.parameterEntry(methodEntry, (IDLID)repIDStack.peek());
        parameterEntry.sourceFile(this.scanner.fileEntry());
        parameterEntry.comment(this.token.comment);
        this.paramAttribute(parameterEntry);
        parameterEntry.type(this.paramTypeSpec(methodEntry));
        parameterEntry.name(this.token.name);
        this.match(80);
        if (this.isntInList(methodEntry.parameters(), parameterEntry.name())) {
            methodEntry.addParameter(parameterEntry);
        }
    }

    private void parameterDcls(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(108);
        this.parameterDcls2(methodEntry);
    }

    private void parameterDcls2(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.type == 109) {
            this.match(109);
        } else {
            this.paramDcl(methodEntry);
            while (this.token.type == 104) {
                this.match(104);
                this.paramDcl(methodEntry);
            }
            this.match(109);
        }
    }

    private void raisesExpr(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(24);
        this.match(108);
        Comment comment = this.token.comment;
        SymtabEntry symtabEntry = this.scopedName(methodEntry.container(), this.stFactory.exceptionEntry());
        if (Parser.typeOf(symtabEntry) instanceof ExceptionEntry) {
            symtabEntry.comment(comment);
            if (this.isntInList(methodEntry.exceptions(), symtabEntry)) {
                methodEntry.exceptionsAddElement((ExceptionEntry)symtabEntry);
            }
        } else {
            ParseException.wrongType(this.scanner, symtabEntry.fullName(), "exception", this.entryName(symtabEntry.type()));
        }
        this.raisesExpr2(methodEntry);
        this.match(109);
    }

    private void raisesExpr2(MethodEntry methodEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            Comment comment = this.token.comment;
            SymtabEntry symtabEntry = this.scopedName(methodEntry.container(), this.stFactory.exceptionEntry());
            if (Parser.typeOf(symtabEntry) instanceof ExceptionEntry) {
                symtabEntry.comment(comment);
                if (!this.isntInList(methodEntry.exceptions(), symtabEntry)) continue;
                methodEntry.addException((ExceptionEntry)symtabEntry);
                continue;
            }
            ParseException.wrongType(this.scanner, symtabEntry.fullName(), "exception", this.entryName(symtabEntry.type()));
        }
    }

    private void addToEmitList(ModuleEntry moduleEntry) {
        Enumeration enumeration = moduleEntry.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry.emit()) {
                this.emitList.addElement(symtabEntry);
                if (symtabEntry instanceof ModuleEntry) {
                    this.checkContained((ModuleEntry)symtabEntry);
                }
                if (!(symtabEntry instanceof IncludeEntry)) continue;
                this.includes.addElement(symtabEntry.name());
                this.includeEntries.addElement(symtabEntry);
                continue;
            }
            if (!(symtabEntry instanceof ModuleEntry)) continue;
            this.checkContained((ModuleEntry)symtabEntry);
        }
        moduleEntry.contained().removeAllElements();
    }

    private void checkContained(ModuleEntry moduleEntry) {
        Enumeration enumeration = moduleEntry.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof ModuleEntry) {
                this.checkContained((ModuleEntry)symtabEntry);
            }
            if (!symtabEntry.emit()) continue;
            if (!this.emitList.contains(moduleEntry)) {
                this.emitList.addElement(moduleEntry);
            }
            moduleEntry.emit(true);
            break;
        }
    }

    private void definition(ModuleEntry moduleEntry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 29: 
                case 32: 
                case 34: {
                    this.typeDcl(moduleEntry);
                    break;
                }
                case 5: {
                    this.constDcl(moduleEntry);
                    break;
                }
                case 19: {
                    this.nativeDcl(moduleEntry);
                    break;
                }
                case 10: {
                    this.exceptDcl(moduleEntry);
                    break;
                }
                case 16: {
                    this.interfaceProd(moduleEntry, 0);
                    break;
                }
                case 55: {
                    this.match(55);
                    if (this.token.type == 16) {
                        this.interfaceProd(moduleEntry, 2);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{16}, this.token.type);
                }
                case 18: {
                    this.module(moduleEntry);
                    break;
                }
                case 39: {
                    this.match(39);
                    if (this.token.type == 16) {
                        this.interfaceProd(moduleEntry, 1);
                        break;
                    }
                    if (this.token.type == 46) {
                        this.valueProd(moduleEntry, true);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{16, 46}, this.token.type);
                }
                case 40: 
                case 46: {
                    this.valueProd(moduleEntry, false);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9, 5, 10, 16, 46, 18}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void module(ModuleEntry moduleEntry) throws IOException, ParseException {
        this.match(18);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ModuleEntry moduleEntry2 = this.newModule(moduleEntry);
        ((IDLID)repIDStack.peek()).appendToName(moduleEntry2.name());
        moduleEntry2.comment(this.tokenHistory.lookBack((int)1).comment);
        this.currentModule = moduleEntry2;
        this.match(80);
        this.prep.openScope(moduleEntry2);
        this.match(101);
        this.definition(moduleEntry2);
        while (!this.token.equals(999) && !this.token.equals(102)) {
            this.definition(moduleEntry2);
        }
        this.prep.closeScope(moduleEntry2);
        this.match(102);
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    private void specification(ModuleEntry moduleEntry) throws IOException {
        while (!this.token.equals(999)) {
            this.definition(moduleEntry);
            this.addToEmitList(moduleEntry);
        }
    }

    private void interfaceProd(ModuleEntry moduleEntry, int n) throws IOException, ParseException {
        this.match(16);
        String string = this.token.name;
        this.match(80);
        this.interface2(moduleEntry, string, n);
    }

    private void valueProd(ModuleEntry moduleEntry, boolean bl) throws IOException, ParseException {
        boolean bl2;
        boolean bl3 = bl2 = this.token.type == 40;
        if (bl2) {
            this.match(40);
        }
        this.match(46);
        String string = this.token.name;
        this.match(80);
        switch (this.token.type) {
            case 43: 
            case 101: 
            case 103: {
                this.value2(moduleEntry, string, bl, bl2);
                return;
            }
            case 100: {
                if (bl2) break;
                this.valueForwardDcl(moduleEntry, string, bl);
                return;
            }
        }
        if (bl2) {
            throw ParseException.badCustom(this.scanner);
        }
        if (bl) {
            throw ParseException.abstractValueBox(this.scanner);
        }
        this.valueBox(moduleEntry, string);
    }

    private void paramAttribute(ParameterEntry parameterEntry) throws IOException, ParseException {
        if (this.token.type == 14) {
            parameterEntry.passType(0);
            this.match(14);
        } else if (this.token.type == 23) {
            parameterEntry.passType(2);
            this.match(23);
        } else if (this.token.type == 15) {
            parameterEntry.passType(1);
            this.match(15);
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{14, 23, 15}, this.token.type);
        }
    }

    private PrimitiveEntry booleanType() throws IOException, ParseException {
        PrimitiveEntry primitiveEntry = null;
        this.match(2);
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry("boolean");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("boolean"));
        }
        return primitiveEntry;
    }

    private PrimitiveEntry charType() throws IOException, ParseException {
        String string;
        if (this.token.type == 4) {
            this.match(4);
            string = "char";
        } else {
            this.match(36);
            string = "wchar";
        }
        PrimitiveEntry primitiveEntry = null;
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName(string));
        }
        return primitiveEntry;
    }

    private PrimitiveEntry floatingPtType() throws IOException, ParseException {
        Object object;
        String string = "double";
        if (this.token.type == 13) {
            this.match(13);
            string = "float";
        } else if (this.token.type == 8) {
            this.match(8);
        } else {
            object = new int[]{13, 8};
            ParseException.syntaxError(this.scanner, new int[]{13, 8}, this.token.type);
        }
        object = null;
        try {
            object = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, string);
        }
        return object;
    }

    private PrimitiveEntry octetType() throws IOException, ParseException {
        PrimitiveEntry primitiveEntry = null;
        this.match(21);
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry("octet");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("octet"));
        }
        return primitiveEntry;
    }

    private void member(StructEntry structEntry) throws IOException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(structEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        try {
            typedefEntry.type(this.typeSpec(structEntry));
            if (typedefEntry.type() == structEntry) {
                throw ParseException.recursive(this.scanner, structEntry.fullName(), this.token.name == null ? "" : this.token.name);
            }
            if (Parser.typeOf(typedefEntry) instanceof ExceptionEntry) {
                throw ParseException.illegalException(this.scanner, this.entryName(structEntry));
            }
            this.declarators(typedefEntry, structEntry.members());
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void memberList2(StructEntry structEntry) throws IOException {
        while (this.token.type != 102) {
            this.member(structEntry);
        }
    }

    private SymtabEntry anyType() throws IOException, ParseException {
        this.match(0);
        try {
            return this.qualifiedEntry("any");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("any"));
            return null;
        }
    }

    private void constDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(5);
        ConstEntry constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.constType(constEntry);
        constEntry.name(this.token.name);
        this.match(80);
        this.match(105);
        constEntry.value(this.constExp(constEntry));
        this.verifyConstType(constEntry.value(), Parser.typeOf(constEntry.type()));
        this.pigeonhole(symtabEntry, constEntry);
    }

    private void constType(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 21: {
                symtabEntry.type(this.octetType());
                break;
            }
            case 17: 
            case 27: 
            case 33: {
                symtabEntry.type(this.integerType(symtabEntry));
                break;
            }
            case 4: 
            case 36: {
                symtabEntry.type(this.charType());
                break;
            }
            case 2: {
                symtabEntry.type(this.booleanType());
                break;
            }
            case 8: 
            case 13: {
                symtabEntry.type(this.floatingPtType());
                break;
            }
            case 28: 
            case 37: {
                symtabEntry.type(this.stringType(symtabEntry));
                break;
            }
            case 80: 
            case 124: {
                SymtabEntry symtabEntry2;
                symtabEntry.type(this.scopedName(symtabEntry.container(), this.stFactory.primitiveEntry()));
                if (this.hasArrayInfo(symtabEntry.type())) {
                    ParseException.illegalArray(this.scanner, "const");
                }
                if (!((symtabEntry2 = Parser.typeOf(symtabEntry.type())) instanceof PrimitiveEntry) && !(symtabEntry2 instanceof StringEntry)) {
                    ParseException.wrongType(this.scanner, symtabEntry.fullName(), "primitive or string", this.entryName(symtabEntry.type()));
                    symtabEntry.type(this.qualifiedEntry("long"));
                    break;
                }
                if (!(symtabEntry2 instanceof PrimitiveEntry)) break;
                String string = Parser.overrideName("any");
                if (!symtabEntry2.name().equals(string)) break;
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "primitive or string (except " + string + ')', string);
                symtabEntry.type(this.qualifiedEntry("long"));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{17, 27, 33, 4, 36, 2, 13, 8, 28, 37, 80, 124}, this.token.type);
            }
        }
    }

    private void exceptDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(10);
        ExceptionEntry exceptionEntry = this.stFactory.exceptionEntry(symtabEntry, (IDLID)repIDStack.peek());
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        exceptionEntry.sourceFile(this.scanner.fileEntry());
        exceptionEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        exceptionEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(symtabEntry, exceptionEntry);
        if (!this.token.equals(101)) {
            throw ParseException.syntaxError(this.scanner, 101, this.token.type);
        }
        this.prep.openScope(exceptionEntry);
        this.match(101);
        this.memberList2(exceptionEntry);
        this.prep.closeScope(exceptionEntry);
        this.match(102);
        repIDStack.pop();
    }

    private void nativeDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(19);
        NativeEntry nativeEntry = this.stFactory.nativeEntry(symtabEntry, (IDLID)repIDStack.peek());
        nativeEntry.sourceFile(this.scanner.fileEntry());
        nativeEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        nativeEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(symtabEntry, nativeEntry);
    }

    private void verifyBoolean(SymtabEntry symtabEntry) {
        if (!symtabEntry.name().equals(Parser.overrideName("boolean"))) {
            ParseException.wrongExprType(this.scanner, symtabEntry.name(), "boolean");
        }
    }

    private boolean hasArrayInfo(SymtabEntry symtabEntry) {
        while (symtabEntry instanceof TypedefEntry) {
            if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
                return true;
            }
            symtabEntry = symtabEntry.type();
        }
        return false;
    }

    private boolean isForward(SymtabEntry symtabEntry) {
        return symtabEntry instanceof ForwardEntry;
    }

    private boolean isInterface(SymtabEntry symtabEntry) {
        return symtabEntry instanceof InterfaceEntry || symtabEntry instanceof ForwardEntry && !(symtabEntry instanceof ForwardValueEntry);
    }

    private boolean isInterfaceOnly(SymtabEntry symtabEntry) {
        return symtabEntry instanceof InterfaceEntry;
    }

    private boolean isValue(SymtabEntry symtabEntry) {
        return symtabEntry instanceof ValueEntry;
    }

    private final boolean isConstTypeSpec(Token token) {
        return token.type == 29 || token.type == 34 || token.type == 9;
    }

    private void declarator(TypedefEntry typedefEntry) throws IOException, ParseException {
        typedefEntry.name(this.token.name);
        if (!this.token.comment.text().equals("")) {
            typedefEntry.comment(this.token.comment);
        }
        this.match(80);
        while (this.token.type == 112) {
            this.fixedArraySize(typedefEntry);
        }
    }

    private void fixedArraySize(TypedefEntry typedefEntry) throws IOException, ParseException {
        this.match(112);
        ConstEntry constEntry = this.stFactory.constEntry(typedefEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.type(this.qualifiedEntry("long"));
        Expression expression = this.positiveIntConst(constEntry);
        typedefEntry.addArrayInfo(expression);
        this.verifyConstType(expression, this.qualifiedEntry("long"));
        this.match(113);
    }

    private long caseCount(UnionEntry unionEntry) {
        long l = 0L;
        Enumeration enumeration = unionEntry.branches().elements();
        while (enumeration.hasMoreElements()) {
            UnionBranch unionBranch = (UnionBranch)enumeration.nextElement();
            l += (long)unionBranch.labels.size();
            if (!unionBranch.isDefault) continue;
            ++l;
        }
        return l;
    }

    private void caseProd(UnionEntry unionEntry) throws IOException, ParseException {
        UnionBranch unionBranch = new UnionBranch();
        unionEntry.addBranch(unionBranch);
        this.caseLabel(unionEntry, unionBranch);
        while (this.token.equals(3) || this.token.equals(7)) {
            this.caseLabel(unionEntry, unionBranch);
        }
        this.elementSpec(unionEntry, unionBranch);
        this.match(100);
    }

    private void switchBody(UnionEntry unionEntry) throws IOException, ParseException {
        this.caseProd(unionEntry);
        while (!this.token.equals(102)) {
            this.caseProd(unionEntry);
        }
        unionEntry.defaultBranch(this.defaultBranch == null ? null : this.defaultBranch.typedef);
        this.defaultBranch = null;
    }

    private void verifyUnion(UnionEntry unionEntry) {
        if (unionEntry.typeName().equals(Parser.overrideName("boolean"))) {
            if (this.caseCount(unionEntry) > 2L) {
                ParseException.noDefault(this.scanner);
            }
        } else if (unionEntry.type() instanceof EnumEntry && this.caseCount(unionEntry) > (long)((EnumEntry)unionEntry.type()).elements().size()) {
            ParseException.noDefault(this.scanner);
        }
    }

    private void initDcl(ValueEntry valueEntry) throws IOException, ParseException {
        MethodEntry methodEntry = this.stFactory.methodEntry(valueEntry, (IDLID)repIDStack.peek());
        methodEntry.sourceFile(this.scanner.fileEntry());
        methodEntry.comment(this.token.comment);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        if (this.token.type == 38) {
            methodEntry.name("init");
            this.match(38);
            this.match(108);
        } else {
            this.match(47);
            methodEntry.name(this.token.name);
            if (this.token.type == 81) {
                this.match(81);
            } else {
                this.match(80);
                this.match(108);
            }
        }
        if (this.token.type != 109) {
            while (true) {
                this.initParamDcl(methodEntry);
                if (this.token.type == 109) break;
                this.match(104);
            }
        }
        valueEntry.initializersAddElement(methodEntry, this.scanner);
        this.match(109);
        this.match(100);
        repIDStack.pop();
    }

    private void valueDcl(ValueEntry valueEntry) throws IOException, ParseException {
        if (this.token.type == 103) {
            this.valueInheritanceSpec(valueEntry);
        } else if (!valueEntry.isAbstract()) {
            SymtabEntry symtabEntry = this.qualifiedEntry("ValueBase");
            SymtabEntry symtabEntry2 = Parser.typeOf(symtabEntry);
            if (symtabEntry != null) {
                if (!this.isValue(symtabEntry2)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("ValueBase"), "value", symtabEntry.typeName());
                } else {
                    valueEntry.derivedFromAddElement(symtabEntry2, false, this.scanner);
                }
            }
        }
        if (this.token.type == 43) {
            this.valueSupportsSpec(valueEntry);
        }
        this.prep.openScope(valueEntry);
        this.match(101);
        while (this.token.type != 102) {
            this.valueElement(valueEntry);
        }
        this.prep.closeScope(valueEntry);
        this.match(102);
    }

    private void valueElement(ValueEntry valueEntry) throws IOException, ParseException {
        if (valueEntry.isAbstract()) {
            this.export(valueEntry);
        } else {
            switch (this.token.type) {
                case 41: 
                case 42: {
                    this.valueStateMember(valueEntry);
                    break;
                }
                case 38: 
                case 47: {
                    this.initDcl(valueEntry);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 45: 
                case 80: 
                case 124: {
                    this.export(valueEntry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{41, 42, 38, 45, 32, 29, 34, 9, 5, 10, 25, 1, 22, 13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 35}, this.token.type);
                }
            }
        }
    }

    private void valueInheritanceSpec(ValueEntry valueEntry) throws IOException, ParseException {
        boolean bl;
        this.match(103);
        boolean bl2 = bl = this.token.type == 44;
        if (bl) {
            this.match(44);
        }
        while (true) {
            SymtabEntry symtabEntry;
            SymtabEntry symtabEntry2;
            if (this.isValue(symtabEntry2 = Parser.typeOf(symtabEntry = this.scopedName(valueEntry.container(), this.stFactory.valueEntry()))) && !(symtabEntry2 instanceof ValueBoxEntry)) {
                valueEntry.derivedFromAddElement(symtabEntry2, bl, this.scanner);
            } else if (this.isForward(symtabEntry2)) {
                ParseException.illegalForwardInheritance(this.scanner, valueEntry.fullName(), symtabEntry.fullName());
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "value", this.entryName(symtabEntry));
            }
            if (this.token.type != 104) break;
            this.match(104);
            bl = false;
        }
    }

    private void valueStateMember(ValueEntry valueEntry) throws IOException, ParseException {
        boolean bl;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(valueEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        boolean bl2 = bl = this.token.type == 42;
        if (bl) {
            this.match(42);
        } else {
            this.match(41);
        }
        boolean bl3 = this.token.type == 29 || this.token.type == 34 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(typedefEntry));
        this.addDeclarators(valueEntry, typedefEntry, bl);
        if (bl3) {
            valueEntry.addContained(typedefEntry);
        }
        this.match(100);
    }

    private void valueSupportsSpec(ValueEntry valueEntry) throws IOException, ParseException {
        this.match(43);
        while (true) {
            SymtabEntry symtabEntry;
            SymtabEntry symtabEntry2;
            if (this.isInterface(symtabEntry2 = Parser.typeOf(symtabEntry = this.scopedName(valueEntry.container(), this.stFactory.interfaceEntry())))) {
                valueEntry.derivedFromAddElement(symtabEntry2, this.scanner);
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "interface", this.entryName(symtabEntry));
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private Expression stringLiteral() throws IOException, ParseException {
        boolean bl = this.token.isWide();
        String string = "";
        do {
            string = string + this.token.name;
            this.match(204);
        } while (this.token.equals(204));
        Terminal terminal = this.exprFactory.terminal(string, bl);
        terminal.rep('\"' + string + '\"');
        return terminal;
    }

    private Terminal booleanLiteral() throws IOException, ParseException {
        Boolean bl = null;
        if (this.token.name.equals("TRUE")) {
            bl = new Boolean(true);
        } else if (this.token.name.equals("FALSE")) {
            bl = new Boolean(false);
        } else {
            ParseException.invalidConst(this.scanner, this.token.name);
            bl = new Boolean(false);
        }
        String string = this.token.name;
        this.match(200);
        return this.exprFactory.terminal(string, bl);
    }

    private String signedInt() throws IOException, ParseException {
        String string = "long";
        if (this.token.type == 17) {
            this.match(17);
            if (this.token.type == 17) {
                string = "long long";
                this.match(17);
            }
        } else if (this.token.type == 27) {
            string = "short";
            this.match(27);
        } else {
            ParseException.syntaxError(this.scanner, new int[]{17, 27}, this.token.type);
        }
        return string;
    }

    void parse(String string) throws IOException {
        IncludeEntry includeEntry = this.stFactory.includeEntry();
        includeEntry.name('\"' + string + '\"');
        try {
            includeEntry.absFilename(Util.getAbsolutePath(string, this.paths));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.scanner = new Scanner(includeEntry, this.keywords, this.verbose, this.emitAll, this.corbaLevel, this.arguments.scannerDebugFlag);
        this.topLevelModule.sourceFile(includeEntry);
        this.token = new Token(0);
        this.tokenHistory.insert(this.token);
        try {
            this.match(0);
            if (this.token.equals(999)) {
                ParseException.nothing(string);
            } else {
                this.specification(this.topLevelModule);
            }
        }
        catch (ParseException parseException) {
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void attrDcl2(InterfaceEntry interfaceEntry, AttributeEntry attributeEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            AttributeEntry attributeEntry2 = (AttributeEntry)attributeEntry.clone();
            attributeEntry2.name(this.token.name);
            if (!this.token.comment.text().equals("")) {
                attributeEntry2.comment(this.token.comment);
            }
            interfaceEntry.methodsAddElement(attributeEntry2, this.scanner);
            this.pigeonholeMethod(interfaceEntry, attributeEntry2);
            this.match(80);
        }
    }

    private EnumEntry enumType(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(9);
        EnumEntry enumEntry = this.newEnumEntry(symtabEntry);
        enumEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        enumEntry.name(this.token.name);
        this.match(80);
        this.prep.openScope(enumEntry);
        this.match(101);
        if (this.isntInStringList(enumEntry.elements(), this.token.name)) {
            enumEntry.addElement(this.token.name);
            SymtabEntry symtabEntry2 = new SymtabEntry(symtabEntry, (IDLID)repIDStack.peek());
            if (symtabEntry2.module().equals("")) {
                symtabEntry2.module(symtabEntry2.name());
            } else if (!symtabEntry2.name().equals("")) {
                symtabEntry2.module(symtabEntry2.module() + "/" + symtabEntry2.name());
            }
            symtabEntry2.name(this.token.name);
            this.pigeonhole(enumEntry.container(), symtabEntry2);
        }
        this.match(80);
        this.enumType2(enumEntry);
        this.prep.closeScope(enumEntry);
        this.match(102);
        return enumEntry;
    }

    private EnumEntry newEnumEntry(SymtabEntry symtabEntry) {
        EnumEntry enumEntry = this.stFactory.enumEntry(symtabEntry, (IDLID)repIDStack.peek());
        enumEntry.sourceFile(this.scanner.fileEntry());
        enumEntry.name(this.token.name);
        this.pigeonhole(symtabEntry, enumEntry);
        return enumEntry;
    }

    private void pigeonholeMethod(InterfaceEntry interfaceEntry, MethodEntry methodEntry) {
        String string;
        if (methodEntry.name().equals("")) {
            methodEntry.name(unknownNamePrefix + ++this.sequence);
        }
        if (overrideNames.get(string = methodEntry.fullName()) == null) {
            this.addToContainer(interfaceEntry, methodEntry);
            String string2 = string.toLowerCase();
            symbolTable.put(string, methodEntry);
            this.lcSymbolTable.put(string2, methodEntry);
            if (string.startsWith("org/omg/CORBA")) {
                overrideNames.put("CORBA" + string.substring(13), string);
            }
        }
    }

    private ModuleEntry newModule(ModuleEntry moduleEntry) {
        ModuleEntry moduleEntry2 = this.stFactory.moduleEntry(moduleEntry, (IDLID)repIDStack.peek());
        moduleEntry2.sourceFile(this.scanner.fileEntry());
        moduleEntry2.name(this.token.name);
        SymtabEntry symtabEntry = (SymtabEntry)symbolTable.get(moduleEntry2.fullName());
        if (!this.cppModule && symtabEntry != null && symtabEntry instanceof ModuleEntry) {
            moduleEntry2 = (ModuleEntry)symtabEntry;
            if (moduleEntry == this.topLevelModule) {
                if (!moduleEntry2.emit()) {
                    this.addToContainer(moduleEntry, moduleEntry2);
                } else if (!moduleEntry.contained().contains(moduleEntry2)) {
                    this.addToContainer(moduleEntry, moduleEntry2);
                }
            }
        } else {
            this.pigeonhole(moduleEntry, moduleEntry2);
        }
        return moduleEntry2;
    }

    private PrimitiveEntry integerType(SymtabEntry symtabEntry) throws IOException, ParseException {
        String string = "";
        if (this.token.type == 33) {
            this.match(33);
            string = "unsigned ";
        }
        string = string + this.signedInt();
        PrimitiveEntry primitiveEntry = null;
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, string);
        }
        return primitiveEntry;
    }

    private SequenceEntry newSequenceEntry(SymtabEntry symtabEntry) {
        SequenceEntry sequenceEntry = this.stFactory.sequenceEntry(symtabEntry, (IDLID)repIDStack.peek());
        sequenceEntry.sourceFile(this.scanner.fileEntry());
        sequenceEntry.name("");
        this.pigeonhole(symtabEntry, sequenceEntry);
        return sequenceEntry;
    }

    private SequenceEntry sequenceType(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(26);
        this.match(110);
        SequenceEntry sequenceEntry = this.newSequenceEntry(symtabEntry);
        sequenceEntry.type(this.simpleTypeSpec(sequenceEntry));
        if (this.token.type == 104) {
            this.match(104);
            ConstEntry constEntry = this.stFactory.constEntry(sequenceEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.type(this.qualifiedEntry("long"));
            sequenceEntry.maxSize(this.positiveIntConst(constEntry));
            this.verifyConstType(sequenceEntry.maxSize(), this.qualifiedEntry("long"));
        }
        this.match(111);
        return sequenceEntry;
    }

    private StringEntry stringType(SymtabEntry symtabEntry) throws IOException, ParseException {
        StringEntry stringEntry = this.stFactory.stringEntry();
        if (this.token.type == 28) {
            stringEntry.name(Parser.overrideName("string"));
            this.match(28);
        } else {
            stringEntry.name(Parser.overrideName("wstring"));
            this.match(37);
        }
        stringEntry.maxSize(this.stringType2(symtabEntry));
        return stringEntry;
    }

    private StructEntry structType(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(29);
        StructEntry structEntry = this.stFactory.structEntry(symtabEntry, (IDLID)repIDStack.peek());
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        structEntry.sourceFile(this.scanner.fileEntry());
        structEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        structEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(symtabEntry, structEntry);
        if (!this.token.equals(101)) {
            throw ParseException.syntaxError(this.scanner, 101, this.token.type);
        }
        this.prep.openScope(structEntry);
        this.match(101);
        this.member(structEntry);
        this.memberList2(structEntry);
        this.prep.closeScope(structEntry);
        this.match(102);
        repIDStack.pop();
        return structEntry;
    }

    private SymtabEntry baseTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 8: 
            case 13: {
                return this.floatingPtType();
            }
            case 17: 
            case 27: 
            case 33: {
                return this.integerType(symtabEntry);
            }
            case 4: 
            case 36: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 21: {
                return this.octetType();
            }
            case 0: {
                return this.anyType();
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{13, 8, 17, 27, 33, 4, 36, 2, 21, 0}, this.token.type);
    }

    private SymtabEntry constrTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 29: {
                return this.structType(symtabEntry);
            }
            case 34: {
                return this.unionType(symtabEntry);
            }
            case 9: {
                return this.enumType(symtabEntry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{29, 34, 9}, this.token.type);
    }

    private SymtabEntry opTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry2 = null;
        if (this.token.type == 35) {
            this.match(35);
        } else {
            symtabEntry2 = this.paramTypeSpec(symtabEntry);
        }
        return symtabEntry2;
    }

    private SymtabEntry paramTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry2 = null;
        switch (this.token.type) {
            case 0: 
            case 2: 
            case 4: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 27: 
            case 33: 
            case 36: {
                return this.baseTypeSpec(symtabEntry);
            }
            case 28: 
            case 37: {
                return this.stringType(symtabEntry);
            }
            case 20: 
            case 45: 
            case 80: 
            case 124: {
                symtabEntry2 = this.scopedName(symtabEntry.container(), this.stFactory.primitiveEntry());
                if (Parser.typeOf(symtabEntry2) instanceof AttributeEntry) {
                    ParseException.attributeNotType(this.scanner, symtabEntry2.name());
                    break;
                }
                if (!(Parser.typeOf(symtabEntry2) instanceof MethodEntry)) break;
                ParseException.operationNotType(this.scanner, symtabEntry2.name());
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 45}, this.token.type);
            }
        }
        return symtabEntry2;
    }

    private SymtabEntry simpleTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (this.token.type == 80 || this.token.type == 124 || this.token.type == 20 || this.token.type == 45) {
            SymtabEntry symtabEntry2 = symtabEntry instanceof InterfaceEntry || symtabEntry instanceof ModuleEntry || symtabEntry instanceof StructEntry || symtabEntry instanceof UnionEntry ? symtabEntry : symtabEntry.container();
            return this.scopedName(symtabEntry2, this.stFactory.primitiveEntry());
        }
        return this.token.type == 26 || this.token.type == 28 || this.token.type == 37 ? this.templateTypeSpec(symtabEntry) : this.baseTypeSpec(symtabEntry);
    }

    private SymtabEntry templateTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 26: {
                return this.sequenceType(symtabEntry);
            }
            case 28: 
            case 37: {
                return this.stringType(symtabEntry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{26, 28, 37}, this.token.type);
    }

    private SymtabEntry typeDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 32: {
                this.match(32);
                return this.typeDeclarator(symtabEntry);
            }
            case 29: {
                return this.structType(symtabEntry);
            }
            case 34: {
                return this.unionType(symtabEntry);
            }
            case 9: {
                return this.enumType(symtabEntry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9}, this.token.type);
    }

    public static SymtabEntry typeOf(SymtabEntry symtabEntry) {
        while (symtabEntry instanceof TypedefEntry) {
            symtabEntry = symtabEntry.type();
        }
        return symtabEntry;
    }

    private SymtabEntry typeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        return this.token.type == 29 || this.token.type == 34 || this.token.type == 9 ? this.constrTypeSpec(symtabEntry) : this.simpleTypeSpec(symtabEntry);
    }

    private void addToContainer(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        if (symtabEntry instanceof ModuleEntry) {
            ((ModuleEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof InterfaceEntry) {
            ((InterfaceEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof StructEntry) {
            ((StructEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof UnionEntry) {
            ((UnionEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof SequenceEntry) {
            ((SequenceEntry)symtabEntry).addContained(symtabEntry2);
        }
    }

    private void pigeonhole(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        String string;
        if (symtabEntry2.name().equals("")) {
            symtabEntry2.name(unknownNamePrefix + ++this.sequence);
        }
        if (overrideNames.get(string = symtabEntry2.fullName()) == null) {
            this.addToContainer(symtabEntry, symtabEntry2);
            SymtabEntry symtabEntry3 = (SymtabEntry)symbolTable.get(string);
            if (symtabEntry3 == null) {
                String string2 = string.toLowerCase();
                if (this.lcSymbolTable.get(string2) != null) {
                    ParseException.alreadyDeclared(this.scanner, string);
                }
                symbolTable.put(string, symtabEntry2);
                this.lcSymbolTable.put(string2, symtabEntry2);
                if (string.startsWith("org/omg/CORBA")) {
                    overrideNames.put("CORBA" + string.substring(13), string);
                }
            } else if (symtabEntry3 instanceof ForwardEntry && symtabEntry2 instanceof InterfaceEntry) {
                String string3;
                String string4 = ((IDLID)symtabEntry2.repositoryID()).prefix();
                if (string4.equals(string3 = ((IDLID)symtabEntry3.repositoryID()).prefix())) {
                    String string5 = string.toLowerCase();
                    symbolTable.put(string, symtabEntry2);
                    this.lcSymbolTable.put(string5, symtabEntry2);
                } else {
                    ParseException.badRepIDPrefix(this.scanner, string, string3, string4);
                }
            } else if (symtabEntry2 instanceof ForwardEntry && (symtabEntry3 instanceof InterfaceEntry || symtabEntry3 instanceof ForwardEntry)) {
                String string6;
                String string7;
                if (symtabEntry3 instanceof ForwardEntry && symtabEntry2.repositoryID() instanceof IDLID && symtabEntry3.repositoryID() instanceof IDLID && !(string7 = ((IDLID)symtabEntry2.repositoryID()).prefix()).equals(string6 = ((IDLID)symtabEntry3.repositoryID()).prefix())) {
                    ParseException.badRepIDPrefix(this.scanner, string, string6, string7);
                }
            } else if (!(this.cppModule && symtabEntry2 instanceof ModuleEntry && symtabEntry3 instanceof ModuleEntry || string.startsWith("org/omg/CORBA") || string.startsWith("CORBA"))) {
                ParseException.alreadyDeclared(this.scanner, string);
            }
        }
    }

    private SymtabEntry switchTypeSpec(UnionEntry unionEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry = null;
        switch (this.token.type) {
            case 17: 
            case 27: 
            case 33: {
                return this.integerType(unionEntry);
            }
            case 4: 
            case 36: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 9: {
                return this.enumType(unionEntry);
            }
            case 80: 
            case 124: {
                SymtabEntry symtabEntry2;
                symtabEntry = this.scopedName(unionEntry, this.stFactory.primitiveEntry());
                if (this.hasArrayInfo(unionEntry.type())) {
                    ParseException.illegalArray(this.scanner, "switch");
                }
                if (!((symtabEntry2 = Parser.typeOf(symtabEntry)) instanceof EnumEntry) && !(symtabEntry2 instanceof PrimitiveEntry)) {
                    ParseException.wrongType(this.scanner, symtabEntry.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(symtabEntry.type()));
                    break;
                }
                if (!(symtabEntry instanceof PrimitiveEntry)) break;
                SymtabEntry symtabEntry3 = this.qualifiedEntry("octet");
                SymtabEntry symtabEntry4 = this.qualifiedEntry("float");
                SymtabEntry symtabEntry5 = this.qualifiedEntry("double");
                if (symtabEntry2 != symtabEntry3 && symtabEntry2 != symtabEntry4 && symtabEntry2 != symtabEntry5) break;
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(symtabEntry.type()));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{17, 27, 33, 4, 2, 9, 80, 124}, this.token.type);
            }
        }
        return symtabEntry;
    }

    private void verifyCharacter(Expression expression, SymtabEntry symtabEntry) {
        if (!symtabEntry.name().equals(Parser.overrideName("char")) && !symtabEntry.name().equals(Parser.overrideName("wchar")) || !symtabEntry.name().equals(expression.type())) {
            ParseException.wrongExprType(this.scanner, symtabEntry.fullName(), expression.type());
        }
    }

    private void verifyConstType(Expression expression, SymtabEntry symtabEntry) {
        Object object = expression.value();
        if (object instanceof BigInteger) {
            this.verifyIntegral((Number)object, symtabEntry);
        } else if (object instanceof String) {
            this.verifyString(expression, symtabEntry);
        } else if (object instanceof Boolean) {
            this.verifyBoolean(symtabEntry);
        } else if (object instanceof Character) {
            this.verifyCharacter(expression, symtabEntry);
        } else if (object instanceof Float || object instanceof Double) {
            this.verifyFloat((Number)object, symtabEntry);
        } else if (object instanceof ConstEntry) {
            this.verifyConstType(((ConstEntry)object).value(), symtabEntry);
        } else {
            ParseException.wrongExprType(this.scanner, symtabEntry.fullName(), object == null ? "" : object.toString());
        }
    }

    private void verifyString(Expression expression, SymtabEntry symtabEntry) {
        String string = (String)expression.value();
        if (!(symtabEntry instanceof StringEntry)) {
            ParseException.wrongExprType(this.scanner, symtabEntry.fullName(), expression.type());
        } else if (((StringEntry)symtabEntry).maxSize() != null) {
            Expression expression2 = ((StringEntry)symtabEntry).maxSize();
            try {
                Number number = (Number)expression2.value();
                if (string.length() > number.intValue()) {
                    ParseException.stringTooLong(this.scanner, string, number.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!expression.type().equals(symtabEntry.name())) {
            ParseException.wrongExprType(this.scanner, symtabEntry.name(), expression.type());
        }
    }

    private void verifyFloat(Number number, SymtabEntry symtabEntry) {
        boolean bl = false;
        if (symtabEntry.name().equals(Parser.overrideName("float"))) {
            double d;
            double d2 = d = number.doubleValue() < 0.0 ? number.doubleValue() * -1.0 : number.doubleValue();
            if (d != 0.0 && (d > 3.4028234663852886E38 || d < (double)1.4E-45f)) {
                bl = true;
            }
        } else if (!symtabEntry.name().equals(Parser.overrideName("double"))) {
            ParseException.wrongExprType(this.scanner, symtabEntry.fullName(), number instanceof Float ? "float" : "double");
        }
        if (bl) {
            ParseException.outOfRange(this.scanner, number.toString(), symtabEntry.fullName());
        }
    }

    private void verifyIntegral(Number number, SymtabEntry symtabEntry) {
        boolean bl = false;
        if (symtabEntry == this.qualifiedEntry("octet")) {
            if (number.longValue() > 255L || number.longValue() < 0L) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("long")) {
            if (number.longValue() > Integer.MAX_VALUE || number.longValue() < Integer.MIN_VALUE) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("short")) {
            if (number.intValue() > Short.MAX_VALUE || number.intValue() < Short.MIN_VALUE) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned long")) {
            if (number.longValue() > 0xFFFFFFFFL || number.longValue() < 0L) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned short")) {
            if (number.intValue() > 65535 || number.intValue() < 0) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("long long")) {
            BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
            BigInteger bigInteger2 = BigInteger.valueOf(Long.MIN_VALUE);
            if (((BigInteger)number).compareTo(bigInteger) > 0 || ((BigInteger)number).compareTo(bigInteger2) < 0) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned long long")) {
            BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));
            BigInteger bigInteger3 = BigInteger.valueOf(0L);
            if (((BigInteger)number).compareTo(bigInteger) > 0 || ((BigInteger)number).compareTo(bigInteger3) < 0) {
                bl = true;
            }
        } else {
            String string = null;
            string = "long";
            ParseException.wrongExprType(this.scanner, symtabEntry.fullName(), string);
        }
        if (bl) {
            ParseException.outOfRange(this.scanner, number.toString(), symtabEntry.fullName());
        }
    }

    SymtabEntry qualifiedEntry(String string) {
        SymtabEntry symtabEntry = this.recursiveQualifiedEntry(string);
        if (symtabEntry == null) {
            ParseException.undeclaredType(this.scanner, string);
        } else if (symtabEntry instanceof ModuleEntry && !this._isModuleLegalType) {
            ParseException.moduleNotType(this.scanner, string);
            symtabEntry = null;
        }
        return symtabEntry;
    }

    SymtabEntry recursiveQualifiedEntry(String string) {
        SymtabEntry symtabEntry = null;
        if (string != null && !string.equals("void")) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                symtabEntry = this.recursiveQualifiedEntry(string.substring(0, n));
                if (symtabEntry == null) {
                    return null;
                }
                if (symtabEntry instanceof TypedefEntry) {
                    string = Parser.typeOf(symtabEntry).fullName() + string.substring(n);
                }
            }
            if ((symtabEntry = this.searchOverrideNames(string)) == null) {
                symtabEntry = (SymtabEntry)symbolTable.get(string);
            }
            if (symtabEntry == null) {
                symtabEntry = this.searchGlobalInheritanceScope(string);
            }
        }
        return symtabEntry;
    }

    SymtabEntry searchGlobalInheritanceScope(String string) {
        int n = string.lastIndexOf(47);
        SymtabEntry symtabEntry = null;
        if (n >= 0) {
            String string2 = string.substring(0, n);
            symtabEntry = (SymtabEntry)symbolTable.get(string2);
            symtabEntry = symtabEntry instanceof InterfaceEntry ? this.searchLocalInheritanceScope(string.substring(n + 1), symtabEntry) : null;
        }
        return symtabEntry;
    }

    SymtabEntry searchOverrideNames(String string) {
        String string2 = (String)overrideNames.get(string);
        return string2 != null ? (SymtabEntry)symbolTable.get(string2) : null;
    }

    private boolean isntInList(Vector vector, SymtabEntry symtabEntry) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry2 = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry != symtabEntry2) continue;
            ParseException.alreadyDeclared(this.scanner, symtabEntry.fullName());
            bl = false;
            break;
        }
        return bl;
    }

    private TypedefEntry typeDeclarator(SymtabEntry symtabEntry) throws IOException, ParseException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(symtabEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        typedefEntry.type(this.typeSpec(symtabEntry));
        Vector vector = new Vector();
        this.declarators(typedefEntry, vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.pigeonhole(symtabEntry, (SymtabEntry)enumeration.nextElement());
        }
        return typedefEntry;
    }

    private void addDeclarators(ValueEntry valueEntry, TypedefEntry typedefEntry, boolean bl) throws IOException, ParseException {
        int n = bl ? 2 : 0;
        try {
            Vector vector = new Vector();
            this.declarators(typedefEntry, vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                valueEntry.addStateElement(new InterfaceState(n, (TypedefEntry)enumeration.nextElement()), this.scanner);
            }
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void caseLabel(UnionEntry unionEntry, UnionBranch unionBranch) throws IOException, ParseException {
        if (this.token.type == 3) {
            Expression expression;
            this.match(3);
            ConstEntry constEntry = this.stFactory.constEntry(unionEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.type(unionEntry);
            SymtabEntry symtabEntry = Parser.typeOf(unionEntry.type());
            if (symtabEntry instanceof EnumEntry) {
                expression = this.matchEnum((EnumEntry)symtabEntry);
            } else {
                expression = this.constExp(constEntry);
                this.verifyConstType(expression, symtabEntry);
            }
            if (unionEntry.has(expression)) {
                ParseException.branchLabel(this.scanner, expression.rep());
            }
            unionBranch.labels.addElement(expression);
            this.match(103);
        } else if (this.token.type == 7) {
            this.match(7);
            this.match(103);
            if (unionEntry.defaultBranch() != null) {
                ParseException.alreadyDefaulted(this.scanner);
            }
            unionBranch.isDefault = true;
            this.defaultBranch = unionBranch;
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{3, 7}, this.token.type);
        }
    }

    private void elementSpec(UnionEntry unionEntry, UnionBranch unionBranch) throws IOException, ParseException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(unionEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        typedefEntry.type(this.typeSpec(unionEntry));
        if (typedefEntry.type() == unionEntry) {
            throw ParseException.recursive(this.scanner, unionEntry.fullName(), this.token.name == null ? "" : this.token.name);
        }
        if (Parser.typeOf(typedefEntry) instanceof ExceptionEntry) {
            throw ParseException.illegalException(this.scanner, this.entryName(unionEntry));
        }
        this.declarator(typedefEntry);
        unionBranch.typedef = typedefEntry;
        if (unionEntry.has(typedefEntry)) {
            ParseException.branchName(this.scanner, typedefEntry.name());
        }
    }

    private UnionEntry unionType(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(34);
        UnionEntry unionEntry = this.stFactory.unionEntry(symtabEntry, (IDLID)repIDStack.peek());
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        unionEntry.sourceFile(this.scanner.fileEntry());
        unionEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        unionEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(symtabEntry, unionEntry);
        this.match(30);
        this.match(108);
        unionEntry.type(this.switchTypeSpec(unionEntry));
        this.match(109);
        this.prep.openScope(unionEntry);
        this.match(101);
        this.switchBody(unionEntry);
        this.verifyUnion(unionEntry);
        this.prep.closeScope(unionEntry);
        this.match(102);
        repIDStack.pop();
        return unionEntry;
    }

    private Expression matchEnum(EnumEntry enumEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry = this.scopedName(enumEntry.container(), new SymtabEntry());
        return this.exprFactory.terminal(symtabEntry.name(), false);
    }

    Expression constExp(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = this.orExpr(null, symtabEntry);
        if (expression.type() == null) {
            expression.type(symtabEntry.typeName());
        }
        try {
            expression.evaluate();
            if (expression instanceof Terminal && expression.value() instanceof BigInteger && (Parser.overrideName(expression.type()).equals("float") || Parser.overrideName(expression.type()).indexOf("double") >= 0)) {
                expression.value(new Double(((BigInteger)expression.value()).doubleValue()));
            }
        }
        catch (EvaluationException evaluationException) {
            ParseException.evaluationError(this.scanner, evaluationException.toString());
        }
        return expression;
    }

    Expression literal(SymtabEntry symtabEntry) throws IOException, ParseException {
        String string = this.token.name;
        Expression expression = null;
        switch (this.token.type) {
            case 202: {
                this.match(202);
                try {
                    expression = this.exprFactory.terminal(string, this.parseString(string));
                    expression.type(symtabEntry.typeName());
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException.notANumber(this.scanner, string);
                    expression = this.exprFactory.terminal("0", BigInteger.valueOf(0L));
                }
                break;
            }
            case 201: {
                boolean bl = this.token.isWide();
                this.match(201);
                expression = this.exprFactory.terminal("'" + string.substring(1) + "'", new Character(string.charAt(0)), bl);
                break;
            }
            case 203: {
                this.match(203);
                try {
                    expression = this.exprFactory.terminal(string, new Double(string));
                    expression.type(symtabEntry.typeName());
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException.notANumber(this.scanner, string);
                }
                break;
            }
            case 200: {
                expression = this.booleanLiteral();
                break;
            }
            case 204: {
                expression = this.stringLiteral();
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, 205, this.token.type);
            }
        }
        return expression;
    }

    private Expression positiveIntConst(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = this.constExp(symtabEntry);
        Object object = expression.value();
        while (object instanceof ConstEntry) {
            object = ((ConstEntry)object).value().value();
        }
        if (!(object instanceof Number) || object instanceof Float || object instanceof Double) {
            ParseException.notPositiveInt(this.scanner, expression.rep());
            expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        } else if (((BigInteger)object).compareTo(BigInteger.valueOf(0L)) <= 0) {
            ParseException.notPositiveInt(this.scanner, object.toString());
            expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        }
        return expression;
    }

    private Expression primaryExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = null;
        if (this.parsingConditionalExpr) {
            this.prep.token = this.token;
            expression = this.prep.primaryExpr(symtabEntry);
            this.token = this.prep.token;
        } else {
            switch (this.token.type) {
                case 80: 
                case 124: {
                    ConstEntry constEntry = this.stFactory.constEntry();
                    constEntry.value(this.exprFactory.terminal("1", BigInteger.valueOf(1L)));
                    SymtabEntry symtabEntry2 = this.scopedName(symtabEntry.container(), constEntry);
                    if (!(symtabEntry2 instanceof ConstEntry)) {
                        ParseException.invalidConst(this.scanner, symtabEntry2.fullName());
                        expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
                        break;
                    }
                    expression = this.exprFactory.terminal((ConstEntry)symtabEntry2);
                    break;
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    expression = this.literal(symtabEntry);
                    break;
                }
                case 108: {
                    this.match(108);
                    expression = this.constExp(symtabEntry);
                    this.match(109);
                    expression.rep('(' + expression.rep() + ')');
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{80, 124, 205, 108}, this.token.type);
                }
            }
        }
        return expression;
    }

    private Expression stringType2(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (this.token.type == 110) {
            this.match(110);
            ConstEntry constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.type(this.qualifiedEntry("long"));
            Expression expression = this.positiveIntConst(constEntry);
            this.verifyConstType(expression, this.qualifiedEntry("long"));
            this.match(111);
            return expression;
        }
        return null;
    }

    private Expression unaryExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (this.token.equals(106)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Positive positive = this.exprFactory.positive(expression);
            positive.type(symtabEntry.typeName());
            positive.rep('+' + expression.rep());
            return positive;
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Negative negative = this.exprFactory.negative(expression);
            negative.type(symtabEntry.typeName());
            negative.rep('-' + expression.rep());
            return negative;
        }
        if (this.token.equals(123)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Not not = this.exprFactory.not(expression);
            not.type(symtabEntry.typeName());
            not.rep('~' + expression.rep());
            return not;
        }
        return this.primaryExpr(symtabEntry);
    }

    private void valueBox(ModuleEntry moduleEntry, String string) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueBoxEntry valueBoxEntry = this.stFactory.valueBoxEntry(moduleEntry, (IDLID)repIDStack.peek());
        valueBoxEntry.sourceFile(this.scanner.fileEntry());
        valueBoxEntry.name(string);
        valueBoxEntry.comment(this.tokenHistory.lookBack((int)2).comment);
        SymtabEntry symtabEntry = (SymtabEntry)symbolTable.get(valueBoxEntry.fullName());
        if (symtabEntry != null && symtabEntry instanceof ForwardEntry) {
            ParseException.forwardedValueBox(this.scanner, valueBoxEntry.fullName());
        }
        this.pigeonhole(moduleEntry, valueBoxEntry);
        ((IDLID)repIDStack.peek()).appendToName(string);
        this.currentModule = valueBoxEntry;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(valueBoxEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        boolean bl = this.token.type == 29 || this.token.type == 34 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(typedefEntry));
        if (typedefEntry.type() instanceof ValueBoxEntry) {
            ParseException.nestedValueBox(this.scanner);
        }
        valueBoxEntry.addStateElement(new InterfaceState(2, typedefEntry), this.scanner);
        if (bl) {
            valueBoxEntry.addContained(typedefEntry);
        }
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    private void interface2(ModuleEntry moduleEntry, String string, int n) throws IOException, ParseException {
        if (this.token.type == 103 || this.token.type == 101) {
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            InterfaceEntry interfaceEntry = this.stFactory.interfaceEntry(moduleEntry, (IDLID)repIDStack.peek());
            interfaceEntry.sourceFile(this.scanner.fileEntry());
            interfaceEntry.name(string);
            interfaceEntry.setInterfaceType(n);
            interfaceEntry.comment(this.tokenHistory.lookBack((int)(interfaceEntry.getInterfaceType() == 0 ? 2 : 3)).comment);
            if (!ForwardEntry.replaceForwardDecl(interfaceEntry)) {
                ParseException.badAbstract(this.scanner, interfaceEntry.fullName());
            }
            this.pigeonhole(moduleEntry, interfaceEntry);
            ((IDLID)repIDStack.peek()).appendToName(string);
            this.currentModule = interfaceEntry;
            this.interfaceDcl(interfaceEntry);
            this.currentModule = moduleEntry;
            repIDStack.pop();
        } else {
            ForwardEntry forwardEntry = this.stFactory.forwardEntry(moduleEntry, (IDLID)repIDStack.peek());
            forwardEntry.sourceFile(this.scanner.fileEntry());
            forwardEntry.name(string);
            forwardEntry.setInterfaceType(n);
            forwardEntry.comment(this.tokenHistory.lookBack((int)(forwardEntry.getInterfaceType() == 0 ? 2 : 3)).comment);
            this.pigeonhole(moduleEntry, forwardEntry);
        }
    }

    private void valueForwardDcl(ModuleEntry moduleEntry, String string, boolean bl) throws IOException, ParseException {
        ForwardValueEntry forwardValueEntry = this.stFactory.forwardValueEntry(moduleEntry, (IDLID)repIDStack.peek());
        forwardValueEntry.sourceFile(this.scanner.fileEntry());
        forwardValueEntry.name(string);
        forwardValueEntry.setInterfaceType(bl ? 1 : 0);
        forwardValueEntry.comment(this.tokenHistory.lookBack((int)(bl ? 3 : 2)).comment);
        this.pigeonhole(moduleEntry, forwardValueEntry);
    }

    private void value2(ModuleEntry moduleEntry, String string, boolean bl, boolean bl2) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueEntry valueEntry = this.stFactory.valueEntry(moduleEntry, (IDLID)repIDStack.peek());
        valueEntry.sourceFile(this.scanner.fileEntry());
        valueEntry.name(string);
        valueEntry.setInterfaceType(bl ? 1 : 0);
        valueEntry.setCustom(bl2);
        valueEntry.comment(this.tokenHistory.lookBack((int)(bl || bl2 ? 3 : 2)).comment);
        if (!ForwardEntry.replaceForwardDecl(valueEntry)) {
            ParseException.badAbstract(this.scanner, valueEntry.fullName());
        }
        this.pigeonhole(moduleEntry, valueEntry);
        ((IDLID)repIDStack.peek()).appendToName(string);
        this.currentModule = valueEntry;
        this.valueDcl(valueEntry);
        valueEntry.tagMethods();
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    String entryName(SymtabEntry symtabEntry) {
        if (symtabEntry instanceof AttributeEntry) {
            return "attribute";
        }
        if (symtabEntry instanceof ConstEntry) {
            return "constant";
        }
        if (symtabEntry instanceof EnumEntry) {
            return "enumeration";
        }
        if (symtabEntry instanceof ExceptionEntry) {
            return "exception";
        }
        if (symtabEntry instanceof ValueBoxEntry) {
            return "value box";
        }
        if (symtabEntry instanceof ForwardValueEntry || symtabEntry instanceof ValueEntry) {
            return "value";
        }
        if (symtabEntry instanceof ForwardEntry || symtabEntry instanceof InterfaceEntry) {
            return "interface";
        }
        if (symtabEntry instanceof MethodEntry) {
            return "method";
        }
        if (symtabEntry instanceof ModuleEntry) {
            return "module";
        }
        if (symtabEntry instanceof ParameterEntry) {
            return "parameter";
        }
        if (symtabEntry instanceof PrimitiveEntry) {
            return "primitive";
        }
        if (symtabEntry instanceof SequenceEntry) {
            return "sequence";
        }
        if (symtabEntry instanceof StringEntry) {
            return "string";
        }
        if (symtabEntry instanceof StructEntry) {
            return "struct";
        }
        if (symtabEntry instanceof TypedefEntry) {
            return "typedef";
        }
        if (symtabEntry instanceof UnionEntry) {
            return "union";
        }
        return "void";
    }

    public static String overrideName(String string) {
        String string2 = (String)overrideNames.get(string);
        return string2 == null ? string : string2;
    }

    private boolean isntInList(Vector vector, String string) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(((SymtabEntry)enumeration.nextElement()).name())) continue;
            ParseException.alreadyDeclared(this.scanner, string);
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isntInStringList(Vector vector, String string) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals((String)enumeration.nextElement())) continue;
            ParseException.alreadyDeclared(this.scanner, string);
            bl = false;
            break;
        }
        return bl;
    }

    private BigInteger parseString(String string) throws NumberFormatException {
        int n = 10;
        if (string.length() > 1 && string.charAt(0) == '0') {
            if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
                string = string.substring(2);
                n = 16;
            } else {
                n = 8;
            }
        }
        return new BigInteger(string, n);
    }

    private void declarators(TypedefEntry typedefEntry, Vector vector) throws IOException, ParseException {
        while (true) {
            TypedefEntry typedefEntry2 = (TypedefEntry)typedefEntry.clone();
            this.declarator(typedefEntry2);
            if (this.isntInList(vector, typedefEntry2.name())) {
                vector.addElement(typedefEntry2);
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    SymtabEntry searchDerivedFrom(String string, InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.derivedFrom().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (!(symtabEntry instanceof InterfaceEntry)) continue;
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)symtabEntry;
            String string2 = interfaceEntry2.fullName() + '/' + string;
            SymtabEntry symtabEntry2 = (SymtabEntry)symbolTable.get(string2);
            if (symtabEntry2 != null) {
                return symtabEntry2;
            }
            symtabEntry2 = this.searchDerivedFrom(string, interfaceEntry2);
            if (symtabEntry2 == null) continue;
            return symtabEntry2;
        }
        return null;
    }

    SymtabEntry scopedName(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) throws IOException, ParseException {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        if (this.token.type == 124) {
            bl = true;
        } else if (this.token.type == 20) {
            string = "Object";
            this.match(20);
        } else if (this.token.type == 45) {
            string = "ValueBase";
            this.match(45);
        } else {
            string = this.token.name;
            this.match(80);
        }
        while (this.token.type == 124) {
            this.match(124);
            bl2 = true;
            string = string != null ? string + '/' + this.token.name : this.token.name;
            this.match(80);
        }
        SymtabEntry symtabEntry3 = null;
        symtabEntry3 = bl ? this.qualifiedEntry(string) : (bl2 ? this.partlyQualifiedEntry(string, symtabEntry) : this.unqualifiedEntry(string, symtabEntry));
        if (symtabEntry3 == null) {
            symtabEntry3 = symtabEntry2;
            symtabEntry3.name(string);
        }
        return symtabEntry3;
    }

    SymtabEntry partlyQualifiedEntry(String string, SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = null;
        if (string != null) {
            int n = string.lastIndexOf(47);
            symtabEntry2 = this.recursivePQEntry(string.substring(0, n), symtabEntry);
            if (symtabEntry2 instanceof TypedefEntry) {
                string = Parser.typeOf(symtabEntry2).fullName() + string.substring(n);
            }
            if (symtabEntry != null) {
                symtabEntry2 = this.searchModuleScope(string.substring(0, string.lastIndexOf(47)), symtabEntry);
            }
            symtabEntry2 = symtabEntry2 == null ? this.qualifiedEntry(string) : this.qualifiedEntry(symtabEntry2.fullName() + string.substring(string.lastIndexOf(47)));
        }
        return symtabEntry2;
    }

    SymtabEntry recursivePQEntry(String string, SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = null;
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                symtabEntry2 = this.searchModuleScope(string, symtabEntry);
            } else {
                symtabEntry2 = this.recursivePQEntry(string.substring(0, n), symtabEntry);
                if (symtabEntry2 == null) {
                    return null;
                }
                if (symtabEntry2 instanceof TypedefEntry) {
                    string = Parser.typeOf(symtabEntry2).fullName() + string.substring(n);
                }
                if (symtabEntry != null) {
                    symtabEntry2 = this.searchModuleScope(string.substring(0, string.lastIndexOf(47)), symtabEntry);
                }
                if (symtabEntry2 == null) {
                    this.recursiveQualifiedEntry(string);
                } else {
                    symtabEntry2 = this.recursiveQualifiedEntry(symtabEntry2.fullName() + string.substring(string.lastIndexOf(47)));
                }
            }
        }
        return symtabEntry2;
    }

    SymtabEntry searchLocalInheritanceScope(String string, SymtabEntry symtabEntry) {
        return symtabEntry instanceof InterfaceEntry ? this.searchDerivedFrom(string, (InterfaceEntry)symtabEntry) : null;
    }

    SymtabEntry searchModuleScope(String string, SymtabEntry symtabEntry) {
        String string2 = symtabEntry.fullName();
        String string3 = string2 + '/' + string;
        SymtabEntry symtabEntry2 = (SymtabEntry)symbolTable.get(string3);
        while (symtabEntry2 == null && !string2.equals("")) {
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                string2 = "";
                continue;
            }
            string2 = string2.substring(0, n);
            string3 = string2 + '/' + string;
            symtabEntry2 = (SymtabEntry)symbolTable.get(string3);
        }
        return symtabEntry2 == null ? (SymtabEntry)symbolTable.get(string) : symtabEntry2;
    }

    SymtabEntry unqualifiedEntry(String string, SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = this.unqualifiedEntryWMod(string, symtabEntry);
        if (symtabEntry2 instanceof ModuleEntry && !this._isModuleLegalType) {
            ParseException.moduleNotType(this.scanner, string);
            symtabEntry2 = null;
        }
        return symtabEntry2;
    }

    SymtabEntry unqualifiedEntryWMod(String string, SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = null;
        if (string != null && !string.equals("void")) {
            symtabEntry2 = (SymtabEntry)symbolTable.get(symtabEntry.fullName() + '/' + string);
            if (symtabEntry2 == null) {
                symtabEntry2 = this.searchLocalInheritanceScope(string, symtabEntry);
            }
            if (symtabEntry2 == null) {
                symtabEntry2 = this.searchOverrideNames(string);
            }
            if (symtabEntry2 == null && symtabEntry != null) {
                symtabEntry2 = this.searchModuleScope(string, symtabEntry);
            }
        }
        if (symtabEntry2 == null) {
            ParseException.undeclaredType(this.scanner, string);
        }
        return symtabEntry2;
    }

    private Expression addExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.multExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.multExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(106)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.plus(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " + ");
            return this.addExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.minus(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " - ");
            return this.addExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression andExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.shiftExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.shiftExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(119)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.and(expression, null);
            binaryExpr.rep(expression.rep() + " & ");
            binaryExpr.type(symtabEntry.typeName());
            return this.andExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression multExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.unaryExpr(symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.unaryExpr(symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(120)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.times(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " * ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(121)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.divide(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " / ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(122)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.modulo(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " % ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression orExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.xorExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.xorExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(117)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.or(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " | ");
            return this.orExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression shiftExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.addExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.addExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(125)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.shiftLeft(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " << ");
            return this.shiftExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(126)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.shiftRight(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " >> ");
            return this.shiftExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression xorExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.andExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.andExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(118)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.xor(expression, null);
            binaryExpr.rep(expression.rep() + " ^ ");
            binaryExpr.type(symtabEntry.typeName());
            return this.xorExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    Parser(Preprocessor preprocessor, Arguments arguments, Hashtable hashtable, Hashtable hashtable2, SymtabFactory symtabFactory, ExprFactory exprFactory, String[] stringArray) {
        this.arguments = arguments;
        this.noWarn = arguments.noWarn;
        this.corbaLevel = arguments.corbaLevel;
        this.paths = arguments.includePaths;
        this.symbols = arguments.definedSymbols;
        this.verbose = arguments.verbose;
        this.emitAll = arguments.emitAll;
        this.cppModule = arguments.cppModule;
        overrideNames = hashtable == null ? new Hashtable() : hashtable;
        symbolTable = hashtable2 == null ? new Hashtable() : hashtable2;
        this.keywords = stringArray == null ? new String[]{} : stringArray;
        this.stFactory = symtabFactory;
        this.exprFactory = exprFactory;
        this.topLevelModule = new ModuleEntry();
        this.currentModule = this.topLevelModule;
        this.prep = preprocessor;
        repIDStack.push(new IDLID());
        this.addPrimEntries();
    }
}

