/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Lines;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java2d.AnimatingSurface;

public class LineAnim
extends AnimatingSurface {
    private static int[] caps = new int[]{0, 2, 1};
    private static int[] joins = new int[]{0, 2, 1};
    private static Color[] colors = new Color[]{Color.gray, Color.pink, Color.lightGray};
    private static BasicStroke bs1 = new BasicStroke(1.0f);
    private static final int CLOCKWISE = 0;
    private static final int COUNTERCW = 1;
    private Line2D[] lines = new Line2D[3];
    private int[] rAmt = new int[this.lines.length];
    private int[] direction = new int[this.lines.length];
    private int[] speed = new int[this.lines.length];
    private BasicStroke[] strokes = new BasicStroke[this.lines.length];
    private GeneralPath path;
    private Point2D[] pts;
    private float size;
    private Ellipse2D ellipse = new Ellipse2D.Double();

    public LineAnim() {
        this.setBackground(Color.white);
    }

    public void reset(int n, int n2) {
        this.size = n > n2 ? (float)n2 / 6.0f : (float)n / 6.0f;
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new Line2D.Float(0.0f, 0.0f, this.size, 0.0f);
            this.strokes[i] = new BasicStroke(this.size / 3.0f, caps[i], joins[i]);
            this.rAmt[i] = i * 360 / this.lines.length;
            this.direction[i] = i % 2;
            this.speed[i] = i + 1;
        }
        this.path = new GeneralPath();
        this.path.moveTo(this.size, -this.size / 2.0f);
        this.path.lineTo(this.size + this.size / 2.0f, 0.0f);
        this.path.lineTo(this.size, this.size / 2.0f);
        this.ellipse.setFrame((float)(n / 2) - this.size * 2.0f - 4.5f, (float)(n2 / 2) - this.size * 2.0f - 4.5f, this.size * 4.0f, this.size * 4.0f);
        PathIterator pathIterator = this.ellipse.getPathIterator(null, 0.9);
        Point2D[] point2DArray = new Point2D[100];
        int n3 = 0;
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: 
                case 1: {
                    point2DArray[n3] = new Point2D.Float(fArray[0], fArray[1]);
                    ++n3;
                }
            }
            pathIterator.next();
        }
        this.pts = new Point2D[n3];
        System.arraycopy(point2DArray, 0, this.pts, 0, n3);
    }

    public void step(int n, int n2) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (this.direction[i] == 0) {
                int n3 = i;
                this.rAmt[n3] = this.rAmt[n3] + this.speed[i];
                if (this.rAmt[i] != 360) continue;
                this.rAmt[i] = 0;
                continue;
            }
            int n4 = i;
            this.rAmt[n4] = this.rAmt[n4] - this.speed[i];
            if (this.rAmt[i] != 0) continue;
            this.rAmt[i] = 360;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3;
        this.ellipse.setFrame((float)(n / 2) - this.size, (float)(n2 / 2) - this.size, this.size * 2.0f, this.size * 2.0f);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.ellipse);
        for (n3 = 0; n3 < this.lines.length; ++n3) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n / 2, n2 / 2);
            affineTransform.rotate(Math.toRadians(this.rAmt[n3]));
            graphics2D.setStroke(this.strokes[n3]);
            graphics2D.setColor(colors[n3]);
            graphics2D.draw(affineTransform.createTransformedShape(this.lines[n3]));
            graphics2D.draw(affineTransform.createTransformedShape(this.path));
            int n4 = (int)((double)this.rAmt[n3] / 360.0 * (double)this.pts.length);
            n4 = n4 == this.pts.length ? this.pts.length - 1 : n4;
            this.ellipse.setFrame(this.pts[n4].getX(), this.pts[n4].getY(), 9.0, 9.0);
            graphics2D.fill(this.ellipse);
        }
        graphics2D.setStroke(bs1);
        graphics2D.setColor(Color.black);
        for (n3 = 0; n3 < this.pts.length; ++n3) {
            this.ellipse.setFrame(this.pts[n3].getX(), this.pts[n3].getY(), 9.0, 9.0);
            graphics2D.draw(this.ellipse);
        }
    }

    public static void main(String[] stringArray) {
        LineAnim.createDemoFrame(new LineAnim());
    }
}

