/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java2d.DemoImages;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Intro
extends JPanel {
    static Color black = new Color(20, 20, 20);
    static Color white = new Color(240, 240, 255);
    static Color red = new Color(149, 43, 42);
    static Color blue = new Color(94, 105, 176);
    static Color yellow = new Color(255, 255, 140);
    static Surface surface;
    private ScenesTable scenesTable;
    private boolean doTable;

    public Intro() {
        EmptyBorder emptyBorder = new EmptyBorder(80, 110, 80, 110);
        BevelBorder bevelBorder = new BevelBorder(1);
        this.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.gray);
        this.setToolTipText("click for scene table");
        surface = new Surface();
        this.add(surface);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Intro.this.removeAll();
                if (Intro.this.doTable = !Intro.this.doTable) {
                    Intro.this.setToolTipText("click for animation");
                    surface.stop();
                    if (Intro.this.scenesTable == null) {
                        Intro.this.scenesTable = new ScenesTable();
                    }
                    Intro.this.add(Intro.this.scenesTable);
                } else {
                    Intro.this.setToolTipText("click for scene table");
                    surface.start();
                    Intro.this.add(surface);
                }
                Intro.this.revalidate();
                Intro.this.repaint();
            }
        });
    }

    public void start() {
        if (!this.doTable) {
            surface.start();
        }
    }

    public void stop() {
        if (!this.doTable) {
            surface.stop();
        }
    }

    public static void main(String[] stringArray) {
        final Intro intro = new Intro();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                intro.start();
            }

            public void windowIconified(WindowEvent windowEvent) {
                intro.stop();
            }
        };
        JFrame jFrame = new JFrame("Java2D Demo - Intro");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", intro);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 720;
        int n2 = 510;
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
        intro.start();
    }

    static class Surface
    extends JPanel
    implements Runnable {
        static Surface surf;
        static Image cupanim;
        static Image java_logo;
        static BufferedImage bimg;
        public Director director;
        public int index;
        public long sleepAmt = 30L;
        private Thread thread;

        public Surface() {
            surf = this;
            this.setBackground(black);
            this.setLayout(new BorderLayout());
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$0;
                {
                    this.this$0 = surface;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Surface.access$200(this.this$0) == null) {
                        this.this$0.start();
                    } else {
                        this.this$0.stop();
                    }
                }
            });
            cupanim = DemoImages.getImage("cupanim.gif", this);
            java_logo = DemoImages.getImage("java_logo.png", this);
            this.director = new Director();
        }

        static FontMetrics getMetrics(Font font) {
            return surf.getFontMetrics(font);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            if (bimg == null || bimg.getWidth() != dimension.width || bimg.getHeight() != dimension.height) {
                bimg = this.getGraphicsConfiguration().createCompatibleImage(dimension.width, dimension.height);
                for (int i = this.index + 1; i < this.director.size(); ++i) {
                    ((Scene)this.director.get(i)).reset(dimension.width, dimension.height);
                }
            }
            Scene scene = (Scene)this.director.get(this.index);
            if (scene.index <= scene.length) {
                if (this.thread != null) {
                    scene.step(dimension.width, dimension.height);
                }
                Graphics2D graphics2D = bimg.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                scene.render(dimension.width, dimension.height, graphics2D);
                if (this.thread != null) {
                    ++scene.index;
                }
                graphics2D.dispose();
            }
            graphics.drawImage(bimg, 0, 0, this);
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.setName("Intro");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
            this.notifyAll();
        }

        public void reset() {
            this.index = 0;
            Dimension dimension = this.getSize();
            for (int i = 0; i < this.director.size(); ++i) {
                ((Scene)this.director.get(i)).reset(dimension.width, dimension.height);
            }
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width <= 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            if (this.index == 0) {
                this.reset();
            }
            while (this.thread == thread) {
                Scene scene = (Scene)this.director.get(this.index);
                if (((Boolean)scene.participate).booleanValue()) {
                    this.repaint();
                    try {
                        Thread.sleep(this.sleepAmt);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (scene.index <= scene.length) continue;
                    scene.pause(this.thread);
                    if (++this.index < this.director.size()) continue;
                    this.reset();
                    continue;
                }
                if (++this.index < this.director.size()) continue;
                this.reset();
            }
            this.thread = null;
        }

        static /* synthetic */ Thread access$200(Surface surface) {
            return surface.thread;
        }

        static class Contributors
        implements Part {
            static String[] members = new String[]{"Brian Lichtenwalter", "Jeannette Hung", "Thanh Nguyen", "Jim Graham", "Jerry Evans", "John Raley", "Michael Peirce", "Robert Kim", "Jennifer Ball", "Deborah Adair", "Paul Charlton", "Dmitry Feld", "Gregory Stone", "Richard Blanchard", "Link Perry", "Phil Race", "Vincent Hardy", "Parry Kejriwal", "Doug Felt", "Rekha Rangarajan", "Paula Patel", "Michael Bundschuh", "Joe Warzecha", "Joey Beheler", "Aastha Bhardwaj", "Daniel Rice", "Chris Campbell", "Shinsuke Fukuda", "Dmitri Trembovetski", "Chet Haase", "Jennifer Godinez", "Nicholas Talian", "Raul Vera", "Ankit Patel", "Ilya Bagrak"};
            static Font font = new Font("serif", 0, 26);
            static FontMetrics fm = Surface.getMetrics(font);
            private int beginning;
            private int ending;
            private int nStrs;
            private int strH;
            private int index;
            private int yh;
            private int height;
            private Vector v = new Vector();
            private Vector cast = new Vector(members.length + 3);
            private int counter;
            private int cntMod;
            private GradientPaint gp;

            public Contributors(int n, int n2) {
                this.beginning = n;
                this.ending = n2;
                Arrays.sort(members);
                this.cast.addElement("CONTRIBUTORS");
                this.cast.addElement(" ");
                for (int i = 0; i < members.length; ++i) {
                    this.cast.addElement(members[i]);
                }
                this.cast.addElement(" ");
                this.cast.addElement(" ");
                this.cntMod = (this.ending - this.beginning) / this.cast.size() - 1;
            }

            public void reset(int n, int n2) {
                this.v.clear();
                this.strH = fm.getAscent() + fm.getDescent();
                this.nStrs = (n2 - 40) / this.strH + 1;
                this.height = this.strH * (this.nStrs - 1) + 48;
                this.index = 0;
                this.gp = new GradientPaint(0.0f, n2 / 2, Color.white, 0.0f, n2 + 20, Color.black);
                this.counter = 0;
            }

            public void step(int n, int n2) {
                if (this.counter++ % this.cntMod == 0) {
                    if (this.index < this.cast.size()) {
                        this.v.addElement(this.cast.get(this.index));
                    }
                    if ((this.v.size() == this.nStrs || this.index >= this.cast.size()) && this.v.size() != 0) {
                        this.v.removeElementAt(0);
                    }
                    ++this.index;
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setPaint(this.gp);
                graphics2D.setFont(font);
                double d = this.counter % this.cntMod;
                double d2 = 1.0 - d / (double)this.cntMod;
                d2 = d2 == 1.0 ? 0.0 : d2;
                int n3 = (int)(d2 * (double)this.strH);
                n3 = this.index >= this.cast.size() ? this.yh + n3 : (this.yh = this.height - this.v.size() * this.strH + n3);
                for (int i = 0; i < this.v.size(); ++i) {
                    String string = (String)this.v.get(i);
                    graphics2D.drawString(string, n / 2 - fm.stringWidth(string) / 2, n3 += this.strH);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class Features
        implements Part {
            static final int GRAPHICS = 0;
            static final int TEXT = 1;
            static final int IMAGES = 2;
            static final int COLOR = 3;
            static Font font1 = new Font("serif", 1, 38);
            static Font font2 = new Font("serif", 0, 24);
            static FontMetrics fm1 = Surface.getMetrics(font1);
            static FontMetrics fm2 = Surface.getMetrics(font2);
            static String[][] table = new String[][]{{"Graphics", "Antialiased rendering", "Bezier paths", "Transforms", "Compositing", "Stroking parameters"}, {"Text", "Extended font support", "Advanced text layout", "Dynamic font loading", "AttributeSets for font customization"}, {"Images", "Flexible image layouts", "Extended imaging operations", "   Convolutions, Lookup Tables", "RenderableImage interface"}, {"Color", "ICC profile support", "Color conversion", "Arbitrary color spaces"}};
            private String[] list;
            private int beginning;
            private int ending;
            private int strH;
            private int endIndex;
            private int listIndex;
            private Vector v = new Vector();

            public Features(int n, int n2, int n3) {
                this.list = table[n];
                this.beginning = n2;
                this.ending = n3;
            }

            public void reset(int n, int n2) {
                this.strH = fm2.getAscent() + fm2.getDescent();
                this.endIndex = 1;
                this.listIndex = 0;
                this.v.clear();
                this.v.addElement(this.list[this.listIndex].substring(0, this.endIndex));
            }

            public void step(int n, int n2) {
                if (this.listIndex < this.list.length) {
                    if (++this.endIndex > this.list[this.listIndex].length()) {
                        if (++this.listIndex < this.list.length) {
                            this.endIndex = 1;
                            this.v.addElement(this.list[this.listIndex].substring(0, this.endIndex));
                        }
                    } else {
                        this.v.set(this.listIndex, this.list[this.listIndex].substring(0, this.endIndex));
                    }
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setColor(white);
                graphics2D.setFont(font1);
                graphics2D.drawString((String)this.v.get(0), 90, 85);
                graphics2D.setFont(font2);
                int n3 = 90;
                for (int i = 1; i < this.v.size(); ++i) {
                    graphics2D.drawString((String)this.v.get(i), 120, n3 += this.strH);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class Temp
        implements Part {
            static final int NOANIM = 1;
            static final int RECT = 2;
            static final int RNA = 3;
            static final int IMG = 4;
            static final int INA = 5;
            private int beginning;
            private int ending;
            private float alpha;
            private float aIncr;
            private int type;
            private Rectangle rect1;
            private Rectangle rect2;
            private int x;
            private int y;
            private int xIncr;
            private int yIncr;
            private Image img;

            public Temp(int n, Image image, int n2, int n3) {
                this.type = n;
                this.img = image;
                this.beginning = n2;
                this.ending = n3;
                this.aIncr = 0.9f / (float)(this.ending - this.beginning);
                if ((n & 1) != 0) {
                    this.alpha = 1.0f;
                }
            }

            public void reset(int n, int n2) {
                this.rect1 = new Rectangle(8, 20, n - 20, 30);
                this.rect2 = new Rectangle(20, 8, 30, n2 - 20);
                if ((this.type & 1) == 0) {
                    this.alpha = 0.0f;
                    this.xIncr = n / (this.ending - this.beginning);
                    this.yIncr = n2 / (this.ending - this.beginning);
                    this.x = n + (int)((double)this.xIncr * 1.4);
                    this.y = n2 + (int)((double)this.yIncr * 1.4);
                }
            }

            public void step(int n, int n2) {
                if ((this.type & 1) != 0) {
                    return;
                }
                if ((this.type & 2) != 0) {
                    this.rect1.setLocation(this.x -= this.xIncr, 20);
                    this.rect2.setLocation(20, this.y -= this.yIncr);
                }
                if ((this.type & 4) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                if ((this.type & 2) != 0) {
                    graphics2D.setColor(blue);
                    graphics2D.fill(this.rect1);
                    graphics2D.setColor(red);
                    graphics2D.fill(this.rect2);
                }
                if ((this.type & 4) != 0) {
                    Composite composite = graphics2D.getComposite();
                    if (this.alpha >= 0.0f && this.alpha <= 1.0f) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    }
                    graphics2D.drawImage(this.img, 30, 30, null);
                    graphics2D.setComposite(composite);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class LnE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int ZOOM = 8;
            static final int ZOOMI = 9;
            static final int ZOOMD = 10;
            static final int AC = 32;
            static final int ACI = 33;
            static final int ACD = 34;
            private int beginning;
            private int ending;
            private double rIncr;
            private double rotate;
            private double zIncr;
            private double zoom;
            private Vector pts = new Vector();
            private float alpha;
            private float aIncr;
            private int type;

            public LnE(int n, int n2, int n3) {
                this.type = n;
                this.beginning = n2;
                this.ending = n3;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.aIncr = 0.9f / (float)(this.ending - this.beginning);
                this.zIncr = 2.0 / (double)(this.ending - this.beginning);
                if ((n & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.aIncr = -this.aIncr;
                    this.zIncr = -this.zIncr;
                }
            }

            public void generatePts(int n, int n2, double d) {
                this.pts.clear();
                double d2 = (double)Math.min(n, n2) * d;
                Ellipse2D.Double double_ = new Ellipse2D.Double((double)(n / 2) - d2 / 2.0, (double)(n2 / 2) - d2 / 2.0, d2, d2);
                PathIterator pathIterator = double_.getPathIterator(null, 0.8);
                while (!pathIterator.isDone()) {
                    double[] dArray = new double[6];
                    switch (pathIterator.currentSegment(dArray)) {
                        case 0: 
                        case 1: {
                            this.pts.addElement(new Point2D.Double(dArray[0], dArray[1]));
                        }
                    }
                    pathIterator.next();
                }
            }

            public void reset(int n, int n2) {
                if ((this.type & 2) != 0) {
                    this.rotate = 360.0;
                    this.alpha = 1.0f;
                    this.zoom = 2.0;
                } else {
                    this.alpha = 0.0f;
                    this.rotate = 0.0f;
                    this.zoom = 0.0;
                }
                if ((this.type & 8) == 0) {
                    this.generatePts(n, n2, 0.5);
                }
            }

            public void step(int n, int n2) {
                if ((this.type & 8) != 0) {
                    this.generatePts(n, n2, this.zoom += this.zIncr);
                }
                if ((this.type & 5) != 0 || (this.type & 5) != 0) {
                    this.rotate += this.rIncr;
                }
                if ((this.type & 0x21) != 0 || (this.type & 0x22) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                Cloneable cloneable;
                Composite composite = null;
                if ((this.type & 0x20) != 0 && this.alpha >= 0.0f && this.alpha <= 1.0f) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
                AffineTransform affineTransform = null;
                if ((this.type & 4) != 0) {
                    affineTransform = graphics2D.getTransform();
                    cloneable = new AffineTransform();
                    cloneable.rotate(Math.toRadians(this.rotate), n / 2, n2 / 2);
                    graphics2D.setTransform((AffineTransform)cloneable);
                }
                cloneable = new Point2D.Double(n / 2, n2 / 2);
                graphics2D.setColor(Color.yellow);
                for (int i = 0; i < this.pts.size() - 1; ++i) {
                    graphics2D.draw(new Line2D.Float((Point2D)cloneable, (Point2D)this.pts.get(i)));
                }
                if (affineTransform != null) {
                    graphics2D.setTransform(affineTransform);
                }
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class SiE
        implements Part {
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private double rIncr;
            private double sIncr;
            private double scale;
            private double rotate;
            private int siw;
            private int sih;
            private Vector subs = new Vector(20);
            private Vector pts = new Vector(20);

            public SiE(int n, int n2, int n3, int n4) {
                this.siw = n;
                this.sih = n2;
                this.beginning = n3;
                this.ending = n4;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
            }

            public void reset(int n, int n2) {
                this.scale = 1.0;
                this.rotate = 0.0;
                this.bimg = null;
                this.subs.clear();
                this.pts.clear();
            }

            public void step(int n, int n2) {
                if (this.bimg == null) {
                    int n3 = bimg.getWidth();
                    int n4 = bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    Graphics2D graphics2D = this.bimg.createGraphics();
                    graphics2D.drawImage((Image)bimg, 0, 0, null);
                    for (int i = 0; i < n && this.scale > 0.0; i += this.siw) {
                        int n5 = i + this.siw < n ? this.siw : n - i;
                        for (int j = 0; j < n2; j += this.sih) {
                            int n6 = j + this.sih < n2 ? this.sih : n2 - j;
                            this.subs.addElement(this.bimg.getSubimage(i, j, n5, n6));
                            this.pts.addElement(new Point(i, j));
                        }
                    }
                }
                this.rotate += this.rIncr;
                this.scale -= this.sIncr;
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setColor(blue);
                for (int i = 0; i < this.subs.size() && this.scale > 0.0; ++i) {
                    BufferedImage bufferedImage = (BufferedImage)this.subs.get(i);
                    Point point = (Point)this.pts.get(i);
                    int n3 = bufferedImage.getWidth();
                    int n4 = bufferedImage.getHeight();
                    AffineTransform affineTransform2 = new AffineTransform();
                    affineTransform2.rotate(Math.toRadians(this.rotate), point.x + n3 / 2, point.y + n4 / 2);
                    affineTransform2.translate(point.x, point.y);
                    affineTransform2.scale(this.scale, this.scale);
                    Rectangle rectangle = new Rectangle(0, 0, n3, n4);
                    Shape shape = affineTransform2.createTransformedShape(rectangle);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    double d = (double)(point.x + n3 / 2) - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0);
                    double d2 = (double)(point.y + n4 / 2) - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
                    AffineTransform affineTransform3 = new AffineTransform();
                    affineTransform3.translate(d, d2);
                    affineTransform3.concatenate(affineTransform2);
                    graphics2D.setTransform(affineTransform3);
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.draw(rectangle);
                }
                graphics2D.setTransform(affineTransform);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class DdE
        implements Part {
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Graphics2D big;
            private List list;
            private List xlist;
            private List ylist;
            private int xeNum;
            private int yeNum;
            private int xcSize;
            private int ycSize;
            private int inc;
            private int blocksize;

            public DdE(int n, int n2, int n3) {
                this.beginning = n;
                this.ending = n2;
                this.blocksize = n3;
            }

            private void createShuffledLists() {
                int n;
                int n2 = this.bimg.getWidth();
                int n3 = this.bimg.getHeight();
                Integer[] integerArray = new Integer[n2];
                Integer[] integerArray2 = new Integer[n3];
                Integer[] integerArray3 = new Integer[this.ending - this.beginning + 1];
                for (n = 0; n < integerArray.length; ++n) {
                    integerArray[n] = new Integer(n);
                }
                for (n = 0; n < integerArray2.length; ++n) {
                    integerArray2[n] = new Integer(n);
                }
                for (n = 0; n < integerArray3.length; ++n) {
                    integerArray3[n] = new Integer(n);
                }
                this.xlist = Arrays.asList(integerArray);
                Collections.shuffle(this.xlist);
                this.ylist = Arrays.asList(integerArray2);
                Collections.shuffle(this.ylist);
                this.list = Arrays.asList(integerArray3);
                Collections.shuffle(this.list);
            }

            public void reset(int n, int n2) {
                this.bimg = null;
            }

            public void step(int n, int n2) {
                if (this.bimg == null) {
                    int n3 = bimg.getWidth();
                    int n4 = bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    this.createShuffledLists();
                    this.big = this.bimg.createGraphics();
                    this.big.drawImage((Image)bimg, 0, 0, null);
                    this.xcSize = this.xlist.size() / (this.ending - this.beginning) + 1;
                    this.ycSize = this.ylist.size() / (this.ending - this.beginning) + 1;
                    this.xeNum = 0;
                    this.inc = 0;
                }
                this.xeNum = this.xcSize * (Integer)this.list.get(this.inc);
                this.yeNum = -this.ycSize;
                ++this.inc;
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                this.big.setColor(black);
                for (int i = 0; i <= this.ending - this.beginning; ++i) {
                    this.xeNum = this.xeNum + this.xcSize > this.xlist.size() ? 0 : (this.xeNum += this.xcSize);
                    this.yeNum += this.ycSize;
                    for (int j = this.xeNum; j < this.xeNum + this.xcSize && j < this.xlist.size(); ++j) {
                        for (int k = this.yeNum; k < this.yeNum + this.ycSize && k < this.ylist.size(); ++k) {
                            int n3 = (Integer)this.xlist.get(j);
                            int n4 = (Integer)this.ylist.get(k);
                            if (n3 % this.blocksize != 0 || n4 % this.blocksize != 0) continue;
                            this.big.fillRect(n3, n4, this.blocksize, this.blocksize);
                        }
                    }
                }
                graphics2D.drawImage((Image)this.bimg, 0, 0, null);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class CoE
        implements Part {
            static final int WID = 1;
            static final int HEI = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int RAND = 16;
            static final int ARC = 32;
            private int type;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Shape shape;
            private double zoom;
            private double extent;
            private double zIncr;
            private double eIncr;
            private boolean doRandom;

            public CoE(int n, int n2, int n3) {
                this.type = n;
                this.beginning = n2;
                this.ending = n3;
                this.zIncr = -(2.0 / (double)(this.ending - this.beginning));
                this.eIncr = 360.0 / (double)(this.ending - this.beginning);
                this.doRandom = (n & 0x10) != 0;
            }

            public void reset(int n, int n2) {
                if (this.doRandom) {
                    int n3 = (int)(Math.random() * 5.0);
                    switch (n3) {
                        case 0: {
                            this.type = 4;
                            break;
                        }
                        case 1: {
                            this.type = 8;
                            break;
                        }
                        case 2: {
                            this.type = 9;
                            break;
                        }
                        case 3: {
                            this.type = 10;
                            break;
                        }
                        case 4: {
                            this.type = 32;
                            break;
                        }
                        default: {
                            this.type = 4;
                        }
                    }
                }
                this.shape = null;
                this.bimg = null;
                this.extent = 360.0;
                this.zoom = 2.0;
            }

            public void step(int n, int n2) {
                if (this.bimg == null) {
                    int n3 = bimg.getWidth();
                    int n4 = bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    Graphics2D graphics2D = this.bimg.createGraphics();
                    graphics2D.drawImage((Image)bimg, 0, 0, null);
                }
                double d = (double)Math.min(n, n2) * this.zoom;
                if ((this.type & 4) != 0) {
                    this.shape = new Ellipse2D.Double((double)(n / 2) - d / 2.0, (double)(n2 / 2) - d / 2.0, d, d);
                } else if ((this.type & 0x20) != 0) {
                    this.shape = new Arc2D.Double(-100.0, -100.0, n + 200, n2 + 200, 90.0, this.extent, 2);
                    this.extent -= this.eIncr;
                } else if ((this.type & 8) != 0) {
                    this.shape = (this.type & 1) != 0 ? new Rectangle2D.Double((double)(n / 2) - d / 2.0, 0.0, d, n2) : ((this.type & 2) != 0 ? new Rectangle2D.Double(0.0, (double)(n2 / 2) - d / 2.0, n, d) : new Rectangle2D.Double((double)(n / 2) - d / 2.0, (double)(n2 / 2) - d / 2.0, d, d));
                }
                this.zoom += this.zIncr;
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.clip(this.shape);
                graphics2D.drawImage((Image)this.bimg, 0, 0, null);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class TpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int HAF = 16;
            static final int OI = 5;
            static final int OD = 6;
            static final int RI = 9;
            static final int RD = 10;
            static final int NF = 32;
            private Paint p1;
            private Paint p2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private TexturePaint texture;
            private int type;
            private int size;
            private BufferedImage bimg;
            private Rectangle rect;

            public TpE(int n, Paint paint, Paint paint2, int n2, int n3, int n4) {
                this.type = n;
                this.p1 = paint;
                this.p2 = paint2;
                this.beginning = n3;
                this.ending = n4;
                this.setTextureSize(n2);
            }

            public void setTextureSize(int n) {
                this.size = n;
                this.bimg = new BufferedImage(n, n, 1);
                this.rect = new Rectangle(0, 0, n, n);
            }

            public void reset(int n, int n2) {
                this.incr = (float)this.size / (float)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0) {
                    this.incr /= 2.0f;
                }
                if ((this.type & 2) != 0) {
                    this.index = this.size;
                    if ((this.type & 0x10) != 0) {
                        this.index /= 2.0f;
                    }
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            public void step(int n, int n2) {
                Graphics2D graphics2D = this.bimg.createGraphics();
                graphics2D.setPaint(this.p1);
                graphics2D.fillRect(0, 0, this.size, this.size);
                graphics2D.setPaint(this.p2);
                if ((this.type & 4) != 0) {
                    graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, this.index, this.index));
                } else if ((this.type & 8) != 0) {
                    graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, this.index, this.index));
                }
                this.texture = new TexturePaint(this.bimg, this.rect);
                graphics2D.dispose();
                this.index += this.incr;
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setPaint(this.texture);
                if ((this.type & 0x20) == 0) {
                    graphics2D.fillRect(0, 0, n, n2);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class GpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int CNT = 4;
            static final int WID = 8;
            static final int WI = 9;
            static final int WD = 10;
            static final int HEI = 16;
            static final int HI = 17;
            static final int HD = 18;
            static final int SPL = 36;
            static final int SIW = 45;
            static final int SDW = 46;
            static final int SIH = 53;
            static final int SDH = 54;
            static final int BUR = 68;
            static final int BURI = 69;
            static final int BURD = 70;
            static final int NF = 128;
            private Color c1;
            private Color c2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private Vector rect = new Vector();
            private Vector grad = new Vector();
            private int type;

            public GpE(int n, Color color, Color color2, int n2, int n3) {
                this.type = n;
                this.c1 = color;
                this.c2 = color2;
                this.beginning = n2;
                this.ending = n3;
            }

            public void reset(int n, int n2) {
                this.incr = 1.0f / (float)(this.ending - this.beginning);
                if ((this.type & 4) != 0) {
                    this.incr /= 2.3f;
                }
                if ((this.type & 4) != 0 && (this.type & 1) != 0) {
                    this.index = 0.5f;
                } else if ((this.type & 2) != 0) {
                    this.index = 1.0f;
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            public void step(int n, int n2) {
                this.rect.clear();
                this.grad.clear();
                if ((this.type & 8) != 0) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        f = (float)n * 0.5f;
                        f2 = (float)n * (1.0f - this.index);
                        f3 = (float)n * this.index;
                    } else {
                        f2 = f3 = (f = (float)n * this.index);
                    }
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, f, n2));
                    this.rect.addElement(new Rectangle2D.Float(f, 0.0f, (float)n - f, n2));
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, f2, 0.0f, this.c2));
                    this.grad.addElement(new GradientPaint(f3, 0.0f, this.c2, n, 0.0f, this.c1));
                } else if ((this.type & 0x10) != 0) {
                    float f = 0.0f;
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        f = (float)n2 * 0.5f;
                        f4 = (float)n2 * (1.0f - this.index);
                        f5 = (float)n2 * this.index;
                    } else {
                        f4 = f5 = (f = (float)n2 * this.index);
                    }
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, n, f));
                    this.rect.addElement(new Rectangle2D.Float(0.0f, f, n, (float)n2 - f));
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, f4, this.c2));
                    this.grad.addElement(new GradientPaint(0.0f, f5, this.c2, 0.0f, n2, this.c1));
                } else if ((this.type & 0x44) != 0) {
                    float f = n / 2;
                    float f6 = n2 / 2;
                    this.rect.addElement(new Rectangle2D.Float(0.0f, 0.0f, f, f6));
                    this.rect.addElement(new Rectangle2D.Float(f, 0.0f, f, f6));
                    this.rect.addElement(new Rectangle2D.Float(0.0f, f6, f, f6));
                    this.rect.addElement(new Rectangle2D.Float(f, f6, f, f6));
                    float f7 = (float)n * (1.0f - this.index);
                    float f8 = (float)n * this.index;
                    float f9 = (float)n2 * (1.0f - this.index);
                    float f10 = (float)n2 * this.index;
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, f7, f9, this.c2));
                    this.grad.addElement(new GradientPaint(n, 0.0f, this.c1, f8, f9, this.c2));
                    this.grad.addElement(new GradientPaint(0.0f, n2, this.c1, f7, f10, this.c2));
                    this.grad.addElement(new GradientPaint(n, n2, this.c1, f8, f10, this.c2));
                } else if ((this.type & 0x80) != 0) {
                    float f = (float)n * this.index;
                    float f11 = (float)n2 * this.index;
                    this.grad.addElement(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, f11, this.c2));
                }
                if ((this.type & 1) != 0 || (this.type & 2) != 0) {
                    this.index += this.incr;
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                for (int i = 0; i < this.grad.size(); ++i) {
                    graphics2D.setPaint((GradientPaint)this.grad.get(i));
                    if ((this.type & 0x80) != 0) continue;
                    graphics2D.fill((Rectangle2D)this.rect.get(i));
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class TxE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int SC = 8;
            static final int SCI = 9;
            static final int SCD = 10;
            static final int SCX = 16;
            static final int SCXI = 25;
            static final int SCXD = 26;
            static final int SCY = 32;
            static final int SCYI = 41;
            static final int SCYD = 42;
            static final int AC = 64;
            static final int CLIP = 128;
            static final int NOP = 512;
            private int beginning;
            private int ending;
            private int type;
            private double rIncr;
            private double sIncr;
            private double sx;
            private double sy;
            private double rotate;
            private Shape[] shapes;
            private Shape[] txShapes;
            private int sw;
            private int numRev;
            private Paint paint;

            public TxE(String string, Font font, int n, Paint paint, int n2, int n3) {
                this.type = n;
                this.paint = paint;
                this.beginning = n2;
                this.ending = n3;
                this.setIncrements(2.0);
                char[] cArray = string.toCharArray();
                this.shapes = new Shape[cArray.length];
                this.txShapes = new Shape[cArray.length];
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
                TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
                this.sw = (int)textLayout.getOutline(null).getBounds().getWidth();
                for (int i = 0; i < cArray.length; ++i) {
                    String string2 = String.valueOf(cArray[i]);
                    this.shapes[i] = new TextLayout(string2, font, fontRenderContext).getOutline(null);
                }
            }

            public void setIncrements(double d) {
                this.numRev = (int)d;
                this.rIncr = 360.0 / ((double)(this.ending - this.beginning) / d);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0 || (this.type & 0x20) != 0) {
                    this.sIncr *= 2.0;
                }
                if ((this.type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.sIncr = -this.sIncr;
                }
            }

            public void reset(int n, int n2) {
                if (this.type == 25) {
                    this.sx = -1.0;
                    this.sy = 1.0;
                } else if (this.type == 41) {
                    this.sx = 1.0;
                    this.sy = -1.0;
                } else {
                    this.sy = (this.type & 2) != 0 ? 1.0 : 0.0;
                    this.sx = this.sy;
                }
                this.rotate = 0.0;
            }

            public void step(int n, int n2) {
                float f = n / 2 - this.sw / 2;
                for (int i = 0; i < this.shapes.length; ++i) {
                    AffineTransform affineTransform = new AffineTransform();
                    Rectangle rectangle = this.shapes[i].getBounds();
                    affineTransform.translate(f, (double)(n2 / 2) + ((RectangularShape)rectangle).getHeight() / 2.0);
                    f += (float)((RectangularShape)rectangle).getWidth() + 1.0f;
                    Shape shape = affineTransform.createTransformedShape(this.shapes[i]);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    if ((this.type & 4) != 0) {
                        affineTransform.rotate(Math.toRadians(this.rotate));
                    }
                    if ((this.type & 8) != 0) {
                        affineTransform.scale(this.sx, this.sy);
                    }
                    shape = affineTransform.createTransformedShape(this.shapes[i]);
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    double d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - (rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
                    double d2 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
                    AffineTransform affineTransform2 = new AffineTransform();
                    affineTransform2.translate(d, d2);
                    affineTransform2.concatenate(affineTransform);
                    this.txShapes[i] = affineTransform2.createTransformedShape(this.shapes[i]);
                }
                if (Math.abs(this.rotate) <= (double)(this.numRev * 360)) {
                    this.rotate += this.rIncr;
                    if ((this.type & 0x10) != 0) {
                        this.sx += this.sIncr;
                    } else if ((this.type & 0x20) != 0) {
                        this.sy += this.sIncr;
                    } else {
                        this.sx += this.sIncr;
                        this.sy += this.sIncr;
                    }
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                Composite composite = null;
                if ((this.type & 0x40) != 0 && this.sx > 0.0 && this.sx < 1.0) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.sx));
                }
                GeneralPath generalPath = null;
                if ((this.type & 0x80) != 0) {
                    generalPath = new GeneralPath();
                }
                if (this.paint != null) {
                    graphics2D.setPaint(this.paint);
                }
                for (int i = 0; i < this.txShapes.length; ++i) {
                    if ((this.type & 0x80) != 0) {
                        generalPath.append(this.txShapes[i], false);
                        continue;
                    }
                    graphics2D.fill(this.txShapes[i]);
                }
                if ((this.type & 0x80) != 0) {
                    graphics2D.clip(generalPath);
                }
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
            }

            public int getBegin() {
                return this.beginning;
            }

            public int getEnd() {
                return this.ending;
            }
        }

        static class Scene {
            public Object name;
            public Object participate = new Boolean(true);
            public Object pauseAmt;
            public Vector parts;
            public int index;
            public int length;

            public Scene(Vector vector, Object object, Object object2) {
                this.name = object;
                this.parts = vector;
                this.pauseAmt = object2;
                for (int i = 0; i < vector.size(); ++i) {
                    if (((Part)vector.get(i)).getEnd() <= this.length) continue;
                    this.length = ((Part)vector.get(i)).getEnd();
                }
            }

            public void reset(int n, int n2) {
                this.index = 0;
                for (int i = 0; i < this.parts.size(); ++i) {
                    ((Part)this.parts.get(i)).reset(n, n2);
                }
            }

            public void step(int n, int n2) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.step(n, n2);
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = (Part)this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.render(n, n2, graphics2D);
                }
            }

            public void pause(Thread thread) {
                try {
                    Thread.sleep(Long.parseLong((String)this.pauseAmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
            }
        }

        static class Director
        extends Vector {
            GradientPaint gp = new GradientPaint(0.0f, 40.0f, blue, 38.0f, 2.0f, black);
            Font f1 = new Font("serif", 0, 200);
            Font f2 = new Font("serif", 0, 120);
            Font f3 = new Font("serif", 0, 72);
            Object[][][] parts = new Object[][][]{{{"J  -  scale text on gradient", "0"}, {new GpE(69, black, blue, 0, 20), new TxE("J", this.f1, 9, yellow, 2, 20)}}, {{"2  -  scale & rotate text on gradient", "0"}, {new GpE(69, blue, black, 0, 22), new TxE("2", this.f1, 13, yellow, 2, 22)}}, {{"D  -  scale text on gradient", "0"}, {new GpE(69, black, blue, 0, 20), new TxE("D", this.f1, 9, yellow, 2, 20)}}, {{"Java2D  -  scale & rotate text on gradient", "1000"}, {new GpE(53, blue, black, 0, 40), new TxE("Java2D", this.f2, 13, yellow, 0, 40)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 1)}}, {{"Graphics Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, java_logo, 2, 15), new Temp(7, java_logo, 16, 130), new Features(0, 16, 130)}}, {{"Java2D  -  texture text on gradient", "1000"}, {new GpE(9, blue, black, 0, 20), new GpE(10, blue, black, 21, 40), new TpE(37, black, yellow, 4, 0, 10), new TpE(38, black, yellow, 4, 11, 20), new TpE(53, black, yellow, 5, 21, 40), new TxE("Java2D", this.f2, 0, null, 0, 40)}}, {{"Previous scene random close out", "0"}, {new CoE(16, 0, 20)}}, {{"Text Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, java_logo, 2, 15), new Temp(7, java_logo, 16, 130), new Features(1, 16, 130)}}, {{"Java2D  -  composite text on texture", "1000"}, {new TpE(9, black, this.gp, 40, 0, 20), new TpE(10, black, this.gp, 40, 21, 40), new TpE(9, black, this.gp, 40, 41, 60), new TxE("Java2D", this.f2, 64, yellow, 0, 60)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 4)}}, {{"Imaging Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, java_logo, 2, 15), new Temp(7, java_logo, 16, 130), new Features(2, 16, 130)}}, {{"Java2D  -  text on gradient", "1000"}, {new GpE(54, blue, black, 0, 20), new GpE(53, blue, black, 21, 40), new GpE(54, blue, black, 41, 50), new GpE(129, red, yellow, 0, 50), new TxE("Java2D", this.f2, 512, null, 0, 50)}}, {{"Previous scene ellipse close out", "0"}, {new CoE(4, 0, 20)}}, {{"Color Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, java_logo, 2, 15), new Temp(7, java_logo, 16, 99), new Features(3, 16, 99)}}, {{"Java2D  -  composite and rotate text on paints", "2000"}, {new GpE(69, black, blue, 0, 20), new GpE(70, black, blue, 21, 30), new TpE(21, black, blue, 10, 31, 40), new TxE("Java2D", this.f2, 69, yellow, 0, 40)}}, {{"Previous scene subimage transform out", "0"}, {new SiE(60, 60, 0, 40)}}, {{"CREDITS  -  transform in", "1000"}, {new LnE(45, 0, 60), new TxE("CREDITS", this.f3, 73, Color.red, 20, 30), new TxE("CREDITS", this.f3, 26, Color.red, 31, 38), new TxE("CREDITS", this.f3, 25, Color.red, 39, 48), new TxE("CREDITS", this.f3, 26, Color.red, 49, 54), new TxE("CREDITS", this.f3, 25, Color.red, 55, 60)}}, {{"CREDITS  -  transform out", "0"}, {new LnE(46, 0, 45), new TxE("CREDITS", this.f3, 0, Color.red, 0, 9), new TxE("CREDITS", this.f3, 14, Color.red, 10, 30)}}, {{"Contributors", "1000"}, {new Temp(2, null, 0, 30), new Temp(4, cupanim, 4, 30), new Temp(7, cupanim, 31, 200), new Contributors(34, 200)}}};

            public Director() {
                for (int i = 0; i < this.parts.length; ++i) {
                    Vector<Object> vector = new Vector<Object>();
                    for (int j = 0; j < this.parts[i][1].length; ++j) {
                        vector.addElement(this.parts[i][1][j]);
                    }
                    this.addElement(new Scene(vector, this.parts[i][0][0], this.parts[i][0][1]));
                }
            }
        }

        static interface Part {
            public void reset(int var1, int var2);

            public void step(int var1, int var2);

            public void render(int var1, int var2, Graphics2D var3);

            public int getBegin();

            public int getEnd();
        }
    }

    static class ScenesTable
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private JTable table;
        private TableModel dataModel;

        public ScenesTable() {
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            String[] stringArray = new String[]{"", "Scenes", "Pause"};
            this.dataModel = new AbstractTableModel(this, stringArray){
                private final /* synthetic */ String[] val$names;
                private final /* synthetic */ ScenesTable this$0;
                {
                    this.this$0 = scenesTable;
                    this.val$names = stringArray;
                }

                public int getColumnCount() {
                    return this.val$names.length;
                }

                public int getRowCount() {
                    return Intro.surface.director.size();
                }

                public Object getValueAt(int n, int n2) {
                    Surface.Scene scene = (Surface.Scene)Intro.surface.director.get(n);
                    if (n2 == 0) {
                        return scene.participate;
                    }
                    if (n2 == 1) {
                        return scene.name;
                    }
                    return scene.pauseAmt;
                }

                public String getColumnName(int n) {
                    return this.val$names[n];
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public boolean isCellEditable(int n, int n2) {
                    return n2 != 1;
                }

                public void setValueAt(Object object, int n, int n2) {
                    Surface.Scene scene = (Surface.Scene)Intro.surface.director.get(n);
                    if (n2 == 0) {
                        scene.participate = object;
                    } else if (n2 == 1) {
                        scene.name = object;
                    } else {
                        scene.pauseAmt = object;
                    }
                }
            };
            this.table = new JTable(this.dataModel);
            TableColumn tableColumn = this.table.getColumn("");
            tableColumn.setWidth(16);
            tableColumn.setMinWidth(16);
            tableColumn.setMaxWidth(20);
            tableColumn = this.table.getColumn("Pause");
            tableColumn.setWidth(60);
            tableColumn.setMinWidth(60);
            tableColumn.setMaxWidth(60);
            this.table.sizeColumnsToFit(0);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.add(jScrollPane);
            JPanel jPanel = new JPanel(new BorderLayout());
            JButton jButton = new JButton("Unselect All");
            jButton.setHorizontalAlignment(2);
            Font font = new Font("serif", 0, 10);
            jButton.setFont(font);
            jButton.addActionListener(this);
            jPanel.add("West", jButton);
            JSlider jSlider = new JSlider(0, 0, 200, (int)Intro.surface.sleepAmt);
            jSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(font);
            titledBorder.setTitle("Anim delay = " + String.valueOf(Intro.surface.sleepAmt) + " ms");
            jSlider.setBorder(titledBorder);
            jSlider.setPreferredSize(new Dimension(140, 40));
            jSlider.setMinimumSize(new Dimension(100, 40));
            jSlider.setMaximumSize(new Dimension(180, 40));
            jPanel.add("East", jSlider);
            this.add("South", jPanel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            jButton.setSelected(!(jButton = (JButton)actionEvent.getSource()).isSelected());
            jButton.setText(jButton.isSelected() ? "Select All" : "Unselect All");
            for (int i = 0; i < Intro.surface.director.size(); ++i) {
                Surface.Scene scene = (Surface.Scene)Intro.surface.director.get(i);
                scene.participate = new Boolean(!jButton.isSelected());
            }
            this.table.tableChanged(new TableModelEvent(this.dataModel));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            titledBorder.setTitle("Anim delay = " + String.valueOf(n) + " ms");
            Intro.surface.sleepAmt = n;
            jSlider.repaint();
        }
    }
}

