/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.motif;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import sun.plugin.navig.motif.Plugin;

public class Worker {
    private static DataInputStream data_in;
    private static DataOutputStream data_out;
    private static Hashtable proxmap;
    private static String cookieString;
    public static final int JAVA_PLUGIN_SHOW_STATUS = 16121857;
    public static final int JAVA_PLUGIN_SHOW_DOCUMENT = 16121858;
    public static final int JAVA_PLUGIN_FIND_PROXY = 16121859;
    public static final int JAVA_PLUGIN_FIND_COOKIE = 16121860;
    public static final int JAVA_PLUGIN_JAVASCRIPT_REQUEST = 0xF60006;
    public static final int JAVA_PLUGIN_SET_COOKIE = 16121865;
    private static String requestName;
    private static final int REQUEST_IDLE = 1;
    private static final int REQUEST_IN_PROGRESS = 2;
    private static final int RESPONSE_IS_READY = 3;
    private static final int REQUEST_ABRUPTLY_TERMINATED = 4;
    private static int requestStatus;

    Worker(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        data_out = dataOutputStream;
        data_in = dataInputStream;
    }

    static synchronized void terminateRequestAbruptly() {
        Worker.terminateAbruptly();
    }

    private static synchronized void pushRequest(String string) throws IOException {
        data_out.flush();
        Plugin.trace("Worker pushRequest:" + string);
    }

    private static synchronized void writeString(String string) throws IOException {
        data_out.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            data_out.writeByte((byte)c);
        }
    }

    private static synchronized void writeByteArr(byte[] byArray) throws IOException {
        data_out.writeInt(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            data_out.writeByte(byArray[i]);
        }
    }

    public static synchronized void showDocument(int n, URL uRL, String string) {
        try {
            data_out.writeInt(16121858);
            data_out.writeShort(n);
            Worker.writeString("" + uRL);
            Worker.writeString(string);
            Worker.pushRequest("showDocument");
        }
        catch (IOException iOException) {
            Plugin.error("java process showDocument: write to parent failed\nException: " + iOException.toString());
        }
    }

    public static synchronized void showStatus(int n, String string) {
        try {
            if (!Plugin.parentAlive()) {
                return;
            }
            if (string == null) {
                string = "";
            }
            data_out.writeInt(16121857);
            data_out.writeShort(n);
            Worker.writeString(string);
            Worker.pushRequest("showstatus:" + string);
        }
        catch (IOException iOException) {
            Plugin.error("java process show status: write to parent failed\nException: " + iOException.toString());
        }
    }

    public static synchronized String getProxySettings(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol() + ":" + uRL.getHost() + ":" + uRL.getPort();
            Plugin.trace("getProxySettings. Using key:" + string2);
            String string3 = (String)proxmap.get(string2);
            if (string3 != null) {
                Plugin.trace("Retrieving cached proxy:" + string3);
                return string3;
            }
            Worker.enterRequest("Proxy");
            data_out.writeInt(16121859);
            data_out.writeShort(-1);
            Worker.writeString(string);
            Worker.writeString(uRL.getHost());
            Worker.pushRequest("FindProxy");
            Worker.waitForResponse("Proxy");
            string3 = (String)proxmap.get(string2);
            Worker.clearRequest();
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL in getProxySettings: " + string);
        }
        catch (IOException iOException) {
            System.err.println("getProxySettings: IO error on plugin");
        }
        Worker.clearRequest();
        return null;
    }

    static synchronized void addProxyMapping(String string, String string2) {
        try {
            URL uRL = new URL(string);
            String string3 = uRL.getProtocol() + ":" + uRL.getHost() + ":" + uRL.getPort();
            proxmap.put(string3, string2);
            Worker.responseIsReady("Proxy");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL in getting proxy: " + string);
        }
    }

    public static synchronized void sendJSRequest(int n, String string) {
        try {
            data_out.writeInt(0xF60006);
            data_out.writeShort((short)n);
            data_out.writeShort(0);
            Worker.writeString(string);
            Worker.pushRequest("JS Request");
        }
        catch (IOException iOException) {
            System.err.println("sendJSRequest: io error in Plugin " + iOException);
        }
    }

    public static synchronized String findCookieForURL(String string) {
        Plugin.trace("Worker.findCookieForURL: " + string);
        try {
            Worker.enterRequest("Cookie");
            cookieString = null;
            data_out.writeInt(16121860);
            data_out.writeShort(-1);
            Worker.writeString(string);
            Worker.pushRequest("FindCookie");
            Worker.waitForResponse("Cookie");
            String string2 = cookieString;
            Worker.clearRequest();
            Plugin.trace(" Got cookie string:" + string2);
            return string2;
        }
        catch (IOException iOException) {
            System.err.println("IOException in findCookieURL");
            System.err.println("Bad termination of cookie request!");
            Worker.clearRequest();
            return null;
        }
    }

    public static synchronized String setCookieForURL(String string, String string2) {
        Plugin.trace("Worker.setCookieForURL: " + string + "=" + string2);
        try {
            data_out.writeInt(16121865);
            data_out.writeShort(-1);
            Worker.writeString("" + string);
            Worker.writeString("" + string2);
            Worker.pushRequest("setCookie");
        }
        catch (IOException iOException) {
            Plugin.error("java process setCookie: write to parent failed\nException: " + iOException.toString());
        }
        return null;
    }

    static synchronized void setCookieString(String string) {
        cookieString = string;
        Worker.responseIsReady("Cookie");
    }

    static synchronized void enterRequest(String string) {
        try {
            while (requestStatus != 1) {
                (class$sun$plugin$navig$motif$Worker == null ? Worker.class$("sun.plugin.navig.motif.Worker") : class$sun$plugin$navig$motif$Worker).wait();
            }
            requestName = string;
            requestStatus = 2;
            Plugin.trace("Entering request for:" + string);
        }
        catch (InterruptedException interruptedException) {
            Plugin.trace("Request was interrupted when entering");
        }
    }

    static synchronized boolean waitForResponse(String string) {
        Plugin.trace("Waiting for response: " + string);
        try {
            while (requestStatus != 3) {
                (class$sun$plugin$navig$motif$Worker == null ? Worker.class$("sun.plugin.navig.motif.Worker") : class$sun$plugin$navig$motif$Worker).wait();
                Plugin.trace("Woke up in request for:" + string);
                if (requestStatus != 4) continue;
                Worker.clearRequest();
                return false;
            }
            Plugin.trace("Got response for request:" + string);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Plugin.trace("Request was interrupted before response");
            return false;
        }
    }

    static synchronized void responseIsReady(String string) {
        Plugin.trace("Response is ready:" + string);
        requestStatus = 3;
        Worker.class.notifyAll();
    }

    static synchronized void terminateAbruptly() {
        Plugin.trace("Request was abruptly terminated");
        if (requestStatus != 1) {
            requestStatus = 4;
        }
        Worker.class.notifyAll();
    }

    static synchronized void clearRequest() {
        Plugin.trace("Request was cleared");
        requestStatus = 1;
        Worker.class.notifyAll();
    }

    static {
        proxmap = new Hashtable();
        cookieString = null;
        requestStatus = 1;
    }
}

