/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralName;

public class GeneralSubtree {
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralSubtree)) {
            return false;
        }
        GeneralSubtree generalSubtree = (GeneralSubtree)object;
        if (this.name == null ? generalSubtree.name != null : !this.name.equals(generalSubtree.name)) {
            return false;
        }
        if (this.minimum != generalSubtree.minimum) {
            return false;
        }
        return this.maximum == generalSubtree.maximum;
    }

    public String toString() {
        String string = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        string = this.maximum == -1 ? string + "\t    Maximum: undefined" : string + "\t    Maximum: " + this.maximum;
        string = string + "    ]\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        this.name.encode(derOutputStream3);
        if (this.minimum != 0) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.minimum);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream2);
        }
        if (this.maximum != -1) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.maximum);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }

    public GeneralSubtree(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(derValue.data.getDerValue());
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.minimum = derValue2.getInteger();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.maximum = derValue2.getInteger();
                continue;
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
    }

    public GeneralName getName() {
        return this.name;
    }

    public GeneralSubtree(GeneralName generalName, int n2, int n3) {
        this.name = generalName;
        this.minimum = n2;
        this.maximum = n3;
    }
}

