/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Adjustable;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import sun.awt.DebugHelper;

public abstract class ScrollPaneWheelScroller {
    private static final DebugHelper dbg = DebugHelper.create(ScrollPaneWheelScroller.class);

    private ScrollPaneWheelScroller() {
    }

    public static void scrollAdjustable(Adjustable adjustable, int n2) {
        int n3 = adjustable.getValue();
        int n4 = adjustable.getMaximum() - adjustable.getVisibleAmount();
        if (n2 > 0 && n3 < n4) {
            if (n3 + n2 < n4) {
                adjustable.setValue(n3 + n2);
                return;
            }
            adjustable.setValue(n4);
            return;
        }
        if (n2 < 0 && n3 > adjustable.getMinimum()) {
            if (n3 + n2 > adjustable.getMinimum()) {
                adjustable.setValue(n3 + n2);
                return;
            }
            adjustable.setValue(adjustable.getMinimum());
            return;
        }
    }

    public static Adjustable getAdjustableToScroll(ScrollPane scrollPane) {
        int n2 = scrollPane.getScrollbarDisplayPolicy();
        if (n2 == 1 || n2 == 2) {
            return scrollPane.getVAdjustable();
        }
        Insets insets = scrollPane.getInsets();
        int n3 = scrollPane.getVScrollbarWidth();
        if (insets.right >= n3) {
            return scrollPane.getVAdjustable();
        }
        int n4 = scrollPane.getHScrollbarHeight();
        if (insets.bottom >= n4) {
            return scrollPane.getHAdjustable();
        }
        return null;
    }

    public static int getIncrementFromAdjustable(Adjustable adjustable, MouseWheelEvent mouseWheelEvent) {
        int n2 = 0;
        if (mouseWheelEvent.getScrollType() == 0) {
            n2 = mouseWheelEvent.getUnitsToScroll() * adjustable.getUnitIncrement();
        } else if (mouseWheelEvent.getScrollType() == 1) {
            n2 = adjustable.getBlockIncrement() * mouseWheelEvent.getWheelRotation();
        }
        return n2;
    }

    public static void handleWheelScrolling(ScrollPane scrollPane, MouseWheelEvent mouseWheelEvent) {
        Adjustable adjustable;
        int n2 = 0;
        if (scrollPane != null && mouseWheelEvent.getScrollAmount() != 0 && (adjustable = ScrollPaneWheelScroller.getAdjustableToScroll(scrollPane)) != null) {
            n2 = ScrollPaneWheelScroller.getIncrementFromAdjustable(adjustable, mouseWheelEvent);
            ScrollPaneWheelScroller.scrollAdjustable(adjustable, n2);
        }
    }
}

