/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TemplatesHandler;
import org.apache.xalan.extensions.ExpressionVisitor;
import org.apache.xalan.processor.ProcessorStylesheetElement;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.FuncDocument;
import org.apache.xalan.templates.FuncFormatNumb;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.NamespaceSupport2;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPath;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function2Args;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class StylesheetHandler
extends DefaultHandler
implements TemplatesHandler,
PrefixResolver,
NodeConsumer {
    private static boolean m_xpathFunctionsInited = false;
    private int m_stylesheetLevel = -1;
    private boolean m_parsingComplete = false;
    private Vector m_prefixMappings = new Vector();
    private boolean m_shouldProcess = true;
    private String m_fragmentIDString;
    private int m_elementID = 0;
    private int m_fragmentID = 0;
    private TransformerFactoryImpl m_stylesheetProcessor;
    static final int STYPE_ROOT = 1;
    static final int STYPE_INCLUDE = 2;
    static final int STYPE_IMPORT = 3;
    private int m_stylesheetType = 1;
    private Stack m_stylesheets = new Stack();
    StylesheetRoot m_stylesheetRoot;
    Stylesheet m_lastPoppedStylesheet;
    private Stack m_processors = new Stack();
    private XSLTSchema m_schema = new XSLTSchema();
    private Stack m_elems = new Stack();
    private int m_docOrderCount = 0;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    Stack m_baseIdentifiers = new Stack();
    private Stack m_stylesheetLocatorStack = new Stack();
    private Stack m_importStack = new Stack();
    private boolean warnedAboutOldXSLTNamespace = false;
    Stack m_nsSupportStack = new Stack();
    private Node m_originatingNode;
    private BoolStack m_spacePreserveStack = new BoolStack();

    private double getElemVersion() {
        double d2 = -1.0;
        for (ElemTemplateElement elemTemplateElement = this.getElemTemplateElement(); (d2 == -1.0 || d2 == 1.0) && elemTemplateElement != null; elemTemplateElement = elemTemplateElement.getParentElem()) {
            try {
                d2 = Double.valueOf(elemTemplateElement.getVersion());
                continue;
            }
            catch (Exception exception) {
                d2 = -1.0;
            }
        }
        return d2 == -1.0 ? 1.0 : d2;
    }

    int getStylesheetType() {
        return this.m_stylesheetType;
    }

    int nextUid() {
        return this.m_docOrderCount++;
    }

    public void endDocument() throws SAXException {
        try {
            if (null != this.getStylesheetRoot()) {
                if (0 == this.m_stylesheetLevel) {
                    this.getStylesheetRoot().recompose();
                }
            } else {
                throw new TransformerException(XSLMessages.createMessage("ER_NO_STYLESHEETROOT", null));
            }
            XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
            if (null != xSLTElementProcessor) {
                xSLTElementProcessor.startNonText(this);
            }
            --this.m_stylesheetLevel;
            this.popSpaceHandling();
            this.m_parsingComplete = this.m_stylesheetLevel < 0;
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private void flushCharacters() throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        if (null != xSLTElementProcessor) {
            xSLTElementProcessor.startNonText(this);
        }
    }

    void popNamespaceSupport() {
        this.m_nsSupportStack.pop();
    }

    void popSpaceHandling() {
        this.m_spacePreserveStack.pop();
    }

    void pushNewNamespaceSupport() {
        this.m_nsSupportStack.push(new NamespaceSupport2());
    }

    public void startDocument() throws SAXException {
        ++this.m_stylesheetLevel;
        this.pushSpaceHandling(false);
    }

    public boolean handlesNullPrefixes() {
        return false;
    }

    boolean isSpacePreserve() {
        return this.m_spacePreserveStack.peek();
    }

    public boolean isStylesheetParsingComplete() {
        return this.m_parsingComplete;
    }

    void setStylesheetType(int n2) {
        this.m_stylesheetType = n2;
    }

    void pushSpaceHandling(boolean bl2) throws SAXParseException {
        this.m_spacePreserveStack.push(bl2);
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        if (xSLTElementDef.getType() != 2) {
            xSLTElementProcessor = xSLTElementDef.getProcessorFor(null, "text()");
        }
        if (null == xSLTElementProcessor) {
            if (!XMLCharacterRecognizer.isWhiteSpace(cArray, n2, n3)) {
                this.error(XSLMessages.createMessage("ER_NONWHITESPACE_NOT_ALLOWED_IN_POSITION", null), null);
            }
        } else {
            xSLTElementProcessor.characters(this, cArray, n2, n3);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().ignorableWhitespace(this, cArray, n2, n3);
    }

    public String getBaseIdentifier() {
        String string = (String)(this.m_baseIdentifiers.isEmpty() ? null : this.m_baseIdentifiers.peek());
        if (null == string) {
            SAXSourceLocator sAXSourceLocator = this.getLocator();
            string = null == sAXSourceLocator ? "" : sAXSourceLocator.getSystemId();
        }
        return string;
    }

    public String getSystemId() {
        return this.getBaseIdentifier();
    }

    String popBaseIndentifier() {
        return (String)this.m_baseIdentifiers.pop();
    }

    String popImportURL() {
        return (String)this.m_importStack.pop();
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    void pushBaseIndentifier(String string) {
        if (null != string) {
            int n2 = string.indexOf(35);
            if (n2 > -1) {
                this.m_fragmentIDString = string.substring(n2 + 1);
                this.m_shouldProcess = false;
            } else {
                this.m_shouldProcess = true;
            }
        } else {
            this.m_shouldProcess = true;
        }
        this.m_baseIdentifiers.push(string);
    }

    void pushImportURL(String string) {
        this.m_importStack.push(string);
    }

    public void setSystemId(String string) {
        this.pushBaseIndentifier(string);
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().skippedEntity(this, string);
    }

    boolean importStackContains(String string) {
        return this.stackContains(this.m_importStack, string);
    }

    private void assertion(boolean bl2, String string) throws RuntimeException {
        if (!bl2) {
            throw new RuntimeException(string);
        }
    }

    public Templates getTemplates() {
        return this.getStylesheetRoot();
    }

    TransformerFactoryImpl getStylesheetProcessor() {
        return this.m_stylesheetProcessor;
    }

    public StylesheetHandler(TransformerFactoryImpl transformerFactoryImpl) throws TransformerConfigurationException {
        this.init(transformerFactoryImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(TransformerFactoryImpl transformerFactoryImpl) {
        if (!m_xpathFunctionsInited) {
            StylesheetHandler stylesheetHandler = this;
            synchronized (stylesheetHandler) {
                if (!m_xpathFunctionsInited) {
                    m_xpathFunctionsInited = true;
                    Function2Args function2Args = new FuncDocument();
                    FunctionTable.installFunction("document", function2Args);
                    function2Args = new FuncFormatNumb();
                    FunctionTable.installFunction("format-number", function2Args);
                }
            }
        }
        this.m_stylesheetProcessor = transformerFactoryImpl;
        this.m_processors.push(this.m_schema.getElementProcessor());
        this.pushNewNamespaceSupport();
    }

    XSLTElementProcessor getCurrentProcessor() {
        return (XSLTElementProcessor)this.m_processors.peek();
    }

    XSLTElementProcessor popProcessor() {
        return (XSLTElementProcessor)this.m_processors.pop();
    }

    void pushProcessor(XSLTElementProcessor xSLTElementProcessor) {
        this.m_processors.push(xSLTElementProcessor);
    }

    XSLTSchema getSchema() {
        return this.m_schema;
    }

    XSLMessages getXSLMessages() {
        return m_XSLMessages;
    }

    ElemTemplateElement getElemTemplateElement() {
        try {
            return (ElemTemplateElement)this.m_elems.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    ElemTemplateElement popElemTemplateElement() {
        return (ElemTemplateElement)this.m_elems.pop();
    }

    void pushElemTemplateElement(ElemTemplateElement elemTemplateElement) {
        if (elemTemplateElement.getUid() == -1) {
            elemTemplateElement.setUid(this.nextUid());
        }
        this.m_elems.push(elemTemplateElement);
    }

    Stylesheet getLastPoppedStylesheet() {
        return this.m_lastPoppedStylesheet;
    }

    Stylesheet getStylesheet() {
        return this.m_stylesheets.size() == 0 ? null : (Stylesheet)this.m_stylesheets.peek();
    }

    Stylesheet popStylesheet() {
        if (!this.m_stylesheetLocatorStack.isEmpty()) {
            this.m_stylesheetLocatorStack.pop();
        }
        if (!this.m_stylesheets.isEmpty()) {
            this.m_lastPoppedStylesheet = (Stylesheet)this.m_stylesheets.pop();
        }
        return this.m_lastPoppedStylesheet;
    }

    public void pushStylesheet(Stylesheet stylesheet) {
        if (this.m_stylesheets.size() == 0) {
            this.m_stylesheetRoot = (StylesheetRoot)stylesheet;
        }
        this.m_stylesheets.push(stylesheet);
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_stylesheetRoot;
    }

    public SAXSourceLocator getLocator() {
        if (this.m_stylesheetLocatorStack.isEmpty()) {
            SAXSourceLocator sAXSourceLocator = new SAXSourceLocator();
            sAXSourceLocator.setSystemId(this.getStylesheetProcessor().getDOMsystemID());
            return sAXSourceLocator;
        }
        return (SAXSourceLocator)this.m_stylesheetLocatorStack.peek();
    }

    public Node getOriginatingNode() {
        return this.m_originatingNode;
    }

    public void setOriginatingNode(Node node) {
        this.m_originatingNode = node;
    }

    private void checkForFragmentID(Attributes attributes) {
        if (!this.m_shouldProcess && null != attributes && null != this.m_fragmentIDString) {
            int n2 = attributes.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                String string2 = attributes.getQName(i2);
                if (!string2.equals("id") || !(string = attributes.getValue(i2)).equalsIgnoreCase(this.m_fragmentIDString)) continue;
                this.m_shouldProcess = true;
                this.m_fragmentID = this.m_elementID;
            }
        }
    }

    void pushSpaceHandling(Attributes attributes) throws SAXParseException {
        String string = attributes.getValue("xml:space");
        if (null == string) {
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peekOrFalse());
        } else if (string.equals("preserve")) {
            this.m_spacePreserveStack.push(true);
        } else if (string.equals("default")) {
            this.m_spacePreserveStack.push(false);
        } else {
            SAXSourceLocator sAXSourceLocator = this.getLocator();
            ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
            try {
                errorListener.error(new TransformerException(XSLMessages.createMessage("ER_ILLEGAL_XMLSPACE_VALUE", null), sAXSourceLocator));
            }
            catch (TransformerException transformerException) {
                throw new SAXParseException(transformerException.getMessage(), sAXSourceLocator, transformerException);
            }
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peek());
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.m_stylesheetLocatorStack.push(new SAXSourceLocator(locator));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.error(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.fatalError(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            errorListener.warning(new TransformerException(string, sAXSourceLocator));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    NamespaceSupport getNamespaceSupport() {
        return (NamespaceSupport)this.m_nsSupportStack.peek();
    }

    protected void error(String string, Exception exception) throws SAXException {
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        TransformerException transformerException = !(exception instanceof TransformerException) ? (null == exception ? new TransformerException(string, sAXSourceLocator) : new TransformerException(string, sAXSourceLocator, exception)) : (TransformerException)exception;
        if (null != errorListener) {
            try {
                errorListener.error(transformerException);
            }
            catch (TransformerException transformerException2) {
                throw new SAXException(transformerException2);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }

    public void warn(String string, Object[] objectArray) throws SAXException {
        String string2 = XSLMessages.createWarning(string, objectArray);
        SAXSourceLocator sAXSourceLocator = this.getLocator();
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        try {
            if (null != errorListener) {
                errorListener.warning(new TransformerException(string2, sAXSourceLocator));
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public String getNamespaceForPrefix(String string) {
        return this.getNamespaceSupport().getURI(string);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        String string3 = "";
        String string4 = "";
        String string5 = string;
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string4 = this.getNamespaceForPrefix(string3);
            string5 = string.substring(n2 + 1);
        }
        try {
            if ("xalan:doc-cache-off".equals(string) || "doc-cache-off".equals(string5) && string4.equals("org.apache.xalan.xslt.extensions.Redirect")) {
                if (!(this.m_elems.peek() instanceof ElemForEach)) {
                    throw new TransformerException("xalan:doc-cache-off not allowed here!", this.getLocator());
                }
                ElemForEach elemForEach = (ElemForEach)this.m_elems.peek();
                elemForEach.m_doc_cache_off = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flushCharacters();
        this.getCurrentProcessor().processingInstruction(this, string, string2);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.m_prefixMappings.addElement(string);
        this.m_prefixMappings.addElement(string2);
    }

    private boolean stackContains(Stack stack, String string) {
        int n2 = stack.size();
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = (String)stack.elementAt(i2);
            if (!string2.equals(string)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    protected void error(String string, Object[] objectArray, Exception exception) throws SAXException {
        String string2 = XSLMessages.createMessage(string, objectArray);
        this.error(string2, exception);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.m_elementID;
        if (!this.m_shouldProcess) {
            return;
        }
        if (this.m_elementID + 1 == this.m_fragmentID) {
            this.m_shouldProcess = false;
        }
        this.flushCharacters();
        this.popSpaceHandling();
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        xSLTElementProcessor.endElement(this, string, string2, string3);
        this.popProcessor();
        this.getNamespaceSupport().popContext();
    }

    public void notationDecl(String string, String string2, String string3) {
        this.getCurrentProcessor().notationDecl(this, string, string2, string3);
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.assertion(true, "can't process a context node in StylesheetHandler!");
        return null;
    }

    XPath createMatchPatternXPath(String string, ElemTemplateElement elemTemplateElement) throws TransformerException {
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        XPath xPath = new XPath(string, elemTemplateElement, this, 1, errorListener);
        xPath.callVisitors(xPath, new ExpressionVisitor(this.getStylesheetRoot()));
        return xPath;
    }

    public XPath createXPath(String string, ElemTemplateElement elemTemplateElement) throws TransformerException {
        ErrorListener errorListener = this.m_stylesheetProcessor.getErrorListener();
        XPath xPath = new XPath(string, elemTemplateElement, this, 0, errorListener);
        xPath.callVisitors(xPath, new ExpressionVisitor(this.getStylesheetRoot()));
        return xPath;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return this.getCurrentProcessor().resolveEntity(this, string, string2);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this.getCurrentProcessor().unparsedEntityDecl(this, string, string2, string3, string4);
    }

    XSLTElementProcessor getProcessorFor(String string, String string2, String string3) throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        XSLTElementProcessor xSLTElementProcessor2 = xSLTElementDef.getProcessorFor(string, string2);
        if (null == xSLTElementProcessor2 && (null == this.getStylesheet() || Double.valueOf(this.getStylesheet().getVersion()) > 1.0 || !string.equals("http://www.w3.org/1999/XSL/Transform") && xSLTElementProcessor instanceof ProcessorStylesheetElement || this.getElemVersion() > 1.0)) {
            xSLTElementProcessor2 = xSLTElementDef.getProcessorForUnknown(string, string2);
        }
        if (null == xSLTElementProcessor2) {
            this.error(XSLMessages.createMessage("ER_NOT_ALLOWED_IN_POSITION", new Object[]{string3}), null);
        }
        return xSLTElementProcessor2;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        NamespaceSupport namespaceSupport = this.getNamespaceSupport();
        namespaceSupport.pushContext();
        int n2 = this.m_prefixMappings.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = (String)this.m_prefixMappings.elementAt(i2++);
            String string5 = (String)this.m_prefixMappings.elementAt(i2);
            namespaceSupport.declarePrefix(string4, string5);
        }
        this.m_prefixMappings.removeAllElements();
        ++this.m_elementID;
        this.checkForFragmentID(attributes);
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.pushSpaceHandling(attributes);
        XSLTElementProcessor xSLTElementProcessor = this.getProcessorFor(string, string2, string3);
        if (null != xSLTElementProcessor) {
            this.pushProcessor(xSLTElementProcessor);
            xSLTElementProcessor.startElement(this, string, string2, string3, attributes);
        } else {
            this.m_shouldProcess = false;
            this.popSpaceHandling();
        }
    }
}

