/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public DefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    public void revalidate() {
    }

    public void validate() {
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void paint(Graphics graphics) {
        Object object;
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n2 = -1;
        if (color != null) {
            object = this.getIcon();
            n2 = this.getLabelStart();
            graphics.setColor(color);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1 - n2, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n2 = 0;
            } else if (n2 == -1) {
                n2 = this.getLabelStart();
            }
            object = this.getBorderSelectionColor();
            if (object != null) {
                graphics.setColor((Color)object);
                if (this.getComponentOrientation().isLeftToRight()) {
                    graphics.drawRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
                } else {
                    graphics.drawRect(0, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
                }
            }
        }
        super.paint(graphics);
    }

    public void repaint(Rectangle rectangle) {
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c2, char c3) {
    }

    public void firePropertyChange(String string, double d2, double d3) {
    }

    public void firePropertyChange(String string, float f2, float f3) {
    }

    public void firePropertyChange(String string, int n2, int n3) {
    }

    public void firePropertyChange(String string, long l2, long l3) {
    }

    public void firePropertyChange(String string, short s2, short s3) {
    }

    public void firePropertyChange(String string, boolean bl2, boolean bl3) {
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        String string = jTree.convertValueToText(object, bl2, bl3, bl4, n2, bl5);
        this.tree = jTree;
        this.hasFocus = bl5;
        this.setText(string);
        if (bl2) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl4) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl3) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl4) {
                this.setIcon(this.getLeafIcon());
            } else if (bl3) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl2;
        return this;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }
}

