/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    int axis;
    List stats = new ArrayList();
    float majorSpan;
    boolean estimatedMajorSpan;
    float minorSpan;
    protected ChildLocator locator;
    float topInset;
    float bottomInset;
    float leftInset;
    float rightInset;
    ChildState minRequest;
    ChildState prefRequest;
    boolean majorChanged;
    boolean minorChanged;
    Runnable flushTask;
    ChildState changing;

    public float getBottomInset() {
        return this.bottomInset;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public int getMajorAxis() {
        return this.axis;
    }

    public int getMinorAxis() {
        return this.axis == 0 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewCount() {
        List list = this.stats;
        synchronized (list) {
            return this.stats.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRequirementChanges() {
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        try {
            abstractDocument.readLock();
            View view = null;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object = this;
            synchronized (object) {
                List list = this.stats;
                synchronized (list) {
                    int n2 = this.getViewCount();
                    if (n2 > 0 && (this.minorChanged || this.estimatedMajorSpan)) {
                        LayoutQueue layoutQueue = this.getLayoutQueue();
                        ChildState childState = this.getChildState(0);
                        ChildState childState2 = this.getChildState(0);
                        float f2 = 0.0f;
                        for (int i2 = 1; i2 < n2; ++i2) {
                            ChildState childState3 = this.getChildState(i2);
                            if (this.minorChanged) {
                                if (childState3.min > childState.min) {
                                    childState = childState3;
                                }
                                if (childState3.pref > childState2.pref) {
                                    childState2 = childState3;
                                }
                            }
                            if (!this.estimatedMajorSpan) continue;
                            f2 += childState3.getMajorSpan();
                        }
                        if (this.minorChanged) {
                            this.minRequest = childState;
                            this.prefRequest = childState2;
                        }
                        if (this.estimatedMajorSpan) {
                            this.majorSpan = f2;
                            this.estimatedMajorSpan = false;
                            this.majorChanged = true;
                        }
                    }
                }
                if (this.majorChanged || this.minorChanged) {
                    view = this.getParent();
                    if (view != null) {
                        if (this.axis == 0) {
                            bl2 = this.majorChanged;
                            bl3 = this.minorChanged;
                        } else {
                            bl3 = this.majorChanged;
                            bl2 = this.minorChanged;
                        }
                    }
                    this.majorChanged = false;
                    this.minorChanged = false;
                }
            }
            if (view != null) {
                view.preferenceChanged(this, bl2, bl3);
                object = this.getContainer();
                if (object != null) {
                    ((Component)object).repaint();
                }
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    public void setBottomInset(float f2) {
        this.bottomInset = f2;
    }

    public void setLeftInset(float f2) {
        this.leftInset = f2;
    }

    public void setRightInset(float f2) {
        this.rightInset = f2;
    }

    public void setTopInset(float f2) {
        this.topInset = f2;
    }

    public void setSize(float f2, float f3) {
        this.setSpanOnAxis(0, f2);
        this.setSpanOnAxis(1, f3);
    }

    protected float getInsetSpan(int n2) {
        float f2 = n2 == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
        return f2;
    }

    public float getMaximumSpan(int n2) {
        if (n2 == this.axis) {
            return this.getPreferredSpan(n2);
        }
        return 32767.0f;
    }

    public float getMinimumSpan(int n2) {
        if (n2 == this.axis) {
            return this.getPreferredSpan(n2);
        }
        if (this.minRequest != null) {
            View view = this.minRequest.getChildView();
            return view.getMinimumSpan(n2);
        }
        if (n2 == 0) {
            return this.getLeftInset() + this.getRightInset() + 5.0f;
        }
        return this.getTopInset() + this.getBottomInset() + 5.0f;
    }

    public float getPreferredSpan(int n2) {
        float f2 = this.getInsetSpan(n2);
        if (n2 == this.axis) {
            return this.majorSpan + f2;
        }
        if (this.prefRequest != null) {
            View view = this.prefRequest.getChildView();
            return view.getPreferredSpan(n2) + f2;
        }
        return f2 + 30.0f;
    }

    float getSpanOnAxis(int n2) {
        if (n2 == this.getMajorAxis()) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    void setSpanOnAxis(int n2, float f2) {
        float f3 = this.getInsetSpan(n2);
        if (n2 == this.getMinorAxis()) {
            float f4 = f2 - f3;
            if (f4 != this.minorSpan) {
                this.minorSpan = f4;
                int n3 = this.getViewCount();
                if (n3 != 0) {
                    LayoutQueue layoutQueue = this.getLayoutQueue();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        ChildState childState = this.getChildState(i2);
                        childState.childSizeValid = false;
                        layoutQueue.addTask(childState);
                    }
                    layoutQueue.addTask(this.flushTask);
                }
            }
        } else if (this.estimatedMajorSpan) {
            this.majorSpan = f2 - f3;
        }
    }

    protected void setEstimatedMajorSpan(boolean bl2) {
        this.estimatedMajorSpan = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildState getChildState(int n2) {
        List list = this.stats;
        synchronized (list) {
            if (n2 >= 0 && n2 < this.stats.size()) {
                return (ChildState)this.stats.get(n2);
            }
            return null;
        }
    }

    protected synchronized void minorRequirementChange(ChildState childState) {
        this.minorChanged = true;
    }

    protected synchronized void majorRequirementChange(ChildState childState, float f2) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += f2;
        }
        this.majorChanged = true;
    }

    public AsyncBoxView(Element element, int n2) {
        super(element);
        this.axis = n2;
        this.locator = new ChildLocator();
        this.flushTask = new FlushTask();
        this.minorSpan = 32767.0f;
        this.estimatedMajorSpan = false;
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    public int getViewIndex(int n2, Position.Bias bias) {
        return this.getViewIndexAtPosition(n2, bias);
    }

    protected synchronized int getViewIndexAtPosition(int n2, Position.Bias bias) {
        boolean bl2 = bias == Position.Bias.Backward;
        n2 = bl2 ? Math.max(0, n2 - 1) : n2;
        Element element = this.getElement();
        return element.getElementIndex(n2);
    }

    public View getView(int n2) {
        ChildState childState = this.getChildState(n2);
        if (childState != null) {
            return childState.getChildView();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n2, int n3, View[] viewArray) {
        List list = this.stats;
        synchronized (list) {
            for (int i2 = 0; i2 < n3; ++i2) {
                ChildState childState = (ChildState)this.stats.remove(n2);
                float f2 = childState.getMajorSpan();
                childState.getChildView().setParent(null);
                if (f2 == 0.0f) continue;
                this.majorRequirementChange(childState, -f2);
            }
            LayoutQueue layoutQueue = this.getLayoutQueue();
            if (viewArray != null) {
                for (int i3 = 0; i3 < viewArray.length; ++i3) {
                    ChildState childState = this.createChildState(viewArray[i3]);
                    this.stats.add(n2 + i3, childState);
                    layoutQueue.addTask(childState);
                }
            }
            layoutQueue.addTask(this.flushTask);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.getViewCount() == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public synchronized void preferenceChanged(View view, boolean bl2, boolean bl3) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl2, bl3);
        } else {
            View view2;
            if (this.changing != null && (view2 = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(bl2, bl3);
                return;
            }
            int n2 = this.getViewIndex(view.getStartOffset(), Position.Bias.Forward);
            ChildState childState = this.getChildState(n2);
            childState.preferenceChanged(bl2, bl3);
            LayoutQueue layoutQueue = this.getLayoutQueue();
            layoutQueue.addTask(childState);
            layoutQueue.addTask(this.flushTask);
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n2 = element.getElementCount();
        if (n2 > 0) {
            View[] viewArray = new View[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                viewArray[i2] = viewFactory.create(element.getElement(i2));
            }
            this.replace(0, 0, viewArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, Shape shape) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(shape);
            this.locator.paintChildren(graphics);
        }
    }

    public Shape getChildAllocation(int n2, Shape shape) {
        Shape shape2 = this.locator.getChildAllocation(n2, shape);
        return shape2;
    }

    protected ChildState createChildState(View view) {
        return new ChildState(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        int n2;
        Shape shape2;
        int n3;
        Object object = this.locator;
        synchronized (object) {
            n3 = this.locator.getViewIndexAtPoint(f2, f3, shape);
            shape2 = this.locator.getChildAllocation(n3, shape);
        }
        Object object2 = object = this.getChildState(n3);
        synchronized (object2) {
            View view = ((ChildState)object).getChildView();
            n2 = view.viewToModel(f2, f3, shape2, biasArray);
        }
        return n2;
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null) {
            int n2 = Math.max(elementChange.getIndex() - 1, 0);
            ChildState childState = this.getChildState(n2);
            this.locator.childChanged(childState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        ChildState childState;
        int n3 = this.getViewIndex(n2, bias);
        Shape shape2 = this.locator.getChildAllocation(n3, shape);
        ChildState childState2 = childState = this.getChildState(n3);
        synchronized (childState2) {
            View view = childState.getChildView();
            Shape shape3 = view.modelToView(n2, shape2, bias);
            return shape3;
        }
    }

    public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n2, bias, shape, n3, biasArray);
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        protected int getViewIndexAtVisualOffset(float f2) {
            int n2 = AsyncBoxView.this.getViewCount();
            if (n2 > 0) {
                boolean bl2;
                boolean bl3 = bl2 = this.lastValidOffset != null;
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (f2 > AsyncBoxView.this.majorSpan) {
                    if (!bl2) {
                        return 0;
                    }
                    int n3 = this.lastValidOffset.getChildView().getStartOffset();
                    int n4 = AsyncBoxView.this.getViewIndex(n3, Position.Bias.Forward);
                    return n4;
                }
                if (f2 > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(f2);
                }
                float f3 = 0.0f;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ChildState childState = AsyncBoxView.this.getChildState(i2);
                    float f4 = f3 + childState.getMajorSpan();
                    if (f2 < f4) {
                        return i2;
                    }
                    f3 = f4;
                }
            }
            return n2 - 1;
        }

        int updateChildOffsets(float f2) {
            float f3;
            int n2 = AsyncBoxView.this.getViewCount();
            int n3 = n2 - 1;
            int n4 = this.lastValidOffset.getChildView().getStartOffset();
            int n5 = AsyncBoxView.this.getViewIndex(n4, Position.Bias.Forward);
            float f4 = f3 = this.lastValidOffset.getMajorOffset();
            for (int i2 = n5; i2 < n2; ++i2) {
                ChildState childState = AsyncBoxView.this.getChildState(i2);
                childState.setMajorOffset(f4);
                f4 += childState.getMajorSpan();
                if (!(f2 < f4)) continue;
                n3 = i2;
                this.lastValidOffset = childState;
                break;
            }
            return n3;
        }

        void updateChildOffsetsToIndex(int n2) {
            int n3 = this.lastValidOffset.getChildView().getStartOffset();
            int n4 = AsyncBoxView.this.getViewIndex(n3, Position.Bias.Forward);
            float f2 = this.lastValidOffset.getMajorOffset();
            for (int i2 = n4; i2 <= n2; ++i2) {
                ChildState childState = AsyncBoxView.this.getChildState(i2);
                childState.setMajorOffset(f2);
                f2 += childState.getMajorSpan();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintChildren(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            float f2 = AsyncBoxView.this.axis == 0 ? (float)(rectangle.x - this.lastAlloc.x) : (float)(rectangle.y - this.lastAlloc.y);
            int n2 = this.getViewIndexAtVisualOffset(f2);
            int n3 = AsyncBoxView.this.getViewCount();
            float f3 = AsyncBoxView.this.getChildState(n2).getMajorOffset();
            for (int i2 = n2; i2 < n3; ++i2) {
                ChildState childState = AsyncBoxView.this.getChildState(i2);
                childState.setMajorOffset(f3);
                Shape shape = this.getChildAllocation(i2);
                if (!this.intersectsClip(shape, rectangle)) break;
                ChildState childState2 = childState;
                synchronized (childState2) {
                    View view = childState.getChildView();
                    view.paint(graphics, shape);
                }
                f3 += childState.getMajorSpan();
            }
        }

        public int getViewIndexAtPoint(float f2, float f3, Shape shape) {
            this.setAllocation(shape);
            float f4 = AsyncBoxView.this.axis == 0 ? f2 - (float)this.lastAlloc.x : f3 - (float)this.lastAlloc.y;
            int n2 = this.getViewIndexAtVisualOffset(f4);
            return n2;
        }

        protected Shape getChildAllocation(int n2) {
            ChildState childState = AsyncBoxView.this.getChildState(n2);
            if (!childState.isLayoutValid()) {
                childState.run();
            }
            if (AsyncBoxView.this.axis == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMinorOffset();
                this.childAlloc.width = (int)childState.getMajorSpan();
                this.childAlloc.height = (int)childState.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMinorOffset();
                this.childAlloc.height = (int)childState.getMajorSpan();
                this.childAlloc.width = (int)childState.getMinorSpan();
            }
            this.childAlloc.x += (int)AsyncBoxView.this.getLeftInset();
            this.childAlloc.y += (int)AsyncBoxView.this.getRightInset();
            return this.childAlloc;
        }

        protected void setAllocation(Shape shape) {
            if (shape instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)shape);
            } else {
                this.lastAlloc.setBounds(shape.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        public synchronized void childChanged(ChildState childState) {
            if (this.lastValidOffset == null) {
                this.lastValidOffset = childState;
            } else if (childState.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = childState;
            }
        }

        boolean intersectsClip(Shape shape, Rectangle rectangle) {
            Rectangle rectangle2;
            Rectangle rectangle3 = rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (rectangle2.intersects(rectangle)) {
                return this.lastAlloc.intersects(rectangle2);
            }
            return false;
        }

        public synchronized Shape getChildAllocation(int n2, Shape shape) {
            if (shape == null) {
                return null;
            }
            this.setAllocation(shape);
            ChildState childState = AsyncBoxView.this.getChildState(n2);
            if (this.lastValidOffset == null) {
                this.lastValidOffset = AsyncBoxView.this.getChildState(0);
            }
            if (childState.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(n2);
            }
            Shape shape2 = this.getChildAllocation(n2);
            return shape2;
        }
    }

    public class ChildState
    implements Runnable {
        private float min;
        private float pref;
        private float max;
        private float align;
        private boolean minorValid;
        private float span;
        private float offset;
        private boolean majorValid;
        private View child;
        private boolean childSizeValid;

        public float getMajorOffset() {
            return this.offset;
        }

        public float getMajorSpan() {
            return this.span;
        }

        public float getMinorOffset() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                float f2 = this.child.getAlignment(AsyncBoxView.this.getMinorAxis());
                return (AsyncBoxView.this.minorSpan - this.max) * f2;
            }
            return 0.0f;
        }

        public float getMinorSpan() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                return this.max;
            }
            return Math.max(this.min, AsyncBoxView.this.minorSpan);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                AbstractDocument abstractDocument = (AbstractDocument)AsyncBoxView.this.getDocument();
                try {
                    abstractDocument.readLock();
                    if (this.minorValid && this.majorValid && this.childSizeValid) {
                        return;
                    }
                    if (this.child.getParent() != AsyncBoxView.this) break block11;
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.updateChild();
                    asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.updateChild();
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateChild() {
            float f2;
            boolean bl2 = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    int n2 = AsyncBoxView.this.getMinorAxis();
                    this.min = this.child.getMinimumSpan(n2);
                    this.pref = this.child.getPreferredSpan(n2);
                    this.max = this.child.getMaximumSpan(n2);
                    this.minorValid = true;
                    bl2 = true;
                }
            }
            if (bl2) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            boolean bl3 = false;
            float f3 = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    f2 = this.span;
                    this.span = this.child.getPreferredSpan(AsyncBoxView.this.axis);
                    f3 = this.span - f2;
                    this.majorValid = true;
                    bl3 = true;
                }
            }
            if (bl3) {
                AsyncBoxView.this.majorRequirementChange(this, f3);
                AsyncBoxView.this.locator.childChanged(this);
            }
            childState2 = this;
            synchronized (childState2) {
                if (!this.childSizeValid) {
                    float f4;
                    if (AsyncBoxView.this.axis == 0) {
                        f2 = this.span;
                        f4 = this.getMinorSpan();
                    } else {
                        f2 = this.getMinorSpan();
                        f4 = this.span;
                    }
                    this.childSizeValid = true;
                    this.child.setSize(f2, f4);
                }
            }
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }

        public void setMajorOffset(float f2) {
            this.offset = f2;
        }

        public void preferenceChanged(boolean bl2, boolean bl3) {
            if (AsyncBoxView.this.axis == 0) {
                if (bl2) {
                    this.majorValid = false;
                }
                if (bl3) {
                    this.minorValid = false;
                }
            } else {
                if (bl2) {
                    this.minorValid = false;
                }
                if (bl3) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }

        public View getChildView() {
            return this.child;
        }

        public ChildState(View view) {
            this.child = view;
            this.minorValid = false;
            this.majorValid = false;
            this.childSizeValid = false;
            this.child.setParent(AsyncBoxView.this);
        }
    }

    class FlushTask
    implements Runnable {
        public void run() {
            AsyncBoxView.this.flushRequirementChanges();
        }

        FlushTask() {
        }
    }
}

