/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class FloatControl
extends Control {
    private float minimum;
    private float maximum;
    private float precision;
    private int updatePeriod;
    private final String units;
    private final String minLabel;
    private final String maxLabel;
    private final String midLabel;
    private float value;

    public float getMaximum() {
        return this.maximum;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getPrecision() {
        return this.precision;
    }

    public float getValue() {
        return this.value;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setValue(float f2) {
        if (f2 > this.maximum) {
            throw new IllegalArgumentException("Requested value " + f2 + " exceeds allowable maximum value " + this.maximum + ".");
        }
        if (f2 < this.minimum) {
            throw new IllegalArgumentException("Requested value " + f2 + " smaller than allowable minimum value " + this.minimum + ".");
        }
        this.value = f2;
    }

    public void shift(float f2, float f3, int n2) {
        this.setValue(f3);
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public String getUnits() {
        return this.units;
    }

    public String toString() {
        return new String(this.getType() + " with current value: " + this.getValue() + " " + this.units + " (range: " + this.minimum + " - " + this.maximum + ")");
    }

    protected FloatControl(Type type, float f2, float f3, float f4, int n2, float f5, String string) {
        this(type, f2, f3, f4, n2, f5, string, "", "", "");
    }

    protected FloatControl(Type type, float f2, float f3, float f4, int n2, float f5, String string, String string2, String string3, String string4) {
        super(type);
        this.minimum = f2;
        this.maximum = f3;
        this.precision = f4;
        this.updatePeriod = n2;
        this.value = f5;
        this.units = string;
        this.minLabel = string2 == null ? "" : string2;
        this.midLabel = string3 == null ? "" : string3;
        this.maxLabel = string4 == null ? "" : string4;
    }

    public static class Type
    extends Control.Type {
        public static final Type MASTER_GAIN = new Type("Master Gain");
        public static final Type AUX_SEND = new Type("AUX Send");
        public static final Type AUX_RETURN = new Type("AUX Return");
        public static final Type REVERB_SEND = new Type("Reverb Send");
        public static final Type REVERB_RETURN = new Type("Reverb Return");
        public static final Type VOLUME = new Type("Volume");
        public static final Type PAN = new Type("Pan");
        public static final Type BALANCE = new Type("Balance");
        public static final Type SAMPLE_RATE = new Type("Sample Rate");

        protected Type(String string) {
            super(string);
        }
    }
}

