/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static Configuration configuration;
    private static ClassLoader contextClassLoader;

    static {
        contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected Configuration() {
    }

    public abstract void refresh();

    public static synchronized Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        if (configuration == null) {
            String string = null;
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("login.configuration.provider");
                }
            });
            if (string == null) {
                string = "com.sun.security.auth.login.ConfigFile";
            }
            try {
                final String string2 = string;
                configuration = (Configuration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        return Class.forName(string2, true, contextClassLoader).newInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof InstantiationException) {
                    throw (SecurityException)new SecurityException("Configuration error:" + exception.getCause().getMessage() + "\n").initCause(exception.getCause());
                }
                throw (SecurityException)new SecurityException("Configuration error: " + exception.toString() + "\n").initCause(exception);
            }
        }
        return configuration;
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.configuration = configuration;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);
}

