/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.security.action.LoadLibraryAction;

public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private Vector inflaters = new Vector();

    public int size() {
        this.ensureOpen(this.jzfile);
        return this.total;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        ZipFile.initIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            if (this.jzfile != 0L) {
                long l2 = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(l2);
                Vector vector = this.inflaters;
                synchronized (vector) {
                    int n2 = this.inflaters.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Inflater inflater = (Inflater)this.inflaters.get(i2);
                        inflater.end();
                    }
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void initIDs();

    private static native int getCSize(long var0);

    private static native int getMethod(long var0);

    private static native int getSize(long var0);

    private static native int getTotal(long var0);

    private static native void close(long var0);

    private void ensureOpen(long l2) {
        if (l2 == 0L) {
            throw new IllegalStateException("zip file closed");
        }
    }

    private static native long getNextEntry(long var0, int var2);

    private static native void freeEntry(long var0, long var2);

    private static native int read(long var0, long var2, int var4, byte[] var5, int var6, int var7);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n2) throws IOException {
        if ((n2 & 1) == 0 || (n2 & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n2));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n2 & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        long l2 = ZipFile.open(string, n2, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(l2);
        this.jzfile = l2;
    }

    public String getName() {
        return this.name;
    }

    private static native String getZipMessage(long var0);

    private static native long getEntry(long var0, String var2);

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    private static native long open(String var0, int var1, long var2);

    public Enumeration entries() {
        this.ensureOpen(this.jzfile);
        return new Enumeration(){
            private int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    if (ZipFile.this.jzfile == 0L) {
                        throw new IllegalStateException("zip file closed");
                    }
                    ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                }
                return this.i < ZipFile.this.total;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() throws NoSuchElementException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    long l2 = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (l2 == 0L) {
                        String string = ZipFile.this.jzfile == 0L ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                        throw new InternalError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                    }
                    ZipEntry zipEntry = new ZipEntry(l2);
                    ZipFile.freeEntry(ZipFile.this.jzfile, l2);
                    return zipEntry;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n2 = this.inflaters.size();
            if (n2 > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n2 - 1);
                inflater.reset();
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inflater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l2 = 0L;
        ZipFileInputStream zipFileInputStream = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen(this.jzfile);
            l2 = ZipFile.getEntry(this.jzfile, string);
            if (l2 == 0L) {
                return null;
            }
            zipFileInputStream = new ZipFileInputStream(l2, this);
        }
        switch (ZipFile.getMethod(l2)) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, this.getInflater()){
                    private boolean isClosed;
                    private boolean eof;

                    public int available() throws IOException {
                        if (super.available() != 0) {
                            return this.in.available();
                        }
                        return 0;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }
                    {
                        this.isClosed = false;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l2 = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen(this.jzfile);
            l2 = ZipFile.getEntry(this.jzfile, string);
            if (l2 == 0L && !string.endsWith("/")) {
                l2 = ZipFile.getEntry(this.jzfile, string + "/");
            }
            if (l2 != 0L) {
                ZipEntry zipEntry = new ZipEntry(string, l2);
                ZipFile.freeEntry(this.jzfile, l2);
                return zipEntry;
            }
        }
        return null;
    }

    private class ZipFileInputStream
    extends InputStream {
        private long jzentry;
        private int pos = 0;
        private int rem;
        private int size;
        private ZipFile handle;

        public int available() {
            return this.size;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.rem = 0;
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
        }

        public long skip(long l2) {
            int n2 = l2 > (long)this.rem ? this.rem : (int)l2;
            this.pos += n2;
            this.rem -= n2;
            if (this.rem == 0) {
                this.close();
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.rem == 0) {
                return -1;
            }
            if (n3 <= 0) {
                return 0;
            }
            if (n3 > this.rem) {
                n3 = this.rem;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (ZipFile.this.jzfile == 0L) {
                    throw new ZipException("ZipFile closed.");
                }
                n3 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, byArray, n2, n3);
            }
            if (n3 > 0) {
                this.pos += n3;
                this.rem -= n3;
            }
            if (this.rem == 0) {
                this.close();
            }
            return n3;
        }

        ZipFileInputStream(long l2, ZipFile zipFile2) {
            this.rem = ZipFile.getCSize(l2);
            this.size = ZipFile.getSize(l2);
            this.handle = zipFile2;
            this.jzentry = l2;
        }
    }
}

