/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public WeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    private void expungeStaleEntries() {
        Reference reference;
        block0: while ((reference = this.queue.poll()) != null) {
            Entry entry;
            Entry entry2 = (Entry)reference;
            int n2 = entry2.hash;
            int n3 = WeakHashMap.indexFor(n2, this.table.length);
            Entry entry3 = entry = this.table[n3];
            while (entry3 != null) {
                Entry entry4 = entry3.next;
                if (entry3 == entry2) {
                    if (entry == entry2) {
                        this.table[n3] = entry4;
                    } else {
                        entry.next = entry4;
                    }
                    entry2.next = null;
                    entry2.value = null;
                    --this.size;
                    continue block0;
                }
                entry = entry3;
                entry3 = entry4;
            }
        }
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public WeakHashMap(int n2) {
        this(n2, 0.75f);
    }

    void resize(int n2) {
        Entry[] entryArray = this.getTable();
        int n3 = entryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n2];
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    public WeakHashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.table = new Entry[n3];
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public WeakHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            int n3;
            int n4 = (int)((float)n2 / this.loadFactor + 1.0f);
            if (n4 > 0x40000000) {
                n4 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n4; n3 <<= 1) {
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    public Object get(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && WeakHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    public Object remove(Object object) {
        Entry entry;
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n2 == entry2.hash && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    Entry getEntry(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object2);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (!(entry == null || entry.hash == n2 && WeakHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Entry[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n2 = HashMap.hash(object2);
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry3 = entry = entryArray[n3];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n2 == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n3] = entry4;
                } else {
                    entry.next = entry4;
                }
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return null;
    }

    private void transfer(Entry[] entryArray, Entry[] entryArray2) {
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry = entryArray[i2];
            entryArray[i2] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object object = entry.get();
                if (object == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n2 = WeakHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n2];
                    entryArray2[n2] = entry;
                }
                entry = entry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        Object object3 = WeakHashMap.maskNull(object);
        int n2 = HashMap.hash(object3);
        Entry[] entryArray = this.getTable();
        int n3 = WeakHashMap.indexFor(n2, entryArray.length);
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (n2 == entry.hash && WeakHashMap.eq(object3, entry.get())) {
                Object object4 = entry.value;
                if (object2 != object4) {
                    entry.value = object2;
                }
                return object4;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entryArray[n3] = new Entry(object3, object2, this.queue, n2, entryArray[n3]);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        private Object value;
        private final int hash;
        private Entry next;

        public int hashCode() {
            Object object = this.getKey();
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public Object getKey() {
            return WeakHashMap.unmaskNull(this.get());
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            Object object2;
            Object object3;
            Object object4;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object5 = this.getKey();
            return (object5 == (object4 = entry.getKey()) || object5 != null && object5.equals(object4)) && ((object3 = this.getValue()) == (object2 = entry.getValue()) || object3 != null && object3.equals(object2));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        Entry(Object object, Object object2, ReferenceQueue referenceQueue, int n2, Entry entry) {
            super(object, referenceQueue);
            this.value = object2;
            this.hash = n2;
            this.next = entry;
        }
    }

    private class EntryIterator
    extends HashIterator {
        public Object next() {
            return this.nextEntry();
        }

        private EntryIterator() {
        }
    }

    private class EntrySet
    extends AbstractSet {
        public int size() {
            return WeakHashMap.this.size();
        }

        public void clear() {
            WeakHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getKey();
            Entry entry2 = WeakHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return WeakHashMap.this.removeMapping(object) != null;
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        private EntrySet() {
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray(objectArray);
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        Entry entry = null;
        Entry lastReturned = null;
        int expectedModCount = WeakHashMap.access$400(WeakHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }

        public boolean hasNext() {
            Entry[] entryArray = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n2 = this.index;
                while (entry == null && n2 > 0) {
                    entry = entryArray[--n2];
                }
                this.entry = entry;
                this.index = n2;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        HashIterator() {
            this.index = WeakHashMap.this.size() != 0 ? WeakHashMap.this.table.length : 0;
        }

        protected Entry nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }
    }

    private class KeyIterator
    extends HashIterator {
        public Object next() {
            return this.nextEntry().getKey();
        }

        private KeyIterator() {
        }
    }

    private class KeySet
    extends AbstractSet {
        public int size() {
            return WeakHashMap.this.size();
        }

        public void clear() {
            WeakHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            return WeakHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            if (WeakHashMap.this.containsKey(object)) {
                WeakHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        private KeySet() {
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class ValueIterator
    extends HashIterator {
        public Object next() {
            return this.nextEntry().value;
        }

        private ValueIterator() {
        }
    }

    private class Values
    extends AbstractCollection {
        public int size() {
            return WeakHashMap.this.size();
        }

        public void clear() {
            WeakHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public boolean contains(Object object) {
            return WeakHashMap.this.containsValue(object);
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        private Values() {
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }
}

