/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public int size() {
        return this.count;
    }

    public ByteArrayOutputStream() {
        this(32);
    }

    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new byte[n2];
    }

    public synchronized void write(int n2) {
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
    }

    public synchronized void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(int n2) {
        return new String(this.buf, n2, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }
}

