/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    public int x;
    public int y;
    public int width;
    public int height;
    private static final long serialVersionUID = -4345857070255674764L;

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Rectangle.initIDs();
        }
    }

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    private static native void initIDs();

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int outcode(double d2, double d3) {
        int n2 = 0;
        if (this.width <= 0) {
            n2 |= 5;
        } else if (d2 < (double)this.x) {
            n2 |= 1;
        } else if (d2 > (double)this.x + (double)this.width) {
            n2 |= 4;
        }
        if (this.height <= 0) {
            n2 |= 0xA;
        } else if (d3 < (double)this.y) {
            n2 |= 2;
        } else if (d3 > (double)this.y + (double)this.height) {
            n2 |= 8;
        }
        return n2;
    }

    public void setRect(double d2, double d3, double d4, double d5) {
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.floor(d3);
        int n4 = (int)Math.ceil(d2 + d4);
        int n5 = (int)Math.ceil(d3 + d5);
        this.setBounds(n2, n3, n4 - n2, n5 - n3);
    }

    public Rectangle(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public void add(int n2, int n3) {
        int n4 = Math.min(this.x, n2);
        int n5 = Math.max(this.x + this.width, n2);
        int n6 = Math.min(this.y, n3);
        int n7 = Math.max(this.y + this.height, n3);
        this.x = n4;
        this.y = n6;
        this.width = n5 - n4;
        this.height = n7 - n6;
    }

    public void grow(int n2, int n3) {
        this.x -= n2;
        this.y -= n3;
        this.width += n2 * 2;
        this.height += n3 * 2;
    }

    public void move(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public void resize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setLocation(int n2, int n3) {
        this.move(n2, n3);
    }

    public void setSize(int n2, int n3) {
        this.resize(n2, n3);
    }

    public void translate(int n2, int n3) {
        this.x += n2;
        this.y += n3;
    }

    public boolean contains(int n2, int n3) {
        return this.inside(n2, n3);
    }

    public boolean inside(int n2, int n3) {
        int n4 = this.width;
        int n5 = this.height;
        if ((n4 | n5) < 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        if (n2 < n6 || n3 < n7) {
            return false;
        }
        n5 += n7;
        return !((n4 += n6) >= n6 && n4 <= n2 || n5 >= n7 && n5 <= n3);
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.reshape(n2, n3, n4, n5);
    }

    public boolean contains(int n2, int n3, int n4, int n5) {
        int n6 = this.width;
        int n7 = this.height;
        if ((n6 | n7 | n4 | n5) < 0) {
            return false;
        }
        int n8 = this.x;
        int n9 = this.y;
        if (n2 < n8 || n3 < n9) {
            return false;
        }
        n6 += n8;
        if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
            return false;
        }
        n7 += n9;
        return !((n5 += n3) <= n3 ? n7 >= n9 || n5 > n7 : n7 >= n9 && n5 > n7);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Rectangle(Point point) {
        this(point.x, point.y, 0, 0);
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(Rectangle rectangle) {
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n4 = Math.min(this.y, rectangle.y);
        int n5 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        this.x = n2;
        this.y = n4;
        this.width = n3 - n2;
        this.height = n5 - n4;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean intersects(Rectangle rectangle) {
        int n2 = this.width;
        int n3 = this.height;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n4 <= 0 || n5 <= 0 || n2 <= 0 || n3 <= 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        n5 += n9;
        n2 += n6;
        n3 += n7;
        return !((n4 += n8) >= n8 && n4 <= n6 || n5 >= n9 && n5 <= n7 || n2 >= n6 && n2 <= n8 || n3 >= n7 && n3 <= n9);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public Rectangle(Point point, Dimension dimension) {
        this(point.x, point.y, dimension.width, dimension.height);
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n2 = this.x;
        int n3 = this.y;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        long l2 = n2;
        l2 += (long)this.width;
        long l3 = n3;
        l3 += (long)this.height;
        long l4 = n4;
        l4 += (long)rectangle.width;
        long l5 = n5;
        l5 += (long)rectangle.height;
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n5) {
            n3 = n5;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        if (l3 > l5) {
            l3 = l5;
        }
        l3 -= (long)n3;
        if ((l2 -= (long)n2) < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        if (l3 < Integer.MIN_VALUE) {
            l3 = Integer.MIN_VALUE;
        }
        return new Rectangle(n2, n3, (int)l2, (int)l3);
    }

    public Rectangle union(Rectangle rectangle) {
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n4 = Math.min(this.y, rectangle.y);
        int n5 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.intersection((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.intersect(this, rectangle2D, double_);
        return double_;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.union((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.union(this, rectangle2D, double_);
        return double_;
    }
}

